/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.roadbridge.vo.DutyEquipmentVO;
import com.ejianc.business.roadbridge.vo.DutyJjfVO;
import com.ejianc.business.roadbridge.vo.DutyMaterialVO;
import com.ejianc.business.roadbridge.vo.DutyOneVO;
import com.ejianc.business.roadbridge.vo.DutyOtherVO;
import com.ejianc.business.roadbridge.vo.DutyRmatVO;
import com.ejianc.business.roadbridge.vo.DutyTwoVO;
import com.ejianc.business.roadbridge.vo.RoadbridgeDutyVO;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.handler.ConversionBaseHandler;
import com.ejianc.business.targetcost.handler.IConversioneHandler;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class RoadbridgeHandler
extends ConversionBaseHandler
implements IConversioneHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        RoadbridgeDutyVO roadbridgeDutyVO = (RoadbridgeDutyVO)baseVO;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)roadbridgeDutyVO), DutyEntity.class));
        dutyEntity.setFirstImportId(roadbridgeDutyVO.getBaseDutyId());
        dutyEntity.setImportId(roadbridgeDutyVO.getId());
        dutyEntity.setMemo(roadbridgeDutyVO.getProjectProfile());
        dutyEntity.setImportType(ConversionEnum.\u4e91\u5357\u8def\u6865.getCode());
        this.handlerHead(dutyEntity, isEff, baseVO);
        return CommonResponse.success((String)"\u5bfc\u5165\u8f6c\u6362\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        this.deleteDuty(importId);
        return CommonResponse.success((String)"\u5220\u9664\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        RoadbridgeDutyVO roadbridgeDutyVO = (RoadbridgeDutyVO)baseVO;
        ExecutorService threadPool = Executors.newFixedThreadPool(5);
        CommonResponse subjectResponse = this.shareSubjectOrgApi.shareSubjectOrgApi();
        HashMap<String, SubjectOrgVO> subjectMap = new HashMap();
        if (subjectResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)subjectResponse.getData()))) {
            subjectMap = ((List)subjectResponse.getData()).stream().collect(Collectors.toMap(SubjectOrgVO::getSubjectName, Function.identity(), (key1, key2) -> key1));
        }
        TwoChangeCallable twoCallable = new TwoChangeCallable(this.labsubApi, this.prosubApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> twoFuture = threadPool.submit(twoCallable);
        MaterialChangeCallable materialCallable = new MaterialChangeCallable(this.materialApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> materialFuture = threadPool.submit(materialCallable);
        RmatChangeCallable rmatCallable = new RmatChangeCallable(this.materialApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> rmatFuture = threadPool.submit(rmatCallable);
        EquipChangeCallable equipCallable = new EquipChangeCallable(this.equipmentApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> equipFuture = threadPool.submit(equipCallable);
        OtherChangeCallable othCallable = new OtherChangeCallable(roadbridgeDutyVO, dutyEntity, feeVO, subjectMap);
        Future<DutyEntity> othFuture = threadPool.submit(othCallable);
        ArrayList<DutyEntity> dutyList = new ArrayList<DutyEntity>();
        try {
            dutyList.add(twoFuture.get());
            dutyList.add(materialFuture.get());
            dutyList.add(rmatFuture.get());
            dutyList.add(equipFuture.get());
            dutyList.add(othFuture.get());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u8def\u6865\u5bfc\u5165\u8f6c\u6362\u5931\u8d25\uff01");
        }
        finally {
            threadPool.shutdown();
        }
        return dutyList;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        boolean jjfFlag = false;
        boolean qtgcfFlag = false;
        boolean hunFlag = false;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if ("\u95f4\u63a5\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                jjfFlag = true;
            }
            if ("\u5176\u4ed6\u5de5\u7a0b\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                qtgcfFlag = true;
            }
            if (!"100\u7ae0\u8d39\u7528".equals(detailVO.getName()) || null != detailVO.getParentId()) continue;
            hunFlag = true;
        }
        if (!jjfFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u95f4\u63a5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!qtgcfFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u5de5\u7a0b\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!hunFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010100\u7ae0\u8d39\u7528\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
    }

    class OtherChangeCallable
    implements Callable<DutyEntity> {
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;
        private Map<String, SubjectOrgVO> subjectMap;

        public OtherChangeCallable(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO, Map<String, SubjectOrgVO> subjectMap) {
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
            this.subjectMap = subjectMap;
        }

        @Override
        public DutyEntity call() {
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            this.dealJjfData(this.roadbridgeDutyVO, dutyEntity, this.feeVO);
            this.dealOtherData(this.roadbridgeDutyVO, dutyEntity, this.feeVO);
            this.dealOneData(this.roadbridgeDutyVO, dutyEntity, this.feeVO);
            return dutyEntity;
        }

        private void dealJjfData(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long jjfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u95f4\u63a5\u8d39".equals(detailVO.getName())) continue;
                jjfId = detailVO.getId();
            }
            int num = 1;
            for (DutyJjfVO jjfVO : roadbridgeDutyVO.getDutyJjfList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(jjfId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(String.valueOf(num));
                    itemEntity.setName(jjfVO.getJjfName());
                    itemEntity.setUnitName(jjfVO.getJjfUnitName());
                    if (this.subjectMap.containsKey(jjfVO.getSubjectName())) {
                        SubjectOrgVO subjectOrgVO = this.subjectMap.get(jjfVO.getSubjectName());
                        itemEntity.setSubjectId(subjectOrgVO.getId());
                        itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                        itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
                    }
                    itemEntity.setMny(jjfVO.getJjfMny());
                    itemEntity.setTaxMny(jjfVO.getJjfMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealOtherData(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long otherId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u5176\u4ed6\u5de5\u7a0b\u8d39".equals(detailVO.getName())) continue;
                otherId = detailVO.getId();
            }
            int num = 1;
            for (DutyOtherVO otherVO : roadbridgeDutyVO.getDutyOtherList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(otherId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(String.valueOf(num));
                    itemEntity.setName(otherVO.getOtherName());
                    itemEntity.setUnitName(otherVO.getOtherUnitName());
                    if (this.subjectMap.containsKey(otherVO.getSubjectName())) {
                        SubjectOrgVO subjectOrgVO = this.subjectMap.get(otherVO.getSubjectName());
                        itemEntity.setSubjectId(subjectOrgVO.getId());
                        itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                        itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
                    }
                    itemEntity.setMny(otherVO.getOtherMny());
                    itemEntity.setTaxMny(otherVO.getOtherMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealOneData(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long oneId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"100\u7ae0\u8d39\u7528".equals(detailVO.getName())) continue;
                oneId = detailVO.getId();
            }
            for (DutyOneVO oneVO : roadbridgeDutyVO.getDutyOneList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(oneId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(oneVO.getOneDetailCode());
                    itemEntity.setName(oneVO.getOneDetailName());
                    itemEntity.setUnitName(oneVO.getOneUnitName());
                    itemEntity.setMny(oneVO.getOneDutyMny());
                    itemEntity.setTaxMny(oneVO.getOneDutyMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }
    }

    class EquipChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareEquipmentApi shareEquipmentApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public EquipChangeCallable(IShareEquipmentApi shareEquipmentApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareEquipmentApi = shareEquipmentApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var4_7;
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long jxfId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238542").equals(feeDetailVO.getFeePropId())) continue;
                jxfId = feeDetailVO.getId();
            }
            if (null == jxfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u673a\u68b0\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> jxfSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(jxfId))) continue;
                jxfSet.add(feeDetailVO.getId());
            }
            Object var4_6 = null;
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) || !jxfSet.contains(detailVO.getId())) continue;
                Long l = detailVO.getId();
            }
            if (null == var4_7) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u673a\u68b0\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            CommonResponse commonResponse = this.shareEquipmentApi.queryCategoryListByIds(new ArrayList());
            HashMap<Long, String> equipCtyLongInnerMap = new HashMap<Long, String>();
            HashMap<String, String> equipCtyStringInnerMap = new HashMap<String, String>();
            for (EquipmentCategoryVO categoryVO : (List)commonResponse.getData()) {
                equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
            }
            List codeList = this.roadbridgeDutyVO.getDutyEquipmentList().stream().filter(dutyEquipmentVO -> StringUtils.isNotBlank((CharSequence)dutyEquipmentVO.getEquipmentCode())).map(DutyEquipmentVO::getEquipmentCode).collect(Collectors.toList());
            CommonResponse equipResponse = this.shareEquipmentApi.queryEquipmentListByCodes(codeList);
            RoadbridgeHandler.this.logger.error(JSONObject.toJSONString(codeList));
            RoadbridgeHandler.this.logger.error(JSONObject.toJSONString((Object)equipResponse));
            Map<Object, Object> equipMap = new HashMap();
            if (equipResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)equipResponse.getData()))) {
                equipMap = ((List)equipResponse.getData()).stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
            int num = 1;
            for (DutyEquipmentVO dutyEquipmentVO2 : this.roadbridgeDutyVO.getDutyEquipmentList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)dutyEquipmentVO2.getEquipmentCode()) && equipMap.containsKey(dutyEquipmentVO2.getEquipmentCode())) {
                        EquipmentVO equipmentVO = (EquipmentVO)equipMap.get(dutyEquipmentVO2.getEquipmentCode());
                        String innerCode = (String)equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(equipmentVO.getCode());
                        itemEntity.setName(equipmentVO.getName());
                        itemEntity.setModel(equipmentVO.getSpec());
                        itemEntity.setUnitId(equipmentVO.getUnitId());
                        itemEntity.setUnitName(equipmentVO.getUnitName());
                        itemEntity.setPrice(dutyEquipmentVO2.getEquipmentPrice());
                        itemEntity.setTaxPrice(dutyEquipmentVO2.getEquipmentPrice());
                        itemEntity.setAmount(dutyEquipmentVO2.getEquipmentNum());
                        itemEntity.setMny(dutyEquipmentVO2.getEquipmentCostMny());
                        itemEntity.setTaxMny(dutyEquipmentVO2.getEquipmentCostMny());
                        itemEntity.setRmatRentMonth(dutyEquipmentVO2.getEquipmentRentMonth());
                        itemEntity.setCategoryId(equipmentVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(equipmentVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                        itemEntity.setDocId(equipmentVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)dutyEquipmentVO2.getEquipmentCode()) && equipCtyStringInnerMap.containsKey(dutyEquipmentVO2.getEquipmentCode())) {
                        String innerCode = (String)equipCtyStringInnerMap.get(dutyEquipmentVO2.getEquipmentCode());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)dutyEquipmentVO2.getEquipmentNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)dutyEquipmentVO2.getEquipmentCostMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)dutyEquipmentVO2.getEquipmentCostMny()));
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var4_7)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)dutyEquipmentVO2.getEquipmentCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(dutyEquipmentVO2.getEquipmentCode());
                    }
                    itemEntity.setName(dutyEquipmentVO2.getEquipmentName());
                    itemEntity.setUnitName(dutyEquipmentVO2.getEquipmentUnitName());
                    itemEntity.setPrice(dutyEquipmentVO2.getEquipmentPrice());
                    itemEntity.setTaxPrice(dutyEquipmentVO2.getEquipmentPrice());
                    itemEntity.setAmount(dutyEquipmentVO2.getEquipmentNum());
                    itemEntity.setMny(dutyEquipmentVO2.getEquipmentCostMny());
                    itemEntity.setTaxMny(dutyEquipmentVO2.getEquipmentCostMny());
                    itemEntity.setRmatRentMonth(dutyEquipmentVO2.getEquipmentRentMonth());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                if (!StringUtils.isBlank((CharSequence)dutyEquipmentVO2.getEquipmentCode())) continue;
                ++num;
            }
            return dutyEntity;
        }
    }

    class RmatChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public RmatChangeCallable(IShareMaterialApi shareMaterialApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var6_9;
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            HashMap<Long, String> matCtyLongInnerMap = new HashMap<Long, String>();
            HashMap<String, String> matCtyStringInnerMap = new HashMap<String, String>();
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long zzcId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238537").equals(feeDetailVO.getFeePropId())) continue;
                zzcId = feeDetailVO.getId();
            }
            if (null == zzcId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5468\u8f6c\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> zzcSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(zzcId))) continue;
                zzcSet.add(feeDetailVO.getId());
            }
            Object var6_8 = null;
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238538").equals(detailVO.getFeePropId()) || !zzcSet.contains(detailVO.getId())) continue;
                Long l = detailVO.getId();
            }
            if (null == var6_9) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u5468\u8f6c\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            List list = this.roadbridgeDutyVO.getDutyRmatList().stream().filter(dutyRmatVO -> StringUtils.isNotBlank((CharSequence)dutyRmatVO.getRmatCode())).map(DutyRmatVO::getRmatCode).collect(Collectors.toList());
            CommonResponse matResponse = this.shareMaterialApi.queryMaterialListByCodes(list);
            Map<Object, Object> matMap = new HashMap();
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)matResponse.getData()))) {
                matMap = ((List)matResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
            int num = 1;
            for (DutyRmatVO rmatVO : this.roadbridgeDutyVO.getDutyRmatList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    MaterialVO materialVO;
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode())) {
                        CommonResponse response;
                        if (matMap.containsKey(rmatVO.getRmatCode())) {
                            materialVO = (MaterialVO)matMap.get(rmatVO.getRmatCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse response2 = this.shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = (MaterialCategoryVO)response2.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else if (!matCtyStringInnerMap.containsKey(rmatVO.getRmatCode()) && (response = this.shareMaterialApi.queryCategoryByCode(rmatVO.getRmatCode())).isSuccess() && null != response.getData()) {
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)response.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode()) && matMap.containsKey(rmatVO.getRmatCode())) {
                        materialVO = (MaterialVO)matMap.get(rmatVO.getRmatCode());
                        String innerCode = (String)matCtyLongInnerMap.get(materialVO.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zzcSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(materialVO.getCode());
                        itemEntity.setName(materialVO.getName());
                        itemEntity.setModel(materialVO.getSpec());
                        itemEntity.setUnitId(materialVO.getUnitId());
                        itemEntity.setUnitName(materialVO.getUnitName());
                        itemEntity.setPrice(rmatVO.getRmatPrice());
                        itemEntity.setTaxPrice(rmatVO.getRmatPrice());
                        itemEntity.setAmount(rmatVO.getRmatNum());
                        itemEntity.setMny(rmatVO.getRmatCostMny());
                        itemEntity.setTaxMny(rmatVO.getRmatCostMny());
                        itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                        itemEntity.setCategoryId(materialVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(materialVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                        itemEntity.setDocId(materialVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode()) && matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {
                        String innerCode = (String)matCtyStringInnerMap.get(rmatVO.getRmatCode());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zzcSet.contains(detailEntity.getFeeDetailId()))) continue;
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)rmatVO.getRmatNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)rmatVO.getRmatCostMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)rmatVO.getRmatCostMny()));
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var6_9)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)rmatVO.getRmatCode())) {
                        itemEntity.setCode(String.valueOf(num));
                        ++num;
                    } else {
                        itemEntity.setCode(rmatVO.getRmatCode());
                    }
                    itemEntity.setName(rmatVO.getRmatName());
                    itemEntity.setUnitName(rmatVO.getRmatUnitName());
                    itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                    itemEntity.setPrice(rmatVO.getRmatPrice());
                    itemEntity.setTaxPrice(rmatVO.getRmatPrice());
                    itemEntity.setAmount(rmatVO.getRmatNum());
                    itemEntity.setMny(rmatVO.getRmatCostMny());
                    itemEntity.setTaxMny(rmatVO.getRmatCostMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }

    class MaterialChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public MaterialChangeCallable(IShareMaterialApi shareMaterialApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var6_9;
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            HashMap<Long, String> matCtyLongInnerMap = new HashMap<Long, String>();
            HashMap<String, String> matCtyStringInnerMap = new HashMap<String, String>();
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long clfId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238535").equals(feeDetailVO.getFeePropId())) continue;
                clfId = feeDetailVO.getId();
            }
            if (null == clfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> clfSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(clfId))) continue;
                clfSet.add(feeDetailVO.getId());
            }
            Object var6_8 = null;
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) || !clfSet.contains(detailVO.getId())) continue;
                Long l = detailVO.getId();
            }
            if (null == var6_9) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            List list = this.roadbridgeDutyVO.getDutyMaterialList().stream().filter(materialVO -> StringUtils.isNotBlank((CharSequence)materialVO.getMaterialCode())).map(DutyMaterialVO::getMaterialCode).collect(Collectors.toList());
            CommonResponse matResponse = this.shareMaterialApi.queryMaterialListByCodes(list);
            Map<Object, Object> matMap = new HashMap();
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)matResponse.getData()))) {
                matMap = ((List)matResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
            int num = 1;
            for (DutyMaterialVO dutyMaterialVO : this.roadbridgeDutyVO.getDutyMaterialList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)dutyMaterialVO.getMaterialCode())) {
                        CommonResponse response;
                        if (matMap.containsKey(dutyMaterialVO.getMaterialCode())) {
                            MaterialVO materialVO2 = (MaterialVO)matMap.get(dutyMaterialVO.getMaterialCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO2.getCategoryId())) {
                                CommonResponse response2 = this.shareMaterialApi.queryCategoryById(materialVO2.getCategoryId());
                                MaterialCategoryVO categoryVO = (MaterialCategoryVO)response2.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else if (!matCtyStringInnerMap.containsKey(dutyMaterialVO.getMaterialCode()) && (response = this.shareMaterialApi.queryCategoryByCode(dutyMaterialVO.getMaterialCode())).isSuccess() && null != response.getData()) {
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)response.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)dutyMaterialVO.getMaterialCode()) && matMap.containsKey(dutyMaterialVO.getMaterialCode())) {
                        MaterialVO materialVO2 = (MaterialVO)matMap.get(dutyMaterialVO.getMaterialCode());
                        String innerCode = (String)matCtyLongInnerMap.get(materialVO2.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(materialVO2.getCode());
                        itemEntity.setName(materialVO2.getName());
                        itemEntity.setModel(materialVO2.getSpec());
                        itemEntity.setUnitId(materialVO2.getUnitId());
                        itemEntity.setUnitName(materialVO2.getUnitName());
                        itemEntity.setPrice(dutyMaterialVO.getMaterialPrice());
                        itemEntity.setTaxPrice(dutyMaterialVO.getMaterialPrice());
                        itemEntity.setAmount(dutyMaterialVO.getMaterialNum());
                        itemEntity.setMny(dutyMaterialVO.getMaterialMny());
                        itemEntity.setTaxMny(dutyMaterialVO.getMaterialMny());
                        itemEntity.setCategoryId(materialVO2.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(materialVO2.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                        itemEntity.setDocId(materialVO2.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)dutyMaterialVO.getMaterialCode()) && matCtyStringInnerMap.containsKey(dutyMaterialVO.getMaterialCode())) {
                        String innerCode = (String)matCtyStringInnerMap.get(dutyMaterialVO.getMaterialCode());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)dutyMaterialVO.getMaterialNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)dutyMaterialVO.getMaterialMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)dutyMaterialVO.getMaterialMny()));
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var6_9)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)dutyMaterialVO.getMaterialCode())) {
                        itemEntity.setCode(String.valueOf(num));
                        ++num;
                    } else {
                        itemEntity.setCode(dutyMaterialVO.getMaterialCode());
                    }
                    itemEntity.setName(dutyMaterialVO.getMaterialName());
                    itemEntity.setUnitName(dutyMaterialVO.getMaterialUnitName());
                    itemEntity.setPrice(dutyMaterialVO.getMaterialPrice());
                    itemEntity.setTaxPrice(dutyMaterialVO.getMaterialPrice());
                    itemEntity.setAmount(dutyMaterialVO.getMaterialNum());
                    itemEntity.setMny(dutyMaterialVO.getMaterialMny());
                    itemEntity.setTaxMny(dutyMaterialVO.getMaterialMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }

    class TwoChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareLabsubApi shareLabsubApi;
        private IShareProsubApi shareProsubApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public TwoChangeCallable(IShareLabsubApi shareLabsubApi, IShareProsubApi shareProsubApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareLabsubApi = shareLabsubApi;
            this.shareProsubApi = shareProsubApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long rgfId = null;
            Long zyfbId = null;
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238533").equals(detailVO.getFeePropId())) {
                    rgfId = detailVO.getId();
                }
                if (!Long.valueOf("546645586985238540").equals(detailVO.getFeePropId())) continue;
                zyfbId = detailVO.getId();
            }
            if (null == rgfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            if (null == zyfbId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4e13\u4e1a\u5206\u5305\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> rgfSet = new HashSet<Long>();
            HashSet<Long> zyfbSet = new HashSet<Long>();
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(rgfId))) {
                    rgfSet.add(detailVO.getId());
                }
                if (!detailVO.getInnerCode().contains(String.valueOf(zyfbId))) continue;
                zyfbSet.add(detailVO.getId());
            }
            Long qtrgfId = null;
            Long qtzyfbId = null;
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) && rgfSet.contains(detailVO.getId())) {
                    qtrgfId = detailVO.getId();
                }
                if (!Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) || !zyfbSet.contains(detailVO.getId())) continue;
                qtzyfbId = detailVO.getId();
            }
            if (null == qtrgfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            if (null == qtzyfbId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4e13\u4e1a\u5206\u5305\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            ArrayList<String> codeList = new ArrayList<String>();
            ArrayList<DutyTwoVO> addList = new ArrayList<DutyTwoVO>();
            for (DutyTwoVO twoVO : this.roadbridgeDutyVO.getDutyTwoList()) {
                DutyTwoVO dutyTwoVO;
                if (null == twoVO.getLeafFlag() || !twoVO.getLeafFlag().booleanValue()) continue;
                if (twoVO.getTwoDetailCode().startsWith("GL")) {
                    if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoJxPrice(), (BigDecimal)BigDecimal.ZERO)) {
                        if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoRgPrice(), (BigDecimal)BigDecimal.ZERO)) {
                            dutyTwoVO = (DutyTwoVO)BeanMapper.map((Object)twoVO, DutyTwoVO.class);
                            dutyTwoVO.setTwoJxPrice(null);
                            addList.add(dutyTwoVO);
                            codeList.add(dutyTwoVO.getTwoDetailCode());
                        }
                        twoVO.setTwoRgPrice(null);
                        twoVO.setTwoDetailCode(twoVO.getTwoDetailCode().replace("GL", "GJ"));
                    }
                    codeList.add(twoVO.getTwoDetailCode());
                    continue;
                }
                if (twoVO.getTwoDetailCode().startsWith("GZ")) {
                    codeList.add(twoVO.getTwoDetailCode());
                    continue;
                }
                if (null == twoVO.getTwoJxPrice() || ComputeUtil.equals((BigDecimal)twoVO.getTwoJxPrice(), (BigDecimal)BigDecimal.ZERO)) continue;
                if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoRgPrice(), (BigDecimal)BigDecimal.ZERO)) {
                    dutyTwoVO = (DutyTwoVO)BeanMapper.map((Object)twoVO, DutyTwoVO.class);
                    dutyTwoVO.setTwoJxPrice(null);
                    addList.add(dutyTwoVO);
                    codeList.add(dutyTwoVO.getTwoDetailCode());
                }
                twoVO.setTwoRgPrice(null);
                twoVO.setTwoDetailCode(twoVO.getTwoDetailCode().replace("GL", "GJ"));
            }
            if (CollectionUtils.isNotEmpty(addList)) {
                this.roadbridgeDutyVO.getDutyTwoList().addAll(addList);
            }
            CommonResponse labCtyResponse = this.shareLabsubApi.queryCategoryListByIds(new ArrayList());
            Map<Object, Object> labCtyInnerCodeMap = new HashMap();
            if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labCtyResponse.getData()))) {
                labCtyInnerCodeMap = ((List)labCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
            }
            Map<Object, Object> labSubMap = new HashMap();
            CommonResponse labItemResponse = this.shareLabsubApi.queryItemListByCodes(codeList);
            if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labItemResponse.getData()))) {
                labSubMap = ((List)labItemResponse.getData()).stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }
            CommonResponse proCtyResponse = this.shareProsubApi.queryCategoryListByIds(new ArrayList());
            Map<Object, Object> proCtyInnerCodeMap = new HashMap();
            if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proCtyResponse.getData()))) {
                proCtyInnerCodeMap = ((List)proCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
            }
            Map<Object, Object> proSubMap = new HashMap();
            CommonResponse proItemResponse = this.shareProsubApi.queryItemListByCodes(codeList);
            if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proItemResponse.getData()))) {
                proSubMap = ((List)proItemResponse.getData()).stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }
            for (DutyTwoVO twoVO : this.roadbridgeDutyVO.getDutyTwoList()) {
                if (!(null != twoVO.getLeafFlag() && twoVO.getLeafFlag() != false && (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoRgPrice(), (BigDecimal)BigDecimal.ZERO) || null != twoVO.getTwoJxPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoJxPrice(), (BigDecimal)BigDecimal.ZERO) || null != twoVO.getTwoSubPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoSubPrice(), (BigDecimal)BigDecimal.ZERO)))) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    DutyDetailItemEntity itemEntity;
                    ArrayList<DutyDetailItemEntity> itemList;
                    DutyDetailItemEntity itemEntity2;
                    ArrayList<DutyDetailItemEntity> itemList2;
                    String innerCode;
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (twoVO.getTwoDetailCode().startsWith("GL") || twoVO.getTwoDetailCode().startsWith("GJ")) {
                        if (labSubMap.containsKey(twoVO.getTwoDetailCode())) {
                            LabsubItemVO labsubItemVO = (LabsubItemVO)labSubMap.get(twoVO.getTwoDetailCode());
                            innerCode = (String)labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                            if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !rgfSet.contains(detailEntity.getFeeDetailId()))) continue;
                            itemList2 = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                            itemEntity2 = new DutyDetailItemEntity();
                            itemEntity2.setId(IdWorker.getId());
                            itemEntity2.setCode(labsubItemVO.getTrawlingCode());
                            itemEntity2.setName(labsubItemVO.getTrawlingName());
                            itemEntity2.setPriceType(labsubItemVO.getPriceType());
                            itemEntity2.setJobContent(labsubItemVO.getJobContent());
                            itemEntity2.setUnitName(labsubItemVO.getUnitName());
                            if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoRgPrice(), (BigDecimal)BigDecimal.ZERO)) {
                                itemEntity2.setPrice(twoVO.getTwoRgPrice());
                                itemEntity2.setTaxPrice(twoVO.getTwoRgPrice());
                                itemEntity2.setAmount(twoVO.getTwoNum());
                                itemEntity2.setMny(twoVO.getTwoRgMny());
                                itemEntity2.setTaxMny(twoVO.getTwoRgMny());
                                itemEntity2.setCategoryId(labsubItemVO.getCategoryId());
                                itemEntity2.setCategoryInnerCode(innerCode);
                                itemEntity2.setCategoryName(labsubItemVO.getCategoryName());
                                itemEntity2.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                                itemEntity2.setDocId(labsubItemVO.getId());
                                itemList2.add(itemEntity2);
                                detailEntity.setDutyDetailItemList(itemList2);
                                continue;
                            }
                            if (null == twoVO.getTwoJxPrice() || ComputeUtil.equals((BigDecimal)twoVO.getTwoJxPrice(), (BigDecimal)BigDecimal.ZERO)) continue;
                            itemEntity2.setPrice(twoVO.getTwoJxPrice());
                            itemEntity2.setTaxPrice(twoVO.getTwoJxPrice());
                            itemEntity2.setAmount(twoVO.getTwoNum());
                            itemEntity2.setMny(twoVO.getTwoJxMny());
                            itemEntity2.setTaxMny(twoVO.getTwoJxMny());
                            itemEntity2.setCategoryId(labsubItemVO.getCategoryId());
                            itemEntity2.setCategoryInnerCode(innerCode);
                            itemEntity2.setCategoryName(labsubItemVO.getCategoryName());
                            itemEntity2.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                            itemEntity2.setDocId(labsubItemVO.getId());
                            itemList2.add(itemEntity2);
                            detailEntity.setDutyDetailItemList(itemList2);
                            continue;
                        }
                        if (!detailEntity.getFeeDetailId().equals(qtrgfId)) continue;
                        itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList();
                        itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(twoVO.getTwoDetailCode());
                        itemEntity.setName(twoVO.getTwoDetailName());
                        itemEntity.setUnitName(twoVO.getTwoUnitName());
                        if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoRgPrice(), (BigDecimal)BigDecimal.ZERO)) {
                            itemEntity.setPrice(twoVO.getTwoRgPrice());
                            itemEntity.setTaxPrice(twoVO.getTwoRgPrice());
                            itemEntity.setAmount(twoVO.getTwoNum());
                            itemEntity.setMny(twoVO.getTwoRgMny());
                            itemEntity.setTaxMny(twoVO.getTwoRgMny());
                            itemEntity.setDocType(6);
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                            continue;
                        }
                        if (null == twoVO.getTwoJxPrice() || ComputeUtil.equals((BigDecimal)twoVO.getTwoJxPrice(), (BigDecimal)BigDecimal.ZERO)) continue;
                        itemEntity.setPrice(twoVO.getTwoJxPrice());
                        itemEntity.setTaxPrice(twoVO.getTwoJxPrice());
                        itemEntity.setAmount(twoVO.getTwoNum());
                        itemEntity.setMny(twoVO.getTwoJxMny());
                        itemEntity.setTaxMny(twoVO.getTwoJxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (twoVO.getTwoDetailCode().startsWith("GZ") && null != twoVO.getTwoSubPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoSubPrice(), (BigDecimal)BigDecimal.ZERO)) {
                        if (proSubMap.containsKey(twoVO.getTwoDetailCode())) {
                            ProsubItemVO prosubItemVO = (ProsubItemVO)proSubMap.get(twoVO.getTwoDetailCode());
                            innerCode = (String)proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                            if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !rgfSet.contains(detailEntity.getFeeDetailId()))) continue;
                            itemList2 = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList();
                            itemEntity2 = new DutyDetailItemEntity();
                            itemEntity2.setId(IdWorker.getId());
                            itemEntity2.setCode(prosubItemVO.getTrawlingCode());
                            itemEntity2.setName(prosubItemVO.getTrawlingName());
                            itemEntity2.setPriceType(prosubItemVO.getPriceType());
                            itemEntity2.setJobContent(prosubItemVO.getJobContent());
                            itemEntity2.setUnitName(prosubItemVO.getUnitName());
                            itemEntity2.setPrice(twoVO.getTwoSubPrice());
                            itemEntity2.setTaxPrice(twoVO.getTwoSubPrice());
                            itemEntity2.setAmount(twoVO.getTwoNum());
                            itemEntity2.setMny(twoVO.getTwoSubMny());
                            itemEntity2.setTaxMny(twoVO.getTwoSubMny());
                            itemEntity2.setCategoryId(prosubItemVO.getCategoryId());
                            itemEntity2.setCategoryInnerCode(innerCode);
                            itemEntity2.setCategoryName(prosubItemVO.getCategoryName());
                            itemEntity2.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                            itemEntity2.setDocId(prosubItemVO.getId());
                            itemList2.add(itemEntity2);
                            detailEntity.setDutyDetailItemList(itemList2);
                            continue;
                        }
                        if (!detailEntity.getFeeDetailId().equals(qtzyfbId)) continue;
                        itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList();
                        itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(twoVO.getTwoDetailCode());
                        itemEntity.setName(twoVO.getTwoDetailName());
                        itemEntity.setUnitName(twoVO.getTwoUnitName());
                        itemEntity.setPrice(twoVO.getTwoSubPrice());
                        itemEntity.setTaxPrice(twoVO.getTwoSubPrice());
                        itemEntity.setAmount(twoVO.getTwoNum());
                        itemEntity.setMny(twoVO.getTwoSubMny());
                        itemEntity.setTaxMny(twoVO.getTwoSubMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(twoVO.getTwoDetailCode());
                    itemEntity.setName(twoVO.getTwoDetailName());
                    itemEntity.setUnitName(twoVO.getTwoUnitName());
                    if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoRgPrice(), (BigDecimal)BigDecimal.ZERO) && detailEntity.getFeeDetailId().equals(qtrgfId)) {
                        itemEntity.setPrice(twoVO.getTwoRgPrice());
                        itemEntity.setTaxPrice(twoVO.getTwoRgPrice());
                        itemEntity.setAmount(twoVO.getTwoNum());
                        itemEntity.setMny(twoVO.getTwoRgMny());
                        itemEntity.setTaxMny(twoVO.getTwoRgMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals((BigDecimal)twoVO.getTwoJxPrice(), (BigDecimal)BigDecimal.ZERO) && detailEntity.getFeeDetailId().equals(qtrgfId)) {
                        itemEntity.setPrice(twoVO.getTwoJxPrice());
                        itemEntity.setTaxPrice(twoVO.getTwoJxPrice());
                        itemEntity.setAmount(twoVO.getTwoNum());
                        itemEntity.setMny(twoVO.getTwoJxMny());
                        itemEntity.setTaxMny(twoVO.getTwoJxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (null == twoVO.getTwoSubPrice() || ComputeUtil.equals((BigDecimal)twoVO.getTwoSubPrice(), (BigDecimal)BigDecimal.ZERO) || !detailEntity.getFeeDetailId().equals(qtzyfbId)) continue;
                    itemEntity.setPrice(twoVO.getTwoSubPrice());
                    itemEntity.setTaxPrice(twoVO.getTwoSubPrice());
                    itemEntity.setAmount(twoVO.getTwoNum());
                    itemEntity.setMny(twoVO.getTwoSubMny());
                    itemEntity.setTaxMny(twoVO.getTwoSubMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }
}

