/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.roadbridge.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.roadbridge.bean.DutyEquipmentEntity;
import com.ejianc.business.roadbridge.bean.DutyJjfEntity;
import com.ejianc.business.roadbridge.bean.DutyMaterialEntity;
import com.ejianc.business.roadbridge.bean.DutyOneEntity;
import com.ejianc.business.roadbridge.bean.DutyOtherEntity;
import com.ejianc.business.roadbridge.bean.DutyPlansEntity;
import com.ejianc.business.roadbridge.bean.DutyRmatEntity;
import com.ejianc.business.roadbridge.bean.DutyTwoEntity;
import com.ejianc.business.roadbridge.bean.DutyUsenumEntity;
import com.ejianc.business.roadbridge.bean.RoadbridgeDutyEntity;
import com.ejianc.business.roadbridge.mapper.RoadbridgeDutyMapper;
import com.ejianc.business.roadbridge.service.IDutyEquipmentService;
import com.ejianc.business.roadbridge.service.IDutyJjfService;
import com.ejianc.business.roadbridge.service.IDutyMaterialService;
import com.ejianc.business.roadbridge.service.IDutyOneService;
import com.ejianc.business.roadbridge.service.IDutyOtherService;
import com.ejianc.business.roadbridge.service.IDutyPlansService;
import com.ejianc.business.roadbridge.service.IDutyRmatService;
import com.ejianc.business.roadbridge.service.IDutyTwoService;
import com.ejianc.business.roadbridge.service.IDutyUsenumService;
import com.ejianc.business.roadbridge.service.IRoadbridgeDutyService;
import com.ejianc.business.roadbridge.vo.DutyEquipmentVO;
import com.ejianc.business.roadbridge.vo.DutyJjfVO;
import com.ejianc.business.roadbridge.vo.DutyMaterialVO;
import com.ejianc.business.roadbridge.vo.DutyOneVO;
import com.ejianc.business.roadbridge.vo.DutyOtherVO;
import com.ejianc.business.roadbridge.vo.DutyPlansVO;
import com.ejianc.business.roadbridge.vo.DutyRmatVO;
import com.ejianc.business.roadbridge.vo.DutyTwoVO;
import com.ejianc.business.roadbridge.vo.DutyUsenumVO;
import com.ejianc.business.roadbridge.vo.RoadbridgeDutyRecordVO;
import com.ejianc.business.roadbridge.vo.RoadbridgeDutyVO;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.DetailIndexExcelReader;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ImportErrorVo;
import com.ejianc.business.targetcost.vo.ImportVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="roadbridgeDutyService")
public class RoadbridgeDutyServiceImpl
extends BaseServiceImpl<RoadbridgeDutyMapper, RoadbridgeDutyEntity>
implements IRoadbridgeDutyService {
    private static final String BILL_CODE = "ROADBRIDGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRoadbridgeDutyService roadbridgeDutyService;
    @Autowired
    private IDutyEquipmentService dutyEquipmentService;
    @Autowired
    private IDutyJjfService dutyJjfService;
    @Autowired
    private IDutyMaterialService dutyMaterialService;
    @Autowired
    private IDutyOneService dutyOneService;
    @Autowired
    private IDutyOtherService dutyOtherService;
    @Autowired
    private IDutyPlansService dutyPlansService;
    @Autowired
    private IDutyRmatService dutyRmatService;
    @Autowired
    private IDutyTwoService dutyTwoService;
    @Autowired
    private IDutyUsenumService dutyUsenumService;
    @Autowired
    private IDutyService dutyService;

    @Override
    public CommonResponse<RoadbridgeDutyVO> saveOrUpdate(RoadbridgeDutyVO saveOrUpdateVO) {
        RoadbridgeDutyVO roadbridgeDutyVO;
        List<DutyPlansEntity> dutyPlansEntityList;
        RoadbridgeDutyEntity entity = (RoadbridgeDutyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), RoadbridgeDutyEntity.class));
        if (entity.getLastDutyId() != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getFirstImportId, (Object)entity.getBaseDutyId());
            queryWrapper.isNotNull(DutyEntity::getLastDutyId);
            queryWrapper.notIn(DutyEntity::getBillState, new Object[]{"1,3"});
            if (this.dutyService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u5b58\u5728\u53d8\u66f4\u4e2d\u7684\u3010\u76ee\u6807\u8d23\u4efb\u6210\u672c\u3011\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u53d8\u66f4\uff01");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null == entity.getDutyVersion()) {
            entity.setDutyVersion(1);
        }
        entity.setConvertFlag(0);
        super.saveOrUpdate((Object)entity, false);
        if (entity.getBaseDutyId() == null && 0 == entity.getChangeState()) {
            entity.setBaseDutyId(entity.getId());
            entity.setOneTime(entity.getCreateTime());
        }
        if (entity.getLastDutyId() != null) {
            RoadbridgeDutyEntity revise = (RoadbridgeDutyEntity)((Object)super.getById((Serializable)entity.getLastDutyId()));
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            super.saveOrUpdate((Object)revise);
        }
        if (CollectionUtils.isNotEmpty(entity.getDutyOneList()) && CollectionUtils.isNotEmpty(dutyPlansEntityList = this.SumPlanDetail(roadbridgeDutyVO = (RoadbridgeDutyVO)((Object)BeanMapper.map((Object)((Object)entity), RoadbridgeDutyVO.class))))) {
            this.dutyPlansService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)entity.getId()));
            this.dutyPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
            DutyPlansEntity plansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size() - 1);
            DutyPlansEntity lastPlansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size() - 2);
            entity.setTaxMny(plansEntity.getPlansPlanMny());
            entity.setMny(plansEntity.getPlansPlanMny().subtract(lastPlansEntity.getPlansPlanMny()));
        }
        super.updateById((Object)entity);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        List<DutyTwoEntity> dutyTwoEntities = entity.getDutyTwoList();
        if (CollectionUtils.isNotEmpty(dutyTwoEntities)) {
            for (DutyTwoEntity twoEntity : dutyTwoEntities) {
                idMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (DutyTwoEntity cdEntity : dutyTwoEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.dutyTwoService.saveOrUpdateBatch(dutyTwoEntities, dutyTwoEntities.size(), false);
        }
        RoadbridgeDutyVO vo = this.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long dutyId = null;
        if (!StringUtils.isNotEmpty((CharSequence)request.getParameter("dutyId"))) {
            return CommonResponse.error((String)"\u4e3b\u8868\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        dutyId = Long.valueOf(request.getParameter("dutyId"));
        RoadbridgeDutyEntity roadbridgeDutyEntity = (RoadbridgeDutyEntity)((Object)this.roadbridgeDutyService.selectById(dutyId));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result0 = resList.get(0);
        List<List<String>> result1 = resList.get(2);
        if (result1.size() > 0 && result1.get(0).size() < 16) {
            return CommonResponse.error((String)"[100\u7ae0\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result2 = resList.get(3);
        if (result2.size() > 0 && result2.get(0).size() < 23) {
            return CommonResponse.error((String)"[200-1300\u7ae0\u8d39\u7528\u6784\u6210\u5206\u6790]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result3 = resList.get(4);
        if (result3.size() > 0 && result3.get(0).size() < 8) {
            return CommonResponse.error((String)"[\u4e3b\u8981\u6750\u6599\u6c47\u603b\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result4 = resList.get(5);
        if (result4.size() > 0 && result4.get(0).size() < 13) {
            return CommonResponse.error((String)"[\u5468\u8f6c\u6750\u6599\u8d39]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result5 = resList.get(6);
        if (result5.size() > 0 && result5.get(0).size() < 13) {
            return CommonResponse.error((String)"[\u673a\u68b0\u8bbe\u5907\u8d39\u7528]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result6 = resList.get(7);
        if (result6.size() > 0 && result6.get(0).size() < 5) {
            return CommonResponse.error((String)"[\u95f4\u63a5\u8d39]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result7 = resList.get(8);
        if (result7.size() > 0 && result7.get(0).size() < 9) {
            return CommonResponse.error((String)"[\u5176\u5b83\u5de5\u7a0b\u8d39]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ImportVo importVo1 = this.excelImportOne(result1, dutyId);
        ImportVo importVo2 = this.excelImportTwo(result2, dutyId);
        ImportVo importVo3 = this.excelImportMaterial(result3, dutyId);
        ImportVo importVo4 = this.excelImportRmat(result4, dutyId);
        ImportVo importVo5 = this.excelImportEquipment(result5, dutyId);
        ImportVo importVo6 = this.excelImportJjf(result6, dutyId);
        ImportVo importVo7 = this.excelImportOther(result7, dutyId);
        ImportVo importVo8 = this.excelImportUsenum(result0, dutyId);
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        errorList.addAll(importVo1.getErrorList());
        errorList.addAll(importVo2.getErrorList());
        errorList.addAll(importVo3.getErrorList());
        errorList.addAll(importVo4.getErrorList());
        errorList.addAll(importVo5.getErrorList());
        errorList.addAll(importVo6.getErrorList());
        errorList.addAll(importVo7.getErrorList());
        errorList.addAll(importVo8.getErrorList());
        if (errorList.size() > 0) {
            resp.put("successList", null);
            resp.put("successNum", (Object)0);
            resp.put("errorNum", (Object)errorList.size());
            if (errorList.size() > 100) {
                resp.put("errorList", errorList.subList(0, 100));
            } else {
                resp.put("errorList", errorList);
            }
        } else {
            List<DutyOneVO> dutyOneList = importVo1.getDutyOneList();
            List<DutyTwoVO> dutyTwoList = importVo2.getDutyTwoList();
            List<DutyMaterialVO> dutyMaterialList = importVo3.getDutyMaterialList();
            List<DutyRmatVO> dutyRmatList = importVo4.getDutyRmatList();
            List<DutyEquipmentVO> dutyEquipmentList = importVo5.getDutyEquipmentList();
            List<DutyJjfVO> dutyJjfList = importVo6.getDutyJjfList();
            List<DutyOtherVO> dutyOtherList = importVo7.getDutyOtherList();
            List<DutyUsenumVO> dutyUsenumList = importVo8.getDutyUsenumList();
            resp.put("successList", null);
            resp.put("errorList", null);
            resp.put("successNum", (Object)(dutyOneList.size() + dutyMaterialList.size() + dutyRmatList.size() + dutyEquipmentList.size() + dutyJjfList.size() + dutyOtherList.size() + dutyUsenumList.size()));
            resp.put("errorNum", (Object)0);
            this.dutyOneService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyOneList.size() > 0) {
                List dutyOneListEntities = BeanMapper.mapList(dutyOneList, DutyOneEntity.class);
                this.dutyOneService.saveOrUpdateBatch(dutyOneListEntities, dutyOneListEntities.size(), false);
            }
            this.dutyTwoService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyTwoList.size() > 0) {
                List dutyTwoListEntities = BeanMapper.mapList(dutyTwoList, DutyTwoEntity.class);
                this.dutyTwoService.saveOrUpdateBatch(dutyTwoListEntities, dutyTwoListEntities.size(), false);
            }
            this.dutyMaterialService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyMaterialList.size() > 0) {
                List dutyMaterialListEntities = BeanMapper.mapList(dutyMaterialList, DutyMaterialEntity.class);
                this.dutyMaterialService.saveOrUpdateBatch(dutyMaterialListEntities, dutyMaterialListEntities.size(), false);
            }
            this.dutyRmatService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyRmatList.size() > 0) {
                List dutyRmatListEntities = BeanMapper.mapList(dutyRmatList, DutyRmatEntity.class);
                this.dutyRmatService.saveOrUpdateBatch(dutyRmatListEntities, dutyRmatListEntities.size(), false);
            }
            this.dutyEquipmentService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyEquipmentList.size() > 0) {
                List dutyEquipmentListEntities = BeanMapper.mapList(dutyEquipmentList, DutyEquipmentEntity.class);
                this.dutyEquipmentService.saveOrUpdateBatch(dutyEquipmentListEntities, dutyEquipmentListEntities.size(), false);
            }
            this.dutyJjfService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyJjfList.size() > 0) {
                List dutyJjfListEntities = BeanMapper.mapList(dutyJjfList, DutyJjfEntity.class);
                this.dutyJjfService.saveOrUpdateBatch(dutyJjfListEntities, dutyJjfListEntities.size(), false);
            }
            this.dutyOtherService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyOtherList.size() > 0) {
                List dutyOtherListEntities = BeanMapper.mapList(dutyOtherList, DutyOtherEntity.class);
                this.dutyOtherService.saveOrUpdateBatch(dutyOtherListEntities, dutyOtherListEntities.size(), false);
            }
            this.dutyUsenumService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (dutyUsenumList.size() > 0) {
                List dutyUsenumListEntities = BeanMapper.mapList(dutyUsenumList, DutyUsenumEntity.class);
                this.dutyUsenumService.saveOrUpdateBatch(dutyUsenumListEntities, dutyUsenumListEntities.size(), false);
            }
            RoadbridgeDutyVO roadbridgeDutyVO = (RoadbridgeDutyVO)((Object)BeanMapper.map((Object)((Object)roadbridgeDutyEntity), RoadbridgeDutyVO.class));
            roadbridgeDutyVO.setDutyOneList(dutyOneList);
            roadbridgeDutyVO.setDutyTwoList(dutyTwoList);
            roadbridgeDutyVO.setDutyMaterialList(dutyMaterialList);
            roadbridgeDutyVO.setDutyRmatList(dutyRmatList);
            roadbridgeDutyVO.setDutyEquipmentList(dutyEquipmentList);
            roadbridgeDutyVO.setDutyOtherList(dutyOtherList);
            roadbridgeDutyVO.setDutyJjfList(dutyJjfList);
            List<DutyPlansEntity> dutyPlansEntityList = this.SumPlanDetail(roadbridgeDutyVO);
            this.dutyPlansService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (CollectionUtils.isNotEmpty(dutyPlansEntityList)) {
                this.dutyPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
                DutyPlansEntity plansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size() - 1);
                DutyPlansEntity lastPlansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size() - 2);
                roadbridgeDutyEntity.setProjectProfile(result0.get(0).get(1));
                roadbridgeDutyEntity.setTaxMny(plansEntity.getPlansPlanMny());
                roadbridgeDutyEntity.setMny(plansEntity.getPlansPlanMny().subtract(lastPlansEntity.getPlansPlanMny()));
                roadbridgeDutyEntity.setConvertFlag(0);
                this.roadbridgeDutyService.updateById((Object)roadbridgeDutyEntity);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    @Override
    public RoadbridgeDutyVO queryDetail(Long id) {
        RoadbridgeDutyEntity entity = (RoadbridgeDutyEntity)((Object)super.selectById((Serializable)id));
        RoadbridgeDutyVO vo = (RoadbridgeDutyVO)((Object)BeanMapper.map((Object)((Object)entity), RoadbridgeDutyVO.class));
        List<DutyTwoVO> twoVOList = vo.getDutyTwoList();
        vo.setDutyTwoList(TreeNodeBUtil.buildTree(twoVOList));
        List<RoadbridgeDutyRecordVO> list = new ArrayList<RoadbridgeDutyRecordVO>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RoadbridgeDutyEntity::getBaseDutyId, (Object)entity.getBaseDutyId());
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(RoadbridgeDutyEntity::getBillState, billStatusList);
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List roadbridgeDutyEntities = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)roadbridgeDutyEntities)) {
            list = BeanMapper.mapList((Iterable)roadbridgeDutyEntities, RoadbridgeDutyRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public RoadbridgeDutyVO queryChangeDetail(Long id) {
        List<DutyUsenumVO> dutyUsenumList;
        List<DutyOtherVO> dutyOtherList;
        List<DutyJjfVO> dutyJjfList;
        List<DutyEquipmentVO> dutyEquipmentList;
        List<DutyRmatVO> dutyRmatList;
        List<DutyMaterialVO> dutyMaterialList;
        List<DutyTwoVO> dutyTwoList;
        List<DutyOneVO> dutyOneList;
        RoadbridgeDutyEntity entity = (RoadbridgeDutyEntity)((Object)super.selectById((Serializable)id));
        RoadbridgeDutyVO vo = (RoadbridgeDutyVO)((Object)BeanMapper.map((Object)((Object)entity), RoadbridgeDutyVO.class));
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);
        List<DutyPlansVO> dutyPlansList = vo.getDutyPlansList();
        if (CollectionUtils.isNotEmpty(dutyPlansList)) {
            dutyPlansList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyPlansList(dutyPlansList);
        }
        if (CollectionUtils.isNotEmpty(dutyOneList = vo.getDutyOneList())) {
            dutyOneList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyOneList(dutyOneList);
        }
        if (CollectionUtils.isNotEmpty(dutyTwoList = vo.getDutyTwoList())) {
            HashMap idMap = new HashMap();
            dutyTwoList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (DutyTwoVO cdEntity : dutyTwoList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setDutyTwoList(TreeNodeBUtil.buildTree(dutyTwoList));
        }
        if (CollectionUtils.isNotEmpty(dutyMaterialList = vo.getDutyMaterialList())) {
            dutyMaterialList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyMaterialList(dutyMaterialList);
        }
        if (CollectionUtils.isNotEmpty(dutyRmatList = vo.getDutyRmatList())) {
            dutyRmatList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyRmatList(dutyRmatList);
        }
        if (CollectionUtils.isNotEmpty(dutyEquipmentList = vo.getDutyEquipmentList())) {
            dutyEquipmentList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyEquipmentList(dutyEquipmentList);
        }
        if (CollectionUtils.isNotEmpty(dutyJjfList = vo.getDutyJjfList())) {
            dutyJjfList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyJjfList(dutyJjfList);
        }
        if (CollectionUtils.isNotEmpty(dutyOtherList = vo.getDutyOtherList())) {
            dutyOtherList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyOtherList(dutyOtherList);
        }
        if (CollectionUtils.isNotEmpty(dutyUsenumList = vo.getDutyUsenumList())) {
            dutyUsenumList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyUsenumList(dutyUsenumList);
        }
        return vo;
    }

    @Override
    public RoadbridgeDutyVO ConvertFlag(Long id) {
        RoadbridgeDutyEntity entity = (RoadbridgeDutyEntity)((Object)super.selectById((Serializable)id));
        entity.setConvertFlag(1);
        super.updateById((Object)entity);
        RoadbridgeDutyVO vo = (RoadbridgeDutyVO)((Object)BeanMapper.map((Object)((Object)entity), RoadbridgeDutyVO.class));
        this.dutyService.pushFromImport(vo, false, ConversionEnum.\u4e91\u5357\u8def\u6865.getCode());
        List<DutyTwoVO> twoVOList = vo.getDutyTwoList();
        vo.setDutyTwoList(TreeNodeBUtil.buildTree(twoVOList));
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<RoadbridgeDutyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RoadbridgeDutyVO dutyVO : vos) {
                RoadbridgeDutyEntity dutyEntity = (RoadbridgeDutyEntity)((Object)super.getById((Serializable)dutyVO.getId()));
                if (dutyEntity.getLastDutyId() != null) {
                    RoadbridgeDutyEntity revise = (RoadbridgeDutyEntity)((Object)super.getById((Serializable)dutyEntity.getLastDutyId()));
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
                    revise.setLatestFlag(true);
                    super.saveOrUpdate((Object)revise);
                }
                this.dutyService.deleteFromImport(dutyVO.getId(), ConversionEnum.\u4e91\u5357\u8def\u6865.getCode());
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private ImportVo excelImportOne(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DutyOneVO> detailVoList = new ArrayList<DutyOneVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                DutyOneVO vo = new DutyOneVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String oneDetailName = datas.get(1);
                String oneUnitName = datas.get(2);
                String oneNum = datas.get(3);
                String oneMny = datas.get(4);
                String oneSumMny = datas.get(5);
                String oneRate = datas.get(6);
                String oneRgMny = datas.get(7);
                String oneMaterialMny = datas.get(8);
                String oneJxMny = datas.get(9);
                String oneSubMny = datas.get(10);
                String oneOtherMny = datas.get(11);
                String oneDutyMny = datas.get(12);
                String oneDownMny = datas.get(13);
                String oneDownRate = datas.get(14);
                String oneMemo = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                Boolean oneMnyFlag = false;
                if (StringUtils.isNotEmpty((CharSequence)oneMny) && BigDecimal.ZERO.compareTo(new BigDecimal(oneMny)) == 0) {
                    oneMnyFlag = true;
                }
                Boolean oneSumMnyFlag = false;
                if (StringUtils.isNotEmpty((CharSequence)oneSumMny) && BigDecimal.ZERO.compareTo(new BigDecimal(oneSumMny)) == 0) {
                    oneSumMnyFlag = true;
                }
                Boolean oneDutyMnyFlag = false;
                if (StringUtils.isNotEmpty((CharSequence)oneDutyMny) && BigDecimal.ZERO.compareTo(new BigDecimal(oneDutyMny)) == 0) {
                    oneDutyMnyFlag = true;
                }
                if (!(!StringUtils.isEmpty((CharSequence)oneMny) && oneMnyFlag == false || !StringUtils.isEmpty((CharSequence)oneSumMny) && oneSumMnyFlag == false) && (StringUtils.isEmpty((CharSequence)oneDutyMny) || oneDutyMnyFlag.booleanValue())) continue;
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setOneDetailCode(indexCode);
                    parentMap.put(indexCode, id);
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5b50\u76ee\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setOneDetailCode(null);
                    warnType = warnType + "[\u5b50\u76ee\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)oneDetailName)) {
                    vo.setOneDetailName(null);
                    warnType = warnType + "[\u5b50\u76ee\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setOneDetailName(oneDetailName);
                }
                vo.setOneUnitName(oneUnitName);
                if (StringUtils.isEmpty((CharSequence)oneNum)) {
                    vo.setOneNum(null);
                } else {
                    try {
                        vo.setOneNum(new BigDecimal(oneNum));
                    }
                    catch (Exception e) {
                        vo.setOneNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneMny)) {
                    vo.setOneMny(null);
                } else {
                    try {
                        vo.setOneMny(new BigDecimal(oneMny));
                    }
                    catch (Exception e) {
                        vo.setOneMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u63a7\u5236\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneSumMny)) {
                    vo.setOneSumMny(null);
                } else {
                    try {
                        vo.setOneSumMny(new BigDecimal(oneSumMny));
                    }
                    catch (Exception e) {
                        vo.setOneSumMny(null);
                        warnType = warnType + "[\u4e0d\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneRate)) {
                    vo.setOneRate(null);
                } else {
                    try {
                        vo.setOneRate(new BigDecimal(oneRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setOneRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneRgMny)) {
                    vo.setOneRgMny(null);
                } else {
                    try {
                        vo.setOneRgMny(new BigDecimal(oneRgMny));
                    }
                    catch (Exception e) {
                        vo.setOneRgMny(null);
                        warnType = warnType + "[\u4eba\u5de5\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneMaterialMny)) {
                    vo.setOneMaterialMny(null);
                } else {
                    try {
                        vo.setOneMaterialMny(new BigDecimal(oneMaterialMny));
                    }
                    catch (Exception e) {
                        vo.setOneMaterialMny(null);
                        warnType = warnType + "[\u6750\u6599\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneJxMny)) {
                    vo.setOneJxMny(null);
                } else {
                    try {
                        vo.setOneJxMny(new BigDecimal(oneJxMny));
                    }
                    catch (Exception e) {
                        vo.setOneJxMny(null);
                        warnType = warnType + "[\u673a\u68b0\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneSubMny)) {
                    vo.setOneSubMny(null);
                } else {
                    try {
                        vo.setOneSubMny(new BigDecimal(oneSubMny));
                    }
                    catch (Exception e) {
                        vo.setOneSubMny(null);
                        warnType = warnType + "[\u4e13\u4e1a\u5206\u5305\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneOtherMny)) {
                    vo.setOneOtherMny(null);
                } else {
                    try {
                        vo.setOneOtherMny(new BigDecimal(oneOtherMny));
                    }
                    catch (Exception e) {
                        vo.setOneOtherMny(null);
                        warnType = warnType + "[\u5176\u4ed6\u8d39\u7528\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneDutyMny)) {
                    vo.setOneDutyMny(null);
                } else {
                    try {
                        vo.setOneDutyMny(new BigDecimal(oneDutyMny));
                    }
                    catch (Exception e) {
                        vo.setOneDutyMny(null);
                        warnType = warnType + "[\u76ee\u6807\u6210\u672c\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneDownMny)) {
                    vo.setOneDownMny(null);
                } else {
                    try {
                        vo.setOneDownMny(new BigDecimal(oneDownMny));
                    }
                    catch (Exception e) {
                        vo.setOneDownMny(null);
                        warnType = warnType + "[\u964d\u4f4e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)oneDownRate)) {
                    vo.setOneDownRate(null);
                } else {
                    try {
                        vo.setOneDownRate(new BigDecimal(oneDownRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setOneDownRate(null);
                        warnType = warnType + "[\u964d\u4f4e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setOneMemo(oneMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyOneVO> successList = new ArrayList<DutyOneVO>();
            for (DutyOneVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("100\u7ae0\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getOneDetailCode());
                errorVo.setCode(vo.getOneDetailCode());
                errorVo.setName(vo.getOneDetailName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyOneList(successList);
        }
        return res;
    }

    private ImportVo excelImportTwo(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() - 2 > 0) {
            String twoDetailCode;
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DutyTwoVO> detailVoList = new ArrayList<DutyTwoVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DutyTwoVO vo = new DutyTwoVO();
                boolean flag = false;
                String warnType = "";
                twoDetailCode = datas.get(0);
                String twoDetailName = datas.get(1);
                String twoUnitName = datas.get(2);
                String twoNum = datas.get(3);
                String twoMny = datas.get(4);
                String twoSumMny = datas.get(5);
                String twoRgPrice = datas.get(6);
                String twoJxPrice = datas.get(7);
                String twoMaterialPrice = datas.get(8);
                String twoRate = datas.get(9);
                String twoNoPrice = datas.get(10);
                String twoSubPrice = datas.get(11);
                String twoDutyPrice = datas.get(12);
                String twoRgMny = datas.get(13);
                String twoJxMny = datas.get(14);
                String twoMaterialMny = datas.get(15);
                String twoNoMny = datas.get(16);
                String twoSubMny = datas.get(17);
                String twoDutyMny = datas.get(19);
                String twoDownMny = datas.get(20);
                String twoDownRate = datas.get(21);
                String twoMemo = datas.get(22);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)twoDetailCode)) {
                    twoDetailCode = twoDetailCode.trim();
                    vo.setTwoDetailCode(twoDetailCode);
                    parentMap.put(twoDetailCode, id);
                    if (detailIndexList.contains(twoDetailCode)) {
                        warnType = warnType + "[\u5b50\u76ee\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(twoDetailCode);
                    }
                } else {
                    vo.setTwoDetailCode(null);
                    warnType = warnType + "[\u5b50\u76ee\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)twoDetailName)) {
                    vo.setTwoDetailName(null);
                    warnType = warnType + "[\u5b50\u76ee\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setTwoDetailName(twoDetailName);
                }
                vo.setTwoUnitName(twoUnitName);
                if (StringUtils.isEmpty((CharSequence)twoNum)) {
                    vo.setTwoNum(null);
                } else {
                    try {
                        vo.setTwoNum(new BigDecimal(twoNum));
                    }
                    catch (Exception e) {
                        vo.setTwoNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoMny)) {
                    vo.setTwoMny(null);
                } else {
                    try {
                        vo.setTwoMny(new BigDecimal(twoMny));
                    }
                    catch (Exception e) {
                        vo.setTwoMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u63a7\u5236\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoSumMny)) {
                    vo.setTwoSumMny(null);
                } else {
                    try {
                        vo.setTwoSumMny(new BigDecimal(twoSumMny));
                    }
                    catch (Exception e) {
                        vo.setTwoSumMny(null);
                        warnType = warnType + "[\u4e0d\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1 \u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoRgPrice)) {
                    vo.setTwoRgPrice(null);
                } else {
                    try {
                        vo.setTwoRgPrice(new BigDecimal(twoRgPrice));
                    }
                    catch (Exception e) {
                        vo.setTwoRgPrice(null);
                        warnType = warnType + "[\u5355\u4ef7-\u4eba\u5de5\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoJxPrice)) {
                    vo.setTwoJxPrice(null);
                } else {
                    try {
                        vo.setTwoJxPrice(new BigDecimal(twoJxPrice));
                    }
                    catch (Exception e) {
                        vo.setTwoJxPrice(null);
                        warnType = warnType + "[\u5355\u4ef7-\u673a\u68b0\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoMaterialPrice)) {
                    vo.setTwoMaterialPrice(null);
                } else {
                    try {
                        vo.setTwoMaterialPrice(new BigDecimal(twoMaterialPrice));
                    }
                    catch (Exception e) {
                        vo.setTwoMaterialPrice(null);
                        warnType = warnType + "[\u5355\u4ef7-\u4e3b\u8981\u6750\u6599\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoRate)) {
                    vo.setTwoRate(null);
                } else {
                    try {
                        vo.setTwoRate(new BigDecimal(twoRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setTwoRate(null);
                        warnType = warnType + "[\u6750\u6599\u8017\u635f\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoNoPrice)) {
                    vo.setTwoNoPrice(null);
                } else {
                    try {
                        vo.setTwoNoPrice(new BigDecimal(twoNoPrice));
                    }
                    catch (Exception e) {
                        vo.setTwoNoPrice(null);
                        warnType = warnType + "[\u8ba1\u4ef7\u4e0d\u8ba1\u91cf\u6750\u6599\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoSubPrice)) {
                    vo.setTwoSubPrice(null);
                } else {
                    try {
                        vo.setTwoSubPrice(new BigDecimal(twoSubPrice));
                    }
                    catch (Exception e) {
                        vo.setTwoSubPrice(null);
                        warnType = warnType + "[\u5355\u4ef7-\u4e13\u4e1a\u5206\u5305\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoDutyPrice)) {
                    vo.setTwoDutyPrice(null);
                } else {
                    try {
                        vo.setTwoDutyPrice(new BigDecimal(twoDutyPrice));
                    }
                    catch (Exception e) {
                        vo.setTwoDutyPrice(null);
                        warnType = warnType + "[\u5355\u4ef7-\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoRgMny)) {
                    vo.setTwoRgMny(null);
                } else {
                    try {
                        vo.setTwoRgMny(new BigDecimal(twoRgMny));
                    }
                    catch (Exception e) {
                        vo.setTwoRgMny(null);
                        warnType = warnType + "[\u5408\u4ef7-\u4eba\u5de5\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoJxMny)) {
                    vo.setTwoJxMny(null);
                } else {
                    try {
                        vo.setTwoJxMny(new BigDecimal(twoJxMny));
                    }
                    catch (Exception e) {
                        vo.setTwoJxMny(null);
                        warnType = warnType + "[\u5408\u4ef7-\u673a\u68b0\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoMaterialMny)) {
                    vo.setTwoMaterialMny(null);
                } else {
                    try {
                        vo.setTwoMaterialMny(new BigDecimal(twoMaterialMny));
                    }
                    catch (Exception e) {
                        vo.setTwoMaterialMny(null);
                        warnType = warnType + "[\u5408\u4ef7-\u4e3b\u8981\u6750\u6599\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoNoMny)) {
                    vo.setTwoNoMny(null);
                } else {
                    try {
                        vo.setTwoNoMny(new BigDecimal(twoNoMny));
                    }
                    catch (Exception e) {
                        vo.setTwoNoMny(null);
                        warnType = warnType + "[\u5408\u4ef7-\u8ba1\u4ef7\u4e0d\u8ba1\u91cf\u6750\u6599\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoSubMny)) {
                    vo.setTwoSubMny(null);
                } else {
                    try {
                        vo.setTwoSubMny(new BigDecimal(twoSubMny));
                    }
                    catch (Exception e) {
                        vo.setTwoSubMny(null);
                        warnType = warnType + "[\u5408\u4ef7-\u4e13\u4e1a\u5206\u5305\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoDutyMny)) {
                    vo.setTwoDutyMny(null);
                } else {
                    try {
                        vo.setTwoDutyMny(new BigDecimal(twoDutyMny));
                    }
                    catch (Exception e) {
                        vo.setTwoDutyMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoDownMny)) {
                    vo.setTwoDownMny(null);
                } else {
                    try {
                        vo.setTwoDownMny(new BigDecimal(twoDownMny));
                    }
                    catch (Exception e) {
                        vo.setTwoDownMny(null);
                        warnType = warnType + "[\u964d\u4f4e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)twoDownRate)) {
                    vo.setTwoDownRate(null);
                } else {
                    try {
                        vo.setTwoDownRate(new BigDecimal(twoDownRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setTwoDownRate(null);
                        warnType = warnType + "[\u964d\u4f4e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setTwoMemo(twoMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyTwoVO> successList = new ArrayList<DutyTwoVO>();
            HashedMap map = new HashedMap();
            for (int i = 0; i < detailVoList.size(); ++i) {
                map.put(((DutyTwoVO)detailVoList.get(i)).getTwoDetailCode(), i);
            }
            HashMap<Long, Long> idsMap = new HashMap<Long, Long>();
            for (int i = 0; i < detailVoList.size(); ++i) {
                DutyTwoVO vo = (DutyTwoVO)detailVoList.get(i);
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    twoDetailCode = vo.getTwoDetailCode();
                    if (this.checkcountname(twoDetailCode)) {
                        vo.setParentId(null);
                    } else {
                        DutyTwoVO upVo = this.getUpVo(twoDetailCode, twoDetailCode, detailVoList, (Map<String, Integer>)map);
                        vo.setParentId(upVo.getId());
                    }
                    successList.add(vo);
                    Long pid = vo.getParentId() == null ? 999L : vo.getParentId();
                    if (idsMap.containsKey(pid)) continue;
                    idsMap.put(pid, vo.getId());
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("200-1300\u7ae0\u8d39\u7528\u6784\u6210\u5206\u6790");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getTwoDetailCode());
                errorVo.setCode(vo.getTwoDetailCode());
                errorVo.setName(vo.getTwoDetailName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            for (DutyTwoVO vo : successList) {
                if (idsMap.containsKey(vo.getId())) {
                    vo.setLeafFlag(false);
                    continue;
                }
                vo.setLeafFlag(true);
            }
            res.setDutyTwoList(successList);
        }
        return res;
    }

    private ImportVo excelImportMaterial(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<DutyMaterialVO> detailVoList = new ArrayList<DutyMaterialVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                DutyMaterialVO vo = new DutyMaterialVO();
                boolean flag = false;
                String warnType = "";
                String materialCode = datas.get(1);
                String materialName = datas.get(2);
                String materialUnitName = datas.get(3);
                String materialNum = datas.get(4);
                String materialPrice = datas.get(5);
                String materialMny = datas.get(6);
                String materialMemo = datas.get(7);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                vo.setMaterialMemo(materialMemo);
                if (StringUtils.isEmpty((CharSequence)materialCode)) {
                    vo.setMaterialCode(null);
                } else {
                    vo.setMaterialCode(materialCode);
                }
                if (StringUtils.isEmpty((CharSequence)materialName)) {
                    vo.setMaterialName(null);
                    warnType = warnType + "[\u4e3b\u8981\u6750\u6599\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMaterialName(materialName);
                }
                vo.setMaterialUnitName(materialUnitName);
                if (StringUtils.isEmpty((CharSequence)materialNum)) {
                    vo.setMaterialNum(null);
                } else {
                    try {
                        vo.setMaterialNum(new BigDecimal(materialNum));
                    }
                    catch (Exception e) {
                        vo.setMaterialNum(null);
                        warnType = warnType + "[\u5e94\u8017\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialPrice)) {
                    vo.setMaterialPrice(null);
                } else {
                    try {
                        vo.setMaterialPrice(new BigDecimal(materialPrice));
                    }
                    catch (Exception e) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u6750\u6599\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialMny)) {
                    vo.setMaterialMny(null);
                } else {
                    try {
                        vo.setMaterialMny(new BigDecimal(materialMny));
                    }
                    catch (Exception e) {
                        vo.setMaterialMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u6750\u6599\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyMaterialVO> successList = new ArrayList<DutyMaterialVO>();
            for (DutyMaterialVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u4e3b\u8981\u6750\u6599\u6c47\u603b\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getMaterialCode());
                errorVo.setCode(vo.getMaterialCode());
                errorVo.setName(vo.getMaterialName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyMaterialList(successList);
        }
        return res;
    }

    private ImportVo excelImportRmat(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<DutyRmatVO> detailVoList = new ArrayList<DutyRmatVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                DutyRmatVO vo = new DutyRmatVO();
                boolean flag = false;
                String warnType = "";
                String rmatCode = datas.get(1);
                String rmatName = datas.get(2);
                String rmatUnitName = datas.get(3);
                String rmatNum = datas.get(4);
                String rmatRentMonth = datas.get(5);
                String rmatPrice = datas.get(6);
                String rmatPrice2 = datas.get(8);
                String rmatMny = datas.get(9);
                String rmatCostScale = datas.get(10);
                String rmatCostMny = datas.get(11);
                String rmatMemo = datas.get(12);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isEmpty((CharSequence)rmatCode)) {
                    vo.setRmatCode(null);
                } else {
                    vo.setRmatCode(rmatCode);
                }
                if (StringUtils.isEmpty((CharSequence)rmatName)) {
                    vo.setRmatName(null);
                    warnType = warnType + "[\u6750\u6599\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setRmatName(rmatName);
                }
                vo.setRmatUnitName(rmatUnitName);
                if (StringUtils.isEmpty((CharSequence)rmatNum)) {
                    vo.setRmatNum(null);
                } else {
                    try {
                        vo.setRmatNum(new BigDecimal(rmatNum));
                    }
                    catch (Exception e) {
                        vo.setRmatNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatRentMonth)) {
                    vo.setRmatRentMonth(null);
                    if (StringUtils.isEmpty((CharSequence)rmatPrice)) {
                        vo.setRmatPrice(null);
                    } else {
                        try {
                            vo.setRmatPrice(new BigDecimal(rmatPrice));
                        }
                        catch (Exception e) {
                            vo.setRmatPrice(null);
                            warnType = warnType + "[\u5355\u4ef7-\u8d2d\u4e70 \u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                            flag = true;
                        }
                    }
                } else {
                    try {
                        vo.setRmatRentMonth(new BigDecimal(rmatRentMonth));
                        if (StringUtils.isEmpty((CharSequence)rmatPrice2)) {
                            vo.setRmatPrice(null);
                        } else {
                            try {
                                vo.setRmatPrice(new BigDecimal(rmatPrice2));
                            }
                            catch (Exception e) {
                                vo.setRmatPrice(null);
                                warnType = warnType + "[\u5355\u4ef7-\u79df\u91d1 \u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                                flag = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        vo.setRmatRentMonth(null);
                        vo.setRmatPrice(null);
                        warnType = warnType + "[\u79df\u7528\u65f6\u95f4(\u6708)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatCostScale)) {
                    vo.setRmatCostScale(null);
                } else {
                    try {
                        vo.setRmatCostScale(new BigDecimal(rmatCostScale).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setRmatCostScale(null);
                        warnType = warnType + "[\u644a\u9500\u6bd4\u4f8b\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatMny)) {
                    vo.setRmatMny(null);
                } else {
                    try {
                        vo.setRmatMny(new BigDecimal(rmatMny));
                    }
                    catch (Exception e) {
                        vo.setRmatMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatCostMny)) {
                    vo.setRmatCostMny(null);
                } else {
                    try {
                        vo.setRmatCostMny(new BigDecimal(rmatCostMny));
                    }
                    catch (Exception e) {
                        vo.setRmatCostMny(null);
                        warnType = warnType + "[\u644a\u9500\u6210\u672c\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setRmatMemo(rmatMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyRmatVO> successList = new ArrayList<DutyRmatVO>();
            for (DutyRmatVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5468\u8f6c\u6750\u6599\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setCode(vo.getRmatCode());
                errorVo.setName(vo.getRmatName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyRmatList(successList);
        }
        return res;
    }

    private ImportVo excelImportEquipment(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<DutyEquipmentVO> detailVoList = new ArrayList<DutyEquipmentVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                DutyEquipmentVO vo = new DutyEquipmentVO();
                boolean flag = false;
                String warnType = "";
                String equipmentCode = datas.get(1);
                String equipmentName = datas.get(2);
                String equipmentUnitName = datas.get(3);
                String equipmentNum = datas.get(4);
                String equipmentRentMonth = datas.get(5);
                String equipmentPrice = datas.get(6);
                String equipmentPrice2 = datas.get(8);
                String equipmentCostScale = datas.get(9);
                String equipmentMny = datas.get(10);
                String equipmentCostMny = datas.get(11);
                String equipmentMemo = datas.get(12);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isEmpty((CharSequence)equipmentCode)) {
                    vo.setEquipmentCode(null);
                } else {
                    vo.setEquipmentCode(equipmentCode);
                }
                if (StringUtils.isEmpty((CharSequence)equipmentName)) {
                    vo.setEquipmentName(null);
                    warnType = warnType + "[\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setEquipmentName(equipmentName);
                }
                vo.setEquipmentUnitName(equipmentUnitName);
                if (StringUtils.isEmpty((CharSequence)equipmentNum)) {
                    vo.setEquipmentNum(null);
                } else {
                    try {
                        vo.setEquipmentNum(new BigDecimal(equipmentNum));
                    }
                    catch (Exception e) {
                        vo.setEquipmentNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentRentMonth)) {
                    vo.setEquipmentRentMonth(null);
                    if (StringUtils.isEmpty((CharSequence)equipmentPrice)) {
                        vo.setEquipmentPrice(null);
                    } else {
                        try {
                            vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
                        }
                        catch (Exception e) {
                            vo.setEquipmentPrice(null);
                            warnType = warnType + "[\u5355\u4ef7-\u8d2d\u4e70 \u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                            flag = true;
                        }
                    }
                } else {
                    try {
                        vo.setEquipmentRentMonth(new BigDecimal(equipmentRentMonth));
                        if (StringUtils.isEmpty((CharSequence)equipmentPrice2)) {
                            vo.setEquipmentPrice(null);
                        } else {
                            try {
                                vo.setEquipmentPrice(new BigDecimal(equipmentPrice2));
                            }
                            catch (Exception e) {
                                vo.setEquipmentPrice(null);
                                warnType = warnType + "[\u5355\u4ef7-\u79df\u91d1 \u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                                flag = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        vo.setEquipmentRentMonth(null);
                        vo.setEquipmentPrice(null);
                        warnType = warnType + "[\u79df\u7528\u65f6\u95f4(\u6708)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentCostScale)) {
                    vo.setEquipmentCostScale(null);
                } else {
                    try {
                        vo.setEquipmentCostScale(new BigDecimal(equipmentCostScale).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setEquipmentCostScale(null);
                        warnType = warnType + "[\u644a\u9500\u6bd4\u4f8b\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentMny)) {
                    vo.setEquipmentMny(null);
                } else {
                    try {
                        vo.setEquipmentMny(new BigDecimal(equipmentMny));
                    }
                    catch (Exception e) {
                        vo.setEquipmentMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentCostMny)) {
                    vo.setEquipmentCostMny(null);
                } else {
                    try {
                        vo.setEquipmentCostMny(new BigDecimal(equipmentCostMny));
                    }
                    catch (Exception e) {
                        vo.setEquipmentCostMny(null);
                        warnType = warnType + "[\u644a\u9500\u6210\u672c\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setEquipmentMemo(equipmentMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyEquipmentVO> successList = new ArrayList<DutyEquipmentVO>();
            for (DutyEquipmentVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u673a\u68b0\u8bbe\u5907\u8d39\u7528");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getEquipmentCode());
                errorVo.setCode(vo.getEquipmentCode());
                errorVo.setName(vo.getEquipmentName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyEquipmentList(successList);
        }
        return res;
    }

    private ImportVo excelImportJjf(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<DutyJjfVO> detailVoList = new ArrayList<DutyJjfVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                DutyJjfVO vo = new DutyJjfVO();
                boolean flag = false;
                String warnType = "";
                String jjfName = datas.get(1);
                String jjfUnitName = datas.get(2);
                String jjfMny = datas.get(3);
                String jjfMemo = datas.get(4);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                vo.setJjfMemo(jjfMemo);
                if (StringUtils.isEmpty((CharSequence)jjfName)) {
                    vo.setJjfName(null);
                    vo.setSubjectName(null);
                    warnType = warnType + "[\u540d\u79f0\uff08\u6210\u672c\u79d1\u76ee\uff09\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setJjfName(jjfName);
                    vo.setSubjectName(jjfName);
                }
                vo.setJjfUnitName(jjfUnitName);
                if (StringUtils.isEmpty((CharSequence)jjfMny)) {
                    vo.setJjfMny(null);
                } else {
                    try {
                        vo.setJjfMny(new BigDecimal(jjfMny));
                    }
                    catch (Exception e) {
                        vo.setJjfMny(null);
                        warnType = warnType + "[\u91d1\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyJjfVO> successList = new ArrayList<DutyJjfVO>();
            for (DutyJjfVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u95f4\u63a5\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setName(vo.getJjfName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyJjfList(successList);
        }
        return res;
    }

    private ImportVo excelImportOther(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<DutyOtherVO> detailVoList = new ArrayList<DutyOtherVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                DutyOtherVO vo = new DutyOtherVO();
                boolean flag = false;
                String warnType = "";
                String subjectName = datas.get(1);
                String otherName = datas.get(2);
                String otherUnitName = datas.get(3);
                String otherNum = datas.get(4);
                String otherJs = datas.get(5);
                String otherRate = datas.get(6);
                String otherMny = datas.get(7);
                String otherMemo = datas.get(8);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isEmpty((CharSequence)subjectName)) {
                    vo.setSubjectName(null);
                    warnType = warnType + "[\u6210\u672c\u79d1\u76ee\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSubjectName(subjectName);
                }
                if (StringUtils.isEmpty((CharSequence)otherName)) {
                    vo.setOtherName(null);
                    warnType = warnType + "[\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setOtherName(otherName);
                }
                vo.setOtherUnitName(otherUnitName);
                if (StringUtils.isEmpty((CharSequence)otherNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(otherNum));
                    }
                    catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)otherJs)) {
                    vo.setOtherJs(null);
                } else {
                    try {
                        vo.setOtherJs(new BigDecimal(otherJs));
                    }
                    catch (Exception e) {
                        vo.setOtherJs(null);
                        warnType = warnType + "[\u8ba1\u7b97\u57fa\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)otherRate)) {
                    vo.setOtherRate(null);
                } else {
                    try {
                        vo.setOtherRate(new BigDecimal(otherRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setOtherRate(null);
                        warnType = warnType + "[\u8d39\u7387\uff08%\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)otherMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(otherMny));
                    }
                    catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setOtherMemo(otherMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyOtherVO> successList = new ArrayList<DutyOtherVO>();
            for (DutyOtherVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5176\u5b83\u5de5\u7a0b\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setName(vo.getOtherName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyOtherList(successList);
        }
        return res;
    }

    private ImportVo excelImportUsenum(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<DutyUsenumVO> detailVoList = new ArrayList<DutyUsenumVO>();
            boolean importFlag = true;
            for (int i = 3; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DutyUsenumVO vo = new DutyUsenumVO();
                boolean flag = false;
                String warnType = "";
                String usenumName = datas.get(0);
                String usenumUnitName = datas.get(1);
                String usenumNum = datas.get(2);
                String usenumMemo = datas.get(3);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                vo.setUsenumMemo(usenumMemo);
                if (StringUtils.isEmpty((CharSequence)usenumName)) {
                    vo.setUsenumName(null);
                } else {
                    vo.setUsenumName(usenumName);
                }
                vo.setUsenumUnitName(usenumUnitName);
                if (StringUtils.isEmpty((CharSequence)usenumNum)) {
                    vo.setUsenumNum(null);
                } else {
                    try {
                        vo.setUsenumNum(new BigDecimal(usenumNum));
                    }
                    catch (Exception e) {
                        vo.setUsenumNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<DutyUsenumVO> successList = new ArrayList<DutyUsenumVO>();
            for (DutyUsenumVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u4e3b\u8981\u6750\u6599\u7528\u91cf\u8868");
                errorVo.setId(vo.getId());
                errorVo.setName(vo.getUsenumName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setDutyUsenumList(successList);
        }
        return res;
    }

    public boolean checkcountname(String countname) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(countname);
        return m.find();
    }

    public boolean checkUn(String countname) {
        return countname.matches("^[a-zA-Z].*");
    }

    public DutyTwoVO getUpVo(String baseCode, String code, List<DutyTwoVO> list, Map<String, Integer> map) {
        int index = map.get(code);
        DutyTwoVO vo = list.get(index);
        DutyTwoVO lastVo = list.get(index - 1);
        if (baseCode.length() > lastVo.getTwoDetailCode().length() && !this.checkUn(lastVo.getTwoDetailCode())) {
            return lastVo;
        }
        return this.getUpVo(baseCode, lastVo.getTwoDetailCode(), list, map);
    }

    public List<DutyPlansEntity> SumPlanDetail(RoadbridgeDutyVO vo) {
        Long dutyId = vo.getId();
        List<DutyOneVO> dutyOneList = vo.getDutyOneList();
        List<DutyTwoVO> dutyTwoList = vo.getDutyTwoList();
        List<DutyMaterialVO> dutyMaterialList = vo.getDutyMaterialList();
        List<DutyRmatVO> dutyRmatList = vo.getDutyRmatList();
        List<DutyEquipmentVO> dutyEquipmentList = vo.getDutyEquipmentList();
        List<DutyJjfVO> dutyJjfList = vo.getDutyJjfList();
        List<DutyOtherVO> dutyOtherList = vo.getDutyOtherList();
        ArrayList<DutyPlansEntity> dutyPlansEntityList = new ArrayList<DutyPlansEntity>();
        BigDecimal sumPlansMny = BigDecimal.ZERO;
        BigDecimal sumPlansTaxMny = BigDecimal.ZERO;
        BigDecimal sumPlansPlanMny = BigDecimal.ZERO;
        BigDecimal sumPlansDownMny = BigDecimal.ZERO;
        DutyPlansEntity one = new DutyPlansEntity();
        one.setDutyId(dutyId);
        one.setPlansDetailName("100\u7ae0\u603b\u5219");
        BigDecimal plansMny = dutyOneList.stream().filter(item -> null != item.getOneSumMny()).map(DutyOneVO::getOneSumMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        one.setPlansMny(plansMny);
        BigDecimal plansTaxMny = plansMny.multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100), 2, 5);
        one.setPlansTaxMny(plansTaxMny);
        BigDecimal plansPlanMny = dutyOneList.stream().filter(item -> null != item.getOneDutyMny()).map(DutyOneVO::getOneDutyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        one.setPlansPlanMny(plansPlanMny);
        BigDecimal plansDownMny = dutyOneList.stream().filter(item -> null != item.getOneDownMny()).map(DutyOneVO::getOneDownMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        one.setPlansDownMny(plansDownMny);
        if (BigDecimal.ZERO.compareTo(plansMny) != 0) {
            one.setPlansDownRate(plansDownMny.multiply(new BigDecimal(100)).divide(plansMny, 2, 5));
        } else {
            one.setPlansDownRate(BigDecimal.ZERO);
        }
        dutyPlansEntityList.add(one);
        sumPlansMny = sumPlansMny.add(plansMny);
        sumPlansTaxMny = sumPlansTaxMny.add(plansTaxMny);
        sumPlansPlanMny = sumPlansPlanMny.add(plansPlanMny);
        sumPlansDownMny = sumPlansDownMny.add(plansDownMny);
        for (DutyTwoVO dutyTwoVO : dutyTwoList) {
            if (!this.checkcountname(dutyTwoVO.getTwoDetailCode())) continue;
            DutyPlansEntity two = new DutyPlansEntity();
            two.setDutyId(dutyId);
            two.setPlansDetailName(dutyTwoVO.getTwoDetailName());
            two.setPlansFeeName("\u4eba\u5de5\u8d39");
            two.setPlansMny(dutyTwoVO.getTwoSumMny() == null ? BigDecimal.ZERO : dutyTwoVO.getTwoSumMny());
            two.setPlansTaxMny(two.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100), 2, 5));
            two.setPlansPlanMny(dutyTwoVO.getTwoRgMny());
            two.setPlansDownMny(dutyTwoVO.getTwoDownMny());
            two.setPlansDownRate(dutyTwoVO.getTwoDownRate());
            dutyPlansEntityList.add(two);
            DutyPlansEntity two2 = new DutyPlansEntity();
            two2.setDutyId(dutyId);
            two2.setPlansDetailName(dutyTwoVO.getTwoDetailName());
            two2.setPlansFeeName("\u673a\u68b0\u8d39");
            two2.setPlansMny(dutyTwoVO.getTwoSumMny() == null ? BigDecimal.ZERO : dutyTwoVO.getTwoSumMny());
            two2.setPlansTaxMny(two2.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100), 2, 5));
            two2.setPlansPlanMny(dutyTwoVO.getTwoJxMny());
            two2.setPlansDownMny(dutyTwoVO.getTwoDownMny());
            two2.setPlansDownRate(dutyTwoVO.getTwoDownRate());
            dutyPlansEntityList.add(two2);
            DutyPlansEntity two3 = new DutyPlansEntity();
            two3.setDutyId(dutyId);
            two3.setPlansDetailName(dutyTwoVO.getTwoDetailName());
            two3.setPlansFeeName("\u6750\u6599\u8d39");
            two3.setPlansMny(dutyTwoVO.getTwoSumMny() == null ? BigDecimal.ZERO : dutyTwoVO.getTwoSumMny());
            two3.setPlansTaxMny(two3.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100), 2, 5));
            two3.setPlansPlanMny(dutyTwoVO.getTwoMaterialMny());
            two3.setPlansDownMny(dutyTwoVO.getTwoDownMny());
            two3.setPlansDownRate(dutyTwoVO.getTwoDownRate());
            dutyPlansEntityList.add(two3);
            DutyPlansEntity two4 = new DutyPlansEntity();
            two4.setDutyId(dutyId);
            two4.setPlansDetailName(dutyTwoVO.getTwoDetailName());
            two4.setPlansFeeName("\u8ba1\u4ef7\u4e0d\u8ba1\u91cf\u6750\u6599\u8d39");
            two4.setPlansMny(dutyTwoVO.getTwoSumMny() == null ? BigDecimal.ZERO : dutyTwoVO.getTwoSumMny());
            two4.setPlansTaxMny(two4.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100), 2, 5));
            two4.setPlansPlanMny(dutyTwoVO.getTwoNoMny());
            two4.setPlansDownMny(dutyTwoVO.getTwoDownMny());
            two4.setPlansDownRate(dutyTwoVO.getTwoDownRate());
            dutyPlansEntityList.add(two4);
            DutyPlansEntity two5 = new DutyPlansEntity();
            two5.setDutyId(dutyId);
            two5.setPlansDetailName(dutyTwoVO.getTwoDetailName());
            two5.setPlansFeeName("\u4e13\u4e1a\u5206\u5305");
            two5.setPlansMny(dutyTwoVO.getTwoSumMny() == null ? BigDecimal.ZERO : dutyTwoVO.getTwoSumMny());
            two5.setPlansTaxMny(two5.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100)).divide(new BigDecimal(100), 2, 5)));
            two5.setPlansPlanMny(dutyTwoVO.getTwoSubMny());
            two5.setPlansDownMny(dutyTwoVO.getTwoDownMny());
            two5.setPlansDownRate(dutyTwoVO.getTwoDownRate());
            dutyPlansEntityList.add(two5);
            DutyPlansEntity two6 = new DutyPlansEntity();
            two6.setDutyId(dutyId);
            two6.setPlansDetailName(dutyTwoVO.getTwoDetailName());
            two6.setPlansFeeName("\u5408\u8ba1");
            two6.setPlansMny(dutyTwoVO.getTwoSumMny() == null ? BigDecimal.ZERO : dutyTwoVO.getTwoSumMny());
            two6.setPlansTaxMny(two6.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100)).divide(new BigDecimal(100), 2, 5)));
            two6.setPlansPlanMny(dutyTwoVO.getTwoDutyMny());
            two6.setPlansDownMny(dutyTwoVO.getTwoDownMny());
            two6.setPlansDownRate(dutyTwoVO.getTwoDownRate());
            dutyPlansEntityList.add(two6);
            sumPlansMny = sumPlansMny.add(two6.getPlansMny() == null ? BigDecimal.ZERO : two6.getPlansMny());
            sumPlansTaxMny = sumPlansTaxMny.add(two6.getPlansTaxMny() == null ? BigDecimal.ZERO : two6.getPlansTaxMny());
            sumPlansPlanMny = sumPlansPlanMny.add(two6.getPlansPlanMny() == null ? BigDecimal.ZERO : two6.getPlansPlanMny());
            sumPlansDownMny = sumPlansDownMny.add(two6.getPlansDownMny() == null ? BigDecimal.ZERO : two6.getPlansDownMny());
        }
        DutyPlansEntity hj = new DutyPlansEntity();
        hj.setDutyId(dutyId);
        hj.setPlansDetailName("\u5408\u8ba1");
        hj.setPlansMny(sumPlansMny);
        hj.setPlansTaxMny(sumPlansTaxMny);
        hj.setPlansPlanMny(sumPlansPlanMny);
        hj.setPlansDownMny(sumPlansDownMny);
        if (BigDecimal.ZERO.compareTo(sumPlansMny) != 0) {
            hj.setPlansDownRate(sumPlansDownMny.multiply(new BigDecimal(100)).divide(sumPlansMny, 2, 5));
        } else {
            hj.setPlansDownRate(BigDecimal.ZERO);
        }
        dutyPlansEntityList.add(hj);
        DutyPlansEntity bkyj = new DutyPlansEntity();
        bkyj.setDutyId(dutyId);
        bkyj.setPlansDetailName("\u4e0d\u53ef\u9884\u89c1\u8d39");
        bkyj.setPlansMny(sumPlansMny.multiply(vo.getScale().divide(new BigDecimal(100), 2, 5)));
        bkyj.setPlansTaxMny(sumPlansTaxMny.multiply(vo.getScale().divide(new BigDecimal(100), 2, 5)));
        bkyj.setPlansPlanMny(bkyj.getPlansMny());
        bkyj.setPlansDownMny(BigDecimal.ZERO);
        dutyPlansEntityList.add(bkyj);
        DutyPlansEntity rmat = new DutyPlansEntity();
        rmat.setDutyId(dutyId);
        rmat.setPlansDetailName("\u5468\u8f6c\u6750\u6599\u53ca\u5c0f\u4e94\u91d1");
        BigDecimal rmatMny = dutyRmatList.stream().filter(item -> null == item.getParentId()).map(DutyRmatVO::getRmatCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        rmat.setPlansPlanMny(rmatMny == null ? BigDecimal.ZERO : rmatMny);
        dutyPlansEntityList.add(rmat);
        DutyPlansEntity equipment = new DutyPlansEntity();
        equipment.setDutyId(dutyId);
        equipment.setPlansDetailName("\u673a\u68b0\u8bbe\u5907\u8d39\uff08\u79df\u8d41\u6216\u81ea\u8d2d\uff09");
        BigDecimal equipmentMny = dutyEquipmentList.stream().filter(item -> null != item.getEquipmentCostMny()).map(DutyEquipmentVO::getEquipmentCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        equipment.setPlansPlanMny(equipmentMny == null ? BigDecimal.ZERO : equipmentMny);
        dutyPlansEntityList.add(equipment);
        DutyPlansEntity material = new DutyPlansEntity();
        material.setDutyId(dutyId);
        material.setPlansDetailName("\u96f6\u661f\u6750\u6599\u53ca\u673a\u68b0\u7528\u6cb9");
        ArrayList materialList = new ArrayList();
        if (CollectionUtils.isNotEmpty(dutyMaterialList)) {
            dutyMaterialList.forEach(e -> {
                if ("114003".equals(e.getMaterialCode()) || "134009".equals(e.getMaterialCode())) {
                    materialList.add(e);
                }
            });
            BigDecimal materialMny = materialList.stream().filter(item -> null != item.getMaterialMny()).map(DutyMaterialVO::getMaterialMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            material.setPlansPlanMny(materialMny == null ? BigDecimal.ZERO : materialMny);
        } else {
            material.setPlansPlanMny(BigDecimal.ZERO);
        }
        dutyPlansEntityList.add(material);
        DutyPlansEntity jjf = new DutyPlansEntity();
        jjf.setDutyId(dutyId);
        jjf.setPlansDetailName("\u95f4\u63a5\u8d39\u7528");
        BigDecimal jjfMny = dutyJjfList.stream().filter(item -> null != item.getJjfMny()).map(DutyJjfVO::getJjfMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        jjf.setPlansPlanMny(jjfMny == null ? BigDecimal.ZERO : jjfMny);
        jjf.setPlansDownMny(BigDecimal.ZERO.subtract(jjfMny));
        dutyPlansEntityList.add(jjf);
        DutyPlansEntity other = new DutyPlansEntity();
        other.setDutyId(dutyId);
        other.setPlansDetailName("\u5176\u5b83\u5de5\u7a0b\u8d39\u7528");
        BigDecimal otherMny = dutyOtherList.stream().filter(item -> null != item.getOtherMny()).map(DutyOtherVO::getOtherMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        other.setPlansPlanMny(otherMny == null ? BigDecimal.ZERO : otherMny);
        other.setPlansDownMny(BigDecimal.ZERO.subtract(otherMny));
        dutyPlansEntityList.add(other);
        DutyPlansEntity sj = new DutyPlansEntity();
        sj.setDutyId(dutyId);
        sj.setPlansDetailName("\u7a0e\u91d1");
        BigDecimal sjMny = hj.getPlansMny().add(bkyj.getPlansMny()).multiply(vo.getTaxRate()).divide(new BigDecimal(100), 2, 5);
        sj.setPlansMny(sjMny);
        sj.setPlansPlanMny(sjMny);
        sj.setPlansDownMny(BigDecimal.ZERO);
        dutyPlansEntityList.add(sj);
        DutyPlansEntity hj2 = new DutyPlansEntity();
        hj2.setDutyId(dutyId);
        hj2.setPlansDetailName("\u5408\u8ba1");
        hj2.setPlansMny(sumPlansMny.add(bkyj.getPlansMny()).add(sjMny));
        hj2.setPlansTaxMny(sumPlansTaxMny.add(bkyj.getPlansTaxMny()));
        hj2.setPlansPlanMny(sumPlansPlanMny.add(bkyj.getPlansPlanMny()).add(rmat.getPlansPlanMny()).add(equipment.getPlansPlanMny()).add(material.getPlansPlanMny()).add(otherMny).add(jjfMny).add(sjMny));
        hj2.setPlansDownMny(hj2.getPlansMny().subtract(hj2.getPlansPlanMny()));
        if (BigDecimal.ZERO.compareTo(hj2.getPlansMny()) != 0) {
            hj2.setPlansDownRate(hj2.getPlansDownMny().multiply(new BigDecimal(100)).divide(hj2.getPlansMny(), 2, 5));
        } else {
            hj2.setPlansDownRate(BigDecimal.ZERO);
        }
        dutyPlansEntityList.add(hj2);
        return dutyPlansEntityList;
    }
}

