/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sx2j.build.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.sx2j.build.bean.BuildAppointEntity;
import com.ejianc.business.sx2j.build.bean.BuildCompleteEntity;
import com.ejianc.business.sx2j.build.bean.BuildDutyEntity;
import com.ejianc.business.sx2j.build.bean.BuildEquipmentEntity;
import com.ejianc.business.sx2j.build.bean.BuildIndirectEntity;
import com.ejianc.business.sx2j.build.bean.BuildMaterialEntity;
import com.ejianc.business.sx2j.build.bean.BuildMeasureEntity;
import com.ejianc.business.sx2j.build.bean.BuildNightEntity;
import com.ejianc.business.sx2j.build.bean.BuildPlansEntity;
import com.ejianc.business.sx2j.build.bean.BuildPrecipitationEntity;
import com.ejianc.business.sx2j.build.bean.BuildRgcostEntity;
import com.ejianc.business.sx2j.build.bean.BuildSafeEntity;
import com.ejianc.business.sx2j.build.bean.BuildScaffoldEntity;
import com.ejianc.business.sx2j.build.bean.BuildStimulateEntity;
import com.ejianc.business.sx2j.build.bean.BuildSubEntity;
import com.ejianc.business.sx2j.build.bean.BuildTemplatesEntity;
import com.ejianc.business.sx2j.build.mapper.BuildDutyMapper;
import com.ejianc.business.sx2j.build.service.IBuildAppointService;
import com.ejianc.business.sx2j.build.service.IBuildCompleteService;
import com.ejianc.business.sx2j.build.service.IBuildDutyService;
import com.ejianc.business.sx2j.build.service.IBuildEquipmentService;
import com.ejianc.business.sx2j.build.service.IBuildFeesService;
import com.ejianc.business.sx2j.build.service.IBuildIndirectService;
import com.ejianc.business.sx2j.build.service.IBuildManageService;
import com.ejianc.business.sx2j.build.service.IBuildMaterialService;
import com.ejianc.business.sx2j.build.service.IBuildMeasureService;
import com.ejianc.business.sx2j.build.service.IBuildNightService;
import com.ejianc.business.sx2j.build.service.IBuildOtherService;
import com.ejianc.business.sx2j.build.service.IBuildPlansService;
import com.ejianc.business.sx2j.build.service.IBuildPrecipitationService;
import com.ejianc.business.sx2j.build.service.IBuildRgcostService;
import com.ejianc.business.sx2j.build.service.IBuildRmatService;
import com.ejianc.business.sx2j.build.service.IBuildSafeService;
import com.ejianc.business.sx2j.build.service.IBuildScaffoldService;
import com.ejianc.business.sx2j.build.service.IBuildStimulateService;
import com.ejianc.business.sx2j.build.service.IBuildSubService;
import com.ejianc.business.sx2j.build.service.IBuildTemplatesService;
import com.ejianc.business.sx2j.build.service.IBuildTemporaryService;
import com.ejianc.business.sx2j.build.vo.BuildAppointVO;
import com.ejianc.business.sx2j.build.vo.BuildCompleteVO;
import com.ejianc.business.sx2j.build.vo.BuildDutyRecordVO;
import com.ejianc.business.sx2j.build.vo.BuildDutyVO;
import com.ejianc.business.sx2j.build.vo.BuildEquipmentVO;
import com.ejianc.business.sx2j.build.vo.BuildIndirectVO;
import com.ejianc.business.sx2j.build.vo.BuildMaterialVO;
import com.ejianc.business.sx2j.build.vo.BuildMeasureVO;
import com.ejianc.business.sx2j.build.vo.BuildNightVO;
import com.ejianc.business.sx2j.build.vo.BuildPlansVO;
import com.ejianc.business.sx2j.build.vo.BuildPrecipitationVO;
import com.ejianc.business.sx2j.build.vo.BuildRgcostVO;
import com.ejianc.business.sx2j.build.vo.BuildSafeVO;
import com.ejianc.business.sx2j.build.vo.BuildScaffoldVO;
import com.ejianc.business.sx2j.build.vo.BuildStimulateVO;
import com.ejianc.business.sx2j.build.vo.BuildSubVO;
import com.ejianc.business.sx2j.build.vo.BuildTemplatesVO;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.DetailIndexExcelReader2;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ImportBuildVo;
import com.ejianc.business.targetcost.vo.ImportErrorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="buildDutyService")
public class BuildDutyServiceImpl
extends BaseServiceImpl<BuildDutyMapper, BuildDutyEntity>
implements IBuildDutyService {
    private static final String BILL_CODE = "TC_DUTY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBuildPlansService buildPlansService;
    @Autowired
    private IBuildRgcostService buildRgcostService;
    @Autowired
    private IBuildSubService buildSubService;
    @Autowired
    private IBuildMaterialService buildMaterialService;
    @Autowired
    private IBuildAppointService buildAppointService;
    @Autowired
    private IBuildRmatService buildRmatService;
    @Autowired
    private IBuildEquipmentService buildEquipmentService;
    @Autowired
    private IBuildSafeService buildSafeService;
    @Autowired
    private IBuildNightService buildNightService;
    @Autowired
    private IBuildCompleteService buildCompleteService;
    @Autowired
    private IBuildPrecipitationService buildPrecipitationService;
    @Autowired
    private IBuildTemporaryService buildTemporaryService;
    @Autowired
    private IBuildTemplatesService buildTemplatesService;
    @Autowired
    private IBuildIndirectService buildIndirectService;
    @Autowired
    private IBuildScaffoldService buildScaffoldService;
    @Autowired
    private IBuildStimulateService buildStimulateService;
    @Autowired
    private IBuildMeasureService buildMeasureService;
    @Autowired
    private IBuildManageService buildManageService;
    @Autowired
    private IBuildFeesService buildFeesService;
    @Autowired
    private IBuildOtherService buildOtherService;
    @Autowired
    private IDutyService dutyService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<BuildDutyVO> saveOrUpdate(BuildDutyVO saveOrUpdateVO) {
        List<BuildPlansEntity> dutyPlansEntityList;
        BuildDutyEntity entity = (BuildDutyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BuildDutyEntity.class));
        if (entity.getLastDutyId() != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getFirstImportId, (Object)entity.getBaseDutyId());
            queryWrapper.isNotNull(DutyEntity::getLastDutyId);
            queryWrapper.notIn(DutyEntity::getBillState, new Object[]{"1,3"});
            if (this.dutyService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u5b58\u5728\u53d8\u66f4\u4e2d\u7684\u3010\u76ee\u6807\u8d23\u4efb\u6210\u672c\u3011\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u53d8\u66f4\uff01");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getProjectId, (Object)entity.getProjectId());
            if (this.dutyService.count((Wrapper)queryWrapper) > 1) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e\uff01");
            }
        }
        if (null == entity.getDutyVersion()) {
            entity.setDutyVersion(1);
        }
        entity = this.countMny(entity);
        entity.setConvertFlag(0);
        super.saveOrUpdate((Object)entity, false);
        if (entity.getBaseDutyId() == null && 0 == entity.getChangeState()) {
            entity.setBaseDutyId(entity.getId());
            entity.setOneTime(entity.getCreateTime());
        }
        if (entity.getLastDutyId() != null) {
            BuildDutyEntity revise = (BuildDutyEntity)((Object)super.getById((Serializable)entity.getLastDutyId()));
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            super.saveOrUpdate((Object)revise);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildPlansList()) && CollectionUtils.isNotEmpty(dutyPlansEntityList = entity.getBuildPlansList())) {
            this.buildPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
        }
        super.updateById((Object)entity);
        this.updateByPid(entity);
        BuildDutyVO vo = this.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private BuildDutyEntity countMny(BuildDutyEntity entity) {
        BigDecimal totalTaxMny1 = BigDecimal.ZERO;
        BigDecimal totalTaxMny2 = BigDecimal.ZERO;
        BigDecimal indirectTaxMny = BigDecimal.ZERO;
        BigDecimal stimulateTaxMny = BigDecimal.ZERO;
        BigDecimal rgcostTaxMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        BigDecimal templatesTaxMny = BigDecimal.ZERO;
        BigDecimal scaffoldTaxMny = BigDecimal.ZERO;
        BigDecimal appointTaxMny = BigDecimal.ZERO;
        BigDecimal subTaxMny = BigDecimal.ZERO;
        BigDecimal equipmentTaxMny = BigDecimal.ZERO;
        BigDecimal safeTaxMny1 = BigDecimal.ZERO;
        BigDecimal safeTaxMny2 = BigDecimal.ZERO;
        BigDecimal safeTaxMny3 = BigDecimal.ZERO;
        BigDecimal safeTaxMny4 = BigDecimal.ZERO;
        BigDecimal nightTaxMny1 = BigDecimal.ZERO;
        BigDecimal nightTaxMny2 = BigDecimal.ZERO;
        BigDecimal completeTaxMny = BigDecimal.ZERO;
        BigDecimal precipitationTaxMny = BigDecimal.ZERO;
        BigDecimal measureTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getBuildRgcostList())) {
            rgcostTaxMny = entity.getBuildRgcostList().stream().filter(e -> e.getRgcostTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getRgcostTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)rgcostTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildMaterialList())) {
            materialTaxMny = entity.getBuildMaterialList().stream().filter(e -> e.getMaterialTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getMaterialTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)materialTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildTemplatesList())) {
            templatesTaxMny = entity.getBuildTemplatesList().stream().filter(e -> e.getTemplatesTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getTemplatesTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)templatesTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildScaffoldList())) {
            scaffoldTaxMny = entity.getBuildScaffoldList().stream().filter(e -> e.getScaffoldTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getScaffoldTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)scaffoldTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildAppointList())) {
            appointTaxMny = entity.getBuildAppointList().stream().filter(e -> e.getAppointTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getAppointTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)appointTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildSubList())) {
            subTaxMny = entity.getBuildSubList().stream().filter(e -> e.getSubTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getSubTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)subTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildEquipmentList())) {
            equipmentTaxMny = entity.getBuildEquipmentList().stream().filter(e -> e.getEquipmentTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getEquipmentTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny1 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny1, (BigDecimal)equipmentTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildSafeList())) {
            safeTaxMny1 = entity.getBuildSafeList().stream().filter(e -> e.getSafeTaxMny() != null && e.getParentId() != null && e.getSafeName().equals("\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39")).map(it -> it.getSafeTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            safeTaxMny2 = entity.getBuildSafeList().stream().filter(e -> e.getSafeTaxMny() != null && e.getParentId() != null && e.getSafeName().equals("\u73af\u5883\u4fdd\u62a4\u8d39")).map(it -> it.getSafeTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            safeTaxMny3 = entity.getBuildSafeList().stream().filter(e -> e.getSafeTaxMny() != null && e.getParentId() != null && e.getSafeName().equals("\u4e34\u65f6\u8bbe\u65bd")).map(it -> it.getSafeTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            safeTaxMny4 = entity.getBuildSafeList().stream().filter(e -> e.getSafeTaxMny() != null && e.getParentId() != null && e.getSafeName().equals("\u4e8c\u6b21\u642c\u8fd0")).map(it -> it.getSafeTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalSafeTaxMny = entity.getBuildSafeList().stream().filter(e -> e.getSafeTaxMny() != null && e.getLeafFlag() != false).map(it -> it.getSafeTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny2 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny2, (BigDecimal)totalSafeTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildNightList())) {
            for (BuildNightEntity nightEntity : entity.getBuildNightList()) {
                switch (nightEntity.getNightName()) {
                    case "\u51ac\u96e8\u5b63\u65bd\u5de5\u8d39": {
                        nightTaxMny1 = nightEntity.getNightTaxMny();
                        totalTaxMny2 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny2, (BigDecimal)nightTaxMny1);
                        break;
                    }
                    case "\u591c\u95f4\u65bd\u5de5\u8d39": {
                        nightTaxMny2 = nightEntity.getNightTaxMny();
                        totalTaxMny2 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny2, (BigDecimal)nightTaxMny2);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildCompleteList())) {
            completeTaxMny = entity.getBuildCompleteList().stream().filter(e -> e.getCompleteTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getCompleteTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny2 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny2, (BigDecimal)completeTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildPrecipitationList())) {
            precipitationTaxMny = entity.getBuildPrecipitationList().stream().filter(e -> e.getPrecipitationTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getPrecipitationTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny2 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny2, (BigDecimal)precipitationTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildMeasureList())) {
            measureTaxMny = entity.getBuildMeasureList().stream().filter(e -> e.getMeasureTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getMeasureTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTaxMny2 = ComputeUtil.safeAdd((BigDecimal)totalTaxMny2, (BigDecimal)measureTaxMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildIndirectList())) {
            indirectTaxMny = entity.getBuildIndirectList().stream().filter(e -> e.getIndirectTaxMny() != null && (null == e.getLeafFlag() || e.getLeafFlag() != false)).map(it -> it.getIndirectTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildStimulateList())) {
            stimulateTaxMny = entity.getBuildStimulateList().stream().filter(e -> e.getStimulateTaxMny() != null && null != e.getLeafFlag() && e.getLeafFlag() != false).map(it -> it.getStimulateTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        for (BuildPlansEntity plansEntity : entity.getBuildPlansList()) {
            switch (plansEntity.getPlansName()) {
                case "\u4eba\u5de5\u8d39": {
                    plansEntity.setPlansTaxMny(rgcostTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u6750\u6599\u8d39": {
                    plansEntity.setPlansTaxMny(materialTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u6a21\u677f\u53ca\u652f\u6491": {
                    plansEntity.setPlansTaxMny(templatesTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u811a\u624b\u67b6": {
                    plansEntity.setPlansTaxMny(scaffoldTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u7532\u65b9\u6307\u5b9a\u5206\u5305\u9879\u76ee": {
                    plansEntity.setPlansTaxMny(appointTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u8d39": {
                    plansEntity.setPlansTaxMny(subTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u65bd\u5de5\u673a\u5177\u4f7f\u7528\u8d39": {
                    plansEntity.setPlansTaxMny(equipmentTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny1);
                    break;
                }
                case "\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39": {
                    plansEntity.setPlansTaxMny(safeTaxMny1);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u73af\u5883\u4fdd\u62a4\u8d39": {
                    plansEntity.setPlansTaxMny(safeTaxMny2);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u4e34\u65f6\u8bbe\u65bd": {
                    plansEntity.setPlansTaxMny(safeTaxMny3);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u4e8c\u6b21\u642c\u8fd0": {
                    plansEntity.setPlansTaxMny(safeTaxMny4);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u51ac\u96e8\u5b63\u65bd\u5de5\u8d39": {
                    plansEntity.setPlansTaxMny(nightTaxMny1);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u591c\u95f4\u65bd\u5de5\u8d39": {
                    plansEntity.setPlansTaxMny(nightTaxMny2);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u5df2\u5b8c\u5de5\u7a0b\u53ca\u8bbe\u5907\u4fdd\u62a4": {
                    plansEntity.setPlansTaxMny(completeTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u6392\u3001\u964d\u6c34": {
                    plansEntity.setPlansTaxMny(precipitationTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u5176\u4ed6\u63aa\u65bd\u8d39": {
                    plansEntity.setPlansTaxMny(measureTaxMny);
                    plansEntity.setPlansCountTaxMny(totalTaxMny2);
                    break;
                }
                case "\u95f4\u63a5\u8d39": {
                    plansEntity.setPlansTaxMny(indirectTaxMny);
                    plansEntity.setPlansCountTaxMny(indirectTaxMny);
                    break;
                }
                case "\u9879\u76ee\u6fc0\u52b1\u5956": {
                    plansEntity.setPlansTaxMny(stimulateTaxMny);
                    plansEntity.setPlansCountTaxMny(stimulateTaxMny);
                }
            }
        }
        return entity;
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long dutyId = null;
        if (!StringUtils.isNotEmpty((CharSequence)request.getParameter("dutyId"))) {
            return CommonResponse.error((String)"\u4e3b\u8868\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        dutyId = Long.valueOf(request.getParameter("dutyId"));
        BuildDutyEntity buildDutyEntity = (BuildDutyEntity)((Object)super.selectById((Serializable)dutyId));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader2.getNumberOfSheets(mf);
        this.logger.error("\u6587\u4ef6\u9875\u7b7e\u6570\uff1a" + JSONObject.toJSONString((Object)size));
        if (size == null || size != 22) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u6570\u5e94\u8be5\u4e3a22\u4e2a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u9690\u85cf\u9875\u7b7e\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
        List<List<String>> result1 = resList.get(0);
        if (result1.size() > 0 && result1.get(0).size() < 5) {
            return CommonResponse.error((String)"[\u9879\u76ee\u9884\u8ba1\u603b\u6210\u672c\u6d4b\u7b97\u6c47\u603b\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result2 = resList.get(1);
        if (result2.size() > 0 && result2.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u4eba\u5de5\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result3 = resList.get(3);
        if (result3.size() > 0 && result3.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u6750\u6599\u8d39\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result4 = resList.get(5);
        if (result4.size() > 0 && result4.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u7532\u6307\u5206\u5305\u9879\u76ee\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result5 = resList.get(6);
        if (result5.size() > 0 && result5.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u4e13\u4e1a\u5206\u5305\u5de5\u7a0b\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result6 = resList.get(7);
        if (result6.size() > 0 && result6.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u65bd\u5de5\u673a\u5177\u4f7f\u7528\u8d39\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result7 = resList.get(8);
        if (result7.size() > 0 && result7.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39\u3001\u73af\u5883\u4fdd\u62a4\u8d39\u3001\u4e34\u65f6\u8bbe\u65bd\u53ca\u4e8c\u6b21\u642c\u8fd0\u8d39\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result8 = resList.get(9);
        if (result8.size() > 0 && result8.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u51ac\u96e8\u5b63\u3001\u591c\u95f4\u65bd\u5de5\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result9 = resList.get(10);
        if (result9.size() > 0 && result9.get(0).size() < 9) {
            return CommonResponse.error((String)"[\u9879\u76ee\u5df2\u5b8c\u5de5\u7a0b\u53ca\u8bbe\u5907\u4fdd\u62a4\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result10 = resList.get(11);
        if (result10.size() > 0 && result10.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u65bd\u5de5\u6392\u6c34\u3001\u964d\u6c34\u8d39\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result11 = resList.get(12);
        if (result11.size() > 0 && result11.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u9879\u76ee\u6a21\u677f\u53ca\u652f\u6491\u8d39\u7528\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result12 = resList.get(13);
        if (result12.size() > 0 && result12.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u9879\u76ee\u811a\u624b\u67b6\u8d39\u7528\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result13 = resList.get(14);
        if (result13.size() > 0 && result13.get(0).size() < 9) {
            return CommonResponse.error((String)"[\u9879\u76ee\u5176\u4ed6\u63aa\u65bd\u8d39\u6d4b\u7b97\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result14 = resList.get(15);
        if (result14.size() > 0 && result14.get(0).size() < 10) {
            return CommonResponse.error((String)"[\u9879\u76ee\u95f4\u63a5\u8d39]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result15 = resList.get(16);
        if (result15.size() > 0 && result15.get(0).size() < 9) {
            return CommonResponse.error((String)"[\u9879\u76ee\u6fc0\u52b1\u5956]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ImportBuildVo importVo1 = this.excelImportPlan(result1, dutyId);
        ImportBuildVo importVo2 = this.excelImportRgcost(result2, dutyId);
        ImportBuildVo importVo3 = this.excelImportMaterial(result3, dutyId);
        ImportBuildVo importVo4 = this.excelImportAppoint(result4, dutyId);
        ImportBuildVo importVo5 = this.excelImportSub(result5, dutyId);
        ImportBuildVo importVo6 = this.excelImportEquipment(result6, dutyId);
        ImportBuildVo importVo7 = this.excelImportSafe(result7, dutyId);
        ImportBuildVo importVo8 = this.excelImportNight(result8, dutyId);
        ImportBuildVo importVo9 = this.excelImportComplete(result9, dutyId);
        ImportBuildVo importVo10 = this.excelImportPrecipitation(result10, dutyId);
        ImportBuildVo importVo11 = this.excelImportTemplates(result11, dutyId);
        ImportBuildVo importVo12 = this.excelImportScaffold(result12, dutyId);
        ImportBuildVo importVo13 = this.excelImportMeasure(result13, dutyId);
        ImportBuildVo importVo14 = this.excelImportIndirect(result14, dutyId);
        ImportBuildVo importVo15 = this.excelImportStimulate(result15, dutyId);
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        errorList.addAll(importVo1.getErrorList());
        errorList.addAll(importVo2.getErrorList());
        errorList.addAll(importVo3.getErrorList());
        errorList.addAll(importVo4.getErrorList());
        errorList.addAll(importVo5.getErrorList());
        errorList.addAll(importVo6.getErrorList());
        errorList.addAll(importVo7.getErrorList());
        errorList.addAll(importVo8.getErrorList());
        errorList.addAll(importVo9.getErrorList());
        errorList.addAll(importVo10.getErrorList());
        errorList.addAll(importVo11.getErrorList());
        errorList.addAll(importVo12.getErrorList());
        errorList.addAll(importVo13.getErrorList());
        errorList.addAll(importVo14.getErrorList());
        errorList.addAll(importVo15.getErrorList());
        if (errorList.size() > 0) {
            resp.put("successList", null);
            resp.put("successNum", (Object)0);
            resp.put("errorNum", (Object)errorList.size());
            if (errorList.size() > 100) {
                resp.put("errorList", errorList.subList(0, 100));
            } else {
                resp.put("errorList", errorList);
            }
        } else {
            List<BuildPlansVO> buildPlansList = importVo1.getBuildPlansList();
            List<BuildRgcostVO> buildRgcostList = importVo2.getBuildRgcostList();
            List<BuildMaterialVO> buildMaterialList = importVo3.getBuildMaterialList();
            List<BuildAppointVO> buildAppointVOList = importVo4.getBuildAppointVOList();
            List<BuildSubVO> buildSubList = importVo5.getBuildSubList();
            List<BuildEquipmentVO> buildEquipmentList = importVo6.getBuildEquipmentList();
            List<BuildSafeVO> buildSafeList = importVo7.getBuildSafeList();
            List<BuildNightVO> buildNightList = importVo8.getBuildNightList();
            List<BuildCompleteVO> buildCompleteList = importVo9.getBuildCompleteList();
            List<BuildPrecipitationVO> buildPrecipitationList = importVo10.getBuildPrecipitationList();
            List<BuildTemplatesVO> buildTemplatesList = importVo11.getBuildTemplatesList();
            List<BuildScaffoldVO> buildScaffoldList = importVo12.getBuildScaffoldList();
            List<BuildMeasureVO> buildMeasureList = importVo13.getBuildMeasureList();
            List<BuildIndirectVO> buildIndirectList = importVo14.getBuildIndirectList();
            List<BuildStimulateVO> buildStimulateList = importVo15.getBuildStimulateList();
            int sucNum = buildPlansList.size() + buildRgcostList.size() + buildSubList.size() + buildMaterialList.size() + buildAppointVOList.size() + buildEquipmentList.size() + buildSafeList.size() + buildNightList.size() + buildNightList.size() + buildCompleteList.size() + buildPrecipitationList.size() + buildTemplatesList.size() + buildScaffoldList.size() + buildIndirectList.size() + buildStimulateList.size();
            resp.put("successList", null);
            resp.put("errorList", null);
            resp.put("successNum", (Object)sucNum);
            resp.put("errorNum", (Object)0);
            this.buildPlansService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildPlansList.size() > 0) {
                List buildPlansEntities = BeanMapper.mapList(buildPlansList, BuildPlansEntity.class);
                this.buildPlansService.saveOrUpdateBatch(buildPlansEntities, buildPlansEntities.size(), false);
                for (BuildPlansEntity e : buildPlansEntities) {
                    if ("\u5de5\u7a0b\u9879\u76ee\u9884\u8ba1\u603b\u6210\u672c(\u65e0\u7a0e)".equals(e.getFeeCategoryName())) {
                        buildDutyEntity.setMny(e.getPlansCountTaxMny());
                    }
                    if (!"\u5de5\u7a0b\u9879\u76ee\u9884\u8ba1\u603b\u6210\u672c(\u542b\u7a0e)".equals(e.getFeeCategoryName())) continue;
                    buildDutyEntity.setTaxMny(e.getPlansCountTaxMny());
                }
                buildDutyEntity.setConvertFlag(0);
                super.updateById((Object)buildDutyEntity);
            }
            this.buildRgcostService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildRgcostList.size() > 0) {
                List buildRgcostEntities = BeanMapper.mapList(buildRgcostList, BuildRgcostEntity.class);
                this.buildRgcostService.saveOrUpdateBatch(buildRgcostEntities, buildRgcostEntities.size(), false);
            }
            this.buildMaterialService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildMaterialList.size() > 0) {
                List buildMaterialEntities = BeanMapper.mapList(buildMaterialList, BuildMaterialEntity.class);
                this.buildMaterialService.saveOrUpdateBatch(buildMaterialEntities, buildMaterialEntities.size(), false);
            }
            this.buildAppointService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildAppointVOList.size() > 0) {
                List buildAppointEntities = BeanMapper.mapList(buildAppointVOList, BuildAppointEntity.class);
                this.buildAppointService.saveOrUpdateBatch(buildAppointEntities, buildAppointEntities.size(), false);
            }
            this.buildSubService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildSubList.size() > 0) {
                List buildSubEntities = BeanMapper.mapList(buildSubList, BuildSubEntity.class);
                this.buildSubService.saveOrUpdateBatch(buildSubEntities, buildSubEntities.size(), false);
            }
            this.buildEquipmentService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildEquipmentList.size() > 0) {
                List buildEquipmentEntities = BeanMapper.mapList(buildEquipmentList, BuildEquipmentEntity.class);
                this.buildEquipmentService.saveOrUpdateBatch(buildEquipmentEntities, buildEquipmentEntities.size(), false);
            }
            this.buildSafeService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildSafeList.size() > 0) {
                List buildSafeEntities = BeanMapper.mapList(buildSafeList, BuildSafeEntity.class);
                this.buildSafeService.saveOrUpdateBatch(buildSafeEntities, buildSafeEntities.size(), false);
            }
            this.buildNightService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildNightList.size() > 0) {
                List buildNightEntities = BeanMapper.mapList(buildNightList, BuildNightEntity.class);
                this.buildNightService.saveOrUpdateBatch(buildNightEntities, buildNightEntities.size(), false);
            }
            this.buildCompleteService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildCompleteList.size() > 0) {
                List buildCompleteEntities = BeanMapper.mapList(buildCompleteList, BuildCompleteEntity.class);
                this.buildCompleteService.saveOrUpdateBatch(buildCompleteEntities, buildCompleteEntities.size(), false);
            }
            this.buildPrecipitationService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildPrecipitationList.size() > 0) {
                List buildPrecipitationEntities = BeanMapper.mapList(buildPrecipitationList, BuildPrecipitationEntity.class);
                this.buildPrecipitationService.saveOrUpdateBatch(buildPrecipitationEntities, buildPrecipitationEntities.size(), false);
            }
            this.buildTemplatesService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildTemplatesList.size() > 0) {
                List buildTemplatesEntities = BeanMapper.mapList(buildTemplatesList, BuildTemplatesEntity.class);
                this.buildTemplatesService.saveOrUpdateBatch(buildTemplatesEntities, buildTemplatesEntities.size(), false);
            }
            this.buildScaffoldService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildScaffoldList.size() > 0) {
                List buildScaffoldEntities = BeanMapper.mapList(buildScaffoldList, BuildScaffoldEntity.class);
                this.buildScaffoldService.saveOrUpdateBatch(buildScaffoldEntities, buildScaffoldEntities.size(), false);
            }
            this.buildIndirectService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildIndirectList.size() > 0) {
                List buildIndirectEntities = BeanMapper.mapList(buildIndirectList, BuildIndirectEntity.class);
                this.buildIndirectService.saveOrUpdateBatch(buildIndirectEntities, buildIndirectEntities.size(), false);
            }
            this.buildStimulateService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildStimulateList.size() > 0) {
                List buildStimulateEntities = BeanMapper.mapList(buildStimulateList, BuildStimulateEntity.class);
                this.buildStimulateService.saveOrUpdateBatch(buildStimulateEntities, buildStimulateEntities.size(), false);
            }
            this.buildMeasureService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildMeasureList.size() > 0) {
                List buildMeasureEntities = BeanMapper.mapList(buildMeasureList, BuildMeasureEntity.class);
                this.buildMeasureService.saveOrUpdateBatch(buildMeasureEntities, buildMeasureEntities.size(), false);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    @Override
    public BuildDutyVO queryDetail(Long id) {
        BuildDutyEntity entity = (BuildDutyEntity)((Object)super.selectById((Serializable)id));
        BuildDutyVO vo = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class));
        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();
        vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        List<BuildSubVO> buildSubList = vo.getBuildSubList();
        vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList();
        vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList();
        vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(buildEquipmentList));
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList();
        vo.setBuildSafeList(TreeNodeBUtil.buildTree(buildSafeList));
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList();
        vo.setBuildMeasureList(TreeNodeBUtil.buildTree(buildMeasureList));
        List<BuildIndirectVO> buildIndirectList = vo.getBuildIndirectList();
        vo.setBuildIndirectList(TreeNodeBUtil.buildTree(buildIndirectList));
        List<BuildScaffoldVO> buildScaffoldList = vo.getBuildScaffoldList();
        vo.setBuildScaffoldList(TreeNodeBUtil.buildTree(buildScaffoldList));
        List<BuildTemplatesVO> buildTemplatesList = vo.getBuildTemplatesList();
        vo.setBuildTemplatesList(TreeNodeBUtil.buildTree(buildTemplatesList));
        List<BuildPrecipitationVO> buildPrecipitationList = vo.getBuildPrecipitationList();
        vo.setBuildPrecipitationList(TreeNodeBUtil.buildTree(buildPrecipitationList));
        List<BuildCompleteVO> buildCompleteList = vo.getBuildCompleteList();
        vo.setBuildCompleteList(TreeNodeBUtil.buildTree(buildCompleteList));
        List<BuildNightVO> buildNightList = vo.getBuildNightList();
        vo.setBuildNightList(TreeNodeBUtil.buildTree(buildNightList));
        List<BuildAppointVO> buildAppointList = vo.getBuildAppointList();
        vo.setBuildAppointList(TreeNodeBUtil.buildTree(buildAppointList));
        List<BuildDutyRecordVO> list = new ArrayList<BuildDutyRecordVO>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BuildDutyEntity::getBaseDutyId, (Object)entity.getBaseDutyId());
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(BuildDutyEntity::getBillState, billStatusList);
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List roadbridgeDutyEntities = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)roadbridgeDutyEntities)) {
            list = BeanMapper.mapList((Iterable)roadbridgeDutyEntities, BuildDutyRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public BuildDutyVO queryChangeDetail(Long id) {
        List<BuildAppointVO> list;
        List<BuildNightVO> list2;
        List<BuildCompleteVO> list3;
        List<BuildPrecipitationVO> list4;
        List<BuildTemplatesVO> list5;
        List<BuildScaffoldVO> list6;
        List<BuildMeasureVO> list7;
        List<BuildIndirectVO> list8;
        List<BuildSafeVO> list9;
        List<BuildEquipmentVO> list10;
        List<BuildStimulateVO> list11;
        List<BuildMaterialVO> buildMaterialList;
        List<BuildSubVO> buildSubList;
        List<BuildRgcostVO> buildRgcostList;
        BuildDutyEntity entity = (BuildDutyEntity)((Object)super.selectById((Serializable)id));
        BuildDutyVO vo = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class));
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);
        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList();
        if (CollectionUtils.isNotEmpty(buildPlansList)) {
            buildPlansList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setBuildPlansList(buildPlansList);
        }
        if (CollectionUtils.isNotEmpty(buildRgcostList = vo.getBuildRgcostList())) {
            HashMap idMap = new HashMap();
            buildRgcostList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildRgcostVO buildRgcostVO : buildRgcostList) {
                if (null != buildRgcostVO.getParentId()) {
                    buildRgcostVO.setParentId((Long)idMap.get(buildRgcostVO.getParentId()));
                }
                buildRgcostVO.setTid(buildRgcostVO.getId());
            }
            vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        }
        if (CollectionUtils.isNotEmpty(buildSubList = vo.getBuildSubList())) {
            HashMap idMap = new HashMap();
            buildSubList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildSubVO buildSubVO : buildSubList) {
                if (null != buildSubVO.getParentId()) {
                    buildSubVO.setParentId((Long)idMap.get(buildSubVO.getParentId()));
                }
                buildSubVO.setTid(buildSubVO.getId());
            }
            vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        }
        if (CollectionUtils.isNotEmpty(buildMaterialList = vo.getBuildMaterialList())) {
            HashMap hashMap = new HashMap();
            buildMaterialList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildMaterialVO buildMaterialVO : buildMaterialList) {
                if (null != buildMaterialVO.getParentId()) {
                    buildMaterialVO.setParentId((Long)hashMap.get(buildMaterialVO.getParentId()));
                }
                buildMaterialVO.setTid(buildMaterialVO.getId());
            }
            vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        }
        if (CollectionUtils.isNotEmpty(list11 = vo.getBuildStimulateList())) {
            HashMap hashMap = new HashMap();
            list11.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildStimulateVO buildStimulateVO : list11) {
                buildStimulateVO.setTid(buildStimulateVO.getId());
            }
            vo.setBuildStimulateList(list11);
        }
        if (CollectionUtils.isNotEmpty(list10 = vo.getBuildEquipmentList())) {
            HashMap hashMap = new HashMap();
            list10.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildEquipmentVO buildEquipmentVO : list10) {
                if (null != buildEquipmentVO.getParentId()) {
                    buildEquipmentVO.setParentId((Long)hashMap.get(buildEquipmentVO.getParentId()));
                }
                buildEquipmentVO.setTid(buildEquipmentVO.getId());
            }
            vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(list10));
        }
        if (CollectionUtils.isNotEmpty(list9 = vo.getBuildSafeList())) {
            HashMap hashMap = new HashMap();
            list9.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildSafeVO buildSafeVO : list9) {
                if (null != buildSafeVO.getParentId()) {
                    buildSafeVO.setParentId((Long)hashMap.get(buildSafeVO.getParentId()));
                }
                buildSafeVO.setTid(buildSafeVO.getId());
            }
            vo.setBuildSafeList(TreeNodeBUtil.buildTree(list9));
        }
        if (CollectionUtils.isNotEmpty(list8 = vo.getBuildIndirectList())) {
            HashMap hashMap = new HashMap();
            list8.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildIndirectVO buildIndirectVO : list8) {
                buildIndirectVO.setTid(buildIndirectVO.getId());
            }
            vo.setBuildIndirectList(list8);
        }
        if (CollectionUtils.isNotEmpty(list7 = vo.getBuildMeasureList())) {
            HashMap hashMap = new HashMap();
            list7.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildMeasureVO buildMeasureVO : list7) {
                if (null != buildMeasureVO.getParentId()) {
                    buildMeasureVO.setParentId((Long)hashMap.get(buildMeasureVO.getParentId()));
                }
                buildMeasureVO.setTid(buildMeasureVO.getId());
            }
            vo.setBuildMeasureList(TreeNodeBUtil.buildTree(list7));
        }
        if (CollectionUtils.isNotEmpty(list6 = vo.getBuildScaffoldList())) {
            HashMap hashMap = new HashMap();
            list6.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildScaffoldVO buildScaffoldVO : list6) {
                if (null != buildScaffoldVO.getParentId()) {
                    buildScaffoldVO.setParentId((Long)hashMap.get(buildScaffoldVO.getParentId()));
                }
                buildScaffoldVO.setTid(buildScaffoldVO.getId());
            }
            vo.setBuildScaffoldList(TreeNodeBUtil.buildTree(list6));
        }
        if (CollectionUtils.isNotEmpty(list5 = vo.getBuildTemplatesList())) {
            HashMap hashMap = new HashMap();
            list5.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildTemplatesVO buildTemplatesVO : list5) {
                if (null != buildTemplatesVO.getParentId()) {
                    buildTemplatesVO.setParentId((Long)hashMap.get(buildTemplatesVO.getParentId()));
                }
                buildTemplatesVO.setTid(buildTemplatesVO.getId());
            }
            vo.setBuildTemplatesList(TreeNodeBUtil.buildTree(list5));
        }
        if (CollectionUtils.isNotEmpty(list4 = vo.getBuildPrecipitationList())) {
            HashMap hashMap = new HashMap();
            list4.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildPrecipitationVO buildPrecipitationVO : list4) {
                if (null != buildPrecipitationVO.getParentId()) {
                    buildPrecipitationVO.setParentId((Long)hashMap.get(buildPrecipitationVO.getParentId()));
                }
                buildPrecipitationVO.setTid(buildPrecipitationVO.getId());
            }
            vo.setBuildPrecipitationList(TreeNodeBUtil.buildTree(list4));
        }
        if (CollectionUtils.isNotEmpty(list3 = vo.getBuildCompleteList())) {
            HashMap hashMap = new HashMap();
            list3.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildCompleteVO buildCompleteVO : list3) {
                if (null != buildCompleteVO.getParentId()) {
                    buildCompleteVO.setParentId((Long)hashMap.get(buildCompleteVO.getParentId()));
                }
                buildCompleteVO.setTid(buildCompleteVO.getId());
            }
            vo.setBuildCompleteList(TreeNodeBUtil.buildTree(list3));
        }
        if (CollectionUtils.isNotEmpty(list2 = vo.getBuildNightList())) {
            HashMap hashMap = new HashMap();
            list2.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildNightVO cdEntity : list2) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)hashMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildNightList(TreeNodeBUtil.buildTree(list2));
        }
        if (CollectionUtils.isNotEmpty(list = vo.getBuildAppointList())) {
            HashMap hashMap = new HashMap();
            list.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildAppointVO cdEntity : list) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)hashMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildAppointList(TreeNodeBUtil.buildTree(list));
        }
        return vo;
    }

    @Override
    public BuildDutyVO ConvertFlag(Long id) {
        BuildDutyEntity entity = (BuildDutyEntity)((Object)super.selectById((Serializable)id));
        entity.setConvertFlag(1);
        super.updateById((Object)entity);
        BuildDutyVO vo = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class));
        this.dutyService.pushFromImport(vo, false, ConversionEnum.\u9655\u5efa\u623f\u5efa.getCode());
        return this.queryDetail(id);
    }

    @Override
    public CommonResponse<String> deleteVos(List<BuildDutyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BuildDutyVO dutyVO : vos) {
                BuildDutyEntity dutyEntity = (BuildDutyEntity)((Object)super.getById((Serializable)dutyVO.getId()));
                if (dutyEntity.getLastDutyId() != null) {
                    BuildDutyEntity revise = (BuildDutyEntity)((Object)super.getById((Serializable)dutyEntity.getLastDutyId()));
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
                    revise.setLatestFlag(true);
                    super.saveOrUpdate((Object)revise);
                }
                this.dutyService.deleteFromImport(dutyVO.getId(), ConversionEnum.\u9655\u5efa\u623f\u5efa.getCode());
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private ImportBuildVo excelImportPlan(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<BuildPlansVO> detailVoList = new ArrayList<BuildPlansVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BuildPlansVO vo = new BuildPlansVO();
                boolean flag = false;
                String warnType = "";
                String feeCategoryName = datas.get(1);
                String plansName = datas.get(2);
                String plansTaxMny = datas.get(3);
                String plansCountTaxMny = datas.get(4);
                String plansMemo = datas.get(5);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isEmpty((CharSequence)feeCategoryName)) {
                    vo.setFeeCategoryName(null);
                } else {
                    vo.setFeeCategoryName(feeCategoryName);
                }
                if (i != 26) {
                    if (StringUtils.isEmpty((CharSequence)plansName)) {
                        vo.setPlansName(null);
                        warnType = warnType + "[\u8d39\u7528\u540d\u79f0\u4e3a\u7a7a]";
                        flag = true;
                    } else {
                        vo.setPlansName(plansName.trim());
                    }
                } else if (StringUtils.isEmpty((CharSequence)plansName)) {
                    vo.setPlansName(null);
                } else {
                    vo.setPlansName(plansName);
                }
                if (StringUtils.isEmpty((CharSequence)plansTaxMny)) {
                    vo.setPlansTaxMny(null);
                } else {
                    try {
                        vo.setPlansTaxMny(new BigDecimal(plansTaxMny));
                    }
                    catch (Exception e) {
                        vo.setPlansTaxMny(null);
                        warnType = warnType + "[ \u91d1\u989d\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansCountTaxMny)) {
                    vo.setPlansCountTaxMny(null);
                } else {
                    try {
                        vo.setPlansCountTaxMny(new BigDecimal(plansCountTaxMny));
                    }
                    catch (Exception e) {
                        vo.setPlansCountTaxMny(null);
                        warnType = warnType + "[ \u91d1\u989d\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setPlansMemo(plansMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildPlansVO> successList = new ArrayList<BuildPlansVO>();
            for (BuildPlansVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("2-\u603b\u6210\u672c\u6d4b\u7b97\u6c47\u603b\u8868");
                errorVo.setId(vo.getId());
                errorVo.setName(vo.getPlansName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildPlansList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportRgcost(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildRgcostVO> detailVoList = new ArrayList<BuildRgcostVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildRgcostVO vo = new BuildRgcostVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String rgcostName = datas.get(2);
                if (StringUtils.isEmpty((CharSequence)rgcostName)) {
                    vo.setRgcostName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setRgcostName(rgcostName.trim());
                }
                if ("\u5408\u8ba1".equals(rgcostName)) continue;
                String rgcostCode = datas.get(1);
                String rgcostUnitName = datas.get(3);
                String rgcostCount = datas.get(4);
                String rgcostTaxPrice = datas.get(5);
                String rgcostRate = datas.get(6);
                String rgcostPrice = datas.get(7);
                String rgcostMny = datas.get(8);
                String rgcostTax = datas.get(9);
                String rgcostMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)rgcostCode)) {
                    vo.setRgcostCode(null);
                } else {
                    vo.setRgcostCode(rgcostCode);
                }
                vo.setRgcostUnitName(rgcostUnitName);
                if (StringUtils.isEmpty((CharSequence)rgcostCount)) {
                    vo.setRgcostNum(null);
                } else {
                    try {
                        vo.setRgcostNum(new BigDecimal(rgcostCount));
                    }
                    catch (Exception e) {
                        vo.setRgcostNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostTaxPrice)) {
                    vo.setRgcostTaxPrice(null);
                } else {
                    try {
                        vo.setRgcostTaxPrice(new BigDecimal(rgcostTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setRgcostTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostTaxPrice)) {
                    vo.setRgcostTaxPrice(null);
                } else {
                    try {
                        vo.setRgcostTaxPrice(new BigDecimal(rgcostTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setRgcostTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostRate)) {
                    vo.setRgcostRate(null);
                } else {
                    try {
                        vo.setRgcostRate(new BigDecimal(rgcostRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setRgcostRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostPrice)) {
                    vo.setRgcostPrice(null);
                } else {
                    try {
                        vo.setRgcostPrice(new BigDecimal(rgcostPrice));
                    }
                    catch (Exception e) {
                        vo.setRgcostPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostMny)) {
                    vo.setRgcostMny(null);
                } else {
                    try {
                        vo.setRgcostMny(new BigDecimal(rgcostMny));
                    }
                    catch (Exception e) {
                        vo.setRgcostMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostTax)) {
                    vo.setRgcostTax(null);
                } else {
                    try {
                        vo.setRgcostTax(new BigDecimal(rgcostTax));
                    }
                    catch (Exception e) {
                        vo.setRgcostTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setRgcostTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getRgcostNum(), (BigDecimal)vo.getRgcostTaxPrice()));
                vo.setRgcostMemo(rgcostMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildRgcostVO> successList = new ArrayList<BuildRgcostVO>();
            for (BuildRgcostVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("3-\u4eba\u5de5\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getRgcostCode());
                errorVo.setName(vo.getRgcostName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildRgcostList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportSub(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildSubVO> detailVoList = new ArrayList<BuildSubVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildSubVO vo = new BuildSubVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String subCode = datas.get(1);
                String subName = datas.get(2);
                if (StringUtils.isEmpty((CharSequence)subName)) {
                    vo.setSubName(null);
                    warnType = warnType + "[\u6750\u6599\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSubName(subName.trim());
                }
                if ("\u5408\u8ba1".equals(subName)) continue;
                String subUnitName = datas.get(3);
                String subNum = datas.get(4);
                String subTaxPrice = datas.get(5);
                String subRate = datas.get(6);
                String subPrice = datas.get(7);
                String subMny = datas.get(8);
                String subTax = datas.get(9);
                String subMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        System.out.println("hahaha");
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)subCode)) {
                    vo.setSubCode(null);
                } else {
                    vo.setSubCode(subCode);
                }
                vo.setSubUnitName(subUnitName);
                if (StringUtils.isEmpty((CharSequence)subNum)) {
                    vo.setSubNum(null);
                } else {
                    try {
                        vo.setSubNum(new BigDecimal(subNum));
                    }
                    catch (Exception e) {
                        vo.setSubNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subTaxPrice)) {
                    vo.setSubTaxPrice(null);
                } else {
                    try {
                        vo.setSubTaxPrice(new BigDecimal(subTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setSubTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subRate)) {
                    vo.setSubRate(null);
                } else {
                    try {
                        vo.setSubRate(new BigDecimal(subRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setSubRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subPrice)) {
                    vo.setSubPrice(null);
                } else {
                    try {
                        vo.setSubPrice(new BigDecimal(subPrice));
                    }
                    catch (Exception e) {
                        vo.setSubPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subMny)) {
                    vo.setSubMny(null);
                } else {
                    try {
                        vo.setSubMny(new BigDecimal(subMny));
                    }
                    catch (Exception e) {
                        vo.setSubMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subTax)) {
                    vo.setSubTax(null);
                } else {
                    try {
                        vo.setSubTax(new BigDecimal(subTax));
                    }
                    catch (Exception e) {
                        vo.setSubTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setSubMemo(subMemo);
                vo.setSubTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getSubNum(), (BigDecimal)vo.getSubTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildSubVO> successList = new ArrayList<BuildSubVO>();
            for (BuildSubVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("8-\u4e13\u4e1a\u5206\u5305");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getSubCode());
                errorVo.setName(vo.getSubName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildSubList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportAppoint(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildAppointVO> detailVoList = new ArrayList<BuildAppointVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildAppointVO vo = new BuildAppointVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String appointCode = datas.get(1);
                String appointName = datas.get(2);
                if (StringUtils.isEmpty((CharSequence)appointName)) {
                    vo.setAppointName(null);
                    warnType = warnType + "[\u6750\u6599\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setAppointName(appointName.trim());
                }
                if ("\u5408\u8ba1".equals(appointName)) continue;
                String appointUnitName = datas.get(3);
                String appointNum = datas.get(4);
                String appointTaxPrice = datas.get(5);
                String appointRate = datas.get(6);
                String appointPrice = datas.get(7);
                String appointMny = datas.get(8);
                String appointTax = datas.get(9);
                String appointMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)appointCode)) {
                    vo.setAppointCode(null);
                } else {
                    vo.setAppointCode(appointCode);
                }
                vo.setAppointUnitName(appointUnitName);
                if (StringUtils.isEmpty((CharSequence)appointNum)) {
                    vo.setAppointNum(null);
                } else {
                    try {
                        vo.setAppointNum(new BigDecimal(appointNum));
                    }
                    catch (Exception e) {
                        vo.setAppointNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appointTaxPrice)) {
                    vo.setAppointTaxPrice(null);
                } else {
                    try {
                        vo.setAppointTaxPrice(new BigDecimal(appointTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setAppointTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appointRate)) {
                    vo.setAppointRate(null);
                } else {
                    try {
                        vo.setAppointRate(new BigDecimal(appointRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setAppointRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appointPrice)) {
                    vo.setAppointPrice(null);
                } else {
                    try {
                        vo.setAppointPrice(new BigDecimal(appointPrice));
                    }
                    catch (Exception e) {
                        vo.setAppointPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appointMny)) {
                    vo.setAppointMny(null);
                } else {
                    try {
                        vo.setAppointMny(new BigDecimal(appointMny));
                    }
                    catch (Exception e) {
                        vo.setAppointMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appointTax)) {
                    vo.setAppointTax(null);
                } else {
                    try {
                        vo.setAppointTax(new BigDecimal(appointTax));
                    }
                    catch (Exception e) {
                        vo.setAppointTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setAppointMemo(appointMemo);
                vo.setAppointTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getAppointNum(), (BigDecimal)vo.getAppointTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildAppointVO> successList = new ArrayList<BuildAppointVO>();
            for (BuildAppointVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("7-\u7532\u6307\u5206\u5305");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getAppointCode());
                errorVo.setName(vo.getAppointName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildAppointVOList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportMaterial(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildMaterialVO> detailVoList = new ArrayList<BuildMaterialVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildMaterialVO vo = new BuildMaterialVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String materialCode = datas.get(1);
                String materialName = datas.get(2);
                if (StringUtils.isEmpty((CharSequence)materialName)) {
                    vo.setMaterialName(null);
                    warnType = warnType + "[\u6750\u6599\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMaterialName(materialName.trim());
                }
                if ("\u5408\u8ba1".equals(materialName)) continue;
                String materialUnitName = datas.get(3);
                String materialNum = datas.get(4);
                String materialTaxPrice = datas.get(5);
                String materialRate = datas.get(6);
                String materialPrice = datas.get(7);
                String materialMny = datas.get(8);
                String materialTax = datas.get(9);
                String materialMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)materialCode)) {
                    vo.setMaterialCode(null);
                } else {
                    vo.setMaterialCode(materialCode);
                }
                vo.setMaterialUnitName(materialUnitName);
                if (StringUtils.isEmpty((CharSequence)materialNum)) {
                    vo.setMaterialNum(null);
                } else {
                    try {
                        vo.setMaterialNum(new BigDecimal(materialNum));
                    }
                    catch (Exception e) {
                        vo.setMaterialNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialTaxPrice)) {
                    vo.setMaterialTaxPrice(null);
                } else {
                    try {
                        vo.setMaterialTaxPrice(new BigDecimal(materialTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMaterialTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialRate)) {
                    vo.setMaterialRate(null);
                } else {
                    try {
                        vo.setMaterialRate(new BigDecimal(materialRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setMaterialRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialPrice)) {
                    vo.setMaterialPrice(null);
                } else {
                    try {
                        vo.setMaterialPrice(new BigDecimal(materialPrice));
                    }
                    catch (Exception e) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialMny)) {
                    vo.setMaterialMny(null);
                } else {
                    try {
                        vo.setMaterialMny(new BigDecimal(materialMny));
                    }
                    catch (Exception e) {
                        vo.setMaterialMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialTax)) {
                    vo.setMaterialTax(null);
                } else {
                    try {
                        vo.setMaterialTax(new BigDecimal(materialTax));
                    }
                    catch (Exception e) {
                        vo.setMaterialTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMaterialMemo(materialMemo);
                vo.setMaterialTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialNum(), (BigDecimal)vo.getMaterialTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildMaterialVO> successList = new ArrayList<BuildMaterialVO>();
            for (BuildMaterialVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("5-\u6750\u6599\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getMaterialCode());
                errorVo.setName(vo.getMaterialName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildMaterialList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportEquipment(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildEquipmentVO> detailVoList = new ArrayList<BuildEquipmentVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildEquipmentVO vo = new BuildEquipmentVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String equipmentCode = datas.get(1);
                String equipmentName = datas.get(2);
                if (StringUtils.isEmpty((CharSequence)equipmentName)) {
                    vo.setEquipmentName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setEquipmentName(equipmentName.trim());
                }
                if ("\u5408\u8ba1".equals(equipmentName)) continue;
                String equipmentLabourPrice = datas.get(3);
                String equipmentLabourTaxPrice = datas.get(4);
                String equipmentRentMonth = datas.get(5);
                String equipmentRate = datas.get(6);
                String equipmentPrice = datas.get(7);
                String equipmentMny = datas.get(8);
                String equipmentTax = datas.get(9);
                String equipmentMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)equipmentCode)) {
                    vo.setEquipmentCode(null);
                } else {
                    vo.setEquipmentCode(equipmentCode);
                }
                if (StringUtils.isEmpty((CharSequence)equipmentLabourPrice)) {
                    vo.setEquipmentLabourPrice(null);
                } else {
                    try {
                        vo.setEquipmentLabourPrice(new BigDecimal(equipmentLabourPrice));
                    }
                    catch (Exception e) {
                        vo.setEquipmentLabourPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u6708\u79df\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentLabourTaxPrice)) {
                    vo.setEquipmentLabourTaxPrice(null);
                } else {
                    try {
                        vo.setEquipmentLabourTaxPrice(new BigDecimal(equipmentLabourTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setEquipmentLabourTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u4eba\u5de5\u8d39\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentRentMonth)) {
                    vo.setEquipmentRentMonth(null);
                } else {
                    try {
                        vo.setEquipmentRentMonth(new BigDecimal(equipmentRentMonth));
                    }
                    catch (Exception e) {
                        vo.setEquipmentRentMonth(null);
                        warnType = warnType + "[\u79df\u7528\u65f6\u95f4\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentRate)) {
                    vo.setEquipmentRate(null);
                } else {
                    try {
                        vo.setEquipmentRate(new BigDecimal(equipmentRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setEquipmentRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentPrice)) {
                    vo.setEquipmentPrice(null);
                } else {
                    try {
                        vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
                    }
                    catch (Exception e) {
                        vo.setEquipmentPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentMny)) {
                    vo.setEquipmentMny(null);
                } else {
                    try {
                        vo.setEquipmentMny(new BigDecimal(equipmentMny));
                    }
                    catch (Exception e) {
                        vo.setEquipmentMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentTax)) {
                    vo.setEquipmentTax(null);
                } else {
                    try {
                        vo.setEquipmentTax(new BigDecimal(equipmentTax));
                    }
                    catch (Exception e) {
                        vo.setEquipmentTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setEquipmentMemo(equipmentMemo);
                vo.setEquipmentTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getEquipmentNum(), (BigDecimal)vo.getEquipmentTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildEquipmentVO> successList = new ArrayList<BuildEquipmentVO>();
            for (BuildEquipmentVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("9-\u673a\u5177\u4f7f\u7528\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getEquipmentCode());
                errorVo.setName(vo.getEquipmentName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildEquipmentList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportSafe(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildSafeVO> detailVoList = new ArrayList<BuildSafeVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildSafeVO vo = new BuildSafeVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String safeName = datas.get(1);
                if (StringUtils.isEmpty((CharSequence)safeName)) {
                    vo.setSafeName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSafeName(safeName.trim());
                }
                if ("\u5408\u8ba1".equals(safeName)) continue;
                String safeUnitName = datas.get(2);
                String safeNum = datas.get(3);
                String safeTaxPrice = datas.get(4);
                String safeRate = datas.get(5);
                String safePrice = datas.get(6);
                String safeMny = datas.get(7);
                String safeTax = datas.get(8);
                String safeMemo = datas.get(9);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                vo.setSafeUnitName(safeUnitName);
                if (StringUtils.isEmpty((CharSequence)safeNum)) {
                    vo.setSafeNum(null);
                } else {
                    try {
                        vo.setSafeNum(new BigDecimal(safeNum));
                    }
                    catch (Exception e) {
                        vo.setSafeNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeTaxPrice)) {
                    vo.setSafeTaxPrice(null);
                } else {
                    try {
                        vo.setSafeTaxPrice(new BigDecimal(safeTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setSafeTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeRate)) {
                    vo.setSafeRate(null);
                } else {
                    try {
                        vo.setSafeRate(new BigDecimal(safeRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setSafeRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safePrice)) {
                    vo.setSafePrice(null);
                } else {
                    try {
                        vo.setSafePrice(new BigDecimal(safePrice));
                    }
                    catch (Exception e) {
                        vo.setSafePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeMny)) {
                    vo.setSafeMny(null);
                } else {
                    try {
                        vo.setSafeMny(new BigDecimal(safeMny));
                    }
                    catch (Exception e) {
                        vo.setSafeMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeTax)) {
                    vo.setSafeTax(null);
                } else {
                    try {
                        vo.setSafeTax(new BigDecimal(safeTax));
                    }
                    catch (Exception e) {
                        vo.setSafeTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setSafeMemo(safeMemo);
                vo.setSafeTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getSafeNum(), (BigDecimal)vo.getSafeTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildSafeVO> successList = new ArrayList<BuildSafeVO>();
            for (BuildSafeVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("10-\u5b89\u5168\u6587\u660e\u3001\u73af\u5883\u4fdd\u62a4\u3001\u4e34\u65f6\u8bbe\u65bd\u3001\u4e8c\u6b21\u642c\u8fd0");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getSafeCode());
                errorVo.setName(vo.getSafeName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildSafeList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportNight(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildNightVO> detailVoList = new ArrayList<BuildNightVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildNightVO vo = new BuildNightVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String nightName = datas.get(1);
                if (StringUtils.isEmpty((CharSequence)nightName)) {
                    vo.setNightName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setNightName(nightName.trim());
                }
                if ("\u5408\u8ba1".equals(nightName)) continue;
                String nightUnitName = datas.get(2);
                String nightNum = datas.get(3);
                String nightTaxPrice = datas.get(4);
                String nightRate = datas.get(5);
                String nightPrice = datas.get(6);
                String nightMny = datas.get(7);
                String nightTax = datas.get(8);
                String nightMemo = datas.get(9);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                vo.setNightUnitName(nightUnitName);
                if (StringUtils.isEmpty((CharSequence)nightNum)) {
                    vo.setNightNum(null);
                } else {
                    try {
                        vo.setNightNum(new BigDecimal(nightNum));
                    }
                    catch (Exception e) {
                        vo.setNightNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)nightTaxPrice)) {
                    vo.setNightTaxPrice(null);
                } else {
                    try {
                        vo.setNightTaxPrice(new BigDecimal(nightTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setNightTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)nightRate)) {
                    vo.setNightRate(null);
                } else {
                    try {
                        vo.setNightRate(new BigDecimal(nightRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setNightRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)nightPrice)) {
                    vo.setNightPrice(null);
                } else {
                    try {
                        vo.setNightPrice(new BigDecimal(nightPrice));
                    }
                    catch (Exception e) {
                        vo.setNightPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)nightMny)) {
                    vo.setNightMny(null);
                } else {
                    try {
                        vo.setNightMny(new BigDecimal(nightMny));
                    }
                    catch (Exception e) {
                        vo.setNightMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)nightTax)) {
                    vo.setNightTax(null);
                } else {
                    try {
                        vo.setNightTax(new BigDecimal(nightTax));
                    }
                    catch (Exception e) {
                        vo.setNightTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setNightMemo(nightMemo);
                vo.setNightTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getNightNum(), (BigDecimal)vo.getNightTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildNightVO> successList = new ArrayList<BuildNightVO>();
            for (BuildNightVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("11-\u51ac\u96e8\u5b63\u3001\u591c\u95f4\u65bd\u5de5");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getNightCode());
                errorVo.setName(vo.getNightName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildNightList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportComplete(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildCompleteVO> detailVoList = new ArrayList<BuildCompleteVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildCompleteVO vo = new BuildCompleteVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String completeName = datas.get(1);
                if (StringUtils.isEmpty((CharSequence)completeName)) {
                    vo.setCompleteName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setCompleteName(completeName.trim());
                }
                if ("\u5408\u8ba1".equals(completeName)) continue;
                String completeUnitName = datas.get(2);
                String completeNum = datas.get(3);
                String completeTaxPrice = datas.get(4);
                String completeRate = datas.get(5);
                String completePrice = datas.get(6);
                String completeMny = datas.get(7);
                String completeTax = datas.get(8);
                String completeMemo = datas.get(9);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                vo.setCompleteUnitName(completeUnitName);
                if (StringUtils.isEmpty((CharSequence)completeNum)) {
                    vo.setCompleteNum(null);
                } else {
                    try {
                        vo.setCompleteNum(new BigDecimal(completeNum));
                    }
                    catch (Exception e) {
                        vo.setCompleteNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)completeTaxPrice)) {
                    vo.setCompleteTaxPrice(null);
                } else {
                    try {
                        vo.setCompleteTaxPrice(new BigDecimal(completeTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setCompleteTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)completeRate)) {
                    vo.setCompleteRate(null);
                } else {
                    try {
                        vo.setCompleteRate(new BigDecimal(completeRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setCompleteRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)completePrice)) {
                    vo.setCompletePrice(null);
                } else {
                    try {
                        vo.setCompletePrice(new BigDecimal(completePrice));
                    }
                    catch (Exception e) {
                        vo.setCompletePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)completeMny)) {
                    vo.setCompleteMny(null);
                } else {
                    try {
                        vo.setCompleteMny(new BigDecimal(completeMny));
                    }
                    catch (Exception e) {
                        vo.setCompleteMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)completeTax)) {
                    vo.setCompleteTax(null);
                } else {
                    try {
                        vo.setCompleteTax(new BigDecimal(completeTax));
                    }
                    catch (Exception e) {
                        vo.setCompleteTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setCompleteMemo(completeMemo);
                vo.setCompleteTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getCompleteNum(), (BigDecimal)vo.getCompleteTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildCompleteVO> successList = new ArrayList<BuildCompleteVO>();
            for (BuildCompleteVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("12-\u5df2\u5b8c\u5de5\u7a0b\u53ca\u8bbe\u5907\u4fdd\u62a4");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCompleteCode());
                errorVo.setName(vo.getCompleteName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildCompleteList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportTemplates(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildTemplatesVO> detailVoList = new ArrayList<BuildTemplatesVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildTemplatesVO vo = new BuildTemplatesVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String templatesName = datas.get(2);
                if (StringUtils.isEmpty((CharSequence)templatesName)) {
                    vo.setTemplatesName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setTemplatesName(templatesName.trim());
                }
                if ("\u5408\u8ba1".equals(templatesName)) continue;
                String templatesCode = datas.get(1);
                String templatesSpec = datas.get(3);
                String templatesUnitName = datas.get(4);
                String templatesNum = datas.get(5);
                String templatesTaxPrice = datas.get(6);
                String templatesRentDay = datas.get(7);
                String templatesRate = datas.get(8);
                String templatesPrice = datas.get(9);
                String templatesMny = datas.get(10);
                String templatesTax = datas.get(11);
                String templatesMemo = datas.get(12);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isNotEmpty((CharSequence)templatesCode)) {
                    vo.setTemplatesCode(templatesCode);
                }
                if (StringUtils.isNotEmpty((CharSequence)templatesSpec)) {
                    vo.setTemplatesSpec(templatesSpec);
                }
                vo.setTemplatesUnitName(templatesUnitName);
                if (StringUtils.isEmpty((CharSequence)templatesNum)) {
                    vo.setTemplatesNum(null);
                } else {
                    try {
                        vo.setTemplatesNum(new BigDecimal(templatesNum));
                    }
                    catch (Exception e) {
                        vo.setTemplatesNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)templatesTaxPrice)) {
                    vo.setTemplatesTaxPrice(null);
                } else {
                    try {
                        vo.setTemplatesTaxPrice(new BigDecimal(templatesTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setTemplatesTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)templatesRentDay)) {
                    vo.setTemplatesRentDay(null);
                } else {
                    try {
                        vo.setTemplatesRentDay(new BigDecimal(templatesRentDay));
                    }
                    catch (Exception e) {
                        vo.setTemplatesRentDay(null);
                        warnType = warnType + "[\u79df\u8d41\u65f6\u95f4\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)templatesRate)) {
                    vo.setTemplatesRate(null);
                } else {
                    try {
                        vo.setTemplatesRate(new BigDecimal(templatesRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setTemplatesRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)templatesPrice)) {
                    vo.setTemplatesPrice(null);
                } else {
                    try {
                        vo.setTemplatesPrice(new BigDecimal(templatesPrice));
                    }
                    catch (Exception e) {
                        vo.setTemplatesPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)templatesMny)) {
                    vo.setTemplatesMny(null);
                } else {
                    try {
                        vo.setTemplatesMny(new BigDecimal(templatesMny));
                    }
                    catch (Exception e) {
                        vo.setTemplatesMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)templatesTax)) {
                    vo.setTemplatesTax(null);
                } else {
                    try {
                        vo.setTemplatesTax(new BigDecimal(templatesTax));
                    }
                    catch (Exception e) {
                        vo.setTemplatesTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setTemplatesMemo(templatesMemo);
                if (null != vo.getTemplatesNum() && null != vo.getTemplatesTaxPrice()) {
                    BigDecimal bigDecimal = ComputeUtil.safeMultiply((BigDecimal)vo.getTemplatesNum(), (BigDecimal)vo.getTemplatesTaxPrice());
                    if (null != vo.getTemplatesRentDay()) {
                        bigDecimal = ComputeUtil.safeMultiply((BigDecimal)bigDecimal, (BigDecimal)vo.getTemplatesRentDay());
                    }
                    vo.setTemplatesTaxMny(bigDecimal);
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildTemplatesVO> successList = new ArrayList<BuildTemplatesVO>();
            for (BuildTemplatesVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("14-\u6a21\u677f\u53ca\u652f\u6491");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getTemplatesCode());
                errorVo.setName(vo.getTemplatesName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildTemplatesList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportScaffold(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildScaffoldVO> detailVoList = new ArrayList<BuildScaffoldVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildScaffoldVO vo = new BuildScaffoldVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String scaffoldCode = datas.get(1);
                String scaffoldName = datas.get(2);
                if ("\u5408\u8ba1".equals(scaffoldName)) continue;
                String scaffoldSpec = datas.get(3);
                String scaffoldUnitName = datas.get(4);
                String scaffoldNum = datas.get(5);
                String scaffoldTaxPrice = datas.get(6);
                String scaffoldRentDay = datas.get(7);
                String scaffoldRate = datas.get(8);
                String scaffoldPrice = datas.get(9);
                String scaffoldMny = datas.get(10);
                String scaffoldTax = datas.get(11);
                String scaffoldMemo = datas.get(12);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldCode)) {
                    vo.setScaffoldCode(null);
                } else {
                    vo.setScaffoldCode(scaffoldCode);
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldName)) {
                    vo.setScaffoldName(null);
                    warnType = warnType + "[\u6750\u6599\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setScaffoldName(scaffoldName.trim());
                }
                vo.setScaffoldUnitName(scaffoldUnitName);
                if (StringUtils.isEmpty((CharSequence)scaffoldNum)) {
                    vo.setScaffoldNum(null);
                } else {
                    try {
                        vo.setScaffoldNum(new BigDecimal(scaffoldNum));
                    }
                    catch (Exception e) {
                        vo.setScaffoldNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldSpec)) {
                    vo.setScaffoldSpec(null);
                } else {
                    vo.setScaffoldSpec(scaffoldSpec);
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldTaxPrice)) {
                    vo.setScaffoldTaxPrice(null);
                } else {
                    try {
                        vo.setScaffoldTaxPrice(new BigDecimal(scaffoldTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setScaffoldTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldRentDay)) {
                    vo.setScaffoldRentDay(null);
                } else {
                    try {
                        vo.setScaffoldRentDay(new BigDecimal(scaffoldRentDay));
                    }
                    catch (Exception e) {
                        vo.setScaffoldRentDay(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldRate)) {
                    vo.setScaffoldRate(null);
                } else {
                    try {
                        vo.setScaffoldRate(new BigDecimal(scaffoldRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setScaffoldRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldPrice)) {
                    vo.setScaffoldPrice(null);
                } else {
                    try {
                        vo.setScaffoldPrice(new BigDecimal(scaffoldPrice));
                    }
                    catch (Exception e) {
                        vo.setScaffoldPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldMny)) {
                    vo.setScaffoldMny(null);
                } else {
                    try {
                        vo.setScaffoldMny(new BigDecimal(scaffoldMny));
                    }
                    catch (Exception e) {
                        vo.setScaffoldMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)scaffoldTax)) {
                    vo.setScaffoldTax(null);
                } else {
                    try {
                        vo.setScaffoldTax(new BigDecimal(scaffoldTax));
                    }
                    catch (Exception e) {
                        vo.setScaffoldTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setScaffoldMemo(scaffoldMemo);
                if (null != vo.getScaffoldNum() && null != vo.getScaffoldTaxPrice()) {
                    BigDecimal bigDecimal = ComputeUtil.safeMultiply((BigDecimal)vo.getScaffoldNum(), (BigDecimal)vo.getScaffoldTaxPrice());
                    if (null != vo.getScaffoldRentDay()) {
                        bigDecimal = ComputeUtil.safeMultiply((BigDecimal)bigDecimal, (BigDecimal)vo.getScaffoldRentDay());
                    }
                    vo.setScaffoldTaxMny(bigDecimal);
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildScaffoldVO> successList = new ArrayList<BuildScaffoldVO>();
            for (BuildScaffoldVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String scaffold;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(scaffold = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("15-\u811a\u624b\u67b6");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getScaffoldCode());
                errorVo.setName(vo.getScaffoldName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildScaffoldList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportStimulate(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList detailIndexList = new ArrayList();
            HashMap parentMap = new HashMap();
            ArrayList<BuildStimulateVO> detailVoList = new ArrayList<BuildStimulateVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildStimulateVO vo = new BuildStimulateVO();
                boolean flag = false;
                String warnType = "";
                String treeIndex = datas.get(0);
                String stimulateName = datas.get(1);
                if ("\u5408\u8ba1".equals(stimulateName) || StringUtils.isEmpty((CharSequence)treeIndex)) continue;
                String stimulateUnitName = datas.get(2);
                String stimulateNum = datas.get(3);
                String stimulateTaxPrice = datas.get(4);
                String stimulateRate = datas.get(5);
                String stimulatePrice = datas.get(6);
                String stimulateMny = datas.get(7);
                String stimulateTax = datas.get(8);
                String stimulateMemo = datas.get(9);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                vo.setTreeIndex(treeIndex);
                if (StringUtils.isEmpty((CharSequence)stimulateName)) {
                    vo.setStimulateName(null);
                    warnType = warnType + "[\u9879\u76ee\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setStimulateName(stimulateName.trim());
                }
                vo.setStimulateUnitName(stimulateUnitName);
                if (StringUtils.isEmpty((CharSequence)stimulateNum)) {
                    vo.setStimulateNum(null);
                } else {
                    try {
                        vo.setStimulateNum(new BigDecimal(stimulateNum));
                    }
                    catch (Exception e) {
                        vo.setStimulateNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)stimulateTaxPrice)) {
                    vo.setStimulateTaxPrice(null);
                } else {
                    try {
                        vo.setStimulateTaxPrice(new BigDecimal(stimulateTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setStimulateTaxPrice(null);
                        warnType = warnType + "[ \u542b\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)stimulateRate)) {
                    vo.setStimulateRate(null);
                } else {
                    try {
                        vo.setStimulateRate(new BigDecimal(stimulateRate));
                    }
                    catch (Exception e) {
                        vo.setStimulateRate(null);
                        warnType = warnType + "[\u4e13\u7968\u8fdb\u9879\u7a0e\u7a0e\u7387\uff08%\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)stimulatePrice)) {
                    vo.setStimulatePrice(null);
                } else {
                    try {
                        vo.setStimulatePrice(new BigDecimal(stimulatePrice));
                    }
                    catch (Exception e) {
                        vo.setStimulatePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)stimulateMny)) {
                    vo.setStimulateMny(null);
                } else {
                    try {
                        vo.setStimulateMny(new BigDecimal(stimulateMny));
                    }
                    catch (Exception e) {
                        vo.setStimulateMny(null);
                        warnType = warnType + "\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)stimulateTax)) {
                    vo.setStimulateTax(null);
                } else {
                    try {
                        vo.setStimulateTax(new BigDecimal(stimulateTax));
                    }
                    catch (Exception e) {
                        vo.setStimulateTax(null);
                        warnType = warnType + "\u8fdb\u9879\u7a0e\u5408\u8ba1\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570";
                        flag = true;
                    }
                }
                vo.setStimulateMemo(stimulateMemo);
                vo.setStimulateTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getStimulateNum(), (BigDecimal)vo.getStimulateTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildStimulateVO> successList = new ArrayList<BuildStimulateVO>();
            for (BuildStimulateVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("18-\u6fc0\u52b1\u5956");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getTreeIndex());
                errorVo.setCode(null);
                errorVo.setName(vo.getStimulateName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildStimulateList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportIndirect(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildIndirectVO> detailVoList = new ArrayList<BuildIndirectVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildIndirectVO vo = new BuildIndirectVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String indirectName = datas.get(1);
                if ("\u5408\u8ba1".equals(indirectName)) continue;
                String indirectUnitName = datas.get(2);
                String indirectNum = datas.get(3);
                String indirectTaxPrice = datas.get(4);
                String indirectMothNum = datas.get(5);
                String indirectRate = datas.get(6);
                String indirectPrice = datas.get(7);
                String indirectMny = datas.get(8);
                String indirectTax = datas.get(9);
                String indirectMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)indirectName)) {
                    vo.setIndirectName(null);
                    warnType = warnType + "\u9879\u76ee\u4e3a\u7a7a";
                    flag = true;
                } else {
                    vo.setIndirectName(indirectName.trim());
                }
                vo.setIndirectUnitName(indirectUnitName);
                if (StringUtils.isEmpty((CharSequence)indirectNum)) {
                    vo.setIndirectNum(null);
                } else {
                    try {
                        vo.setIndirectNum(new BigDecimal(indirectNum));
                    }
                    catch (Exception e) {
                        vo.setIndirectNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectTaxPrice)) {
                    vo.setIndirectTaxPrice(null);
                } else {
                    try {
                        vo.setIndirectTaxPrice(new BigDecimal(indirectTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setIndirectTaxPrice(null);
                        warnType = warnType + "[ \u542b\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectMothNum)) {
                    vo.setIndirectMothNum(null);
                } else {
                    try {
                        vo.setIndirectMothNum(new BigDecimal(indirectMothNum));
                    }
                    catch (Exception e) {
                        vo.setIndirectMothNum(null);
                        warnType = warnType + "[ \u65f6\u95f4\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectRate)) {
                    vo.setIndirectRate(null);
                } else {
                    try {
                        vo.setIndirectRate(new BigDecimal(indirectRate));
                    }
                    catch (Exception e) {
                        vo.setIndirectRate(null);
                        warnType = warnType + "[\u4e13\u7968\u8fdb\u9879\u7a0e\u7a0e\u7387\uff08%\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectPrice)) {
                    vo.setIndirectPrice(null);
                } else {
                    try {
                        vo.setIndirectPrice(new BigDecimal(indirectPrice));
                    }
                    catch (Exception e) {
                        vo.setIndirectPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectTax)) {
                    vo.setIndirectTax(null);
                } else {
                    try {
                        vo.setIndirectTax(new BigDecimal(indirectTax));
                    }
                    catch (Exception e) {
                        vo.setIndirectTax(null);
                        warnType = warnType + "[\u4e0d\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectTax)) {
                    vo.setIndirectTax(null);
                } else {
                    try {
                        vo.setIndirectTax(new BigDecimal(indirectTax));
                    }
                    catch (Exception e) {
                        vo.setIndirectTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)indirectMny)) {
                    vo.setIndirectMny(null);
                } else {
                    try {
                        vo.setIndirectMny(new BigDecimal(indirectMny));
                    }
                    catch (Exception e) {
                        vo.setIndirectMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\uff08\u5143\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setIndirectMemo(indirectMemo);
                if (null != vo.getIndirectNum() && null != vo.getIndirectTaxPrice()) {
                    BigDecimal bigDecimal = ComputeUtil.safeMultiply((BigDecimal)vo.getIndirectNum(), (BigDecimal)vo.getIndirectTaxPrice());
                    if (null != vo.getIndirectMothNum()) {
                        bigDecimal = ComputeUtil.safeMultiply((BigDecimal)bigDecimal, (BigDecimal)vo.getIndirectMothNum());
                    }
                    vo.setIndirectTaxMny(bigDecimal);
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildIndirectVO> successList = new ArrayList<BuildIndirectVO>();
            for (BuildIndirectVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("17-\u95f4\u63a5\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setName(vo.getIndirectName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildIndirectList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportPrecipitation(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildPrecipitationVO> detailVoList = new ArrayList<BuildPrecipitationVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildPrecipitationVO vo = new BuildPrecipitationVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String precipitationName = datas.get(1);
                if ("\u5408\u8ba1".equals(precipitationName)) continue;
                String precipitationFeatures = datas.get(2);
                String precipitationUnitName = datas.get(3);
                String precipitationNum = datas.get(4);
                String precipitationTaxPrice = datas.get(5);
                String precipitationRate = datas.get(6);
                String precipitationPrice = datas.get(7);
                String precipitationMny = datas.get(8);
                String precipitationTax = datas.get(9);
                String precipitationMemo = datas.get(10);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)precipitationName)) {
                    vo.setPrecipitationName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setPrecipitationName(precipitationName.trim());
                }
                vo.setPrecipitationUnitName(precipitationUnitName);
                vo.setPrecipitationFeatures(precipitationFeatures);
                if (StringUtils.isEmpty((CharSequence)precipitationNum)) {
                    vo.setPrecipitationNum(null);
                } else {
                    try {
                        vo.setPrecipitationNum(new BigDecimal(precipitationNum));
                    }
                    catch (Exception e) {
                        vo.setPrecipitationNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)precipitationTaxPrice)) {
                    vo.setPrecipitationTaxPrice(null);
                } else {
                    try {
                        vo.setPrecipitationTaxPrice(new BigDecimal(precipitationTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setPrecipitationTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)precipitationRate)) {
                    vo.setPrecipitationRate(null);
                } else {
                    try {
                        vo.setPrecipitationRate(new BigDecimal(precipitationRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setPrecipitationRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)precipitationPrice)) {
                    vo.setPrecipitationPrice(null);
                } else {
                    try {
                        vo.setPrecipitationPrice(new BigDecimal(precipitationPrice));
                    }
                    catch (Exception e) {
                        vo.setPrecipitationPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)precipitationMny)) {
                    vo.setPrecipitationMny(null);
                } else {
                    try {
                        vo.setPrecipitationMny(new BigDecimal(precipitationMny));
                    }
                    catch (Exception e) {
                        vo.setPrecipitationMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)precipitationTax)) {
                    vo.setPrecipitationTax(null);
                } else {
                    try {
                        vo.setPrecipitationTax(new BigDecimal(precipitationTax));
                    }
                    catch (Exception e) {
                        vo.setPrecipitationTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setPrecipitationMemo(precipitationMemo);
                vo.setPrecipitationTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getPrecipitationNum(), (BigDecimal)vo.getPrecipitationTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildPrecipitationVO> successList = new ArrayList<BuildPrecipitationVO>();
            for (BuildPrecipitationVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("13-\u6392\u3001\u964d\u6c34");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getPrecipitationCode());
                errorVo.setName(vo.getPrecipitationName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildPrecipitationList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportMeasure(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildMeasureVO> detailVoList = new ArrayList<BuildMeasureVO>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; ++i) {
                List<String> datas = result.get(i);
                BuildMeasureVO vo = new BuildMeasureVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String measureName = datas.get(1);
                if ("\u5408\u8ba1".equals(measureName)) continue;
                String measureUnitName = datas.get(2);
                String measureNum = datas.get(3);
                String measureTaxPrice = datas.get(4);
                String measureRate = datas.get(5);
                String measurePrice = datas.get(6);
                String measureMny = datas.get(7);
                String measureTax = datas.get(8);
                String measureMemo = datas.get(9);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache) {
                        warnType = warnType + "[\u5e8f\u53f7\u975e\u6570\u5b57]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)measureName)) {
                    vo.setMeasureName(null);
                    warnType = warnType + "[\u6750\u6599\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMeasureName(measureName.trim());
                }
                vo.setMeasureUnitName(measureUnitName);
                if (StringUtils.isEmpty((CharSequence)measureNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(measureNum));
                    }
                    catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureTaxPrice)) {
                    vo.setMeasureTaxPrice(null);
                } else {
                    try {
                        vo.setMeasureTaxPrice(new BigDecimal(measureTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasureTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureRate)) {
                    vo.setMeasureRate(null);
                } else {
                    try {
                        vo.setMeasureRate(new BigDecimal(measureRate).multiply(new BigDecimal(100)));
                    }
                    catch (Exception e) {
                        vo.setMeasureRate(null);
                        warnType = warnType + "[\u4e13\u9879\u8fdb\u9879\u7a0e\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measurePrice)) {
                    vo.setMeasurePrice(null);
                } else {
                    try {
                        vo.setMeasurePrice(new BigDecimal(measurePrice));
                    }
                    catch (Exception e) {
                        vo.setMeasurePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureMny)) {
                    vo.setMeasureMny(null);
                } else {
                    try {
                        vo.setMeasureMny(new BigDecimal(measureMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureTax)) {
                    vo.setMeasureTax(null);
                } else {
                    try {
                        vo.setMeasureTax(new BigDecimal(measureTax));
                    }
                    catch (Exception e) {
                        vo.setMeasureTax(null);
                        warnType = warnType + "[\u8fdb\u9879\u7a0e\u5408\u8ba1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMeasureMemo(measureMemo);
                vo.setMeasureTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getMeasureNum(), (BigDecimal)vo.getMeasureTaxPrice()));
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildMeasureVO> successList = new ArrayList<BuildMeasureVO>();
            for (BuildMeasureVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("16-\u5176\u4ed6\u63aa\u65bd\u8d39");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getMeasureCode());
                errorVo.setName(vo.getMeasureName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildMeasureList(successList);
        }
        return res;
    }

    public void updateByPid(BuildDutyEntity entity) {
        HashMap<Long, Long> rgcostMap = new HashMap<Long, Long>();
        List<BuildRgcostEntity> rgcostEntities = entity.getBuildRgcostList();
        if (CollectionUtils.isNotEmpty(rgcostEntities)) {
            for (BuildRgcostEntity twoEntity : rgcostEntities) {
                rgcostMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildRgcostEntity cdEntity : rgcostEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)rgcostMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildRgcostService.saveOrUpdateBatch(rgcostEntities, rgcostEntities.size(), false);
        }
        HashMap<Long, Long> subMap = new HashMap<Long, Long>();
        List<BuildSubEntity> dutySubEntities = entity.getBuildSubList();
        if (CollectionUtils.isNotEmpty(dutySubEntities)) {
            for (BuildSubEntity rmatEntity : dutySubEntities) {
                subMap.put(rmatEntity.getTid(), rmatEntity.getId());
            }
            for (BuildSubEntity cdEntity : dutySubEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)subMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildSubService.saveOrUpdateBatch(dutySubEntities, dutySubEntities.size(), false);
        }
        HashMap<Long, Long> materialMap = new HashMap<Long, Long>();
        List<BuildMaterialEntity> materialEntities = entity.getBuildMaterialList();
        if (CollectionUtils.isNotEmpty(materialEntities)) {
            for (BuildMaterialEntity twoEntity : materialEntities) {
                materialMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildMaterialEntity cdEntity : materialEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)materialMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildMaterialService.saveOrUpdateBatch(materialEntities, materialEntities.size(), false);
        }
        HashMap<Long, Long> rmatMap = new HashMap<Long, Long>();
        List<BuildStimulateEntity> buildStimulateList = entity.getBuildStimulateList();
        if (CollectionUtils.isNotEmpty(buildStimulateList)) {
            for (BuildStimulateEntity twoEntity : buildStimulateList) {
                rmatMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildStimulateEntity cdEntity : buildStimulateList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)rmatMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildStimulateService.saveOrUpdateBatch(buildStimulateList, buildStimulateList.size(), false);
        }
        HashMap<Long, Long> equipmentMap = new HashMap<Long, Long>();
        List<BuildEquipmentEntity> equipmentEntities = entity.getBuildEquipmentList();
        if (CollectionUtils.isNotEmpty(equipmentEntities)) {
            for (BuildEquipmentEntity twoEntity : equipmentEntities) {
                equipmentMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildEquipmentEntity cdEntity : equipmentEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)equipmentMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildEquipmentService.saveOrUpdateBatch(equipmentEntities, equipmentEntities.size(), false);
        }
        HashMap<Long, Long> safeMap = new HashMap<Long, Long>();
        List<BuildSafeEntity> safeEntities = entity.getBuildSafeList();
        if (CollectionUtils.isNotEmpty(safeEntities)) {
            for (BuildSafeEntity twoEntity : safeEntities) {
                safeMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildSafeEntity cdEntity : safeEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)safeMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildSafeService.saveOrUpdateBatch(safeEntities, safeEntities.size(), false);
        }
        HashMap<Long, Long> temporaryMap = new HashMap<Long, Long>();
        List<BuildIndirectEntity> buildIndirectList = entity.getBuildIndirectList();
        if (CollectionUtils.isNotEmpty(buildIndirectList)) {
            for (BuildIndirectEntity twoEntity : buildIndirectList) {
                temporaryMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildIndirectEntity cdEntity : buildIndirectList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)temporaryMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildIndirectService.saveOrUpdateBatch(buildIndirectList, buildIndirectList.size(), false);
        }
        HashMap<Long, Long> measureMap = new HashMap<Long, Long>();
        List<BuildMeasureEntity> measureEntities = entity.getBuildMeasureList();
        if (CollectionUtils.isNotEmpty(measureEntities)) {
            for (BuildMeasureEntity twoEntity : measureEntities) {
                measureMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildMeasureEntity cdEntity : measureEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)measureMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildMeasureService.saveOrUpdateBatch(measureEntities, measureEntities.size(), false);
        }
        HashMap<Long, Long> manageMap = new HashMap<Long, Long>();
        List<BuildScaffoldEntity> buildScaffoldList = entity.getBuildScaffoldList();
        if (CollectionUtils.isNotEmpty(buildScaffoldList)) {
            for (BuildScaffoldEntity twoEntity : buildScaffoldList) {
                manageMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildScaffoldEntity cdEntity : buildScaffoldList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)manageMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildScaffoldService.saveOrUpdateBatch(buildScaffoldList, buildScaffoldList.size(), false);
        }
        HashMap<Long, Long> feesMap = new HashMap<Long, Long>();
        List<BuildTemplatesEntity> buildTemplatesList = entity.getBuildTemplatesList();
        if (CollectionUtils.isNotEmpty(buildTemplatesList)) {
            for (BuildTemplatesEntity twoEntity : buildTemplatesList) {
                feesMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildTemplatesEntity cdEntity : buildTemplatesList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)feesMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildTemplatesService.saveOrUpdateBatch(buildTemplatesList, buildTemplatesList.size(), false);
        }
        HashMap<Long, Long> otherMap = new HashMap<Long, Long>();
        List<BuildPrecipitationEntity> buildPrecipitationList = entity.getBuildPrecipitationList();
        if (CollectionUtils.isNotEmpty(buildPrecipitationList)) {
            for (BuildPrecipitationEntity twoEntity : buildPrecipitationList) {
                otherMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildPrecipitationEntity cdEntity : buildPrecipitationList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)otherMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildPrecipitationService.saveOrUpdateBatch(buildPrecipitationList, buildPrecipitationList.size(), false);
        }
        HashMap<Long, Long> completeMap = new HashMap<Long, Long>();
        List<BuildCompleteEntity> buildCompleteList = entity.getBuildCompleteList();
        if (CollectionUtils.isNotEmpty(buildCompleteList)) {
            for (BuildCompleteEntity twoEntity : buildCompleteList) {
                completeMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildCompleteEntity cdEntity : buildCompleteList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)completeMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildCompleteService.saveOrUpdateBatch(buildCompleteList, buildCompleteList.size(), false);
        }
        HashMap<Long, Long> nightMap = new HashMap<Long, Long>();
        List<BuildNightEntity> buildNightList = entity.getBuildNightList();
        if (CollectionUtils.isNotEmpty(buildNightList)) {
            for (BuildNightEntity twoEntity : buildNightList) {
                nightMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildNightEntity cdEntity : buildNightList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)nightMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildNightService.saveOrUpdateBatch(buildNightList, buildNightList.size(), false);
        }
        HashMap<Long, Long> appointMap = new HashMap<Long, Long>();
        List<BuildAppointEntity> buildAppointList = entity.getBuildAppointList();
        if (CollectionUtils.isNotEmpty(buildAppointList)) {
            for (BuildAppointEntity twoEntity : buildAppointList) {
                appointMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildAppointEntity cdEntity : buildAppointList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)appointMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildAppointService.saveOrUpdateBatch(buildAppointList, buildAppointList.size(), false);
        }
    }

    public List<BuildPlansEntity> SumPlanDetail(BuildDutyVO vo) {
        BigDecimal plansMny;
        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList();
        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();
        List<BuildSubVO> buildSubList = vo.getBuildSubList();
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList();
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList();
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList();
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList();
        ArrayList<BuildPlansEntity> dutyPlansEntityList = new ArrayList<BuildPlansEntity>();
        BigDecimal sumPlansMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        BigDecimal sumPlansMny2 = BigDecimal.ZERO;
        for (int i = 0; i < buildPlansList.size(); ++i) {
            BigDecimal plansYsMny;
            BigDecimal priceTax;
            BuildPlansEntity buildPlansEntity = (BuildPlansEntity)((Object)BeanMapper.map((Object)((Object)buildPlansList.get(i)), BuildPlansEntity.class));
            buildPlansEntity.setId(null);
            if (i == 0) {
                plansMny = buildRgcostList.stream().filter(item -> null == item.getParentId() && null != item.getRgcostMny()).map(BuildRgcostVO::getRgcostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildRgcostList.stream().filter(item -> null == item.getParentId() && null != item.getRgcostTax()).map(BuildRgcostVO::getRgcostTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 1) {
                plansMny = buildSubList.stream().filter(item -> null == item.getParentId() && null != item.getSubMny()).map(BuildSubVO::getSubMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildSubList.stream().filter(item -> null == item.getParentId() && null != item.getSubTax()).map(BuildSubVO::getSubTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 2) {
                plansMny = buildMaterialList.stream().filter(item -> null == item.getParentId() && null != item.getMaterialMny()).map(BuildMaterialVO::getMaterialMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildMaterialList.stream().filter(item -> null == item.getParentId() && null != item.getMaterialTax()).map(BuildMaterialVO::getMaterialTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i != 3) {
                if (i == 4) {
                    plansMny = buildEquipmentList.stream().filter(item -> null == item.getParentId() && null != item.getEquipmentMny()).map(BuildEquipmentVO::getEquipmentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    buildPlansEntity.setPlansMny(plansMny);
                    priceTax = buildEquipmentList.stream().filter(item -> null == item.getParentId() && null != item.getEquipmentTax()).map(BuildEquipmentVO::getEquipmentTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                    sumTaxMny = sumTaxMny.add(priceTax);
                } else if (i == 5) {
                    plansMny = buildSafeList.stream().filter(item -> null == item.getParentId() && null != item.getSafeMny()).map(BuildSafeVO::getSafeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    buildPlansEntity.setPlansMny(plansMny);
                    priceTax = buildSafeList.stream().filter(item -> null == item.getParentId() && null != item.getSafeTax()).map(BuildSafeVO::getSafeTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                    sumTaxMny = sumTaxMny.add(priceTax);
                } else if (i != 6) {
                    if (i == 7) {
                        plansMny = buildMeasureList.stream().filter(item -> null == item.getParentId() && null != item.getMeasureMny()).map(BuildMeasureVO::getMeasureMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        buildPlansEntity.setPlansMny(plansMny);
                        priceTax = buildMeasureList.stream().filter(item -> null == item.getParentId() && null != item.getMeasureTax()).map(BuildMeasureVO::getMeasureTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                        sumTaxMny = sumTaxMny.add(priceTax);
                    } else if (i != 8 && i != 9 && i != 11) {
                        if (i == 13) {
                            buildPlansEntity.setPlansMny(sumPlansMny);
                        } else if (i == 18) {
                            buildPlansEntity.setPlansMny(sumPlansMny2);
                        } else if (i == 15) {
                            buildPlansEntity.setPlansMny(sumTaxMny);
                        }
                    }
                }
            }
            if (i < 13) {
                sumPlansMny = sumPlansMny.add(buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny());
            } else if (i > 12 && i < 18) {
                sumPlansMny2 = sumPlansMny2.add(buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny());
            }
            BigDecimal bigDecimal = plansYsMny = buildPlansEntity.getPlansYsMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansYsMny();
            if (null != buildPlansEntity.getPlansMny()) {
                buildPlansEntity.setPlansJcMny(plansYsMny.subtract(buildPlansEntity.getPlansMny()));
                if (BigDecimal.ZERO.compareTo(plansYsMny) != 0) {
                    buildPlansEntity.setPlansJcRate(plansYsMny.subtract(buildPlansEntity.getPlansMny()).multiply(new BigDecimal(100)).divide(plansYsMny, 2, 5));
                }
            }
            dutyPlansEntityList.add(buildPlansEntity);
        }
        if (CollectionUtils.isNotEmpty(dutyPlansEntityList)) {
            for (BuildPlansEntity buildPlansEntity : dutyPlansEntityList) {
                if (BigDecimal.ZERO.compareTo(sumPlansMny2) != 0) {
                    plansMny = buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny();
                    buildPlansEntity.setPlansRate(plansMny.multiply(new BigDecimal(100)).divide(sumPlansMny2, 2, 5));
                    continue;
                }
                buildPlansEntity.setPlansRate(BigDecimal.ZERO);
            }
        }
        return dutyPlansEntityList;
    }
}

