/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.utils.DutyCalcUtil;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;

public class PushCalcExecCallable
implements Callable<CommonResponse<String>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TC_LOCK = "TC_LOCK::";
    private RequestAttributes context;
    private String authority;
    private ExecutionVO executionVO;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private IDutyService dutyService;
    private IDutyDetailService dutyDetailService;
    private IDutyDetailItemService dutyDetailItemService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;

    public PushCalcExecCallable(RequestAttributes context, String authority, ExecutionVO executionVO, RedissonClient redissonClient, ITotalCacheService totalCacheService, IDetailCacheService detailCacheService, IDutyService dutyService, IDutyDetailService dutyDetailService, IDutyDetailItemService dutyDetailItemService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService) {
        this.context = context;
        this.authority = authority;
        this.executionVO = executionVO;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyService = dutyService;
        this.dutyDetailService = dutyDetailService;
        this.dutyDetailItemService = dutyDetailItemService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<String> call() throws Exception {
        TotalExecutionVO totalExecutionVO = this.executionVO.getTotalVO();
        String lockKey = TC_LOCK + totalExecutionVO.getProjectId();
        RLock mylock = this.redissonClient.getLock(lockKey);
        try {
            boolean lock = mylock.tryLock(20L, TimeUnit.SECONDS);
            if (!lock) {
                CommonResponse commonResponse = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + totalExecutionVO.getProjectId()));
                return commonResponse;
            }
            LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
            feeQuery.eq(DutyEntity::getProjectId, (Object)totalExecutionVO.getProjectId());
            feeQuery.eq(DutyEntity::getEnableState, (Object)true);
            feeQuery.eq(DutyEntity::getGatherFlag, (Object)true);
            DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.getOne((Wrapper)feeQuery, false));
            if (null == dutyEntity) {
                mylock.unlock();
                CommonResponse commonResponse = CommonResponse.success((String)"\u8be5\u9879\u76ee\u6ca1\u6709\u751f\u6548\u7684\u6c47\u603b\u76ee\u6807\u6210\u672c");
                return commonResponse;
            }
            List<Long> feeDetailPks = this.queryFeeDetailPks(dutyEntity.getFeeId(), totalExecutionVO);
            if (CollectionUtils.isEmpty(feeDetailPks)) {
                mylock.unlock();
                CommonResponse commonResponse = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u660e\u7ec6");
                return commonResponse;
            }
            Set<Long> keySet = null;
            if (CollectionUtils.isNotEmpty((Collection)this.executionVO.getDetailList())) {
                keySet = this.cacheDetails(dutyEntity, this.executionVO, feeDetailPks);
            }
            this.cacheTotal(dutyEntity, this.executionVO, feeDetailPks);
            if (CollectionUtils.isNotEmpty(keySet)) {
                this.detailCacheService.deleteByIdsPhy(new ArrayList<Long>(keySet));
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u6c47\u603b\u7f13\u5b58\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
        }
        finally {
            mylock.unlock();
        }
        return CommonResponse.success((String)"\u5355\u4e2a\u63a8\u9001\u8ba1\u7b97\u7f13\u5b58\u8868\u6210\u529f");
    }

    private List<Long> queryFeeDetailPks(Long feeId, TotalExecutionVO totalExecutionVO) {
        LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeId, (Object)feeId);
        scopeQuery.eq(FeeDetailScopeEntity::getBillCode, (Object)totalExecutionVO.getBussinessType());
        scopeQuery.eq(FeeDetailScopeEntity::getPropertyValue, (Object)totalExecutionVO.getProperty());
        List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
        if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
            return scopeEntities.stream().map(FeeDetailScopeEntity::getFeeDetailId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private Set<Long> cacheDetails(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks) {
        ArrayList<DetailCacheEntity> insertList = new ArrayList<DetailCacheEntity>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        queryWrapper.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List detailEntities = this.dutyDetailService.list((Wrapper)queryWrapper);
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        for (DutyDetailEntity detailEntity : detailEntities) {
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId()) {
                parentIdList.add(detailEntity.getFeeDetailId());
            }
            detailIdList.add(detailEntity.getId());
        }
        HashMap ctyMap = new HashMap();
        if (CollectionUtils.isNotEmpty(parentIdList)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(FeeDetailEntity::getParentId, parentIdList);
            List feeDetailEntities = this.feeDetailService.list((Wrapper)query);
            for (Object detailEntity : feeDetailEntities) {
                ArrayList<Object> list = ctyMap.containsKey(((FeeDetailEntity)((Object)detailEntity)).getParentId()) ? (List)ctyMap.get(((FeeDetailEntity)((Object)detailEntity)).getParentId()) : new ArrayList<Object>();
                list.add(detailEntity);
                ctyMap.put(((FeeDetailEntity)((Object)detailEntity)).getParentId(), list);
            }
        }
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.in(DutyDetailItemEntity::getDutyDetailId, detailIdList);
        List itemAllEntityList = this.dutyDetailItemService.list((Wrapper)itemQuery);
        HashMap itemAllMap = new HashMap();
        for (DutyDetailItemEntity itemEntity : itemAllEntityList) {
            ArrayList<DutyDetailItemEntity> list = itemAllMap.containsKey(itemEntity.getDutyDetailId()) ? (List)itemAllMap.get(itemEntity.getDutyDetailId()) : new ArrayList<DutyDetailItemEntity>();
            list.add(itemEntity);
            itemAllMap.put(itemEntity.getDutyDetailId(), list);
        }
        LambdaQueryWrapper detailQuery = new LambdaQueryWrapper();
        detailQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        List detailCacheAllEntities = this.detailCacheService.list((Wrapper)detailQuery);
        HashMap itemcacheAllMap = new HashMap();
        for (DetailCacheEntity cacheEntity : detailCacheAllEntities) {
            ArrayList<DetailCacheEntity> list = itemcacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)itemcacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<DetailCacheEntity>();
            list.add(cacheEntity);
            itemcacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity detailEntity : detailEntities) {
            ArrayList<Long> categoryList = new ArrayList();
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId() && ctyMap.containsKey(detailEntity.getFeeDetailId())) {
                List list = (List)ctyMap.get(detailEntity.getFeeDetailId());
                categoryList = list.stream().map(FeeDetailEntity::getCategoryId).collect(Collectors.toList());
            }
            List itemEntityList = (List)itemAllMap.get(detailEntity.getId());
            Map<Object, Object> itemMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemEntityList)) {
                itemMap = itemEntityList.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }
            List detailCacheEntities = (List)itemcacheAllMap.get(detailEntity.getId());
            Map<Object, Object> itemcacheMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)detailCacheEntities)) {
                itemcacheMap = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                Long docId = detailExecutionVO.getDocId();
                if (!this.check(detailEntity, detailExecutionVO, categoryList)) continue;
                DetailCacheEntity cacheEntity = null;
                if (itemcacheMap.containsKey(docId)) {
                    cacheEntity = (DetailCacheEntity)((Object)itemcacheMap.get(docId));
                } else {
                    if (itemMap.containsKey(docId)) {
                        DutyDetailItemEntity itemEntity = (DutyDetailItemEntity)((Object)itemMap.get(docId));
                        cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)((Object)itemEntity), DetailCacheEntity.class));
                        cacheEntity.setDutyItemId(itemEntity.getId());
                        cacheEntity.setSpec(itemEntity.getModel());
                    } else {
                        cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)detailExecutionVO, DetailCacheEntity.class));
                        if (detailExecutionVO.getCategoryFlag().booleanValue()) {
                            cacheEntity.setCode(detailExecutionVO.getCategoryCode());
                            cacheEntity.setName(detailExecutionVO.getCategoryName());
                        }
                        cacheEntity.setPrice(null);
                        cacheEntity.setTaxPrice(null);
                        cacheEntity.setModel(detailExecutionVO.getSpec());
                        cacheEntity.setDutyDetailId(detailEntity.getId());
                        cacheEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                        cacheEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                        cacheEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    }
                    cacheEntity.setProjectId(dutyEntity.getProjectId());
                }
                cacheEntity.setBillCategory(executionVO.getTotalVO().getBillCategory());
                DutyCalcUtil.setDetailValue(cacheEntity, detailExecutionVO, executionVO.getTotalVO());
                insertList.add(cacheEntity);
            }
        }
        HashSet<Long> keySet = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.detailCacheService.saveOrUpdateBatch(insertList);
            for (DetailCacheEntity cacheEntity : insertList) {
                BigDecimal otherTotal;
                BigDecimal storeTotal;
                BigDecimal contTotal;
                BigDecimal planTotal;
                BigDecimal total;
                if (null != cacheEntity.getDutyItemId() || null != (total = ComputeUtil.safeAdd((BigDecimal)(planTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getPlanNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getPlanMoney(), cacheEntity.getPlanTaxMoney()})), (BigDecimal[])new BigDecimal[]{contTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getContNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getContMoney(), cacheEntity.getContTaxMoney()}), storeTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getStoreNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getStoreMoney(), cacheEntity.getStoreTaxMoney()}), otherTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getOtherNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getOtherMoney(), cacheEntity.getOtherTaxMoney()})})) && 0 != total.intValue()) continue;
                keySet.add(cacheEntity.getId());
            }
        }
        return keySet;
    }

    private boolean check(DutyDetailEntity detailEntity, DetailExecutionVO detailExecutionVO, List<Long> categoryList) {
        if (null == detailEntity.getCategoryId() && !DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(detailExecutionVO.getDocType())) {
            boolean flag = false;
            if (CollectionUtils.isNotEmpty(categoryList)) {
                for (Long category : categoryList) {
                    if (null == detailExecutionVO.getCategoryInnerCode() || !detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(category))) continue;
                    flag = true;
                }
            }
            return flag;
        }
        if (!detailEntity.getLeafFlag().booleanValue()) {
            return false;
        }
        if (detailEntity.getDocType().compareTo(detailExecutionVO.getDocType()) != 0) {
            return false;
        }
        return null != detailExecutionVO.getCategoryInnerCode() && detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(detailEntity.getCategoryId()));
    }

    private void cacheTotal(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks) {
        ArrayList<TotalCacheEntity> insertList = new ArrayList<TotalCacheEntity>();
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        LambdaQueryWrapper totalQuery = new LambdaQueryWrapper();
        totalQuery.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        totalQuery.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List dutyDetailEntities = this.dutyDetailService.list((Wrapper)totalQuery);
        List detailIdList = dutyDetailEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(TotalCacheEntity::getDutyDetailId, detailIdList);
        List totalCacheAllEntities = this.totalCacheService.list((Wrapper)query);
        HashMap totalMap = new HashMap();
        for (TotalCacheEntity cacheEntity : totalCacheAllEntities) {
            ArrayList<TotalCacheEntity> list = totalMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)totalMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<TotalCacheEntity>();
            list.add(cacheEntity);
            totalMap.put(cacheEntity.getDutyDetailId(), list);
        }
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        itemQuery.eq(DetailCacheEntity::getBillCategory, (Object)totalExecutionVO.getBillCategory());
        List itemEntityAllListdb = this.detailCacheService.list((Wrapper)itemQuery);
        HashMap cacheAllMap = new HashMap();
        for (DetailCacheEntity cacheEntity : itemEntityAllListdb) {
            ArrayList<DetailCacheEntity> list = cacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)cacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<DetailCacheEntity>();
            list.add(cacheEntity);
            cacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            List totalCacheEntities = (List)totalMap.get(dutyDetailEntity.getId());
            TotalCacheEntity totalCacheEntity = CollectionUtils.isNotEmpty((Collection)totalCacheEntities) ? (TotalCacheEntity)((Object)totalCacheEntities.get(0)) : (TotalCacheEntity)((Object)BeanMapper.map((Object)((Object)dutyDetailEntity), TotalCacheEntity.class));
            totalCacheEntity.setDutyDetailId(dutyDetailEntity.getId());
            List itemEntityList = (List)cacheAllMap.get(dutyDetailEntity.getId());
            DutyCalcUtil.setValue(totalCacheEntity, itemEntityList, totalExecutionVO);
            insertList.add(totalCacheEntity);
        }
        List resultMapList = BeanMapper.mapList(insertList, Map.class);
        List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);
        DutyCalcUtil.gatherMnyAndNum(null, treeData);
        ArrayList<TotalCacheEntity> entities = new ArrayList<TotalCacheEntity>();
        this.treeToList(treeData, entities);
        for (TotalCacheEntity entity : entities) {
            if (!BooleanUtils.isTrue((Boolean)entity.getSelfScopeFlag()) || !BooleanUtils.isFalse((Boolean)entity.getLeafFlag()) || null != entity.getAllCostFlag() && !BooleanUtils.isFalse((Boolean)entity.getAllCostFlag())) continue;
            DutyCalcUtil.setValue(entity, totalExecutionVO);
        }
        if (CollectionUtils.isNotEmpty(entities)) {
            this.totalCacheService.saveOrUpdateBatch(entities);
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<TotalCacheEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((TotalCacheEntity)((Object)BeanMapper.map(ypd, TotalCacheEntity.class)));
        }
    }
}

