package com.ejianc.business.sx2j.build.vo;

import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 房建-已完工程及设备保护测算表
 *
 * @author generator
 *
 */
public class BuildCompleteVO extends CommonImportDataVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long dutyId; // 目标责任成本主键
    private Long parentId; // pid
    private Long tid; // 前端生成树形主键
    private Boolean leafFlag; // 是否末级
    private String treeIndex; // 序号
    private String completeName; // 分项名称
    private String completeCode; // 编码
    private String completeUnitName; // 单位
    private BigDecimal completeNum; // 数量
    private BigDecimal completeTaxPrice; // 含税单价（元）
    private BigDecimal completeRate; // 专项进项税税率(%)
    private BigDecimal completePrice; // 不含进项税单价
    private BigDecimal completeTaxMny; // 进项税合计
    private BigDecimal completeMny; // 不含进项税合计
    private BigDecimal completeTax; // 进项税合计
    private String completeMemo; // 备注

    private String tpid; // 前端生成树形父主键
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }


    public Long getDutyId() {
        return dutyId;
    }

    public void setDutyId(Long dutyId) {
        this.dutyId = dutyId;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    public String getCompleteName() {
        return completeName;
    }

    public void setCompleteName(String completeName) {
        this.completeName = completeName;
    }
    public String getCompleteCode() {
        return completeCode;
    }

    public void setCompleteCode(String completeCode) {
        this.completeCode = completeCode;
    }
    public String getCompleteUnitName() {
        return completeUnitName;
    }

    public void setCompleteUnitName(String completeUnitName) {
        this.completeUnitName = completeUnitName;
    }
    public BigDecimal getCompleteNum() {
        return completeNum;
    }

    public void setCompleteNum(BigDecimal completeNum) {
        this.completeNum = completeNum;
    }
    public BigDecimal getCompleteTaxPrice() {
        return completeTaxPrice;
    }

    public void setCompleteTaxPrice(BigDecimal completeTaxPrice) {
        this.completeTaxPrice = completeTaxPrice;
    }
    public BigDecimal getCompleteRate() {
        return completeRate;
    }

    public void setCompleteRate(BigDecimal completeRate) {
        this.completeRate = completeRate;
    }
    public BigDecimal getCompletePrice() {
        return completePrice;
    }

    public void setCompletePrice(BigDecimal completePrice) {
        this.completePrice = completePrice;
    }
    public BigDecimal getCompleteTaxMny() {
        return completeTaxMny;
    }

    public void setCompleteTaxMny(BigDecimal completeTaxMny) {
        this.completeTaxMny = completeTaxMny;
    }
    public BigDecimal getCompleteMny() {
        return completeMny;
    }

    public void setCompleteMny(BigDecimal completeMny) {
        this.completeMny = completeMny;
    }
    public BigDecimal getCompleteTax() {
        return completeTax;
    }

    public void setCompleteTax(BigDecimal completeTax) {
        this.completeTax = completeTax;
    }
    public String getCompleteMemo() {
        return completeMemo;
    }

    public void setCompleteMemo(String completeMemo) {
        this.completeMemo = completeMemo;
    }
    /***转换使用**/


    @Override
    public String getcCode() {
        return this.completeCode;
    }

    @Override
    public String getcName() {
        return this.completeName;
    }

    @Override
    public String getcUnitName() {
        return this.completeUnitName;
    }

    @Override
    public Long getcId() {
        return this.getId();
    }

    @Override
    public BigDecimal getcTaxRate() {
        return this.completeRate;
    }

    @Override
    public BigDecimal getcPrice() {
        return this.completePrice;
    }

    @Override
    public BigDecimal getcTaxPrice() {
        return this.completeTaxPrice;
    }

    @Override
    public BigDecimal getcAmount() {
        return this.completeNum;
    }

    @Override
    public BigDecimal getcMny() {
        return this.completeMny;
    }

    @Override
    public BigDecimal getcTaxMny() {
        return this.completeTaxMny;
    }
    @Override
    public Boolean getcLeafFlag() {
        return this.leafFlag;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
}
