package com.ejianc.business.sx2j.build.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.sx2j.build.bean.*;
import com.ejianc.business.sx2j.build.mapper.BuildDutyMapper;
import com.ejianc.business.sx2j.build.service.*;
import com.ejianc.business.sx2j.build.vo.*;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.DetailIndexExcelReader2;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ImportBuildVo;
import com.ejianc.business.targetcost.vo.ImportErrorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 房建-目标责任成本
 *
 * @author generator
 */
@Service("buildDutyService")
public class BuildDutyServiceImpl extends BaseServiceImpl<BuildDutyMapper, BuildDutyEntity> implements IBuildDutyService {
    private static final String BILL_CODE = "TC_DUTY";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBuildPlansService buildPlansService;
    @Autowired
    private IBuildRgcostService buildRgcostService;
    @Autowired
    private IBuildSubService buildSubService;
    @Autowired
    private IBuildMaterialService buildMaterialService;
    @Autowired
    private IBuildAppointService buildAppointService;
    @Autowired
    private IBuildRmatService buildRmatService;
    @Autowired
    private IBuildEquipmentService buildEquipmentService;
    @Autowired
    private IBuildSafeService buildSafeService;
    @Autowired
    private IBuildNightService buildNightService;
    @Autowired
    private IBuildCompleteService buildCompleteService;
    @Autowired
    private IBuildPrecipitationService buildPrecipitationService;
    @Autowired
    private IBuildTemporaryService buildTemporaryService;
    @Autowired
    private IBuildTemplatesService buildTemplatesService;
    @Autowired
    private IBuildIndirectService buildIndirectService;
    @Autowired
    private IBuildScaffoldService buildScaffoldService;
    @Autowired
    private IBuildStimulateService buildStimulateService;
    @Autowired
    private IBuildMeasureService buildMeasureService;
    @Autowired
    private IBuildManageService buildManageService;
    @Autowired
    private IBuildFeesService buildFeesService;
    @Autowired
    private IBuildOtherService buildOtherService;
    @Autowired
    private IDutyService dutyService;
    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Override
    public CommonResponse<BuildDutyVO> saveOrUpdate(BuildDutyVO saveOrUpdateVO) {
        BuildDutyEntity entity = BeanMapper.map(saveOrUpdateVO, BuildDutyEntity.class);
        if (entity.getLastDutyId() != null) {
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getFirstImportId, entity.getBaseDutyId());
            queryWrapper.isNotNull(DutyEntity::getLastDutyId);
            queryWrapper.notIn(DutyEntity::getBillState, "1,3");
            if (dutyService.count(queryWrapper) > 0) {
                throw new BusinessException("该单据存在变更中的【目标责任成本】单，不允许新增变更！");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (null==entity.getLastDutyId()) {
                LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(BuildDutyEntity::getProjectId, entity.getProjectId());
                if (super.count(queryWrapper) > 0) {
                    throw new BusinessException("该项目已存在目标责任成本，不允许重复新增！");
                }            }
        }
        if (null == entity.getDutyVersion()) {
            entity.setDutyVersion(1);
        }
        entity = countMny(entity);
        entity.setConvertFlag(0);
        super.saveOrUpdate(entity, false);
        //更新实体

        if (entity.getBaseDutyId() == null && 0 == entity.getChangeState()) {
            entity.setBaseDutyId(entity.getId());
            entity.setOneTime(entity.getCreateTime());
        }
        //变更单保存
        if (entity.getLastDutyId() != null) {
            BuildDutyEntity revise = super.getById(entity.getLastDutyId());
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.变更中.getCode());
            super.saveOrUpdate(revise);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildPlansList())) {
            //说明有子表信息，不是第一次点下一步保存   需要重新计算 计划汇总表
            List<BuildPlansEntity> dutyPlansEntityList = entity.getBuildPlansList();
            if (CollectionUtils.isNotEmpty(dutyPlansEntityList)) {
                buildPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
            }
        }
        super.updateById(entity);
        //维护父子级关系
        updateByPid(entity);
        BuildDutyVO vo = queryDetail(entity.getId());
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse saveCheckProject(Long projectId){
        LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BuildDutyEntity::getProjectId,projectId);
        if (super.count(queryWrapper) > 0) {
            return CommonResponse.error("该项目已存在目标责任成本，不允许重复新增！");
        }
        return CommonResponse.success();
    }

    private BuildDutyEntity countMny(BuildDutyEntity entity) {
        BigDecimal totalMny1 = BigDecimal.ZERO;//分部分项费用汇总表小计
        BigDecimal totalMny2 = BigDecimal.ZERO;//措施项目费用汇总表小计
        BigDecimal indirectMny = BigDecimal.ZERO;//间接费汇总表小计
        BigDecimal stimulateMny = BigDecimal.ZERO;//项目激励汇总表小计
        BigDecimal totalTax = BigDecimal.ZERO;//增值税进项税合计
        BigDecimal rgcostMny = BigDecimal.ZERO;
        BigDecimal materialMny = BigDecimal.ZERO;
        BigDecimal templatesMny = BigDecimal.ZERO;
        BigDecimal scaffoldMny = BigDecimal.ZERO;
        BigDecimal appointMny = BigDecimal.ZERO;
        BigDecimal subMny = BigDecimal.ZERO;
        BigDecimal equipmentMny = BigDecimal.ZERO;
        BigDecimal safeMny1 = BigDecimal.ZERO;//安全文明施工费
        BigDecimal safeMny2 = BigDecimal.ZERO;//环境保护费
        BigDecimal safeMny3 = BigDecimal.ZERO;//临时设施
        BigDecimal safeMny4 = BigDecimal.ZERO;//二次搬运
        BigDecimal nightMny1 = BigDecimal.ZERO;
        BigDecimal nightMny2 = BigDecimal.ZERO;
        BigDecimal completeMny = BigDecimal.ZERO;
        BigDecimal precipitationMny = BigDecimal.ZERO;
        BigDecimal measureMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getBuildRgcostList())) {
            rgcostMny = entity.getBuildRgcostList().stream().filter(e ->!"del".equals(e.getRowState()) &&
                    e.getRgcostMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getRgcostMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildRgcostList().stream().filter(e -> e.getRowState() != "del" && e.getRgcostTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getRgcostTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, rgcostMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildMaterialList())) {
            materialMny = entity.getBuildMaterialList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getMaterialMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getMaterialMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildMaterialList().stream().filter(e -> e.getRowState() != "del" && e.getMaterialTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getMaterialTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, materialMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildTemplatesList())) {
            templatesMny = entity.getBuildTemplatesList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getTemplatesMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getTemplatesMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildTemplatesList().stream().filter(e -> e.getRowState() != "del" && e.getTemplatesTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getTemplatesTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, templatesMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildScaffoldList())) {
            scaffoldMny = entity.getBuildScaffoldList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getScaffoldMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getScaffoldMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildScaffoldList().stream().filter(e -> e.getRowState() != "del" && e.getScaffoldTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getScaffoldTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, scaffoldMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildAppointList())) {
            appointMny = entity.getBuildAppointList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getAppointMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getAppointMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildAppointList().stream().filter(e -> e.getRowState() != "del" && e.getAppointTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getAppointTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, appointMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildSubList())) {
            subMny = entity.getBuildSubList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getSubMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getSubMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildSubList().stream().filter(e -> e.getRowState() != "del" && e.getSubTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getSubTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, subMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildEquipmentList())) {
            equipmentMny = entity.getBuildEquipmentList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getEquipmentMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getEquipmentMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildEquipmentList().stream().filter(e -> e.getRowState() != "del" && e.getEquipmentTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getEquipmentTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny1 = ComputeUtil.safeAdd(totalMny1, equipmentMny);
        }
        // 用TreeIndex分类四个类型
        if (CollectionUtils.isNotEmpty(entity.getBuildSafeList())) {
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildSafeList().stream().filter(e -> e.getRowState() != "del" && e.getSafeTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getSafeTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            for (BuildSafeEntity detailEntity : entity.getBuildSafeList()) {
                String[] treeIndexes = detailEntity.getTreeIndex().split("\\.");
                if (detailEntity.getSafeMny() != null && detailEntity.getParentId() != null && detailEntity.getLeafFlag() && detailEntity.getRowState()!="del") {
                    switch (treeIndexes[0]) {
                        case "1":
                            safeMny1 = ComputeUtil.safeAdd(safeMny1, detailEntity.getSafeMny());
                            break;
                        case "2":
                            safeMny2 = ComputeUtil.safeAdd(safeMny2, detailEntity.getSafeMny());
                            break;
                        case "3":
                            safeMny3 = ComputeUtil.safeAdd(safeMny3, detailEntity.getSafeMny());
                            break;
                        case "4":
                            safeMny4 = ComputeUtil.safeAdd(safeMny4, detailEntity.getSafeMny());
                            break;
                    }
                }
            }
            BigDecimal totalSafeMny = entity.getBuildSafeList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getSafeMny() != null && e.getLeafFlag()).map(it -> it.getSafeMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny2 = ComputeUtil.safeAdd(totalMny2, totalSafeMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildNightList())) {
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildNightList().stream().filter(e -> e.getRowState() != "del" && e.getNightTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getNightTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            for (BuildNightEntity nightEntity : entity.getBuildNightList()) {
                switch (nightEntity.getNightName()) {
                    case "冬雨季施工费":
                        nightMny1 = nightEntity.getNightMny();
                        totalMny2 = ComputeUtil.safeAdd(totalMny2, nightMny1);
                        break;
                    case "夜间施工费":
                        nightMny2 = nightEntity.getNightMny();
                        totalMny2 = ComputeUtil.safeAdd(totalMny2, nightMny2);
                        break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildCompleteList())) {
            completeMny = entity.getBuildCompleteList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getCompleteMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getCompleteMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
//            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildCompleteList().stream().filter(e -> e.getRowState() != "del" && e.getCompleteTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getCompleteTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny2 = ComputeUtil.safeAdd(totalMny2, completeMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildPrecipitationList())) {
            precipitationMny = entity.getBuildPrecipitationList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getPrecipitationMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getPrecipitationMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildPrecipitationList().stream().filter(e -> e.getRowState() != "del" && e.getPrecipitationTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getPrecipitationTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny2 = ComputeUtil.safeAdd(totalMny2, precipitationMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildMeasureList())) {
            measureMny = entity.getBuildMeasureList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getMeasureMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getMeasureMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildMeasureList().stream().filter(e -> e.getRowState() != "del" && e.getMeasureTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getMeasureTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
            totalMny2 = ComputeUtil.safeAdd(totalMny2, measureMny);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildIndirectList())) {
            List<BuildIndirectEntity> collect = entity.getBuildIndirectList().stream().filter(e ->!"del".equals(e.getRowState())&& e.getIndirectMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).collect(Collectors.toList());
            indirectMny = entity.getBuildIndirectList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getIndirectMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getIndirectMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalTax = ComputeUtil.safeAdd(totalTax, entity.getBuildIndirectList().stream().filter(e -> e.getRowState() != "del" && e.getIndirectTax() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getIndirectTax()).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildStimulateList())) {
            stimulateMny = entity.getBuildStimulateList().stream().filter(e ->!"del".equals(e.getRowState()) && e.getStimulateMny() != null && null != e.getLeafFlag() && e.getLeafFlag()).map(it -> it.getStimulateMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        logger.info("增值税进项税合计:---"+totalTax);
        for (BuildPlansEntity plansEntity : entity.getBuildPlansList()) {
            switch (plansEntity.getPlansName()) {
                case "人工费":
                    plansEntity.setPlansTaxMny(rgcostMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "材料费":
                    plansEntity.setPlansTaxMny(materialMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "模板及支撑":
                    plansEntity.setPlansTaxMny(templatesMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "脚手架":
                    plansEntity.setPlansTaxMny(scaffoldMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "甲方指定分包项目":
                    plansEntity.setPlansTaxMny(appointMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "专业分包工程费":
                    plansEntity.setPlansTaxMny(subMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "施工机具使用费":
                    plansEntity.setPlansTaxMny(equipmentMny);plansEntity.setPlansCountTaxMny(totalMny1);break;
                case "安全文明施工费":
                    plansEntity.setPlansTaxMny(safeMny1);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "环境保护费":
                    plansEntity.setPlansTaxMny(safeMny2);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "临时设施":
                    plansEntity.setPlansTaxMny(safeMny3);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "二次搬运":
                    plansEntity.setPlansTaxMny(safeMny4);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "冬雨季施工费":
                    plansEntity.setPlansTaxMny(nightMny1);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "夜间施工费":
                    plansEntity.setPlansTaxMny(nightMny2);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "已完工程及设备保护":
                    plansEntity.setPlansTaxMny(completeMny);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "排、降水":
                    plansEntity.setPlansTaxMny(precipitationMny);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "其他措施费":
                    plansEntity.setPlansTaxMny(measureMny);plansEntity.setPlansCountTaxMny(totalMny2);break;
                case "间接费":
                    plansEntity.setPlansTaxMny(indirectMny);plansEntity.setPlansCountTaxMny(indirectMny);break;
                case "项目激励奖":
                    plansEntity.setPlansTaxMny(stimulateMny);plansEntity.setPlansCountTaxMny(stimulateMny);break;
                case "增值税进项税合计":
                    logger.info("增值税进项税合计1:---"+totalTax);
                    plansEntity.setPlansTaxMny(totalTax);plansEntity.setPlansCountTaxMny(totalTax);break;
            }
        }
        BigDecimal totalMny = ComputeUtil.safeAdd(ComputeUtil.safeAdd(totalMny1, totalMny2), indirectMny);
        BigDecimal tax = entity.getBuildPlansList().stream().filter(e -> e.getPlansTaxMny() != null
                && (e.getPlansName().equals("增值税销项税/简易项目计税金额")
                ||e.getPlansName().equals("附加税（城市维护建设税7%、教育费附加3%、地方教育费附加2%）")
                ||e.getPlansName().equals("印花税（税率0.03%）")
                ||e.getPlansName().equals("水利基金（税率0.06%）"))).map(it -> it.getPlansTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTaxMny = ComputeUtil.safeAdd(totalMny, tax);
        for (BuildPlansEntity plansEntity : entity.getBuildPlansList()){
            switch (plansEntity.getPlansName()) {
                case "工程项目预计总成本(无税)":
                    plansEntity.setPlansTaxMny(totalMny);plansEntity.setPlansCountTaxMny(totalMny);break;
                case "增值税进项税合计":
                    logger.info("增值税进项税合计2:---"+totalTax);
                    plansEntity.setPlansTaxMny(totalTax);plansEntity.setPlansCountTaxMny(totalTax);break;
                case "增值税销项税/简易项目计税金额":
                    plansEntity.setPlansCountTaxMny(tax);break;
                case "附加税（城市维护建设税7%、教育费附加3%、地方教育费附加2%）":
                    plansEntity.setPlansCountTaxMny(tax);break;
                case "印花税（税率0.03%）":
                    plansEntity.setPlansCountTaxMny(tax);break;
                case "水利基金（税率0.06%）":
                    plansEntity.setPlansCountTaxMny(tax);break;
                case "合计":
                    plansEntity.setPlansTaxMny(totalTaxMny);plansEntity.setPlansCountTaxMny(totalTaxMny);break;
            }
        }
            return entity;
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long dutyId = null;
        if (StringUtils.isNotEmpty(request.getParameter("dutyId"))) {
            dutyId = Long.valueOf(request.getParameter("dutyId"));
        } else {
            return CommonResponse.error("主表主键为空！");
        }
        BuildDutyEntity buildDutyEntity = super.selectById(dutyId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            Integer size = DetailIndexExcelReader2.getNumberOfSheets(mf);
            logger.error("文件页签数：" + JSONObject.toJSONString(size));

            if (size == null || size != 22) {
                return CommonResponse.error("文件页签数应该为22个，请检查是否有隐藏页签！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);

            List<List<String>> result1 = resList.get(0);
            if (result1.size() > 0 && result1.get(0).size() < 5) {
                return CommonResponse.error("[项目预计总成本测算汇总表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result2 = resList.get(1);
            if (result2.size() > 0 && result2.get(0).size() < 10) {
                return CommonResponse.error("[人工费目标成本控制计划表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result3 = resList.get(3);
            if (result3.size() > 0 && result3.get(0).size() < 12) {
                return CommonResponse.error("[项目材料费测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result4 = resList.get(5);
            if (result4.size() > 0 && result4.get(0).size() < 10) {
                return CommonResponse.error("[项目甲指分包项目测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result5 = resList.get(6);
            if (result5.size() > 0 && result5.get(0).size() < 10) {
                return CommonResponse.error("[项目专业分包工程测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result6 = resList.get(7);
            if (result6.size() > 0 && result6.get(0).size() < 10) {
                return CommonResponse.error("[项目施工机具使用费测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result7 = resList.get(8);
            if (result7.size() > 0 && result7.get(0).size() < 10) {
                return CommonResponse.error("[项目安全文明施工费、环境保护费、临时设施及二次搬运费测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result8 = resList.get(9);
            if (result8.size() > 0 && result8.get(0).size() < 10) {
                return CommonResponse.error("[项目冬雨季、夜间施工测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result9 = resList.get(10);
            if (result9.size() > 0 && result9.get(0).size() < 9) {
                return CommonResponse.error("[项目已完工程及设备保护测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result10 = resList.get(11);
            if (result10.size() > 0 && result10.get(0).size() < 10) {
                return CommonResponse.error("[项目施工排水、降水费测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result11 = resList.get(12);
            if (result11.size() > 0 && result11.get(0).size() < 12) {
                return CommonResponse.error("[项目模板及支撑费用测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result12 = resList.get(13);
            if (result12.size() > 0 && result12.get(0).size() < 12) {
                return CommonResponse.error("[项目脚手架费用测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result13 = resList.get(14);
            if (result13.size() > 0 && result13.get(0).size() < 9) {
                return CommonResponse.error("[项目其他措施费测算表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result14 = resList.get(15);
            if (result14.size() > 0 && result14.get(0).size() < 10) {
                return CommonResponse.error("[项目间接费]数据不完整，请下载最新模板！");
            }
            List<List<String>> result15 = resList.get(16);
            if (result15.size() > 0 && result15.get(0).size() < 9) {
                return CommonResponse.error("[项目激励奖]数据不完整，请下载最新模板！");
            }
            ImportBuildVo importVo1 = excelImportPlan(result1, dutyId);//项目预计总成本测算汇总表
            ImportBuildVo importVo2 = excelImportRgcost(result2, dutyId);//人工费目标成本控制计划表
            ImportBuildVo importVo3 = excelImportMaterial(result3, dutyId);//项目材料费测算表
            ImportBuildVo importVo4 = excelImportAppoint(result4, dutyId);//项目甲指分包项目测算表
            ImportBuildVo importVo5 = excelImportSub(result5, dutyId);//项目专业分包工程测算表
            ImportBuildVo importVo6 = excelImportEquipment(result6, dutyId);//项目施工机具使用费测算表
            ImportBuildVo importVo7 = excelImportSafe(result7, dutyId);//项目安全文明施工费、环境保护费、临时设施及二次搬运费测算表
            ImportBuildVo importVo8 = excelImportNight(result8, dutyId);//项目冬雨季、夜间施工测算表
            ImportBuildVo importVo9 = excelImportComplete(result9, dutyId);//项目已完工程及设备保护测算表
            ImportBuildVo importVo10 = excelImportPrecipitation(result10, dutyId);//项目施工排水、降水费测算表
            ImportBuildVo importVo11 = excelImportTemplates(result11, dutyId);//项目模板及支撑费用测算表
            ImportBuildVo importVo12 = excelImportScaffold(result12, dutyId);//项目脚手架费用测算表
            ImportBuildVo importVo13 = excelImportMeasure(result13, dutyId);//项目其他措施费测算表
            ImportBuildVo importVo14 = excelImportIndirect(result14, dutyId);//项目间接费
            ImportBuildVo importVo15 = excelImportStimulate(result15, dutyId);//项目激励奖


            List<ImportErrorVo> errorList = new ArrayList<>();
            errorList.addAll(importVo1.getErrorList());
            errorList.addAll(importVo2.getErrorList());
            errorList.addAll(importVo3.getErrorList());
            errorList.addAll(importVo4.getErrorList());
            errorList.addAll(importVo5.getErrorList());
            errorList.addAll(importVo6.getErrorList());
            errorList.addAll(importVo7.getErrorList());
            errorList.addAll(importVo8.getErrorList());
            errorList.addAll(importVo9.getErrorList());
            errorList.addAll(importVo10.getErrorList());
            errorList.addAll(importVo11.getErrorList());
            errorList.addAll(importVo12.getErrorList());
            errorList.addAll(importVo13.getErrorList());
            errorList.addAll(importVo14.getErrorList());
            errorList.addAll(importVo15.getErrorList());

            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", 0);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                List<BuildPlansVO> buildPlansList = importVo1.getBuildPlansList(); // 项目预计总成本测算汇总表
                List<BuildRgcostVO> buildRgcostList = importVo2.getBuildRgcostList(); // 人工费目标成本控制计划表
                List<BuildMaterialVO> buildMaterialList = importVo3.getBuildMaterialList(); //项目材料费测算表
                List<BuildAppointVO> buildAppointVOList = importVo4.getBuildAppointVOList();//项目甲指分包项目测算表
                List<BuildSubVO> buildSubList = importVo5.getBuildSubList(); // 项目专业分包工程测算表
                List<BuildEquipmentVO> buildEquipmentList = importVo6.getBuildEquipmentList(); // 项目施工机具使用费测算表
                List<BuildSafeVO> buildSafeList = importVo7.getBuildSafeList(); // 项目安全文明施工费、环境保护费、临时设施及二次搬运费测算表
                List<BuildNightVO> buildNightList = importVo8.getBuildNightList();//项目冬雨季、夜间施工测算表
                List<BuildCompleteVO> buildCompleteList = importVo9.getBuildCompleteList();//项目已完工程及设备保护测算表
                List<BuildPrecipitationVO> buildPrecipitationList = importVo10.getBuildPrecipitationList();//项目施工排水、降水费测算表
                List<BuildTemplatesVO> buildTemplatesList = importVo11.getBuildTemplatesList();//项目模板及支撑费用测算表
                List<BuildScaffoldVO> buildScaffoldList = importVo12.getBuildScaffoldList();//项目脚手架费用测算表
                List<BuildMeasureVO> buildMeasureList = importVo13.getBuildMeasureList(); //项目其他措施费测算表
                List<BuildIndirectVO> buildIndirectList = importVo14.getBuildIndirectList();//项目间接费
                List<BuildStimulateVO> buildStimulateList = importVo15.getBuildStimulateList();//项目激励奖
                int sucNum = buildPlansList.size() + buildRgcostList.size() + buildSubList.size() + buildMaterialList.size() +
                        buildAppointVOList.size() + buildEquipmentList.size() + buildSafeList.size() + buildNightList.size() +
                        buildNightList.size() + buildCompleteList.size() + buildPrecipitationList.size() +
                        buildTemplatesList.size() + buildScaffoldList.size() + buildIndirectList.size() + buildStimulateList.size();
                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", sucNum);
                resp.put("errorNum", 0);

                buildPlansService.remove(new QueryWrapper<BuildPlansEntity>().eq("duty_id", dutyId));
                if (buildPlansList.size() > 0) {
                    List<BuildPlansEntity> buildPlansEntities = BeanMapper.mapList(buildPlansList, BuildPlansEntity.class);
                    buildPlansService.saveOrUpdateBatch(buildPlansEntities, buildPlansEntities.size(), false);
                    for (BuildPlansEntity e:buildPlansEntities){
                        if("工程项目预计总成本(无税)".equals(e.getFeeCategoryName())){
                            buildDutyEntity.setMny(e.getPlansCountTaxMny());
                        }
                        if("工程项目预计总成本(含税)".equals(e.getFeeCategoryName())){
                            buildDutyEntity.setTaxMny(e.getPlansCountTaxMny());
                        }
                    }
                    buildDutyEntity.setConvertFlag(0);//设置未转换
                    super.updateById(buildDutyEntity);
                }
                // 人工费
                buildRgcostService.remove(new QueryWrapper<BuildRgcostEntity>().eq("duty_id", dutyId));
                if (buildRgcostList.size() > 0) {
                    List<BuildRgcostEntity> buildRgcostEntities = BeanMapper.mapList(buildRgcostList, BuildRgcostEntity.class);
                    buildRgcostService.saveOrUpdateBatch(buildRgcostEntities, buildRgcostEntities.size(), false);
                }
                //项目材料费测算表
                buildMaterialService.remove(new QueryWrapper<BuildMaterialEntity>().eq("duty_id", dutyId));
                if (buildMaterialList.size() > 0) {
                    List<BuildMaterialEntity> buildMaterialEntities = BeanMapper.mapList(buildMaterialList, BuildMaterialEntity.class);
                    buildMaterialService.saveOrUpdateBatch(buildMaterialEntities, buildMaterialEntities.size(), false);
                }
                //项目甲指分包项目测算表
                buildAppointService.remove(new QueryWrapper<BuildAppointEntity>().eq("duty_id", dutyId));
                if (buildAppointVOList.size() > 0) {
                    List<BuildAppointEntity> buildAppointEntities = BeanMapper.mapList(buildAppointVOList, BuildAppointEntity.class);
                    buildAppointService.saveOrUpdateBatch(buildAppointEntities, buildAppointEntities.size(), false);
                }
                //项目专业分包工程测算表
                buildSubService.remove(new QueryWrapper<BuildSubEntity>().eq("duty_id", dutyId));
                if (buildSubList.size() > 0) {
                    List<BuildSubEntity> buildSubEntities = BeanMapper.mapList(buildSubList, BuildSubEntity.class);
                    buildSubService.saveOrUpdateBatch(buildSubEntities, buildSubEntities.size(), false);
                }
                //项目施工机具使用费测算表
                buildEquipmentService.remove(new QueryWrapper<BuildEquipmentEntity>().eq("duty_id", dutyId));
                if (buildEquipmentList.size() > 0) {
                    List<BuildEquipmentEntity> buildEquipmentEntities = BeanMapper.mapList(buildEquipmentList, BuildEquipmentEntity.class);
                    buildEquipmentService.saveOrUpdateBatch(buildEquipmentEntities, buildEquipmentEntities.size(), false);
                }
                //项目安全文明施工费、环境保护费、临时设施及二次搬运费测算表
                buildSafeService.remove(new QueryWrapper<BuildSafeEntity>().eq("duty_id", dutyId));
                if (buildSafeList.size() > 0) {
                    List<BuildSafeEntity> buildSafeEntities = BeanMapper.mapList(buildSafeList, BuildSafeEntity.class);
                    buildSafeService.saveOrUpdateBatch(buildSafeEntities, buildSafeEntities.size(), false);
                }
                //项目冬雨季、夜间施工测算表
                buildNightService.remove(new QueryWrapper<BuildNightEntity>().eq("duty_id", dutyId));
                if (buildNightList.size() > 0) {
                    List<BuildNightEntity> buildNightEntities = BeanMapper.mapList(buildNightList, BuildNightEntity.class);
                    buildNightService.saveOrUpdateBatch(buildNightEntities, buildNightEntities.size(), false);
                }
                //项目已完工程及设备保护测算表
                buildCompleteService.remove(new QueryWrapper<BuildCompleteEntity>().eq("duty_id", dutyId));
                if (buildCompleteList.size() > 0) {
                    List<BuildCompleteEntity> buildCompleteEntities = BeanMapper.mapList(buildCompleteList, BuildCompleteEntity.class);
                    buildCompleteService.saveOrUpdateBatch(buildCompleteEntities, buildCompleteEntities.size(), false);
                }
                //项目施工排水、降水费测算表
                buildPrecipitationService.remove(new QueryWrapper<BuildPrecipitationEntity>().eq("duty_id", dutyId));
                if (buildPrecipitationList.size() > 0) {
                    List<BuildPrecipitationEntity> buildPrecipitationEntities = BeanMapper.mapList(buildPrecipitationList, BuildPrecipitationEntity.class);
                    buildPrecipitationService.saveOrUpdateBatch(buildPrecipitationEntities, buildPrecipitationEntities.size(), false);
                }
                //项目模板及支撑费用测算表
                buildTemplatesService.remove(new QueryWrapper<BuildTemplatesEntity>().eq("duty_id", dutyId));
                if (buildTemplatesList.size() > 0) {
                    List<BuildTemplatesEntity> buildTemplatesEntities = BeanMapper.mapList(buildTemplatesList, BuildTemplatesEntity.class);
                    buildTemplatesService.saveOrUpdateBatch(buildTemplatesEntities, buildTemplatesEntities.size(), false);
                }
                //项目脚手架费用测算表
                buildScaffoldService.remove(new QueryWrapper<BuildScaffoldEntity>().eq("duty_id", dutyId));
                if (buildScaffoldList.size() > 0) {
                    List<BuildScaffoldEntity> buildScaffoldEntities = BeanMapper.mapList(buildScaffoldList, BuildScaffoldEntity.class);
                    buildScaffoldService.saveOrUpdateBatch(buildScaffoldEntities, buildScaffoldEntities.size(), false);
                }

                //项目间接费
                buildIndirectService.remove(new QueryWrapper<BuildIndirectEntity>().eq("duty_id", dutyId));
                if (buildIndirectList.size() > 0) {
                    List<BuildIndirectEntity> buildIndirectEntities = BeanMapper.mapList(buildIndirectList, BuildIndirectEntity.class);
                    buildIndirectService.saveOrUpdateBatch(buildIndirectEntities, buildIndirectEntities.size(), false);
                }
                //项目激励奖
                buildStimulateService.remove(new QueryWrapper<BuildStimulateEntity>().eq("duty_id", dutyId));
                if (buildStimulateList.size() > 0) {
                    List<BuildStimulateEntity> buildStimulateEntities = BeanMapper.mapList(buildStimulateList, BuildStimulateEntity.class);
                    buildStimulateService.saveOrUpdateBatch(buildStimulateEntities, buildStimulateEntities.size(), false);
                }
                //项目其他措施费测算表
                buildMeasureService.remove(new QueryWrapper<BuildMeasureEntity>().eq("duty_id", dutyId));
                if (buildMeasureList.size() > 0) {
                    List<BuildMeasureEntity> buildMeasureEntities = BeanMapper.mapList(buildMeasureList, BuildMeasureEntity.class);
                    buildMeasureService.saveOrUpdateBatch(buildMeasureEntities, buildMeasureEntities.size(), false);
                }


            }
            return CommonResponse.success(resp);
        }
    }

    @Override
    public BuildDutyVO queryDetail(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);

        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList(); // 房建-人工费
        vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        List<BuildSubVO> buildSubList = vo.getBuildSubList(); // 房建-专业分包
        vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList(); // 房建-主要材料
        vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList(); // 房建-机械设备费
        vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(buildEquipmentList));
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList(); // 房建-安全文明施工费
        vo.setBuildSafeList(TreeNodeBUtil.buildTree(buildSafeList));
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList(); // 房建-其他措施费
        vo.setBuildMeasureList(TreeNodeBUtil.buildTree(buildMeasureList));
//        List<BuildStimulateVO> buildStimulateList = vo.getBuildStimulateList();//项目激励奖
//        vo.setBuildStimulateList(buildStimulateList);

        List<BuildIndirectVO> buildIndirectList = vo.getBuildIndirectList();//间接费
        vo.setBuildIndirectList(TreeNodeBUtil.buildTree(buildIndirectList));
        List<BuildScaffoldVO> buildScaffoldList = vo.getBuildScaffoldList();//脚手架
        vo.setBuildScaffoldList(TreeNodeBUtil.buildTree(buildScaffoldList));
        List<BuildTemplatesVO> buildTemplatesList = vo.getBuildTemplatesList();//项目模板及支撑费用
        vo.setBuildTemplatesList(TreeNodeBUtil.buildTree(buildTemplatesList));
        List<BuildPrecipitationVO> buildPrecipitationList = vo.getBuildPrecipitationList();//建-排水、降水费
        vo.setBuildPrecipitationList(TreeNodeBUtil.buildTree(buildPrecipitationList));
        List<BuildCompleteVO> buildCompleteList = vo.getBuildCompleteList();//已完工程及设备保护测算表
        vo.setBuildCompleteList(TreeNodeBUtil.buildTree(buildCompleteList));
        List<BuildNightVO> buildNightList = vo.getBuildNightList();//项目冬雨季、夜间施工
        vo.setBuildNightList(TreeNodeBUtil.buildTree(buildNightList));
        List<BuildAppointVO> buildAppointList = vo.getBuildAppointList();//甲指分包
        vo.setBuildAppointList(TreeNodeBUtil.buildTree(buildAppointList));
        List<BuildDutyRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BuildDutyEntity::getBaseDutyId, entity.getBaseDutyId());
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(BuildDutyEntity::getBillState, billStatusList);
        queryWrapper.ne(BuildDutyEntity::getId, id);
        queryWrapper.orderByAsc(BuildDutyEntity::getCreateTime);
        List<BuildDutyEntity> roadbridgeDutyEntities = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(roadbridgeDutyEntities)) {
            list = BeanMapper.mapList(roadbridgeDutyEntities, BuildDutyRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public BuildDutyVO queryChangeDetail(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);

        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList();
        if (CollectionUtils.isNotEmpty(buildPlansList)) {
            buildPlansList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setBuildPlansList(buildPlansList);
        }

        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();
        if (CollectionUtils.isNotEmpty(buildRgcostList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildRgcostList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildRgcostVO cdEntity : buildRgcostList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        }

        List<BuildSubVO> buildSubList = vo.getBuildSubList(); // 房建-专业分包
        if (CollectionUtils.isNotEmpty(buildSubList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildSubList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildSubVO cdEntity : buildSubList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        }

        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList(); // 房建-主要材料
        if (CollectionUtils.isNotEmpty(buildMaterialList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildMaterialList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildMaterialVO cdEntity : buildMaterialList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        }

        List<BuildStimulateVO> buildStimulateList = vo.getBuildStimulateList(); // 房建-项目激励奖
        if (CollectionUtils.isNotEmpty(buildStimulateList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildStimulateList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildStimulateVO cdEntity : buildStimulateList) {
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildStimulateList(buildStimulateList);
        }
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList(); // 房建-机械设备费
        if (CollectionUtils.isNotEmpty(buildEquipmentList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildEquipmentList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildEquipmentVO cdEntity : buildEquipmentList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(buildEquipmentList));
        }

        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList(); // 房建-安全文明施工费
        if (CollectionUtils.isNotEmpty(buildSafeList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildSafeList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildSafeVO cdEntity : buildSafeList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildSafeList(TreeNodeBUtil.buildTree(buildSafeList));
        }

        List<BuildIndirectVO>  buildIndirectList = vo.getBuildIndirectList(); // 房建-间接费
        if (CollectionUtils.isNotEmpty(buildIndirectList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildIndirectList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildIndirectVO cdEntity : buildIndirectList) {
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildIndirectList(buildIndirectList);
        }
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList(); // 房建-其他措施费
        if (CollectionUtils.isNotEmpty(buildMeasureList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildMeasureList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildMeasureVO cdEntity : buildMeasureList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildMeasureList(TreeNodeBUtil.buildTree(buildMeasureList));
        }

        List<BuildScaffoldVO> buildScaffoldList = vo.getBuildScaffoldList(); // 房建-现场管理费
        if (CollectionUtils.isNotEmpty(buildScaffoldList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildScaffoldList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildScaffoldVO cdEntity : buildScaffoldList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildScaffoldList(TreeNodeBUtil.buildTree(buildScaffoldList));
        }

        List<BuildTemplatesVO> buildTemplatesList = vo.getBuildTemplatesList(); // 房建-项目模板及支撑费用
        if (CollectionUtils.isNotEmpty(buildTemplatesList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildTemplatesList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildTemplatesVO cdEntity : buildTemplatesList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildTemplatesList(TreeNodeBUtil.buildTree(buildTemplatesList));
        }

        List<BuildPrecipitationVO> buildPrecipitationList = vo.getBuildPrecipitationList(); // 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildPrecipitationList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildPrecipitationList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildPrecipitationVO cdEntity : buildPrecipitationList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildPrecipitationList(TreeNodeBUtil.buildTree(buildPrecipitationList));
        }





        List<BuildCompleteVO> buildCompleteList = vo.getBuildCompleteList(); // 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildCompleteList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildCompleteList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildCompleteVO cdEntity : buildCompleteList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildCompleteList(TreeNodeBUtil.buildTree(buildCompleteList));
        }



        List<BuildNightVO> buildNightList = vo.getBuildNightList(); // 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildNightList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildNightList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildNightVO cdEntity : buildNightList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildNightList(TreeNodeBUtil.buildTree(buildNightList));
        }

        List<BuildAppointVO> buildAppointList = vo.getBuildAppointList(); // 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildAppointList)) {
            Map<Long, Long> idMap = new HashMap<>();
            buildAppointList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildAppointVO cdEntity : buildAppointList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildAppointList(TreeNodeBUtil.buildTree(buildAppointList));
        }
        return vo;
    }

    @Override
    public BuildDutyVO ConvertFlag(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        entity.setConvertFlag(1);
        super.updateById(entity);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        dutyService.pushFromImport(vo, false, ConversionEnum.陕建房建.getCode());
        return queryDetail(id);
    }

    @Override
    public CommonResponse<String> deleteVos(List<BuildDutyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BuildDutyVO dutyVO : vos) {
                BuildDutyEntity dutyEntity = super.getById(dutyVO.getId());
                if (dutyEntity.getLastDutyId() != null) {
                    BuildDutyEntity revise = super.getById(dutyEntity.getLastDutyId());
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.未变更.getCode());
                    revise.setLatestFlag(true);
                    super.saveOrUpdate(revise);
                }

                //删除转换的数据
                dutyService.deleteFromImport(dutyVO.getId(), ConversionEnum.陕建房建.getCode());
            }
        }
        super.removeByIds(vos.stream().map(BuildDutyVO::getId).collect(Collectors.toList()), true);

        return CommonResponse.success("删除成功！");
    }

    private ImportBuildVo excelImportPlan(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<BuildPlansVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {

//                if ((i == 3) || (i == 5)) { //4、6 行不导入
//                    break;
//                }
                List<String> datas = result.get(i);
                BuildPlansVO vo = new BuildPlansVO();
                boolean flag = false;
                String warnType = "";
                String feeCategoryName = datas.get(1); // 费用分类
                String plansName = datas.get(2); // 费用项名称
                String plansTaxMny = datas.get(3); //  金额
                String plansCountTaxMny = datas.get(4); // 合计金额
                String plansMemo = datas.get(5); // 备注
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isBlank(feeCategoryName)) {
                    vo.setFeeCategoryName(null);
                } else {
                    vo.setFeeCategoryName(feeCategoryName);
                }
                if(i!=26){
                    if (StringUtils.isBlank(plansName)) {
                        vo.setPlansName(null);
                        warnType = warnType + "[费用名称为空]";
                        flag = true;
                    } else {
                        vo.setPlansName(plansName.trim());
                    }
                }else {
                    if (StringUtils.isBlank(plansName)) {
                        vo.setPlansName(null);
                    } else {
                        vo.setPlansName(plansName);
                    }
                }

                // 金额（元）
                if (StringUtils.isBlank(plansTaxMny)) {
                    vo.setPlansTaxMny(null);
                } else {
                    try {
                        vo.setPlansTaxMny(new BigDecimal(plansTaxMny));
                    } catch (Exception e) {
                        vo.setPlansTaxMny(null);
                        warnType = warnType + "[ 金额（元）只能为数字或小数]";
                        flag = true;
                    }
                }
                // 合计金额（元）
                if (StringUtils.isBlank(plansCountTaxMny)) {
                    vo.setPlansCountTaxMny(null);
                } else {
                    try {
                        vo.setPlansCountTaxMny(new BigDecimal(plansCountTaxMny));
                    } catch (Exception e) {
                        vo.setPlansCountTaxMny(null);
                        warnType = warnType + "[ 金额（元）只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setPlansMemo(plansMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildPlansVO> successList = new ArrayList<>();
            for (BuildPlansVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("2-总成本测算汇总表");
                    errorVo.setId(vo.getId());
                    errorVo.setName(vo.getPlansName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildPlansList(successList);
        }
        return res;
    }
    /**
     * 房建-人工费
     */
    private ImportBuildVo excelImportRgcost(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildRgcostVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildRgcostVO vo = new BuildRgcostVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);//序号
                String rgcostName = datas.get(2); // 科目内容
                if (StringUtils.isBlank(rgcostName)) {//名称为空
                    vo.setRgcostName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setRgcostName(rgcostName.trim());
                }
               if("合计".equals(rgcostName)){
                   continue;
               } else {
                   String rgcostCode = datas.get(1); // 编码
                   String rgcostUnitName = datas.get(3); // 单位
                   String rgcostCount = datas.get(4); // 合计工程量
                   String rgcostTaxPrice = datas.get(5); // 含税单价
                   String rgcostRate = datas.get(6); // 专项进项税税率(%)
                   String rgcostPrice = datas.get(7); // 不含进项税单价
                   String rgcostMny = datas.get(8); // 不含进项税合计
                   String rgcostTax = datas.get(9); // 进项税合计
                   String rgcostMemo = datas.get(10); // 备注
                   Long id = IdWorker.getId();
                   vo.setId(id);
                   vo.setTid(id);
                   vo.setDutyId(dutyId);
                   if (StringUtils.isNotEmpty(indexCode)) {
                       //序号不为空
                       indexCode = indexCode.trim();// 去除导入时树形编码空格
                       vo.setIndexCode(indexCode);
                       vo.setTreeIndex(indexCode);
                       parentMap.put(indexCode, id);
                       String[] split = indexCode.split("[-/.]");
                       String checkCode = indexCode.replaceAll("\\.", "");
                       boolean isMache = pattern.matcher(checkCode).matches();
                       if (!isMache){
                           warnType = warnType + "[序号非数字]";
                           flag = true;
                       }
                       if (split.length > 1) {
                           vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                       }
                       if (detailIndexList.contains(indexCode)) {
                           warnType = warnType + "[序号重复]";
                           flag = true;
                       } else {
                           detailIndexList.add(indexCode);
                       }
                   } else {
                       vo.setIndexCode(null);
                       warnType = warnType + "[序号为空]";
                       flag = true;
                   }

                   if (StringUtils.isBlank(rgcostCode)) {// 编码为空
                       vo.setRgcostCode(null);
                   } else {
                       vo.setRgcostCode(rgcostCode);
                   }


                   vo.setRgcostUnitName(rgcostUnitName);

                   if (StringUtils.isBlank(rgcostCount)) {
                       vo.setRgcostNum(null);
                   } else {
                       try {
                           vo.setRgcostNum(new BigDecimal(rgcostCount));
                       } catch (Exception e) {
                           vo.setRgcostNum(null);
                           warnType = warnType + "[工程量合计只能为数字或小数]";
                           flag = true;
                       }
                   }

                   if (StringUtils.isBlank(rgcostTaxPrice)) {
                       vo.setRgcostTaxPrice(null);
                   } else {
                       try {
                           vo.setRgcostTaxPrice(new BigDecimal(rgcostTaxPrice));
                       } catch (Exception e) {
                           vo.setRgcostTaxPrice(null);
                           warnType = warnType + "[含税单价只能为数字或小数]";
                           flag = true;
                       }
                   }

                   if (StringUtils.isBlank(rgcostTaxPrice)) {
                       vo.setRgcostTaxPrice(null);
                   } else {
                       try {
                           vo.setRgcostTaxPrice(new BigDecimal(rgcostTaxPrice));
                       } catch (Exception e) {
                           vo.setRgcostTaxPrice(null);
                           warnType = warnType + "[含税单价只能为数字或小数]";
                           flag = true;
                       }
                   }

                   if (StringUtils.isBlank(rgcostRate)) {
                       vo.setRgcostRate(null);
                   } else {
                       try {
                           vo.setRgcostRate(new BigDecimal(rgcostRate).multiply(new BigDecimal(100)));
                       } catch (Exception e) {
                           vo.setRgcostRate(null);
                           warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                           flag = true;
                       }
                   }

                   if (StringUtils.isBlank(rgcostPrice)) {
                       vo.setRgcostPrice(null);
                   } else {
                       try {
                           vo.setRgcostPrice(new BigDecimal(rgcostPrice));
                       } catch (Exception e) {
                           vo.setRgcostPrice(null);
                           warnType = warnType + "[不含进项税单价只能为数字或小数]";
                           flag = true;
                       }
                   }

                   if (StringUtils.isBlank(rgcostMny)) {
                       vo.setRgcostMny(null);
                   } else {
                       try {
                           vo.setRgcostMny(new BigDecimal(rgcostMny));
                       } catch (Exception e) {
                           vo.setRgcostMny(null);
                           warnType = warnType + "[不含进项税合计只能为数字或小数]";
                           flag = true;
                       }
                   }

                   if (StringUtils.isBlank(rgcostTax)) {
                       vo.setRgcostTax(null);
                   } else {
                       try {
                           vo.setRgcostTax(new BigDecimal(rgcostTax));
                       } catch (Exception e) {
                           vo.setRgcostTax(null);
                           warnType = warnType + "[进项税合计只能为数字或小数]";
                           flag = true;
                       }
                   }
                   //含进项税合计
                   vo.setRgcostTaxMny(ComputeUtil.safeMultiply(vo.getRgcostNum(), vo.getRgcostTaxPrice()));

                   vo.setRgcostMemo(rgcostMemo);
                   vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                   if (importFlag) {// 如果能导入
                       importFlag = !flag;
                   }
                   vo.setWarnType(warnType);
                   detailVoList.add(vo);}

            }
            List<BuildRgcostVO> successList = new ArrayList<>();
            for (BuildRgcostVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("3-人工费");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getRgcostCode());
                    errorVo.setName(vo.getRgcostName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildRgcostList(successList);
        }
        return res;
    }
    /**
     * 房建-专业分包工程测算表
     */
    private ImportBuildVo excelImportSub(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildSubVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildSubVO vo = new BuildSubVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String subCode = datas.get(1); // 编码
                String subName = datas.get(2); // 材料名称
                if (StringUtils.isBlank(subName)) {//材料名称
                    vo.setSubName(null);
                    warnType = warnType + "[材料名称为空]";
                    flag = true;
                } else {
                    vo.setSubName(subName.trim());
                }

                if("合计".equals(subName)){
                    continue;
                }else {
                    String subUnitName = datas.get(3); // 单位
                    String subNum = datas.get(4); // 数量
                    String subTaxPrice = datas.get(5); // 含税单价
                    String subRate = datas.get(6); // 专项进项税税率(%)
                    String subPrice = datas.get(7); // 不含进项税单价
                    String subMny = datas.get(8); // 不含进项税合计
                    String subTax = datas.get(9); // 进项税合计
                    String subMemo = datas.get(10); // 备注
                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);
                    if (StringUtils.isNotEmpty(indexCode)) {//// 序号不为空


                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");

                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            System.out.println("hahaha");
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isBlank(subCode)) {// 编码为空
                        vo.setSubCode(null);
                    } else {
                        vo.setSubCode(subCode);
                    }


                    vo.setSubUnitName(subUnitName);
                    if (StringUtils.isBlank(subNum)) {
                        vo.setSubNum(null);
                    } else {
                        try {
                            vo.setSubNum(new BigDecimal(subNum));
                        } catch (Exception e) {
                            vo.setSubNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(subTaxPrice)) {
                        vo.setSubTaxPrice(null);
                    } else {
                        try {
                            vo.setSubTaxPrice(new BigDecimal(subTaxPrice));
                        } catch (Exception e) {
                            vo.setSubTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(subRate)) {
                        vo.setSubRate(null);
                    } else {
                        try {
                            vo.setSubRate(new BigDecimal(subRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setSubRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(subPrice)) {
                        vo.setSubPrice(null);
                    } else {
                        try {
                            vo.setSubPrice(new BigDecimal(subPrice));
                        } catch (Exception e) {
                            vo.setSubPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(subMny)) {
                        vo.setSubMny(null);
                    } else {
                        try {
                            vo.setSubMny(new BigDecimal(subMny));
                        } catch (Exception e) {
                            vo.setSubMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(subTax)) {
                        vo.setSubTax(null);
                    } else {
                        try {
                            vo.setSubTax(new BigDecimal(subTax));
                        } catch (Exception e) {
                            vo.setSubTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setSubMemo(subMemo);
                    vo.setSubTaxMny(ComputeUtil.safeMultiply(vo.getSubNum(), vo.getSubTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildSubVO> successList = new ArrayList<>();
            for (BuildSubVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("8-专业分包");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getSubCode());
                    errorVo.setName(vo.getSubName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildSubList(successList);
        }
        return res;
    }
    /**
     * 房建-甲指分包
     */
    private ImportBuildVo excelImportAppoint(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildAppointVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildAppointVO vo = new BuildAppointVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String appointCode = datas.get(1); // 编码
                String appointName = datas.get(2); // 材料名称
                if (StringUtils.isBlank(appointName)) {//材料名称
                    vo.setAppointName(null);
                    warnType = warnType + "[材料名称为空]";
                    flag = true;
                } else {
                    vo.setAppointName(appointName.trim());
                }
                if("合计".equals(appointName)){
                    continue;
                }else {

                String appointUnitName = datas.get(3); // 单位
                String appointNum = datas.get(4); // 数量
                String appointTaxPrice = datas.get(5); // 含税单价
                String appointRate = datas.get(6); // 专项进项税税率(%)
                String appointPrice = datas.get(7); // 不含进项税单价
                String appointMny = datas.get(8); // 不含进项税合计
                String appointTax = datas.get(9); // 进项税合计
                String appointMemo = datas.get(10); // 备注
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    String checkCode = indexCode.replaceAll("\\.", "");
                    boolean isMache = pattern.matcher(checkCode).matches();
                    if (!isMache){
                        warnType = warnType + "[序号非数字]";
                        flag = true;
                    }
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isBlank(appointCode)) {// 编码为空
                    vo.setAppointCode(null);
                } else {
                    vo.setAppointCode(appointCode);
                }


                vo.setAppointUnitName(appointUnitName);
                if (StringUtils.isBlank(appointNum)) {
                    vo.setAppointNum(null);
                } else {
                    try {
                        vo.setAppointNum(new BigDecimal(appointNum));
                    } catch (Exception e) {
                        vo.setAppointNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isBlank(appointTaxPrice)) {
                    vo.setAppointTaxPrice(null);
                } else {
                    try {
                        vo.setAppointTaxPrice(new BigDecimal(appointTaxPrice));
                    } catch (Exception e) {
                        vo.setAppointTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isBlank(appointRate)) {
                    vo.setAppointRate(null);
                } else {
                    try {
                        vo.setAppointRate(new BigDecimal(appointRate).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setAppointRate(null);
                        warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isBlank(appointPrice)) {
                    vo.setAppointPrice(null);
                } else {
                    try {
                        vo.setAppointPrice(new BigDecimal(appointPrice));
                    } catch (Exception e) {
                        vo.setAppointPrice(null);
                        warnType = warnType + "[不含进项税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isBlank(appointMny)) {
                    vo.setAppointMny(null);
                } else {
                    try {
                        vo.setAppointMny(new BigDecimal(appointMny));
                    } catch (Exception e) {
                        vo.setAppointMny(null);
                        warnType = warnType + "[不含进项税合计只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isBlank(appointTax)) {
                    vo.setAppointTax(null);
                } else {
                    try {
                        vo.setAppointTax(new BigDecimal(appointTax));
                    } catch (Exception e) {
                        vo.setAppointTax(null);
                        warnType = warnType + "[进项税合计只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setAppointMemo(appointMemo);
                vo.setAppointTaxMny(ComputeUtil.safeMultiply(vo.getAppointNum(), vo.getAppointTaxPrice()));
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
                }
            }
            List<BuildAppointVO> successList = new ArrayList<>();
            for (BuildAppointVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("7-甲指分包");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getAppointCode());
                    errorVo.setName(vo.getAppointName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildAppointVOList(successList);
        }
        return res;
    }
    /**
     * 房建-项目材料费测算表
     */
    private ImportBuildVo excelImportMaterial(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildMaterialVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildMaterialVO vo = new BuildMaterialVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String materialCode = datas.get(1); // 编码
                String materialName = datas.get(2); // 材料名称
                if (StringUtils.isBlank(materialName)) {//材料名称
                    vo.setMaterialName(null);
                    warnType = warnType + "[材料名称为空]";
                    flag = true;
                } else {
                    vo.setMaterialName(materialName.trim());
                }
                String spec = datas.get(3); //规格型号
                if("合计".equals(materialName)){
                    continue;
                }else {
                    String materialUnitName = datas.get(4); // 单位
                    String materialNum = datas.get(5); // 数量
                    String materialTaxPrice = datas.get(6); // 含税单价
                    String materialRate = datas.get(7); // 专项进项税税率(%)
                    String materialPrice = datas.get(8); // 不含进项税单价
                    String materialMny = datas.get(9); // 不含进项税合计
                    String materialTax = datas.get(10); // 进项税合计
                    String materialMemo = datas.get(11); // 备注
                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);
                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isBlank(materialCode)) {// 编码为空
                        vo.setMaterialCode(null);
                    } else {
                        vo.setMaterialCode(materialCode);
                    }

                    if(StringUtils.isNotBlank(spec)) {
                        vo.setMaterialSpec(spec);
                    }

                    vo.setMaterialUnitName(materialUnitName);
                    if (StringUtils.isBlank(materialNum)) {
                        vo.setMaterialNum(null);
                    } else {
                        try {
                            vo.setMaterialNum(new BigDecimal(materialNum));
                        } catch (Exception e) {
                            vo.setMaterialNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(materialTaxPrice)) {
                        vo.setMaterialTaxPrice(null);
                    } else {
                        try {
                            vo.setMaterialTaxPrice(new BigDecimal(materialTaxPrice));
                        } catch (Exception e) {
                            vo.setMaterialTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(materialRate)) {
                        vo.setMaterialRate(null);
                    } else {
                        try {
                            vo.setMaterialRate(new BigDecimal(materialRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setMaterialRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(materialPrice)) {
                        vo.setMaterialPrice(null);
                    } else {
                        try {
                            vo.setMaterialPrice(new BigDecimal(materialPrice));
                        } catch (Exception e) {
                            vo.setMaterialPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(materialMny)) {
                        vo.setMaterialMny(null);
                    } else {
                        try {
                            vo.setMaterialMny(new BigDecimal(materialMny));
                        } catch (Exception e) {
                            vo.setMaterialMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(materialTax)) {
                        vo.setMaterialTax(null);
                    } else {
                        try {
                            vo.setMaterialTax(new BigDecimal(materialTax));
                        } catch (Exception e) {
                            vo.setMaterialTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMaterialMemo(materialMemo);
                    vo.setMaterialTaxMny(ComputeUtil.safeMultiply(vo.getMaterialNum(), vo.getMaterialTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildMaterialVO> successList = new ArrayList<>();
            for (BuildMaterialVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("5-材料费");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getMaterialCode());
                    errorVo.setName(vo.getMaterialName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildMaterialList(successList);
        }
        return res;
    }

    /**
     * 房建-项目施工机具使用费测算表
     *
     * @author generator
     *
     */
    private ImportBuildVo excelImportEquipment(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildEquipmentVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildEquipmentVO vo = new BuildEquipmentVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String equipmentCode = datas.get(1); // 编码
                String equipmentName = datas.get(2); // 费用项名称
                if (StringUtils.isBlank(equipmentName)) {//名称为空
                    vo.setEquipmentName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setEquipmentName(equipmentName.trim());
                }
                if("合计".equals(equipmentName)){
                    continue;
                }else {
                    String equipmentMothTaxPrice = datas.get(3); // 含税月租费
                    String equipmentLabourTaxPrice = datas.get(4); // 含税人工费
                    String equipmentRentMonth = datas.get(5); // 租用时间
                    String equipmentRate = datas.get(6); // 专项进项税税率(%)
                    String equipmentPrice = datas.get(7); // 不含进项税单价
                    String equipmentMny = datas.get(8); // 不含进项税含税合计
                    String equipmentTax = datas.get(9); // 进项税合计
                    String equipmentMemo = datas.get(10); // 备注
                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isBlank(equipmentCode)) {// 编码为空
                        vo.setEquipmentCode(null);
                    } else {
                        vo.setEquipmentCode(equipmentCode);
                    }


                    if (StringUtils.isBlank(equipmentMothTaxPrice)) {
                        vo.setEquipmentMothTaxPrice(null);
                    } else {
                        try {
                            vo.setEquipmentMothTaxPrice(new BigDecimal(equipmentMothTaxPrice));
                        } catch (Exception e) {
                            vo.setEquipmentMothTaxPrice(null);
                            warnType = warnType + "[含税月租费只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(equipmentLabourTaxPrice)) {
                        vo.setEquipmentLabourTaxPrice(null);
                    } else {
                        try {
                            vo.setEquipmentLabourTaxPrice(new BigDecimal(equipmentLabourTaxPrice));
                        } catch (Exception e) {
                            vo.setEquipmentLabourTaxPrice(null);
                            warnType = warnType + "[含税人工费只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(equipmentRentMonth)) {
                        vo.setEquipmentRentMonth(null);
                    } else {
                        try {
                            vo.setEquipmentRentMonth(new BigDecimal(equipmentRentMonth));
                        } catch (Exception e) {
                            vo.setEquipmentRentMonth(null);
                            warnType = warnType + "[租用时间只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(equipmentRate)) {
                        vo.setEquipmentRate(null);
                    } else {
                        try {
                            vo.setEquipmentRate(new BigDecimal(equipmentRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setEquipmentRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(equipmentPrice)) {
                        vo.setEquipmentPrice(null);
                    } else {
                        try {
                            vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
                        } catch (Exception e) {
                            vo.setEquipmentPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(equipmentMny)) {
                        vo.setEquipmentMny(null);
                    } else {
                        try {
                            vo.setEquipmentMny(new BigDecimal(equipmentMny));
                        } catch (Exception e) {
                            vo.setEquipmentMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(equipmentTax)) {
                        vo.setEquipmentTax(null);
                    } else {
                        try {
                            vo.setEquipmentTax(new BigDecimal(equipmentTax));
                        } catch (Exception e) {
                            vo.setEquipmentTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setEquipmentMemo(equipmentMemo);
                    vo.setEquipmentTaxMny(ComputeUtil.safeMultiply(vo.getEquipmentNum(), vo.getEquipmentTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildEquipmentVO> successList = new ArrayList<>();
            for (BuildEquipmentVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("9-机具使用费");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getEquipmentCode());
                    errorVo.setName(vo.getEquipmentName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildEquipmentList(successList);
        }
        return res;
    }
    /**
     * 房建-安全文明施工费
     */
    private ImportBuildVo excelImportSafe(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildSafeVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildSafeVO vo = new BuildSafeVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String safeName = datas.get(1); // 费用项名称
                if (StringUtils.isBlank(safeName)) {//名称为空
                    vo.setSafeName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setSafeName(safeName.trim());
                }

                if("合计".equals(safeName)){
                    continue;
                }else {
                    String safeUnitName = datas.get(2); // 单位
                    String safeNum = datas.get(3); // 工程量
                    String safeTaxPrice = datas.get(4); // 含税单价
                    String safeRate = datas.get(5); // 专项进项税税率(%)
                    String safePrice = datas.get(6); // 不含进项税单价
                    String safeMny = datas.get(7); // 不含进项税含税合计
                    String safeTax = datas.get(8); // 进项税合计
                    String safeMemo = datas.get(9); // 备注

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }


                    vo.setSafeUnitName(safeUnitName);

                    if (StringUtils.isBlank(safeNum)) {
                        vo.setSafeNum(null);
                    } else {
                        try {
                            vo.setSafeNum(new BigDecimal(safeNum));
                        } catch (Exception e) {
                            vo.setSafeNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(safeTaxPrice)) {
                        vo.setSafeTaxPrice(null);
                    } else {
                        try {
                            vo.setSafeTaxPrice(new BigDecimal(safeTaxPrice));
                        } catch (Exception e) {
                            vo.setSafeTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(safeRate)) {
                        vo.setSafeRate(null);
                    } else {
                        try {
                            vo.setSafeRate(new BigDecimal(safeRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setSafeRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(safePrice)) {
                        vo.setSafePrice(null);
                    } else {
                        try {
                            vo.setSafePrice(new BigDecimal(safePrice));
                        } catch (Exception e) {
                            vo.setSafePrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(safeMny)) {
                        vo.setSafeMny(null);
                    } else {
                        try {
                            vo.setSafeMny(new BigDecimal(safeMny));
                        } catch (Exception e) {
                            vo.setSafeMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(safeTax)) {
                        vo.setSafeTax(null);
                    } else {
                        try {
                            vo.setSafeTax(new BigDecimal(safeTax));
                        } catch (Exception e) {
                            vo.setSafeTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setSafeMemo(safeMemo);
                    vo.setSafeTaxMny(ComputeUtil.safeMultiply(vo.getSafeNum(), vo.getSafeTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildSafeVO> successList = new ArrayList<>();
            for (BuildSafeVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("10-安全文明、环境保护、临时设施、二次搬运");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getSafeCode());
                    errorVo.setName(vo.getSafeName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildSafeList(successList);
        }
        return res;
    }
    /**
     * 房建-项目冬雨季、夜间施工
     */
    private ImportBuildVo excelImportNight(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildNightVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildNightVO vo = new BuildNightVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String nightName = datas.get(1); // 费用项名称
                if (StringUtils.isBlank(nightName)) {//名称为空
                    vo.setNightName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setNightName(nightName.trim());
                }

                if("合计".equals(nightName)){
                    continue;
                }else {
                    String nightUnitName = datas.get(2); // 单位
                    String nightNum = datas.get(3); // 工程量
                    String nightTaxPrice = datas.get(4); // 含税单价
                    String nightRate = datas.get(5); // 专项进项税税率(%)
                    String nightPrice = datas.get(6); // 不含进项税单价
                    String nightMny = datas.get(7); // 不含进项税含税合计
                    String nightTax = datas.get(8); // 进项税合计
                    String nightMemo = datas.get(9); // 备注

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }


                    vo.setNightUnitName(nightUnitName);

                    if (StringUtils.isBlank(nightNum)) {
                        vo.setNightNum(null);
                    } else {
                        try {
                            vo.setNightNum(new BigDecimal(nightNum));
                        } catch (Exception e) {
                            vo.setNightNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(nightTaxPrice)) {
                        vo.setNightTaxPrice(null);
                    } else {
                        try {
                            vo.setNightTaxPrice(new BigDecimal(nightTaxPrice));
                        } catch (Exception e) {
                            vo.setNightTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(nightRate)) {
                        vo.setNightRate(null);
                    } else {
                        try {
                            vo.setNightRate(new BigDecimal(nightRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setNightRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(nightPrice)) {
                        vo.setNightPrice(null);
                    } else {
                        try {
                            vo.setNightPrice(new BigDecimal(nightPrice));
                        } catch (Exception e) {
                            vo.setNightPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(nightMny)) {
                        vo.setNightMny(null);
                    } else {
                        try {
                            vo.setNightMny(new BigDecimal(nightMny));
                        } catch (Exception e) {
                            vo.setNightMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(nightTax)) {
                        vo.setNightTax(null);
                    } else {
                        try {
                            vo.setNightTax(new BigDecimal(nightTax));
                        } catch (Exception e) {
                            vo.setNightTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setNightMemo(nightMemo);
                    vo.setNightTaxMny(ComputeUtil.safeMultiply(vo.getNightNum(), vo.getNightTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildNightVO> successList = new ArrayList<>();
            for (BuildNightVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("11-冬雨季、夜间施工");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getNightCode());
                    errorVo.setName(vo.getNightName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildNightList(successList);
        }
        return res;
    }
    /**
     * 房建-已完工程及设备保护测算表
     */
    private ImportBuildVo excelImportComplete(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildCompleteVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildCompleteVO vo = new BuildCompleteVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String completeName = datas.get(1); // 费用项名称

                if (StringUtils.isBlank(completeName)) {//名称为空
                    vo.setCompleteName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setCompleteName(completeName.trim());
                }
                if("合计".equals(completeName)){
                    continue;
                }else {
                    String completeUnitName = datas.get(2); // 单位
                    String completeNum = datas.get(3); // 工程量
                    String completeTaxPrice = datas.get(4); // 含税单价
                    String completeRate = datas.get(5); // 专项进项税税率(%)
                    String completePrice = datas.get(6); // 不含进项税单价
                    String completeMny = datas.get(7); // 不含进项税含税合计
                    String completeTax = datas.get(8); // 进项税合计
                    String completeMemo = datas.get(9); // 备注

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }


                    vo.setCompleteUnitName(completeUnitName);

                    if (StringUtils.isBlank(completeNum)) {
                        vo.setCompleteNum(null);
                    } else {
                        try {
                            vo.setCompleteNum(new BigDecimal(completeNum));
                        } catch (Exception e) {
                            vo.setCompleteNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(completeTaxPrice)) {
                        vo.setCompleteTaxPrice(null);
                    } else {
                        try {
                            vo.setCompleteTaxPrice(new BigDecimal(completeTaxPrice));
                        } catch (Exception e) {
                            vo.setCompleteTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(completeRate)) {
                        vo.setCompleteRate(null);
                    } else {
                        try {
                            vo.setCompleteRate(new BigDecimal(completeRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setCompleteRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(completePrice)) {
                        vo.setCompletePrice(null);
                    } else {
                        try {
                            vo.setCompletePrice(new BigDecimal(completePrice));
                        } catch (Exception e) {
                            vo.setCompletePrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(completeMny)) {
                        vo.setCompleteMny(null);
                    } else {
                        try {
                            vo.setCompleteMny(new BigDecimal(completeMny));
                        } catch (Exception e) {
                            vo.setCompleteMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(completeTax)) {
                        vo.setCompleteTax(null);
                    } else {
                        try {
                            vo.setCompleteTax(new BigDecimal(completeTax));
                        } catch (Exception e) {
                            vo.setCompleteTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setCompleteMemo(completeMemo);
                    vo.setCompleteTaxMny(ComputeUtil.safeMultiply(vo.getCompleteNum(), vo.getCompleteTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildCompleteVO> successList = new ArrayList<>();
            for (BuildCompleteVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("12-已完工程及设备保护");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getCompleteCode());
                    errorVo.setName(vo.getCompleteName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildCompleteList(successList);
        }
        return res;
    }
    /**
     * 房建-项目模板及支撑费用
     */
    private ImportBuildVo excelImportTemplates(List<List<String>> result, Long dutyId) {

        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildTemplatesVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildTemplatesVO vo = new BuildTemplatesVO();
                boolean flag = false;
                String warnType = "";
                //TODO 补充编码和 日租
                String indexCode = datas.get(0);//序号
                String templatesName = datas.get(2); // 费用项名称
                if (StringUtils.isBlank(templatesName)) {//名称为空
                    vo.setTemplatesName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setTemplatesName(templatesName.trim());
                }

                if("合计".equals(templatesName)){
                    continue;
                }else {
                    String templatesCode = datas.get(1); // 编码
                    String templatesSpec = datas.get(3); // 规格型号
                    String templatesUnitName = datas.get(4); // 单位
                    String templatesNum = datas.get(5); // 工程量
                    String templatesTaxPrice = datas.get(6); // 含税单价
                    String templatesRentDay =  datas.get(7);//租赁时间
                    String templatesRate = datas.get(8); // 专项进项税税率(%)
                    String templatesPrice = datas.get(9); // 不含进项税单价
                    String templatesMny = datas.get(10); // 不含进项税含税合计
                    String templatesTax = datas.get(11); // 进项税合计
                    String templatesMemo = datas.get(12); // 备注
                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }
                    if (StringUtils.isNotEmpty(templatesCode)) {
                        vo.setTemplatesCode(templatesCode);
                    }
                    if (StringUtils.isNotEmpty(templatesSpec)) {
                        vo.setTemplatesSpec(templatesSpec);
                    }

                    vo.setTemplatesUnitName(templatesUnitName);

                    if (StringUtils.isBlank(templatesNum)) {
                        vo.setTemplatesNum(null);
                    } else {
                        try {
                            vo.setTemplatesNum(new BigDecimal(templatesNum));
                        } catch (Exception e) {
                            vo.setTemplatesNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(templatesTaxPrice)) {
                        vo.setTemplatesTaxPrice(null);
                    } else {
                        try {
                            vo.setTemplatesTaxPrice(new BigDecimal(templatesTaxPrice));
                        } catch (Exception e) {
                            vo.setTemplatesTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(templatesRentDay)) {
                        vo.setTemplatesRentDay(null);
                    } else {
                        try {
                            vo.setTemplatesRentDay(new BigDecimal(templatesRentDay));
                        } catch (Exception e) {
                            vo.setTemplatesRentDay(null);
                            warnType = warnType + "[租赁时间只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(templatesRate)) {
                        vo.setTemplatesRate(null);
                    } else {
                        try {
                            vo.setTemplatesRate(new BigDecimal(templatesRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setTemplatesRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(templatesPrice)) {
                        vo.setTemplatesPrice(null);
                    } else {
                        try {
                            vo.setTemplatesPrice(new BigDecimal(templatesPrice));
                        } catch (Exception e) {
                            vo.setTemplatesPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(templatesMny)) {
                        vo.setTemplatesMny(null);
                    } else {
                        try {
                            vo.setTemplatesMny(new BigDecimal(templatesMny));
                        } catch (Exception e) {
                            vo.setTemplatesMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(templatesTax)) {
                        vo.setTemplatesTax(null);
                    } else {
                        try {
                            vo.setTemplatesTax(new BigDecimal(templatesTax));
                        } catch (Exception e) {
                            vo.setTemplatesTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setTemplatesMemo(templatesMemo);

                    if (null!=vo.getTemplatesNum()&&null!=vo.getTemplatesTaxPrice()){
                        BigDecimal bigDecimal = ComputeUtil.safeMultiply(vo.getTemplatesNum(), vo.getTemplatesTaxPrice());
                        if (null!=vo.getTemplatesRentDay()){
                            bigDecimal = ComputeUtil.safeMultiply(bigDecimal,vo.getTemplatesRentDay());
                        }
                        vo.setTemplatesTaxMny(bigDecimal);
                    }
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildTemplatesVO> successList = new ArrayList<>();
            for (BuildTemplatesVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("14-模板及支撑");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getTemplatesCode());
                    errorVo.setName(vo.getTemplatesName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildTemplatesList(successList);
        }
        return res;





    }
    /**
     * 房建-脚手架
     */
    private ImportBuildVo excelImportScaffold(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildScaffoldVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildScaffoldVO vo = new BuildScaffoldVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String scaffoldCode = datas.get(1); // 编码
                String scaffoldName = datas.get(2); // 材料名称
                if("合计".equals(scaffoldName)){
                    continue;
                }else {
                    String scaffoldSpec = datas.get(3); // 规格型号
                    String scaffoldUnitName = datas.get(4); // 单位
                    String scaffoldNum = datas.get(5); // 数量
                    String scaffoldTaxPrice = datas.get(6); // 含税单价
                    String scaffoldRentDay = datas.get(7); // 含税单价
                    String scaffoldRate = datas.get(8); // 专项进项税税率(%)
                    String scaffoldPrice = datas.get(9); // 不含进项税单价
                    String scaffoldMny = datas.get(10); // 不含进项税合计
                    String scaffoldTax = datas.get(11); // 进项税合计
                    String scaffoldMemo = datas.get(12); // 备注
                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);
                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isBlank(scaffoldCode)) {// 编码为空
                        vo.setScaffoldCode(null);
                    } else {
                        vo.setScaffoldCode(scaffoldCode);
                    }

                    if (StringUtils.isBlank(scaffoldName)) {//材料名称
                        vo.setScaffoldName(null);
                        warnType = warnType + "[材料名称为空]";
                        flag = true;
                    } else {
                        vo.setScaffoldName(scaffoldName.trim());
                    }
                    vo.setScaffoldUnitName(scaffoldUnitName);
                    if (StringUtils.isBlank(scaffoldNum)) {
                        vo.setScaffoldNum(null);
                    } else {
                        try {
                            vo.setScaffoldNum(new BigDecimal(scaffoldNum));
                        } catch (Exception e) {
                            vo.setScaffoldNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(scaffoldSpec)) {// 编码为空
                        vo.setScaffoldSpec(null);
                    } else {
                        vo.setScaffoldSpec(scaffoldSpec);
                    }

                    if (StringUtils.isBlank(scaffoldTaxPrice)) {
                        vo.setScaffoldTaxPrice(null);
                    } else {
                        try {
                            vo.setScaffoldTaxPrice(new BigDecimal(scaffoldTaxPrice));
                        } catch (Exception e) {
                            vo.setScaffoldTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(scaffoldRentDay)) {
                        vo.setScaffoldRentDay(null);
                    } else {
                        try {
                            vo.setScaffoldRentDay(new BigDecimal(scaffoldRentDay));
                        } catch (Exception e) {
                            vo.setScaffoldRentDay(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(scaffoldRate)) {
                        vo.setScaffoldRate(null);
                    } else {
                        try {
                            vo.setScaffoldRate(new BigDecimal(scaffoldRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setScaffoldRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(scaffoldPrice)) {
                        vo.setScaffoldPrice(null);
                    } else {
                        try {
                            vo.setScaffoldPrice(new BigDecimal(scaffoldPrice));
                        } catch (Exception e) {
                            vo.setScaffoldPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(scaffoldMny)) {
                        vo.setScaffoldMny(null);
                    } else {
                        try {
                            vo.setScaffoldMny(new BigDecimal(scaffoldMny));
                        } catch (Exception e) {
                            vo.setScaffoldMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(scaffoldTax)) {
                        vo.setScaffoldTax(null);
                    } else {
                        try {
                            vo.setScaffoldTax(new BigDecimal(scaffoldTax));
                        } catch (Exception e) {
                            vo.setScaffoldTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setScaffoldMemo(scaffoldMemo);
                    if (null!=vo.getScaffoldNum()&&null!=vo.getScaffoldTaxPrice()){
                        BigDecimal bigDecimal = ComputeUtil.safeMultiply(vo.getScaffoldNum(), vo.getScaffoldTaxPrice());
                        if (null!=vo.getScaffoldRentDay()){
                            bigDecimal = ComputeUtil.safeMultiply(bigDecimal,vo.getScaffoldRentDay());
                        }
                        vo.setScaffoldTaxMny(bigDecimal);
                    }
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildScaffoldVO> successList = new ArrayList<>();
            for (BuildScaffoldVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String scaffold = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(scaffold) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("15-脚手架");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getScaffoldCode());
                    errorVo.setName(vo.getScaffoldName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildScaffoldList(successList);
        }
        return res;
    }
    /**
     * 房建-项目激励奖
     */
    private ImportBuildVo excelImportStimulate(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildStimulateVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildStimulateVO vo = new  BuildStimulateVO();
                boolean flag = false;
                String warnType = "";

                String treeIndex = datas.get(0);//序号
                String stimulateName = datas.get(1); // 项目
                if("合计".equals(stimulateName)||StringUtils.isBlank(treeIndex)){
                    continue;
                }else {
                    String stimulateUnitName = datas.get(2); // 单位
                    String stimulateNum = datas.get(3); // 数量
                    String stimulateTaxPrice = datas.get(4); // 含税单价（元）
                    String stimulateRate = datas.get(5); // 专票进项税税率（%）
                    String stimulatePrice = datas.get(6); // 不含进项税单价（元）
                    String stimulateMny = datas.get(7); // 不含进项税合计（元）
                    String stimulateTax = datas.get(8); // 进项税合计（元）
                    String stimulateMemo = datas.get(9); // 备注
                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);
                    vo.setTreeIndex(treeIndex);
                    // 项目
                    if (StringUtils.isBlank(stimulateName)) {//项目为空
                        vo.setStimulateName(null);
                        warnType = warnType + "[项目为空]";
                        flag = true;
                    } else {
                        vo.setStimulateName(stimulateName.trim());
                    }
                    // 单位
                    vo.setStimulateUnitName(stimulateUnitName);//单位
                    // 数量
                    if (StringUtils.isBlank(stimulateNum)) {
                        vo.setStimulateNum(null);
                    } else {
                        try {
                            vo.setStimulateNum(new BigDecimal(stimulateNum));
                        } catch (Exception e) {
                            vo.setStimulateNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 含税单价（元）
                    if (StringUtils.isBlank(stimulateTaxPrice)) {
                        vo.setStimulateTaxPrice(null);
                    } else {
                        try {
                            vo.setStimulateTaxPrice(new BigDecimal(stimulateTaxPrice));
                        } catch (Exception e) {
                            vo.setStimulateTaxPrice(null);
                            warnType = warnType + "[ 含税单价（元）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 专票进项税税率（%）
                    if (StringUtils.isBlank(stimulateRate)) {
                        vo.setStimulateRate(null);
                    } else {
                        try {
                            vo.setStimulateRate(new BigDecimal(stimulateRate).multiply(new BigDecimal(100)));

                        } catch (Exception e) {
                            vo.setStimulateRate(null);
                            warnType = warnType + "[专票进项税税率（%）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 不含进项税单价（元）
                    if (StringUtils.isBlank(stimulatePrice)) {
                        vo.setStimulatePrice(null);
                    } else {
                        try {
                            vo.setStimulatePrice(new BigDecimal(stimulatePrice));
                        } catch (Exception e) {
                            vo.setStimulatePrice(null);
                            warnType = warnType + "[不含进项税单价（元）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(stimulateMny)) {
                        vo.setStimulateMny(null);
                    } else {
                        try {
                            vo.setStimulateMny(new BigDecimal(stimulateMny));
                        } catch (Exception e) {
                            vo.setStimulateMny(null);
                            warnType = warnType + "不含进项税合计只能为数字或小数";
                            flag = true;
                        }
                    }
                    // 进项税合计（元）
                    if (StringUtils.isBlank(stimulateTax)) {
                        vo.setStimulateTax(null);
                    } else {
                        try {
                            vo.setStimulateTax(new BigDecimal(stimulateTax));
                        } catch (Exception e) {
                            vo.setStimulateTax(null);
                            warnType = warnType + "进项税合计（元）只能为数字或小数";
                            flag = true;
                        }
                    }
                    // 备注
                    vo.setStimulateMemo(stimulateMemo);
                    vo.setStimulateTaxMny(ComputeUtil.safeMultiply(vo.getStimulateNum(), vo.getStimulateTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildStimulateVO> successList = new ArrayList<>();
            for (BuildStimulateVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("18-激励奖");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getTreeIndex());
                    errorVo.setCode(null);
                    errorVo.setName(vo.getStimulateName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildStimulateList(successList);
        }
        return res;
    }
    /**
     * 房建-间接费
     */
    private ImportBuildVo excelImportIndirect(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildIndirectVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildIndirectVO vo = new BuildIndirectVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String indirectName = datas.get(1); // 项目
                if("合计".equals(indirectName)){
                    continue;
                }else {
                    String indirectUnitName = datas.get(2); // 单位
                    String indirectNum = datas.get(3); // 数量
                    String indirectTaxPrice = datas.get(4); // 含税单价（元）
                    String indirectMothNum = datas.get(5); // 时间（月）
                    String indirectRate = datas.get(6); // 专票进项税税率（%）
                    String indirectPrice = datas.get(7); // 不含进项税单价（元）
                    String indirectMny = datas.get(8); // 不不含进项税合计（元）
                    String indirectTax = datas.get(9); // 进项税合计（元）
                    String indirectMemo = datas.get(10); // 备注

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);


                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }


                    // 项目
                    if (StringUtils.isBlank(indirectName)) {//项目为空
                        vo.setIndirectName(null);
                        warnType = warnType + "项目为空";
                        flag = true;
                    } else {
                        vo.setIndirectName(indirectName.trim());
                    }
                    // 单位
                    vo.setIndirectUnitName(indirectUnitName);
                    // 数量
                    if (StringUtils.isBlank(indirectNum)) {
                        vo.setIndirectNum(null);
                    } else {
                        try {
                            vo.setIndirectNum(new BigDecimal(indirectNum));
                        } catch (Exception e) {
                            vo.setIndirectNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 含税单价（元）
                    if (StringUtils.isBlank(indirectTaxPrice)) {
                        vo.setIndirectTaxPrice(null);
                    } else {
                        try {
                            vo.setIndirectTaxPrice(new BigDecimal(indirectTaxPrice));
                        } catch (Exception e) {
                            vo.setIndirectTaxPrice(null);
                            warnType = warnType + "[ 含税单价（元）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 时间（月）
                    if (StringUtils.isBlank(indirectMothNum)) {
                        vo.setIndirectMothNum(null);
                    } else {
                        try {
                            vo.setIndirectMothNum(new BigDecimal(indirectMothNum));
                        } catch (Exception e) {
                            vo.setIndirectMothNum(null);
                            warnType = warnType + "[ 时间只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 专票进项税税率（%）
                    if (StringUtils.isBlank(indirectRate)) {
                        vo.setIndirectRate(null);
                    } else {
                        try {
                            vo.setIndirectRate(new BigDecimal(indirectRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setIndirectRate(null);
                            warnType = warnType + "[专票进项税税率（%）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 不含进项税单价（元）
                    if (StringUtils.isBlank(indirectPrice)) {
                        vo.setIndirectPrice(null);
                    } else {
                        try {
                            vo.setIndirectPrice(new BigDecimal(indirectPrice));
                        } catch (Exception e) {
                            vo.setIndirectPrice(null);
                            warnType = warnType + "[不含进项税单价（元）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 不不含进项税合计（元）
                    if (StringUtils.isBlank(indirectTax)) {
                        vo.setIndirectTax(null);
                    } else {
                        try {
                            vo.setIndirectTax(new BigDecimal(indirectTax));
                        } catch (Exception e) {
                            vo.setIndirectTax(null);
                            warnType = warnType + "[不不含进项税合计（元）只能为数字或小数]";
                            flag = true;
                        }
                    }


                    // 进项税合计（元）
                    if (StringUtils.isBlank(indirectTax)) {
                        vo.setIndirectTax(null);
                    } else {
                        try {
                            vo.setIndirectTax(new BigDecimal(indirectTax));
                        } catch (Exception e) {
                            vo.setIndirectTax(null);
                            warnType = warnType + "[进项税合计（元）只能为数字或小数]";
                            flag = true;
                        }
                    } // 进项税合计（元）
                    if (StringUtils.isBlank(indirectMny)) {
                        vo.setIndirectMny(null);
                    } else {
                        try {
                            vo.setIndirectMny(new BigDecimal(indirectMny));
                        } catch (Exception e) {
                            vo.setIndirectMny(null);
                            warnType = warnType + "[不含进项税合计（元）只能为数字或小数]";
                            flag = true;
                        }
                    }
                    // 备注
                    vo.setIndirectMemo(indirectMemo);
                    if (null!=vo.getIndirectNum()&&null!=vo.getIndirectTaxPrice()){
                        BigDecimal bigDecimal = ComputeUtil.safeMultiply(vo.getIndirectNum(), vo.getIndirectTaxPrice());
                        if (null!=vo.getIndirectMothNum()){
                            bigDecimal = ComputeUtil.safeMultiply(bigDecimal,vo.getIndirectMothNum());
                        }
                        vo.setIndirectTaxMny(bigDecimal);
                    }
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildIndirectVO> successList = new ArrayList<>();
            for (BuildIndirectVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("17-间接费");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setName(vo.getIndirectName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildIndirectList(successList);
        }
        return res;
    }
    /**
     * 房建-排水、降水费
     *
     * @author generator
     *
     */
    private ImportBuildVo excelImportPrecipitation(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildPrecipitationVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildPrecipitationVO vo = new BuildPrecipitationVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String precipitationName = datas.get(1); // 费用项名称

                if("合计".equals(precipitationName)){
                    continue;
                }else {

                    String precipitationFeatures = datas.get(2); // 特征
                    String precipitationUnitName = datas.get(3); // 特征
                    String precipitationNum = datas.get(4); // 工程量
                    String precipitationTaxPrice = datas.get(5); // 含税单价
                    String precipitationRate = datas.get(6); // 专项进项税税率(%)
                    String precipitationPrice = datas.get(7); // 不含进项税单价
                    String precipitationMny = datas.get(8); // 不含进项税含税合计
                    String precipitationTax = datas.get(9); // 进项税合计
                    String precipitationMemo = datas.get(10); // 备注

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isBlank(precipitationName)) {//名称为空
                        vo.setPrecipitationName(null);
                        warnType = warnType + "[费用项名称为空]";
                        flag = true;
                    } else {
                        vo.setPrecipitationName(precipitationName.trim());
                    }

                    vo.setPrecipitationUnitName(precipitationUnitName);
                    vo.setPrecipitationFeatures(precipitationFeatures);
                    if (StringUtils.isBlank(precipitationNum)) {
                        vo.setPrecipitationNum(null);
                    } else {
                        try {
                            vo.setPrecipitationNum(new BigDecimal(precipitationNum));
                        } catch (Exception e) {
                            vo.setPrecipitationNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(precipitationTaxPrice)) {
                        vo.setPrecipitationTaxPrice(null);
                    } else {
                        try {
                            vo.setPrecipitationTaxPrice(new BigDecimal(precipitationTaxPrice));
                        } catch (Exception e) {
                            vo.setPrecipitationTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(precipitationRate)) {
                        vo.setPrecipitationRate(null);
                    } else {
                        try {
                            vo.setPrecipitationRate(new BigDecimal(precipitationRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setPrecipitationRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(precipitationPrice)) {
                        vo.setPrecipitationPrice(null);
                    } else {
                        try {
                            vo.setPrecipitationPrice(new BigDecimal(precipitationPrice));
                        } catch (Exception e) {
                            vo.setPrecipitationPrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(precipitationMny)) {
                        vo.setPrecipitationMny(null);
                    } else {
                        try {
                            vo.setPrecipitationMny(new BigDecimal(precipitationMny));
                        } catch (Exception e) {
                            vo.setPrecipitationMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(precipitationTax)) {
                        vo.setPrecipitationTax(null);
                    } else {
                        try {
                            vo.setPrecipitationTax(new BigDecimal(precipitationTax));
                        } catch (Exception e) {
                            vo.setPrecipitationTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setPrecipitationMemo(precipitationMemo);
                    vo.setPrecipitationTaxMny(ComputeUtil.safeMultiply(vo.getPrecipitationNum(), vo.getPrecipitationTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildPrecipitationVO> successList = new ArrayList<>();
            for (BuildPrecipitationVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("13-排、降水");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getPrecipitationCode());
                    errorVo.setName(vo.getPrecipitationName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildPrecipitationList(successList);
        }
        return res;
    }


    /**
     * 房建-其他措施费
     */
    private ImportBuildVo excelImportMeasure(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildMeasureVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            for (int i = 0; i < result.size() - 1; i++) {
                List<String> datas = result.get(i);
                BuildMeasureVO vo = new BuildMeasureVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String measureName = datas.get(1); // 项目
                if("合计".equals(measureName)){
                    continue;
                }else {
                    String measureUnitName = datas.get(2); // 单位
                    String measureNum = datas.get(3); // 数量
                    String measureTaxPrice = datas.get(4); // 含税单价
                    String measureRate = datas.get(5); // 专项进项税税率(%)
                    String measurePrice = datas.get(6); // 不含进项税单价
                    String measureMny = datas.get(7); // 不含进项税合计
                    String measureTax = datas.get(8); // 进项税合计
                    String measureMemo = datas.get(9); // 备注

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setTid(id);
                    vo.setDutyId(dutyId);
                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        vo.setTreeIndex(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        String checkCode = indexCode.replaceAll("\\.", "");
                        boolean isMache = pattern.matcher(checkCode).matches();
                        if (!isMache){
                            warnType = warnType + "[序号非数字]";
                            flag = true;
                        }
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
//                    vo.setTreeIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isBlank(measureName)) {//材料名称
                        vo.setMeasureName(null);
                        warnType = warnType + "[材料名称为空]";
                        flag = true;
                    } else {
                        vo.setMeasureName(measureName.trim());
                    }
                    vo.setMeasureUnitName(measureUnitName);
                    if (StringUtils.isBlank(measureNum)) {
                        vo.setMeasureNum(null);
                    } else {
                        try {
                            vo.setMeasureNum(new BigDecimal(measureNum));
                        } catch (Exception e) {
                            vo.setMeasureNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(measureTaxPrice)) {
                        vo.setMeasureTaxPrice(null);
                    } else {
                        try {
                            vo.setMeasureTaxPrice(new BigDecimal(measureTaxPrice));
                        } catch (Exception e) {
                            vo.setMeasureTaxPrice(null);
                            warnType = warnType + "[含税单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(measureRate)) {
                        vo.setMeasureRate(null);
                    } else {
                        try {
                            vo.setMeasureRate(new BigDecimal(measureRate).multiply(new BigDecimal(100)));
                        } catch (Exception e) {
                            vo.setMeasureRate(null);
                            warnType = warnType + "[专项进项税税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(measurePrice)) {
                        vo.setMeasurePrice(null);
                    } else {
                        try {
                            vo.setMeasurePrice(new BigDecimal(measurePrice));
                        } catch (Exception e) {
                            vo.setMeasurePrice(null);
                            warnType = warnType + "[不含进项税单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank(measureMny)) {
                        vo.setMeasureMny(null);
                    } else {
                        try {
                            vo.setMeasureMny(new BigDecimal(measureMny));
                        } catch (Exception e) {
                            vo.setMeasureMny(null);
                            warnType = warnType + "[不含进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(measureTax)) {
                        vo.setMeasureTax(null);
                    } else {
                        try {
                            vo.setMeasureTax(new BigDecimal(measureTax));
                        } catch (Exception e) {
                            vo.setMeasureTax(null);
                            warnType = warnType + "[进项税合计只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMeasureMemo(measureMemo);
                    vo.setMeasureTaxMny(ComputeUtil.safeMultiply(vo.getMeasureNum(), vo.getMeasureTaxPrice()));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
            }
            List<BuildMeasureVO> successList = new ArrayList<>();
            for (BuildMeasureVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("16-其他措施费");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getMeasureCode());
                    errorVo.setName(vo.getMeasureName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildMeasureList(successList);
        }
        return res;
    }

    public void updateByPid(BuildDutyEntity entity) {
        Map<Long, Long> rgcostMap = new HashMap<>();
        List<BuildRgcostEntity> rgcostEntities = entity.getBuildRgcostList();// 房建-人工费
        if (CollectionUtils.isNotEmpty(rgcostEntities)) {
            for (BuildRgcostEntity twoEntity : rgcostEntities) {
                rgcostMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildRgcostEntity cdEntity : rgcostEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(rgcostMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildRgcostService.saveOrUpdateBatch(rgcostEntities, rgcostEntities.size(), false);
        }

        Map<Long, Long> subMap = new HashMap<>();
        List<BuildSubEntity> dutySubEntities = entity.getBuildSubList();
        if (CollectionUtils.isNotEmpty(dutySubEntities)) {
            for (BuildSubEntity rmatEntity : dutySubEntities) {
                subMap.put(rmatEntity.getTid(), rmatEntity.getId());
            }
            for (BuildSubEntity cdEntity : dutySubEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(subMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildSubService.saveOrUpdateBatch(dutySubEntities, dutySubEntities.size(), false);
        }

        Map<Long, Long> materialMap = new HashMap<>();
        List<BuildMaterialEntity> materialEntities = entity.getBuildMaterialList();// 房建-材料
        if (CollectionUtils.isNotEmpty(materialEntities)) {
            for (BuildMaterialEntity twoEntity : materialEntities) {
                materialMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildMaterialEntity cdEntity : materialEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(materialMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildMaterialService.saveOrUpdateBatch(materialEntities, materialEntities.size(), false);
        }

        Map<Long, Long> rmatMap = new HashMap<>();
        List<BuildStimulateEntity> buildStimulateList = entity.getBuildStimulateList();// 房建-周转材
        if (CollectionUtils.isNotEmpty(buildStimulateList)) {
            for (BuildStimulateEntity twoEntity : buildStimulateList) {
                rmatMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildStimulateEntity cdEntity : buildStimulateList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(rmatMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildStimulateService.saveOrUpdateBatch(buildStimulateList, buildStimulateList.size(), false);
        }

        Map<Long, Long> equipmentMap = new HashMap<>();
        List<BuildEquipmentEntity> equipmentEntities = entity.getBuildEquipmentList();// 房建-机械设备
        if (CollectionUtils.isNotEmpty(equipmentEntities)) {
            for (BuildEquipmentEntity twoEntity : equipmentEntities) {
                equipmentMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildEquipmentEntity cdEntity : equipmentEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(equipmentMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildEquipmentService.saveOrUpdateBatch(equipmentEntities, equipmentEntities.size(), false);
        }

        Map<Long, Long> safeMap = new HashMap<>();
        List<BuildSafeEntity> safeEntities = entity.getBuildSafeList();// 房建-安全文明施工费
        if (CollectionUtils.isNotEmpty(safeEntities)) {
            for (BuildSafeEntity twoEntity : safeEntities) {
                safeMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildSafeEntity cdEntity : safeEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(safeMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildSafeService.saveOrUpdateBatch(safeEntities, safeEntities.size(), false);
        }

        Map<Long, Long> temporaryMap = new HashMap<>();
        List<BuildIndirectEntity> buildIndirectList = entity.getBuildIndirectList();// 房建-临时设施费
        if (CollectionUtils.isNotEmpty(buildIndirectList)) {
            for (BuildIndirectEntity twoEntity : buildIndirectList) {
                temporaryMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildIndirectEntity cdEntity : buildIndirectList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(temporaryMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildIndirectService.saveOrUpdateBatch(buildIndirectList, buildIndirectList.size(), false);
        }

        Map<Long, Long> measureMap = new HashMap<>();
        List<BuildMeasureEntity> measureEntities = entity.getBuildMeasureList();// 房建-其他措施费
        if (CollectionUtils.isNotEmpty(measureEntities)) {
            for (BuildMeasureEntity twoEntity : measureEntities) {
                measureMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildMeasureEntity cdEntity : measureEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(measureMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildMeasureService.saveOrUpdateBatch(measureEntities, measureEntities.size(), false);
        }

        Map<Long, Long> manageMap = new HashMap<>();
        List<BuildScaffoldEntity> buildScaffoldList = entity.getBuildScaffoldList();// 房建-现场管理费
        if (CollectionUtils.isNotEmpty(buildScaffoldList)) {
            for (BuildScaffoldEntity twoEntity : buildScaffoldList) {
                manageMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildScaffoldEntity cdEntity : buildScaffoldList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(manageMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildScaffoldService.saveOrUpdateBatch(buildScaffoldList, buildScaffoldList.size(), false);
        }

        Map<Long, Long> feesMap = new HashMap<>();
        List<BuildTemplatesEntity> buildTemplatesList = entity.getBuildTemplatesList();// 房建-规费
        if (CollectionUtils.isNotEmpty(buildTemplatesList)) {
            for (BuildTemplatesEntity twoEntity : buildTemplatesList) {
                feesMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildTemplatesEntity cdEntity : buildTemplatesList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(feesMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildTemplatesService.saveOrUpdateBatch(buildTemplatesList, buildTemplatesList.size(), false);
        }

        Map<Long, Long> otherMap = new HashMap<>();
        List<BuildPrecipitationEntity> buildPrecipitationList = entity.getBuildPrecipitationList();// 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildPrecipitationList)) {
            for (BuildPrecipitationEntity twoEntity : buildPrecipitationList) {
                otherMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildPrecipitationEntity cdEntity : buildPrecipitationList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(otherMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildPrecipitationService.saveOrUpdateBatch(buildPrecipitationList, buildPrecipitationList.size(), false);
        }

        Map<Long, Long> completeMap = new HashMap<>();
        List<BuildCompleteEntity> buildCompleteList = entity.getBuildCompleteList();// 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildCompleteList)) {
            for (BuildCompleteEntity twoEntity : buildCompleteList) {
                completeMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildCompleteEntity cdEntity : buildCompleteList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(completeMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildCompleteService.saveOrUpdateBatch(buildCompleteList, buildCompleteList.size(), false);
        }
        Map<Long, Long> nightMap = new HashMap<>();
        List<BuildNightEntity> buildNightList = entity.getBuildNightList();// 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildNightList)) {
            for (BuildNightEntity twoEntity : buildNightList) {
                nightMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildNightEntity cdEntity : buildNightList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(nightMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildNightService.saveOrUpdateBatch(buildNightList, buildNightList.size(), false);
        }
        Map<Long, Long> appointMap = new HashMap<>();
        List<BuildAppointEntity> buildAppointList = entity.getBuildAppointList();// 房建-其他费用
        if (CollectionUtils.isNotEmpty(buildAppointList)) {
            for (BuildAppointEntity twoEntity : buildAppointList) {
                appointMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildAppointEntity cdEntity : buildAppointList) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(appointMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildAppointService.saveOrUpdateBatch(buildAppointList, buildAppointList.size(), false);
        }
    }

    public List<BuildPlansEntity> SumPlanDetail(BuildDutyVO vo) {
        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList(); //计划汇总表
        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();//人工费
        List<BuildSubVO> buildSubList = vo.getBuildSubList(); // 房建-专业分包
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList(); // 房建-主要材料
//        List<BuildRmatVO> buildRmatList = vo.getBuildRmatList(); // 房建-周转材
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList(); // 房建-机械设备费
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList(); // 房建-安全文明施工费
//        List<BuildTemporaryVO> buildTemporaryList = vo.getBuildTemporaryList(); // 房建-临时设施费
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList(); // 房建-其他措施费
//        List<BuildManageVO> buildManageList = vo.getBuildManageList(); // 房建-现场管理费
//        List<BuildFeesVO> buildFeesList = vo.getBuildFeesList(); // 房建-规费
//        List<BuildOtherVO> buildOtherList = vo.getBuildOtherList(); // 房建-其他费用

        //生成汇总表
        List<BuildPlansEntity> dutyPlansEntityList = new ArrayList<>();
        BigDecimal sumPlansMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;//税金
        BigDecimal sumPlansMny2 = BigDecimal.ZERO;

        for (int i = 0; i < buildPlansList.size(); i++) {
            BuildPlansEntity buildPlansEntity = BeanMapper.map(buildPlansList.get(i), BuildPlansEntity.class);
            buildPlansEntity.setId(null);
            if (i == 0) {
                BigDecimal plansMny = buildRgcostList.stream().filter(item -> null == item.getParentId() && null != item.getRgcostMny()).map(BuildRgcostVO::getRgcostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildRgcostList.stream().filter(item -> null == item.getParentId() && null != item.getRgcostTax()).map(BuildRgcostVO::getRgcostTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 1) {
                BigDecimal plansMny = buildSubList.stream().filter(item -> null == item.getParentId() && null != item.getSubMny()).map(BuildSubVO::getSubMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildSubList.stream().filter(item -> null == item.getParentId() && null != item.getSubTax()).map(BuildSubVO::getSubTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 2) {
                BigDecimal plansMny = buildMaterialList.stream().filter(item -> null == item.getParentId() && null != item.getMaterialMny()).map(BuildMaterialVO::getMaterialMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildMaterialList.stream().filter(item -> null == item.getParentId() && null != item.getMaterialTax()).map(BuildMaterialVO::getMaterialTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 3) {
//                BigDecimal plansMny = buildRmatList.stream().filter(item -> null == item.getParentId() && null != item.getRmatMny()).map(BuildRmatVO::getRmatMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                buildPlansEntity.setPlansMny(plansMny);
//                BigDecimal priceTax = buildRmatList.stream().filter(item -> null == item.getParentId() && null != item.getRmatTax()).map(BuildRmatVO::getRmatTax).reduce(BigDecimal.ZERO, BigDecimal::add);
//                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 4) {
                BigDecimal plansMny = buildEquipmentList.stream().filter(item -> null == item.getParentId() && null != item.getEquipmentMny()).map(BuildEquipmentVO::getEquipmentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildEquipmentList.stream().filter(item -> null == item.getParentId() && null != item.getEquipmentTax()).map(BuildEquipmentVO::getEquipmentTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 5) {
                BigDecimal plansMny = buildSafeList.stream().filter(item -> null == item.getParentId() && null != item.getSafeMny()).map(BuildSafeVO::getSafeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildSafeList.stream().filter(item -> null == item.getParentId() && null != item.getSafeTax()).map(BuildSafeVO::getSafeTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 6) {
//                BigDecimal plansMny = buildTemporaryList.stream().filter(item -> null == item.getParentId() && null != item.getTemporaryMny()).map(BuildTemporaryVO::getTemporaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                buildPlansEntity.setPlansMny(plansMny);
//                BigDecimal priceTax = buildTemporaryList.stream().filter(item -> null == item.getParentId() && null != item.getTemporaryTax()).map(BuildTemporaryVO::getTemporaryTax).reduce(BigDecimal.ZERO, BigDecimal::add);
//                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 7) {
                BigDecimal plansMny = buildMeasureList.stream().filter(item -> null == item.getParentId() && null != item.getMeasureMny()).map(BuildMeasureVO::getMeasureMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildMeasureList.stream().filter(item -> null == item.getParentId() && null != item.getMeasureTax()).map(BuildMeasureVO::getMeasureTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 8) {
//                BigDecimal plansMny = buildFeesList.stream().filter(item -> null == item.getParentId() && null != item.getFeesMny()).map(BuildFeesVO::getFeesMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                buildPlansEntity.setPlansMny(plansMny);
            } else if (i == 9) {
//                BigDecimal plansMny = buildManageList.stream().filter(item -> null == item.getParentId() && null != item.getManageMny()).map(BuildManageVO::getManageMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                buildPlansEntity.setPlansMny(plansMny);
//                BigDecimal priceTax = buildManageList.stream().filter(item -> null == item.getParentId() && null != item.getManageTax()).map(BuildManageVO::getManageTax).reduce(BigDecimal.ZERO, BigDecimal::add);
//                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 11) {
//                BigDecimal plansMny = buildOtherList.stream().filter(item -> null == item.getParentId() && null != item.getOtherMny()).map(BuildOtherVO::getOtherMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                buildPlansEntity.setPlansMny(plansMny);
            } else if (i == 13) {
                //第一个合计行
                buildPlansEntity.setPlansMny(sumPlansMny);
            } else if (i == 18) {
                //第二个合计行
                buildPlansEntity.setPlansMny(sumPlansMny2);
            } else if (i == 15) {
                //税金合计行
                buildPlansEntity.setPlansMny(sumTaxMny);
            }
            if (i < 13) {
                sumPlansMny = sumPlansMny.add(buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny());//合计行1累加
            } else if (i > 12 && i < 18) {
                sumPlansMny2 = sumPlansMny2.add(buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny());//合计行2累加
            }
            BigDecimal plansYsMny = buildPlansEntity.getPlansYsMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansYsMny();
            if (null != buildPlansEntity.getPlansMny()) {
                buildPlansEntity.setPlansJcMny(plansYsMny.subtract(buildPlansEntity.getPlansMny()));
                if (BigDecimal.ZERO.compareTo(plansYsMny) != 0) {
                    buildPlansEntity.setPlansJcRate((plansYsMny.subtract(buildPlansEntity.getPlansMny())).multiply(new BigDecimal(100)).divide(plansYsMny, 2, BigDecimal.ROUND_HALF_DOWN));
                }
            }
            dutyPlansEntityList.add(buildPlansEntity);
        }

        if (CollectionUtils.isNotEmpty(dutyPlansEntityList)) {
            for (BuildPlansEntity buildPlansEntity : dutyPlansEntityList) {
                if (BigDecimal.ZERO.compareTo(sumPlansMny2) != 0) {
                    BigDecimal plansMny = buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny();
                    buildPlansEntity.setPlansRate(plansMny.multiply(new BigDecimal(100)).divide(sumPlansMny2, 2, BigDecimal.ROUND_HALF_DOWN));
                } else {
                    buildPlansEntity.setPlansRate(BigDecimal.ZERO);
                }
            }
        }
        return dutyPlansEntityList;
    }


}
