/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.build.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.build.bean.BuildDutyEntity;
import com.ejianc.business.build.bean.BuildEquipmentEntity;
import com.ejianc.business.build.bean.BuildFeesEntity;
import com.ejianc.business.build.bean.BuildManageEntity;
import com.ejianc.business.build.bean.BuildMaterialEntity;
import com.ejianc.business.build.bean.BuildMeasureEntity;
import com.ejianc.business.build.bean.BuildOtherEntity;
import com.ejianc.business.build.bean.BuildPlansEntity;
import com.ejianc.business.build.bean.BuildRgcostEntity;
import com.ejianc.business.build.bean.BuildRmatEntity;
import com.ejianc.business.build.bean.BuildSafeEntity;
import com.ejianc.business.build.bean.BuildSubEntity;
import com.ejianc.business.build.bean.BuildTemporaryEntity;
import com.ejianc.business.build.mapper.BuildDutyMapper;
import com.ejianc.business.build.service.IBuildDutyService;
import com.ejianc.business.build.service.IBuildEquipmentService;
import com.ejianc.business.build.service.IBuildFeesService;
import com.ejianc.business.build.service.IBuildManageService;
import com.ejianc.business.build.service.IBuildMaterialService;
import com.ejianc.business.build.service.IBuildMeasureService;
import com.ejianc.business.build.service.IBuildOtherService;
import com.ejianc.business.build.service.IBuildPlansService;
import com.ejianc.business.build.service.IBuildRgcostService;
import com.ejianc.business.build.service.IBuildRmatService;
import com.ejianc.business.build.service.IBuildSafeService;
import com.ejianc.business.build.service.IBuildSubService;
import com.ejianc.business.build.service.IBuildTemporaryService;
import com.ejianc.business.build.vo.BuildDutyRecordVO;
import com.ejianc.business.build.vo.BuildDutyVO;
import com.ejianc.business.build.vo.BuildEquipmentVO;
import com.ejianc.business.build.vo.BuildFeesVO;
import com.ejianc.business.build.vo.BuildManageVO;
import com.ejianc.business.build.vo.BuildMaterialVO;
import com.ejianc.business.build.vo.BuildMeasureVO;
import com.ejianc.business.build.vo.BuildOtherVO;
import com.ejianc.business.build.vo.BuildPlansVO;
import com.ejianc.business.build.vo.BuildRgcostVO;
import com.ejianc.business.build.vo.BuildRmatVO;
import com.ejianc.business.build.vo.BuildSafeVO;
import com.ejianc.business.build.vo.BuildSubVO;
import com.ejianc.business.build.vo.BuildTemporaryVO;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.DetailIndexExcelReader2;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ImportBuildVo;
import com.ejianc.business.targetcost.vo.ImportErrorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="buildDutyService")
public class BuildDutyServiceImpl
extends BaseServiceImpl<BuildDutyMapper, BuildDutyEntity>
implements IBuildDutyService {
    private static final String BILL_CODE = "BUILDDUTY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBuildPlansService buildPlansService;
    @Autowired
    private IBuildRgcostService buildRgcostService;
    @Autowired
    private IBuildSubService buildSubService;
    @Autowired
    private IBuildMaterialService buildMaterialService;
    @Autowired
    private IBuildRmatService buildRmatService;
    @Autowired
    private IBuildEquipmentService buildEquipmentService;
    @Autowired
    private IBuildSafeService buildSafeService;
    @Autowired
    private IBuildTemporaryService buildTemporaryService;
    @Autowired
    private IBuildMeasureService buildMeasureService;
    @Autowired
    private IBuildManageService buildManageService;
    @Autowired
    private IBuildFeesService buildFeesService;
    @Autowired
    private IBuildOtherService buildOtherService;
    @Autowired
    private IDutyService dutyService;

    @Override
    public CommonResponse<BuildDutyVO> saveOrUpdate(BuildDutyVO saveOrUpdateVO) {
        BuildDutyVO buildDutyVO;
        List<BuildPlansEntity> dutyPlansEntityList;
        BuildDutyEntity entity = (BuildDutyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BuildDutyEntity.class));
        if (entity.getLastDutyId() != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getFirstImportId, (Object)entity.getBaseDutyId());
            queryWrapper.isNotNull(DutyEntity::getLastDutyId);
            queryWrapper.notIn(DutyEntity::getBillState, new Object[]{"1,3"});
            if (this.dutyService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u5b58\u5728\u53d8\u66f4\u4e2d\u7684\u3010\u76ee\u6807\u8d23\u4efb\u6210\u672c\u3011\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u53d8\u66f4\uff01");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null == entity.getDutyVersion()) {
            entity.setDutyVersion(1);
        }
        entity.setConvertFlag(0);
        super.saveOrUpdate((Object)entity, false);
        if (entity.getBaseDutyId() == null && 0 == entity.getChangeState()) {
            entity.setBaseDutyId(entity.getId());
            entity.setOneTime(entity.getCreateTime());
        }
        if (entity.getLastDutyId() != null) {
            BuildDutyEntity revise = (BuildDutyEntity)((Object)super.getById((Serializable)entity.getLastDutyId()));
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            super.saveOrUpdate((Object)revise);
        }
        if (CollectionUtils.isNotEmpty(entity.getBuildPlansList()) && CollectionUtils.isNotEmpty(dutyPlansEntityList = this.SumPlanDetail(buildDutyVO = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class))))) {
            this.buildPlansService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)entity.getId()));
            this.buildPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
            BuildPlansEntity plansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size() - 1);
            BuildPlansEntity lastPlansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size() - 6);
            entity.setTaxMny(plansEntity.getPlansMny());
            entity.setMny(lastPlansEntity.getPlansMny());
        }
        super.updateById((Object)entity);
        this.updateByPid(entity);
        BuildDutyVO vo = this.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long dutyId = null;
        if (!StringUtils.isNotEmpty((CharSequence)request.getParameter("dutyId"))) {
            return CommonResponse.error((String)"\u4e3b\u8868\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        dutyId = Long.valueOf(request.getParameter("dutyId"));
        BuildDutyEntity buildDutyEntity = (BuildDutyEntity)((Object)super.selectById((Serializable)dutyId));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader2.getNumberOfSheets(mf);
        if (size == null || size != 17) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u6570\u5e94\u8be5\u4e3a17\u4e2a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u9690\u85cf\u9875\u7b7e\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
        List<List<String>> result1 = resList.get(1);
        if (result1.size() > 0 && result1.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u76ee\u6807\u6210\u672c\u8ba1\u5212\u6c47\u603b\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result2 = resList.get(4);
        if (result2.size() > 0 && result2.get(0).size() < 13) {
            return CommonResponse.error((String)"[\u4eba\u5de5\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result3 = resList.get(5);
        if (result3.size() > 0 && result3.get(0).size() < 14) {
            return CommonResponse.error((String)"[\u5206\u5305\u5de5\u7a0b\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result4 = resList.get(6);
        if (result4.size() > 0 && result4.get(0).size() < 16) {
            return CommonResponse.error((String)"[\u4e3b\u8981\u6750\u6599\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result5 = resList.get(13);
        if (result5.size() > 0 && result5.get(0).size() < 14) {
            return CommonResponse.error((String)"[\u5468\u8f6c\u6750\u6599\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result6 = resList.get(14);
        if (result6.size() > 0 && result6.get(0).size() < 14) {
            return CommonResponse.error((String)"[\u673a\u68b0\u4f7f\u7528\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result7 = resList.get(9);
        if (result7.size() > 0 && result7.get(0).size() < 13) {
            return CommonResponse.error((String)"[\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result8 = resList.get(10);
        if (result8.size() > 0 && result8.get(0).size() < 13) {
            return CommonResponse.error((String)"[\u4e34\u65f6\u8bbe\u65bd\u8d39\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result9 = resList.get(11);
        if (result9.size() > 0 && result9.get(0).size() < 13) {
            return CommonResponse.error((String)"[\u5176\u4ed6\u63aa\u65bd\u8d39\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result10 = resList.get(12);
        if (result10.size() > 0 && result10.get(0).size() < 14) {
            return CommonResponse.error((String)"[\u73b0\u573a\u7ba1\u7406\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result11 = resList.get(15);
        if (result11.size() > 0 && result11.get(0).size() < 7) {
            return CommonResponse.error((String)"[\u89c4\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result12 = resList.get(16);
        if (result12.size() > 0 && result12.get(0).size() < 7) {
            return CommonResponse.error((String)"[\u5176\u5b83\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ImportBuildVo importVo1 = this.excelImportPlan(result1, dutyId);
        ImportBuildVo importVo2 = this.excelImportRgcost(result2, dutyId);
        ImportBuildVo importVo3 = this.excelImportSub(result3, dutyId);
        ImportBuildVo importVo4 = this.excelImportMaterial(result4, dutyId);
        ImportBuildVo importVo5 = this.excelImportRmat(result5, dutyId);
        ImportBuildVo importVo6 = this.excelImportEquipment(result6, dutyId);
        ImportBuildVo importVo7 = this.excelImportSafe(result7, dutyId);
        ImportBuildVo importVo8 = this.excelImportTemporary(result8, dutyId);
        ImportBuildVo importVo9 = this.excelImportMeasure(result9, dutyId);
        ImportBuildVo importVo10 = this.excelImportManage(result10, dutyId);
        ImportBuildVo importVo11 = this.excelImportFees(result11, dutyId);
        ImportBuildVo importVo12 = this.excelImportOther(result12, dutyId);
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        errorList.addAll(importVo1.getErrorList());
        errorList.addAll(importVo2.getErrorList());
        errorList.addAll(importVo3.getErrorList());
        errorList.addAll(importVo4.getErrorList());
        errorList.addAll(importVo5.getErrorList());
        errorList.addAll(importVo6.getErrorList());
        errorList.addAll(importVo7.getErrorList());
        errorList.addAll(importVo8.getErrorList());
        errorList.addAll(importVo9.getErrorList());
        errorList.addAll(importVo10.getErrorList());
        errorList.addAll(importVo11.getErrorList());
        errorList.addAll(importVo12.getErrorList());
        if (errorList.size() > 0) {
            resp.put("successList", null);
            resp.put("successNum", (Object)0);
            resp.put("errorNum", (Object)errorList.size());
            if (errorList.size() > 100) {
                resp.put("errorList", errorList.subList(0, 100));
            } else {
                resp.put("errorList", errorList);
            }
        } else {
            List<BuildPlansVO> buildPlansList = importVo1.getBuildPlansList();
            List<BuildRgcostVO> buildRgcostList = importVo2.getBuildRgcostList();
            List<BuildSubVO> buildSubList = importVo3.getBuildSubList();
            List<BuildMaterialVO> buildMaterialList = importVo4.getBuildMaterialList();
            List<BuildRmatVO> buildRmatList = importVo5.getBuildRmatList();
            List<BuildEquipmentVO> buildEquipmentList = importVo6.getBuildEquipmentList();
            List<BuildSafeVO> buildSafeList = importVo7.getBuildSafeList();
            List<BuildTemporaryVO> buildTemporaryList = importVo8.getBuildTemporaryList();
            List<BuildMeasureVO> buildMeasureList = importVo9.getBuildMeasureList();
            List<BuildManageVO> buildManageList = importVo10.getBuildManageList();
            List<BuildFeesVO> buildFeesList = importVo11.getBuildFeesList();
            List<BuildOtherVO> buildOtherList = importVo12.getBuildOtherList();
            int sucNum = buildPlansList.size() + buildRgcostList.size() + buildSubList.size() + buildMaterialList.size() + buildRmatList.size() + buildEquipmentList.size() + buildSafeList.size() + buildTemporaryList.size() + buildMeasureList.size() + buildManageList.size() + buildFeesList.size() + buildOtherList.size();
            resp.put("successList", null);
            resp.put("errorList", null);
            resp.put("successNum", (Object)sucNum);
            resp.put("errorNum", (Object)0);
            this.buildPlansService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildPlansList.size() > 0) {
                List buildPlansEntities = BeanMapper.mapList(buildPlansList, BuildPlansEntity.class);
                this.buildPlansService.saveOrUpdateBatch(buildPlansEntities, buildPlansEntities.size(), false);
                BigDecimal plansMny = ((BuildPlansEntity)((Object)buildPlansEntities.get(buildPlansEntities.size() - 6))).getPlansMny();
                buildDutyEntity.setMny(plansMny);
                BigDecimal plansTaxMny = ((BuildPlansEntity)((Object)buildPlansEntities.get(buildPlansEntities.size() - 1))).getPlansMny();
                buildDutyEntity.setTaxMny(plansTaxMny);
                buildDutyEntity.setConvertFlag(0);
                super.updateById((Object)buildDutyEntity);
            }
            this.buildRgcostService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildRgcostList.size() > 0) {
                List buildRgcostEntities = BeanMapper.mapList(buildRgcostList, BuildRgcostEntity.class);
                this.buildRgcostService.saveOrUpdateBatch(buildRgcostEntities, buildRgcostEntities.size(), false);
            }
            this.buildSubService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildSubList.size() > 0) {
                List buildSubEntities = BeanMapper.mapList(buildSubList, BuildSubEntity.class);
                this.buildSubService.saveOrUpdateBatch(buildSubEntities, buildSubEntities.size(), false);
            }
            this.buildMaterialService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildMaterialList.size() > 0) {
                List buildMaterialEntities = BeanMapper.mapList(buildMaterialList, BuildMaterialEntity.class);
                this.buildMaterialService.saveOrUpdateBatch(buildMaterialEntities, buildMaterialEntities.size(), false);
            }
            this.buildRmatService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildRmatList.size() > 0) {
                List buildRmatEntities = BeanMapper.mapList(buildRmatList, BuildRmatEntity.class);
                this.buildRmatService.saveOrUpdateBatch(buildRmatEntities, buildRmatEntities.size(), false);
            }
            this.buildEquipmentService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildEquipmentList.size() > 0) {
                List buildEquipmentEntities = BeanMapper.mapList(buildEquipmentList, BuildEquipmentEntity.class);
                this.buildEquipmentService.saveOrUpdateBatch(buildEquipmentEntities, buildEquipmentEntities.size(), false);
            }
            this.buildSafeService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildSafeList.size() > 0) {
                List buildSafeEntities = BeanMapper.mapList(buildSafeList, BuildSafeEntity.class);
                this.buildSafeService.saveOrUpdateBatch(buildSafeEntities, buildSafeEntities.size(), false);
            }
            this.buildTemporaryService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildTemporaryList.size() > 0) {
                List buildTemporaryEntities = BeanMapper.mapList(buildTemporaryList, BuildTemporaryEntity.class);
                this.buildTemporaryService.saveOrUpdateBatch(buildTemporaryEntities, buildTemporaryEntities.size(), false);
            }
            this.buildMeasureService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildMeasureList.size() > 0) {
                List buildMeasureEntities = BeanMapper.mapList(buildMeasureList, BuildMeasureEntity.class);
                this.buildMeasureService.saveOrUpdateBatch(buildMeasureEntities, buildMeasureEntities.size(), false);
            }
            this.buildManageService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildManageList.size() > 0) {
                List buildManageEntities = BeanMapper.mapList(buildManageList, BuildManageEntity.class);
                this.buildManageService.saveOrUpdateBatch(buildManageEntities, buildManageEntities.size(), false);
            }
            this.buildFeesService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildFeesList.size() > 0) {
                List buildFeesEntities = BeanMapper.mapList(buildFeesList, BuildFeesEntity.class);
                this.buildFeesService.saveOrUpdateBatch(buildFeesEntities, buildFeesEntities.size(), false);
            }
            this.buildOtherService.remove((Wrapper)new QueryWrapper().eq((Object)"duty_id", (Object)dutyId));
            if (buildOtherList.size() > 0) {
                List buildOtherEntities = BeanMapper.mapList(buildOtherList, BuildOtherEntity.class);
                this.buildOtherService.saveOrUpdateBatch(buildOtherEntities, buildOtherEntities.size(), false);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    @Override
    public BuildDutyVO queryDetail(Long id) {
        BuildDutyEntity entity = (BuildDutyEntity)((Object)super.selectById((Serializable)id));
        BuildDutyVO vo = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class));
        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();
        vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        List<BuildSubVO> buildSubList = vo.getBuildSubList();
        vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList();
        vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        List<BuildRmatVO> buildRmatList = vo.getBuildRmatList();
        vo.setBuildRmatList(TreeNodeBUtil.buildTree(buildRmatList));
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList();
        vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(buildEquipmentList));
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList();
        vo.setBuildSafeList(TreeNodeBUtil.buildTree(buildSafeList));
        List<BuildTemporaryVO> buildTemporaryList = vo.getBuildTemporaryList();
        vo.setBuildTemporaryList(TreeNodeBUtil.buildTree(buildTemporaryList));
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList();
        vo.setBuildMeasureList(TreeNodeBUtil.buildTree(buildMeasureList));
        List<BuildManageVO> buildManageList = vo.getBuildManageList();
        vo.setBuildManageList(TreeNodeBUtil.buildTree(buildManageList));
        List<BuildFeesVO> buildFeesList = vo.getBuildFeesList();
        vo.setBuildFeesList(TreeNodeBUtil.buildTree(buildFeesList));
        List<BuildOtherVO> buildOtherList = vo.getBuildOtherList();
        vo.setBuildOtherList(TreeNodeBUtil.buildTree(buildOtherList));
        List<BuildDutyRecordVO> list = new ArrayList<BuildDutyRecordVO>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BuildDutyEntity::getBaseDutyId, (Object)entity.getBaseDutyId());
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(BuildDutyEntity::getBillState, billStatusList);
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List roadbridgeDutyEntities = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)roadbridgeDutyEntities)) {
            list = BeanMapper.mapList((Iterable)roadbridgeDutyEntities, BuildDutyRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public BuildDutyVO queryChangeDetail(Long id) {
        List<BuildOtherVO> list;
        List<BuildFeesVO> list2;
        List<BuildManageVO> list3;
        List<BuildMeasureVO> list4;
        List<BuildTemporaryVO> list5;
        List<BuildSafeVO> list6;
        List<BuildEquipmentVO> list7;
        List<BuildRmatVO> list8;
        List<BuildMaterialVO> buildMaterialList;
        List<BuildSubVO> buildSubList;
        List<BuildRgcostVO> buildRgcostList;
        BuildDutyEntity entity = (BuildDutyEntity)((Object)super.selectById((Serializable)id));
        BuildDutyVO vo = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class));
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);
        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList();
        if (CollectionUtils.isNotEmpty(buildPlansList)) {
            buildPlansList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setBuildPlansList(buildPlansList);
        }
        if (CollectionUtils.isNotEmpty(buildRgcostList = vo.getBuildRgcostList())) {
            HashMap idMap = new HashMap();
            buildRgcostList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildRgcostVO buildRgcostVO : buildRgcostList) {
                if (null != buildRgcostVO.getParentId()) {
                    buildRgcostVO.setParentId((Long)idMap.get(buildRgcostVO.getParentId()));
                }
                buildRgcostVO.setTid(buildRgcostVO.getId());
            }
            vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        }
        if (CollectionUtils.isNotEmpty(buildSubList = vo.getBuildSubList())) {
            HashMap idMap = new HashMap();
            buildSubList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildSubVO buildSubVO : buildSubList) {
                if (null != buildSubVO.getParentId()) {
                    buildSubVO.setParentId((Long)idMap.get(buildSubVO.getParentId()));
                }
                buildSubVO.setTid(buildSubVO.getId());
            }
            vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        }
        if (CollectionUtils.isNotEmpty(buildMaterialList = vo.getBuildMaterialList())) {
            HashMap hashMap = new HashMap();
            buildMaterialList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildMaterialVO buildMaterialVO : buildMaterialList) {
                if (null != buildMaterialVO.getParentId()) {
                    buildMaterialVO.setParentId((Long)hashMap.get(buildMaterialVO.getParentId()));
                }
                buildMaterialVO.setTid(buildMaterialVO.getId());
            }
            vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        }
        if (CollectionUtils.isNotEmpty(list8 = vo.getBuildRmatList())) {
            HashMap hashMap = new HashMap();
            list8.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildRmatVO buildRmatVO : list8) {
                if (null != buildRmatVO.getParentId()) {
                    buildRmatVO.setParentId((Long)hashMap.get(buildRmatVO.getParentId()));
                }
                buildRmatVO.setTid(buildRmatVO.getId());
            }
            vo.setBuildRmatList(TreeNodeBUtil.buildTree(list8));
        }
        if (CollectionUtils.isNotEmpty(list7 = vo.getBuildEquipmentList())) {
            HashMap hashMap = new HashMap();
            list7.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildEquipmentVO buildEquipmentVO : list7) {
                if (null != buildEquipmentVO.getParentId()) {
                    buildEquipmentVO.setParentId((Long)hashMap.get(buildEquipmentVO.getParentId()));
                }
                buildEquipmentVO.setTid(buildEquipmentVO.getId());
            }
            vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(list7));
        }
        if (CollectionUtils.isNotEmpty(list6 = vo.getBuildSafeList())) {
            HashMap hashMap = new HashMap();
            list6.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildSafeVO buildSafeVO : list6) {
                if (null != buildSafeVO.getParentId()) {
                    buildSafeVO.setParentId((Long)hashMap.get(buildSafeVO.getParentId()));
                }
                buildSafeVO.setTid(buildSafeVO.getId());
            }
            vo.setBuildSafeList(TreeNodeBUtil.buildTree(list6));
        }
        if (CollectionUtils.isNotEmpty(list5 = vo.getBuildTemporaryList())) {
            HashMap hashMap = new HashMap();
            list5.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildTemporaryVO buildTemporaryVO : list5) {
                if (null != buildTemporaryVO.getParentId()) {
                    buildTemporaryVO.setParentId((Long)hashMap.get(buildTemporaryVO.getParentId()));
                }
                buildTemporaryVO.setTid(buildTemporaryVO.getId());
            }
            vo.setBuildTemporaryList(TreeNodeBUtil.buildTree(list5));
        }
        if (CollectionUtils.isNotEmpty(list4 = vo.getBuildMeasureList())) {
            HashMap hashMap = new HashMap();
            list4.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildMeasureVO buildMeasureVO : list4) {
                if (null != buildMeasureVO.getParentId()) {
                    buildMeasureVO.setParentId((Long)hashMap.get(buildMeasureVO.getParentId()));
                }
                buildMeasureVO.setTid(buildMeasureVO.getId());
            }
            vo.setBuildMeasureList(TreeNodeBUtil.buildTree(list4));
        }
        if (CollectionUtils.isNotEmpty(list3 = vo.getBuildManageList())) {
            HashMap hashMap = new HashMap();
            list3.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildManageVO buildManageVO : list3) {
                if (null != buildManageVO.getParentId()) {
                    buildManageVO.setParentId((Long)hashMap.get(buildManageVO.getParentId()));
                }
                buildManageVO.setTid(buildManageVO.getId());
            }
            vo.setBuildManageList(TreeNodeBUtil.buildTree(list3));
        }
        if (CollectionUtils.isNotEmpty(list2 = vo.getBuildFeesList())) {
            HashMap hashMap = new HashMap();
            list2.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildFeesVO cdEntity : list2) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)hashMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildFeesList(TreeNodeBUtil.buildTree(list2));
        }
        if (CollectionUtils.isNotEmpty(list = vo.getBuildOtherList())) {
            HashMap hashMap = new HashMap();
            list.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (BuildOtherVO cdEntity : list) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)hashMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildOtherList(TreeNodeBUtil.buildTree(list));
        }
        return vo;
    }

    @Override
    public BuildDutyVO ConvertFlag(Long id) {
        BuildDutyEntity entity = (BuildDutyEntity)((Object)super.selectById((Serializable)id));
        entity.setConvertFlag(1);
        super.updateById((Object)entity);
        BuildDutyVO vo = (BuildDutyVO)((Object)BeanMapper.map((Object)((Object)entity), BuildDutyVO.class));
        this.dutyService.pushFromImport(vo, false, ConversionEnum.\u4e91\u5357\u623f\u5efa.getCode());
        return this.queryDetail(id);
    }

    @Override
    public CommonResponse<String> deleteVos(List<BuildDutyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BuildDutyVO dutyVO : vos) {
                BuildDutyEntity dutyEntity = (BuildDutyEntity)((Object)super.getById((Serializable)dutyVO.getId()));
                if (dutyEntity.getLastDutyId() != null) {
                    BuildDutyEntity revise = (BuildDutyEntity)((Object)super.getById((Serializable)dutyEntity.getLastDutyId()));
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
                    revise.setLatestFlag(true);
                    super.saveOrUpdate((Object)revise);
                }
                this.dutyService.deleteFromImport(dutyVO.getId(), ConversionEnum.\u4e91\u5357\u623f\u5efa.getCode());
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private ImportBuildVo excelImportPlan(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<BuildPlansVO> detailVoList = new ArrayList<BuildPlansVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                if (i == 3 || i == 5) continue;
                List<String> datas = result.get(i);
                BuildPlansVO vo = new BuildPlansVO();
                boolean flag = false;
                String warnType = "";
                String plansName = datas.get(1);
                String plansUnitName = datas.get(3);
                String plansYsMny = datas.get(4);
                String plansYsSquare = datas.get(5);
                String plansMny = datas.get(6);
                String plansMnySquare = datas.get(7);
                String plansJcMny = datas.get(8);
                String plansJcRate = datas.get(9);
                String plansRate = datas.get(10);
                String plansMemo = datas.get(11);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isEmpty((CharSequence)plansName)) {
                    vo.setPlansName(null);
                    warnType = warnType + "[\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setPlansName(plansName);
                }
                vo.setPlansUnitName(plansUnitName);
                if (StringUtils.isEmpty((CharSequence)plansYsMny)) {
                    vo.setPlansYsMny(null);
                } else {
                    try {
                        vo.setPlansYsMny(new BigDecimal(plansYsMny));
                    }
                    catch (Exception e) {
                        vo.setPlansYsMny(null);
                        warnType = warnType + "[\u9884\u7b97\u6536\u5165\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansYsSquare)) {
                    vo.setPlansYsSquare(null);
                } else {
                    try {
                        vo.setPlansYsSquare(new BigDecimal(plansYsSquare));
                    }
                    catch (Exception e) {
                        vo.setPlansYsSquare(null);
                        warnType = warnType + "[\u9884\u7b97\u5e73\u7c73\u9020\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansMny)) {
                    vo.setPlansMny(null);
                } else {
                    try {
                        vo.setPlansMny(new BigDecimal(plansMny));
                    }
                    catch (Exception e) {
                        vo.setPlansMny(null);
                        warnType = warnType + "[\u76ee\u6807\u6210\u672c\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansMnySquare)) {
                    vo.setPlansMnySquare(null);
                } else {
                    try {
                        vo.setPlansMnySquare(new BigDecimal(plansMnySquare));
                    }
                    catch (Exception e) {
                        vo.setPlansMnySquare(null);
                        warnType = warnType + "[\u76ee\u6807\u6210\u672c\u5e73\u7c73\u9020\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansJcMny)) {
                    vo.setPlansJcMny(null);
                } else {
                    try {
                        vo.setPlansJcMny(new BigDecimal(plansJcMny));
                    }
                    catch (Exception e) {
                        vo.setPlansJcMny(null);
                        warnType = warnType + "[\u8282\u8d85\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansJcRate)) {
                    vo.setPlansJcRate(null);
                } else {
                    try {
                        vo.setPlansJcRate(new BigDecimal(plansJcRate));
                    }
                    catch (Exception e) {
                        vo.setPlansJcRate(null);
                        warnType = warnType + "[\u8282\u8d85\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)plansRate)) {
                    vo.setPlansRate(null);
                } else {
                    try {
                        vo.setPlansRate(new BigDecimal(plansRate));
                    }
                    catch (Exception e) {
                        vo.setPlansRate(null);
                        warnType = warnType + "[\u5355\u9879\u6210\u672c\u5360\u603b\u6210\u672c\u6bd4\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setPlansMemo(plansMemo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildPlansVO> successList = new ArrayList<BuildPlansVO>();
            for (BuildPlansVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u76ee\u6807\u6210\u672c\u8ba1\u5212\u6c47\u603b\u8868");
                errorVo.setId(vo.getId());
                errorVo.setName(vo.getPlansName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildPlansList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportRgcost(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildRgcostVO> detailVoList = new ArrayList<BuildRgcostVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildRgcostVO vo = new BuildRgcostVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String rgcostCode = datas.get(1);
                String rgcostName = datas.get(2);
                String rgcostUnitName = datas.get(3);
                String rgcostNum = datas.get(4);
                String rgcostPrice = datas.get(5);
                String rgcostTaxPrice = datas.get(6);
                String rgcostRate = datas.get(7);
                String rgcostPriceTax = datas.get(8);
                String rgcostMny = datas.get(9);
                String rgcostTaxMny = datas.get(11);
                String rgcostTax = datas.get(12);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)rgcostCode)) {
                    vo.setRgcostCode(null);
                } else {
                    vo.setRgcostCode(rgcostCode);
                }
                if (StringUtils.isEmpty((CharSequence)rgcostName)) {
                    vo.setRgcostName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setRgcostName(rgcostName);
                }
                vo.setRgcostUnitName(rgcostUnitName);
                if (StringUtils.isEmpty((CharSequence)rgcostNum)) {
                    vo.setRgcostNum(null);
                } else {
                    try {
                        vo.setRgcostNum(new BigDecimal(rgcostNum));
                    }
                    catch (Exception e) {
                        vo.setRgcostNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostPrice)) {
                    vo.setRgcostPrice(null);
                } else {
                    try {
                        vo.setRgcostPrice(new BigDecimal(rgcostPrice));
                    }
                    catch (Exception e) {
                        vo.setRgcostPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostTaxPrice)) {
                    vo.setRgcostTaxPrice(null);
                } else {
                    try {
                        vo.setRgcostTaxPrice(new BigDecimal(rgcostTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setRgcostTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostRate)) {
                    vo.setRgcostRate(null);
                } else {
                    try {
                        vo.setRgcostRate(new BigDecimal(rgcostRate));
                    }
                    catch (Exception e) {
                        vo.setRgcostRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostPriceTax)) {
                    vo.setRgcostPriceTax(null);
                } else {
                    try {
                        vo.setRgcostPriceTax(new BigDecimal(rgcostPriceTax));
                    }
                    catch (Exception e) {
                        vo.setRgcostPriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostMny)) {
                    vo.setRgcostMny(null);
                } else {
                    try {
                        vo.setRgcostMny(new BigDecimal(rgcostMny));
                    }
                    catch (Exception e) {
                        vo.setRgcostMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostTaxMny)) {
                    vo.setRgcostTaxMny(null);
                } else {
                    try {
                        vo.setRgcostTaxMny(new BigDecimal(rgcostTaxMny));
                    }
                    catch (Exception e) {
                        vo.setRgcostTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rgcostTax)) {
                    vo.setRgcostTax(null);
                } else {
                    try {
                        vo.setRgcostTax(new BigDecimal(rgcostTax));
                    }
                    catch (Exception e) {
                        vo.setRgcostTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildRgcostVO> successList = new ArrayList<BuildRgcostVO>();
            for (BuildRgcostVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u4eba\u5de5\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getRgcostCode());
                errorVo.setName(vo.getRgcostName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildRgcostList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportSub(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildSubVO> detailVoList = new ArrayList<BuildSubVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildSubVO vo = new BuildSubVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String subCode = datas.get(1);
                String subName = datas.get(3);
                String subUnitName = datas.get(4);
                String subNum = datas.get(5);
                String subYsPrice = datas.get(6);
                String subYsMny = datas.get(7);
                String subPrice = datas.get(8);
                String subTaxPrice = datas.get(9);
                String subRate = datas.get(10);
                String subPriceTax = datas.get(11);
                String subMny = datas.get(12);
                String subTaxMny = datas.get(14);
                String subTax = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)subCode)) {
                    vo.setSubCode(null);
                } else {
                    vo.setSubCode(subCode);
                }
                if (StringUtils.isEmpty((CharSequence)subName)) {
                    vo.setSubName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSubName(subName);
                }
                vo.setSubUnitName(subUnitName);
                if (StringUtils.isEmpty((CharSequence)subNum)) {
                    vo.setSubNum(null);
                } else {
                    try {
                        vo.setSubNum(new BigDecimal(subNum));
                    }
                    catch (Exception e) {
                        vo.setSubNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subYsPrice)) {
                    vo.setSubYsPrice(null);
                } else {
                    try {
                        vo.setSubYsPrice(new BigDecimal(subYsPrice));
                    }
                    catch (Exception e) {
                        vo.setSubYsPrice(null);
                        warnType = warnType + "[\u9884\u7b97\u7efc\u5408\u5355\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subYsMny)) {
                    vo.setSubYsMny(null);
                } else {
                    try {
                        vo.setSubYsMny(new BigDecimal(subYsMny));
                    }
                    catch (Exception e) {
                        vo.setSubYsMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subPrice)) {
                    vo.setSubPrice(null);
                } else {
                    try {
                        vo.setSubPrice(new BigDecimal(subPrice));
                    }
                    catch (Exception e) {
                        vo.setSubPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subTaxPrice)) {
                    vo.setSubTaxPrice(null);
                } else {
                    try {
                        vo.setSubTaxPrice(new BigDecimal(subTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setSubTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subRate)) {
                    vo.setSubRate(null);
                } else {
                    try {
                        vo.setSubRate(new BigDecimal(subRate));
                    }
                    catch (Exception e) {
                        vo.setSubRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subPriceTax)) {
                    vo.setSubPriceTax(null);
                } else {
                    try {
                        vo.setSubPriceTax(new BigDecimal(subPriceTax));
                    }
                    catch (Exception e) {
                        vo.setSubPriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subMny)) {
                    vo.setSubMny(null);
                } else {
                    try {
                        vo.setSubMny(new BigDecimal(subMny));
                    }
                    catch (Exception e) {
                        vo.setSubMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subTaxMny)) {
                    vo.setSubTaxMny(null);
                } else {
                    try {
                        vo.setSubTaxMny(new BigDecimal(subTaxMny));
                    }
                    catch (Exception e) {
                        vo.setSubTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)subTax)) {
                    vo.setSubTax(null);
                } else {
                    try {
                        vo.setSubTax(new BigDecimal(subTax));
                    }
                    catch (Exception e) {
                        vo.setSubTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildSubVO> successList = new ArrayList<BuildSubVO>();
            for (BuildSubVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5206\u5305\u5de5\u7a0b\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getSubCode());
                errorVo.setName(vo.getSubName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildSubList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportMaterial(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildMaterialVO> detailVoList = new ArrayList<BuildMaterialVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildMaterialVO vo = new BuildMaterialVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String materialCode = datas.get(1);
                String materialName = datas.get(3);
                String materialSpec = datas.get(4);
                String materialUnitName = datas.get(5);
                String materialYsNum = datas.get(6);
                String materialNum = datas.get(7);
                String materialYsPrice = datas.get(8);
                String materialYsMny = datas.get(9);
                String materialPrice = datas.get(10);
                String materialTaxPrice = datas.get(11);
                String materialRate = datas.get(12);
                String materialPriceTax = datas.get(13);
                String materialMny = datas.get(14);
                String materialTaxMny = datas.get(16);
                String materialTax = datas.get(17);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)materialCode)) {
                    vo.setMaterialCode(null);
                } else {
                    vo.setMaterialCode(materialCode);
                }
                if (StringUtils.isEmpty((CharSequence)materialName)) {
                    vo.setMaterialName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMaterialName(materialName);
                }
                vo.setMaterialUnitName(materialUnitName);
                vo.setMaterialSpec(materialSpec);
                if (StringUtils.isEmpty((CharSequence)materialNum)) {
                    vo.setMaterialNum(null);
                } else {
                    try {
                        vo.setMaterialNum(new BigDecimal(materialNum));
                    }
                    catch (Exception e) {
                        vo.setMaterialNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialYsNum)) {
                    vo.setMaterialYsNum(null);
                } else {
                    try {
                        vo.setMaterialYsNum(new BigDecimal(materialYsNum));
                    }
                    catch (Exception e) {
                        vo.setMaterialYsNum(null);
                        warnType = warnType + "[\u9884\u7b97\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialYsPrice)) {
                    vo.setMaterialYsPrice(null);
                } else {
                    try {
                        vo.setMaterialYsPrice(new BigDecimal(materialYsPrice));
                    }
                    catch (Exception e) {
                        vo.setMaterialYsPrice(null);
                        warnType = warnType + "[\u9884\u7b97-\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialYsMny)) {
                    vo.setMaterialYsMny(null);
                } else {
                    try {
                        vo.setMaterialYsMny(new BigDecimal(materialYsMny));
                    }
                    catch (Exception e) {
                        vo.setMaterialYsMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialPrice)) {
                    vo.setMaterialPrice(null);
                } else {
                    try {
                        vo.setMaterialPrice(new BigDecimal(materialPrice));
                    }
                    catch (Exception e) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialTaxPrice)) {
                    vo.setMaterialTaxPrice(null);
                } else {
                    try {
                        vo.setMaterialTaxPrice(new BigDecimal(materialTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMaterialTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialRate)) {
                    vo.setMaterialRate(null);
                } else {
                    try {
                        vo.setMaterialRate(new BigDecimal(materialRate));
                    }
                    catch (Exception e) {
                        vo.setMaterialRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialPriceTax)) {
                    vo.setMaterialPriceTax(null);
                } else {
                    try {
                        vo.setMaterialPriceTax(new BigDecimal(materialPriceTax));
                    }
                    catch (Exception e) {
                        vo.setMaterialPriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialMny)) {
                    vo.setMaterialMny(null);
                } else {
                    try {
                        vo.setMaterialMny(new BigDecimal(materialMny));
                    }
                    catch (Exception e) {
                        vo.setMaterialMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialTaxMny)) {
                    vo.setMaterialTaxMny(null);
                } else {
                    try {
                        vo.setMaterialTaxMny(new BigDecimal(materialTaxMny));
                    }
                    catch (Exception e) {
                        vo.setMaterialTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)materialTax)) {
                    vo.setMaterialTax(null);
                } else {
                    try {
                        vo.setMaterialTax(new BigDecimal(materialTax));
                    }
                    catch (Exception e) {
                        vo.setMaterialTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildMaterialVO> successList = new ArrayList<BuildMaterialVO>();
            for (BuildMaterialVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u4e3b\u8981\u6750\u6599\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getMaterialCode());
                errorVo.setName(vo.getMaterialName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildMaterialList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportRmat(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildRmatVO> detailVoList = new ArrayList<BuildRmatVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildRmatVO vo = new BuildRmatVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String rmatCode = datas.get(1);
                String rmatName = datas.get(3);
                String rmatUnitName = datas.get(4);
                String rmatNum = datas.get(5);
                String rmatRentMonth = datas.get(6);
                String rmatCostScale = datas.get(7);
                String rmatPrice = datas.get(8);
                String rmatTaxPrice = datas.get(9);
                String rmatRate = datas.get(10);
                String rmatPriceTax = datas.get(11);
                String rmatMny = datas.get(12);
                String rmatTaxMny = datas.get(14);
                String rmatTax = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)rmatCode)) {
                    vo.setRmatCode(null);
                } else {
                    vo.setRmatCode(rmatCode);
                }
                if (StringUtils.isEmpty((CharSequence)rmatName)) {
                    vo.setRmatName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setRmatName(rmatName);
                }
                vo.setRmatUnitName(rmatUnitName);
                if (StringUtils.isEmpty((CharSequence)rmatNum)) {
                    vo.setRmatNum(null);
                } else {
                    try {
                        vo.setRmatNum(new BigDecimal(rmatNum));
                    }
                    catch (Exception e) {
                        vo.setRmatNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatRentMonth)) {
                    vo.setRmatRentMonth(null);
                } else {
                    try {
                        vo.setRmatRentMonth(new BigDecimal(rmatRentMonth));
                    }
                    catch (Exception e) {
                        vo.setRmatRentMonth(null);
                        warnType = warnType + "[\u79df\u7528\u65f6\u95f4\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatCostScale)) {
                    vo.setRmatCostScale(null);
                } else {
                    try {
                        vo.setRmatCostScale(new BigDecimal(rmatCostScale));
                    }
                    catch (Exception e) {
                        vo.setRmatCostScale(null);
                        warnType = warnType + "[\u644a\u9500\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatPrice)) {
                    vo.setRmatPrice(null);
                } else {
                    try {
                        vo.setRmatPrice(new BigDecimal(rmatPrice));
                    }
                    catch (Exception e) {
                        vo.setRmatPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatTaxPrice)) {
                    vo.setRmatTaxPrice(null);
                } else {
                    try {
                        vo.setRmatTaxPrice(new BigDecimal(rmatTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setRmatTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatRate)) {
                    vo.setRmatRate(null);
                } else {
                    try {
                        vo.setRmatRate(new BigDecimal(rmatRate));
                    }
                    catch (Exception e) {
                        vo.setRmatRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatPriceTax)) {
                    vo.setRmatPriceTax(null);
                } else {
                    try {
                        vo.setRmatPriceTax(new BigDecimal(rmatPriceTax));
                    }
                    catch (Exception e) {
                        vo.setRmatPriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatMny)) {
                    vo.setRmatMny(null);
                } else {
                    try {
                        vo.setRmatMny(new BigDecimal(rmatMny));
                    }
                    catch (Exception e) {
                        vo.setRmatMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatTaxMny)) {
                    vo.setRmatTaxMny(null);
                } else {
                    try {
                        vo.setRmatTaxMny(new BigDecimal(rmatTaxMny));
                    }
                    catch (Exception e) {
                        vo.setRmatTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rmatTax)) {
                    vo.setRmatTax(null);
                } else {
                    try {
                        vo.setRmatTax(new BigDecimal(rmatTax));
                    }
                    catch (Exception e) {
                        vo.setRmatTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildRmatVO> successList = new ArrayList<BuildRmatVO>();
            for (BuildRmatVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5468\u8f6c\u6750\u6599\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getRmatCode());
                errorVo.setName(vo.getRmatName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildRmatList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportEquipment(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildEquipmentVO> detailVoList = new ArrayList<BuildEquipmentVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildEquipmentVO vo = new BuildEquipmentVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String equipmentCode = datas.get(1);
                String equipmentName = datas.get(3);
                String equipmentUnitName = datas.get(4);
                String equipmentNum = datas.get(5);
                String equipmentRentMonth = datas.get(6);
                String equipmentCostScale = datas.get(7);
                String equipmentPrice = datas.get(8);
                String equipmentTaxPrice = datas.get(9);
                String equipmentRate = datas.get(10);
                String equipmentPriceTax = datas.get(11);
                String equipmentMny = datas.get(12);
                String equipmentTaxMny = datas.get(14);
                String equipmentTax = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)equipmentCode)) {
                    vo.setEquipmentCode(null);
                } else {
                    vo.setEquipmentCode(equipmentCode);
                }
                if (StringUtils.isEmpty((CharSequence)equipmentName)) {
                    vo.setEquipmentName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setEquipmentName(equipmentName);
                }
                vo.setEquipmentUnitName(equipmentUnitName);
                if (StringUtils.isEmpty((CharSequence)equipmentNum)) {
                    vo.setEquipmentNum(null);
                } else {
                    try {
                        vo.setEquipmentNum(new BigDecimal(equipmentNum));
                    }
                    catch (Exception e) {
                        vo.setEquipmentNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentRentMonth)) {
                    vo.setEquipmentRentMonth(null);
                } else {
                    try {
                        vo.setEquipmentRentMonth(new BigDecimal(equipmentRentMonth));
                    }
                    catch (Exception e) {
                        vo.setEquipmentRentMonth(null);
                        warnType = warnType + "[\u79df\u7528\u65f6\u95f4\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentCostScale)) {
                    vo.setEquipmentCostScale(null);
                } else {
                    try {
                        vo.setEquipmentCostScale(new BigDecimal(equipmentCostScale));
                    }
                    catch (Exception e) {
                        vo.setEquipmentCostScale(null);
                        warnType = warnType + "[\u644a\u9500\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentPrice)) {
                    vo.setEquipmentPrice(null);
                } else {
                    try {
                        vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
                    }
                    catch (Exception e) {
                        vo.setEquipmentPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentTaxPrice)) {
                    vo.setEquipmentTaxPrice(null);
                } else {
                    try {
                        vo.setEquipmentTaxPrice(new BigDecimal(equipmentTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setEquipmentTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentRate)) {
                    vo.setEquipmentRate(null);
                } else {
                    try {
                        vo.setEquipmentRate(new BigDecimal(equipmentRate));
                    }
                    catch (Exception e) {
                        vo.setEquipmentRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentPriceTax)) {
                    vo.setEquipmentPriceTax(null);
                } else {
                    try {
                        vo.setEquipmentPriceTax(new BigDecimal(equipmentPriceTax));
                    }
                    catch (Exception e) {
                        vo.setEquipmentPriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentMny)) {
                    vo.setEquipmentMny(null);
                } else {
                    try {
                        vo.setEquipmentMny(new BigDecimal(equipmentMny));
                    }
                    catch (Exception e) {
                        vo.setEquipmentMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentTaxMny)) {
                    vo.setEquipmentTaxMny(null);
                } else {
                    try {
                        vo.setEquipmentTaxMny(new BigDecimal(equipmentTaxMny));
                    }
                    catch (Exception e) {
                        vo.setEquipmentTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)equipmentTax)) {
                    vo.setEquipmentTax(null);
                } else {
                    try {
                        vo.setEquipmentTax(new BigDecimal(equipmentTax));
                    }
                    catch (Exception e) {
                        vo.setEquipmentTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildEquipmentVO> successList = new ArrayList<BuildEquipmentVO>();
            for (BuildEquipmentVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u673a\u68b0\u4f7f\u7528\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getEquipmentCode());
                errorVo.setName(vo.getEquipmentName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildEquipmentList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportSafe(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildSafeVO> detailVoList = new ArrayList<BuildSafeVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildSafeVO vo = new BuildSafeVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String safeCode = datas.get(1);
                String safeName = datas.get(3);
                String safeUnitName = datas.get(4);
                String safeNum = datas.get(5);
                String safeCostScale = datas.get(6);
                String safePrice = datas.get(7);
                String safeTaxPrice = datas.get(8);
                String safeRate = datas.get(9);
                String safePriceTax = datas.get(10);
                String safeMny = datas.get(11);
                String safeTaxMny = datas.get(13);
                String safeTax = datas.get(14);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)safeCode)) {
                    vo.setSafeCode(null);
                } else {
                    vo.setSafeCode(safeCode);
                }
                if (StringUtils.isEmpty((CharSequence)safeName)) {
                    vo.setSafeName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSafeName(safeName);
                }
                vo.setSafeUnitName(safeUnitName);
                if (StringUtils.isEmpty((CharSequence)safeNum)) {
                    vo.setSafeNum(null);
                } else {
                    try {
                        vo.setSafeNum(new BigDecimal(safeNum));
                    }
                    catch (Exception e) {
                        vo.setSafeNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeCostScale)) {
                    vo.setSafeCostScale(null);
                } else {
                    try {
                        vo.setSafeCostScale(new BigDecimal(safeCostScale));
                    }
                    catch (Exception e) {
                        vo.setSafeCostScale(null);
                        warnType = warnType + "[ \u644a\u9500\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safePrice)) {
                    vo.setSafePrice(null);
                } else {
                    try {
                        vo.setSafePrice(new BigDecimal(safePrice));
                    }
                    catch (Exception e) {
                        vo.setSafePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeTaxPrice)) {
                    vo.setSafeTaxPrice(null);
                } else {
                    try {
                        vo.setSafeTaxPrice(new BigDecimal(safeTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setSafeTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeRate)) {
                    vo.setSafeRate(null);
                } else {
                    try {
                        vo.setSafeRate(new BigDecimal(safeRate));
                    }
                    catch (Exception e) {
                        vo.setSafeRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safePriceTax)) {
                    vo.setSafePriceTax(null);
                } else {
                    try {
                        vo.setSafePriceTax(new BigDecimal(safePriceTax));
                    }
                    catch (Exception e) {
                        vo.setSafePriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeMny)) {
                    vo.setSafeMny(null);
                } else {
                    try {
                        vo.setSafeMny(new BigDecimal(safeMny));
                    }
                    catch (Exception e) {
                        vo.setSafeMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeTaxMny)) {
                    vo.setSafeTaxMny(null);
                } else {
                    try {
                        vo.setSafeTaxMny(new BigDecimal(safeTaxMny));
                    }
                    catch (Exception e) {
                        vo.setSafeTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)safeTax)) {
                    vo.setSafeTax(null);
                } else {
                    try {
                        vo.setSafeTax(new BigDecimal(safeTax));
                    }
                    catch (Exception e) {
                        vo.setSafeTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildSafeVO> successList = new ArrayList<BuildSafeVO>();
            for (BuildSafeVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getSafeCode());
                errorVo.setName(vo.getSafeName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildSafeList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportTemporary(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildTemporaryVO> detailVoList = new ArrayList<BuildTemporaryVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildTemporaryVO vo = new BuildTemporaryVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String temporaryCode = datas.get(1);
                String temporaryName = datas.get(3);
                String temporaryUnitName = datas.get(4);
                String temporaryNum = datas.get(5);
                String temporaryCostScale = datas.get(6);
                String temporaryPrice = datas.get(7);
                String temporaryTaxPrice = datas.get(8);
                String temporaryRate = datas.get(9);
                String temporaryPriceTax = datas.get(10);
                String temporaryMny = datas.get(11);
                String temporaryTaxMny = datas.get(13);
                String temporaryTax = datas.get(14);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)temporaryCode)) {
                    vo.setTemporaryCode(null);
                } else {
                    vo.setTemporaryCode(temporaryCode);
                }
                if (StringUtils.isEmpty((CharSequence)temporaryName)) {
                    vo.setTemporaryName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setTemporaryName(temporaryName);
                }
                vo.setTemporaryUnitName(temporaryUnitName);
                if (StringUtils.isEmpty((CharSequence)temporaryNum)) {
                    vo.setTemporaryNum(null);
                } else {
                    try {
                        vo.setTemporaryNum(new BigDecimal(temporaryNum));
                    }
                    catch (Exception e) {
                        vo.setTemporaryNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryCostScale)) {
                    vo.setTemporaryCostScale(null);
                } else {
                    try {
                        vo.setTemporaryCostScale(new BigDecimal(temporaryCostScale));
                    }
                    catch (Exception e) {
                        vo.setTemporaryCostScale(null);
                        warnType = warnType + "[ \u644a\u9500\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryPrice)) {
                    vo.setTemporaryPrice(null);
                } else {
                    try {
                        vo.setTemporaryPrice(new BigDecimal(temporaryPrice));
                    }
                    catch (Exception e) {
                        vo.setTemporaryPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryTaxPrice)) {
                    vo.setTemporaryTaxPrice(null);
                } else {
                    try {
                        vo.setTemporaryTaxPrice(new BigDecimal(temporaryTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setTemporaryTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryRate)) {
                    vo.setTemporaryRate(null);
                } else {
                    try {
                        vo.setTemporaryRate(new BigDecimal(temporaryRate));
                    }
                    catch (Exception e) {
                        vo.setTemporaryRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryPriceTax)) {
                    vo.setTemporaryPriceTax(null);
                } else {
                    try {
                        vo.setTemporaryPriceTax(new BigDecimal(temporaryPriceTax));
                    }
                    catch (Exception e) {
                        vo.setTemporaryPriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryMny)) {
                    vo.setTemporaryMny(null);
                } else {
                    try {
                        vo.setTemporaryMny(new BigDecimal(temporaryMny));
                    }
                    catch (Exception e) {
                        vo.setTemporaryMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryTaxMny)) {
                    vo.setTemporaryTaxMny(null);
                } else {
                    try {
                        vo.setTemporaryTaxMny(new BigDecimal(temporaryTaxMny));
                    }
                    catch (Exception e) {
                        vo.setTemporaryTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)temporaryTax)) {
                    vo.setTemporaryTax(null);
                } else {
                    try {
                        vo.setTemporaryTax(new BigDecimal(temporaryTax));
                    }
                    catch (Exception e) {
                        vo.setTemporaryTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildTemporaryVO> successList = new ArrayList<BuildTemporaryVO>();
            for (BuildTemporaryVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u4e34\u65f6\u8bbe\u65bd\u8d39\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getTemporaryCode());
                errorVo.setName(vo.getTemporaryName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildTemporaryList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportMeasure(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildMeasureVO> detailVoList = new ArrayList<BuildMeasureVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildMeasureVO vo = new BuildMeasureVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String measureCode = datas.get(1);
                String measureName = datas.get(3);
                String measureUnitName = datas.get(4);
                String measureNum = datas.get(5);
                String measureCostScale = datas.get(6);
                String measurePrice = datas.get(7);
                String measureTaxPrice = datas.get(8);
                String measureRate = datas.get(9);
                String measurePriceTax = datas.get(10);
                String measureMny = datas.get(11);
                String measureTaxMny = datas.get(13);
                String measureTax = datas.get(14);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)measureCode)) {
                    vo.setMeasureCode(null);
                } else {
                    vo.setMeasureCode(measureCode);
                }
                if (StringUtils.isEmpty((CharSequence)measureName)) {
                    vo.setMeasureName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMeasureName(measureName);
                }
                vo.setMeasureUnitName(measureUnitName);
                if (StringUtils.isEmpty((CharSequence)measureNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(measureNum));
                    }
                    catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureCostScale)) {
                    vo.setMeasureCostScale(null);
                } else {
                    try {
                        vo.setMeasureCostScale(new BigDecimal(measureCostScale));
                    }
                    catch (Exception e) {
                        vo.setMeasureCostScale(null);
                        warnType = warnType + "[ \u644a\u9500\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measurePrice)) {
                    vo.setMeasurePrice(null);
                } else {
                    try {
                        vo.setMeasurePrice(new BigDecimal(measurePrice));
                    }
                    catch (Exception e) {
                        vo.setMeasurePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureTaxPrice)) {
                    vo.setMeasureTaxPrice(null);
                } else {
                    try {
                        vo.setMeasureTaxPrice(new BigDecimal(measureTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasureTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureRate)) {
                    vo.setMeasureRate(null);
                } else {
                    try {
                        vo.setMeasureRate(new BigDecimal(measureRate));
                    }
                    catch (Exception e) {
                        vo.setMeasureRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measurePriceTax)) {
                    vo.setMeasurePriceTax(null);
                } else {
                    try {
                        vo.setMeasurePriceTax(new BigDecimal(measurePriceTax));
                    }
                    catch (Exception e) {
                        vo.setMeasurePriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureMny)) {
                    vo.setMeasureMny(null);
                } else {
                    try {
                        vo.setMeasureMny(new BigDecimal(measureMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureTaxMny)) {
                    vo.setMeasureTaxMny(null);
                } else {
                    try {
                        vo.setMeasureTaxMny(new BigDecimal(measureTaxMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)measureTax)) {
                    vo.setMeasureTax(null);
                } else {
                    try {
                        vo.setMeasureTax(new BigDecimal(measureTax));
                    }
                    catch (Exception e) {
                        vo.setMeasureTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildMeasureVO> successList = new ArrayList<BuildMeasureVO>();
            for (BuildMeasureVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5176\u4ed6\u63aa\u65bd\u8d39\u76ee\u6807\u6210\u672c\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getMeasureCode());
                errorVo.setName(vo.getMeasureName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildMeasureList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportManage(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildManageVO> detailVoList = new ArrayList<BuildManageVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildManageVO vo = new BuildManageVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String manageCode = datas.get(1);
                String manageName = datas.get(3);
                String manageUnitName = datas.get(4);
                String manageNum = datas.get(5);
                String manageDuration = datas.get(6);
                String manageCostScale = datas.get(7);
                String managePrice = datas.get(8);
                String manageTaxPrice = datas.get(9);
                String manageRate = datas.get(10);
                String managePriceTax = datas.get(11);
                String manageMny = datas.get(12);
                String manageTaxMny = datas.get(14);
                String manageTax = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)manageCode)) {
                    vo.setManageCode(null);
                } else {
                    vo.setManageCode(manageCode);
                }
                if (StringUtils.isEmpty((CharSequence)manageName)) {
                    vo.setManageName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setManageName(manageName);
                }
                vo.setManageUnitName(manageUnitName);
                if (StringUtils.isEmpty((CharSequence)manageNum)) {
                    vo.setManageNum(null);
                } else {
                    try {
                        vo.setManageNum(new BigDecimal(manageNum));
                    }
                    catch (Exception e) {
                        vo.setManageNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageDuration)) {
                    vo.setManageDuration(null);
                } else {
                    try {
                        vo.setManageDuration(new BigDecimal(manageDuration));
                    }
                    catch (Exception e) {
                        vo.setManageDuration(null);
                        warnType = warnType + "[\u5de5\u671f\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageCostScale)) {
                    vo.setManageCostScale(null);
                } else {
                    try {
                        vo.setManageCostScale(new BigDecimal(manageCostScale));
                    }
                    catch (Exception e) {
                        vo.setManageCostScale(null);
                        warnType = warnType + "[ \u644a\u9500\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)managePrice)) {
                    vo.setManagePrice(null);
                } else {
                    try {
                        vo.setManagePrice(new BigDecimal(managePrice));
                    }
                    catch (Exception e) {
                        vo.setManagePrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageTaxPrice)) {
                    vo.setManageTaxPrice(null);
                } else {
                    try {
                        vo.setManageTaxPrice(new BigDecimal(manageTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setManageTaxPrice(null);
                        warnType = warnType + "[\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageRate)) {
                    vo.setManageRate(null);
                } else {
                    try {
                        vo.setManageRate(new BigDecimal(manageRate));
                    }
                    catch (Exception e) {
                        vo.setManageRate(null);
                        warnType = warnType + "[\u589e\u503c\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)managePriceTax)) {
                    vo.setManagePriceTax(null);
                } else {
                    try {
                        vo.setManagePriceTax(new BigDecimal(managePriceTax));
                    }
                    catch (Exception e) {
                        vo.setManagePriceTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageMny)) {
                    vo.setManageMny(null);
                } else {
                    try {
                        vo.setManageMny(new BigDecimal(manageMny));
                    }
                    catch (Exception e) {
                        vo.setManageMny(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageTaxMny)) {
                    vo.setManageTaxMny(null);
                } else {
                    try {
                        vo.setManageTaxMny(new BigDecimal(manageTaxMny));
                    }
                    catch (Exception e) {
                        vo.setManageTaxMny(null);
                        warnType = warnType + "[\u542b\u7a0e\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)manageTax)) {
                    vo.setManageTax(null);
                } else {
                    try {
                        vo.setManageTax(new BigDecimal(manageTax));
                    }
                    catch (Exception e) {
                        vo.setManageTax(null);
                        warnType = warnType + "[\u7a0e\u91d1\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildManageVO> successList = new ArrayList<BuildManageVO>();
            for (BuildManageVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u73b0\u573a\u7ba1\u7406\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getManageCode());
                errorVo.setName(vo.getManageName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildManageList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportFees(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildFeesVO> detailVoList = new ArrayList<BuildFeesVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildFeesVO vo = new BuildFeesVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String feesCode = datas.get(1);
                String feesName = datas.get(3);
                String feesUnitName = datas.get(4);
                String feesNum = datas.get(5);
                String feesPrice = datas.get(6);
                String feesMny = datas.get(8);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)feesCode)) {
                    vo.setFeesCode(null);
                } else {
                    vo.setFeesCode(feesCode);
                }
                if (StringUtils.isEmpty((CharSequence)feesName)) {
                    vo.setFeesName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setFeesName(feesName);
                }
                vo.setFeesUnitName(feesUnitName);
                if (StringUtils.isEmpty((CharSequence)feesNum)) {
                    vo.setFeesNum(null);
                } else {
                    try {
                        vo.setFeesNum(new BigDecimal(feesNum));
                    }
                    catch (Exception e) {
                        vo.setFeesNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)feesPrice)) {
                    vo.setFeesPrice(null);
                } else {
                    try {
                        vo.setFeesPrice(new BigDecimal(feesPrice));
                    }
                    catch (Exception e) {
                        vo.setFeesPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)feesMny)) {
                    vo.setFeesMny(null);
                } else {
                    try {
                        vo.setFeesMny(new BigDecimal(feesMny));
                    }
                    catch (Exception e) {
                        vo.setFeesMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildFeesVO> successList = new ArrayList<BuildFeesVO>();
            for (BuildFeesVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u89c4\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getFeesCode());
                errorVo.setName(vo.getFeesName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildFeesList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportOther(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BuildOtherVO> detailVoList = new ArrayList<BuildOtherVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size() - 2; ++i) {
                List<String> datas = result.get(i);
                BuildOtherVO vo = new BuildOtherVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String otherCode = datas.get(1);
                String otherName = datas.get(3);
                String otherUnitName = datas.get(4);
                String otherNum = datas.get(5);
                String otherPrice = datas.get(6);
                String otherMny = datas.get(8);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)otherCode)) {
                    vo.setOtherCode(null);
                } else {
                    vo.setOtherCode(otherCode);
                }
                if (StringUtils.isEmpty((CharSequence)otherName)) {
                    vo.setOtherName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setOtherName(otherName);
                }
                vo.setOtherUnitName(otherUnitName);
                if (StringUtils.isEmpty((CharSequence)otherNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(otherNum));
                    }
                    catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)otherPrice)) {
                    vo.setOtherPrice(null);
                } else {
                    try {
                        vo.setOtherPrice(new BigDecimal(otherPrice));
                    }
                    catch (Exception e) {
                        vo.setOtherPrice(null);
                        warnType = warnType + "[\u4e0d\u542b\u7a0e\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)otherMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(otherMny));
                    }
                    catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BuildOtherVO> successList = new ArrayList<BuildOtherVO>();
            for (BuildOtherVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5176\u5b83\u8d39\u76ee\u6807\u6210\u672c\u63a7\u5236\u8ba1\u5212\u8868");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getOtherCode());
                errorVo.setName(vo.getOtherName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setBuildOtherList(successList);
        }
        return res;
    }

    public void updateByPid(BuildDutyEntity entity) {
        HashMap<Long, Long> rgcostMap = new HashMap<Long, Long>();
        List<BuildRgcostEntity> rgcostEntities = entity.getBuildRgcostList();
        if (CollectionUtils.isNotEmpty(rgcostEntities)) {
            for (BuildRgcostEntity twoEntity : rgcostEntities) {
                rgcostMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildRgcostEntity cdEntity : rgcostEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)rgcostMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildRgcostService.saveOrUpdateBatch(rgcostEntities, rgcostEntities.size(), false);
        }
        HashMap<Long, Long> subMap = new HashMap<Long, Long>();
        List<BuildSubEntity> dutySubEntities = entity.getBuildSubList();
        if (CollectionUtils.isNotEmpty(dutySubEntities)) {
            for (BuildSubEntity rmatEntity : dutySubEntities) {
                subMap.put(rmatEntity.getTid(), rmatEntity.getId());
            }
            for (BuildSubEntity cdEntity : dutySubEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)subMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildSubService.saveOrUpdateBatch(dutySubEntities, dutySubEntities.size(), false);
        }
        HashMap<Long, Long> materialMap = new HashMap<Long, Long>();
        List<BuildMaterialEntity> materialEntities = entity.getBuildMaterialList();
        if (CollectionUtils.isNotEmpty(materialEntities)) {
            for (BuildMaterialEntity twoEntity : materialEntities) {
                materialMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildMaterialEntity cdEntity : materialEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)materialMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildMaterialService.saveOrUpdateBatch(materialEntities, materialEntities.size(), false);
        }
        HashMap<Long, Long> rmatMap = new HashMap<Long, Long>();
        List<BuildRmatEntity> rmatEntities = entity.getBuildRmatList();
        if (CollectionUtils.isNotEmpty(rmatEntities)) {
            for (BuildRmatEntity twoEntity : rmatEntities) {
                rmatMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildRmatEntity cdEntity : rmatEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)rmatMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildRmatService.saveOrUpdateBatch(rmatEntities, rmatEntities.size(), false);
        }
        HashMap<Long, Long> equipmentMap = new HashMap<Long, Long>();
        List<BuildEquipmentEntity> equipmentEntities = entity.getBuildEquipmentList();
        if (CollectionUtils.isNotEmpty(equipmentEntities)) {
            for (BuildEquipmentEntity twoEntity : equipmentEntities) {
                equipmentMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildEquipmentEntity cdEntity : equipmentEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)equipmentMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildEquipmentService.saveOrUpdateBatch(equipmentEntities, equipmentEntities.size(), false);
        }
        HashMap<Long, Long> safeMap = new HashMap<Long, Long>();
        List<BuildSafeEntity> safeEntities = entity.getBuildSafeList();
        if (CollectionUtils.isNotEmpty(safeEntities)) {
            for (BuildSafeEntity twoEntity : safeEntities) {
                safeMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildSafeEntity cdEntity : safeEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)safeMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildSafeService.saveOrUpdateBatch(safeEntities, safeEntities.size(), false);
        }
        HashMap<Long, Long> temporaryMap = new HashMap<Long, Long>();
        List<BuildTemporaryEntity> temporaryEntities = entity.getBuildTemporaryList();
        if (CollectionUtils.isNotEmpty(temporaryEntities)) {
            for (BuildTemporaryEntity twoEntity : temporaryEntities) {
                temporaryMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildTemporaryEntity cdEntity : temporaryEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)temporaryMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildTemporaryService.saveOrUpdateBatch(temporaryEntities, temporaryEntities.size(), false);
        }
        HashMap<Long, Long> measureMap = new HashMap<Long, Long>();
        List<BuildMeasureEntity> measureEntities = entity.getBuildMeasureList();
        if (CollectionUtils.isNotEmpty(measureEntities)) {
            for (BuildMeasureEntity twoEntity : measureEntities) {
                measureMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildMeasureEntity cdEntity : measureEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)measureMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildMeasureService.saveOrUpdateBatch(measureEntities, measureEntities.size(), false);
        }
        HashMap<Long, Long> manageMap = new HashMap<Long, Long>();
        List<BuildManageEntity> manageEntities = entity.getBuildManageList();
        if (CollectionUtils.isNotEmpty(manageEntities)) {
            for (BuildManageEntity twoEntity : manageEntities) {
                manageMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildManageEntity cdEntity : manageEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)manageMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildManageService.saveOrUpdateBatch(manageEntities, manageEntities.size(), false);
        }
        HashMap<Long, Long> feesMap = new HashMap<Long, Long>();
        List<BuildFeesEntity> feesEntities = entity.getBuildFeesList();
        if (CollectionUtils.isNotEmpty(feesEntities)) {
            for (BuildFeesEntity twoEntity : feesEntities) {
                feesMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildFeesEntity cdEntity : feesEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)feesMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildFeesService.saveOrUpdateBatch(feesEntities, feesEntities.size(), false);
        }
        HashMap<Long, Long> otherMap = new HashMap<Long, Long>();
        List<BuildOtherEntity> otherEntities = entity.getBuildOtherList();
        if (CollectionUtils.isNotEmpty(otherEntities)) {
            for (BuildOtherEntity twoEntity : otherEntities) {
                otherMap.put(twoEntity.getTid(), twoEntity.getId());
            }
            for (BuildOtherEntity cdEntity : otherEntities) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)otherMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.buildOtherService.saveOrUpdateBatch(otherEntities, otherEntities.size(), false);
        }
    }

    public List<BuildPlansEntity> SumPlanDetail(BuildDutyVO vo) {
        BigDecimal plansMny;
        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList();
        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();
        List<BuildSubVO> buildSubList = vo.getBuildSubList();
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList();
        List<BuildRmatVO> buildRmatList = vo.getBuildRmatList();
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList();
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList();
        List<BuildTemporaryVO> buildTemporaryList = vo.getBuildTemporaryList();
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList();
        List<BuildManageVO> buildManageList = vo.getBuildManageList();
        List<BuildFeesVO> buildFeesList = vo.getBuildFeesList();
        List<BuildOtherVO> buildOtherList = vo.getBuildOtherList();
        ArrayList<BuildPlansEntity> dutyPlansEntityList = new ArrayList<BuildPlansEntity>();
        BigDecimal sumPlansMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        BigDecimal sumPlansMny2 = BigDecimal.ZERO;
        for (int i = 0; i < buildPlansList.size(); ++i) {
            BigDecimal plansYsMny;
            BigDecimal priceTax;
            BuildPlansEntity buildPlansEntity = (BuildPlansEntity)((Object)BeanMapper.map((Object)((Object)buildPlansList.get(i)), BuildPlansEntity.class));
            buildPlansEntity.setId(null);
            if (i == 0) {
                plansMny = buildRgcostList.stream().filter(item -> null == item.getParentId() && null != item.getRgcostMny()).map(BuildRgcostVO::getRgcostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildRgcostList.stream().filter(item -> null == item.getParentId() && null != item.getRgcostTax()).map(BuildRgcostVO::getRgcostTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 1) {
                plansMny = buildSubList.stream().filter(item -> null == item.getParentId() && null != item.getSubMny()).map(BuildSubVO::getSubMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildSubList.stream().filter(item -> null == item.getParentId() && null != item.getSubTax()).map(BuildSubVO::getSubTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 2) {
                plansMny = buildMaterialList.stream().filter(item -> null == item.getParentId() && null != item.getMaterialMny()).map(BuildMaterialVO::getMaterialMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildMaterialList.stream().filter(item -> null == item.getParentId() && null != item.getMaterialTax()).map(BuildMaterialVO::getMaterialTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 3) {
                plansMny = buildRmatList.stream().filter(item -> null == item.getParentId() && null != item.getRmatMny()).map(BuildRmatVO::getRmatMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildRmatList.stream().filter(item -> null == item.getParentId() && null != item.getRmatTax()).map(BuildRmatVO::getRmatTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 4) {
                plansMny = buildEquipmentList.stream().filter(item -> null == item.getParentId() && null != item.getEquipmentMny()).map(BuildEquipmentVO::getEquipmentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildEquipmentList.stream().filter(item -> null == item.getParentId() && null != item.getEquipmentTax()).map(BuildEquipmentVO::getEquipmentTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 5) {
                plansMny = buildSafeList.stream().filter(item -> null == item.getParentId() && null != item.getSafeMny()).map(BuildSafeVO::getSafeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildSafeList.stream().filter(item -> null == item.getParentId() && null != item.getSafeTax()).map(BuildSafeVO::getSafeTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 6) {
                plansMny = buildTemporaryList.stream().filter(item -> null == item.getParentId() && null != item.getTemporaryMny()).map(BuildTemporaryVO::getTemporaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildTemporaryList.stream().filter(item -> null == item.getParentId() && null != item.getTemporaryTax()).map(BuildTemporaryVO::getTemporaryTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 7) {
                plansMny = buildMeasureList.stream().filter(item -> null == item.getParentId() && null != item.getMeasureMny()).map(BuildMeasureVO::getMeasureMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildMeasureList.stream().filter(item -> null == item.getParentId() && null != item.getMeasureTax()).map(BuildMeasureVO::getMeasureTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 8) {
                plansMny = buildFeesList.stream().filter(item -> null == item.getParentId() && null != item.getFeesMny()).map(BuildFeesVO::getFeesMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
            } else if (i == 9) {
                plansMny = buildManageList.stream().filter(item -> null == item.getParentId() && null != item.getManageMny()).map(BuildManageVO::getManageMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                priceTax = buildManageList.stream().filter(item -> null == item.getParentId() && null != item.getManageTax()).map(BuildManageVO::getManageTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            } else if (i == 11) {
                plansMny = buildOtherList.stream().filter(item -> null == item.getParentId() && null != item.getOtherMny()).map(BuildOtherVO::getOtherMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
            } else if (i == 13) {
                buildPlansEntity.setPlansMny(sumPlansMny);
            } else if (i == 18) {
                buildPlansEntity.setPlansMny(sumPlansMny2);
            } else if (i == 15) {
                buildPlansEntity.setPlansMny(sumTaxMny);
            }
            if (i < 13) {
                sumPlansMny = sumPlansMny.add(buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny());
            } else if (i > 12 && i < 18) {
                sumPlansMny2 = sumPlansMny2.add(buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny());
            }
            BigDecimal bigDecimal = plansYsMny = buildPlansEntity.getPlansYsMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansYsMny();
            if (null != buildPlansEntity.getPlansMny()) {
                buildPlansEntity.setPlansJcMny(plansYsMny.subtract(buildPlansEntity.getPlansMny()));
                if (BigDecimal.ZERO.compareTo(plansYsMny) != 0) {
                    buildPlansEntity.setPlansJcRate(plansYsMny.subtract(buildPlansEntity.getPlansMny()).multiply(new BigDecimal(100)).divide(plansYsMny, 2, 5));
                }
            }
            dutyPlansEntityList.add(buildPlansEntity);
        }
        if (CollectionUtils.isNotEmpty(dutyPlansEntityList)) {
            for (BuildPlansEntity buildPlansEntity : dutyPlansEntityList) {
                if (BigDecimal.ZERO.compareTo(sumPlansMny2) != 0) {
                    plansMny = buildPlansEntity.getPlansMny() == null ? BigDecimal.ZERO : buildPlansEntity.getPlansMny();
                    buildPlansEntity.setPlansRate(plansMny.multiply(new BigDecimal(100)).divide(sumPlansMny2, 2, 5));
                    continue;
                }
                buildPlansEntity.setPlansRate(BigDecimal.ZERO);
            }
        }
        return dutyPlansEntityList;
    }
}

