/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.build.bean.BuildDutyEntity;
import com.ejianc.business.build.service.IBuildDutyService;
import com.ejianc.business.pro.income.api.IProincomeBudgetApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.roadbridge.bean.RoadbridgeDutyEntity;
import com.ejianc.business.roadbridge.service.IRoadbridgeDutyService;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.handler.ConversionManageFactory;
import com.ejianc.business.targetcost.handler.IConversioneHandler;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.targetcost.vo.DutyDetailVO;
import com.ejianc.business.targetcost.vo.DutyVO;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dutyService")
public class DutyServiceImpl
extends BaseServiceImpl<DutyMapper, DutyEntity>
implements IDutyService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDutyService service;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IFeeService feeService;
    @Autowired
    private DutyMapper dutyMapper;
    private static final String BILL_CODE = "TC_DUTY";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;
    @Autowired
    private IProincomeBudgetApi proincomeBudgetApi;
    @Autowired
    private ConversionManageFactory conversionManageFactory;
    @Autowired
    private IRoadbridgeDutyService roadbridgeDutyService;
    @Autowired
    private IBuildDutyService buildDutyService;
    private static final String CHECK_PARAM_BUDGET = "P-t576D10185";
    private static final String CHECK_PARAM_CODE = "P-839rOq97";
    private static final String CHECK_PARAM_CODE_P = "P-zk210W98";
    private static final String CHECK_PARAM_CODE_R = "P-14n3tA0128";
    private static final String CHECK_PARAM_CODE_WZ = "P-DZ2h4i0129";
    private static final String CHECK_PARAM_CODE_LW = "P-1319270130";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<DutyVO> saveOrUpdate(DutyVO dutyVO) {
        DutyEntity entity = (DutyEntity)((Object)BeanMapper.map((Object)dutyVO, DutyEntity.class));
        if (entity.getDutyVersion() == null) {
            entity.setDutyVersion(1);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            if (entity.getLastDutyId() != null && null != entity.getFirstImportId()) {
                this.checkExitsImportChange(entity);
            }
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            entity.setGatherFlag(false);
            entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)dutyVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<DutyDetailEntity> dutyDetailEntities = entity.getDutyDetailList();
        for (Object dutyDetailEntity : dutyDetailEntities) {
            if (null == dutyDetailEntity.getGatherTaxMny() || !ComputeUtil.equals((BigDecimal)dutyDetailEntity.getTaxMny(), (BigDecimal)dutyDetailEntity.getGatherTaxMny()) || ComputeUtil.equals((BigDecimal)dutyDetailEntity.getMny(), (BigDecimal)dutyDetailEntity.getGatherMny())) continue;
            this.logger.error("\u660e\u7ec6\u3010" + dutyDetailEntity.getFeeDetailName() + "\u3011\u7684\u91d1\u989d\u4e0e\u53f3\u4fa7\u6c47\u603b\u91d1\u989d\u4e0d\u7b49\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getDutyVersion() == 1) {
            entity.setFirstDutyId(entity.getId());
            entity.setShowFlag(true);
            entity.setOneTime(entity.getCreateTime());
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            map.put(dutyDetailEntity.getTid(), dutyDetailEntity.getId());
        }
        int totalNum = 0;
        int completNum = 0;
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            if (dutyDetailEntity.getInvolveFlag().booleanValue() && dutyDetailEntity.getLeafFlag().booleanValue()) {
                ++totalNum;
                if (!ComputeUtil.isEmpty((BigDecimal)dutyDetailEntity.getGatherMny()).booleanValue() && ComputeUtil.equals((BigDecimal)dutyDetailEntity.getMny(), (BigDecimal)dutyDetailEntity.getGatherMny()) && ComputeUtil.equals((BigDecimal)dutyDetailEntity.getTaxMny(), (BigDecimal)dutyDetailEntity.getGatherTaxMny())) {
                    ++completNum;
                }
            }
            if (!DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(dutyDetailEntity.getDocType()) || !dutyDetailEntity.getLeafFlag().booleanValue()) {
                dutyDetailEntity.setPreTypeAmount(null);
            }
            dutyDetailEntity.setOrgId(entity.getOrgId());
            dutyDetailEntity.setOrgName(entity.getOrgName());
            dutyDetailEntity.setProjectId(entity.getProjectId());
            dutyDetailEntity.setProjectName(entity.getProjectName());
            dutyDetailEntity.setParentId((Long)map.get(dutyDetailEntity.getTpid()));
        }
        entity.setCompleteScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)BigDecimal.valueOf(completNum), (BigDecimal)BigDecimal.valueOf(totalNum)), (BigDecimal)BigDecimal.valueOf(100L)));
        for (DutyDetailEntity dutyDetailEntity : entity.getDutyDetailList()) {
            if (!(ComputeUtil.equals((BigDecimal)dutyDetailEntity.getMny(), (BigDecimal)dutyDetailEntity.getBeforeMny()) && ComputeUtil.equals((BigDecimal)dutyDetailEntity.getTaxMny(), (BigDecimal)dutyDetailEntity.getBeforeTaxMny()) && ComputeUtil.equals((BigDecimal)dutyDetailEntity.getTaxRate(), (BigDecimal)dutyDetailEntity.getBeforeTaxRate()))) {
                dutyDetailEntity.setChangeFlag(1);
                continue;
            }
            dutyDetailEntity.setChangeFlag(0);
        }
        BigDecimal amount = BigDecimal.ZERO;
        int b = 0;
        for (int m = 0; m < entity.getDutyDetailList().size(); ++m) {
            for (int n = 0; n < entity.getDutyDetailList().get(m).getDutyDetailItemList().size(); ++n) {
                if (m != b) {
                    amount = BigDecimal.ZERO;
                    b = m;
                }
                if (entity.getDutyDetailList().get(m).getDutyDetailItemList().get(n).getAmount() == null) {
                    entity.getDutyDetailList().get(m).getDutyDetailItemList().get(n).setAmount(BigDecimal.ZERO);
                }
                amount = amount.add(entity.getDutyDetailList().get(m).getDutyDetailItemList().get(n).getAmount());
                entity.getDutyDetailList().get(m).setTotalAmount(amount);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        for (DutyDetailEntity dutyDetailEntity : entity.getDutyDetailList()) {
            List<DutyDetailItemEntity> dutyDetailItemList = dutyDetailEntity.getDutyDetailItemList();
            if (!CollectionUtils.isNotEmpty(dutyDetailItemList)) continue;
            ArrayList<DutyDetailItemEntity> insertList = new ArrayList<DutyDetailItemEntity>();
            ArrayList<Long> delPkList = new ArrayList<Long>();
            for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemList) {
                if ("del".equals(dutyDetailItemEntity.getRowState())) {
                    delPkList.add(dutyDetailItemEntity.getId());
                    continue;
                }
                dutyDetailItemEntity.setOrgId(entity.getOrgId());
                dutyDetailItemEntity.setOrgName(entity.getOrgName());
                dutyDetailItemEntity.setProjectId(entity.getProjectId());
                dutyDetailItemEntity.setProjectName(entity.getProjectName());
                dutyDetailItemEntity.setFeeDetailId(dutyDetailEntity.getFeeDetailId());
                dutyDetailItemEntity.setFeeDetailCode(dutyDetailEntity.getFeeDetailCode());
                dutyDetailItemEntity.setFeeDetailName(dutyDetailEntity.getFeeDetailName());
                dutyDetailItemEntity.setCategoryId(dutyDetailItemEntity.getCategoryId());
                dutyDetailItemEntity.setCategoryName(dutyDetailItemEntity.getCategoryName());
                dutyDetailItemEntity.setCategoryInnerCode(dutyDetailEntity.getCategoryInnerCode());
                dutyDetailItemEntity.setDocType(dutyDetailEntity.getDocType());
                dutyDetailItemEntity.setDutyId(dutyDetailEntity.getDutyId());
                dutyDetailItemEntity.setDutyDetailId(dutyDetailEntity.getId());
                insertList.add(dutyDetailItemEntity);
            }
            for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailEntity.getDutyDetailItemList()) {
                if (!(ComputeUtil.equals((BigDecimal)dutyDetailItemEntity.getMny(), (BigDecimal)dutyDetailItemEntity.getBeforeMny()) && ComputeUtil.equals((BigDecimal)dutyDetailItemEntity.getTaxMny(), (BigDecimal)dutyDetailItemEntity.getBeforeTaxMny()) && ComputeUtil.equals((BigDecimal)dutyDetailItemEntity.getPrice(), (BigDecimal)dutyDetailItemEntity.getBeforePrice()) && ComputeUtil.equals((BigDecimal)dutyDetailItemEntity.getTaxPrice(), (BigDecimal)dutyDetailItemEntity.getBeforeTaxPrice()) && ComputeUtil.equals((BigDecimal)dutyDetailItemEntity.getTaxRate(), (BigDecimal)dutyDetailItemEntity.getBeforeTaxRate()) && ComputeUtil.equals((BigDecimal)dutyDetailItemEntity.getAmount(), (BigDecimal)dutyDetailItemEntity.getBeforeAmount()))) {
                    dutyDetailItemEntity.setChangeFlag(1);
                    continue;
                }
                dutyDetailItemEntity.setChangeFlag(0);
            }
            if (CollectionUtil.isNotEmpty(insertList)) {
                this.dutyDetailItemService.saveOrUpdateBatch(dutyDetailEntity.getDutyDetailItemList());
                this.dutyDetailService.saveOrUpdate((Object)dutyDetailEntity);
            }
            if (!CollectionUtil.isNotEmpty(delPkList)) continue;
            this.dutyDetailItemService.removeByIds(delPkList);
        }
        DutyVO vo = (DutyVO)BeanMapper.map((Object)((Object)entity), DutyVO.class);
        List<DutyDetailVO> dutyDetailVOList = vo.getDutyDetailList();
        vo.setDutyDetailList(TreeNodeBUtil.buildTree(dutyDetailVOList));
        if (entity.getLastDutyId() != null) {
            DutyEntity revise = (DutyEntity)((Object)this.service.getById(entity.getLastDutyId()));
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            this.service.saveOrUpdate((Object)revise);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(vo.getId(), true));
    }

    private void checkExits(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, (Object)projectId);
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff01");
        }
    }

    private void checkExitsImportChange(DutyEntity dutyEntity) {
        if (ConversionEnum.\u4e91\u5357\u8def\u6865.getCode().equals(dutyEntity.getImportType())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(RoadbridgeDutyEntity::getBaseDutyId, (Object)dutyEntity.getFirstImportId());
            queryWrapper.isNotNull(RoadbridgeDutyEntity::getLastDutyId);
            queryWrapper.notIn(RoadbridgeDutyEntity::getBillState, new Object[]{"1,3"});
            if (this.roadbridgeDutyService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u5b58\u5728\u53d8\u66f4\u4e2d\u7684\u3010\u8def\u6865\u76ee\u6807\u6210\u672c\u5bfc\u5165\u3011\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u53d8\u66f4\uff01");
            }
        } else if (ConversionEnum.\u4e91\u5357\u623f\u5efa.getCode().equals(dutyEntity.getImportType())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BuildDutyEntity::getBaseDutyId, (Object)dutyEntity.getFirstImportId());
            wrapper.isNotNull(BuildDutyEntity::getLastDutyId);
            wrapper.notIn(BuildDutyEntity::getBillState, new Object[]{"1,3"});
            if (this.buildDutyService.count((Wrapper)wrapper) > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u5b58\u5728\u53d8\u66f4\u4e2d\u7684\u3010\u623f\u5efa\u76ee\u6807\u6210\u672c\u5bfc\u5165\u3011\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u53d8\u66f4\uff01");
            }
        }
    }

    @Override
    public DutyVO queryDetail(Long id, boolean hasChildren) {
        DutyEntity entity = (DutyEntity)((Object)this.selectById(id));
        if (null == entity) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getImportId, (Object)id);
            DutyEntity tmpEntity = (DutyEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
            entity = (DutyEntity)((Object)this.selectById(tmpEntity.getId()));
        }
        FeeVO feeVO = this.feeService.queryDetail(entity.getFeeId(), false);
        HashMap<Long, List<FeeDetailVO>> map = new HashMap<Long, List<FeeDetailVO>>();
        if (CollectionUtils.isNotEmpty(feeVO.getFeeDetailList())) {
            for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getSelfRelatedFlag().booleanValue()) continue;
                map.put(feeDetailVO.getId(), feeDetailVO.getRelatedList());
            }
        }
        List<DutyDetailEntity> dutyDetailEntityList = entity.getDutyDetailList();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntityList) {
            dutyDetailEntity.setTid(dutyDetailEntity.getId().toString());
            dutyDetailEntity.setTpid(dutyDetailEntity.getParentId() != null && dutyDetailEntity.getParentId() > 0L ? dutyDetailEntity.getParentId().toString() : "");
            List<DutyDetailItemEntity> dutyDetailScopeEntityList = this.dutyDetailItemService.findByDutyDetailId(dutyDetailEntity.getId());
            dutyDetailEntity.setDutyDetailItemList(dutyDetailScopeEntityList);
            if (!map.containsKey(dutyDetailEntity.getFeeDetailId())) continue;
            dutyDetailEntity.setRelatedDetailList((List)map.get(dutyDetailEntity.getFeeDetailId()));
        }
        Collections.sort(dutyDetailEntityList, new DutyDetailCompareEntity());
        entity.setDutyDetailList(dutyDetailEntityList);
        DutyVO dutyVO = (DutyVO)BeanMapper.map((Object)((Object)entity), DutyVO.class);
        if (hasChildren) {
            dutyVO.setDutyDetailList(TreeNodeBUtil.buildTree(dutyVO.getDutyDetailList()));
        }
        return dutyVO;
    }

    @Override
    public DutyVO queryReviseDetail(Long id) {
        DutyVO vo = this.queryDetail(id, false);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        vo.setLastDutyId(id);
        vo.setImportId(null);
        vo.setShowFlag(true);
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setMny(null);
        vo.setTaxMny(null);
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);
        List<DutyDetailVO> changeDetailList = vo.getDutyDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            HashMap idMap = new HashMap();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setBeforeGatherMny(changeDetailVO.getGatherMny());
                changeDetailVO.setBeforeGatherTaxRate(changeDetailVO.getBeforeGatherTaxRate());
                changeDetailVO.setBeforeTaxRate(changeDetailVO.getTaxRate());
                changeDetailVO.setBeforeMny(changeDetailVO.getMny());
                changeDetailVO.setBeforeTaxMny(changeDetailVO.getTaxMny());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
                List<DutyDetailItemVO> dutyDetailItemList = changeDetailVO.getDutyDetailItemList();
                if (CollectionUtils.isNotEmpty(dutyDetailItemList)) {
                    for (DutyDetailItemVO itemVO : dutyDetailItemList) {
                        itemVO.setId(IdWorker.getId());
                        itemVO.setCreateTime(null);
                        itemVO.setCreateUserCode(null);
                        itemVO.setUpdateTime(null);
                        itemVO.setUpdateUserCode(null);
                        itemVO.setDutyDetailId(changeDetailVO.getId());
                        itemVO.setBeforeAmount(itemVO.getAmount());
                        itemVO.setBeforeTaxRate(itemVO.getTaxRate());
                        itemVO.setBeforePrice(itemVO.getPrice());
                        itemVO.setBeforeTaxPrice(itemVO.getTaxPrice());
                        itemVO.setBeforeMny(itemVO.getMny());
                        itemVO.setBeforeTaxMny(itemVO.getTaxMny());
                    }
                }
            });
            for (DutyDetailVO cdEntity : changeDetailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
        vo.setDutyDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(DutyVO dutyVO) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckVO> checkDsVOS = new ArrayList<ParamsCheckVO>();
        CommonResponse commonResponse = this.proincomeContractApi.queryContranct(dutyVO.getProjectId());
        BigDecimal incomeMny = commonResponse.isSuccess() ? (BigDecimal)commonResponse.getData() : null;
        checkDsVOS.addAll(this.service.checkParamCode(dutyVO, incomeMny));
        checkDsVOS.addAll(this.checkParamBudgetMny(dutyVO, (BigDecimal)this.proincomeBudgetApi.queryAllBudgetMny(dutyVO.getProjectId()).getData()));
        checkDsVOS.addAll(this.service.checkParamCodeP(dutyVO, incomeMny));
        checkDsVOS.addAll(this.service.checkParamCodeR(dutyVO, incomeMny));
        checkDsVOS.addAll(this.service.checkWZ(dutyVO));
        checkDsVOS.addAll(this.service.checkLW(dutyVO));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(checkDsVOS)) {
            for (ParamsCheckVO checkVO : checkDsVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVO = (List)map.get(warnType);
                    checkDsVO.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVO);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ExecutionLinkVO> linkFeeScale(Long projectId, Long id) {
        ArrayList<ExecutionLinkVO> linkVOS = new ArrayList<ExecutionLinkVO>();
        CommonResponse commonResponse = this.proincomeContractApi.queryContranct(projectId);
        BigDecimal incomeMny = commonResponse.isSuccess() ? (BigDecimal)commonResponse.getData() : null;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        List<DutyDetailEntity> listDetail = this.dutyDetailService.findByDutyId(((DutyEntity)((Object)list.get(0))).getId());
        BigDecimal totalMny = BigDecimal.ZERO;
        for (DutyDetailEntity dutyDetailEntity : listDetail) {
            if (null != dutyDetailEntity.getParentId()) continue;
            ExecutionLinkVO linkVO = (ExecutionLinkVO)((Object)BeanMapper.map((Object)((Object)dutyDetailEntity), ExecutionLinkVO.class));
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)linkVO.getTaxMny());
            linkVO.setFeeDetailCode(dutyDetailEntity.getFeeDetailCode());
            linkVO.setName(dutyDetailEntity.getFeeDetailName());
            linkVO.setIncomeMny(incomeMny);
            linkVO.setContMnyScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)linkVO.getTaxMny(), (BigDecimal)incomeMny)));
            linkVOS.add(linkVO);
        }
        if (CollectionUtils.isNotEmpty(linkVOS)) {
            for (ExecutionLinkVO linkVO : linkVOS) {
                linkVO.setMnyScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)linkVO.getTaxMny(), (BigDecimal)totalMny)));
            }
        }
        if (linkVOS.size() >= 7) {
            int i;
            BigDecimal sumDirectMny = new BigDecimal(0);
            BigDecimal sumDirecttaxMny = new BigDecimal(0);
            BigDecimal sumDirectMnyScale = new BigDecimal(0);
            BigDecimal sumDirectContMnyScale = new BigDecimal(0);
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (!linkVO.getFeeDetailCode().equals("01") && !linkVO.getFeeDetailCode().equals("02") && !linkVO.getFeeDetailCode().equals("03") && !linkVO.getFeeDetailCode().equals("04") && !linkVO.getFeeDetailCode().equals("05") || linkVO.getMny() == null) continue;
                sumDirectMny = sumDirectMny.add(linkVO.getMny());
                if (linkVO.getTaxMny() == null) continue;
                sumDirecttaxMny = sumDirecttaxMny.add(linkVO.getTaxMny());
            }
            sumDirectMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumDirecttaxMny, (BigDecimal)totalMny));
            sumDirectContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumDirecttaxMny, (BigDecimal)incomeMny));
            ExecutionLinkVO executionLinkVO = new ExecutionLinkVO();
            executionLinkVO.setId(Long.parseLong("99999"));
            executionLinkVO.setName("\u5c0f\u8ba1(\u76f4\u63a5\u8d39)");
            executionLinkVO.setMny(sumDirectMny);
            executionLinkVO.setTaxMny(sumDirecttaxMny);
            executionLinkVO.setMnyScale(sumDirectMnyScale);
            executionLinkVO.setContMnyScale(sumDirectContMnyScale);
            BigDecimal sumIndirectMny = new BigDecimal(0);
            BigDecimal sumIndirecttaxMny = new BigDecimal(0);
            BigDecimal sumIndirectMnyScale = new BigDecimal(0);
            BigDecimal sumIndirectContMnyScale = new BigDecimal(0);
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (!linkVO.getFeeDetailCode().equals("06") && !linkVO.getFeeDetailCode().equals("07") || linkVO.getMny() == null) continue;
                sumIndirectMny = sumIndirectMny.add(linkVO.getMny());
                if (linkVO.getTaxMny() == null) continue;
                sumIndirecttaxMny = sumIndirecttaxMny.add(linkVO.getTaxMny());
            }
            sumIndirectMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumIndirecttaxMny, (BigDecimal)totalMny));
            sumIndirectContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumIndirecttaxMny, (BigDecimal)incomeMny));
            ExecutionLinkVO executionLinkVO2 = new ExecutionLinkVO();
            executionLinkVO2.setId(Long.parseLong("88888"));
            executionLinkVO2.setName("\u5c0f\u8ba1(\u95f4\u63a5\u8d39)");
            executionLinkVO2.setMny(sumIndirectMny);
            executionLinkVO2.setTaxMny(sumIndirecttaxMny);
            executionLinkVO2.setMnyScale(sumIndirectMnyScale);
            executionLinkVO2.setContMnyScale(sumIndirectContMnyScale);
            BigDecimal sumTotalMny = new BigDecimal(0);
            BigDecimal sumTotaltaxMny = new BigDecimal(0);
            BigDecimal sumTotalMnyScale = new BigDecimal(0);
            BigDecimal sumTotalContMnyScale = new BigDecimal(0);
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (linkVO.getMny() != null) {
                    sumTotalMny = sumTotalMny.add(linkVO.getMny());
                }
                if (linkVO.getTaxMny() != null) {
                    sumTotaltaxMny = sumTotaltaxMny.add(linkVO.getTaxMny());
                }
                if (linkVO.getMnyScale() == null) continue;
                sumTotalMnyScale = sumTotalMnyScale.add(linkVO.getMnyScale());
            }
            sumTotalContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumTotaltaxMny, (BigDecimal)incomeMny));
            ExecutionLinkVO executionLinkVO3 = new ExecutionLinkVO();
            executionLinkVO3.setId(Long.parseLong("66666"));
            executionLinkVO3.setName("\u5408\u8ba1");
            executionLinkVO3.setMny(sumTotalMny);
            executionLinkVO3.setTaxMny(sumTotaltaxMny);
            executionLinkVO3.setMnyScale(sumTotalMnyScale);
            executionLinkVO3.setContMnyScale(sumTotalContMnyScale);
            ArrayList<ExecutionLinkVO> linkVOList = new ArrayList<ExecutionLinkVO>();
            for (i = 0; i <= 4; ++i) {
                linkVOList.add((ExecutionLinkVO)((Object)linkVOS.get(i)));
            }
            linkVOList.add(executionLinkVO);
            for (i = 5; i <= 6; ++i) {
                linkVOList.add((ExecutionLinkVO)((Object)linkVOS.get(i)));
            }
            linkVOList.add(executionLinkVO2);
            linkVOList.add(executionLinkVO3);
            return linkVOList;
        }
        return linkVOS;
    }

    @Override
    public List<Map<String, Object>> queryDuty() {
        List<Map<String, Object>> dutyVOList = this.dutyMapper.queryDuty();
        return dutyVOList;
    }

    @Override
    public Map<Long, BigDecimal> queryDoc(Long projectId) {
        List<DutyDetailItemVO> dutyDetailItemVOList = this.dutyMapper.queryDoc(projectId);
        HashMap<Long, BigDecimal> dutyMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(dutyDetailItemVOList)) {
            for (DutyDetailItemVO dutyDetailItemVO : dutyDetailItemVOList) {
                dutyMap.put(dutyDetailItemVO.getDocId(), dutyDetailItemVO.getDocSumAmount());
            }
        }
        return dutyMap;
    }

    @Override
    public Map<Long, DutyDetailItemVO> queryDocDutyDetailItem(Long projectId, Integer docType) {
        List<DutyDetailItemVO> dutyDetailItemVOList = this.dutyMapper.queryDocDutyDetailItem(projectId, docType);
        HashMap<Long, DutyDetailItemVO> dutyMap = new HashMap<Long, DutyDetailItemVO>();
        if (CollectionUtils.isNotEmpty(dutyDetailItemVOList)) {
            for (DutyDetailItemVO dutyDetailItemVO : dutyDetailItemVOList) {
                dutyMap.put(dutyDetailItemVO.getDocId(), dutyDetailItemVO);
            }
        }
        return dutyMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DutyVO gatherDuty(Long dutyId) {
        DutyVO dutyVO = this.queryDetail(dutyId, false);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getProjectId, (Object)dutyVO.getProjectId());
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List dutyEntities = this.list((Wrapper)queryWrapper);
        if (dutyEntities.size() == 1) {
            if (!((DutyEntity)((Object)dutyEntities.get(0))).getGatherFlag().booleanValue()) {
                DutyEntity gatherEntity = (DutyEntity)((Object)BeanMapper.map((Object)dutyVO, DutyEntity.class));
                gatherEntity.setId(IdWorker.getId());
                gatherEntity.setName(gatherEntity.getProjectName() + "\u603b\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                gatherEntity.setDutyVersion(1);
                gatherEntity.setChangeId(null);
                gatherEntity.setChangeState(null);
                gatherEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                gatherEntity.setLastDutyId(null);
                gatherEntity.setLatestFlag(true);
                gatherEntity.setEnableState(true);
                gatherEntity.setGatherFlag(true);
                gatherEntity.setWbsId(null);
                gatherEntity.setWbsName(null);
                gatherEntity.setEmployeeId(null);
                gatherEntity.setEmployeeName(null);
                gatherEntity.setDepartmentId(null);
                gatherEntity.setDepartmentName(null);
                gatherEntity.setCreateTime(null);
                gatherEntity.setCreateUserCode(null);
                gatherEntity.setUpdateTime(null);
                gatherEntity.setUpdateUserCode(null);
                gatherEntity.setVersion(1);
                gatherEntity.setOneTime(null);
                gatherEntity.setProFlag(false);
                gatherEntity.setFloatRate(null);
                gatherEntity.setImportId(null);
                gatherEntity.setTax(null);
                gatherEntity.setUnExceptMny(null);
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)dutyVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                gatherEntity.setBillCode((String)billCode.getData());
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                for (DutyDetailEntity dutyDetailEntity : gatherEntity.getDutyDetailList()) {
                    Long newId = IdWorker.getId();
                    map.put(dutyDetailEntity.getId(), newId);
                    dutyDetailEntity.setId(newId);
                    dutyDetailEntity.setDutyId(gatherEntity.getId());
                    dutyDetailEntity.setDutyDetailItemList(this.setItemValues(dutyDetailEntity.getDutyDetailItemList(), gatherEntity, dutyDetailEntity));
                }
                ArrayList<DutyDetailItemEntity> insertList = new ArrayList<DutyDetailItemEntity>();
                for (DutyDetailEntity dutyDetailEntity : gatherEntity.getDutyDetailList()) {
                    dutyDetailEntity.setParentId((Long)map.get(dutyDetailEntity.getParentId()));
                    if (!CollectionUtils.isNotEmpty(dutyDetailEntity.getDutyDetailItemList())) continue;
                    insertList.addAll(dutyDetailEntity.getDutyDetailItemList());
                }
                this.saveOrUpdate((Object)gatherEntity, false);
                if (CollectionUtils.isNotEmpty(insertList)) {
                    this.dutyDetailItemService.saveOrUpdateBatch(insertList);
                }
            } else {
                DutyEntity oldGatherEntity = (DutyEntity)((Object)dutyEntities.get(0));
                this.removeByIds(Arrays.asList(oldGatherEntity.getId()), false);
                LambdaUpdateWrapper delete = new LambdaUpdateWrapper();
                delete.eq(DutyDetailItemEntity::getDutyId, (Object)oldGatherEntity.getId());
                this.dutyDetailItemService.remove((Wrapper)delete);
            }
        } else {
            ArrayList<DutyVO> allDutyList = new ArrayList<DutyVO>();
            DutyEntity oldGatherEntity = null;
            for (DutyEntity dutyEntity : dutyEntities) {
                if (dutyEntity.getGatherFlag().booleanValue()) {
                    oldGatherEntity = dutyEntity;
                    continue;
                }
                allDutyList.add(this.queryDetail(dutyEntity.getId(), false));
            }
            DutyEntity gatherEntity = (DutyEntity)((Object)BeanMapper.map(oldGatherEntity, DutyEntity.class));
            gatherEntity.setId(IdWorker.getId());
            gatherEntity.setMny(((DutyVO)allDutyList.get(0)).getMny());
            gatherEntity.setTaxMny(((DutyVO)allDutyList.get(0)).getTaxMny());
            gatherEntity.setTax(null);
            gatherEntity.setUnExceptMny(null);
            gatherEntity.setCreateTime(null);
            gatherEntity.setCreateUserCode(null);
            gatherEntity.setUpdateTime(null);
            gatherEntity.setUpdateUserCode(null);
            gatherEntity.setVersion(1);
            gatherEntity.setOneTime(null);
            gatherEntity.setProFlag(false);
            gatherEntity.setFloatRate(null);
            HashMap<Long, DutyDetailEntity> detailMap = new HashMap<Long, DutyDetailEntity>();
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (DutyDetailVO detailVO : ((DutyVO)allDutyList.get(0)).getDutyDetailList()) {
                DutyDetailEntity detailEntity = (DutyDetailEntity)((Object)BeanMapper.map((Object)detailVO, DutyDetailEntity.class));
                Long newId = IdWorker.getId();
                map.put(detailEntity.getId(), newId);
                detailEntity.setId(newId);
                detailEntity.setDutyId(gatherEntity.getId());
                detailMap.put(detailEntity.getFeeDetailId(), detailEntity);
            }
            for (DutyDetailEntity dutyDetailEntity : detailMap.values()) {
                dutyDetailEntity.setParentId((Long)map.get(dutyDetailEntity.getParentId()));
            }
            if (allDutyList.size() > 1) {
                void var10_22;
                boolean bl = true;
                while (var10_22 < allDutyList.size()) {
                    DutyVO duty = (DutyVO)allDutyList.get((int)var10_22);
                    gatherEntity.setMny(ComputeUtil.safeAdd((BigDecimal)gatherEntity.getMny(), (BigDecimal)duty.getMny()));
                    gatherEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)gatherEntity.getTaxMny(), (BigDecimal)duty.getTaxMny()));
                    for (DutyDetailVO detailVO : duty.getDutyDetailList()) {
                        DutyDetailEntity detailEntity = (DutyDetailEntity)((Object)detailMap.get(detailVO.getFeeDetailId()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)detailVO.getMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)detailVO.getTaxMny()));
                        detailEntity.setTaxRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)detailEntity.getMny()), (BigDecimal)detailEntity.getMny()), (BigDecimal)BigDecimal.valueOf(100L)));
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)detailVO.getPreTypeAmount()));
                        detailEntity.setGatherMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getGatherMny(), (BigDecimal)detailVO.getGatherMny()));
                        detailEntity.setGatherTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getGatherTaxMny(), (BigDecimal)detailVO.getGatherTaxMny()));
                        detailEntity.setTotalAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTotalAmount(), (BigDecimal)detailVO.getTotalAmount()));
                        ArrayList<DutyDetailItemEntity> itemAllList = new ArrayList<DutyDetailItemEntity>();
                        if (CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList())) {
                            itemAllList.addAll(detailEntity.getDutyDetailItemList());
                        }
                        if (CollectionUtils.isNotEmpty(detailVO.getDutyDetailItemList())) {
                            itemAllList.addAll(BeanMapper.mapList(detailVO.getDutyDetailItemList(), DutyDetailItemEntity.class));
                        }
                        detailEntity.setDutyDetailItemList(this.setItemValues(itemAllList, gatherEntity, detailEntity));
                    }
                    ++var10_22;
                }
            } else {
                for (Object detailEntity : detailMap.values()) {
                    ((DutyDetailEntity)((Object)detailEntity)).setDutyDetailItemList(this.setItemValues(((DutyDetailEntity)((Object)detailEntity)).getDutyDetailItemList(), gatherEntity, (DutyDetailEntity)((Object)detailEntity)));
                }
            }
            gatherEntity.setDutyDetailList(new ArrayList<DutyDetailEntity>(detailMap.values()));
            ArrayList<DutyDetailItemEntity> arrayList = new ArrayList<DutyDetailItemEntity>();
            for (DutyDetailEntity dutyDetailEntity : gatherEntity.getDutyDetailList()) {
                if (!CollectionUtils.isNotEmpty(dutyDetailEntity.getDutyDetailItemList())) continue;
                arrayList.addAll(dutyDetailEntity.getDutyDetailItemList());
            }
            this.saveOrUpdate((Object)gatherEntity, false);
            if (CollectionUtils.isNotEmpty(arrayList)) {
                this.dutyDetailItemService.saveOrUpdateBatch(arrayList);
            }
            this.removeByIds(Arrays.asList(oldGatherEntity.getId()), false);
            LambdaUpdateWrapper delete = new LambdaUpdateWrapper();
            delete.eq(DutyDetailItemEntity::getDutyId, (Object)oldGatherEntity.getId());
            this.dutyDetailItemService.remove((Wrapper)delete);
        }
        return null;
    }

    private List<DutyDetailItemEntity> setItemValues(List<DutyDetailItemEntity> itemAllList, DutyEntity gatherEntity, DutyDetailEntity detailEntity) {
        ArrayList<DutyDetailItemEntity> itemList = new ArrayList<DutyDetailItemEntity>();
        HashMap<Long, DutyDetailItemEntity> itemMap = new HashMap<Long, DutyDetailItemEntity>();
        for (DutyDetailItemEntity dutyDetailItemEntity : itemAllList) {
            if (null != dutyDetailItemEntity.getDocId()) {
                if (itemMap.containsKey(dutyDetailItemEntity.getDocId())) {
                    DutyDetailItemEntity itemEntity = (DutyDetailItemEntity)((Object)itemMap.get(dutyDetailItemEntity.getDocId()));
                    itemEntity.setMny(ComputeUtil.safeAdd((BigDecimal)itemEntity.getMny(), (BigDecimal)dutyDetailItemEntity.getMny()));
                    itemEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)itemEntity.getTaxMny(), (BigDecimal)dutyDetailItemEntity.getTaxMny()));
                    itemEntity.setTaxRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)itemEntity.getTaxMny(), (BigDecimal)itemEntity.getMny()), (BigDecimal)itemEntity.getMny()), (BigDecimal)BigDecimal.valueOf(100L)));
                    itemEntity.setAmount(ComputeUtil.safeAdd((BigDecimal)itemEntity.getAmount(), (BigDecimal)dutyDetailItemEntity.getAmount()));
                    itemEntity.setPrice(ComputeUtil.safeDiv((BigDecimal)itemEntity.getMny(), (BigDecimal)itemEntity.getAmount()));
                    itemEntity.setTaxPrice(ComputeUtil.safeDiv((BigDecimal)itemEntity.getTaxMny(), (BigDecimal)itemEntity.getAmount()));
                    itemMap.put(itemEntity.getDocId(), itemEntity);
                    continue;
                }
                dutyDetailItemEntity.setId(IdWorker.getId());
                dutyDetailItemEntity.setDutyId(gatherEntity.getId());
                dutyDetailItemEntity.setDutyDetailId(detailEntity.getId());
                itemMap.put(dutyDetailItemEntity.getDocId(), dutyDetailItemEntity);
                continue;
            }
            dutyDetailItemEntity.setId(IdWorker.getId());
            dutyDetailItemEntity.setDutyId(gatherEntity.getId());
            dutyDetailItemEntity.setDutyDetailId(detailEntity.getId());
            itemList.add(dutyDetailItemEntity);
        }
        itemList.addAll(itemMap.values());
        return itemList;
    }

    @Override
    public CommonResponse<String> pushFromImport(BaseVO baseVO, Boolean isEff, String conversionType) {
        IConversioneHandler conversioneHandler = this.conversionManageFactory.getHandler(conversionType);
        CommonResponse<String> result = conversioneHandler.push(baseVO, isEff);
        return result;
    }

    @Override
    public CommonResponse<String> deleteFromImport(Long importId, String conversionType) {
        IConversioneHandler conversioneHandler = this.conversionManageFactory.getHandler(conversionType);
        CommonResponse<String> result = conversioneHandler.delete(importId);
        return result;
    }

    @Override
    public Map<Long, BigDecimal> queryPriceByDocIds(Long projectId, Integer docType, Boolean isRent, List<Long> docIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(DutyEntity::getEnableState, (Object)true);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.getOne((Wrapper)queryWrapper));
        if (null != dutyEntity) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(DutyDetailItemEntity::getDutyId, (Object)dutyEntity.getId());
            wrapper.eq(DutyDetailItemEntity::getProjectId, (Object)projectId);
            wrapper.eq(DutyDetailItemEntity::getDocType, (Object)docType);
            if (isRent.booleanValue()) {
                wrapper.isNotNull(DutyDetailItemEntity::getRmatRentMonth);
            } else {
                wrapper.isNull(DutyDetailItemEntity::getRmatRentMonth);
            }
            wrapper.in(DutyDetailItemEntity::getDocId, docIds);
            List list = this.dutyDetailItemService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return list.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, DutyDetailItemEntity::getPrice, (key1, key2) -> key1));
            }
        }
        return null;
    }

    @Override
    public Map<Long, BigDecimal> querySumPreTypeAmount(Long projectId) {
        List<DutyDetailVO> dutyDetailVOList = this.dutyMapper.querySumPreTypeAmount(projectId);
        HashMap<Long, BigDecimal> dutyMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(dutyDetailVOList)) {
            for (DutyDetailVO dutyDetailVO : dutyDetailVOList) {
                dutyMap.put(dutyDetailVO.getCategoryId(), dutyDetailVO.getPreTypeAmount());
            }
        }
        return dutyMap;
    }

    @Override
    public void deleteList(List<DutyVO> vos) {
        for (DutyVO dutyVO : vos) {
            DutyEntity dutyEntity = (DutyEntity)((Object)this.service.getById(dutyVO.getId()));
            if (dutyEntity.getLastDutyId() == null) continue;
            DutyEntity revise = (DutyEntity)((Object)this.service.getById(dutyEntity.getLastDutyId()));
            revise.setChangeId(null);
            revise.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            revise.setLatestFlag(true);
            this.service.saveOrUpdate((Object)revise);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    private List<ParamsCheckVO> checkParamBudgetMny(DutyVO dutyVO, BigDecimal budgetMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_BUDGET, dutyVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            for (BillParamVO billParamVO : (List)billParamByCode.getData()) {
                ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)budgetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (dutyVO.getTaxMny() != null && dutyVO.getTaxMny().compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u76ee\u6807\u6210\u672c\u603b\u989d > \u9884\u7b97\u4e66\u603b\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a").append(DutyServiceImpl.format(dutyVO.getTaxMny().doubleValue())).append("\u5143\uff0c\u9884\u7b97\u4e66\u603b\u91d1\u989d*").append(roleValue).append("%:").append(DutyServiceImpl.format(comMny.doubleValue())).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(DutyServiceImpl.format(ComputeUtil.safeSub((BigDecimal)dutyVO.getTaxMny(), (BigDecimal)comMny).doubleValue())).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamCode(DutyVO dutyVO, BigDecimal incomeMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, dutyVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            for (BillParamVO billParamVO : (List)billParamByCode.getData()) {
                ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)incomeMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (dutyVO.getTaxMny() != null && dutyVO.getTaxMny().compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u76ee\u6807\u6210\u672c\u603b\u989d > \u65bd\u5de5\u5408\u540c\u603b\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a").append(DutyServiceImpl.format(dutyVO.getTaxMny().doubleValue())).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(DutyServiceImpl.format(comMny.doubleValue())).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(DutyServiceImpl.format(ComputeUtil.safeSub((BigDecimal)dutyVO.getTaxMny(), (BigDecimal)comMny).doubleValue())).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamCodeP(DutyVO dutyVO, BigDecimal incomeMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode_P = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_P, dutyVO.getOrgId());
        if (billParamByCode_P.isSuccess() && null != billParamByCode_P.getData()) {
            for (BillParamVO billParamVO : (List)billParamByCode_P.getData()) {
                ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal countMny = new BigDecimal(0);
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (!dutyDetailVO.getFeeDetailCode().equals("01") && !dutyDetailVO.getFeeDetailCode().equals("02") && !dutyDetailVO.getFeeDetailCode().equals("03") && !dutyDetailVO.getFeeDetailCode().equals("04") && !dutyDetailVO.getFeeDetailCode().equals("05") || dutyDetailVO.getTaxMny() == null) continue;
                        countMny = ComputeUtil.safeAdd((BigDecimal)countMny, (BigDecimal)dutyDetailVO.getTaxMny());
                    }
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)incomeMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (countMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u76ee\u6807\u6210\u672c\u76f4\u63a5\u8d39\u603b\u989d > \u65bd\u5de5\u5408\u540c\u603b\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u76ee\u6807\u6210\u672c\u76f4\u63a5\u8d39\u603b\u989d\uff1a").append(DutyServiceImpl.format(countMny.doubleValue())).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(DutyServiceImpl.format(comMny.doubleValue())).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(DutyServiceImpl.format(ComputeUtil.safeSub((BigDecimal)countMny, (BigDecimal)comMny).doubleValue())).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }
        } else {
            this.logger.info(billParamByCode_P.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamCodeR(DutyVO dutyVO, BigDecimal incomeMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode_R = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_R, dutyVO.getOrgId());
        if (billParamByCode_R.isSuccess() && null != billParamByCode_R.getData()) {
            for (BillParamVO billParamVO : (List)billParamByCode_R.getData()) {
                ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal personMny = new BigDecimal(0);
                    BigDecimal proMny = new BigDecimal(0);
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (dutyDetailVO.getFeeDetailCode().equals("01") && dutyDetailVO.getTaxMny() != null) {
                            personMny = personMny.add(dutyDetailVO.getTaxMny());
                        }
                        if (!dutyDetailVO.getFeeDetailCode().equals("04") || dutyDetailVO.getTaxMny() == null) continue;
                        proMny = proMny.add(dutyDetailVO.getTaxMny());
                    }
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    this.logger.info("\u63a7\u5236\u89c4\u5219\u503c-----------------------------------" + roleValue);
                    BigDecimal value = ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)new BigDecimal(100));
                    this.logger.info("\u63a7\u5236\u89c4\u5219\u503c\u767e\u5206\u6bd4-----------------------------------" + value);
                    this.logger.info("\u65bd\u5de5\u5408\u540c\u91d1\u989d------" + incomeMny + "---------------------\u4e13\u4e1a\u5206\u5305\u8d39\u7528--------" + proMny);
                    BigDecimal comMny = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeSub((BigDecimal)incomeMny, (BigDecimal)proMny), (BigDecimal)value).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (personMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u76ee\u6807\u6210\u672c\u4eba\u5de5\u8d39 > (\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d-\u4e13\u4e1a\u5206\u5305\u8d39\u7528)*" + roleValue + "%");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u76ee\u6807\u6210\u672c\u4eba\u5de5\u8d39\uff1a").append(DutyServiceImpl.format(personMny.doubleValue())).append("\u5143\uff0c(\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d-\u4e13\u4e1a\u5206\u5305\u8d39\u7528)* ").append(roleValue).append("%:").append(DutyServiceImpl.format(comMny.doubleValue())).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(DutyServiceImpl.format(ComputeUtil.safeSub((BigDecimal)personMny, (BigDecimal)comMny).doubleValue())).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }
        } else {
            this.logger.info(billParamByCode_R.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkWZ(DutyVO dutyVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode_WZ = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_WZ, dutyVO.getOrgId());
        List data = (List)billParamByCode_WZ.getData();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                if (billParamByCode_WZ.isSuccess() && null != billParamByCode_WZ.getData()) {
                    BigDecimal small = new BigDecimal(0);
                    BigDecimal max = new BigDecimal(0);
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (!CollectionUtils.isNotEmpty(dutyDetailVO.getDutyDetailItemList())) continue;
                        for (DutyDetailItemVO dutyDetailItemVO : dutyDetailVO.getDutyDetailItemList()) {
                            StringBuffer stringBuffer;
                            ParamsCheckDsVO paramsCheckDsVO;
                            BigDecimal difference;
                            String[] historicalPrice;
                            if (dutyDetailVO.getDocType() == null || dutyDetailVO.getDocType() != 3 || dutyDetailItemVO.getHistoricalPrice() == null || dutyDetailItemVO.getHistoricalPrice() == "" || (small = new BigDecimal((historicalPrice = dutyDetailItemVO.getHistoricalPrice().split("-"))[0])).equals(max = new BigDecimal(historicalPrice[1])) || dutyDetailItemVO.getPrice() == null) continue;
                            if (dutyDetailItemVO.getPrice().compareTo(small) == -1) {
                                difference = ComputeUtil.safeSub((BigDecimal)small, (BigDecimal)dutyDetailItemVO.getPrice());
                                paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName() + dutyDetailItemVO.getModel());
                                paramsCheckDsVO.setWarnName("\u76ee\u6807\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7\u683c");
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("\u76ee\u6807\u5355\u4ef7\uff1a").append(DutyServiceImpl.format(dutyDetailItemVO.getPrice().doubleValue())).append("\u5143\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4\uff1a").append(dutyDetailItemVO.getHistoricalPrice()).append(",\u5386\u53f2\u6700\u4f4e\u4ef7\uff1a").append(small.doubleValue()).append(",\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(difference.doubleValue()).append("\u5143\u3002");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                dataSource.add(paramsCheckDsVO);
                                paramsCheckVO.setDataSource(dataSource);
                                continue;
                            }
                            if (dutyDetailItemVO.getPrice().compareTo(max) == 1) {
                                difference = ComputeUtil.safeSub((BigDecimal)dutyDetailItemVO.getPrice(), (BigDecimal)max);
                                paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName() + dutyDetailItemVO.getModel());
                                paramsCheckDsVO.setWarnName("\u76ee\u6807\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7\u683c");
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("\u76ee\u6807\u5355\u4ef7\uff1a").append(DutyServiceImpl.format(dutyDetailItemVO.getPrice().doubleValue())).append("\u5143\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4\uff1a").append(dutyDetailItemVO.getHistoricalPrice()).append(",\u5386\u53f2\u6700\u9ad8\u4ef7\uff1a").append(max.doubleValue()).append(",\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(difference.doubleValue()).append("\u5143\u3002");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                dataSource.add(paramsCheckDsVO);
                                paramsCheckVO.setDataSource(dataSource);
                                continue;
                            }
                            paramsCheckVO.setWarnType(paramsArray[0]);
                        }
                    }
                } else {
                    this.logger.info(billParamByCode_WZ.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkLW(DutyVO dutyVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode_LW = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_LW, dutyVO.getOrgId());
        List data = (List)billParamByCode_LW.getData();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                if (billParamByCode_LW.isSuccess() && null != billParamByCode_LW.getData()) {
                    BigDecimal small = new BigDecimal(0);
                    BigDecimal max = new BigDecimal(0);
                    block1: for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (!CollectionUtils.isNotEmpty(dutyDetailVO.getDutyDetailItemList())) continue;
                        for (DutyDetailItemVO dutyDetailItemVO : dutyDetailVO.getDutyDetailItemList()) {
                            StringBuffer stringBuffer;
                            ParamsCheckDsVO paramsCheckDsVO;
                            BigDecimal difference;
                            if (dutyDetailVO.getDocType() == null || dutyDetailVO.getDocType() != 1 || dutyDetailItemVO.getHistoricalPrice() == null || dutyDetailItemVO.getHistoricalPrice() == "") continue;
                            String[] historicalPrice = dutyDetailItemVO.getHistoricalPrice().split("-");
                            small = new BigDecimal(historicalPrice[0]);
                            if (small.equals(max = new BigDecimal(historicalPrice[1]))) continue block1;
                            if (dutyDetailItemVO.getPrice() == null) continue;
                            if (dutyDetailItemVO.getPrice().compareTo(small) == -1) {
                                difference = ComputeUtil.safeSub((BigDecimal)small, (BigDecimal)dutyDetailItemVO.getPrice());
                                paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName());
                                paramsCheckDsVO.setWarnName("\u76ee\u6807\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7\u683c");
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("\u76ee\u6807\u5355\u4ef7\uff1a").append(DutyServiceImpl.format(dutyDetailItemVO.getPrice().doubleValue())).append("\u5143\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4\uff1a").append(dutyDetailItemVO.getHistoricalPrice()).append(",\u5386\u53f2\u6700\u4f4e\u4ef7\uff1a").append(small.doubleValue()).append(",\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(difference.doubleValue()).append("\u5143\u3002");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                dataSource.add(paramsCheckDsVO);
                                paramsCheckVO.setDataSource(dataSource);
                                continue;
                            }
                            if (dutyDetailItemVO.getPrice().compareTo(max) == 1) {
                                difference = ComputeUtil.safeSub((BigDecimal)dutyDetailItemVO.getPrice(), (BigDecimal)max);
                                paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName());
                                paramsCheckDsVO.setWarnName("\u76ee\u6807\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7\u683c");
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("\u76ee\u6807\u5355\u4ef7\uff1a").append(DutyServiceImpl.format(dutyDetailItemVO.getPrice().doubleValue())).append("\u5143\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4\uff1a").append(dutyDetailItemVO.getHistoricalPrice()).append(",\u5386\u53f2\u6700\u9ad8\u4ef7\uff1a").append(max.doubleValue()).append(",\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(difference.doubleValue()).append("\u5143\u3002");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                dataSource.add(paramsCheckDsVO);
                                paramsCheckVO.setDataSource(dataSource);
                                continue;
                            }
                            paramsCheckVO.setWarnType(paramsArray[0]);
                        }
                    }
                } else {
                    this.logger.info(billParamByCode_LW.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    private int getChangeFlag(BigDecimal one, BigDecimal two) {
        int flag = one.compareTo(two) == 0 ? 0 : 1;
        return flag;
    }

    public static String format(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.toString();
    }

    static class DutyDetailCompareEntity
    implements Comparator<DutyDetailEntity> {
        DutyDetailCompareEntity() {
        }

        @Override
        public int compare(DutyDetailEntity o1, DutyDetailEntity o2) {
            String[] parts1 = o1.getTreeIndex().split("\\.");
            String[] parts2 = o2.getTreeIndex().split("\\.");
            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; ++i) {
                int part2;
                int part1 = Integer.parseInt(parts1[i]);
                if (part1 < (part2 = Integer.parseInt(parts2[i]))) {
                    return -1;
                }
                if (part1 <= part2) continue;
                return 1;
            }
            return Integer.compare(parts1.length, parts2.length);
        }
    }
}

