package com.ejianc.business.targetcost.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务范围配置
 *
 * @author generator
 */
@TableName("ejc_targetcost_business_scope")
public class BusinessScopeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "name")
    private String name; // 名称
    @TableField(value = "code")
    private String code; // 编码
    @TableField(exist = false)
    private Boolean isLeaf = true;//是否叶节点
    @TableField(exist = false)
    private String parentId;//父id

    @TableField(exist = false)
    @SubEntity(serviceName = "businessScopeDetailService", pidName = "businessScopeId")//此处有pid="xxx"，默认值pid="pid"
    private List<BusinessScopeDetailEntity> businessScopeDetailList = new ArrayList<>(); // 业务范围明细表

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<BusinessScopeDetailEntity> getBusinessScopeDetailList() {
        return businessScopeDetailList;
    }

    public void setBusinessScopeDetailList(List<BusinessScopeDetailEntity> businessScopeDetailList) {
        this.businessScopeDetailList = businessScopeDetailList;
    }
}
