package com.ejianc.business.targetcost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 控制规则
 *
 * @author generator
 *
 */
@TableName("ejc_targetcost_rule")
public class RuleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="org_id")
    private Long orgId; // 所属组织，不显示默认当前组织
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="name")
    private String name; // 名称
    @TableField(value="type")
    private String type; // 类型
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 单据日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="fee_id")
    private Long feeId; // 费用模板ID
    @TableField(value="fee_code")
    private String feeCode; // 费用模板编码
    @TableField(value="fee_name")
    private String feeName; // 费用模板名称
    @TableField(value="enabled")
    private Boolean enabled; // 启用/停用(1:启用，0：停用)


    @TableField(exist=false)
    @SubEntity(serviceName="ruleDetailService", pidName = "ruleId")
    private List<RuleDetailEntity> ruleDetailList = new ArrayList<>(); // 控制规则明细


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeCode() {
        return feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<RuleDetailEntity> getRuleDetailList() {
        return ruleDetailList;
    }

    public void setRuleDetailList(List<RuleDetailEntity> ruleDetailList) {
        this.ruleDetailList = ruleDetailList;
    }
}
