/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.build.vo.BuildDutyVO;
import com.ejianc.business.build.vo.BuildEquipmentVO;
import com.ejianc.business.build.vo.BuildFeesVO;
import com.ejianc.business.build.vo.BuildManageVO;
import com.ejianc.business.build.vo.BuildMaterialVO;
import com.ejianc.business.build.vo.BuildMeasureVO;
import com.ejianc.business.build.vo.BuildOtherVO;
import com.ejianc.business.build.vo.BuildRgcostVO;
import com.ejianc.business.build.vo.BuildRmatVO;
import com.ejianc.business.build.vo.BuildSafeVO;
import com.ejianc.business.build.vo.BuildSubVO;
import com.ejianc.business.build.vo.BuildTemporaryVO;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.handler.ConversionBaseHandler;
import com.ejianc.business.targetcost.handler.IConversioneHandler;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class BuildHandler
extends ConversionBaseHandler
implements IConversioneHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        BuildDutyVO buildDutyVO = (BuildDutyVO)baseVO;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)buildDutyVO), DutyEntity.class));
        dutyEntity.setFirstImportId(buildDutyVO.getBaseDutyId());
        dutyEntity.setImportId(buildDutyVO.getId());
        dutyEntity.setImportType(ConversionEnum.\u4e91\u5357\u623f\u5efa.getCode());
        this.handlerHead(dutyEntity, isEff, baseVO);
        return CommonResponse.success((String)"\u5bfc\u5165\u8f6c\u6362\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        this.deleteDuty(importId);
        return CommonResponse.success((String)"\u5220\u9664\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        BuildDutyVO buildDutyVO = (BuildDutyVO)baseVO;
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        LasubChangeCallable labsubCallable = new LasubChangeCallable(this.labsubApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> labsubFuture = threadPool.submit(labsubCallable);
        ProsubChangeCallable prosubCallable = new ProsubChangeCallable(this.prosubApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> prosubFuture = threadPool.submit(prosubCallable);
        MaterialChangeCallable materialCallable = new MaterialChangeCallable(this.materialApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> materialFuture = threadPool.submit(materialCallable);
        RmatChangeCallable rmatCallable = new RmatChangeCallable(this.materialApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> rmatFuture = threadPool.submit(rmatCallable);
        EquipmentChangeCallable equipCallable = new EquipmentChangeCallable(this.equipmentApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> equipFuture = threadPool.submit(equipCallable);
        OtherChangeCallable othCallable = new OtherChangeCallable(buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> othFuture = threadPool.submit(othCallable);
        ArrayList<DutyEntity> dutyList = new ArrayList<DutyEntity>();
        try {
            dutyList.add(labsubFuture.get());
            dutyList.add(prosubFuture.get());
            dutyList.add(materialFuture.get());
            dutyList.add(rmatFuture.get());
            dutyList.add(equipFuture.get());
            dutyList.add(othFuture.get());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u623f\u5efa\u5bfc\u5165\u8f6c\u6362\u5931\u8d25\uff01");
        }
        finally {
            threadPool.shutdown();
        }
        return dutyList;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        boolean aqwmsgfFlag = false;
        boolean lsssfFlag = false;
        boolean qtcsfFlag = false;
        boolean xcglflag = false;
        boolean gfFlag = false;
        boolean otherFlag = false;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if ("\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                aqwmsgfFlag = true;
            }
            if ("\u4e34\u65f6\u8bbe\u65bd\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                lsssfFlag = true;
            }
            if ("\u5176\u4ed6\u63aa\u65bd\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                qtcsfFlag = true;
            }
            if ("\u73b0\u573a\u7ba1\u7406\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                xcglflag = true;
            }
            if ("\u89c4\u8d39".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                gfFlag = true;
            }
            if (!"\u5176\u4ed6\u8d39\u7528".equals(detailVO.getName()) || null != detailVO.getParentId()) continue;
            otherFlag = true;
        }
        if (!aqwmsgfFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!lsssfFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4e34\u65f6\u8bbe\u65bd\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!qtcsfFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u63aa\u65bd\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!xcglflag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u73b0\u573a\u7ba1\u7406\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!gfFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u89c4\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        if (!otherFlag) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u8d39\u7528\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
    }

    class OtherChangeCallable
    implements Callable<DutyEntity> {
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public OtherChangeCallable(BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            this.dealAqwmsgfData(this.buildDutyVO, dutyEntity, this.feeVO);
            this.dealLsssfData(this.buildDutyVO, dutyEntity, this.feeVO);
            this.dealQtcsfData(this.buildDutyVO, dutyEntity, this.feeVO);
            this.dealXcglfData(this.buildDutyVO, dutyEntity, this.feeVO);
            this.dealGfData(this.buildDutyVO, dutyEntity, this.feeVO);
            this.dealOtherData(this.buildDutyVO, dutyEntity, this.feeVO);
            return dutyEntity;
        }

        private void dealAqwmsgfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long aqwmsgfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u5b89\u5168\u6587\u660e\u65bd\u5de5\u8d39".equals(detailVO.getName())) continue;
                aqwmsgfId = detailVO.getId();
            }
            int num = 1;
            for (BuildSafeVO safeVO : buildDutyVO.getBuildSafeList()) {
                if (null == safeVO.getLeafFlag() || !safeVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(aqwmsgfId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)safeVO.getSafeCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(safeVO.getSafeCode());
                    }
                    itemEntity.setName(safeVO.getSafeName());
                    itemEntity.setUnitName(safeVO.getSafeUnitName());
                    itemEntity.setTaxRate(safeVO.getSafeRate());
                    itemEntity.setPrice(safeVO.getSafePrice());
                    itemEntity.setTaxPrice(safeVO.getSafeTaxPrice());
                    itemEntity.setAmount(safeVO.getSafeNum());
                    itemEntity.setMny(safeVO.getSafeMny());
                    itemEntity.setTaxMny(safeVO.getSafeTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealLsssfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long lsssfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u4e34\u65f6\u8bbe\u65bd\u8d39".equals(detailVO.getName())) continue;
                lsssfId = detailVO.getId();
            }
            int num = 1;
            for (BuildTemporaryVO temporaryVO : buildDutyVO.getBuildTemporaryList()) {
                if (null == temporaryVO.getLeafFlag() || !temporaryVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(lsssfId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)temporaryVO.getTemporaryCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(temporaryVO.getTemporaryCode());
                    }
                    itemEntity.setName(temporaryVO.getTemporaryName());
                    itemEntity.setUnitName(temporaryVO.getTemporaryUnitName());
                    itemEntity.setTaxRate(temporaryVO.getTemporaryRate());
                    itemEntity.setPrice(temporaryVO.getTemporaryPrice());
                    itemEntity.setTaxPrice(temporaryVO.getTemporaryTaxPrice());
                    itemEntity.setAmount(temporaryVO.getTemporaryNum());
                    itemEntity.setMny(temporaryVO.getTemporaryMny());
                    itemEntity.setTaxMny(temporaryVO.getTemporaryTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealQtcsfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long qtcsfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u5176\u4ed6\u63aa\u65bd\u8d39".equals(detailVO.getName())) continue;
                qtcsfId = detailVO.getId();
            }
            int num = 1;
            for (BuildMeasureVO measureVO : buildDutyVO.getBuildMeasureList()) {
                if (null == measureVO.getLeafFlag() || !measureVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(qtcsfId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)measureVO.getMeasureCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(measureVO.getMeasureCode());
                    }
                    itemEntity.setName(measureVO.getMeasureName());
                    itemEntity.setUnitName(measureVO.getMeasureUnitName());
                    itemEntity.setTaxRate(measureVO.getMeasureRate());
                    itemEntity.setPrice(measureVO.getMeasurePrice());
                    itemEntity.setTaxPrice(measureVO.getMeasureTaxPrice());
                    itemEntity.setAmount(measureVO.getMeasureNum());
                    itemEntity.setMny(measureVO.getMeasureMny());
                    itemEntity.setTaxMny(measureVO.getMeasureTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealXcglfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long xcglfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u73b0\u573a\u7ba1\u7406\u8d39".equals(detailVO.getName())) continue;
                xcglfId = detailVO.getId();
            }
            int num = 1;
            for (BuildManageVO manageVO : buildDutyVO.getBuildManageList()) {
                if (null == manageVO.getLeafFlag() || !manageVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(xcglfId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)manageVO.getManageCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(manageVO.getManageCode());
                    }
                    itemEntity.setName(manageVO.getManageName());
                    itemEntity.setUnitName(manageVO.getManageUnitName());
                    itemEntity.setTaxRate(manageVO.getManageRate());
                    itemEntity.setPrice(manageVO.getManagePrice());
                    itemEntity.setTaxPrice(manageVO.getManageTaxPrice());
                    itemEntity.setAmount(ComputeUtil.safeMultiply((BigDecimal)manageVO.getManageNum(), (BigDecimal)manageVO.getManageDuration()));
                    itemEntity.setMny(manageVO.getManageMny());
                    itemEntity.setTaxMny(manageVO.getManageTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealGfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long gfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u89c4\u8d39".equals(detailVO.getName())) continue;
                gfId = detailVO.getId();
            }
            int num = 1;
            for (BuildFeesVO feesVO : buildDutyVO.getBuildFeesList()) {
                if (null == feesVO.getLeafFlag() || !feesVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(gfId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)feesVO.getFeesCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(feesVO.getFeesCode());
                    }
                    itemEntity.setName(feesVO.getFeesName());
                    itemEntity.setUnitName(feesVO.getFeesUnitName());
                    itemEntity.setPrice(feesVO.getFeesPrice());
                    itemEntity.setTaxPrice(feesVO.getFeesPrice());
                    itemEntity.setAmount(feesVO.getFeesNum());
                    itemEntity.setMny(feesVO.getFeesMny());
                    itemEntity.setTaxMny(feesVO.getFeesMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }

        private void dealOtherData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            Long otherId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (!"\u5176\u4ed6\u8d39\u7528".equals(detailVO.getName())) continue;
                otherId = detailVO.getId();
            }
            int num = 1;
            for (BuildOtherVO otherVO : buildDutyVO.getBuildOtherList()) {
                if (null == otherVO.getLeafFlag() || !otherVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(otherId)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)otherVO.getOtherCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(otherVO.getOtherCode());
                    }
                    itemEntity.setName(otherVO.getOtherName());
                    itemEntity.setUnitName(otherVO.getOtherUnitName());
                    itemEntity.setPrice(otherVO.getOtherPrice());
                    itemEntity.setTaxPrice(otherVO.getOtherPrice());
                    itemEntity.setAmount(otherVO.getOtherNum());
                    itemEntity.setMny(otherVO.getOtherMny());
                    itemEntity.setTaxMny(otherVO.getOtherMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                ++num;
            }
        }
    }

    class EquipmentChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareEquipmentApi shareEquipmentApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public EquipmentChangeCallable(IShareEquipmentApi shareEquipmentApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareEquipmentApi = shareEquipmentApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var4_7;
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long jxfId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238542").equals(feeDetailVO.getFeePropId())) continue;
                jxfId = feeDetailVO.getId();
            }
            if (null == jxfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u673a\u68b0\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> jxfSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(jxfId))) continue;
                jxfSet.add(feeDetailVO.getId());
            }
            Object var4_6 = null;
            for (FeeDetailVO detailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) || !jxfSet.contains(detailVO.getId())) continue;
                Long l = detailVO.getId();
            }
            if (null == var4_7) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u673a\u68b0\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            CommonResponse commonResponse = this.shareEquipmentApi.queryCategoryListByIds(new ArrayList());
            HashMap<Long, String> equipCtyLongInnerMap = new HashMap<Long, String>();
            HashMap<String, String> equipCtyStringInnerMap = new HashMap<String, String>();
            for (Object categoryVO : (List)commonResponse.getData()) {
                equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
            }
            ArrayList<String> codeList = new ArrayList<String>();
            for (BuildEquipmentVO equipmentVO : this.buildDutyVO.getBuildEquipmentList()) {
                if (!StringUtils.isNotBlank((CharSequence)equipmentVO.getEquipmentCode()) || !equipmentVO.getEquipmentCode().matches("\\d.*")) continue;
                String result = equipmentVO.getEquipmentCode().length() > 3 ? equipmentVO.getEquipmentCode().substring(0, equipmentVO.getEquipmentCode().length() - 3) : equipmentVO.getEquipmentCode();
                equipmentVO.setEquipmentCode(result);
                codeList.add(result);
            }
            CommonResponse equipResponse = this.shareEquipmentApi.queryEquipmentListByCodes(codeList);
            Map<Object, Object> equipMap = new HashMap();
            if (equipResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)equipResponse.getData()))) {
                equipMap = ((List)equipResponse.getData()).stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
            int num = 1;
            for (BuildEquipmentVO buildEquipmentVO : this.buildDutyVO.getBuildEquipmentList()) {
                if (null == buildEquipmentVO.getLeafFlag() || !buildEquipmentVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipmentCode()) && equipMap.containsKey(buildEquipmentVO.getEquipmentCode())) {
                        EquipmentVO equipmentVO = (EquipmentVO)equipMap.get(buildEquipmentVO.getEquipmentCode());
                        String innerCode = (String)equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(equipmentVO.getCode());
                        itemEntity.setName(equipmentVO.getName());
                        itemEntity.setModel(equipmentVO.getSpec());
                        itemEntity.setUnitId(equipmentVO.getUnitId());
                        itemEntity.setUnitName(equipmentVO.getUnitName());
                        itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                        itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                        itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                        itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                        itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                        itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                        itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                        itemEntity.setCategoryId(equipmentVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(equipmentVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                        itemEntity.setDocId(equipmentVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipmentCode()) && equipCtyStringInnerMap.containsKey(buildEquipmentVO.getEquipmentCode())) {
                        String innerCode = (String)equipCtyStringInnerMap.get(buildEquipmentVO.getEquipmentCode());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)buildEquipmentVO.getEquipmentNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)buildEquipmentVO.getEquipmentMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)buildEquipmentVO.getEquipmentTaxMny()));
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var4_7)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)buildEquipmentVO.getEquipmentCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(buildEquipmentVO.getEquipmentCode());
                    }
                    itemEntity.setName(buildEquipmentVO.getEquipmentName());
                    itemEntity.setUnitName(buildEquipmentVO.getEquipmentUnitName());
                    itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                    itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                    itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                    itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                    itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                    itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                    itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
                if (!StringUtils.isBlank((CharSequence)buildEquipmentVO.getEquipmentCode())) continue;
                ++num;
            }
            return dutyEntity;
        }
    }

    class RmatChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public RmatChangeCallable(IShareMaterialApi shareMaterialApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var6_9;
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            HashMap<Long, String> matCtyLongInnerMap = new HashMap<Long, String>();
            HashMap<String, String> matCtyStringInnerMap = new HashMap<String, String>();
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long zzcId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238537").equals(feeDetailVO.getFeePropId())) continue;
                zzcId = feeDetailVO.getId();
            }
            if (null == zzcId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5468\u8f6c\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> zzcSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(zzcId))) continue;
                zzcSet.add(feeDetailVO.getId());
            }
            Object var6_8 = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238538").equals(feeDetailVO.getFeePropId()) || !zzcSet.contains(feeDetailVO.getId())) continue;
                Long l = feeDetailVO.getId();
            }
            if (null == var6_9) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u5468\u8f6c\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BuildRmatVO rmatVO : this.buildDutyVO.getBuildRmatList()) {
                if (!StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode()) || !rmatVO.getRmatCode().matches("\\d.*")) continue;
                String result = rmatVO.getRmatCode().length() > 3 ? rmatVO.getRmatCode().substring(0, rmatVO.getRmatCode().length() - 3) : rmatVO.getRmatCode();
                rmatVO.setRmatCode(result);
                arrayList.add(result);
            }
            CommonResponse commonResponse = this.shareMaterialApi.queryMaterialListByCodes(arrayList);
            Map<Object, Object> matMap = new HashMap();
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                matMap = ((List)commonResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
            int num = 1;
            for (BuildRmatVO rmatVO : this.buildDutyVO.getBuildRmatList()) {
                if (null == rmatVO.getLeafFlag() || !rmatVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    MaterialVO materialVO;
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode())) {
                        CommonResponse response;
                        if (matMap.containsKey(rmatVO.getRmatCode())) {
                            materialVO = (MaterialVO)matMap.get(rmatVO.getRmatCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse response2 = this.shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = (MaterialCategoryVO)response2.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else if (!matCtyStringInnerMap.containsKey(rmatVO.getRmatCode()) && (response = this.shareMaterialApi.queryCategoryByCode(rmatVO.getRmatCode())).isSuccess() && null != response.getData()) {
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)response.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode()) && matMap.containsKey(rmatVO.getRmatCode())) {
                        materialVO = (MaterialVO)matMap.get(rmatVO.getRmatCode());
                        String innerCode = (String)matCtyLongInnerMap.get(materialVO.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zzcSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(materialVO.getCode());
                        itemEntity.setName(materialVO.getName());
                        itemEntity.setModel(materialVO.getSpec());
                        itemEntity.setUnitId(materialVO.getUnitId());
                        itemEntity.setUnitName(materialVO.getUnitName());
                        itemEntity.setTaxRate(rmatVO.getRmatRate());
                        itemEntity.setPrice(rmatVO.getRmatPrice());
                        itemEntity.setTaxPrice(rmatVO.getRmatTaxPrice());
                        itemEntity.setAmount(rmatVO.getRmatNum());
                        itemEntity.setMny(rmatVO.getRmatMny());
                        itemEntity.setTaxMny(rmatVO.getRmatTaxMny());
                        itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                        itemEntity.setCategoryId(materialVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(materialVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                        itemEntity.setDocId(materialVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)rmatVO.getRmatCode()) && matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {
                        String innerCode = (String)matCtyStringInnerMap.get(rmatVO.getRmatCode());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zzcSet.contains(detailEntity.getFeeDetailId()))) continue;
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)rmatVO.getRmatNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)rmatVO.getRmatMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)rmatVO.getRmatTaxMny()));
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var6_9)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)rmatVO.getRmatCode())) {
                        itemEntity.setCode(String.valueOf(num));
                        ++num;
                    } else {
                        itemEntity.setCode(rmatVO.getRmatCode());
                    }
                    itemEntity.setName(rmatVO.getRmatName());
                    itemEntity.setUnitName(rmatVO.getRmatUnitName());
                    itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                    itemEntity.setTaxRate(rmatVO.getRmatRate());
                    itemEntity.setPrice(rmatVO.getRmatPrice());
                    itemEntity.setTaxPrice(rmatVO.getRmatTaxPrice());
                    itemEntity.setAmount(rmatVO.getRmatNum());
                    itemEntity.setMny(rmatVO.getRmatMny());
                    itemEntity.setTaxMny(rmatVO.getRmatTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }

    class MaterialChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public MaterialChangeCallable(IShareMaterialApi shareMaterialApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var6_9;
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            HashMap<Long, String> matCtyLongInnerMap = new HashMap<Long, String>();
            HashMap<String, String> matCtyStringInnerMap = new HashMap<String, String>();
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long clfId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238535").equals(feeDetailVO.getFeePropId())) continue;
                clfId = feeDetailVO.getId();
            }
            if (null == clfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> clfSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(clfId))) continue;
                clfSet.add(feeDetailVO.getId());
            }
            Object var6_8 = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238539").equals(feeDetailVO.getFeePropId()) || !clfSet.contains(feeDetailVO.getId())) continue;
                Long l = feeDetailVO.getId();
            }
            if (null == var6_9) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BuildMaterialVO materialVO : this.buildDutyVO.getBuildMaterialList()) {
                if (!StringUtils.isNotBlank((CharSequence)materialVO.getMaterialCode()) || !materialVO.getMaterialCode().matches("\\d.*")) continue;
                String result = materialVO.getMaterialCode().length() > 3 ? materialVO.getMaterialCode().substring(0, materialVO.getMaterialCode().length() - 3) : materialVO.getMaterialCode();
                materialVO.setMaterialCode(result);
                arrayList.add(result);
            }
            CommonResponse commonResponse = this.shareMaterialApi.queryMaterialListByCodes(arrayList);
            Map<Object, Object> matMap = new HashMap();
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                matMap = ((List)commonResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
            int num = 1;
            for (BuildMaterialVO buildMaterialVO : this.buildDutyVO.getBuildMaterialList()) {
                if (null == buildMaterialVO.getLeafFlag() || !buildMaterialVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    MaterialVO materialVO;
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialCode())) {
                        CommonResponse response;
                        if (matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                            materialVO = (MaterialVO)matMap.get(buildMaterialVO.getMaterialCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse response2 = this.shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = (MaterialCategoryVO)response2.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else if (!matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode()) && (response = this.shareMaterialApi.queryCategoryByCode(buildMaterialVO.getMaterialCode())).isSuccess() && null != response.getData()) {
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)response.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialCode()) && matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                        materialVO = (MaterialVO)matMap.get(buildMaterialVO.getMaterialCode());
                        String innerCode = (String)matCtyLongInnerMap.get(materialVO.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(materialVO.getCode());
                        itemEntity.setName(materialVO.getName());
                        itemEntity.setModel(materialVO.getSpec());
                        itemEntity.setUnitId(materialVO.getUnitId());
                        itemEntity.setUnitName(materialVO.getUnitName());
                        itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                        itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                        itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                        itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                        itemEntity.setMny(buildMaterialVO.getMaterialMny());
                        itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                        itemEntity.setCategoryId(materialVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(materialVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                        itemEntity.setDocId(materialVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialCode()) && matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode())) {
                        String innerCode = (String)matCtyStringInnerMap.get(buildMaterialVO.getMaterialCode());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)buildMaterialVO.getMaterialNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)buildMaterialVO.getMaterialMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)buildMaterialVO.getMaterialTaxMny()));
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var6_9)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank((CharSequence)buildMaterialVO.getMaterialCode())) {
                        itemEntity.setCode(String.valueOf(num));
                        ++num;
                    } else {
                        itemEntity.setCode(buildMaterialVO.getMaterialCode());
                    }
                    itemEntity.setName(buildMaterialVO.getMaterialName());
                    itemEntity.setUnitName(buildMaterialVO.getMaterialUnitName());
                    itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                    itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                    itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                    itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                    itemEntity.setMny(buildMaterialVO.getMaterialMny());
                    itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }

    class ProsubChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareProsubApi shareProsubApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public ProsubChangeCallable(IShareProsubApi shareProsubApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareProsubApi = shareProsubApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var5_8;
            HashMap<Long, String> proCtyInnerCodeMap = new HashMap<Long, String>();
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long zyfbId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238540").equals(feeDetailVO.getFeePropId())) continue;
                zyfbId = feeDetailVO.getId();
            }
            if (null == zyfbId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4e13\u4e1a\u5206\u5305\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> zyfbSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(zyfbId))) continue;
                zyfbSet.add(feeDetailVO.getId());
            }
            Object var5_7 = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238541").equals(feeDetailVO.getFeePropId()) || !zyfbSet.contains(feeDetailVO.getId())) continue;
                Long l = feeDetailVO.getId();
            }
            if (null == var5_8) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4e13\u4e1a\u5206\u5305\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BuildSubVO subVO : this.buildDutyVO.getBuildSubList()) {
                if (null == subVO.getLeafFlag() || !subVO.getLeafFlag().booleanValue() || !StringUtils.isNotBlank((CharSequence)subVO.getSubCode()) || !subVO.getSubCode().startsWith("YZ")) continue;
                String result = subVO.getSubCode().substring(0, subVO.getSubCode().length() - 3);
                subVO.setSubCode(result);
                arrayList.add(result);
            }
            HashMap hashMap = new HashMap();
            CommonResponse proItemResponse = this.shareProsubApi.queryItemListByCodes(arrayList);
            if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proItemResponse.getData()))) {
                Map map = ((List)proItemResponse.getData()).stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }
            for (BuildSubVO subVO : this.buildDutyVO.getBuildSubList()) {
                if (null == subVO.getLeafFlag() || !subVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    void var7_17;
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)subVO.getSubCode()) && subVO.getSubCode().startsWith("YZ") && var7_17.containsKey(subVO.getSubCode())) {
                        ProsubItemVO prosubItemVO = (ProsubItemVO)var7_17.get(subVO.getSubCode());
                        if (!proCtyInnerCodeMap.containsKey(prosubItemVO.getCategoryId())) {
                            CommonResponse response = this.shareProsubApi.queryCategoryListByIds(Arrays.asList(prosubItemVO.getCategoryId()));
                            proCtyInnerCodeMap.put(prosubItemVO.getCategoryId(), ((ProsubCategoryVO)((List)response.getData()).get(0)).getInnerCode());
                        }
                        String innerCode = (String)proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zyfbSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(prosubItemVO.getTrawlingCode());
                        itemEntity.setName(prosubItemVO.getTrawlingName());
                        itemEntity.setPriceType(prosubItemVO.getPriceType());
                        itemEntity.setJobContent(prosubItemVO.getJobContent());
                        itemEntity.setUnitName(prosubItemVO.getUnitName());
                        itemEntity.setTaxRate(subVO.getSubRate());
                        itemEntity.setPrice(subVO.getSubPrice());
                        itemEntity.setTaxPrice(subVO.getSubTaxPrice());
                        itemEntity.setAmount(subVO.getSubNum());
                        itemEntity.setMny(subVO.getSubMny());
                        itemEntity.setTaxMny(subVO.getSubTaxMny());
                        itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                        itemEntity.setDocId(prosubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var5_8)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(subVO.getSubCode());
                    itemEntity.setName(subVO.getSubName());
                    itemEntity.setUnitName(subVO.getSubUnitName());
                    itemEntity.setTaxRate(subVO.getSubRate());
                    itemEntity.setPrice(subVO.getSubPrice());
                    itemEntity.setTaxPrice(subVO.getSubTaxPrice());
                    itemEntity.setAmount(subVO.getSubNum());
                    itemEntity.setMny(subVO.getSubMny());
                    itemEntity.setTaxMny(subVO.getSubTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }

    class LasubChangeCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareLabsubApi shareLabsubApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public LasubChangeCallable(IShareLabsubApi shareLabsubApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareLabsubApi = shareLabsubApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DutyEntity call() {
            void var5_8;
            HashMap<Long, String> labCtyInnerCodeMap = new HashMap<Long, String>();
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)this.baseDutyEntity), DutyEntity.class));
            Long rgfId = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238533").equals(feeDetailVO.getFeePropId())) continue;
                rgfId = feeDetailVO.getId();
            }
            if (null == rgfId) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            HashSet<Long> rgfSet = new HashSet<Long>();
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!feeDetailVO.getInnerCode().contains(String.valueOf(rgfId))) continue;
                rgfSet.add(feeDetailVO.getId());
            }
            Object var5_7 = null;
            for (FeeDetailVO feeDetailVO : this.feeVO.getFeeDetailList()) {
                if (!Long.valueOf("546645586985238534").equals(feeDetailVO.getFeePropId()) || !rgfSet.contains(feeDetailVO.getId())) continue;
                Long l = feeDetailVO.getId();
            }
            if (null == var5_8) {
                throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BuildRgcostVO rgcostVO : this.buildDutyVO.getBuildRgcostList()) {
                if (null == rgcostVO.getLeafFlag() || !rgcostVO.getLeafFlag().booleanValue() || !StringUtils.isNotBlank((CharSequence)rgcostVO.getRgcostCode()) || !rgcostVO.getRgcostCode().startsWith("YL")) continue;
                String result = rgcostVO.getRgcostCode().substring(0, rgcostVO.getRgcostCode().length() - 3);
                rgcostVO.setRgcostCode(result);
                arrayList.add(result);
            }
            HashMap hashMap = new HashMap();
            CommonResponse labItemResponse = this.shareLabsubApi.queryItemListByCodes(arrayList);
            if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labItemResponse.getData()))) {
                Map map = ((List)labItemResponse.getData()).stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            } else {
                BuildHandler.this.logger.error("labItemResponse is" + JSONObject.toJSONString((Object)labItemResponse));
            }
            for (BuildRgcostVO rgcostVO : this.buildDutyVO.getBuildRgcostList()) {
                if (null == rgcostVO.getLeafFlag() || !rgcostVO.getLeafFlag().booleanValue()) continue;
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    void var7_17;
                    if (!detailEntity.getLeafFlag().booleanValue()) continue;
                    if (StringUtils.isNotBlank((CharSequence)rgcostVO.getRgcostCode()) && rgcostVO.getRgcostCode().startsWith("YL") && var7_17.containsKey(rgcostVO.getRgcostCode())) {
                        LabsubItemVO labsubItemVO = (LabsubItemVO)var7_17.get(rgcostVO.getRgcostCode());
                        if (!labCtyInnerCodeMap.containsKey(labsubItemVO.getCategoryId())) {
                            CommonResponse response = this.shareLabsubApi.queryLabSubByCategoryId(labsubItemVO.getCategoryId());
                            labCtyInnerCodeMap.put(labsubItemVO.getCategoryId(), ((LabsubCategoryVO)response.getData()).getInnerCode());
                        }
                        String innerCode = (String)labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                        BuildHandler.this.logger.error("labsubItemVO is" + JSONObject.toJSONString((Object)labsubItemVO));
                        BuildHandler.this.logger.error("innerCode is" + JSONObject.toJSONString((Object)innerCode));
                        BuildHandler.this.logger.error("getRgcostCode is" + JSONObject.toJSONString((Object)rgcostVO.getRgcostCode()));
                        if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !rgfSet.contains(detailEntity.getFeeDetailId()))) continue;
                        ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(labsubItemVO.getTrawlingCode());
                        itemEntity.setName(labsubItemVO.getTrawlingName());
                        itemEntity.setPriceType(labsubItemVO.getPriceType());
                        itemEntity.setJobContent(labsubItemVO.getJobContent());
                        itemEntity.setUnitName(labsubItemVO.getUnitName());
                        itemEntity.setTaxRate(rgcostVO.getRgcostRate());
                        itemEntity.setPrice(rgcostVO.getRgcostPrice());
                        itemEntity.setTaxPrice(rgcostVO.getRgcostTaxPrice());
                        itemEntity.setAmount(rgcostVO.getRgcostNum());
                        itemEntity.setMny(rgcostVO.getRgcostMny());
                        itemEntity.setTaxMny(rgcostVO.getRgcostTaxMny());
                        itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                        itemEntity.setDocId(labsubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                        continue;
                    }
                    if (!detailEntity.getFeeDetailId().equals(var5_8)) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(rgcostVO.getRgcostCode());
                    itemEntity.setName(rgcostVO.getRgcostName());
                    itemEntity.setUnitName(rgcostVO.getRgcostUnitName());
                    itemEntity.setTaxRate(rgcostVO.getRgcostRate());
                    itemEntity.setPrice(rgcostVO.getRgcostPrice());
                    itemEntity.setTaxPrice(rgcostVO.getRgcostTaxPrice());
                    itemEntity.setAmount(rgcostVO.getRgcostNum());
                    itemEntity.setMny(rgcostVO.getRgcostMny());
                    itemEntity.setTaxMny(rgcostVO.getRgcostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            return dutyEntity;
        }
    }
}

