package com.ejianc.business.roadbridge.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.roadbridge.bean.*;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.roadbridge.mapper.RoadbridgeDutyMapper;
import com.ejianc.business.roadbridge.service.*;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.DetailIndexExcelReader;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.roadbridge.vo.*;
import com.ejianc.business.targetcost.vo.ImportErrorVo;
import com.ejianc.business.targetcost.vo.ImportVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 路桥-目标责任成本
 *
 * @author generator
 *
 */
@Service("roadbridgeDutyService")
public class RoadbridgeDutyServiceImpl extends BaseServiceImpl<RoadbridgeDutyMapper, RoadbridgeDutyEntity> implements IRoadbridgeDutyService{

    private static final String BILL_CODE = "ROADBRIDGE";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IRoadbridgeDutyService roadbridgeDutyService;

    @Autowired
    private IDutyEquipmentService dutyEquipmentService;

    @Autowired
    private IDutyJjfService dutyJjfService;

    @Autowired
    private IDutyMaterialService dutyMaterialService;

    @Autowired
    private IDutyOneService dutyOneService;

    @Autowired
    private IDutyOtherService dutyOtherService;

    @Autowired
    private IDutyPlansService dutyPlansService;

    @Autowired
    private IDutyRmatService dutyRmatService;

    @Autowired
    private IDutyTwoService dutyTwoService;

    @Autowired
    private IDutyUsenumService dutyUsenumService;

    @Autowired
    private IDutyService dutyService;


    @Override
    public CommonResponse<RoadbridgeDutyVO> saveOrUpdate(RoadbridgeDutyVO saveOrUpdateVO) {
        RoadbridgeDutyEntity entity = BeanMapper.map(saveOrUpdateVO, RoadbridgeDutyEntity.class);
        //变更单保存  校验该baseDutyId在责任成本中是否也存在未生效变更
        if(entity.getLastDutyId()!=null){
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getFirstImportId, entity.getBaseDutyId());
            queryWrapper.isNotNull(DutyEntity::getLastDutyId);
            queryWrapper.notIn(DutyEntity::getBillState, "1,3");
            if (dutyService.count(queryWrapper) > 0) {
                throw new BusinessException("该单据存在变更中的【目标责任成本】单，不允许新增变更！");
            }
        }
        if(entity.getId() == null || entity.getId() == 0){
            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(null==entity.getDutyVersion()){
            entity.setDutyVersion(1);
        }
        entity.setConvertFlag(0);
        super.saveOrUpdate(entity, false);


        //更新实体

        if(entity.getBaseDutyId()==null&&0==entity.getChangeState()){
            entity.setBaseDutyId(entity.getId());
            entity.setOneTime(entity.getCreateTime());
        }
        //变更单保存
        if(entity.getLastDutyId()!=null){
            RoadbridgeDutyEntity revise = super.getById(entity.getLastDutyId());
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.变更中.getCode());
            super.saveOrUpdate(revise);
        }

        if(CollectionUtils.isNotEmpty(entity.getDutyOneList())){
            //说明有子表信息，不是第一次点下一步保存   需要重新计算 计划汇总表
            RoadbridgeDutyVO roadbridgeDutyVO = BeanMapper.map(entity, RoadbridgeDutyVO.class);
            List<DutyPlansEntity> dutyPlansEntityList = SumPlanDetail(roadbridgeDutyVO);
            if(CollectionUtils.isNotEmpty(dutyPlansEntityList)){
                dutyPlansService.remove(new QueryWrapper<DutyPlansEntity>().eq("duty_id", entity.getId()));
                dutyPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
//                entity.setDutyPlansList(dutyPlansEntityList);
                DutyPlansEntity plansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size()-1);
                DutyPlansEntity lastPlansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size()-2);
                entity.setTaxMny(plansEntity.getPlansPlanMny());
                entity.setMny(plansEntity.getPlansPlanMny().subtract(lastPlansEntity.getPlansPlanMny()));
            }
        }
        super.updateById(entity);
        //维护父子级关系
        Map<Long,Long> idMap=new HashMap<>();
        List<DutyTwoEntity> dutyTwoEntities = entity.getDutyTwoList();
        if(CollectionUtils.isNotEmpty(dutyTwoEntities)){
            for(DutyTwoEntity twoEntity:dutyTwoEntities){
                idMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(DutyTwoEntity cdEntity:dutyTwoEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            dutyTwoService.saveOrUpdateBatch(dutyTwoEntities,dutyTwoEntities.size(),false);
        }

//        Map<Long,Long> rmatMap=new HashMap<>();
//        List<DutyRmatEntity> dutyRmatEntities = entity.getDutyRmatList();
//        if(CollectionUtils.isNotEmpty(dutyRmatEntities)){
//            for(DutyRmatEntity rmatEntity:dutyRmatEntities){
//                rmatMap.put(rmatEntity.getTid(),rmatEntity.getId());
//            }
//            for(DutyRmatEntity cdEntity:dutyRmatEntities){
//                if(null!=cdEntity.getParentId()){
//                    cdEntity.setParentId(rmatMap.get(cdEntity.getParentId()));
//                }
//                cdEntity.setTid(cdEntity.getId());
//            }
//            dutyRmatService.saveOrUpdateBatch(dutyRmatEntities,dutyRmatEntities.size(),false);
//        }

        RoadbridgeDutyVO vo = queryDetail(entity.getId());
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long dutyId = null;
        if (StringUtils.isNotEmpty(request.getParameter("dutyId"))) {
            dutyId = Long.valueOf(request.getParameter("dutyId"));
        } else {
            return CommonResponse.error("主表主键为空！");
        }
        RoadbridgeDutyEntity roadbridgeDutyEntity = roadbridgeDutyService.selectById(dutyId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
//            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
//            if (size == null || size != 9) {
//                return CommonResponse.error("文件页签数应该为9个，请检查是否有隐藏页签！");
//            }
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result0 = resList.get(0);
//            if (result0.size() > 0 && result0.get(0).size() < 16) {
//                return CommonResponse.error("[成本计划汇总表]数据不完整，请下载最新模板！");
//            }

            List<List<String>> result1 = resList.get(2);
            if (result1.size() > 0 && result1.get(0).size() < 16) {
                return CommonResponse.error("[100章目标成本计划表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result2 = resList.get(3);
            if (result2.size() > 0 && result2.get(0).size() < 23) {
                return CommonResponse.error("[200-1300章费用构成分析]数据不完整，请下载最新模板！");
            }
            List<List<String>> result3 = resList.get(4);
            if (result3.size() > 0 && result3.get(0).size() < 8) {
                return CommonResponse.error("[主要材料汇总表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result4 = resList.get(5);
            if (result4.size() > 0 && result4.get(0).size() < 13) {
                return CommonResponse.error("[周转材料费]数据不完整，请下载最新模板！");
            }

            List<List<String>> result5 = resList.get(6);
            if (result5.size() > 0 && result5.get(0).size() < 13) {
                return CommonResponse.error("[机械设备费用]数据不完整，请下载最新模板！");
            }

            List<List<String>> result6 = resList.get(7);
            if (result6.size() > 0 && result6.get(0).size() < 5) {
                return CommonResponse.error("[间接费]数据不完整，请下载最新模板！");
            }

            List<List<String>> result7 = resList.get(8);
            if (result7.size() > 0 && result7.get(0).size() < 9) {
                return CommonResponse.error("[其它工程费]数据不完整，请下载最新模板！");
            }

//            List<List<String>> result8 = resList.get(8);
//            if (result8.size() > 0 && result8.get(0).size() < 9) {
//                return CommonResponse.error("[主要材料用量表]数据不完整，请下载最新模板！");
//            }
//            ImportVo importVo0 = excelImportOne(result0, dutyId);//汇总
            ImportVo importVo1 = excelImportOne(result1, dutyId);//100章
            ImportVo importVo2 = excelImportTwo(result2, dutyId);//200章
            ImportVo importVo3 = excelImportMaterial(result3, dutyId);//主要材料
            ImportVo importVo4 = excelImportRmat(result4, dutyId);//周转材
            ImportVo importVo5 = excelImportEquipment(result5, dutyId);//机械设备
            ImportVo importVo6 = excelImportJjf(result6, dutyId);//间接费
            ImportVo importVo7 = excelImportOther(result7, dutyId);//其他工程费
            ImportVo importVo8 = excelImportUsenum(result0, dutyId);//主要材料用量

            List<ImportErrorVo> errorList = new ArrayList<>();
//            errorList.addAll(importVo0.getErrorList());
            errorList.addAll(importVo1.getErrorList());
            errorList.addAll(importVo2.getErrorList());
            errorList.addAll(importVo3.getErrorList());
            errorList.addAll(importVo4.getErrorList());
            errorList.addAll(importVo5.getErrorList());
            errorList.addAll(importVo6.getErrorList());
            errorList.addAll(importVo7.getErrorList());
            errorList.addAll(importVo8.getErrorList());

            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", 0);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                List<DutyOneVO> dutyOneList = importVo1.getDutyOneList(); // 路桥-目标成本-100章
                List<DutyTwoVO> dutyTwoList = importVo2.getDutyTwoList(); // 路桥-目标成本-200章
                List<DutyMaterialVO> dutyMaterialList = importVo3.getDutyMaterialList(); // 路桥-目标成本-主要材料费
                List<DutyRmatVO> dutyRmatList = importVo4.getDutyRmatList(); // 路桥-目标成本-周转材料费
                List<DutyEquipmentVO> dutyEquipmentList = importVo5.getDutyEquipmentList(); // 路桥-目标成本-机械设备费
                List<DutyJjfVO> dutyJjfList = importVo6.getDutyJjfList(); // 路桥-目标成本-间接费
                List<DutyOtherVO> dutyOtherList = importVo7.getDutyOtherList(); // 路桥-目标成本-其他工程费
                List<DutyUsenumVO> dutyUsenumList = importVo8.getDutyUsenumList(); // 路桥-目标成本-主要材料用量表

                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", dutyOneList.size() + dutyMaterialList.size() + dutyRmatList.size() + dutyEquipmentList.size()+ dutyJjfList.size()+ dutyOtherList.size()+ dutyUsenumList.size());
                resp.put("errorNum", 0);

                dutyOneService.remove(new QueryWrapper<DutyOneEntity>().eq("duty_id", dutyId));
                if (dutyOneList.size() > 0) {
                    List<DutyOneEntity> dutyOneListEntities = BeanMapper.mapList(dutyOneList, DutyOneEntity.class);
                    dutyOneService.saveOrUpdateBatch(dutyOneListEntities, dutyOneListEntities.size(), false);
                }

                dutyTwoService.remove(new QueryWrapper<DutyTwoEntity>().eq("duty_id", dutyId));
                if (dutyTwoList.size() > 0) {
                    List<DutyTwoEntity> dutyTwoListEntities = BeanMapper.mapList(dutyTwoList, DutyTwoEntity.class);
                    dutyTwoService.saveOrUpdateBatch(dutyTwoListEntities, dutyTwoListEntities.size(), false);
                }

                dutyMaterialService.remove(new QueryWrapper<DutyMaterialEntity>().eq("duty_id", dutyId));
                if (dutyMaterialList.size() > 0) {
                    List<DutyMaterialEntity> dutyMaterialListEntities = BeanMapper.mapList(dutyMaterialList, DutyMaterialEntity.class);
                    dutyMaterialService.saveOrUpdateBatch(dutyMaterialListEntities, dutyMaterialListEntities.size(), false);
                }

                dutyRmatService.remove(new QueryWrapper<DutyRmatEntity>().eq("duty_id", dutyId));
                if (dutyRmatList.size() > 0) {
                    List<DutyRmatEntity> dutyRmatListEntities = BeanMapper.mapList(dutyRmatList, DutyRmatEntity.class);
                    dutyRmatService.saveOrUpdateBatch(dutyRmatListEntities, dutyRmatListEntities.size(), false);
                }

                dutyEquipmentService.remove(new QueryWrapper<DutyEquipmentEntity>().eq("duty_id", dutyId));
                if (dutyEquipmentList.size() > 0) {
                    List<DutyEquipmentEntity> dutyEquipmentListEntities = BeanMapper.mapList(dutyEquipmentList, DutyEquipmentEntity.class);
                    dutyEquipmentService.saveOrUpdateBatch(dutyEquipmentListEntities, dutyEquipmentListEntities.size(), false);
                }

                dutyJjfService.remove(new QueryWrapper<DutyJjfEntity>().eq("duty_id", dutyId));
                if (dutyJjfList.size() > 0) {
                    List<DutyJjfEntity> dutyJjfListEntities = BeanMapper.mapList(dutyJjfList, DutyJjfEntity.class);
                    dutyJjfService.saveOrUpdateBatch(dutyJjfListEntities, dutyJjfListEntities.size(), false);
                }

                dutyOtherService.remove(new QueryWrapper<DutyOtherEntity>().eq("duty_id", dutyId));
                if (dutyOtherList.size() > 0) {
                    List<DutyOtherEntity> dutyOtherListEntities = BeanMapper.mapList(dutyOtherList, DutyOtherEntity.class);
                    dutyOtherService.saveOrUpdateBatch(dutyOtherListEntities, dutyOtherListEntities.size(), false);
                }

                dutyUsenumService.remove(new QueryWrapper<DutyUsenumEntity>().eq("duty_id", dutyId));
                if (dutyUsenumList.size() > 0) {
                    List<DutyUsenumEntity> dutyUsenumListEntities = BeanMapper.mapList(dutyUsenumList, DutyUsenumEntity.class);
                    dutyUsenumService.saveOrUpdateBatch(dutyUsenumListEntities, dutyUsenumListEntities.size(), false);
                }

                //生成汇总表
                RoadbridgeDutyVO roadbridgeDutyVO = BeanMapper.map(roadbridgeDutyEntity,RoadbridgeDutyVO.class);
                roadbridgeDutyVO.setDutyOneList(dutyOneList);
                roadbridgeDutyVO.setDutyTwoList(dutyTwoList);
                roadbridgeDutyVO.setDutyMaterialList(dutyMaterialList);
                roadbridgeDutyVO.setDutyRmatList(dutyRmatList);
                roadbridgeDutyVO.setDutyEquipmentList(dutyEquipmentList);
                roadbridgeDutyVO.setDutyOtherList(dutyOtherList);
                roadbridgeDutyVO.setDutyJjfList(dutyJjfList);

                List<DutyPlansEntity> dutyPlansEntityList = SumPlanDetail(roadbridgeDutyVO);
                dutyPlansService.remove(new QueryWrapper<DutyPlansEntity>().eq("duty_id", dutyId));
                if(CollectionUtils.isNotEmpty(dutyPlansEntityList)){
//                    List<DutyPlansEntity> dutyUsenumListEntities = BeanMapper.mapList(dutyPlansEntityList, DutyPlansEntity.class);
                    dutyPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
                    DutyPlansEntity plansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size()-1);
                    DutyPlansEntity lastPlansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size()-2);
                    roadbridgeDutyEntity.setProjectProfile(result0.get(0).get(1));
                    roadbridgeDutyEntity.setTaxMny(plansEntity.getPlansPlanMny());
                    roadbridgeDutyEntity.setMny(plansEntity.getPlansPlanMny().subtract(lastPlansEntity.getPlansPlanMny()));
                    roadbridgeDutyEntity.setConvertFlag(0);//设置未转换
                    roadbridgeDutyService.updateById(roadbridgeDutyEntity);
                }
            }
            return CommonResponse.success(resp);
        }
    }

    @Override
    public RoadbridgeDutyVO queryDetail(Long id) {
        RoadbridgeDutyEntity entity = super.selectById(id);
        RoadbridgeDutyVO vo = BeanMapper.map(entity, RoadbridgeDutyVO.class);
//        List<DutyRmatVO> rmatVOList = vo.getDutyRmatList();
//        vo.setDutyRmatList(TreeNodeBUtil.buildTree(rmatVOList));
        List<DutyTwoVO> twoVOList = vo.getDutyTwoList();
        vo.setDutyTwoList(TreeNodeBUtil.buildTree(twoVOList));

        List<RoadbridgeDutyRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<RoadbridgeDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RoadbridgeDutyEntity::getBaseDutyId, entity.getBaseDutyId());
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(RoadbridgeDutyEntity::getBillState,billStatusList);
        queryWrapper.ne(RoadbridgeDutyEntity::getId, id);
        queryWrapper.orderByAsc(RoadbridgeDutyEntity::getCreateTime);
        List<RoadbridgeDutyEntity> roadbridgeDutyEntities = super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(roadbridgeDutyEntities)){
            list = BeanMapper.mapList(roadbridgeDutyEntities,RoadbridgeDutyRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public RoadbridgeDutyVO queryChangeDetail(Long id) {
        RoadbridgeDutyEntity entity = super.selectById(id);
        RoadbridgeDutyVO vo = BeanMapper.map(entity, RoadbridgeDutyVO.class);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
//        vo.setMny(null);
//        vo.setTaxMny(null);
        vo.setBeforeDutyVersion(vo.getDutyVersion()-1);

        List<DutyPlansVO> dutyPlansList = vo.getDutyPlansList();
        if(CollectionUtils.isNotEmpty(dutyPlansList)){
            dutyPlansList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyPlansList(dutyPlansList);
        }

        List<DutyOneVO> dutyOneList = vo.getDutyOneList();
        if(CollectionUtils.isNotEmpty(dutyOneList)){
            dutyOneList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyOneList(dutyOneList);
        }

        List<DutyTwoVO> dutyTwoList = vo.getDutyTwoList();
        if(CollectionUtils.isNotEmpty(dutyTwoList)){
            Map<Long,Long> idMap=new HashMap<>();
            dutyTwoList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(DutyTwoVO cdEntity : dutyTwoList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setDutyTwoList(TreeNodeBUtil.buildTree(dutyTwoList));
        }

        List<DutyMaterialVO> dutyMaterialList = vo.getDutyMaterialList();
        if(CollectionUtils.isNotEmpty(dutyMaterialList)){
            dutyMaterialList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyMaterialList(dutyMaterialList);
        }

        List<DutyRmatVO> dutyRmatList = vo.getDutyRmatList();
        if(CollectionUtils.isNotEmpty(dutyRmatList)){
//            Map<Long,Long> idMap=new HashMap<>();
            dutyRmatList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
//                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
//                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
//            for(DutyRmatVO cdEntity : dutyRmatList){
//                if(null!=cdEntity.getParentId()){
//                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
//                }
//                cdEntity.setTid(cdEntity.getId());
//            }
//            vo.setDutyRmatList(TreeNodeBUtil.buildTree(dutyRmatList));
            vo.setDutyRmatList(dutyRmatList);
        }

        List<DutyEquipmentVO> dutyEquipmentList = vo.getDutyEquipmentList();
        if(CollectionUtils.isNotEmpty(dutyEquipmentList)){
            dutyEquipmentList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyEquipmentList(dutyEquipmentList);
        }

        List<DutyJjfVO> dutyJjfList = vo.getDutyJjfList();
        if(CollectionUtils.isNotEmpty(dutyJjfList)){
            dutyJjfList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyJjfList(dutyJjfList);
        }

        List<DutyOtherVO> dutyOtherList = vo.getDutyOtherList();
        if(CollectionUtils.isNotEmpty(dutyOtherList)){
            dutyOtherList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyOtherList(dutyOtherList);
        }

        List<DutyUsenumVO> dutyUsenumList = vo.getDutyUsenumList();
        if(CollectionUtils.isNotEmpty(dutyUsenumList)){
            dutyUsenumList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setDutyUsenumList(dutyUsenumList);
        }
        return vo;
    }

    @Override
    public RoadbridgeDutyVO ConvertFlag(Long id) {
        RoadbridgeDutyEntity entity = super.selectById(id);
        entity.setConvertFlag(1);
        super.updateById(entity);
        RoadbridgeDutyVO vo = BeanMapper.map(entity, RoadbridgeDutyVO.class);
        dutyService.pushFromImport(vo,false, ConversionEnum.云南路桥.getCode());
//        List<DutyRmatVO> rmatVOList = vo.getDutyRmatList();
//        vo.setDutyRmatList(TreeNodeBUtil.buildTree(rmatVOList));
        List<DutyTwoVO> twoVOList = vo.getDutyTwoList();
        vo.setDutyTwoList(TreeNodeBUtil.buildTree(twoVOList));
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<RoadbridgeDutyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for(RoadbridgeDutyVO dutyVO : vos){
                RoadbridgeDutyEntity dutyEntity = super.getById(dutyVO.getId());
                if(dutyEntity.getLastDutyId()!=null){
                    RoadbridgeDutyEntity revise = super.getById(dutyEntity.getLastDutyId());
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.未变更.getCode());
                    revise.setLatestFlag(true);
                    super.saveOrUpdate(revise);
                }

                //删除转换的数据
                dutyService.deleteFromImport(dutyVO.getId(),ConversionEnum.云南路桥.getCode());
            }
        }
        super.removeByIds(vos.stream().map(RoadbridgeDutyVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }

    private ImportVo excelImportOne(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyOneVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-1; i++) {
                List<String> datas = result.get(i);
                DutyOneVO vo = new DutyOneVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);// 子目号
                String oneDetailName = datas.get(1);// 子目名称
                String oneUnitName = datas.get(2);// 单位
                String oneNum = datas.get(3);// 数量
                String oneMny = datas.get(4);// 不含税控制价
                String oneSumMny = datas.get(5);// 不含税合价
                String oneRate = datas.get(6);// 增值税率(%)
                String oneRgMny = datas.get(7);// 人工费
                String oneMaterialMny = datas.get(8); // 材料费
                String oneJxMny = datas.get(9);// 机械费
                String oneSubMny = datas.get(10);// 专业分包
                String oneOtherMny = datas.get(11);// 其他费用
                String oneDutyMny = datas.get(12);// 目标成本合价
                String oneDownMny = datas.get(13);// 降低额
                String oneDownRate = datas.get(14);// 降低率
                String oneMemo = datas.get(15);// 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);

                Boolean oneMnyFlag = false;
                if(StringUtils.isNotEmpty(oneMny)){
                    if(BigDecimal.ZERO.compareTo(new BigDecimal(oneMny))==0){
                        oneMnyFlag = true;
                    }
                }

                Boolean oneSumMnyFlag = false;
                if(StringUtils.isNotEmpty(oneSumMny)){
                    if(BigDecimal.ZERO.compareTo(new BigDecimal(oneSumMny))==0){
                        oneSumMnyFlag = true;
                    }
                }

                Boolean oneDutyMnyFlag = false;
                if(StringUtils.isNotEmpty(oneDutyMny)){
                    if(BigDecimal.ZERO.compareTo(new BigDecimal(oneDutyMny))==0){
                        oneDutyMnyFlag = true;
                    }
                }
                //只导入【不含税控制价】【不含税合价】【目标成本合价】不全部为空、不全部为0的数据行；
                if((StringUtils.isEmpty(oneMny)||oneMnyFlag)&&(StringUtils.isEmpty(oneSumMny)||oneSumMnyFlag)&&(StringUtils.isEmpty(oneDutyMny)||oneDutyMnyFlag)){
                    continue;
                }

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setOneDetailCode(indexCode);
                    parentMap.put(indexCode, id);
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[子目号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setOneDetailCode(null);
                    warnType = warnType + "[子目号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(oneDetailName)) {// 编码为空
                    vo.setOneDetailName(null);
                    warnType = warnType + "[子目名称为空]";
                    flag = true;
                } else {
                    vo.setOneDetailName(oneDetailName);
                }
                vo.setOneUnitName(oneUnitName);

                if (StringUtils.isEmpty(oneNum)) {
                    vo.setOneNum(null);
                } else {
                    try {
                        vo.setOneNum(new BigDecimal(oneNum));
                    } catch (Exception e) {
                        vo.setOneNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneMny)) {
                    vo.setOneMny(null);
                } else {
                    try {
                        vo.setOneMny(new BigDecimal(oneMny));
                    } catch (Exception e) {
                        vo.setOneMny(null);
                        warnType = warnType + "[不含税控制价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneSumMny)) {
                    vo.setOneSumMny(null);
                } else {
                    try {
                        vo.setOneSumMny(new BigDecimal(oneSumMny));
                    } catch (Exception e) {
                        vo.setOneSumMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneRate)) {
                    vo.setOneRate(null);
                } else {
                    try {
                        vo.setOneRate(new BigDecimal(oneRate).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setOneRate(null);
                        warnType = warnType + "[增值税率只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneRgMny)) {
                    vo.setOneRgMny(null);
                } else {
                    try {
                        vo.setOneRgMny(new BigDecimal(oneRgMny));
                    } catch (Exception e) {
                        vo.setOneRgMny(null);
                        warnType = warnType + "[人工费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneMaterialMny)) {
                    vo.setOneMaterialMny(null);
                } else {
                    try {
                        vo.setOneMaterialMny(new BigDecimal(oneMaterialMny));
                    } catch (Exception e) {
                        vo.setOneMaterialMny(null);
                        warnType = warnType + "[材料费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneJxMny)) {
                    vo.setOneJxMny(null);
                } else {
                    try {
                        vo.setOneJxMny(new BigDecimal(oneJxMny));
                    } catch (Exception e) {
                        vo.setOneJxMny(null);
                        warnType = warnType + "[机械费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneSubMny)) {
                    vo.setOneSubMny(null);
                } else {
                    try {
                        vo.setOneSubMny(new BigDecimal(oneSubMny));
                    } catch (Exception e) {
                        vo.setOneSubMny(null);
                        warnType = warnType + "[专业分包只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneOtherMny)) {
                    vo.setOneOtherMny(null);
                } else {
                    try {
                        vo.setOneOtherMny(new BigDecimal(oneOtherMny));
                    } catch (Exception e) {
                        vo.setOneOtherMny(null);
                        warnType = warnType + "[其他费用只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneDutyMny)) {
                    vo.setOneDutyMny(null);
                } else {
                    try {
                        vo.setOneDutyMny(new BigDecimal(oneDutyMny));
                    } catch (Exception e) {
                        vo.setOneDutyMny(null);
                        warnType = warnType + "[目标成本合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneDownMny)) {
                    vo.setOneDownMny(null);
                } else {
                    try {
                        vo.setOneDownMny(new BigDecimal(oneDownMny));
                    } catch (Exception e) {
                        vo.setOneDownMny(null);
                        warnType = warnType + "[降低额只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(oneDownRate)) {
                    vo.setOneDownRate(null);
                } else {
                    try {
                        vo.setOneDownRate(new BigDecimal(oneDownRate).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setOneDownRate(null);
                        warnType = warnType + "[降低率只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setOneMemo(oneMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyOneVO> successList = new ArrayList<>();
            for (DutyOneVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("100章目标成本计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getOneDetailCode());
                    errorVo.setCode(vo.getOneDetailCode());
                    errorVo.setName(vo.getOneDetailName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyOneList(successList);
        }
        return res;
    }

    private ImportVo excelImportTwo(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size()-2 > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyTwoVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                DutyTwoVO vo = new DutyTwoVO();
                boolean flag = false;
                String warnType = "";

                String twoDetailCode = datas.get(0);//子目号
                String twoDetailName = datas.get(1);//子目名称
                String twoUnitName = datas.get(2);//单位
                String twoNum = datas.get(3);//数量
                String twoMny = datas.get(4);//不含税控制价
                String twoSumMny = datas.get(5);//不含税合价
                String twoRgPrice = datas.get(6);//人工费
                String twoJxPrice = datas.get(7);//机械费
                String twoMaterialPrice = datas.get(8);//主要材料费
                String twoRate = datas.get(9);//材料耗损率(%)
                String twoNoPrice = datas.get(10);//计价不计量材料费
                String twoSubPrice = datas.get(11);//专业分包
                String twoDutyPrice = datas.get(12);//综合单价
                String twoRgMny = datas.get(13);//人工费
                String twoJxMny = datas.get(14);//机械费
                String twoMaterialMny = datas.get(15);//材料费
                String twoNoMny = datas.get(16);//计价不计量材料费
                String twoSubMny = datas.get(17);//专业分包
                String twoDutyMny = datas.get(19);//目标成本综合合价
                String twoDownMny = datas.get(20);//降低额
                String twoDownRate = datas.get(21);//降低率
                String twoMemo = datas.get(22);//备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(twoDetailCode)) {//序号不为空
                    twoDetailCode = twoDetailCode.trim();// 去除导入时树形编码空格
                    vo.setTwoDetailCode(twoDetailCode);
                    parentMap.put(twoDetailCode, id);
                    if (detailIndexList.contains(twoDetailCode)) {
                        warnType = warnType + "[子目号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(twoDetailCode);
                    }
                } else {
                    vo.setTwoDetailCode(null);
                    warnType = warnType + "[子目号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(twoDetailName)) {//名称为空
                    vo.setTwoDetailName(null);
                    warnType = warnType + "[子目名称为空]";
                    flag = true;
                } else {
                    vo.setTwoDetailName(twoDetailName);
                }

                vo.setTwoUnitName(twoUnitName);

                if (StringUtils.isEmpty(twoNum)) {
                    vo.setTwoNum(null);
                } else {
                    try {
                        vo.setTwoNum(new BigDecimal(twoNum));
                    } catch (Exception e) {
                        vo.setTwoNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoMny)) {
                    vo.setTwoMny(null);
                } else {
                    try {
                        vo.setTwoMny(new BigDecimal(twoMny));
                    } catch (Exception e) {
                        vo.setTwoMny(null);
                        warnType = warnType + "[不含税控制价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoSumMny)) {
                    vo.setTwoSumMny(null);
                } else {
                    try {
                        vo.setTwoSumMny(new BigDecimal(twoSumMny));
                    } catch (Exception e) {
                        vo.setTwoSumMny(null);
                        warnType = warnType + "[不含税合价 只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoRgPrice)) {
                    vo.setTwoRgPrice(null);
                } else {
                    try {
                        vo.setTwoRgPrice(new BigDecimal(twoRgPrice));
                    } catch (Exception e) {
                        vo.setTwoRgPrice(null);
                        warnType = warnType + "[单价-人工费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoJxPrice)) {
                    vo.setTwoJxPrice(null);
                } else {
                    try {
                        vo.setTwoJxPrice(new BigDecimal(twoJxPrice));
                    } catch (Exception e) {
                        vo.setTwoJxPrice(null);
                        warnType = warnType + "[单价-机械费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoMaterialPrice)) {
                    vo.setTwoMaterialPrice(null);
                } else {
                    try {
                        vo.setTwoMaterialPrice(new BigDecimal(twoMaterialPrice));
                    } catch (Exception e) {
                        vo.setTwoMaterialPrice(null);
                        warnType = warnType + "[单价-主要材料费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoRate)) {
                    vo.setTwoRate(null);
                } else {
                    try {
                        vo.setTwoRate(new BigDecimal(twoRate).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setTwoRate(null);
                        warnType = warnType + "[材料耗损率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoNoPrice)) {
                    vo.setTwoNoPrice(null);
                } else {
                    try {
                        vo.setTwoNoPrice(new BigDecimal(twoNoPrice));
                    } catch (Exception e) {
                        vo.setTwoNoPrice(null);
                        warnType = warnType + "[计价不计量材料费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoSubPrice)) {
                    vo.setTwoSubPrice(null);
                } else {
                    try {
                        vo.setTwoSubPrice(new BigDecimal(twoSubPrice));
                    } catch (Exception e) {
                        vo.setTwoSubPrice(null);
                        warnType = warnType + "[单价-专业分包只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoDutyPrice)) {
                    vo.setTwoDutyPrice(null);
                } else {
                    try {
                        vo.setTwoDutyPrice(new BigDecimal(twoDutyPrice));
                    } catch (Exception e) {
                        vo.setTwoDutyPrice(null);
                        warnType = warnType + "[单价-综合单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoRgMny)) {
                    vo.setTwoRgMny(null);
                } else {
                    try {
                        vo.setTwoRgMny(new BigDecimal(twoRgMny));
                    } catch (Exception e) {
                        vo.setTwoRgMny(null);
                        warnType = warnType + "[合价-人工费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoJxMny)) {
                    vo.setTwoJxMny(null);
                } else {
                    try {
                        vo.setTwoJxMny(new BigDecimal(twoJxMny));
                    } catch (Exception e) {
                        vo.setTwoJxMny(null);
                        warnType = warnType + "[合价-机械费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoMaterialMny)) {
                    vo.setTwoMaterialMny(null);
                } else {
                    try {
                        vo.setTwoMaterialMny(new BigDecimal(twoMaterialMny));
                    } catch (Exception e) {
                        vo.setTwoMaterialMny(null);
                        warnType = warnType + "[合价-主要材料费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoNoMny)) {
                    vo.setTwoNoMny(null);
                } else {
                    try {
                        vo.setTwoNoMny(new BigDecimal(twoNoMny));
                    } catch (Exception e) {
                        vo.setTwoNoMny(null);
                        warnType = warnType + "[合价-计价不计量材料费只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoSubMny)) {
                    vo.setTwoSubMny(null);
                } else {
                    try {
                        vo.setTwoSubMny(new BigDecimal(twoSubMny));
                    } catch (Exception e) {
                        vo.setTwoSubMny(null);
                        warnType = warnType + "[合价-专业分包只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoDutyMny)) {
                    vo.setTwoDutyMny(null);
                } else {
                    try {
                        vo.setTwoDutyMny(new BigDecimal(twoDutyMny));
                    } catch (Exception e) {
                        vo.setTwoDutyMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(twoDownMny)) {
                    vo.setTwoDownMny(null);
                } else {
                    try {
                        vo.setTwoDownMny(new BigDecimal(twoDownMny));
                    } catch (Exception e) {
                        vo.setTwoDownMny(null);
                        warnType = warnType + "[降低额只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(twoDownRate)) {
                    vo.setTwoDownRate(null);
                } else {
                    try {
                        vo.setTwoDownRate(new BigDecimal(twoDownRate).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setTwoDownRate(null);
                        warnType = warnType + "[降低率只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setTwoMemo(twoMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyTwoVO> successList = new ArrayList<>();
            Map<String,Integer> map = new HashedMap();
            for(int i=0;i<detailVoList.size();i++){
                map.put(detailVoList.get(i).getTwoDetailCode(),i);
            }
            Map<Long,Long> idsMap = new HashMap<>();
            for(int i=0;i<detailVoList.size();i++){
                DutyTwoVO vo = detailVoList.get(i);
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String twoDetailCode = vo.getTwoDetailCode();//子目号
                        //取父级的code
                        if(checkcountname(twoDetailCode)){
                            //说明是一级
                            vo.setParentId(null);
                        }else {
                            // 找上一条数据 对应的id
                            DutyTwoVO upVo = getUpVo(twoDetailCode,twoDetailCode,detailVoList,map);
                            vo.setParentId(upVo.getId());
                        }
                        successList.add(vo);
                        Long pid = vo.getParentId()==null?999L:vo.getParentId();
                        if(!idsMap.containsKey(pid)){
                            idsMap.put(pid,vo.getId());
                        }
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("200-1300章费用构成分析");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getTwoDetailCode());
                    errorVo.setCode(vo.getTwoDetailCode());
                    errorVo.setName(vo.getTwoDetailName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            //处理是否末级
            for(DutyTwoVO vo:successList ){
                if(idsMap.containsKey(vo.getId())){
                    vo.setLeafFlag(false);
                }else{
                    vo.setLeafFlag(true);
                }
            }
            res.setDutyTwoList(successList);
        }
        return res;
    }

    private ImportVo excelImportMaterial(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyMaterialVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-1; i++) {
                List<String> datas = result.get(i);
                DutyMaterialVO vo = new DutyMaterialVO();
                boolean flag = false;
                String warnType = "";

                String materialCode = datas.get(1);// 物料编码
                String materialName = datas.get(2);// 物料名称
                String materialUnitName = datas.get(3);// 单位
                String materialNum = datas.get(4);// 数量
                String materialPrice = datas.get(5);// 单价
                String materialMny = datas.get(6);// 合价
                String materialMemo = datas.get(7);// 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                vo.setMaterialMemo(materialMemo);

                if (StringUtils.isEmpty(materialCode)) {
                    vo.setMaterialCode(null);
                } else {
                    vo.setMaterialCode(materialCode);
                }

//                if (StringUtils.isNotEmpty(materialCode)) {//序号不为空
//                    materialCode = materialCode.trim();// 去除导入时树形编码空格
//                    vo.setMaterialCode(materialCode);
//                    parentMap.put(materialCode, id);
//                    if (detailIndexList.contains(materialCode)) {
//                        warnType = warnType + "[物料编码重复]";
//                        flag = true;
//                    } else {
//                        detailIndexList.add(materialCode);
//                    }
//                } else {
//                    vo.setMaterialCode(null);
//                    warnType = warnType + "[物料编码为空]";
//                    flag = true;
//                }

                if (StringUtils.isEmpty(materialName)) {
                    vo.setMaterialName(null);
                    warnType = warnType + "[主要材料为空]";
                    flag = true;
                } else {
                    vo.setMaterialName(materialName);
                }
                vo.setMaterialUnitName(materialUnitName);

                if (StringUtils.isEmpty(materialNum)) {
                    vo.setMaterialNum(null);
                } else {
                    try {
                        vo.setMaterialNum(new BigDecimal(materialNum));
                    } catch (Exception e) {
                        vo.setMaterialNum(null);
                        warnType = warnType + "[应耗数量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialPrice)) {
                    vo.setMaterialPrice(null);
                } else {
                    try {
                        vo.setMaterialPrice(new BigDecimal(materialPrice));
                    } catch (Exception e) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "[不含税材料单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialMny)) {
                    vo.setMaterialMny(null);
                } else {
                    try {
                        vo.setMaterialMny(new BigDecimal(materialMny));
                    } catch (Exception e) {
                        vo.setMaterialMny(null);
                        warnType = warnType + "[不含税材料合价只能为数字或小数]";
                        flag = true;
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyMaterialVO> successList = new ArrayList<>();
            for (DutyMaterialVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("主要材料汇总表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getMaterialCode());
                    errorVo.setCode(vo.getMaterialCode());
                    errorVo.setName(vo.getMaterialName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyMaterialList(successList);
        }
        return res;
    }

    private ImportVo excelImportRmat(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyRmatVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-1; i++) {
                List<String> datas = result.get(i);
                DutyRmatVO vo = new DutyRmatVO();
                boolean flag = false;
                String warnType = "";

//                String indexCode = datas.get(0);//序号
                String rmatCode = datas.get(1);//物料编码
                String rmatName = datas.get(2);//材料名称
                String rmatUnitName = datas.get(3);//单位
                String rmatNum = datas.get(4);//数量
                String rmatRentMonth = datas.get(5);//租用时间(月)
                String rmatPrice = datas.get(6);//单价-购买
//                String rmatPrice1 = datas.get(7);//单价-内转
                String rmatPrice2 = datas.get(8);//单价-租金(元/月）
                String rmatMny = datas.get(9);//合价
                String rmatCostScale = datas.get(10);//摊销比例（%)
                String rmatCostMny = datas.get(11);//分摊成本
                String rmatMemo = datas.get(12);//备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

//                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
//                    indexCode = indexCode.trim();// 去除导入时树形编码空格
//                    vo.setIndexCode(indexCode);
//                    vo.setTreeIndex(indexCode);
//                    parentMap.put(indexCode, id);
//                    String[] split = indexCode.split("[-/.]");
//                    if (split.length > 1) {
//                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
//                    }
////                    vo.setTreeIndex(i + "");
//                    if (detailIndexList.contains(indexCode)) {
//                        warnType = warnType + "[序号重复]";
//                        flag = true;
//                    } else {
//                        detailIndexList.add(indexCode);
//                    }
//                } else {
//                    vo.setIndexCode(null);
//                    warnType = warnType + "[序号为空]";
//                    flag = true;
//                }

                if (StringUtils.isEmpty(rmatCode)) {// 编码为空
                    vo.setRmatCode(null);
                } else {
                    vo.setRmatCode(rmatCode);
                }

                if (StringUtils.isEmpty(rmatName)) {//名称为空
                    vo.setRmatName(null);
                    warnType = warnType + "[材料名称为空]";
                    flag = true;
                } else {
                    vo.setRmatName(rmatName);
                }

                vo.setRmatUnitName(rmatUnitName);

                if (StringUtils.isEmpty(rmatNum)) {
                    vo.setRmatNum(null);
                } else {
                    try {
                        vo.setRmatNum(new BigDecimal(rmatNum));
                    } catch (Exception e) {
                        vo.setRmatNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatRentMonth)) {
                    vo.setRmatRentMonth(null);
                    if (StringUtils.isEmpty(rmatPrice)) {
                        vo.setRmatPrice(null);
                    } else {
                        try {
                            vo.setRmatPrice(new BigDecimal(rmatPrice));
                        } catch (Exception e) {
                            vo.setRmatPrice(null);
                            warnType = warnType + "[单价-购买 只能为数字或小数]";
                            flag = true;
                        }
                    }
                } else {
                    try {
                        vo.setRmatRentMonth(new BigDecimal(rmatRentMonth));
                        if (StringUtils.isEmpty(rmatPrice2)) {
                            vo.setRmatPrice(null);
                        } else {
                            try {
                                vo.setRmatPrice(new BigDecimal(rmatPrice2));
                            } catch (Exception e) {
                                vo.setRmatPrice(null);
                                warnType = warnType + "[单价-租金 只能为数字或小数]";
                                flag = true;
                            }
                        }
                    } catch (Exception e) {
                        vo.setRmatRentMonth(null);
                        vo.setRmatPrice(null);
                        warnType = warnType + "[租用时间(月)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatCostScale)) {
                    vo.setRmatCostScale(null);
                } else {
                    try {
                        vo.setRmatCostScale(new BigDecimal(rmatCostScale).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setRmatCostScale(null);
                        warnType = warnType + "[摊销比例只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatMny)) {
                    vo.setRmatMny(null);
                } else {
                    try {
                        vo.setRmatMny(new BigDecimal(rmatMny));
                    } catch (Exception e) {
                        vo.setRmatMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatCostMny)) {
                    vo.setRmatCostMny(null);
                } else {
                    try {
                        vo.setRmatCostMny(new BigDecimal(rmatCostMny));
                    } catch (Exception e) {
                        vo.setRmatCostMny(null);
                        warnType = warnType + "[摊销成本只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setRmatMemo(rmatMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyRmatVO> successList = new ArrayList<>();
            for (DutyRmatVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
//                        String indexCode = vo.getIndexCode();
//                        Boolean leafFlag = true;
//                        for (String code : detailIndexList) {
//                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
//                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
//                                if ("-/.".indexOf(sub) != -1) {
//                                    leafFlag = false;
//                                    break;
//                                }
//                            }
//                        }
//                        vo.setLeafFlag(leafFlag);//0-否，1-是
////                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("周转材料费");
                    errorVo.setId(vo.getId());
//                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getRmatCode());
                    errorVo.setName(vo.getRmatName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyRmatList(successList);
        }
        return res;
    }

    private ImportVo excelImportEquipment(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyEquipmentVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-1; i++) {
                List<String> datas = result.get(i);
                DutyEquipmentVO vo = new DutyEquipmentVO();
                boolean flag = false;
                String warnType = "";

                String equipmentCode = datas.get(1);// 设备编码
                String equipmentName = datas.get(2);// 设备名称
                String equipmentUnitName = datas.get(3);// 单位
                String equipmentNum = datas.get(4);// 数量
                String equipmentRentMonth = datas.get(5);// 租用时间(月)
                String equipmentPrice = datas.get(6);// 单价-购买
//                String equipmentPrice1 = datas.get(7);// 单价-内转
                String equipmentPrice2 = datas.get(8);// 单价-租金
                String equipmentCostScale = datas.get(9);// 摊销比例(%)
                String equipmentMny = datas.get(10);// 合价
                String equipmentCostMny = datas.get(11); // 分摊成本
                String equipmentMemo = datas.get(12);// 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isEmpty(equipmentCode)) {// 编码为空
                    vo.setEquipmentCode(null);
                } else {
                    vo.setEquipmentCode(equipmentCode);
                }

                if (StringUtils.isEmpty(equipmentName)) {// 编码为空
                    vo.setEquipmentName(null);
                    warnType = warnType + "[名称为空]";
                    flag = true;
                } else {
                    vo.setEquipmentName(equipmentName);
                }
                vo.setEquipmentUnitName(equipmentUnitName);

                if (StringUtils.isEmpty(equipmentNum)) {
                    vo.setEquipmentNum(null);
                } else {
                    try {
                        vo.setEquipmentNum(new BigDecimal(equipmentNum));
                    } catch (Exception e) {
                        vo.setEquipmentNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentRentMonth)) {
                    vo.setEquipmentRentMonth(null);
                    if (StringUtils.isEmpty(equipmentPrice)) {
                        vo.setEquipmentPrice(null);
                    } else {
                        try {
                            vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
                        } catch (Exception e) {
                            vo.setEquipmentPrice(null);
                            warnType = warnType + "[单价-购买 只能为数字或小数]";
                            flag = true;
                        }
                    }
                } else {
                    try {
                        vo.setEquipmentRentMonth(new BigDecimal(equipmentRentMonth));
                        if (StringUtils.isEmpty(equipmentPrice2)) {
                            vo.setEquipmentPrice(null);
                        } else {
                            try {
                                vo.setEquipmentPrice(new BigDecimal(equipmentPrice2));
                            } catch (Exception e) {
                                vo.setEquipmentPrice(null);
                                warnType = warnType + "[单价-租金 只能为数字或小数]";
                                flag = true;
                            }
                        }
                    } catch (Exception e) {
                        vo.setEquipmentRentMonth(null);
                        vo.setEquipmentPrice(null);
                        warnType = warnType + "[租用时间(月)只能为数字或小数]";
                        flag = true;
                    }
                }

//                if(null==vo.getEquipmentPrice()){
//
//                }

//                if (StringUtils.isEmpty(equipmentPrice)) {
//                    vo.setEquipmentPrice(null);
//                } else {
//                    try {
//                        vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
//                    } catch (Exception e) {
//                        vo.setEquipmentPrice(null);
//                        warnType = warnType + "[单价-购买 只能为数字或小数]";
//                        flag = true;
//                    }
//                }
//                if(null==vo.getEquipmentPrice()){
//                    if (StringUtils.isEmpty(equipmentPrice2)) {
//                        vo.setEquipmentPrice(null);
//                    } else {
//                        try {
//                            vo.setEquipmentPrice(new BigDecimal(equipmentPrice2));
//                        } catch (Exception e) {
//                            vo.setEquipmentPrice(null);
//                            warnType = warnType + "[单价-租金 只能为数字或小数]";
//                            flag = true;
//                        }
//                    }
//                }


                if (StringUtils.isEmpty(equipmentCostScale)) {
                    vo.setEquipmentCostScale(null);
                } else {
                    try {
                        vo.setEquipmentCostScale(new BigDecimal(equipmentCostScale).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setEquipmentCostScale(null);
                        warnType = warnType + "[摊销比例只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentMny)) {
                    vo.setEquipmentMny(null);
                } else {
                    try {
                        vo.setEquipmentMny(new BigDecimal(equipmentMny));
                    } catch (Exception e) {
                        vo.setEquipmentMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentCostMny)) {
                    vo.setEquipmentCostMny(null);
                } else {
                    try {
                        vo.setEquipmentCostMny(new BigDecimal(equipmentCostMny));
                    } catch (Exception e) {
                        vo.setEquipmentCostMny(null);
                        warnType = warnType + "[摊销成本只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setEquipmentMemo(equipmentMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyEquipmentVO> successList = new ArrayList<>();
            for (DutyEquipmentVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("机械设备费用");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getEquipmentCode());
                    errorVo.setCode(vo.getEquipmentCode());
                    errorVo.setName(vo.getEquipmentName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyEquipmentList(successList);
        }
        return res;
    }

    private ImportVo excelImportJjf(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyJjfVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-1; i++) {
                List<String> datas = result.get(i);
                DutyJjfVO vo = new DutyJjfVO();
                boolean flag = false;
                String warnType = "";

                String jjfName = datas.get(1);// 名称
                String jjfUnitName = datas.get(2);// 单位
                String jjfMny = datas.get(3);// 金额
                String jjfMemo = datas.get(4);// 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                vo.setJjfMemo(jjfMemo);


                if (StringUtils.isEmpty(jjfName)) {
                    vo.setJjfName(null);
                    vo.setSubjectName(null);
                    warnType = warnType + "[名称（成本科目）为空]";
                    flag = true;
                } else {
                    vo.setJjfName(jjfName);
                    vo.setSubjectName(jjfName);
                }
                vo.setJjfUnitName(jjfUnitName);

                if (StringUtils.isEmpty(jjfMny)) {
                    vo.setJjfMny(null);
                } else {
                    try {
                        vo.setJjfMny(new BigDecimal(jjfMny));
                    } catch (Exception e) {
                        vo.setJjfMny(null);
                        warnType = warnType + "[金额只能为数字或小数]";
                        flag = true;
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyJjfVO> successList = new ArrayList<>();
            for (DutyJjfVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("间接费");
                    errorVo.setId(vo.getId());
//                    errorVo.setIndexCode(vo.getMaterialCode());
//                    errorVo.setCode(vo.getMaterialCode());
                    errorVo.setName(vo.getJjfName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyJjfList(successList);
        }
        return res;
    }

    private ImportVo excelImportOther(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyOtherVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-1; i++) {
                List<String> datas = result.get(i);
                DutyOtherVO vo = new DutyOtherVO();
                boolean flag = false;
                String warnType = "";

//                String equipmentCode = datas.get(0);// 序号
                String subjectName = datas.get(1);// 成本科目
                String otherName = datas.get(2);// 名称
                String otherUnitName = datas.get(3);// 单位
                String otherNum = datas.get(4);// 数量
                String otherJs = datas.get(5);// 计算基数
                String otherRate = datas.get(6);// 费率（%）
                String otherMny = datas.get(7);// 合价
                String otherMemo = datas.get(8);// 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isEmpty(subjectName)) {// 编码为空
                    vo.setSubjectName(null);
                    warnType = warnType + "[成本科目为空]";
                    flag = true;
                } else {
                    vo.setSubjectName(subjectName);
                }

                if (StringUtils.isEmpty(otherName)) {// 编码为空
                    vo.setOtherName(null);
                    warnType = warnType + "[名称为空]";
                    flag = true;
                } else {
                    vo.setOtherName(otherName);
                }
                vo.setOtherUnitName(otherUnitName);

                if (StringUtils.isEmpty(otherNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(otherNum));
                    } catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(otherJs)) {
                    vo.setOtherJs(null);
                } else {
                    try {
                        vo.setOtherJs(new BigDecimal(otherJs));
                    } catch (Exception e) {
                        vo.setOtherJs(null);
                        warnType = warnType + "[计算基数只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(otherRate)) {
                    vo.setOtherRate(null);
                } else {
                    try {
                        vo.setOtherRate(new BigDecimal(otherRate).multiply(new BigDecimal(100)));
                    } catch (Exception e) {
                        vo.setOtherRate(null);
                        warnType = warnType + "[费率（%）只能为数字或小数]";
                        flag = true;
                    }
                }


                if (StringUtils.isEmpty(otherMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(otherMny));
                    } catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setOtherMemo(otherMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyOtherVO> successList = new ArrayList<>();
            for (DutyOtherVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("其它工程费");
                    errorVo.setId(vo.getId());
//                    errorVo.setIndexCode(vo.getEquipmentCode());
//                    errorVo.setCode(vo.getEquipmentCode());
                    errorVo.setName(vo.getOtherName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyOtherList(successList);
        }
        return res;
    }

    private ImportVo excelImportUsenum(List<List<String>> result, Long dutyId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<DutyUsenumVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 3; i < result.size(); i++) {
                List<String> datas = result.get(i);
                DutyUsenumVO vo = new DutyUsenumVO();
                boolean flag = false;
                String warnType = "";

                String usenumName = datas.get(0);// 主要材料
                String usenumUnitName = datas.get(1);// 单位
                String usenumNum = datas.get(2);// 数量
                String usenumMemo = datas.get(3);// 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);
                vo.setUsenumMemo(usenumMemo);


                if (StringUtils.isEmpty(usenumName)) {
                    vo.setUsenumName(null);
                } else {
                    vo.setUsenumName(usenumName);
                }
                vo.setUsenumUnitName(usenumUnitName);

                if (StringUtils.isEmpty(usenumNum)) {
                    vo.setUsenumNum(null);
                } else {
                    try {
                        vo.setUsenumNum(new BigDecimal(usenumNum));
                    } catch (Exception e) {
                        vo.setUsenumNum(null);
                        warnType = warnType + "[数量只能为数字或小数]";
                        flag = true;
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<DutyUsenumVO> successList = new ArrayList<>();
            for (DutyUsenumVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("主要材料用量表");
                    errorVo.setId(vo.getId());
//                    errorVo.setIndexCode(vo.getMaterialCode());
//                    errorVo.setCode(vo.getMaterialCode());
                    errorVo.setName(vo.getUsenumName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setDutyUsenumList(successList);
        }
        return res;
    }

    //判断是不是汉字  一级节点
    public boolean checkcountname(String countname)
    {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(countname);
        if (m.find()) {
            return true;
        }
        return false;
    }
    //判断是不是末级
    public boolean checkUn(String countname)
    {
        if (countname.matches("^[a-zA-Z].*")) {
            return true;
        } else {
            return false;
        }
    }

    public DutyTwoVO getUpVo(String baseCode,String code,List<DutyTwoVO> list,Map<String,Integer> map){
        int index = map.get(code);//当前级下标
        DutyTwoVO vo = list.get(index);//当前级数据
        DutyTwoVO lastVo = list.get(index-1);//当前级的 上级数据
        if(baseCode.length()>lastVo.getTwoDetailCode().length()&&!checkUn(lastVo.getTwoDetailCode())){
            return lastVo;
        }else{
            return getUpVo(baseCode,lastVo.getTwoDetailCode(),list,map);
        }
    }

    public List<DutyPlansEntity> SumPlanDetail(RoadbridgeDutyVO vo){
        Long dutyId = vo.getId();
        List<DutyOneVO> dutyOneList = vo.getDutyOneList(); // 路桥-目标成本-100章
        List<DutyTwoVO> dutyTwoList = vo.getDutyTwoList(); // 路桥-目标成本-200章
        List<DutyMaterialVO> dutyMaterialList = vo.getDutyMaterialList();// 路桥-目标成本-主要材料费
        List<DutyRmatVO> dutyRmatList = vo.getDutyRmatList(); // 路桥-目标成本-周转材料费
        List<DutyEquipmentVO> dutyEquipmentList = vo.getDutyEquipmentList(); // 路桥-目标成本-机械设备费
        List<DutyJjfVO> dutyJjfList = vo.getDutyJjfList(); // 路桥-目标成本-间接费
        List<DutyOtherVO> dutyOtherList = vo.getDutyOtherList(); // 路桥-目标成本-其他工程费
        //生成汇总表
        List<DutyPlansEntity> dutyPlansEntityList = new ArrayList<>();
        BigDecimal sumPlansMny = BigDecimal.ZERO;
        BigDecimal sumPlansTaxMny = BigDecimal.ZERO;
        BigDecimal sumPlansPlanMny = BigDecimal.ZERO;
        BigDecimal sumPlansDownMny = BigDecimal.ZERO;

        //100章 行
        DutyPlansEntity one = new DutyPlansEntity();
        one.setDutyId(dutyId);
        one.setPlansDetailName("100章总则");
        BigDecimal plansMny = dutyOneList.stream().filter(item -> null != item.getOneSumMny()).map(DutyOneVO::getOneSumMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        one.setPlansMny(plansMny);
        BigDecimal plansTaxMny = plansMny.multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN);
        one.setPlansTaxMny(plansTaxMny);
        BigDecimal plansPlanMny = dutyOneList.stream().filter(item -> null != item.getOneDutyMny()).map(DutyOneVO::getOneDutyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        one.setPlansPlanMny(plansPlanMny);
        BigDecimal plansDownMny = dutyOneList.stream().filter(item -> null != item.getOneDownMny()).map(DutyOneVO::getOneDownMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        one.setPlansDownMny(plansDownMny);
        if(BigDecimal.ZERO.compareTo(plansMny)!=0){
            one.setPlansDownRate(plansDownMny.multiply(new BigDecimal(100)).divide(plansMny,2,BigDecimal.ROUND_HALF_DOWN));
        }else{
            one.setPlansDownRate(BigDecimal.ZERO);
        }
        dutyPlansEntityList.add(one);
        sumPlansMny = sumPlansMny.add(plansMny);
        sumPlansTaxMny = sumPlansTaxMny.add(plansTaxMny);
        sumPlansPlanMny = sumPlansPlanMny.add(plansPlanMny);
        sumPlansDownMny = sumPlansDownMny.add(plansDownMny);
        //200章行
        for (DutyTwoVO dutyTwoVO : dutyTwoList) {
            if(checkcountname(dutyTwoVO.getTwoDetailCode())){
                DutyPlansEntity two = new DutyPlansEntity();
                two.setDutyId(dutyId);
                two.setPlansDetailName(dutyTwoVO.getTwoDetailName());
                two.setPlansFeeName("人工费");
                two.setPlansMny(dutyTwoVO.getTwoSumMny()==null?BigDecimal.ZERO:dutyTwoVO.getTwoSumMny());
                two.setPlansTaxMny(two.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN));
                two.setPlansPlanMny(dutyTwoVO.getTwoRgMny());
                two.setPlansDownMny(dutyTwoVO.getTwoDownMny());
                two.setPlansDownRate(dutyTwoVO.getTwoDownRate());
                dutyPlansEntityList.add(two);

                DutyPlansEntity two2 = new DutyPlansEntity();
                two2.setDutyId(dutyId);
                two2.setPlansDetailName(dutyTwoVO.getTwoDetailName());
                two2.setPlansFeeName("机械费");
                two2.setPlansMny(dutyTwoVO.getTwoSumMny()==null?BigDecimal.ZERO:dutyTwoVO.getTwoSumMny());
                two2.setPlansTaxMny(two2.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN));
                two2.setPlansPlanMny(dutyTwoVO.getTwoJxMny());
                two2.setPlansDownMny(dutyTwoVO.getTwoDownMny());
                two2.setPlansDownRate(dutyTwoVO.getTwoDownRate());
                dutyPlansEntityList.add(two2);

                DutyPlansEntity two3 = new DutyPlansEntity();
                two3.setDutyId(dutyId);
                two3.setPlansDetailName(dutyTwoVO.getTwoDetailName());
                two3.setPlansFeeName("材料费");
                two3.setPlansMny(dutyTwoVO.getTwoSumMny()==null?BigDecimal.ZERO:dutyTwoVO.getTwoSumMny());
                two3.setPlansTaxMny(two3.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN));
                two3.setPlansPlanMny(dutyTwoVO.getTwoMaterialMny());
                two3.setPlansDownMny(dutyTwoVO.getTwoDownMny());
                two3.setPlansDownRate(dutyTwoVO.getTwoDownRate());
                dutyPlansEntityList.add(two3);

                DutyPlansEntity two4 = new DutyPlansEntity();
                two4.setDutyId(dutyId);
                two4.setPlansDetailName(dutyTwoVO.getTwoDetailName());
                two4.setPlansFeeName("计价不计量材料费");
                two4.setPlansMny(dutyTwoVO.getTwoSumMny()==null?BigDecimal.ZERO:dutyTwoVO.getTwoSumMny());
                two4.setPlansTaxMny(two4.getPlansMny().multiply(vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN));
                two4.setPlansPlanMny(dutyTwoVO.getTwoNoMny());
                two4.setPlansDownMny(dutyTwoVO.getTwoDownMny());
                two4.setPlansDownRate(dutyTwoVO.getTwoDownRate());
                dutyPlansEntityList.add(two4);

                DutyPlansEntity two5 = new DutyPlansEntity();
                two5.setDutyId(dutyId);
                two5.setPlansDetailName(dutyTwoVO.getTwoDetailName());
                two5.setPlansFeeName("专业分包");
                two5.setPlansMny(dutyTwoVO.getTwoSumMny()==null?BigDecimal.ZERO:dutyTwoVO.getTwoSumMny());
                two5.setPlansTaxMny(two5.getPlansMny().multiply((vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN)));
                two5.setPlansPlanMny(dutyTwoVO.getTwoSubMny());
                two5.setPlansDownMny(dutyTwoVO.getTwoDownMny());
                two5.setPlansDownRate(dutyTwoVO.getTwoDownRate());
                dutyPlansEntityList.add(two5);

                DutyPlansEntity two6 = new DutyPlansEntity();
                two6.setDutyId(dutyId);
                two6.setPlansDetailName(dutyTwoVO.getTwoDetailName());
                two6.setPlansFeeName("合计");
                two6.setPlansMny(dutyTwoVO.getTwoSumMny()==null?BigDecimal.ZERO:dutyTwoVO.getTwoSumMny());
                two6.setPlansTaxMny(two6.getPlansMny().multiply((vo.getTaxRate().add(new BigDecimal(100))).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN)));
                two6.setPlansPlanMny(dutyTwoVO.getTwoDutyMny());
                two6.setPlansDownMny(dutyTwoVO.getTwoDownMny());
                two6.setPlansDownRate(dutyTwoVO.getTwoDownRate());
                dutyPlansEntityList.add(two6);

                sumPlansMny = sumPlansMny.add(two6.getPlansMny()==null?BigDecimal.ZERO:two6.getPlansMny());
                sumPlansTaxMny = sumPlansTaxMny.add(two6.getPlansTaxMny()==null?BigDecimal.ZERO:two6.getPlansTaxMny());
                sumPlansPlanMny = sumPlansPlanMny.add(two6.getPlansPlanMny()==null?BigDecimal.ZERO:two6.getPlansPlanMny());
                sumPlansDownMny = sumPlansDownMny.add(two6.getPlansDownMny()==null?BigDecimal.ZERO:two6.getPlansDownMny());

            }
        }

        // 合计行
        DutyPlansEntity hj = new DutyPlansEntity();
        hj.setDutyId(dutyId);
        hj.setPlansDetailName("合计");
        hj.setPlansMny(sumPlansMny);
        hj.setPlansTaxMny(sumPlansTaxMny);
        hj.setPlansPlanMny(sumPlansPlanMny);
        hj.setPlansDownMny(sumPlansDownMny);
        if(BigDecimal.ZERO.compareTo(sumPlansMny)!=0){
            hj.setPlansDownRate(sumPlansDownMny.multiply(new BigDecimal(100)).divide(sumPlansMny,2,BigDecimal.ROUND_HALF_DOWN));
        }else{
            hj.setPlansDownRate(BigDecimal.ZERO);
        }

        dutyPlansEntityList.add(hj);

        // 不可预见费
        DutyPlansEntity bkyj = new DutyPlansEntity();
        bkyj.setDutyId(dutyId);
        bkyj.setPlansDetailName("不可预见费");
        bkyj.setPlansMny(sumPlansMny.multiply(vo.getScale().divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN)));
        bkyj.setPlansTaxMny(sumPlansTaxMny.multiply(vo.getScale().divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN)));
        bkyj.setPlansPlanMny(bkyj.getPlansMny());
        bkyj.setPlansDownMny(BigDecimal.ZERO);
        dutyPlansEntityList.add(bkyj);

        // 周转材料及小五金
        DutyPlansEntity rmat = new DutyPlansEntity();
        rmat.setDutyId(dutyId);
        rmat.setPlansDetailName("周转材料及小五金");
        BigDecimal rmatMny = dutyRmatList.stream().filter(item -> null == item.getParentId()).map(DutyRmatVO::getRmatCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        rmat.setPlansPlanMny(rmatMny==null?BigDecimal.ZERO:rmatMny);
        dutyPlansEntityList.add(rmat);

        // 机械设备费（租赁或自购）
        DutyPlansEntity equipment = new DutyPlansEntity();
        equipment.setDutyId(dutyId);
        equipment.setPlansDetailName("机械设备费（租赁或自购）");
        BigDecimal equipmentMny = dutyEquipmentList.stream().filter(item -> null != item.getEquipmentCostMny()).map(DutyEquipmentVO::getEquipmentCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        equipment.setPlansPlanMny(equipmentMny==null?BigDecimal.ZERO:equipmentMny);
        dutyPlansEntityList.add(equipment);

        // 零星材料及机械用油
        DutyPlansEntity material = new DutyPlansEntity();
        material.setDutyId(dutyId);
        material.setPlansDetailName("零星材料及机械用油");
        List<DutyMaterialVO> materialList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dutyMaterialList)){
            dutyMaterialList.forEach(e->{
             if("114003".equals(e.getMaterialCode())||"134009".equals(e.getMaterialCode())){
                 materialList.add(e);
             }
            });
            BigDecimal materialMny = materialList.stream().filter(item -> null != item.getMaterialMny()).map(DutyMaterialVO::getMaterialMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            material.setPlansPlanMny(materialMny==null?BigDecimal.ZERO:materialMny);
        }else{
            material.setPlansPlanMny(BigDecimal.ZERO);
        }

        dutyPlansEntityList.add(material);

        // 间接费用
        DutyPlansEntity jjf = new DutyPlansEntity();
        jjf.setDutyId(dutyId);
        jjf.setPlansDetailName("间接费用");
        BigDecimal jjfMny = dutyJjfList.stream().filter(item -> null != item.getJjfMny()).map(DutyJjfVO::getJjfMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        jjf.setPlansPlanMny(jjfMny==null?BigDecimal.ZERO:jjfMny);
        jjf.setPlansDownMny(BigDecimal.ZERO.subtract(jjfMny));
        dutyPlansEntityList.add(jjf);

        // 其它工程费用
        DutyPlansEntity other = new DutyPlansEntity();
        other.setDutyId(dutyId);
        other.setPlansDetailName("其它工程费用");
        BigDecimal otherMny = dutyOtherList.stream().filter(item -> null != item.getOtherMny()).map(DutyOtherVO::getOtherMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        other.setPlansPlanMny(otherMny==null?BigDecimal.ZERO:otherMny);
        other.setPlansDownMny(BigDecimal.ZERO.subtract(otherMny));
        dutyPlansEntityList.add(other);

        // 税金
        DutyPlansEntity sj = new DutyPlansEntity();
        sj.setDutyId(dutyId);
        sj.setPlansDetailName("税金");
        BigDecimal sjMny = (hj.getPlansMny().add(bkyj.getPlansMny())).multiply(vo.getTaxRate()).divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_DOWN);
        sj.setPlansMny(sjMny);
        sj.setPlansPlanMny(sjMny);
        sj.setPlansDownMny(BigDecimal.ZERO);
        dutyPlansEntityList.add(sj);

        // 合计行2
        DutyPlansEntity hj2 = new DutyPlansEntity();
        hj2.setDutyId(dutyId);
        hj2.setPlansDetailName("合计");
        hj2.setPlansMny(sumPlansMny.add(bkyj.getPlansMny()).add(sjMny));
        hj2.setPlansTaxMny(sumPlansTaxMny.add(bkyj.getPlansTaxMny()));
        hj2.setPlansPlanMny(sumPlansPlanMny.add(bkyj.getPlansPlanMny()).add(rmat.getPlansPlanMny()).add(equipment.getPlansPlanMny()).add(material.getPlansPlanMny()).add(otherMny).add(jjfMny).add(sjMny));
        hj2.setPlansDownMny(hj2.getPlansMny().subtract(hj2.getPlansPlanMny()));
        if(BigDecimal.ZERO.compareTo(hj2.getPlansMny())!=0){
            hj2.setPlansDownRate(hj2.getPlansDownMny().multiply(new BigDecimal(100)).divide(hj2.getPlansMny(),2,BigDecimal.ROUND_HALF_DOWN));
        }else{
            hj2.setPlansDownRate(BigDecimal.ZERO);
        }
        dutyPlansEntityList.add(hj2);
        return dutyPlansEntityList;
    }


}
