package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.roadbridge.service.IRoadbridgeDutyService;
import com.ejianc.business.roadbridge.vo.RoadbridgeDutyVO;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标责任成本
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("duty")
public class DutyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDutyService service;

    @Autowired
    private IDutyDetailService dutyDetailService;

    @Autowired
    private IDutyDetailItemService dutyDetailItemService;

    @Autowired
    private IDetailCacheService detailCacheService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRoadbridgeDutyService roadbridgeDutyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DutyVO> saveOrUpdate(@RequestBody DutyVO saveOrUpdateVO) {
        Date date = queryOneTime(saveOrUpdateVO.getProjectId());
        if (date != null){
            saveOrUpdateVO.setOneTime(date);
        }
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DutyVO> queryDetail(Long id) {
        DutyVO dutyVO = service.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！", dutyVO);
    }

    /**
     * @Description queryDutyDetail 根据项目查询目标成本详情
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryDutyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DutyVO> queryDutyDetail(Long projectId) {
        LambdaQueryWrapper<DutyEntity> query = new LambdaQueryWrapper<>();
        query.eq(DutyEntity::getProjectId, projectId);
        query.in(DutyEntity::getBillState, 1,3);
        query.eq(DutyEntity::getDr, 0);
        List<DutyEntity> dutyEntities = service.list(query);
        if (dutyEntities.size() == 0){
            return CommonResponse.error("该项目下没有目标成本，请切换项目");
        }
        DutyVO dutyVO = null;
        for (int i = 0; i<=dutyEntities.size(); i++){
            dutyVO = BeanMapper.map(dutyEntities.get(0), DutyVO.class);
        }
        DutyVO dutyVO1 = service.queryDetail(dutyVO.getId(),true);
        return CommonResponse.success("查询详情数据成功！", dutyVO1);
    }


    /**
     * @Description queryReviseDetail 查询修订详情
     * @param id
     */
    @RequestMapping(value = "/queryReviseDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DutyVO> queryReviseDetail(Long id) {
        DutyVO changeVO = service.queryReviseDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }


    /**
     * @Description linkFeeScale 查询费用占比情况
     */
    @RequestMapping(value = "/linkFeeScale", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExecutionLinkVO>> linkFeeScale(@RequestParam Long projectId,Long id) {
        List<ExecutionLinkVO> linkVOS = service.linkFeeScale(projectId,id);
        return CommonResponse.success("查询参照数据成功！", linkVOS);
    }


    @RequestMapping(value = "/queryDoc", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse <Map<Long,BigDecimal>> queryDoc(@RequestParam Long projectId) {
        Map<Long,BigDecimal>  linkVOS = service.queryDoc(projectId);
        return CommonResponse.success("查询数据成功！", linkVOS);
    }

    @RequestMapping(value = "/querySumPreTypeAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<Long,BigDecimal>> querySumPreTypeAmount(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询数据成功！", service.querySumPreTypeAmount(projectId));
    }

    @RequestMapping(value = "/queryDocDutyDetailItem", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse <Map<Long, DutyDetailItemVO>> queryDocDutyDetailItem(@RequestParam Long projectId, @RequestParam Integer docType) {
        Map<Long,DutyDetailItemVO>  linkVOS = service.queryDocDutyDetailItem(projectId,docType);
        return CommonResponse.success("查询数据成功！", linkVOS);
    }

    /**
     * 单据管控-累计结算金额大于合同金额
     * @param
     * @param
     * @param
     * @param
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody DutyVO dutyVO) {
        return CommonResponse.success("参数校验成功！", service.checkParams(dutyVO));
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DutyVO> vos) {
        service.deleteList(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("showFlag", new Parameter(QueryParam.EQ, true));

        //* 数据隔离 本下 没有组织orgId的删除下面代码-------------开始
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        QueryParam queryParam = BeanMapper.map(param, QueryParam.class);

        IPage<DutyEntity> page = service.queryPage(buildParam(param, true),false);
        IPage<DutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DutyVO> dutyVOS = BeanMapper.mapList(page.getRecords(), DutyVO.class);
        for (DutyVO dutyVO : dutyVOS) {
            if(dutyVO.getGatherFlag()){
                queryParam.getParams().put("showFlag", new Parameter(QueryParam.EQ, true));
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, dutyVO.getProjectId()));
                List<DutyEntity> childList = service.queryList(buildParam(queryParam, false));
                for(DutyEntity dutyEntity : childList){
                    DutyVO vo = BeanMapper.map(dutyEntity, DutyVO.class);
                    vo.setParentId(dutyVO.getId());
                    dutyVO.getChildren().add(vo);
                }
            }
        }

        pageData.setRecords(TreeNodeBUtil.buildTree(dutyVOS));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private QueryParam buildParam(QueryParam param, Boolean isParent){
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */

        /*  1>【是否生效】为是的 + 第一版本没审批通过的（审批中的+自由态）单据；
            2> 如果生效的目标成本当前存在修订中的单据（未审批通过的），在操作列显示变更按钮跳转到对应单据。（【是否最新版本】=否  【是否生效】=是）
            3>【是否最新版本】=是  【是否生效】=是 时，操作列显示 修订 按钮，点击跳转到单据修订页面*/
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效
        c1.getParams().put("gatherFlag", new Parameter(QueryParam.EQ, isParent));//是否汇总

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        //不生效
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("dutyVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);
        if(isParent){
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getGatherFlag, true);
            List<DutyEntity> dutyEntities = service.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(dutyEntities)){
                ComplexParam c6 = new ComplexParam();
                c6.setLogic("and");
                c6.getParams().put("projectId", new Parameter(QueryParam.NOT_IN, dutyEntities.stream().map(DutyEntity::getProjectId).collect(Collectors.toList())));
                complex2.getComplexParams().add(c6);
            }
        }

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        return param;
    }

    /**
     * @Description queryList 查询历史版本列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryHistoryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> queryHistoryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("latestFlag", new Parameter(QueryParam.EQ, false));
        param.getParams().put("enableState", new Parameter(QueryParam.EQ, false));
        param.getParams().put("showFlag", new Parameter(QueryParam.EQ, true));

        IPage<DutyEntity> page = service.queryPage(param,false);
        IPage<DutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DutyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryGatherList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> queryGatherList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("showFlag", new Parameter(QueryParam.EQ, true));

        //* 数据隔离 本下 没有组织orgId的删除下面代码-------------开始
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<DutyEntity> page = service.queryPage(param,false);
        IPage<DutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DutyVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        CommonResponse<IPage<DutyVO>> commonResponse = queryList(param);
        List<DutyVO> records = commonResponse.getData().getRecords();
        List<DutyVO> exportVOS = new ArrayList<>();
        records.forEach(val ->{
            switch (val.getBillState()){
                case 0: val.setBillStateName("自由态");break;
                case 1: val.setBillStateName("已提交");break;
                case 2: val.setBillStateName("审批中");break;
                case 3: val.setBillStateName("审批通过");break;
                case 4: val.setBillStateName("审批驳回");break;
                case 5: val.setBillStateName("审批中");break;
            }
            if (null != val.getChangeState()) {
                switch (val.getChangeState()){
                    case 0: val.setChangeStateName("未变更");break;
                    case 1: val.setChangeStateName("变更中");break;
                    case 2: val.setChangeStateName("已变更");break;
                }
            }
            exportVOS.add(val);
            if (CollectionUtils.isNotEmpty(val.getChildren())) {
                for (ITreeNodeB treeNodeB : val.getChildren()) {
                    DutyVO dutyVO = (DutyVO) treeNodeB;
                    switch (dutyVO.getBillState()){
                        case 0: dutyVO.setBillStateName("自由态");break;
                        case 1: dutyVO.setBillStateName("已提交");break;
                        case 2: dutyVO.setBillStateName("审批中");break;
                        case 3: dutyVO.setBillStateName("审批通过");break;
                        case 4: dutyVO.setBillStateName("审批驳回");break;
                        case 5: dutyVO.setBillStateName("审批中");break;
                    }
                    switch (dutyVO.getChangeState()){
                        case 0: dutyVO.setChangeStateName("未变更");break;
                        case 1: dutyVO.setChangeStateName("变更中");break;
                        case 2: dutyVO.setChangeStateName("已变更");break;
                    }
                    exportVOS.add(dutyVO);
                }
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("DutyExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDutyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DutyVO>> refDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");

        IPage<DutyEntity> page = service.queryPage(param,false);
        IPage<DutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DutyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 责任成本表体分类树
     *
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryDutyDetailTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTree(@RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        logger.debug("condition is " + condition);
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }else{
                return null;
            }
        }
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List<DutyEntity> list = service.list(queryWrapper);
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter(QueryParam.EQ, list.get(0).getId()));
        if (StringUtils.isNotBlank(searchText)) {
            queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("docType")) {
                queryParam.getParams().put("docType", new Parameter(QueryParam.EQ, Integer.valueOf(conditionMap.get("docType").toString())));
            }
        }

        List<DutyDetailEntity> dataList = dutyDetailService.queryList(queryParam, false);


        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        for(Map map : resultMapList){
            map.put("name", map.get("feeDetailName"));
        }

        List<Map<String, Object>> result = ResultAsTree.createTreeData(resultMapList);
        return result;
    }

    /**
     * 供方列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refDutyItemPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DutyDetailItemEntity>> refSupplierPage(@RequestParam(defaultValue = "1") int pageNumber,
                                                                       @RequestParam(defaultValue = "10") int pageSize,
                                                                       @RequestParam(required=false) String relyCondition,
                                                                       @RequestParam(required=false) String searchText,
                                                                       @RequestParam(required=false) String condition
    ) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        if(StringUtils.isNotBlank(relyCondition)){
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            DutyDetailEntity dutyDetailEntity = dutyDetailService.selectById(categoryId);
            if(dutyDetailEntity != null) {
                queryParam.getParams().put("dutyDetailId", new Parameter(QueryParam.EQ, dutyDetailEntity.getId()));
            }
        }
        IPage<DutyDetailItemEntity> pageData = dutyDetailItemService.queryPage(queryParam);
        return CommonResponse.success("查询成功！", pageData);
    }

    /**
     * 责任成本表体分类树带父级
     *劳务分包personal
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryDutyDetailTreePersonal", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreePersonal(@RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        logger.debug("condition is " + condition);
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }else{
                return null;
            }
        }
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List<DutyEntity> list = service.list(queryWrapper);
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        Long dutyId = list.get(0).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter(QueryParam.EQ,dutyId));
        queryParam.getParams().put("docType", new Parameter(QueryParam.EQ, Integer.valueOf(1)));
        if (StringUtils.isNotBlank(searchText)) {
            queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }
        List<DutyDetailEntity> dataList = dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = dutyDetailService.queryDutyDetailParentId(dutyId,dataList);
        List<DutyDetailVO> dutyDetailVOList = new ArrayList<>();
        for(DutyDetailEntity dutyDetailEntity : dutyDetailEntities){
            DutyDetailVO vo = BeanMapper.map(dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List<Map> resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for(Map map : resultMapList){
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * 责任成本表体分类树带父级
     *专业分包
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryDutyDetailTreeMajor", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeMajor(@RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        logger.debug("condition is " + condition);
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }else{
                return null;
            }
        }
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List<DutyEntity> list = service.list(queryWrapper);
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        Long dutyId = list.get(0).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter(QueryParam.EQ,dutyId));
        queryParam.getParams().put("docType", new Parameter(QueryParam.EQ, Integer.valueOf(2)));
        if (StringUtils.isNotBlank(searchText)) {
            queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }
        List<DutyDetailEntity> dataList = dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = dutyDetailService.queryDutyDetailParentId(dutyId,dataList);
        List<DutyDetailVO> dutyDetailVOList = new ArrayList<>();
        for(DutyDetailEntity dutyDetailEntity : dutyDetailEntities){
            DutyDetailVO vo = BeanMapper.map(dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List<Map> resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for(Map map : resultMapList){
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * 责任成本表体分类树带父级
     *物料档案
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryDutyDetailTreeMaterial", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeMaterial(@RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        logger.debug("condition is " + condition);
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }else{
                return null;
            }
        }
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List<DutyEntity> list = service.list(queryWrapper);
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        Long dutyId = list.get(0).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter(QueryParam.EQ,dutyId));
        queryParam.getParams().put("docType", new Parameter(QueryParam.EQ, Integer.valueOf(3)));
        if (StringUtils.isNotBlank(searchText)) {
            queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }
        List<DutyDetailEntity> dataList = dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = dutyDetailService.queryDutyDetailParentId(dutyId,dataList);
        List<DutyDetailVO> dutyDetailVOList = new ArrayList<>();
        for(DutyDetailEntity dutyDetailEntity : dutyDetailEntities){
            DutyDetailVO vo = BeanMapper.map(dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }
        List<Map> resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for(Map map : resultMapList){
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * 责任成本表体分类树带父级
     *设备档案4
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryDutyDetailTreeEquipment", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryDutyDetailTreeEquipment(@RequestParam(required = false) String searchText, @RequestParam(required = false) String condition) {
        logger.debug("condition is " + condition);
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }else{
                return null;
            }
        }
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        List<DutyEntity> list = service.list(queryWrapper);
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        Long dutyId = list.get(0).getId();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dutyId", new Parameter(QueryParam.EQ,dutyId));
        queryParam.getParams().put("docType", new Parameter(QueryParam.EQ, Integer.valueOf(4)));
        if (StringUtils.isNotBlank(searchText)) {
            queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }
        List<DutyDetailEntity> dataList = dutyDetailService.queryList(queryParam, false);
        List<DutyDetailEntity> dutyDetailEntities = dutyDetailService.queryDutyDetailParentId(dutyId,dataList);
        List<DutyDetailVO> dutyDetailVOList = new ArrayList<>();
        for(DutyDetailEntity dutyDetailEntity : dutyDetailEntities){
            DutyDetailVO vo = BeanMapper.map(dutyDetailEntity, DutyDetailVO.class);
            dutyDetailVOList.add(vo);
        }

        List<Map> resultMapList = BeanMapper.mapList(dutyDetailVOList, Map.class);
        for(Map map : resultMapList){
            map.put("name", map.get("feeDetailName"));
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * 成本明细列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refDutyDetailItemPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DutyDetailItemEntity>> refDutyDetailItemPage(@RequestParam(defaultValue = "1") int pageNumber,
                                                                       @RequestParam(defaultValue = "10") int pageSize,
                                                                       @RequestParam(required=false) String relyCondition,
                                                                       @RequestParam(required=false) String searchText,
                                                                       @RequestParam(required=false) String condition
    ) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        Long dutyDetailId = null;
        if(StringUtils.isNotBlank(relyCondition)){
            dutyDetailId = Long.parseLong(relyCondition.split("=")[1]);
        }
        queryParam.getParams().put("dutyDetailId", new Parameter(QueryParam.EQ, dutyDetailId));
        queryParam.getOrderMap().put("code",QueryParam.ASC);
        IPage<DutyDetailItemEntity> pageData = dutyDetailItemService.queryPage(queryParam);

        DutyDetailEntity dutyDetailEntity = dutyDetailService.selectById(dutyDetailId);
        if (CollectionUtils.isNotEmpty(pageData.getRecords()) && DocTypeEnum.劳务分包档案.getCode().equals(dutyDetailEntity.getDocType())) {
            LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DetailCacheEntity::getDutyDetailId, dutyDetailId);
            queryWrapper.isNotNull(DetailCacheEntity::getDutyItemId);
            List<DetailCacheEntity> detailCacheEntities = detailCacheService.list(queryWrapper);
            Map<Long, DetailCacheEntity> map = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDutyItemId, Function.identity(), (key1, key2) -> key1));
            for (DutyDetailItemEntity itemEntity : pageData.getRecords()) {
                itemEntity.setContNum(map.containsKey(itemEntity.getId()) ? map.get(itemEntity.getId()).getContNum() : null);
            }
        }

        for (DutyDetailItemEntity itemEntity : pageData.getRecords()) {
            itemEntity.setMaterialEquipmentSupply("测试字段，参照使用！");
        }
      /* //处理档案名称
        for (int i=0; i<pageData.getRecords().size(); i++){
            if(pageData.getRecords().get(i).getCategoryId() != null){
                pageData.getRecords().get(i).setCategoryName(dutyDetailService.queryCategoryName(pageData.getRecords().get(i).getCategoryId(),pageData.getRecords().get(i).getFeeDetailId()));
            }else{
                pageData.getRecords().get(i).setCategoryName(dutyDetailService.queryCategoryName2(pageData.getRecords().get(i).getCode().substring(0,7)));
            }
        }*/
        return CommonResponse.success("查询成功！", pageData);
    }

    /**
     * @Description 重新汇总
     * @param id
     */
    @RequestMapping(value = "/gatherDuty", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DutyVO> gatherDuty(Long id) {
        DutyVO dutyVO = service.gatherDuty(id);
        return CommonResponse.success("重新汇总成功！", dutyVO);
    }

    /**
     * @Description 路桥导入推送
     * @param id
     */
    @RequestMapping(value = "/pushFromLqImport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushFromLqImport(Long id, Boolean isEff) {
        service.pushFromImport(BeanMapper.map(roadbridgeDutyService.selectById(id), RoadbridgeDutyVO.class), isEff, ConversionEnum.云南路桥.getCode());
        return CommonResponse.success("路桥导入推送！");
    }

    private Date queryOneTime(Long projectId){
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<DutyEntity>();
        queryWrapper.eq(DutyEntity::getProjectId,projectId);
        queryWrapper.eq(DutyEntity::getDutyVersion, 1);
        DutyEntity dutyEntity = service.getOne(queryWrapper, false);
        if (dutyEntity!=null){
            return dutyEntity.getCreateTime();
        }else {
            return null;
        }
    }
}

