package com.ejianc.business.targetcost.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.build.vo.*;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
public class BuildHandler extends ConversionBaseHandler implements IConversioneHandler {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        BuildDutyVO buildDutyVO = (BuildDutyVO) baseVO;
        DutyEntity dutyEntity = BeanMapper.map(buildDutyVO, DutyEntity.class);
        dutyEntity.setFirstImportId(buildDutyVO.getBaseDutyId());
        dutyEntity.setImportId(buildDutyVO.getId());
        dutyEntity.setImportType(ConversionEnum.云南房建.getCode());

        handlerHead(dutyEntity, isEff, baseVO);

        return CommonResponse.success("导入转换目标成本单据成功！");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        deleteDuty(importId);
        return CommonResponse.success("删除目标成本单据成功！");
    }

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        BuildDutyVO buildDutyVO = (BuildDutyVO) baseVO;

        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        //人工费
        Callable<DutyEntity> labsubCallable = new LasubChangeCallable(labsubApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> labsubFuture = threadPool.submit(labsubCallable);

        //专业分包费
        Callable<DutyEntity> prosubCallable = new ProsubChangeCallable(prosubApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> prosubFuture = threadPool.submit(prosubCallable);

        //主要材料费
        Callable<DutyEntity> materialCallable = new MaterialChangeCallable(materialApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> materialFuture = threadPool.submit(materialCallable);

        //周转材料费
        Callable<DutyEntity> rmatCallable = new RmatChangeCallable(materialApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> rmatFuture = threadPool.submit(rmatCallable);

        //机械设备费
        Callable<DutyEntity> equipCallable = new EquipmentChangeCallable(equipmentApi, buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> equipFuture = threadPool.submit(equipCallable);

        //其他页签
        Callable<DutyEntity> othCallable = new OtherChangeCallable(buildDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> othFuture = threadPool.submit(othCallable);

        List<DutyEntity> dutyList = new ArrayList<>();
        try {
            dutyList.add(labsubFuture.get());
            dutyList.add(prosubFuture.get());
            dutyList.add(materialFuture.get());
            dutyList.add(rmatFuture.get());
            dutyList.add(equipFuture.get());
            dutyList.add(othFuture.get());
        } catch (Exception e) {
            logger.error("查询数据异常", e);
            throw new BusinessException("房建导入转换失败！");
        } finally {
            threadPool.shutdown();
        }

        return dutyList;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        //安全文明施工费
        boolean aqwmsgfFlag = false;
        //临时设施费
        boolean lsssfFlag = false;
        //其他措施费
        boolean qtcsfFlag = false;
        //现场管理费
        boolean xcglflag = false;
        //规费
        boolean gfFlag = false;
        //其他费用
        boolean otherFlag = false;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if ("安全文明施工费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                aqwmsgfFlag = true;
            }
            if ("临时设施费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                lsssfFlag = true;
            }
            if ("其他措施费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                qtcsfFlag = true;
            }
            if ("现场管理费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                xcglflag = true;
            }
            if ("规费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                gfFlag = true;
            }
            if ("其他费用".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                otherFlag = true;
            }
        }
        if (!aqwmsgfFlag) {
            throw new BusinessException("费用模板中未配置【安全文明施工费】的费用项，无法转换！");
        }
        if (!lsssfFlag) {
            throw new BusinessException("费用模板中未配置【临时设施费】的费用项，无法转换！");
        }
        if (!qtcsfFlag) {
            throw new BusinessException("费用模板中未配置【其他措施费】的费用项，无法转换！");
        }
        if (!xcglflag) {
            throw new BusinessException("费用模板中未配置【现场管理费】的费用项，无法转换！");
        }
        if (!gfFlag) {
            throw new BusinessException("费用模板中未配置【规费】的费用项，无法转换！");
        }
        if (!otherFlag) {
            throw new BusinessException("费用模板中未配置【其他费用】的费用项，无法转换！");
        }
    }

    class LasubChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareLabsubApi shareLabsubApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public LasubChangeCallable(IShareLabsubApi shareLabsubApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareLabsubApi = shareLabsubApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            //劳务分包分类的内码map
            Map<Long, String> labCtyInnerCodeMap = new HashMap<>();
            RequestContextHolder.setRequestAttributes(context);
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //先判断费用模板有无关联人工费
            //人工费
            Long rgfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238533").equals(detailVO.getFeePropId())) {
                    rgfId = detailVO.getId();
                }
            }
            if (null == rgfId) {
                throw new BusinessException("费用模板中未配置【人工费】的费用项，无法转换！");
            }
            //人工费下的主键集合
            Set<Long> rgfSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(rgfId))) {
                    rgfSet.add(detailVO.getId());
                }
            }
            //其他人工费
            Long qtrgfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) && rgfSet.contains(detailVO.getId())) {
                    qtrgfId = detailVO.getId();
                }
            }
            if (null == qtrgfId) {
                throw new BusinessException("费用模板中未配置【其他人工费】的费用项，无法转换！");
            }

            List<String> codeList = new ArrayList<>();
            for (BuildRgcostVO rgcostVO : buildDutyVO.getBuildRgcostList()) {
                if (null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag()) {
                    if (StringUtils.isNotBlank(rgcostVO.getRgcostCode()) && rgcostVO.getRgcostCode().startsWith("YL")) {
                        String result = rgcostVO.getRgcostCode().substring(0, rgcostVO.getRgcostCode().length() - 3);
                        rgcostVO.setRgcostCode(result);
                        codeList.add(result);
                    }
                }
            }

            Map<String, LabsubItemVO> labSubMap = new HashMap<>();
            CommonResponse<List<LabsubItemVO>> labItemResponse = shareLabsubApi.queryItemListByCodes(codeList);
            if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty(labItemResponse.getData())) {
                labSubMap = labItemResponse.getData().stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }else{
                logger.error("labItemResponse is" + JSONObject.toJSONString(labItemResponse));
            }

            for (BuildRgcostVO rgcostVO : buildDutyVO.getBuildRgcostList()) {
                if (null == rgcostVO.getLeafFlag() || !rgcostVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(rgcostVO.getRgcostCode()) && rgcostVO.getRgcostCode().startsWith("YL") && labSubMap.containsKey(rgcostVO.getRgcostCode())) {
                        LabsubItemVO labsubItemVO = labSubMap.get(rgcostVO.getRgcostCode());
                        if (!labCtyInnerCodeMap.containsKey(labsubItemVO.getCategoryId())) {
                            CommonResponse<LabsubCategoryVO> response = shareLabsubApi.queryLabSubByCategoryId(labsubItemVO.getCategoryId());
                            labCtyInnerCodeMap.put(labsubItemVO.getCategoryId(), response.getData().getInnerCode());
                        }
                        String innerCode = labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                        logger.error("labsubItemVO is" + JSONObject.toJSONString(labsubItemVO));
                        logger.error("innerCode is" + JSONObject.toJSONString(innerCode));
                        logger.error("getRgcostCode is" + JSONObject.toJSONString(rgcostVO.getRgcostCode()));
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“人工费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && rgfSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(labsubItemVO.getTrawlingCode());
                            itemEntity.setName(labsubItemVO.getTrawlingName());
                            itemEntity.setPriceType(labsubItemVO.getPriceType());
                            itemEntity.setJobContent(labsubItemVO.getJobContent());
                            itemEntity.setUnitName(labsubItemVO.getUnitName());
                            itemEntity.setTaxRate(rgcostVO.getRgcostRate());
                            itemEntity.setPrice(rgcostVO.getRgcostPrice());
                            itemEntity.setTaxPrice(rgcostVO.getRgcostTaxPrice());
                            itemEntity.setAmount(rgcostVO.getRgcostNum());
                            itemEntity.setMny(rgcostVO.getRgcostMny());
                            itemEntity.setTaxMny(rgcostVO.getRgcostTaxMny());
                            itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.劳务分包档案.getCode());
                            itemEntity.setDocId(labsubItemVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtrgfId)) {//匹配不到档案且子表为“其他人工费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(rgcostVO.getRgcostCode());
                        itemEntity.setName(rgcostVO.getRgcostName());
                        itemEntity.setUnitName(rgcostVO.getRgcostUnitName());
                        itemEntity.setTaxRate(rgcostVO.getRgcostRate());
                        itemEntity.setPrice(rgcostVO.getRgcostPrice());
                        itemEntity.setTaxPrice(rgcostVO.getRgcostTaxPrice());
                        itemEntity.setAmount(rgcostVO.getRgcostNum());
                        itemEntity.setMny(rgcostVO.getRgcostMny());
                        itemEntity.setTaxMny(rgcostVO.getRgcostTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
            return dutyEntity;
        }
    }

    class ProsubChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareProsubApi shareProsubApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public ProsubChangeCallable(IShareProsubApi shareProsubApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareProsubApi = shareProsubApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            //专业分包分类的内码map
            Map<Long, String> proCtyInnerCodeMap = new HashMap<>();
            RequestContextHolder.setRequestAttributes(context);
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //先判断费用模板有无关联专业分包费
            //专业分包费
            Long zyfbId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238540").equals(detailVO.getFeePropId())) {
                    zyfbId = detailVO.getId();
                }
            }
            if (null == zyfbId) {
                throw new BusinessException("费用模板中未配置【专业分包费】的费用项，无法转换！");
            }
            //专业分包费下的主键集合
            Set<Long> zyfbSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(zyfbId))) {
                    zyfbSet.add(detailVO.getId());
                }
            }
            //其他专业分包费
            Long qtzyfbId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) && zyfbSet.contains(detailVO.getId())) {
                    qtzyfbId = detailVO.getId();
                }
            }
            if (null == qtzyfbId) {
                throw new BusinessException("费用模板中未配置【其他专业分包费】的费用项，无法转换！");
            }

            List<String> codeList = new ArrayList<>();
            for (BuildSubVO subVO : buildDutyVO.getBuildSubList()) {
                if (null != subVO.getLeafFlag() && subVO.getLeafFlag()) {
                    if (StringUtils.isNotBlank(subVO.getSubCode()) && subVO.getSubCode().startsWith("YZ")) {
                        String result = subVO.getSubCode().substring(0, subVO.getSubCode().length() - 3);
                        subVO.setSubCode(result);
                        codeList.add(result);
                    }
                }
            }

            Map<String, ProsubItemVO> proSubMap = new HashMap<>();
            CommonResponse<List<ProsubItemVO>> proItemResponse = shareProsubApi.queryItemListByCodes(codeList);
            if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty(proItemResponse.getData())) {
                proSubMap = proItemResponse.getData().stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }

            for (BuildSubVO subVO : buildDutyVO.getBuildSubList()) {
                if (null == subVO.getLeafFlag() || !subVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(subVO.getSubCode()) && subVO.getSubCode().startsWith("YZ") && proSubMap.containsKey(subVO.getSubCode())) {
                        ProsubItemVO prosubItemVO = proSubMap.get(subVO.getSubCode());
                        if (!proCtyInnerCodeMap.containsKey(prosubItemVO.getCategoryId())) {
                            CommonResponse<List<ProsubCategoryVO>> response = shareProsubApi.queryCategoryListByIds(Arrays.asList(prosubItemVO.getCategoryId()));
                            proCtyInnerCodeMap.put(prosubItemVO.getCategoryId(), response.getData().get(0).getInnerCode());
                        }
                        String innerCode = proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && zyfbSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(prosubItemVO.getTrawlingCode());
                            itemEntity.setName(prosubItemVO.getTrawlingName());
                            itemEntity.setPriceType(prosubItemVO.getPriceType());
                            itemEntity.setJobContent(prosubItemVO.getJobContent());
                            itemEntity.setUnitName(prosubItemVO.getUnitName());
                            itemEntity.setTaxRate(subVO.getSubRate());
                            itemEntity.setPrice(subVO.getSubPrice());
                            itemEntity.setTaxPrice(subVO.getSubTaxPrice());
                            itemEntity.setAmount(subVO.getSubNum());
                            itemEntity.setMny(subVO.getSubMny());
                            itemEntity.setTaxMny(subVO.getSubTaxMny());
                            itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.专业分包档案.getCode());
                            itemEntity.setDocId(prosubItemVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtzyfbId)) {//匹配不到档案且子表为“其他专业分包费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(subVO.getSubCode());
                        itemEntity.setName(subVO.getSubName());
                        itemEntity.setUnitName(subVO.getSubUnitName());
                        itemEntity.setTaxRate(subVO.getSubRate());
                        itemEntity.setPrice(subVO.getSubPrice());
                        itemEntity.setTaxPrice(subVO.getSubTaxPrice());
                        itemEntity.setAmount(subVO.getSubNum());
                        itemEntity.setMny(subVO.getSubMny());
                        itemEntity.setTaxMny(subVO.getSubTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
            return dutyEntity;
        }
    }

    class MaterialChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public MaterialChangeCallable(IShareMaterialApi shareMaterialApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            //物资分类的内码map
            Map<Long, String> matCtyLongInnerMap = new HashMap<>();
            Map<String, String> matCtyStringInnerMap = new HashMap<>();
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //先判断费用模板有无关联材料费
            //材料费
            Long clfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238535").equals(detailVO.getFeePropId())) {
                    clfId = detailVO.getId();
                }
            }
            if (null == clfId) {
                throw new BusinessException("费用模板中未配置【材料费】的费用项，无法转换！");
            }
            //材料费下的主键集合
            Set<Long> clfSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(clfId))) {
                    clfSet.add(detailVO.getId());
                }
            }
            //其他材料费
            Long qtclfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) && clfSet.contains(detailVO.getId())) {
                    qtclfId = detailVO.getId();
                }
            }
            if (null == qtclfId) {
                throw new BusinessException("费用模板中未配置【其他材料费】的费用项，无法转换！");
            }

            List<String> codeList = new ArrayList<>();
            for (BuildMaterialVO materialVO : buildDutyVO.getBuildMaterialList()) {
                if (StringUtils.isNotBlank(materialVO.getMaterialCode()) && materialVO.getMaterialCode().matches("\\d.*")) {
                    String result = materialVO.getMaterialCode().length() > 3 ? materialVO.getMaterialCode().substring(0, materialVO.getMaterialCode().length() - 3) : materialVO.getMaterialCode();
                    materialVO.setMaterialCode(result);
                    codeList.add(result);
                }
            }

            CommonResponse<List<MaterialVO>> matResponse = shareMaterialApi.queryMaterialListByCodes(codeList);

            Map<String, MaterialVO> matMap = new HashMap<>();
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
                matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }

            int num = 1;
            for (BuildMaterialVO buildMaterialVO : buildDutyVO.getBuildMaterialList()) {
                if (null == buildMaterialVO.getLeafFlag() || !buildMaterialVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (StringUtils.isNotBlank(buildMaterialVO.getMaterialCode())) {
                        if (matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                            MaterialVO materialVO = matMap.get(buildMaterialVO.getMaterialCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = response.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else {
                            if (!matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryByCode(buildMaterialVO.getMaterialCode());
                                if (response.isSuccess() && null != response.getData()) {
                                    MaterialCategoryVO categoryVO = response.getData();
                                    matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                    matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                                }
                            }
                        }
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(buildMaterialVO.getMaterialCode()) && matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                        MaterialVO materialVO = matMap.get(buildMaterialVO.getMaterialCode());
                        String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && clfSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(materialVO.getCode());
                            itemEntity.setName(materialVO.getName());
                            itemEntity.setModel(materialVO.getSpec());
                            itemEntity.setUnitId(materialVO.getUnitId());
                            itemEntity.setUnitName(materialVO.getUnitName());
                            itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                            itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                            itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                            itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                            itemEntity.setMny(buildMaterialVO.getMaterialMny());
                            itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                            itemEntity.setCategoryId(materialVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(materialVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
                            itemEntity.setDocId(materialVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (StringUtils.isNotBlank(buildMaterialVO.getMaterialCode()) && matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode())) {//匹配到分类
                        String innerCode = matCtyStringInnerMap.get(buildMaterialVO.getMaterialCode());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && clfSet.contains(detailEntity.getFeeDetailId()))) {
                            detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), buildMaterialVO.getMaterialNum()));
                            detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), buildMaterialVO.getMaterialMny()));
                            detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), buildMaterialVO.getMaterialTaxMny()));
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtclfId)) {//匹配不到档案且子表为“其他材料费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(buildMaterialVO.getMaterialCode())) {
                            itemEntity.setCode(String.valueOf(num));
                            num++;
                        } else {
                            itemEntity.setCode(buildMaterialVO.getMaterialCode());
                        }
                        itemEntity.setName(buildMaterialVO.getMaterialName());
                        itemEntity.setUnitName(buildMaterialVO.getMaterialUnitName());
                        itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                        itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                        itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                        itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                        itemEntity.setMny(buildMaterialVO.getMaterialMny());
                        itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
            return dutyEntity;
        }
    }

    class RmatChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public RmatChangeCallable(IShareMaterialApi shareMaterialApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            //物资分类的内码map
            Map<Long, String> matCtyLongInnerMap = new HashMap<>();
            Map<String, String> matCtyStringInnerMap = new HashMap<>();
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //先判断费用模板有无关联周转材材料费
            //周转材材料费
            Long zzcId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238537").equals(detailVO.getFeePropId())) {
                    zzcId = detailVO.getId();
                }
            }
            if (null == zzcId) {
                throw new BusinessException("费用模板中未配置【周转材料费】的费用项，无法转换！");
            }
            //周转材材料费下的主键集合
            Set<Long> zzcSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(zzcId))) {
                    zzcSet.add(detailVO.getId());
                }
            }
            //其他周转材材料费
            Long qtzzcId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238538").equals(detailVO.getFeePropId()) && zzcSet.contains(detailVO.getId())) {
                    qtzzcId = detailVO.getId();
                }
            }
            if (null == qtzzcId) {
                throw new BusinessException("费用模板中未配置【其他周转材料费】的费用项，无法转换！");
            }

            List<String> codeList = new ArrayList<>();
            for (BuildRmatVO rmatVO : buildDutyVO.getBuildRmatList()) {
                if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && rmatVO.getRmatCode().matches("\\d.*")) {
                    String result = rmatVO.getRmatCode().length() > 3 ? rmatVO.getRmatCode().substring(0, rmatVO.getRmatCode().length() - 3) : rmatVO.getRmatCode();
                    rmatVO.setRmatCode(result);
                    codeList.add(result);
                }
            }

            CommonResponse<List<MaterialVO>> matResponse = shareMaterialApi.queryMaterialListByCodes(codeList);
            Map<String, MaterialVO> matMap = new HashMap<>();
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
                matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }

            int num = 1;
            for (BuildRmatVO rmatVO : buildDutyVO.getBuildRmatList()) {
                if (null == rmatVO.getLeafFlag() || !rmatVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (StringUtils.isNotBlank(rmatVO.getRmatCode())) {
                        if (matMap.containsKey(rmatVO.getRmatCode())) {
                            MaterialVO materialVO = matMap.get(rmatVO.getRmatCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = response.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else {
                            if (!matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryByCode(rmatVO.getRmatCode());
                                if (response.isSuccess() && null != response.getData()) {
                                    MaterialCategoryVO categoryVO = response.getData();
                                    matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                    matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                                }
                            }
                        }
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && matMap.containsKey(rmatVO.getRmatCode())) {
                        MaterialVO materialVO = matMap.get(rmatVO.getRmatCode());
                        String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && zzcSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(materialVO.getCode());
                            itemEntity.setName(materialVO.getName());
                            itemEntity.setModel(materialVO.getSpec());
                            itemEntity.setUnitId(materialVO.getUnitId());
                            itemEntity.setUnitName(materialVO.getUnitName());
                            itemEntity.setTaxRate(rmatVO.getRmatRate());
                            itemEntity.setPrice(rmatVO.getRmatPrice());
                            itemEntity.setTaxPrice(rmatVO.getRmatTaxPrice());
                            itemEntity.setAmount(rmatVO.getRmatNum());
                            itemEntity.setMny(rmatVO.getRmatMny());
                            itemEntity.setTaxMny(rmatVO.getRmatTaxMny());
                            itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                            itemEntity.setCategoryId(materialVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(materialVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
                            itemEntity.setDocId(materialVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {//匹配到分类
                        String innerCode = matCtyStringInnerMap.get(rmatVO.getRmatCode());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“周转材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && zzcSet.contains(detailEntity.getFeeDetailId()))) {
                            detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), rmatVO.getRmatNum()));
                            detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), rmatVO.getRmatMny()));
                            detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), rmatVO.getRmatTaxMny()));
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtzzcId)) {//匹配不到档案且子表为“其他周转材料费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(rmatVO.getRmatCode())) {
                            itemEntity.setCode(String.valueOf(num));
                            num++;
                        } else {
                            itemEntity.setCode(rmatVO.getRmatCode());
                        }
                        itemEntity.setName(rmatVO.getRmatName());
                        itemEntity.setUnitName(rmatVO.getRmatUnitName());
                        itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                        itemEntity.setTaxRate(rmatVO.getRmatRate());
                        itemEntity.setPrice(rmatVO.getRmatPrice());
                        itemEntity.setTaxPrice(rmatVO.getRmatTaxPrice());
                        itemEntity.setAmount(rmatVO.getRmatNum());
                        itemEntity.setMny(rmatVO.getRmatMny());
                        itemEntity.setTaxMny(rmatVO.getRmatTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
            return dutyEntity;
        }
    }

    class EquipmentChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareEquipmentApi shareEquipmentApi;
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public EquipmentChangeCallable(IShareEquipmentApi shareEquipmentApi, BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareEquipmentApi = shareEquipmentApi;
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //机械设备费
            Long jxfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238542").equals(detailVO.getFeePropId())) {
                    jxfId = detailVO.getId();
                }
            }
            if (null == jxfId) {
                throw new BusinessException("费用模板中未配置【机械设备费】的费用项，无法转换！");
            }
            //机械设备费下的主键集合
            Set<Long> jxfSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(jxfId))) {
                    jxfSet.add(detailVO.getId());
                }
            }
            //其他机械设备费
            Long qtjxfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) && jxfSet.contains(detailVO.getId())) {
                    qtjxfId = detailVO.getId();
                }
            }
            if (null == qtjxfId) {
                throw new BusinessException("费用模板中未配置【其他机械设备费】的费用项，无法转换！");
            }

            CommonResponse<List<EquipmentCategoryVO>> equipCtyResponse = shareEquipmentApi.queryCategoryListByIds(new ArrayList<>());
            Map<Long, String> equipCtyLongInnerMap = new HashMap<>();
            Map<String, String> equipCtyStringInnerMap = new HashMap<>();
            for (EquipmentCategoryVO categoryVO : equipCtyResponse.getData()) {
                equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
            }

            List<String> codeList = new ArrayList<>();
            for (BuildEquipmentVO equipmentVO : buildDutyVO.getBuildEquipmentList()) {
                if (StringUtils.isNotBlank(equipmentVO.getEquipmentCode()) && equipmentVO.getEquipmentCode().matches("\\d.*")) {
                    String result = equipmentVO.getEquipmentCode().length() > 3 ? equipmentVO.getEquipmentCode().substring(0, equipmentVO.getEquipmentCode().length() - 3) : equipmentVO.getEquipmentCode();
                    equipmentVO.setEquipmentCode(result);
                    codeList.add(result);
                }
            }

            CommonResponse<List<EquipmentVO>> equipResponse = shareEquipmentApi.queryEquipmentListByCodes(codeList);
            Map<String, EquipmentVO> equipMap = new HashMap<>();
            if (equipResponse.isSuccess() && CollectionUtils.isNotEmpty(equipResponse.getData())) {
                equipMap = equipResponse.getData().stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
            }

            int num = 1;
            for (BuildEquipmentVO buildEquipmentVO : buildDutyVO.getBuildEquipmentList()) {
                if (null == buildEquipmentVO.getLeafFlag() || !buildEquipmentVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(buildEquipmentVO.getEquipmentCode()) && equipMap.containsKey(buildEquipmentVO.getEquipmentCode())) {
                        EquipmentVO equipmentVO = equipMap.get(buildEquipmentVO.getEquipmentCode());
                        String innerCode = equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(equipmentVO.getCode());
                            itemEntity.setName(equipmentVO.getName());
                            itemEntity.setModel(equipmentVO.getSpec());
                            itemEntity.setUnitId(equipmentVO.getUnitId());
                            itemEntity.setUnitName(equipmentVO.getUnitName());
                            itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                            itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                            itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                            itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                            itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                            itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                            itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                            itemEntity.setCategoryId(equipmentVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(equipmentVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.设备档案.getCode());
                            itemEntity.setDocId(equipmentVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (StringUtils.isNotBlank(buildEquipmentVO.getEquipmentCode()) && equipCtyStringInnerMap.containsKey(buildEquipmentVO.getEquipmentCode())) {//匹配到分类
                        String innerCode = equipCtyStringInnerMap.get(buildEquipmentVO.getEquipmentCode());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                            detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), buildEquipmentVO.getEquipmentNum()));
                            detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), buildEquipmentVO.getEquipmentMny()));
                            detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), buildEquipmentVO.getEquipmentTaxMny()));
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtjxfId)) {//匹配不到档案且子表为“其他机械设备费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(buildEquipmentVO.getEquipmentCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(buildEquipmentVO.getEquipmentCode());
                        }
                        itemEntity.setName(buildEquipmentVO.getEquipmentName());
                        itemEntity.setUnitName(buildEquipmentVO.getEquipmentUnitName());
                        itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                        itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                        itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                        itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                        itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                        itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                        itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                if (StringUtils.isBlank(buildEquipmentVO.getEquipmentCode())) {
                    num++;
                }
            }
            return dutyEntity;
        }
    }

    class OtherChangeCallable implements Callable<DutyEntity> {

        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public OtherChangeCallable(BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);

            //安全文明施工费
            dealAqwmsgfData(buildDutyVO, dutyEntity, feeVO);
            //临时设施费
            dealLsssfData(buildDutyVO, dutyEntity, feeVO);
            //其他措施费
            dealQtcsfData(buildDutyVO, dutyEntity, feeVO);
            //现场管理费
            dealXcglfData(buildDutyVO, dutyEntity, feeVO);
            //规费
            dealGfData(buildDutyVO, dutyEntity, feeVO);
            //其他费用
            dealOtherData(buildDutyVO, dutyEntity, feeVO);

            return dutyEntity;
        }


        private void dealAqwmsgfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //安全文明施工费
            Long aqwmsgfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("安全文明施工费".equals(detailVO.getName())) {
                    aqwmsgfId = detailVO.getId();
                }
            }
            int num = 1;
            for (BuildSafeVO safeVO : buildDutyVO.getBuildSafeList()) {
                if (null == safeVO.getLeafFlag() || !safeVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(aqwmsgfId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(safeVO.getSafeCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(safeVO.getSafeCode());
                        }
                        itemEntity.setName(safeVO.getSafeName());
                        itemEntity.setUnitName(safeVO.getSafeUnitName());
                        itemEntity.setTaxRate(safeVO.getSafeRate());
                        itemEntity.setPrice(safeVO.getSafePrice());
                        itemEntity.setTaxPrice(safeVO.getSafeTaxPrice());
                        itemEntity.setAmount(safeVO.getSafeNum());
                        itemEntity.setMny(safeVO.getSafeMny());
                        itemEntity.setTaxMny(safeVO.getSafeTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealLsssfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //临时设施费
            Long lsssfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("临时设施费".equals(detailVO.getName())) {
                    lsssfId = detailVO.getId();
                }
            }
            int num = 1;
            for (BuildTemporaryVO temporaryVO : buildDutyVO.getBuildTemporaryList()) {
                if (null == temporaryVO.getLeafFlag() || !temporaryVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(lsssfId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(temporaryVO.getTemporaryCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(temporaryVO.getTemporaryCode());
                        }
                        itemEntity.setName(temporaryVO.getTemporaryName());
                        itemEntity.setUnitName(temporaryVO.getTemporaryUnitName());
                        itemEntity.setTaxRate(temporaryVO.getTemporaryRate());
                        itemEntity.setPrice(temporaryVO.getTemporaryPrice());
                        itemEntity.setTaxPrice(temporaryVO.getTemporaryTaxPrice());
                        itemEntity.setAmount(temporaryVO.getTemporaryNum());
                        itemEntity.setMny(temporaryVO.getTemporaryMny());
                        itemEntity.setTaxMny(temporaryVO.getTemporaryTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealQtcsfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //其他措施费
            Long qtcsfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("其他措施费".equals(detailVO.getName())) {
                    qtcsfId = detailVO.getId();
                }
            }
            int num = 1;
            for (BuildMeasureVO measureVO : buildDutyVO.getBuildMeasureList()) {
                if (null == measureVO.getLeafFlag() || !measureVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(qtcsfId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(measureVO.getMeasureCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(measureVO.getMeasureCode());
                        }
                        itemEntity.setName(measureVO.getMeasureName());
                        itemEntity.setUnitName(measureVO.getMeasureUnitName());
                        itemEntity.setTaxRate(measureVO.getMeasureRate());
                        itemEntity.setPrice(measureVO.getMeasurePrice());
                        itemEntity.setTaxPrice(measureVO.getMeasureTaxPrice());
                        itemEntity.setAmount(measureVO.getMeasureNum());
                        itemEntity.setMny(measureVO.getMeasureMny());
                        itemEntity.setTaxMny(measureVO.getMeasureTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealXcglfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //现场管理费
            Long xcglfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("现场管理费".equals(detailVO.getName())) {
                    xcglfId = detailVO.getId();
                }
            }
            int num = 1;
            for (BuildManageVO manageVO : buildDutyVO.getBuildManageList()) {
                if (null == manageVO.getLeafFlag() || !manageVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(xcglfId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(manageVO.getManageCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(manageVO.getManageCode());
                        }
                        itemEntity.setName(manageVO.getManageName());
                        itemEntity.setUnitName(manageVO.getManageUnitName());
                        itemEntity.setTaxRate(manageVO.getManageRate());
                        itemEntity.setPrice(manageVO.getManagePrice());
                        itemEntity.setTaxPrice(manageVO.getManageTaxPrice());
                        itemEntity.setAmount(ComputeUtil.safeMultiply(manageVO.getManageNum(), manageVO.getManageDuration()));
                        itemEntity.setMny(manageVO.getManageMny());
                        itemEntity.setTaxMny(manageVO.getManageTaxMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealGfData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //规费
            Long gfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("规费".equals(detailVO.getName())) {
                    gfId = detailVO.getId();
                }
            }
            int num = 1;
            for (BuildFeesVO feesVO : buildDutyVO.getBuildFeesList()) {
                if (null == feesVO.getLeafFlag() || !feesVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(gfId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(feesVO.getFeesCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(feesVO.getFeesCode());
                        }
                        itemEntity.setName(feesVO.getFeesName());
                        itemEntity.setUnitName(feesVO.getFeesUnitName());
                        itemEntity.setPrice(feesVO.getFeesPrice());
                        itemEntity.setTaxPrice(feesVO.getFeesPrice());
                        itemEntity.setAmount(feesVO.getFeesNum());
                        itemEntity.setMny(feesVO.getFeesMny());
                        itemEntity.setTaxMny(feesVO.getFeesMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealOtherData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //其他费用
            Long otherId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("其他费用".equals(detailVO.getName())) {
                    otherId = detailVO.getId();
                }
            }
            int num = 1;
            for (BuildOtherVO otherVO : buildDutyVO.getBuildOtherList()) {
                if (null == otherVO.getLeafFlag() || !otherVO.getLeafFlag()) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(otherId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(otherVO.getOtherCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(otherVO.getOtherCode());
                        }
                        itemEntity.setName(otherVO.getOtherName());
                        itemEntity.setUnitName(otherVO.getOtherUnitName());
                        itemEntity.setPrice(otherVO.getOtherPrice());
                        itemEntity.setTaxPrice(otherVO.getOtherPrice());
                        itemEntity.setAmount(otherVO.getOtherNum());
                        itemEntity.setMny(otherVO.getOtherMny());
                        itemEntity.setTaxMny(otherVO.getOtherMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }
    }
}
