/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.pricelib.api.IMaterialPriceHistoryApi;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.prosub.api.IPriceContractCollectApi;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.DutyVO;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class ConversionBaseHandler {
    private static final String BILL_CODE = "TC_DUTY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IFeeService feeService;
    @Autowired
    private DutyMapper dutyMapper;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IMaterialPriceHistoryApi materialPriceHistoryApi;
    @Autowired
    private IPriceContractCollectApi priceContractCollectApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    public void handlerHead(DutyEntity dutyEntity, Boolean isEff, BaseVO baseVO) {
        if (!isEff.booleanValue()) {
            this.checkFeeId(dutyEntity);
            FeeVO feeVO = this.feeService.queryDetailForPush(dutyEntity.getFeeId(), false);
            this.checkFeeCode(feeVO);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getProjectId, (Object)dutyEntity.getProjectId());
            queryWrapper.eq(DutyEntity::getFirstImportId, (Object)dutyEntity.getFirstImportId());
            queryWrapper.eq(DutyEntity::getGatherFlag, (Object)false);
            queryWrapper.orderByDesc(DutyEntity::getDutyVersion);
            queryWrapper.last("limit 1");
            DutyEntity entity = (DutyEntity)((Object)this.dutyService.getOne((Wrapper)queryWrapper, false));
            if (null == entity) {
                dutyEntity.setId(IdWorker.getId());
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)dutyEntity), DutyVO.class)));
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                dutyEntity.setBillCode((String)billCode.getData());
                dutyEntity.setShowFlag(false);
                dutyEntity.setGatherFlag(false);
                dutyEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                dutyEntity.setLatestFlag(true);
                dutyEntity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
                dutyEntity.setEnableState(false);
                dutyEntity.setDutyVersion(1);
                dutyEntity.setFirstDutyId(dutyEntity.getId());
                dutyEntity.setCreateTime(null);
                dutyEntity.setCreateUserCode(null);
                dutyEntity.setVersion(1);
                this.mainSaveAndDealDetail(dutyEntity, feeVO, baseVO);
            } else {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(DutyEntity::getProjectId, (Object)dutyEntity.getProjectId());
                queryWrapper.eq(DutyEntity::getFirstImportId, (Object)dutyEntity.getFirstImportId());
                queryWrapper.eq(DutyEntity::getImportId, (Object)dutyEntity.getImportId());
                queryWrapper.last("limit 1");
                DutyEntity oldEntity = (DutyEntity)((Object)this.dutyService.getOne((Wrapper)queryWrapper, false));
                if (null == oldEntity) {
                    dutyEntity.setId(IdWorker.getId());
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)dutyEntity), DutyVO.class)));
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    dutyEntity.setBillCode((String)billCode.getData());
                    dutyEntity.setBeforeMny(null);
                    dutyEntity.setBeforeTaxMny(null);
                    dutyEntity.setLastDutyId(entity.getId());
                    dutyEntity.setShowFlag(false);
                    dutyEntity.setGatherFlag(false);
                    dutyEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                    dutyEntity.setLatestFlag(true);
                    dutyEntity.setEnableState(false);
                    dutyEntity.setDutyVersion(entity.getDutyVersion() + 1);
                    dutyEntity.setFirstDutyId(entity.getFirstDutyId());
                    dutyEntity.setCreateTime(null);
                    dutyEntity.setCreateUserCode(null);
                    this.mainSaveAndDealDetail(dutyEntity, feeVO, baseVO);
                    entity.setLatestFlag(false);
                    entity.setChangeId(dutyEntity.getId());
                    entity.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
                    this.dutyService.saveOrUpdate((Object)entity);
                } else {
                    if (oldEntity.getDutyVersion() < entity.getDutyVersion()) {
                        throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u540e\u7eed\u8d23\u4efb\u6210\u672c\u53d8\u66f4\u5355\u636e\uff01");
                    }
                    if (oldEntity.getEnableState().booleanValue()) {
                        oldEntity.setEnableState(false);
                        oldEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                        oldEntity.setShowFlag(false);
                        this.dutyService.saveOrUpdate((Object)oldEntity);
                        if (oldEntity.getLastDutyId() != null) {
                            DutyEntity revise = (DutyEntity)((Object)this.dutyService.getById(oldEntity.getLastDutyId()));
                            revise.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
                            revise.setEnableState(true);
                            revise.setShowFlag(true);
                            this.dutyService.saveOrUpdate((Object)revise);
                        }
                        this.dutyService.gatherDuty(oldEntity.getId());
                        this.totalExecutionService.reCalc(oldEntity.getProjectId());
                    } else {
                        dutyEntity.setId(IdWorker.getId());
                        dutyEntity.setBeforeMny(null);
                        dutyEntity.setBeforeTaxMny(null);
                        dutyEntity.setBillCode(oldEntity.getBillCode());
                        dutyEntity.setLastDutyId(oldEntity.getLastDutyId());
                        dutyEntity.setShowFlag(false);
                        dutyEntity.setGatherFlag(false);
                        dutyEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                        dutyEntity.setLatestFlag(true);
                        dutyEntity.setEnableState(false);
                        dutyEntity.setDutyVersion(oldEntity.getDutyVersion());
                        dutyEntity.setFirstDutyId(oldEntity.getFirstDutyId());
                        dutyEntity.setCreateTime(null);
                        dutyEntity.setCreateUserCode(null);
                        this.mainSaveAndDealDetail(dutyEntity, feeVO, baseVO);
                        this.dutyMapper.deleteByDutyIdPhy(oldEntity.getId());
                        this.dutyDetailService.deleteByDutyIdPhy(oldEntity.getId());
                        this.dutyDetailItemService.deleteByDutyIdPhy(oldEntity.getId());
                        if (entity.getLastDutyId() != null) {
                            DutyEntity revise = (DutyEntity)((Object)this.dutyService.getById(entity.getLastDutyId()));
                            revise.setLatestFlag(false);
                            revise.setChangeId(dutyEntity.getId());
                            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
                            this.dutyService.saveOrUpdate((Object)revise);
                        }
                    }
                }
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DutyEntity::getProjectId, (Object)dutyEntity.getProjectId());
            queryWrapper.eq(DutyEntity::getFirstImportId, (Object)dutyEntity.getFirstImportId());
            queryWrapper.eq(DutyEntity::getImportId, (Object)dutyEntity.getImportId());
            queryWrapper.last("limit 1");
            DutyEntity oldEntity = (DutyEntity)((Object)this.dutyService.getOne((Wrapper)queryWrapper, false));
            oldEntity.setEnableState(true);
            oldEntity.setShowFlag(true);
            oldEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            this.dutyService.saveOrUpdate((Object)oldEntity);
            if (oldEntity.getLastDutyId() != null) {
                DutyEntity revise = (DutyEntity)((Object)this.dutyService.getById(oldEntity.getLastDutyId()));
                revise.setChangeState(ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
                revise.setEnableState(false);
                this.dutyService.saveOrUpdate((Object)revise);
            }
            this.dutyService.gatherDuty(oldEntity.getId());
            this.totalExecutionService.reCalc(oldEntity.getProjectId());
        }
    }

    public void deleteDuty(Long importId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getImportId, (Object)importId);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.getOne((Wrapper)queryWrapper, false));
        if (null != dutyEntity) {
            this.dutyMapper.deleteByDutyIdPhy(dutyEntity.getId());
            this.dutyDetailService.deleteByDutyIdPhy(dutyEntity.getId());
            this.dutyDetailItemService.deleteByDutyIdPhy(dutyEntity.getId());
        }
    }

    private void mainSaveAndDealDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        ArrayList<DutyDetailEntity> detailEntities = new ArrayList<DutyDetailEntity>();
        HashMap<Long, Long> pMap = new HashMap<Long, Long>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            DutyDetailEntity detailEntity = (DutyDetailEntity)((Object)BeanMapper.map((Object)detailVO, DutyDetailEntity.class));
            Long newId = IdWorker.getId();
            pMap.put(detailEntity.getId(), newId);
            detailEntity.setId(newId);
            detailEntity.setDutyId(dutyEntity.getId());
            detailEntity.setFeeDetailId(detailVO.getId());
            detailEntity.setFeeDetailCode(detailVO.getCode());
            detailEntity.setFeeDetailName(detailVO.getName());
            detailEntity.setSubjectId(detailVO.getSubjectId());
            detailEntity.setSubjectCode(detailVO.getSubjectCode());
            detailEntity.setSubjectName(detailVO.getSubjectName());
            detailEntity.setOrgId(dutyEntity.getOrgId());
            detailEntity.setOrgName(dutyEntity.getOrgName());
            detailEntity.setProjectId(dutyEntity.getProjectId());
            detailEntity.setProjectName(dutyEntity.getProjectName());
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setVersion(1);
            detailEntities.add(detailEntity);
        }
        for (DutyDetailEntity detailEntity : detailEntities) {
            detailEntity.setParentId((Long)pMap.get(detailEntity.getParentId()));
            detailEntity.setInvolveFlag(false);
        }
        dutyEntity.setDutyDetailList(detailEntities);
        List<DutyEntity> dutyList = this.handlerDetail(dutyEntity, feeVO, baseVO);
        this.gatherCallableData(dutyEntity, dutyList);
        List<DutyDetailItemEntity> itemEntities = this.fullMnyAndBaseInfo(dutyEntity);
        this.dutyService.saveOrUpdate((Object)dutyEntity, false);
        this.dutyDetailItemService.saveOrUpdateBatch(itemEntities);
    }

    private void gatherCallableData(DutyEntity dutyEntity, List<DutyEntity> dutyList) {
        if (CollectionUtils.isNotEmpty(dutyList)) {
            Map map = dutyEntity.getDutyDetailList().stream().collect(Collectors.toMap(DutyDetailEntity::getFeeDetailId, Function.identity(), (key1, key2) -> key1));
            for (DutyEntity duty : dutyList) {
                for (DutyDetailEntity detailEntity : duty.getDutyDetailList()) {
                    DutyDetailEntity baseDetail = (DutyDetailEntity)((Object)map.get(detailEntity.getFeeDetailId()));
                    baseDetail.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)baseDetail.getPreTypeAmount(), (BigDecimal)detailEntity.getPreTypeAmount()));
                    baseDetail.setMny(ComputeUtil.safeAdd((BigDecimal)baseDetail.getMny(), (BigDecimal)detailEntity.getMny()));
                    baseDetail.setTaxMny(ComputeUtil.safeAdd((BigDecimal)baseDetail.getTaxMny(), (BigDecimal)detailEntity.getTaxMny()));
                    if (!CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList())) continue;
                    baseDetail.getDutyDetailItemList().addAll(detailEntity.getDutyDetailItemList());
                }
            }
        }
    }

    public abstract List<DutyEntity> handlerDetail(DutyEntity var1, FeeVO var2, BaseVO var3);

    public abstract void checkFeeCode(FeeVO var1);

    private List<DutyDetailItemEntity> fullMnyAndBaseInfo(DutyEntity dutyEntity) {
        ArrayList<DutyDetailItemEntity> itemList = new ArrayList<DutyDetailItemEntity>();
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashSet<Long> subIdSet = new HashSet<Long>();
        CommonResponse subjectResponse = this.shareSubjectOrgApi.shareSubjectOrgApi();
        HashMap<Long, SubjectOrgVO> idSubjectMap = new HashMap<Long, SubjectOrgVO>();
        HashMap<String, SubjectOrgVO> nameSubjectMap = new HashMap<String, SubjectOrgVO>();
        if (subjectResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)subjectResponse.getData()))) {
            for (SubjectOrgVO subjectOrgVO : (List)subjectResponse.getData()) {
                idSubjectMap.put(subjectOrgVO.getId(), subjectOrgVO);
                nameSubjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO);
            }
        }
        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList())) {
                for (DutyDetailItemEntity itemEntity : detailEntity.getDutyDetailItemList()) {
                    SubjectOrgVO subjectOrgVO;
                    itemEntity.setDutyId(dutyEntity.getId());
                    itemEntity.setDutyDetailId(detailEntity.getId());
                    itemEntity.setOrgId(dutyEntity.getOrgId());
                    itemEntity.setOrgName(dutyEntity.getOrgName());
                    itemEntity.setProjectId(dutyEntity.getProjectId());
                    itemEntity.setProjectName(dutyEntity.getProjectName());
                    itemEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                    itemEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                    itemEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    if (StringUtils.isNotBlank((CharSequence)itemEntity.getSubjectName()) && nameSubjectMap.containsKey(itemEntity.getSubjectName())) {
                        subjectOrgVO = (SubjectOrgVO)nameSubjectMap.get(itemEntity.getSubjectName());
                        itemEntity.setSubjectId(subjectOrgVO.getId());
                        itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                        itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
                        itemEntity.setSubjectInnerCode(subjectOrgVO.getInnerCode());
                    } else if (null != detailEntity.getSubjectId()) {
                        subjectOrgVO = (SubjectOrgVO)idSubjectMap.get(detailEntity.getSubjectId());
                        itemEntity.setSubjectId(detailEntity.getSubjectId());
                        itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                        itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
                        itemEntity.setSubjectInnerCode(subjectOrgVO.getInnerCode());
                    } else {
                        itemEntity.setSubjectName(null);
                    }
                    detailEntity.setGatherMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getGatherMny(), (BigDecimal)itemEntity.getMny()));
                    detailEntity.setGatherTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getGatherTaxMny(), (BigDecimal)itemEntity.getTaxMny()));
                    if (null != itemEntity.getDocType() && DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(itemEntity.getDocType()) && null != itemEntity.getDocId()) {
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)itemEntity.getAmount()));
                        materialIdSet.add(itemEntity.getDocId());
                    }
                    if (null == itemEntity.getDocType() || !DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode().equals(itemEntity.getDocType()) && !DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(itemEntity.getDocType()) || null == itemEntity.getDocId()) continue;
                    subIdSet.add(itemEntity.getDocId());
                }
                itemList.addAll(detailEntity.getDutyDetailItemList());
                if (null == detailEntity.getMny() || ComputeUtil.isGreaterThan((BigDecimal)detailEntity.getGatherMny(), (BigDecimal)detailEntity.getMny())) {
                    detailEntity.setMny(detailEntity.getGatherMny());
                    detailEntity.setTaxMny(detailEntity.getGatherTaxMny());
                }
            }
            detailEntity.setPreTypeAmount(ComputeUtil.scale((BigDecimal)detailEntity.getPreTypeAmount(), (int)4));
            detailEntity.setMny(ComputeUtil.scaleTwo((BigDecimal)detailEntity.getMny()));
            detailEntity.setTaxMny(ComputeUtil.scaleTwo((BigDecimal)detailEntity.getTaxMny()));
            detailEntity.setGatherMny(ComputeUtil.scaleTwo((BigDecimal)detailEntity.getGatherMny()));
            detailEntity.setGatherTaxMny(ComputeUtil.scaleTwo((BigDecimal)detailEntity.getGatherTaxMny()));
        }
        this.fullGuaidPrice(itemList, materialIdSet, subIdSet);
        List resultMapList = BeanMapper.mapList(dutyEntity.getDutyDetailList(), Map.class);
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        this.gatherMny(null, treeData);
        ArrayList<DutyDetailEntity> entities = new ArrayList<DutyDetailEntity>();
        this.treeToList(treeData, entities);
        dutyEntity.setDutyDetailList(entities);
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (null == detailEntity.getParentId()) {
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)detailEntity.getMny());
                totalTaxMny = ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)detailEntity.getTaxMny());
            }
            if (null != detailEntity.getCategoryId() || !StringUtils.isNotBlank((CharSequence)detailEntity.getCategoryInnerCode()) || !detailEntity.getCategoryInnerCode().contains("&")) continue;
            detailEntity.setCategoryInnerCode(null);
        }
        dutyEntity.setMny(ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)dutyEntity.getUnExceptMny()));
        dutyEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)dutyEntity.getTax(), (BigDecimal)dutyEntity.getUnExceptMny())));
        return itemList;
    }

    private void fullGuaidPrice(List<DutyDetailItemEntity> itemList, Set<Long> materialIdSet, Set<Long> subIdSet) {
        CommonResponse response;
        CommonResponse response2;
        Map<Object, Object> matPriceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(materialIdSet) && (response2 = this.materialPriceHistoryApi.getMaterialPriceHistoryApiVOS(new ArrayList<Long>(materialIdSet))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response2.getData()))) {
            matPriceMap = ((List)response2.getData()).stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity(), (key1, key2) -> key1));
        }
        Map<Object, Object> subPriceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(subIdSet) && (response = this.priceContractCollectApi.getPriceContractByDocIds(new ArrayList<Long>(subIdSet))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            subPriceMap = ((List)response.getData()).stream().collect(Collectors.toMap(PriceContractCollectVO::getDocId, Function.identity(), (key1, key2) -> key1));
        }
        for (DutyDetailItemEntity itemEntity : itemList) {
            MaterialPriceHistoryApiVO historyVO;
            if (null != itemEntity.getDocType() && DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(itemEntity.getDocType()) && null != itemEntity.getDocId() && matPriceMap.containsKey(itemEntity.getDocId())) {
                historyVO = (MaterialPriceHistoryApiVO)matPriceMap.get(itemEntity.getDocId());
                itemEntity.setHistoricalPrice(historyVO.getHistoryPriceArea());
                itemEntity.setGuidePriceArea(historyVO.getGuidePriceArea());
            }
            if (null == itemEntity.getDocType() || !DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode().equals(itemEntity.getDocType()) && !DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(itemEntity.getDocType()) || null == itemEntity.getDocId() || !subPriceMap.containsKey(itemEntity.getDocId())) continue;
            historyVO = (PriceContractCollectVO)subPriceMap.get(itemEntity.getDocId());
            itemEntity.setHistoricalPrice(historyVO.getContractPriceArea());
            itemEntity.setGuidePriceArea(historyVO.getGuidePriceArea());
        }
    }

    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal gatherMny = null;
        BigDecimal gatherTaxMny = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMny(ypd, (List)ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, (BigDecimal)this.getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, (BigDecimal)this.getBigDecimalValue(ypd, "taxMny"));
            gatherMny = ComputeUtil.safeAdd(gatherMny, (BigDecimal)this.getBigDecimalValue(ypd, "gatherMny"));
            gatherTaxMny = ComputeUtil.safeAdd(gatherTaxMny, (BigDecimal)this.getBigDecimalValue(ypd, "gatherTaxMny"));
        }
        if (now != null) {
            now.put("gatherMny", gatherMny);
            now.put("gatherTaxMny", gatherTaxMny);
            if (ComputeUtil.isGreaterThan((BigDecimal)mny, (BigDecimal)this.getBigDecimalValue(now, "mny")) || ComputeUtil.isGreaterThan((BigDecimal)taxMny, (BigDecimal)this.getBigDecimalValue(now, "taxMny"))) {
                now.put("mny", mny);
                now.put("taxMny", taxMny);
            }
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<DutyDetailEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((DutyDetailEntity)((Object)BeanMapper.map(ypd, DutyDetailEntity.class)));
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }

    private void checkFeeId(DutyEntity dutyEntity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getProjectId, (Object)dutyEntity.getProjectId());
        queryWrapper.ne(DutyEntity::getImportId, (Object)dutyEntity.getImportId());
        List list = this.dutyService.list((Wrapper)queryWrapper);
        for (DutyEntity dbDutyEntity : list) {
            if (dbDutyEntity.getFeeId().compareTo(dutyEntity.getFeeId()) == 0) continue;
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u4f7f\u7528\u540c\u4e00\u8d39\u7528\u6a21\u677f\uff01");
        }
    }
}

