/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.vo.RuleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rule"})
public class RuleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRuleService ruleService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RuleVO> saveOrUpdate(@RequestBody RuleVO ruleVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.ruleService.insertOrUpdate(ruleVO)));
    }

    @RequestMapping(value={"/tempSaveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RuleVO> tempSaveOrUpdate(@RequestBody RuleVO ruleVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.ruleService.tempSaveOrUpdate(ruleVO)));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RuleVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.ruleService.queryDetail(id)));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RuleVO> vos) {
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            for (RuleVO ruleVO : vos) {
                RuleVO ruleVO1 = this.ruleService.queryDetail(ruleVO.getId());
                if (ruleVO1.getOrgId() != Long.parseLong("1502571152583692289")) continue;
                throw new BusinessException("\u7ec4\u7ec7\u540d\u79f0\u4e3a\u3010\u90d1\u5dde\u4e00\u5efa\u96c6\u56e2\u3011\uff0c\u53ea\u5141\u8bb8\u67e5\u770b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
        }
        this.ruleService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RuleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(InvocationInfoProxy.getOrgId());
        orgIds.add(Long.parseLong("1502571152583692289"));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("in", orgIds));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.ruleService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRuleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RuleVO>> refRuleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (con = JSONObject.parseObject((String)condition)).containsKey((Object)"feeId")) {
            param.getParams().put("feeId", new Parameter("eq", con.get((Object)"feeId")));
        }
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        param.getParams().put("tenantId", new Parameter("in", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.ruleService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateEnable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateEnable(@RequestParam(value="id") Long id, @RequestParam(value="enabled") Boolean enabled) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.ruleService.updateEnable(id, enabled));
    }

    @RequestMapping(value={"/copySave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RuleVO> copySave(@RequestBody RuleVO ruleVO) {
        return CommonResponse.success((String)"\u590d\u5236\u65b0\u589e\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.ruleService.copySave(ruleVO)));
    }
}

