/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyEquipDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyHisVO;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyMaterialDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"buildDuty"})
public class BuildDutyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBuildDutyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;

    @RequestMapping(value={"/ConvertFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BuildDutyVO> ConvertFlag(Long id) {
        return CommonResponse.success((String)"\u8f6c\u6362\u6210\u529f\uff01", (Object)this.service.ConvertFlag(id));
    }

    @RequestMapping(value={"/downloadTemplate"})
    @ResponseBody
    public void downloadInfo(@RequestParam String type, HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        String fileName = null;
        switch (type) {
            case "laborFee": {
                fileName = "\u4eba\u5de5\u8d39\u5bfc\u5165\u6a21\u7248";
                break;
            }
            case "materialFee": {
                fileName = "\u6750\u6599\u8d39\u5bfc\u5165\u6a21\u7248";
                break;
            }
            case "prosubFee": {
                fileName = "\u4e13\u4e1a\u5206\u5305\u8d39\u5bfc\u5165\u6a21\u7248";
                break;
            }
            case "equipFee": {
                fileName = "\u673a\u68b0\u8d39\u5bfc\u5165\u6a21\u7248";
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new BusinessException("\u9519\u8bef\u7684\u6a21\u677f\u7c7b\u578b:" + type);
        }
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)(type + "ImportTemplate.xlsx"), (String)fileName);
    }

    @PostMapping(value={"/laborFeeExcelImport"})
    public CommonResponse<JSONObject> laborFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");
        if (StringUtils.isBlank((CharSequence)categoryIds)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1a\u7269\u6599\u5206\u7c7b\u4e3b\u952e\u5217\u8868[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));
        mf = this.excelImportFileCheck(fileMap);
        ArrayList<BuildDutyLaborCostDetailVO> successList = new ArrayList<BuildDutyLaborCostDetailVO>();
        ArrayList<BuildDutyLaborCostDetailVO> processList = new ArrayList<BuildDutyLaborCostDetailVO>();
        ArrayList<BuildDutyLaborCostDetailVO> errorList = new ArrayList<BuildDutyLaborCostDetailVO>();
        HashMap categoryMap = new HashMap();
        ArrayList<BuildDutyLaborCostDetailVO> docList = new ArrayList<BuildDutyLaborCostDetailVO>();
        HashSet<String> docCodes = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            BuildDutyLaborCostDetailVO vo = null;
            for (int i = 2; i < result.size(); ++i) {
                block27: {
                    List datas = (List)result.get(i);
                    vo = new BuildDutyLaborCostDetailVO();
                    vo.setLaborDocCode((String)datas.get(0));
                    vo.setLaborDocName((String)datas.get(1));
                    vo.setLaborDocSpec((String)datas.get(2));
                    vo.setLaborUnitName((String)datas.get(3));
                    if (StringUtils.isBlank((CharSequence)vo.getLaborDocCode())) {
                        vo.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)vo.getLaborDocName())) {
                        vo.setErrorMsg("\u3010\u6e05\u5355\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                        vo.setErrorMsg("\u3010\u5de5\u7a0b\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    try {
                        vo.setLaborNum(ComputeUtil.toBigDecimal((String)((String)datas.get(4))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u5de5\u7a0b\u91cf\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                        try {
                            vo.setLaborIncomePrice(ComputeUtil.toBigDecimal((String)((String)datas.get(5))));
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6536\u5165-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        try {
                            vo.setLaborCostRate(ComputeUtil.toBigDecimal((String)((String)datas.get(7))));
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u7a0e\u7387\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        try {
                            vo.setLaborCostPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(8))));
                            break block27;
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setRowState("add");
                vo.setLaborIncomeMny(ComputeUtil.safeMultiply((BigDecimal)vo.getLaborNum(), (BigDecimal)vo.getLaborIncomePrice()));
                vo.setLaborCostMny(ComputeUtil.safeMultiply((BigDecimal)vo.getLaborNum(), (BigDecimal)vo.getLaborCostPrice()));
                vo.setLaborCostTaxPrice(ComputeUtil.safeMultiply((BigDecimal)vo.getLaborCostPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getLaborCostRate(), (BigDecimal)new BigDecimal("100")))));
                vo.setLaborCostTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getLaborNum(), (BigDecimal)vo.getLaborCostTaxPrice()));
                vo.setLaborProfitAndLossMny(ComputeUtil.safeSub((BigDecimal)vo.getLaborIncomeMny(), (BigDecimal)vo.getLaborCostMny()));
                vo.setLaborCostTax(ComputeUtil.safeSub((BigDecimal)vo.getLaborCostTaxMny(), (BigDecimal)vo.getLaborCostMny()));
                docCodes.add(vo.getLaborDocCode());
                processList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(processList)) {
                CommonResponse codeResp = this.labsubApi.queryItemListByCodes(new ArrayList(docCodes));
                if (!codeResp.isSuccess()) {
                    this.logger.error("\u4eba\u5de5\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u52b3\u52a1\u5206\u5305\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List itemVOS = (List)codeResp.getData();
                List docCategoryIds = itemVOS.stream().map(LabsubItemVO::getCategoryId).collect(Collectors.toList());
                CommonResponse docCategoryResp = this.labsubApi.queryCategoryListByIds(docCategoryIds);
                if (!docCategoryResp.isSuccess()) {
                    this.logger.error("\u4eba\u5de5\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u6599\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                }
                Map<String, String> categoryInnerCode = ((List)docCategoryResp.getData()).stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));
                Map itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getTrawlingCode(), Function.identity()));
                LabsubItemVO tempItem = null;
                String categoryId = null;
                for (BuildDutyLaborCostDetailVO detail : processList) {
                    tempItem = (LabsubItemVO)itemMap.get(detail.getLaborDocCode());
                    categoryId = null;
                    if (null == tempItem) {
                        detail.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5339\u914d\u9879\uff01");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setLaborDocName(tempItem.getTrawlingName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setLaborDocSpec(tempItem.getDetailMeasurementRules());
                    detail.setLaborUnitName(tempItem.getUnitName());
                    detail.setLaborDocId(tempItem.getId());
                    for (String docCategoryId : categoyList) {
                        if (!docCategoryId.equals(detail.getDocCategoryId()) && (!categoryInnerCode.containsKey(detail.getDocCategoryId()) || !categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) continue;
                        categoryId = docCategoryId;
                        break;
                    }
                    if (StringUtils.isNotBlank(categoryId)) {
                        if (!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList());
                        }
                        ((List)categoryMap.get(categoryId)).add(detail);
                    } else {
                        docList.add(detail);
                    }
                    successList.add(detail);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/prosubFeeExcelImport"})
    public CommonResponse<JSONObject> prosubFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");
        if (StringUtils.isBlank((CharSequence)categoryIds)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1a\u7269\u6599\u5206\u7c7b\u4e3b\u952e\u5217\u8868[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));
        mf = this.excelImportFileCheck(fileMap);
        ArrayList<BuildDutyProSubDetailVO> successList = new ArrayList<BuildDutyProSubDetailVO>();
        ArrayList<BuildDutyProSubDetailVO> processList = new ArrayList<BuildDutyProSubDetailVO>();
        ArrayList<BuildDutyProSubDetailVO> errorList = new ArrayList<BuildDutyProSubDetailVO>();
        HashMap categoryMap = new HashMap();
        ArrayList<BuildDutyProSubDetailVO> docList = new ArrayList<BuildDutyProSubDetailVO>();
        HashSet<String> docCodes = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            BuildDutyProSubDetailVO vo = null;
            for (int i = 2; i < result.size(); ++i) {
                block27: {
                    List datas = (List)result.get(i);
                    vo = new BuildDutyProSubDetailVO();
                    vo.setProSubDocCode((String)datas.get(0));
                    vo.setProSubDocName((String)datas.get(1));
                    vo.setProSubDocSpec((String)datas.get(2));
                    vo.setProSubUnitName((String)datas.get(3));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                        vo.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        vo.setErrorMsg("\u3010\u6e05\u5355\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                        vo.setErrorMsg("\u3010\u5de5\u7a0b\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    try {
                        vo.setProSubNum(ComputeUtil.toBigDecimal((String)((String)datas.get(4))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u5de5\u7a0b\u91cf\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                        try {
                            vo.setProSubIncomePrice(ComputeUtil.toBigDecimal((String)((String)datas.get(5))));
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6536\u5165-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        try {
                            vo.setProSubCostRate(ComputeUtil.toBigDecimal((String)((String)datas.get(7))));
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u7a0e\u7387\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        try {
                            vo.setProSubCostPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(8))));
                            break block27;
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setRowState("add");
                vo.setProSubIncomeMny(ComputeUtil.safeMultiply((BigDecimal)vo.getProSubNum(), (BigDecimal)vo.getProSubIncomePrice()));
                vo.setProSubCostMny(ComputeUtil.safeMultiply((BigDecimal)vo.getProSubNum(), (BigDecimal)vo.getProSubCostPrice()));
                vo.setProSubCostTaxPrice(ComputeUtil.safeMultiply((BigDecimal)vo.getProSubCostPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getProSubCostRate(), (BigDecimal)new BigDecimal("100")))));
                vo.setProSubCostTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getProSubNum(), (BigDecimal)vo.getProSubCostTaxPrice()));
                vo.setProSubProfitAndLossMny(ComputeUtil.safeSub((BigDecimal)vo.getProSubIncomeMny(), (BigDecimal)vo.getProSubCostMny()));
                vo.setProSubTax(ComputeUtil.safeSub((BigDecimal)vo.getProSubCostTaxMny(), (BigDecimal)vo.getProSubCostMny()));
                docCodes.add(vo.getProSubDocCode());
                processList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(processList)) {
                CommonResponse codeResp = this.prosubApi.queryItemListByCodes(new ArrayList(docCodes));
                if (!codeResp.isSuccess()) {
                    this.logger.error("\u4e13\u4e1a\u5206\u5305\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u4e13\u4e1a\u5206\u5305\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List itemVOS = (List)codeResp.getData();
                List docCategoryIds = itemVOS.stream().map(ProsubItemVO::getCategoryId).collect(Collectors.toList());
                CommonResponse docCategoryResp = this.prosubApi.queryCategoryListByIds(docCategoryIds);
                if (!docCategoryResp.isSuccess()) {
                    this.logger.error("\u4e13\u4e1a\u5206\u5305\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u6599\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                }
                Map<String, String> categoryInnerCode = ((List)docCategoryResp.getData()).stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));
                Map itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getTrawlingCode(), Function.identity()));
                ProsubItemVO tempItem = null;
                String categoryId = null;
                for (BuildDutyProSubDetailVO detail : processList) {
                    tempItem = (ProsubItemVO)itemMap.get(detail.getProSubDocCode());
                    categoryId = null;
                    if (null == tempItem) {
                        detail.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5339\u914d\u9879\uff01");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setProSubDocName(tempItem.getTrawlingName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setProSubDocSpec(tempItem.getDetailMeasurementRules());
                    detail.setProSubUnitName(tempItem.getUnitName());
                    detail.setProSubDocId(tempItem.getId());
                    for (String docCategoryId : categoyList) {
                        if (!docCategoryId.equals(detail.getDocCategoryId()) && (!categoryInnerCode.containsKey(detail.getDocCategoryId()) || !categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) continue;
                        categoryId = docCategoryId;
                        break;
                    }
                    if (StringUtils.isNotBlank(categoryId)) {
                        if (!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList());
                        }
                        ((List)categoryMap.get(categoryId)).add(detail);
                    } else {
                        docList.add(detail);
                    }
                    successList.add(detail);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/materialFeeExcelImport"})
    public CommonResponse<JSONObject> materialFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");
        if (StringUtils.isBlank((CharSequence)categoryIds)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1a\u7269\u6599\u5206\u7c7b\u4e3b\u952e\u5217\u8868[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));
        mf = this.excelImportFileCheck(fileMap);
        ArrayList<BuildDutyMaterialDetailVO> successList = new ArrayList<BuildDutyMaterialDetailVO>();
        ArrayList<BuildDutyMaterialDetailVO> processList = new ArrayList<BuildDutyMaterialDetailVO>();
        ArrayList<BuildDutyMaterialDetailVO> errorList = new ArrayList<BuildDutyMaterialDetailVO>();
        HashMap categoryMap = new HashMap();
        ArrayList<BuildDutyMaterialDetailVO> docList = new ArrayList<BuildDutyMaterialDetailVO>();
        HashSet<String> docCodes = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            BuildDutyMaterialDetailVO vo = null;
            for (int i = 2; i < result.size(); ++i) {
                List datas;
                block27: {
                    datas = (List)result.get(i);
                    vo = new BuildDutyMaterialDetailVO();
                    vo.setMaterialDocCode((String)datas.get(0));
                    vo.setMaterialDocName((String)datas.get(1));
                    vo.setMaterialDocSpec((String)datas.get(2));
                    vo.setMaterialUnitName((String)datas.get(3));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                        vo.setErrorMsg("\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        vo.setErrorMsg("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                        vo.setErrorMsg("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    try {
                        vo.setMaterialNum(ComputeUtil.toBigDecimal((String)((String)datas.get(4))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u5de5\u7a0b\u91cf\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                        try {
                            vo.setMaterialIncomePrice(ComputeUtil.toBigDecimal((String)((String)datas.get(5))));
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6536\u5165-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        try {
                            vo.setMaterialCostPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(8))));
                            break block27;
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        vo.setMaterialCostRate(ComputeUtil.toBigDecimal((String)((String)datas.get(7))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u6210\u672c-\u7a0e\u7387\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                vo.setRowState("add");
                vo.setMaterialIncomeMny(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialNum(), (BigDecimal)vo.getMaterialIncomePrice()));
                vo.setMaterialCostMny(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialNum(), (BigDecimal)vo.getMaterialCostPrice()));
                vo.setMaterialCostTaxPrice(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialCostPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getMaterialCostRate(), (BigDecimal)new BigDecimal("100")))));
                vo.setMaterialCostTaxMny(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialNum(), (BigDecimal)vo.getMaterialCostTaxPrice()));
                vo.setMaterialProfitAndLossMny(ComputeUtil.safeSub((BigDecimal)vo.getMaterialIncomeMny(), (BigDecimal)vo.getMaterialCostMny()));
                vo.setMaterialCostTax(ComputeUtil.safeSub((BigDecimal)vo.getMaterialCostTaxMny(), (BigDecimal)vo.getMaterialCostMny()));
                docCodes.add(vo.getMaterialDocCode());
                processList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(processList)) {
                CommonResponse codeResp = this.materialApi.queryMaterialListByCodes(new ArrayList(docCodes));
                if (!codeResp.isSuccess()) {
                    this.logger.error("\u6750\u6599\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u6599\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u7269\u6599\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List itemVOS = (List)codeResp.getData();
                List docCategoryIds = itemVOS.stream().map(MaterialVO::getCategoryId).collect(Collectors.toList());
                CommonResponse docCategoryResp = this.materialApi.queryCategoryListByIds(docCategoryIds);
                if (!docCategoryResp.isSuccess()) {
                    this.logger.error("\u6750\u6599\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u6599\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                }
                Map<String, String> categoryInnerCode = ((List)docCategoryResp.getData()).stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));
                Map itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getCode(), Function.identity()));
                MaterialVO tempItem = null;
                String categoryId = null;
                for (BuildDutyMaterialDetailVO detail : processList) {
                    tempItem = (MaterialVO)itemMap.get(detail.getMaterialDocCode());
                    categoryId = null;
                    if (null == tempItem) {
                        detail.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5339\u914d\u9879\uff01");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setMaterialDocName(tempItem.getName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setMaterialDocSpec(tempItem.getSpec());
                    detail.setMaterialUnitName(tempItem.getUnitName());
                    detail.setMaterialDocId(tempItem.getId());
                    for (String docCategoryId : categoyList) {
                        if (!docCategoryId.equals(detail.getDocCategoryId()) && (!categoryInnerCode.containsKey(detail.getDocCategoryId()) || !categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) continue;
                        categoryId = docCategoryId;
                        break;
                    }
                    if (StringUtils.isNotBlank(categoryId)) {
                        if (!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList());
                        }
                        this.logger.info("categoryDetail:{}\uff0cactCatetgoryId:{}", (Object)JSONObject.toJSONString((Object)detail), (Object)categoryId);
                        ((List)categoryMap.get(categoryId)).add(detail);
                    } else {
                        docList.add(detail);
                        this.logger.info("doc:{}", (Object)JSONObject.toJSONString((Object)detail), (Object)categoryId);
                    }
                    successList.add(detail);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/equipFeeExcelImport"})
    public CommonResponse<JSONObject> equipFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");
        if (StringUtils.isBlank((CharSequence)categoryIds)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1a\u7269\u6599\u5206\u7c7b\u4e3b\u952e\u5217\u8868[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));
        mf = this.excelImportFileCheck(fileMap);
        ArrayList<BuildDutyEquipDetailVO> successList = new ArrayList<BuildDutyEquipDetailVO>();
        ArrayList<BuildDutyEquipDetailVO> processList = new ArrayList<BuildDutyEquipDetailVO>();
        ArrayList<BuildDutyEquipDetailVO> errorList = new ArrayList<BuildDutyEquipDetailVO>();
        HashMap categoryMap = new HashMap();
        ArrayList<BuildDutyEquipDetailVO> docList = new ArrayList<BuildDutyEquipDetailVO>();
        HashSet<String> docCodes = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            BuildDutyEquipDetailVO vo = null;
            for (int i = 2; i < result.size(); ++i) {
                List datas;
                block29: {
                    datas = (List)result.get(i);
                    vo = new BuildDutyEquipDetailVO();
                    vo.setEquipDocCode((String)datas.get(0));
                    vo.setEquipDocName((String)datas.get(1));
                    vo.setEquipDocSpec((String)datas.get(2));
                    vo.setEquipUnitName((String)datas.get(3));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                        vo.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        vo.setErrorMsg("\u3010\u6e05\u5355\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                        vo.setErrorMsg("\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    try {
                        vo.setEquipNum(ComputeUtil.toBigDecimal((String)((String)datas.get(6))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u6570\u91cf\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    try {
                        vo.setEquipIncomeMny(ComputeUtil.toBigDecimal((String)((String)datas.get(4))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u6536\u5165-\u91d1\u989d(\u65e0\u7a0e)\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                        try {
                            vo.setEquipCostRate(ComputeUtil.toBigDecimal((String)((String)datas.get(5))));
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u7a0e\u7387\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        try {
                            vo.setEquipCostPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(8))));
                            break block29;
                        }
                        catch (Exception e) {
                            vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    vo.setErrorMsg("\u3010\u6210\u672c-\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        vo.setEquipRentDays(ComputeUtil.toBigDecimal((String)((String)datas.get(7))));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u6210\u672c-\u79df\u671f\u3011\u53ea\u80fd\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                vo.setRowState("add");
                vo.setEquipCostMny(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)vo.getEquipNum(), (BigDecimal)vo.getEquipCostPrice()), (BigDecimal)vo.getEquipRentDays()));
                vo.setEquipCostTaxPrice(ComputeUtil.safeMultiply((BigDecimal)vo.getEquipCostPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getEquipCostRate(), (BigDecimal)new BigDecimal("100")))));
                vo.setEquipCostTaxMny(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)vo.getEquipNum(), (BigDecimal)vo.getEquipCostTaxPrice()), (BigDecimal)vo.getEquipRentDays()));
                vo.setEquipProfitAndLossMny(ComputeUtil.safeSub((BigDecimal)vo.getEquipIncomeMny(), (BigDecimal)vo.getEquipCostMny()));
                vo.setEquipCostTax(ComputeUtil.safeSub((BigDecimal)vo.getEquipCostTaxMny(), (BigDecimal)vo.getEquipCostMny()));
                docCodes.add(vo.getEquipDocCode());
                processList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(processList)) {
                CommonResponse codeResp = this.equipmentApi.queryEquipmentListByCodes(new ArrayList(docCodes));
                if (!codeResp.isSuccess()) {
                    this.logger.error("\u673a\u68b0\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u6599\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List itemVOS = (List)codeResp.getData();
                List docCategoryIds = itemVOS.stream().map(EquipmentVO::getCategoryId).collect(Collectors.toList());
                CommonResponse docCategoryResp = this.equipmentApi.queryCategoryListByIds(docCategoryIds);
                if (!docCategoryResp.isSuccess()) {
                    this.logger.error("\u673a\u68b0\u8d39\u5bfc\u5165\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u6599\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)codeResp));
                    return CommonResponse.error((String)"\u83b7\u53d6\u5339\u914d\u6e05\u5355\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                }
                Map<String, String> categoryInnerCode = ((List)docCategoryResp.getData()).stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));
                Map itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getCode(), Function.identity()));
                EquipmentVO tempItem = null;
                String categoryId = null;
                for (BuildDutyEquipDetailVO detail : processList) {
                    categoryId = null;
                    tempItem = (EquipmentVO)itemMap.get(detail.getEquipDocCode());
                    if (null == tempItem) {
                        detail.setErrorMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5339\u914d\u9879\uff01");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setEquipDocName(tempItem.getName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setEquipDocSpec(tempItem.getSpec());
                    detail.setEquipUnitName(tempItem.getUnitName());
                    detail.setEquipDocId(tempItem.getId());
                    for (String docCategoryId : categoyList) {
                        if (!docCategoryId.equals(detail.getDocCategoryId()) && (!categoryInnerCode.containsKey(detail.getDocCategoryId()) || !categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) continue;
                        categoryId = docCategoryId;
                        break;
                    }
                    if (StringUtils.isNotBlank(categoryId)) {
                        if (!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList());
                        }
                        ((List)categoryMap.get(categoryId)).add(detail);
                    } else {
                        docList.add(detail);
                    }
                    successList.add(detail);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success((Object)json);
    }

    private MultipartFile excelImportFileCheck(Map<String, MultipartFile> fileMap) {
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        return mf;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<BuildDutyVO> saveOrUpdate(@RequestBody BuildDutyVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @GetMapping(value={"/countByProjectId"})
    public CommonResponse<Integer> countByProjectId(@RequestParam Long projectId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"latest_flag", (Object)1);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = this.service.list((Wrapper)query);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)dbList.size());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<BuildDutyVO> queryDetail(Long id) {
        BuildDutyVO vo = this.service.queryDetail(id, true);
        if (ChangeStateEnum.\u5df2\u53d8\u66f4.getCode().equals(vo.getChangeState())) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"project_id", (Object)vo.getProjectId());
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            query.ne((Object)"id", (Object)vo.getId());
            query.orderByAsc((Object)"duty_version");
            List hisList = this.service.list((Wrapper)query);
            BuildDutyHisVO hisVO = null;
            if (CollectionUtils.isNotEmpty((Collection)hisList)) {
                for (BuildDutyEntity h : hisList) {
                    hisVO = new BuildDutyHisVO();
                    hisVO.setId(h.getId());
                    hisVO.setHisChangeId(h.getChangeId());
                    hisVO.setHisBillCode(h.getBillCode());
                    hisVO.setHisProjectName(h.getProjectName());
                    hisVO.setHisProjectCode(h.getProjectCode());
                    hisVO.setHisCreateTime(h.getCreateTime());
                    hisVO.setHisLatestFlag(h.getLatestFlag());
                    hisVO.setHisDutyVersion(h.getDutyVersion());
                    hisVO.setHisAdditionalTaxRate(h.getAdditionalTaxRate());
                    hisVO.setHisPlanedTotalCostTaxMny(h.getPlanedTotalCostTaxMny());
                    hisVO.setHisPlanedTotalCostMny(h.getPlanedTotalCostMny());
                    hisVO.setHisPlanProfitRate(h.getPlanProfitRate());
                    hisVO.setHisProfitAndLossTaxMny(h.getProfitAndLossTaxMny());
                    vo.getHisList().add(hisVO);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<BuildDutyVO> vos) {
        this.service.deleteVos(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<BuildDutyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BuildDutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BuildDuty-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBuildDutyData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<BuildDutyVO>> refBuildDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        param.getParams().put("billState", new Parameter("sql", (Object)" bill_state in (1,3) "));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BuildDutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/buildDutyTree"})
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(10);
        param.setPageIndex(-1);
        param.setSearchText(searchText);
        param.getParams().put("tenantId", Parameter.getInInstance((Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        param.getParams().put("billState", new Parameter("sql", (Object)" bill_state in (1,3) "));
        if (StringUtils.isNotEmpty((CharSequence)relyCondition) && null != (_con = JSONObject.parseObject((String)relyCondition)).get((Object)"projectId")) {
            param.getParams().put("projectId", Parameter.getInInstance((Object)_con.get((Object)"projectId")));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId")) {
            param.getParams().put("projectId", Parameter.getInInstance((Object)_con.get((Object)"projectId")));
        }
        List dataList = this.service.queryList(param);
        List map = BeanMapper.mapList((Iterable)dataList, Map.class);
        map.forEach(l -> {
            l.put("name", l.get("projectName"));
            l.put("key", l.get("projectName"));
            l.put("isLeaf", true);
            l.put("children", null);
            l.put("parentId", null);
        });
        return ResultAsTree.createTreeData((List)map);
    }

    @RequestMapping(value={"/queryChangeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryChangeDetail(Long id) {
        BuildDutyVO changeVO = this.service.queryChangeDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    @RequestMapping(value={"/queryDetailByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryDetailByProject(Long id) {
        BuildDutyVO resVo = new BuildDutyVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BuildDutyEntity::getProjectId, (Object)id);
        queryWrapper.eq(BuildDutyEntity::getLatestFlag, (Object)1);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List buildDutyEntities = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)buildDutyEntities)) {
            resVo = (BuildDutyVO)BeanMapper.map(buildDutyEntities.get(0), BuildDutyVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVo);
    }

    @GetMapping(value={"/countBuildDutyInfo"})
    public CommonResponse<JSONObject> countBuildDutyInfo(@RequestParam String year, @RequestParam(required=false) Long orgId) {
        JSONObject result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
            params.put("orgIds", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if ("thisYear".equals(year)) {
            params.put("startDate", DateUtil.getCurrentYear() + "-01-01 00:00:00");
            params.put("endDate", DateUtil.getCurrentYear() + "-12-31 23:59:59");
        }
        if (null == (result = this.service.countBuildDutyInfo(params))) {
            result = new JSONObject();
            result.put("labSubTotalMny", (Object)BigDecimal.ZERO);
            result.put("proSubTotalMny", (Object)BigDecimal.ZERO);
            result.put("materialTotalMny", (Object)BigDecimal.ZERO);
            result.put("equipmentTotalMny", (Object)BigDecimal.ZERO);
            result.put("measureTotalMny", (Object)BigDecimal.ZERO);
            result.put("otherTotalMny", (Object)BigDecimal.ZERO);
            result.put("finicialTotalMny", (Object)BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)result);
    }
}

