package com.ejianc.business.targetcost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 控制规则
 *
 * @author generator
 *
 */
public class RuleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orgId; // 所属组织，不显示默认当前组织
    private Long parentOrgId; // 父级组织
    private String orgName; // 项目组织名称
    private String name; // 名称
    private String type; // 类型
    private String billCode; // 单据编码
    private Integer billState; // 审批状态
    private Date billDate; // 单据日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Long feeId; // 费用模板ID
    private String feeCode; // 费用模板编码
    private String feeName; // 费用模板名称
    private Boolean enabled; // 启用/停用(1:启用，0：停用)
    private Long copyId; // 复制时来源id


    private List<RuleFeeDetailVO> feeDetailList = new ArrayList<>(); // 费用模板明细
    private List<RuleDetailVO> ruleDetailList = new ArrayList<>(); // 控制规则明细
    private List<RuleSubjectDetailVO> subjectDetailList = new ArrayList<>(); // 成本科目明细

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="tc-fee")
    public Long getFeeId() {
        return feeId;
    }

    @ReferDeserialTransfer
    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeCode() {
        return feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<RuleFeeDetailVO> getFeeDetailList() {
        return feeDetailList;
    }

    public void setFeeDetailList(List<RuleFeeDetailVO> feeDetailList) {
        this.feeDetailList = feeDetailList;
    }

    public List<RuleDetailVO> getRuleDetailList() {
        return ruleDetailList;
    }

    public void setRuleDetailList(List<RuleDetailVO> ruleDetailList) {
        this.ruleDetailList = ruleDetailList;
    }

    public List<RuleSubjectDetailVO> getSubjectDetailList() {
        return subjectDetailList;
    }

    public void setSubjectDetailList(List<RuleSubjectDetailVO> subjectDetailList) {
        this.subjectDetailList = subjectDetailList;
    }

    public Long getCopyId() {
        return copyId;
    }

    public void setCopyId(Long copyId) {
        this.copyId = copyId;
    }
}
