/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestContextHolder;

public class ThreadContextDecorator
implements TaskDecorator {
    private Logger logger = LoggerFactory.getLogger(ThreadContextDecorator.class);
    private String baseHost;
    private boolean contextFlag;

    public String getBaseHost() {
        return this.baseHost;
    }

    public void setBaseHost(String baseHost) {
        this.baseHost = baseHost;
    }

    public ThreadContextDecorator() {
    }

    public ThreadContextDecorator(String baseHost) {
        this(baseHost, true);
    }

    public ThreadContextDecorator(String baseHost, boolean contextFlag) {
        this.baseHost = baseHost;
        this.contextFlag = contextFlag;
    }

    public boolean isContextFlag() {
        return this.contextFlag;
    }

    public void setContextFlag(boolean contextFlag) {
        this.contextFlag = contextFlag;
    }

    public Runnable decorate(Runnable runnable) {
        JSONObject userContext = this.getToken();
        StringBuilder authtoken = new StringBuilder();
        if (null == userContext) {
            if (this.contextFlag) {
                throw new BusinessException("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5931\u8d25");
            }
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5931\u8d25");
        } else {
            authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
        }
        return () -> {
            try {
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
                runnable.run();
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
            }
        };
    }

    public JSONObject getToken() {
        if (null != this.baseHost) {
            String initContextUrl = this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
            if (null != InvocationInfoProxy.getUserid()) {
                initContextUrl = initContextUrl + "&userId=" + InvocationInfoProxy.getUserid().toString();
            }
            String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
            CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            try {
                if (userContextResponse.isSuccess()) {
                    return ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                }
            }
            catch (Exception e) {
                this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

