package com.ejianc.business.zhht.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zhht.bean.BuildDutyProSubDetailEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zhht.mapper.BuildDutyLaborCostDetailMapper;
import com.ejianc.business.zhht.bean.BuildDutyLaborCostDetailEntity;
import com.ejianc.business.zhht.service.IBuildDutyLaborCostDetailService;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目测试-人工费
 * 
 * @author generator
 * 
 */
@Service("buildDutyLaborCostDetailService")
public class BuildDutyLaborCostDetailServiceImpl extends BaseServiceImpl<BuildDutyLaborCostDetailMapper, BuildDutyLaborCostDetailEntity> implements IBuildDutyLaborCostDetailService{

    @Override
    public List<JSONObject> getAllByPidAndDocIds(Long pid, List<Long> docIds) {
        List<JSONObject> resp = new ArrayList<>();
        QueryWrapper<BuildDutyLaborCostDetailEntity> query = new QueryWrapper<>();

        query.eq("labor_duty_id", pid);
        query.in("labor_doc_id", docIds);
        query.eq("leaf_flag", 1);
        query.isNull("labor_source_detail_id");
        List<BuildDutyLaborCostDetailEntity> dbEntity = super.list(query);
        if(CollectionUtils.isNotEmpty(dbEntity)) {
            resp = BeanMapper.mapList(dbEntity, JSONObject.class);
        }

        return resp;
    }
}
