package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.mapper.DetailCacheMapper;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 目标成本明细汇总缓存
 *
 * @author generator
 *
 */
@Service("detailCacheService")
public class DetailCacheServiceImpl extends BaseServiceImpl<DetailCacheMapper, DetailCacheEntity> implements IDetailCacheService{

    @Override
    public List<DetailCacheEntity> queryReportDetail(Long dutyDetailId, Boolean isAll) {
        LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailCacheEntity::getDutyDetailId, dutyDetailId);
        queryWrapper.isNull(!isAll, DetailCacheEntity::getDutyItemId);
        return list(queryWrapper);
    }

    @Override
    public List<DetailCacheEntity> queryByProjAndFeeDetail(Long projectId, Long feeDetailId, Boolean isAll) {
        LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailCacheEntity::getProjectId, projectId);
        queryWrapper.eq(DetailCacheEntity::getFeeDetailId, feeDetailId);
        queryWrapper.isNull(!isAll, DetailCacheEntity::getDutyItemId);
        List<DetailCacheEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            for(DetailCacheEntity detailCacheEntity : list){
                detailCacheEntity.setAmount(detailCacheEntity.getContNum());
            }
        }
        return list;
    }

    @Override
    public void deleteByProjectIdPhy(Long projectId) {
        baseMapper.deleteByProjectIdPhy(projectId);
    }

    @Override
    public void deleteByIdsPhy(List<Long> idList) {
        baseMapper.deleteByIdsPhy(idList);
    }
}
