package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.mapper.DutyDetailItemMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 目标责任成本明细项
 *
 * @author generator
 *
 */
@Service("dutyDetailItemService")
public class DutyDetailItemServiceImpl extends BaseServiceImpl<DutyDetailItemMapper, DutyDetailItemEntity> implements IDutyDetailItemService{

    @Override
    public List<DutyDetailItemEntity> findByDutyDetailId(Long dutyDetailId) {
        LambdaQueryWrapper<DutyDetailItemEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyDetailItemEntity::getDutyDetailId, dutyDetailId);
        return list(queryWrapper);
    }

    @Override
    public void deleteByDutyDetailId(Long dutyDetailId) {
        if (null == dutyDetailId) {
            return;
        }
        LambdaUpdateWrapper<DutyDetailItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(DutyDetailItemEntity::getDutyDetailId, dutyDetailId);
        remove(updateWrapper);
    }

    @Override
    public int deleteByDutyIdPhy(Long dutyId) {
        return baseMapper.deleteByDutyIdPhy(dutyId);
    }

    @Override
    public List<DutyDetailItemVO> queryCostMny(Long projectId, List<Long> longList) {
        return baseMapper.queryCostMny(projectId, longList);
    }

    @Override
    public DutyDetailItemVO queryCostMnyBySubjectId(Long projectId, Long subjectId) {
        DutyDetailItemVO itemVO = baseMapper.queryCostMnyBySubjectId(projectId, subjectId);
        if (null != itemVO) {
            itemVO.setSubjectId(subjectId);
        }
        return itemVO;
    }

}
