package com.ejianc.business.zhht.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 季度成本分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_targetcost_season_analyse")
public class SeasonAnalyseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="memo")
    private String memo; // 成本分析主要结论
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="project_names")
    private String projectNames; // 项目名称集合
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 成本分析专题会日期

    @TableField(exist=false)
    @SubEntity(serviceName="seasonAnalyseDetailService")
    private List<SeasonAnalyseDetailEntity> seasonAnalyseDetailList  = new ArrayList<>(); // 明细

    public List<SeasonAnalyseDetailEntity> getSeasonAnalyseDetailList() {
        return seasonAnalyseDetailList;
    }

    public void setSeasonAnalyseDetailList(List<SeasonAnalyseDetailEntity> seasonAnalyseDetailList) {
        this.seasonAnalyseDetailList = seasonAnalyseDetailList;
    }

    public String getProjectNames() {
        return projectNames;
    }

    public void setProjectNames(String projectNames) {
        this.projectNames = projectNames;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    
}
