package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目策划
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("buildDuty")
public class BuildDutyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBuildDutyService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareLabsubApi labsubApi;

    @Autowired
    private IShareProsubApi prosubApi;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IShareEquipmentApi equipmentApi;

    /**
     * @Description ConvertFlag 转换
     * @param id
     */
    @RequestMapping(value = "/ConvertFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BuildDutyVO> ConvertFlag(Long id) {
        return CommonResponse.success("转换成功！",service.ConvertFlag(id));
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadTemplate")
    @ResponseBody
    public void downloadInfo(@RequestParam String type, HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        String fileName = null;
        switch (type) {
            case "laborFee":
                fileName = "人工费导入模版";
                break;
            case "materialFee":
                fileName = "材料费导入模版";
                break;
            case "prosubFee":
                fileName = "专业分包费导入模版";
                break;
            case "equipFee":
                fileName = "机械费导入模版";
                break;
            default:;
        }
        if(StringUtils.isBlank(fileName)) {
            throw new BusinessException("错误的模板类型:"+type);
        }
        ImportTemplate.templetdownload(request, type+"ImportTemplate.xlsx", fileName);
    }

    /**
     * 人工费导入上传文件校验
     * @param request
     * @return
     */
    @PostMapping(value = "/laborFeeExcelImport")
    public CommonResponse<JSONObject> laborFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");

        if(StringUtils.isBlank(categoryIds)) {
            throw new BusinessException("缺少参数：物料分类主键列表[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));

        mf = excelImportFileCheck(fileMap);

        List<BuildDutyLaborCostDetailVO> successList = new ArrayList<>();
        List<BuildDutyLaborCostDetailVO> processList = new ArrayList<>();
        List<BuildDutyLaborCostDetailVO> errorList = new ArrayList<>();
        Map<String, List<BuildDutyLaborCostDetailVO>> categoryMap = new HashMap<>();
        List<BuildDutyLaborCostDetailVO> docList = new ArrayList<>();

        Set<String> docCodes = new HashSet<>();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            BuildDutyLaborCostDetailVO vo = null;

            //从第四行开始读取数据
            for(int i = 2;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new BuildDutyLaborCostDetailVO();
                vo.setLaborDocCode(datas.get(0)); //清单编码
                vo.setLaborDocName(datas.get(1)); //清单名称
                vo.setLaborDocSpec(datas.get(2)); //特征描述
                vo.setLaborUnitName(datas.get(3)); //单位


                if(StringUtils.isBlank(vo.getLaborDocCode())){
                    vo.setErrorMsg("【清单编码】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(vo.getLaborDocName())){
                    vo.setErrorMsg("【清单名称】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("【工程量】不能为空！");
                    errorList.add(vo);
                    continue;
                }

                try {
                    vo.setLaborNum(ComputeUtil.toBigDecimal(datas.get(4))); //工程量
                } catch (Exception e) {
                    vo.setErrorMsg("【工程量】只能填写数值类型的值！");
                    errorList.add(vo);
                    continue;
                }

                if(StringUtils.isNotBlank(datas.get(5))) {
                    try {
                        vo.setLaborIncomePrice(ComputeUtil.toBigDecimal(datas.get(5))); //收入-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【收入-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(7))) {
                    try {
                        vo.setLaborCostRate(ComputeUtil.toBigDecimal(datas.get(7))); //成本-税率
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-税率】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(8))) {
                    try {
                        vo.setLaborCostPrice(ComputeUtil.toBigDecimal(datas.get(8))); //成本-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                } else {
                    vo.setErrorMsg("【成本-单价】不能为空！");
                    errorList.add(vo);
                    continue;
                }

                vo.setRowState("add");
                //计算收入-金额（无税）
                vo.setLaborIncomeMny(ComputeUtil.safeMultiply(vo.getLaborNum(), vo.getLaborIncomePrice()));
                vo.setLaborCostMny(ComputeUtil.safeMultiply(vo.getLaborNum(), vo.getLaborCostPrice()));
                vo.setLaborCostTaxPrice(ComputeUtil.safeMultiply(vo.getLaborCostPrice(), ComputeUtil.safeAdd(BigDecimal.ONE,
                        ComputeUtil.safeDiv(vo.getLaborCostRate(), new BigDecimal("100")))));
                vo.setLaborCostTaxMny(ComputeUtil.safeMultiply(vo.getLaborNum(), vo.getLaborCostTaxPrice()));
                vo.setLaborProfitAndLossMny(ComputeUtil.safeSub(vo.getLaborIncomeMny(),vo.getLaborCostMny()));
                vo.setLaborCostTax(ComputeUtil.safeSub(vo.getLaborCostTaxMny(), vo.getLaborCostMny()));
                docCodes.add(vo.getLaborDocCode());
                processList.add(vo);
            }

            if(CollectionUtils.isNotEmpty(processList)) {
                //根据编码查询对应物料清单
                CommonResponse<List<LabsubItemVO>> codeResp= labsubApi.queryItemListByCodes(new ArrayList<>(docCodes));
                if(!codeResp.isSuccess()) {
                    logger.error("人工费导入数据处理失败，获取劳务分包清单信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单信息失败！");
                }

                List<LabsubItemVO> itemVOS = codeResp.getData();

                List<Long> docCategoryIds = itemVOS.stream().map(LabsubItemVO::getCategoryId).collect(Collectors.toList());
                CommonResponse<List<LabsubCategoryVO>> docCategoryResp = labsubApi.queryCategoryListByIds(docCategoryIds);
                if(!docCategoryResp.isSuccess()) {
                    logger.error("人工费导入数据处理失败，获取物料清单分类信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单分类信息失败！");
                }
                Map<String, String> categoryInnerCode = docCategoryResp.getData().stream()
                        .collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));


                Map<String, LabsubItemVO> itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getTrawlingCode(), Function.identity()));
                LabsubItemVO tempItem = null;
                String categoryId = null;
                for(BuildDutyLaborCostDetailVO detail : processList) {
                    tempItem = itemMap.get(detail.getLaborDocCode());
                    categoryId = null;
                    if(null == tempItem) {
                        detail.setErrorMsg("【清单编码】在系统中无匹配项！");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setLaborDocName(tempItem.getTrawlingName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setLaborDocSpec(tempItem.getDetailMeasurementRules());
                    detail.setLaborUnitName(tempItem.getUnitName());
                    detail.setLaborDocId(tempItem.getId());

                    //获取当前物料对应策划中分类
                    for(String docCategoryId : categoyList) {
                        if(docCategoryId.equals(detail.getDocCategoryId()) ||
                                (categoryInnerCode.containsKey(detail.getDocCategoryId()) &&
                                        categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) {
                            categoryId = docCategoryId;
                            break;
                        }
                    }

                    if(StringUtils.isNotBlank(categoryId)) {
                        if(!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList<>());
                        }
                        categoryMap.get(categoryId).add(detail);
                    } else {
                        docList.add(detail);
                    }

                    successList.add(detail);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success(json);
    }

    /**
     * 专业分包费导入上传文件校验
     * @param request
     * @return
     */
    @PostMapping(value = "/prosubFeeExcelImport")
    public CommonResponse<JSONObject> prosubFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");

        if(StringUtils.isBlank(categoryIds)) {
            throw new BusinessException("缺少参数：物料分类主键列表[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));

        mf = excelImportFileCheck(fileMap);

        List<BuildDutyProSubDetailVO> successList = new ArrayList<>();
        List<BuildDutyProSubDetailVO> processList = new ArrayList<>();
        List<BuildDutyProSubDetailVO> errorList = new ArrayList<>();
        Map<String, List<BuildDutyProSubDetailVO>> categoryMap = new HashMap<>();
        List<BuildDutyProSubDetailVO> docList = new ArrayList<>();

        Set<String> docCodes = new HashSet<>();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            BuildDutyProSubDetailVO vo = null;

            //从第四行开始读取数据
            for(int i = 2;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new BuildDutyProSubDetailVO();
                vo.setProSubDocCode(datas.get(0)); //清单编码
                vo.setProSubDocName(datas.get(1)); //清单名称
                vo.setProSubDocSpec(datas.get(2)); //特征描述
                vo.setProSubUnitName(datas.get(3)); //单位

                if(StringUtils.isBlank(datas.get(0))){
                    vo.setErrorMsg("【清单编码】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("【清单名称】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("【工程量】不能为空！");
                    errorList.add(vo);
                    continue;
                }

                try {
                    vo.setProSubNum(ComputeUtil.toBigDecimal(datas.get(4))); //工程量
                } catch (Exception e) {
                    vo.setErrorMsg("【工程量】只能填写数值类型的值！");
                    errorList.add(vo);
                    continue;
                }

                if(StringUtils.isNotBlank(datas.get(5))) {
                    try {
                        vo.setProSubIncomePrice(ComputeUtil.toBigDecimal(datas.get(5))); //收入-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【收入-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(7))) {
                    try {
                        vo.setProSubCostRate(ComputeUtil.toBigDecimal(datas.get(7))); //成本-税率
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-税率】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(8))) {
                    try {
                        vo.setProSubCostPrice(ComputeUtil.toBigDecimal(datas.get(8))); //成本-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                } else {
                    vo.setErrorMsg("【成本-单价】不能为空！");
                    errorList.add(vo);
                    continue;
                }

                vo.setRowState("add");
                //计算收入-金额（无税）
                vo.setProSubIncomeMny(ComputeUtil.safeMultiply(vo.getProSubNum(), vo.getProSubIncomePrice()));
                vo.setProSubCostMny(ComputeUtil.safeMultiply(vo.getProSubNum(), vo.getProSubCostPrice()));
                vo.setProSubCostTaxPrice(ComputeUtil.safeMultiply(vo.getProSubCostPrice(), ComputeUtil.safeAdd(BigDecimal.ONE,
                        ComputeUtil.safeDiv(vo.getProSubCostRate(), new BigDecimal("100")))));
                vo.setProSubCostTaxMny(ComputeUtil.safeMultiply(vo.getProSubNum(), vo.getProSubCostTaxPrice()));
                vo.setProSubProfitAndLossMny(ComputeUtil.safeSub(vo.getProSubIncomeMny(),vo.getProSubCostMny()));
                vo.setProSubTax(ComputeUtil.safeSub(vo.getProSubCostTaxMny(), vo.getProSubCostMny()));

                docCodes.add(vo.getProSubDocCode());
                processList.add(vo);
            }

            if(CollectionUtils.isNotEmpty(processList)) {
                //根据编码查询对应物料清单
                CommonResponse<List<ProsubItemVO>> codeResp= prosubApi.queryItemListByCodes(new ArrayList<>(docCodes));
                if(!codeResp.isSuccess()) {
                    logger.error("专业分包费导入数据处理失败，获取专业分包清单信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单信息失败！");
                }

                List<ProsubItemVO> itemVOS = codeResp.getData();

                List<Long> docCategoryIds = itemVOS.stream().map(ProsubItemVO::getCategoryId).collect(Collectors.toList());
                CommonResponse<List<ProsubCategoryVO>> docCategoryResp = prosubApi.queryCategoryListByIds(docCategoryIds);
                if(!docCategoryResp.isSuccess()) {
                    logger.error("专业分包费导入数据处理失败，获取物料清单分类信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单分类信息失败！");
                }
                Map<String, String> categoryInnerCode = docCategoryResp.getData().stream()
                        .collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));

                Map<String, ProsubItemVO> itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getTrawlingCode(), Function.identity()));
                ProsubItemVO tempItem = null;
                String categoryId = null;
                for(BuildDutyProSubDetailVO detail : processList) {
                    tempItem = itemMap.get(detail.getProSubDocCode());
                    categoryId = null;
                    if(null == tempItem) {
                        detail.setErrorMsg("【清单编码】在系统中无匹配项！");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setProSubDocName(tempItem.getTrawlingName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setProSubDocSpec(tempItem.getDetailMeasurementRules());
                    detail.setProSubUnitName(tempItem.getUnitName());
                    detail.setProSubDocId(tempItem.getId());

                    //获取当前物料对应策划中分类
                    for(String docCategoryId : categoyList) {
                        if(docCategoryId.equals(detail.getDocCategoryId()) ||
                                (categoryInnerCode.containsKey(detail.getDocCategoryId()) &&
                                        categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) {
                            categoryId = docCategoryId;
                            break;
                        }
                    }

                    if(StringUtils.isNotBlank(categoryId)) {
                        if(!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList<>());
                        }
                        categoryMap.get(categoryId).add(detail);
                    } else {
                        docList.add(detail);
                    }

                    successList.add(detail);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success(json);
    }

    /**
     * 材料费导入上传文件校验
     * @param request
     * @return
     */
    @PostMapping(value = "/materialFeeExcelImport")
    public CommonResponse<JSONObject> materialFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");

        if(StringUtils.isBlank(categoryIds)) {
            throw new BusinessException("缺少参数：物料分类主键列表[categoryIds]");
        }
        List<String> categoyList = Arrays.asList(categoryIds.split(","));

        mf = excelImportFileCheck(fileMap);

        List<BuildDutyMaterialDetailVO> successList = new ArrayList<>();
        List<BuildDutyMaterialDetailVO> processList = new ArrayList<>();
        List<BuildDutyMaterialDetailVO> errorList = new ArrayList<>();
        Map<String, List<BuildDutyMaterialDetailVO>> categoryMap = new HashMap<>();
        List<BuildDutyMaterialDetailVO> docList = new ArrayList<>();

        Set<String> docCodes = new HashSet<>();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            BuildDutyMaterialDetailVO vo = null;

            //从第四行开始读取数据
            for(int i = 2;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new BuildDutyMaterialDetailVO();
                vo.setMaterialDocCode(datas.get(0)); //清单编码
                vo.setMaterialDocName(datas.get(1)); //清单名称
                vo.setMaterialDocSpec(datas.get(2)); //特征描述
                vo.setMaterialUnitName(datas.get(3)); //单位

                if(StringUtils.isBlank(datas.get(0))){
                    vo.setErrorMsg("清单编码不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("清单名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("工程量不能为空！");
                    errorList.add(vo);
                    continue;
                }

                try {
                    vo.setMaterialNum(ComputeUtil.toBigDecimal(datas.get(4))); //工程量
                } catch (Exception e) {
                    vo.setErrorMsg("【工程量】只能填写数值类型的值！");
                    errorList.add(vo);
                    continue;
                }

                if(StringUtils.isNotBlank(datas.get(5))) {
                    try {
                        vo.setMaterialIncomePrice(ComputeUtil.toBigDecimal(datas.get(5))); //收入-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【收入-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(8))) {
                    try {
                        vo.setMaterialCostPrice(ComputeUtil.toBigDecimal(datas.get(8))); //成本-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                } else {
                    vo.setErrorMsg("【成本-单价】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isNotBlank(datas.get(7))) {
                    try {
                        vo.setMaterialCostRate(ComputeUtil.toBigDecimal(datas.get(7))); //成本-税率
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-税率】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }

                vo.setRowState("add");
                //计算收入-金额（无税）
                vo.setMaterialIncomeMny(ComputeUtil.safeMultiply(vo.getMaterialNum(), vo.getMaterialIncomePrice()));
                vo.setMaterialCostMny(ComputeUtil.safeMultiply(vo.getMaterialNum(), vo.getMaterialCostPrice()));
                vo.setMaterialCostTaxPrice(ComputeUtil.safeMultiply(vo.getMaterialCostPrice(), ComputeUtil.safeAdd(BigDecimal.ONE,
                        ComputeUtil.safeDiv(vo.getMaterialCostRate(), new BigDecimal("100")))));
                vo.setMaterialCostTaxMny(ComputeUtil.safeMultiply(vo.getMaterialNum(), vo.getMaterialCostTaxPrice()));
                vo.setMaterialProfitAndLossMny(ComputeUtil.safeSub(vo.getMaterialIncomeMny(),vo.getMaterialCostMny()));
                vo.setMaterialCostTax(ComputeUtil.safeSub(vo.getMaterialCostTaxMny(), vo.getMaterialCostMny()));

                docCodes.add(vo.getMaterialDocCode());
                processList.add(vo);
            }

            if(CollectionUtils.isNotEmpty(processList)) {
                //根据编码查询对应物料清单
                CommonResponse<List<MaterialVO>> codeResp= materialApi.queryMaterialListByCodes(new ArrayList<>(docCodes));
                if(!codeResp.isSuccess()) {
                    logger.error("材料费导入数据处理失败，获取物料清单信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取物料清单信息失败！");
                }

                List<MaterialVO> itemVOS = codeResp.getData();

                List<Long> docCategoryIds = itemVOS.stream().map(MaterialVO::getCategoryId).collect(Collectors.toList());
                CommonResponse<List<MaterialCategoryVO>> docCategoryResp = materialApi.queryCategoryListByIds(docCategoryIds);
                if(!docCategoryResp.isSuccess()) {
                    logger.error("材料费导入数据处理失败，获取物料清单分类信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单分类信息失败！");
                }
                Map<String, String> categoryInnerCode = docCategoryResp.getData().stream()
                        .collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));

                Map<String, MaterialVO> itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getCode(), Function.identity()));
                MaterialVO tempItem = null;
                String categoryId = null;
                for(BuildDutyMaterialDetailVO detail : processList) {
                    tempItem = itemMap.get(detail.getMaterialDocCode());
                    categoryId = null;
                    if(null == tempItem) {
                        detail.setErrorMsg("【清单编码】在系统中无匹配项！");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setMaterialDocName(tempItem.getName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setMaterialDocSpec(tempItem.getSpec());
                    detail.setMaterialUnitName(tempItem.getUnitName());
                    detail.setMaterialDocId(tempItem.getId());

                    //获取当前物料对应策划中分类
                    for(String docCategoryId : categoyList) {
                        if(docCategoryId.equals(detail.getDocCategoryId()) ||
                                (categoryInnerCode.containsKey(detail.getDocCategoryId()) &&
                                        categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) {
                            categoryId = docCategoryId;
                            break;
                        }
                    }

                    if(StringUtils.isNotBlank(categoryId)) {
                        if(!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList<>());
                        }
                        logger.info("categoryDetail:{}，actCatetgoryId:{}",JSONObject.toJSONString(detail), categoryId);
                        categoryMap.get(categoryId).add(detail);
                    } else {
                        docList.add(detail);
                        logger.info("doc:{}",JSONObject.toJSONString(detail), categoryId);
                    }

                    successList.add(detail);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success(json);
    }


    /**
     * 机械费导入上传文件校验
     * @param request
     * @return
     */
    @PostMapping(value = "/equipFeeExcelImport")
    public CommonResponse<JSONObject> equipFeeExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        String categoryIds = request.getParameter("categoryIds");

        if(StringUtils.isBlank(categoryIds)) {
            throw new BusinessException("缺少参数：物料分类主键列表[categoryIds]");
        }

        List<String> categoyList = Arrays.asList(categoryIds.split(","));

        mf = excelImportFileCheck(fileMap);

        List<BuildDutyEquipDetailVO> successList = new ArrayList<>();
        List<BuildDutyEquipDetailVO> processList = new ArrayList<>();
        List<BuildDutyEquipDetailVO> errorList = new ArrayList<>();
        Map<String, List<BuildDutyEquipDetailVO>> categoryMap = new HashMap<>();
        List<BuildDutyEquipDetailVO> docList = new ArrayList<>();

        Set<String> docCodes = new HashSet<>();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            BuildDutyEquipDetailVO vo = null;

            //从第四行开始读取数据
            for(int i = 2;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new BuildDutyEquipDetailVO();
                vo.setEquipDocCode(datas.get(0)); //清单编码
                vo.setEquipDocName(datas.get(1)); //清单名称
                vo.setEquipDocSpec(datas.get(2)); //特征描述
                vo.setEquipUnitName(datas.get(3)); //单位

                if(StringUtils.isBlank(datas.get(0))){
                    vo.setErrorMsg("【清单编码】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("【清单名称】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(6))){
                    vo.setErrorMsg("【数量】不能为空！");
                    errorList.add(vo);
                    continue;
                }

                try {
                    vo.setEquipNum(ComputeUtil.toBigDecimal(datas.get(6))); //工程量
                } catch (Exception e) {
                    vo.setErrorMsg("【数量】只能填写数值类型的值！");
                    errorList.add(vo);
                    continue;
                }
                try {
                    vo.setEquipIncomeMny(ComputeUtil.toBigDecimal(datas.get(4))); //收入-金额(无税)
                } catch (Exception e) {
                    vo.setErrorMsg("【收入-金额(无税)】只能填写数值类型的值！");
                    errorList.add(vo);
                    continue;
                }


                if(StringUtils.isNotBlank(datas.get(5))) {
                    try {
                        vo.setEquipCostRate(ComputeUtil.toBigDecimal(datas.get(5))); //成本-税率
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-税率】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(8))) {
                    try {
                        vo.setEquipCostPrice(ComputeUtil.toBigDecimal(datas.get(8))); //成本-单价
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-单价】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                } else {
                    vo.setErrorMsg("【成本-单价】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isNotBlank(datas.get(7))) {
                    try {
                        vo.setEquipRentDays(ComputeUtil.toBigDecimal(datas.get(7))); //成本-租期
                    } catch (Exception e) {
                        vo.setErrorMsg("【成本-租期】只能填写数值类型的值！");
                        errorList.add(vo);
                        continue;
                    }
                }

                vo.setRowState("add");
                //计算收入-金额（无税）
                vo.setEquipCostMny(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(vo.getEquipNum(), vo.getEquipCostPrice()), vo.getEquipRentDays()));
                vo.setEquipCostTaxPrice(ComputeUtil.safeMultiply(vo.getEquipCostPrice(), ComputeUtil.safeAdd(BigDecimal.ONE,
                        ComputeUtil.safeDiv(vo.getEquipCostRate(), new BigDecimal("100")))));
                vo.setEquipCostTaxMny(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(vo.getEquipNum(), vo.getEquipCostTaxPrice()), vo.getEquipRentDays()));
                vo.setEquipProfitAndLossMny(ComputeUtil.safeSub(vo.getEquipIncomeMny(),vo.getEquipCostMny()));
                vo.setEquipCostTax(ComputeUtil.safeSub(vo.getEquipCostTaxMny(), vo.getEquipCostMny()));

                docCodes.add(vo.getEquipDocCode());
                processList.add(vo);
            }

            if(CollectionUtils.isNotEmpty(processList)) {
                //根据编码查询对应物料清单
                CommonResponse<List<EquipmentVO>> codeResp= equipmentApi.queryEquipmentListByCodes(new ArrayList<>(docCodes));
                if(!codeResp.isSuccess()) {
                    logger.error("机械费导入数据处理失败，获取物料清单信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单信息失败！");
                }
                List<EquipmentVO> itemVOS = codeResp.getData();

                List<Long> docCategoryIds = itemVOS.stream().map(EquipmentVO::getCategoryId).collect(Collectors.toList());
                CommonResponse<List<EquipmentCategoryVO>> docCategoryResp = equipmentApi.queryCategoryListByIds(docCategoryIds);
                if(!docCategoryResp.isSuccess()) {
                    logger.error("机械费导入数据处理失败，获取物料清单分类信息失败：{}", JSONObject.toJSONString(codeResp));
                    return CommonResponse.error("获取匹配清单分类信息失败！");
                }

                Map<String, String> categoryInnerCode = docCategoryResp.getData().stream()
                        .collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getInnerCode()));


                Map<String, EquipmentVO> itemMap = itemVOS.stream().collect(Collectors.toMap(item -> item.getCode(), Function.identity()));
                EquipmentVO tempItem = null;
                String categoryId = null;
                for(BuildDutyEquipDetailVO detail : processList) {
                    categoryId = null;
                    tempItem = itemMap.get(detail.getEquipDocCode());
                    if(null == tempItem) {
                        detail.setErrorMsg("【清单编码】在系统中无匹配项！");
                        errorList.add(detail);
                        continue;
                    }
                    detail.setEquipDocName(tempItem.getName());
                    detail.setDocCategoryId(tempItem.getCategoryId().toString());
                    detail.setEquipDocSpec(tempItem.getSpec());
                    detail.setEquipUnitName(tempItem.getUnitName());
                    detail.setEquipDocId(tempItem.getId());

                    //获取当前物料对应策划中分类
                    for(String docCategoryId : categoyList) {
                        if(docCategoryId.equals(detail.getDocCategoryId()) ||
                                (categoryInnerCode.containsKey(detail.getDocCategoryId()) &&
                                        categoryInnerCode.get(detail.getDocCategoryId()).contains(docCategoryId))) {
                            categoryId = docCategoryId;
                            break;
                        }
                    }

                    if(StringUtils.isNotBlank(categoryId)) {
                        if(!categoryMap.containsKey(categoryId)) {
                            categoryMap.put(categoryId, new ArrayList<>());
                        }
                        categoryMap.get(categoryId).add(detail);
                    } else {
                        docList.add(detail);
                    }

                    successList.add(detail);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("category", categoryMap);
        json.put("docList", docList);
        return CommonResponse.success(json);
    }

    private MultipartFile excelImportFileCheck(Map<String, MultipartFile> fileMap) {
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            throw new BusinessException("文件格式不合法");
        }
        return mf;
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<BuildDutyVO> saveOrUpdate(@RequestBody BuildDutyVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    @GetMapping(value = "/countByProjectId")
    public CommonResponse<Integer> countByProjectId(@RequestParam Long projectId) {
        QueryWrapper<BuildDutyEntity> query= new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("latest_flag", 1); //最新
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<BuildDutyEntity> dbList = service.list(query);

        return CommonResponse.success("查询成功！", dbList.size());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<BuildDutyVO> queryDetail(Long id) {
        BuildDutyVO vo = service.queryDetail(id, true);
        //查询历史版本

        if(ChangeStateEnum.已变更.getCode().equals(vo.getChangeState())) {
            QueryWrapper<BuildDutyEntity> query = new QueryWrapper<>();
            query.eq("project_id", vo.getProjectId());
            query.eq("dr", BaseVO.DR_UNDELETE);
            query.ne("id", vo.getId());
            query.orderByAsc("duty_version");

            List<BuildDutyEntity> hisList = service.list(query);
            BuildDutyHisVO hisVO = null;
            if(CollectionUtils.isNotEmpty(hisList)) {
                for(BuildDutyEntity h : hisList) {
                    hisVO = new BuildDutyHisVO();
                    hisVO.setId(h.getId());
                    hisVO.setHisChangeId(h.getChangeId());
                    hisVO.setHisBillCode(h.getBillCode());
                    hisVO.setHisProjectName(h.getProjectName());
                    hisVO.setHisProjectCode(h.getProjectCode());
                    hisVO.setHisCreateTime(h.getCreateTime());
                    hisVO.setHisLatestFlag(h.getLatestFlag());
                    hisVO.setHisDutyVersion(h.getDutyVersion());
                    hisVO.setHisAdditionalTaxRate(h.getAdditionalTaxRate());
                    hisVO.setHisPlanedTotalCostTaxMny(h.getPlanedTotalCostTaxMny());
                    hisVO.setHisPlanedTotalCostMny(h.getPlanedTotalCostMny());
                    hisVO.setHisPlanProfitRate(h.getPlanProfitRate());
                    hisVO.setHisProfitAndLossTaxMny(h.getProfitAndLossTaxMny());
                    vo.getHisList().add(hisVO);
                }
            }
        }



        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<BuildDutyVO> vos) {
        service.deleteVos(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<BuildDutyVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<BuildDutyEntity> page = service.queryPage(param,false);
        IPage<BuildDutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BuildDutyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BuildDutyEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BuildDuty-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBuildDutyData", method = RequestMethod.GET)
    public CommonResponse<IPage<BuildDutyVO>> refBuildDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));
        param.getParams().put("billState", new Parameter(QueryParam.SQL, " bill_state in (1,3) "));

        IPage<BuildDutyEntity> page = service.queryPage(param,false);
        IPage<BuildDutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BuildDutyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @GetMapping(value = "/buildDutyTree")
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required = false) String relyCondition,
                                                      @RequestParam(required = false) String condition,
                                                      @RequestParam(required = false) String searchText) {


        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(10);
        param.setPageIndex(-1);
        param.setSearchText(searchText);
        param.getParams().put("tenantId", Parameter.getInInstance(InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));
        param.getParams().put("billState", new Parameter(QueryParam.SQL, " bill_state in (1,3) "));

        if(StringUtils.isNotEmpty(relyCondition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(relyCondition);
            if(null != _con.get("projectId")) {
                param.getParams().put("projectId", Parameter.getInInstance(_con.get("projectId")));
            }
        }
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("projectId")) {
                param.getParams().put("projectId", Parameter.getInInstance(_con.get("projectId")));
            }
        }

        List<BuildDutyEntity> dataList = service.queryList(param);
        List<Map> map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l-> {
            l.put("name", l.get("projectName"));
            l.put("key", l.get("projectName"));
            l.put("isLeaf", true);
            l.put("children", null);
            l.put("parentId", null);
        });

        return ResultAsTree.createTreeData(map);
    }

    /**
     * @Description queryChangeDetail 复制为变更单 取详情
     * @param id
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryChangeDetail(Long id) {
        BuildDutyVO changeVO = service.queryChangeDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description queryDetailByProject
     * @param id
     */
    @RequestMapping(value = "/queryDetailByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryDetailByProject(Long id) {
        BuildDutyVO resVo = new BuildDutyVO();
        LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BuildDutyEntity::getProjectId, id);
        queryWrapper.eq(BuildDutyEntity::getLatestFlag, 1);
        queryWrapper.orderByDesc(BuildDutyEntity::getCreateTime);
        List<BuildDutyEntity> buildDutyEntities = service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(buildDutyEntities)){
            resVo = BeanMapper.map(buildDutyEntities.get(0),BuildDutyVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",resVo);
    }

    @GetMapping(value = "/countBuildDutyInfo")
    public CommonResponse<JSONObject> countBuildDutyInfo(@RequestParam String year, @RequestParam(required = false) Long orgId) {
        Map<String, Object> params = new HashMap<>();
        if(null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
            params.put("orgIds", iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        if("thisYear".equals(year)) {
            params.put("startDate", DateUtil.getCurrentYear() + "-01-01 00:00:00");
            params.put("endDate", DateUtil.getCurrentYear() + "-12-31 23:59:59");
        }

        JSONObject result = service.countBuildDutyInfo(params);
        if(null == result) {
            result = new JSONObject();
            result.put("labSubTotalMny", BigDecimal.ZERO);
            result.put("proSubTotalMny", BigDecimal.ZERO);
            result.put("materialTotalMny", BigDecimal.ZERO);
            result.put("equipmentTotalMny", BigDecimal.ZERO);
            result.put("measureTotalMny", BigDecimal.ZERO);
            result.put("otherTotalMny", BigDecimal.ZERO);
            result.put("finicialTotalMny", BigDecimal.ZERO);
        }

        return CommonResponse.success("查询成功", result);
    }
}
