/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.controller.api;

import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/duty/"})
public class DutyApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyService dutyService;

    @PostMapping(value={"queryDuty"})
    public CommonResponse<List<Map<String, Object>>> queryDuty() {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.dutyService.queryDuty());
    }

    @PostMapping(value={"queryDoc"})
    public CommonResponse<Map<Long, BigDecimal>> queryDoc(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.dutyService.queryDoc(projectId));
    }

    @PostMapping(value={"querySumPreTypeAmount"})
    public CommonResponse<Map<Long, BigDecimal>> querySumPreTypeAmount(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.dutyService.querySumPreTypeAmount(projectId));
    }

    @PostMapping(value={"/queryDocDutyDetailItem"})
    public CommonResponse<Map<Long, DutyDetailItemVO>> queryDocDutyDetailItem(@RequestParam(value="projectId") Long projectId, @RequestParam(value="docType") Integer docType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.dutyService.queryDocDutyDetailItem(projectId, docType));
    }

    @GetMapping(value={"queryPriceByDocIds"})
    public CommonResponse<Map<Long, BigDecimal>> queryPriceByDocIds(@RequestParam(value="projectId") Long projectId, @RequestParam(value="docType") Integer docType, @RequestParam(value="docIds") List<Long> docIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.dutyService.queryPriceByDocIds(projectId, docType, false, docIds));
    }

    @GetMapping(value={"queryPriceByRentDocIds"})
    public CommonResponse<Map<Long, BigDecimal>> queryPriceByRentDocIds(@RequestParam(value="projectId") Long projectId, @RequestParam(value="docType") Integer docType, @RequestParam(value="docIds") List<Long> docIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.dutyService.queryPriceByDocIds(projectId, docType, true, docIds));
    }

    @GetMapping(value={"queryDutyByProjectId"})
    public CommonResponse<Boolean> queryDutyByProjectId(@RequestParam(value="projectId") Long projectId) {
        return this.dutyService.queryDutyByProjectId(projectId);
    }

    @PostMapping(value={"queryExtInfoByProjectIds"})
    public CommonResponse<List<Long>> queryDutyByProjectIds(@RequestBody List<Long> projectIds) {
        return this.dutyService.queryDutyByProjectIds(projectIds);
    }

    @RequestMapping(value={"/buildQueryProjects"}, method={RequestMethod.GET})
    @ResponseBody
    CommonResponse<List<BuildDutyVO>> buildQueryProjects(@RequestBody List<Long> projectIds) {
        return this.dutyService.buildQueryProjects(projectIds);
    }
}

