package com.ejianc.business.targetcost.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用模板明细
 *
 * @author generator
 */
@TableName("ejc_targetcost_fee_detail")
public class FeeDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "fee_id")
    private Long feeId; // 费用模板主键
    @TableField(value = "name")
    private String name; // 名称
    @TableField(value = "code")
    private String code; // 编码
    @TableField(value="unit_id")
    private Long unitId; // 单位ID
    @TableField(value="unit_name")
    private String unitName; // 单位名称
    @TableField(value = "inner_code")
    private String innerCode; // 内码
    @TableField(value = "category_id")
    private Long categoryId; // 分类（档案）id
    @TableField(value = "category_inner_code")
    private String categoryInnerCode; // 分类（档案）内码
    @TableField(value = "doc_type")
    private Integer docType; // 档案类型：劳务分包方案、专业分包档案、物料档案、设备档案、成本科目
    @TableField(value = "leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value = "self_flag")
    private Boolean selfFlag; // 行属性：引入档案、自制（是否自制）
    @TableField(value = "self_scope_flag")
    private Boolean selfScopeFlag; // 是否自身设置业务范围

    @TableField(value = "self_related_flag")
    private Boolean selfRelatedFlag; // 是否自身设置关联分类
    @TableField(value = "normal_child_flag")
    private Boolean normalChildFlag; // 是否正常子级

    @TableField(value="subject_id")
    private Long subjectId; // 成本科目主键
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称

    @TableField(value="fee_prop_id")
    private Long feePropId; // 费用属性Id
    @TableField(value="fee_prop_code")
    private String feePropCode; // 费用属性编码
    @TableField(value="fee_prop_name")
    private String feePropName; // 费用属性名称

    @TableField(exist = false)
    private List<FeeDetailEntity> relatedList = new ArrayList<>();

    @TableField(exist = false)
    private List<FeeDetailEntity> relatedDetailList = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "feeDetailScopeService", pidName = "feeDetailId")//此处有pid="xxx"，默认值pid="pid"
    private List<FeeDetailScopeEntity> feeDetailScopeList = new ArrayList<>(); // 业务范围列表

    @TableField(value = "parent_id")
    private Long parentId; // pid

    @TableField(value = "tree_index")
    private String treeIndex;
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    @TableField(exist = false)
    private String shadowId;

    @TableField(exist = false)
    private List<ITreeNodeB> children;

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Boolean getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Boolean selfFlag) {
        this.selfFlag = selfFlag;
    }

    public Boolean getSelfScopeFlag() {
        return selfScopeFlag;
    }

    public void setSelfScopeFlag(Boolean selfScopeFlag) {
        this.selfScopeFlag = selfScopeFlag;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryInnerCode() {
        return categoryInnerCode;
    }

    public void setCategoryInnerCode(String categoryInnerCode) {
        this.categoryInnerCode = categoryInnerCode;
    }

    public Integer getDocType() {
        return docType;
    }

    public void setDocType(Integer docType) {
        this.docType = docType;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public List<FeeDetailScopeEntity> getFeeDetailScopeList() {
        return feeDetailScopeList;
    }

    public void setFeeDetailScopeList(List<FeeDetailScopeEntity> feeDetailScopeList) {
        this.feeDetailScopeList = feeDetailScopeList;
    }

    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public Boolean getSelfRelatedFlag() {
        return selfRelatedFlag;
    }

    public void setSelfRelatedFlag(Boolean selfRelatedFlag) {
        this.selfRelatedFlag = selfRelatedFlag;
    }

    public Boolean getNormalChildFlag() {
        return normalChildFlag;
    }

    public void setNormalChildFlag(Boolean normalChildFlag) {
        this.normalChildFlag = normalChildFlag;
    }

    public List<FeeDetailEntity> getRelatedList() {
        return relatedList;
    }

    public void setRelatedList(List<FeeDetailEntity> relatedList) {
        this.relatedList = relatedList;
    }

    public List<FeeDetailEntity> getRelatedDetailList() {
        return relatedDetailList;
    }

    public void setRelatedDetailList(List<FeeDetailEntity> relatedDetailList) {
        this.relatedDetailList = relatedDetailList;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getFeePropId() {
        return feePropId;
    }

    public void setFeePropId(Long feePropId) {
        this.feePropId = feePropId;
    }

    public String getFeePropCode() {
        return feePropCode;
    }

    public void setFeePropCode(String feePropCode) {
        this.feePropCode = feePropCode;
    }

    public String getFeePropName() {
        return feePropName;
    }

    public void setFeePropName(String feePropName) {
        this.feePropName = feePropName;
    }
}
