package com.ejianc.business.targetcost.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用模板
 *
 * @author generator
 */
@TableName("ejc_targetcost_fee")
public class FeeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "org_id")
    private Long orgId; // 所属组织，不显示默认当前组织
    @TableField(value = "name")
    private String name; // 名称
    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "type")
    private Long type; // 类型
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）private jav billState; // 备注
    @TableField(value="enabled")
    private Boolean enabled; // 1:启用/0:停用

    @TableField(exist = false)
    @SubEntity(serviceName = "feeDetailService", pidName = "feeId")//此处有pid="xxx"，默认值pid="pid"
    private List<FeeDetailEntity> feeDetailList = new ArrayList<>(); // 费用模板明细


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<FeeDetailEntity> getFeeDetailList() {
        return feeDetailList;
    }

    public void setFeeDetailList(List<FeeDetailEntity> feeDetailList) {
        this.feeDetailList = feeDetailList;
    }
}
