package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.mapper.FeeDetailScopeMapper;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 费用模板明细业务范围
 *
 * @author generator
 *
 */
@Service("feeDetailScopeService")
public class FeeDetailScopeServiceImpl extends BaseServiceImpl<FeeDetailScopeMapper, FeeDetailScopeEntity> implements IFeeDetailScopeService{

    @Override
    public List<FeeDetailScopeEntity> findByFeeDetailId(Long feeDetailId) {
        LambdaQueryWrapper<FeeDetailScopeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailId);
        return list(queryWrapper);
    }

    @Override
    public void deleteByFeeDetailId(Long feeDetailId) {
        if (null == feeDetailId) {
            return;
        }
        LambdaUpdateWrapper<FeeDetailScopeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailId);
        remove(updateWrapper);
    }
}
