package com.ejianc.business.targetcost.utils;

import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;

import java.util.List;
import java.util.concurrent.Callable;

/**
 * 整个项目重算
 */
public class ReCalcExecCallable implements Callable<CommonResponse<String>> {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static  final  String  TC_LOCK = "TC_LOCK::";

    private RequestAttributes context;
    private Long projectId;
    private DutyEntity dutyEntity;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private IDutyDetailService dutyDetailService;
    private IDutyDetailItemService dutyDetailItemService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;
    private ITotalExecutionService totalExecutionService;
    private IDetailExecutionService detailExecutionService;
    private  List<String> unSubList;

    public ReCalcExecCallable(RequestAttributes context, Long projectId, DutyEntity dutyEntity, RedissonClient redissonClient, ITotalCacheService totalCacheService,
                                IDetailCacheService detailCacheService,  IDutyDetailService dutyDetailService,
                                IDutyDetailItemService dutyDetailItemService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService,
                              ITotalExecutionService totalExecutionService, IDetailExecutionService detailExecutionService,  List<String> unSubList) {
        this.context = context;
        this.projectId = projectId;
        this.dutyEntity = dutyEntity;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyDetailService = dutyDetailService;
        this.dutyDetailItemService = dutyDetailItemService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
        this.totalExecutionService = totalExecutionService;
        this.detailExecutionService = detailExecutionService;
        this.unSubList = unSubList;
    }

    @Override
    public CommonResponse<String> call() throws Exception {
        ReCalcExec reCalcExec = new ReCalcExec(context, projectId, dutyEntity, redissonClient, totalCacheService,
                detailCacheService, dutyDetailService, dutyDetailItemService, feeDetailService, feeDetailScopeService, totalExecutionService, detailExecutionService, unSubList);
        return reCalcExec.call();
    }

    /**
     * 重算明细缓存
     * @param dutyEntity
     * @return
     */
   /* private String reCalcDetail(DutyEntity dutyEntity) {
        Map<String, DetailCacheEntity> cacheAllMap = new HashMap<>();
        LambdaQueryWrapper<DetailExecutionEntity> detailExecQry = new LambdaQueryWrapper<>();
        detailExecQry.eq(DetailExecutionEntity::getProjectId, dutyEntity.getProjectId());
        detailExecQry.eq(DetailExecutionEntity::getCostFlag, true);
        detailExecQry.notIn(DetailExecutionEntity::getBussinessType, unSubList);
        List<DetailExecutionEntity> detailExecList = detailExecutionService.list(detailExecQry);

        Map<Long, List<FeeDetailScopeEntity>> scopeMap = queryScopeMap();

        Map<Long, List<DutyDetailItemEntity>> itemAllMap = queryAllItemMap();

        LambdaQueryWrapper<DutyDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyDetailEntity::getDutyId, dutyEntity.getId());
        List<DutyDetailEntity> detailEntities = dutyDetailService.list(queryWrapper);
        for (DutyDetailEntity detailEntity : detailEntities) {
            if(!scopeMap.containsKey(detailEntity.getFeeDetailId())){
                continue;
            }
            List<Long> categoryList = new ArrayList<>();
            if(detailEntity.getSelfRelatedFlag() && null == detailEntity.getCategoryId()){
                LambdaQueryWrapper<FeeDetailEntity> query = new LambdaQueryWrapper<>();
                query.eq(FeeDetailEntity::getParentId, detailEntity.getFeeDetailId());
                List<FeeDetailEntity> feeDetailEntities = feeDetailService.list(query);
                categoryList = feeDetailEntities.stream().map(FeeDetailEntity::getCategoryId).collect(Collectors.toList());
            }
            Set<String>  scopeSet = new HashSet<>();
            List<FeeDetailScopeEntity> scopeEntityList = scopeMap.get(detailEntity.getFeeDetailId());
            for(FeeDetailScopeEntity scopeEntity : scopeEntityList){
                scopeSet.add(scopeEntity.getBillCode() + "&" + scopeEntity.getPropertyValue());
            }

            List<DutyDetailItemEntity> itemEntities = itemAllMap.get(detailEntity.getId());
            if (CollectionUtils.isNotEmpty(itemEntities)) {
                for(DutyDetailItemEntity itemEntity : itemEntities){
                    String cacheUnKey = detailEntity.getId() + "$" +  itemEntity.getDocType() + "$" + itemEntity.getDocId();
                    if(!cacheAllMap.containsKey(cacheUnKey)){
                        DetailCacheEntity cacheEntity = BeanMapper.map(itemEntity, DetailCacheEntity.class);
                        cacheEntity.setId(null);
                        cacheEntity.setDutyItemId(itemEntity.getId());
                        cacheAllMap.put(cacheUnKey, cacheEntity);
                    }
                }
            }

            if (CollectionUtils.isNotEmpty(detailExecList)) {
                for (DetailExecutionEntity detailExecutionEntity : detailExecList) {
                    String unKey = detailExecutionEntity.getBussinessType() + "&" + detailExecutionEntity.getProperty();
                    if (!scopeSet.contains(unKey) || !check(detailEntity, detailExecutionEntity, categoryList)) {
                        continue;
                    }
                    String cacheUnKey = detailEntity.getId() + "$" +   detailExecutionEntity.getDocType()  + "$" + detailExecutionEntity.getDocId();
                    DetailCacheEntity cacheEntity;
                    if(cacheAllMap.containsKey(cacheUnKey)){
                        cacheEntity = cacheAllMap.get(cacheUnKey);
                    }else{
                        cacheEntity = BeanMapper.map(detailExecutionEntity, DetailCacheEntity.class);
                        if(detailExecutionEntity.getCategoryFlag()){
                            cacheEntity.setCode(detailExecutionEntity.getCategoryCode());
                            cacheEntity.setName(detailExecutionEntity.getCategoryName());
                        }
                        cacheEntity.setPrice(null);
                        cacheEntity.setTaxPrice(null);
                        cacheEntity.setModel(detailExecutionEntity.getSpec());
                        cacheEntity.setDutyDetailId(detailEntity.getId());
                        cacheEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                        cacheEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                        cacheEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                        cacheEntity.setId(null);
                        cacheEntity.setProjectId(dutyEntity.getProjectId());
                    }
                    cacheEntity.setBillCategory(detailExecutionEntity.getBillCategory());
                    setDetailValue(cacheEntity, detailExecutionEntity);
                    cacheAllMap.put(cacheUnKey, cacheEntity);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(cacheAllMap.values())){
            detailCacheService.saveOrUpdateBatch(cacheAllMap.values());
        }
        return null;
    }

    private boolean check(DutyDetailEntity detailEntity, DetailExecutionEntity detailExecutionEntity, List<Long> categoryList){
        if(null == detailEntity.getCategoryId() && !DocTypeEnum.成本科目.getCode().equals(detailExecutionEntity.getDocType())){
            boolean flag = false;
            if(CollectionUtils.isNotEmpty(categoryList)) {
                for (Long category : categoryList) {
                    if (null !=  detailExecutionEntity.getCategoryInnerCode() && detailExecutionEntity.getCategoryInnerCode().contains(String.valueOf(category))) {
                        flag = true;
                    }
                }
            }
            return flag;
        }else if(!detailEntity.getLeafFlag()){
            return  false;
        }else if(detailEntity.getDocType().compareTo(detailExecutionEntity.getDocType()) != 0){
            return  false;
        }else if(null == detailExecutionEntity.getCategoryInnerCode() || !detailExecutionEntity.getCategoryInnerCode().contains(String.valueOf(detailEntity.getCategoryId()))){
            return  false;
        }
        return  true;
    }

    private void reCalcTotal(DutyEntity dutyEntity) {
        List<TotalCacheEntity> totalList = new ArrayList<>();

        Map<String, List<TotalExecutionEntity>> totalExecMap = queryTotalExecMap();

        Map<Long, List<DetailCacheEntity>> detailCacheMap = queryDetailCacheMap();

        Map<Long, List<FeeDetailScopeEntity>> scopeMap = queryScopeMap();

        LambdaQueryWrapper<DutyDetailEntity> detailQuery = new LambdaQueryWrapper<>();
        detailQuery.eq(DutyDetailEntity::getDutyId, dutyEntity.getId());
        List<DutyDetailEntity> detailEntities = dutyDetailService.list(detailQuery);
        for (DutyDetailEntity detailEntity : detailEntities) {
            TotalCacheEntity totalEntity = BeanMapper.map(detailEntity, TotalCacheEntity.class);
            totalEntity.setId(null);
            totalEntity.setCode(detailEntity.getFeeDetailCode());
            totalEntity.setName(detailEntity.getFeeDetailName());
            totalEntity.setDutyDetailId(detailEntity.getId());
            totalEntity.setProjectId(dutyEntity.getProjectId());
            totalEntity.setCreateTime(null);
            totalEntity.setCreateUserCode(null);
            setValue(totalEntity, detailCacheMap.get(detailEntity.getId()), totalExecMap, scopeMap);
            totalList.add(totalEntity);
        }

        List<Map> resultMapList = BeanMapper.mapList(totalList, Map.class);
        List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);

        DutyCalcUtil.gatherMnyAndNum(null, treeData);


        List<TotalCacheEntity> entities = new ArrayList<>();
        treeToList(treeData, entities);

        for (TotalCacheEntity entity : entities) {
            if (BooleanUtils.isTrue(entity.getSelfScopeFlag()) && BooleanUtils.isFalse(entity.getLeafFlag()) && (null == entity.getAllCostFlag() || BooleanUtils.isFalse(entity.getAllCostFlag()))) {
                List<FeeDetailScopeEntity> scopeEntityList = scopeMap.get(entity.getFeeDetailId());
                for (FeeDetailScopeEntity scopeEntity : scopeEntityList) {
                    String key = scopeEntity.getBillCode() + "&" + scopeEntity.getPropertyValue();
                    if (totalExecMap.containsKey(key)) {
                        List<TotalExecutionEntity> totalExecutionEntities = totalExecMap.get(key);
                        setValueByList(entity, totalExecutionEntities);
                    }
                }
            }
        }

        if(CollectionUtils.isNotEmpty(entities)){
            totalCacheService.saveOrUpdateBatch(entities);
        }
    }

    private void setValueByList(TotalCacheEntity totalCacheEntity, List<TotalExecutionEntity> totalExecutionEntities) {
        for(TotalExecutionEntity executionEntity : totalExecutionEntities){
            if (BillCategoryEnum.计划.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), executionEntity.getMoney()));
                totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), executionEntity.getTaxMoney()));
            }else  if (BillCategoryEnum.合同.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), executionEntity.getMoney()));
                totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), executionEntity.getTaxMoney()));
            }else  if (BillCategoryEnum.入库.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), executionEntity.getMoney()));
                totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), executionEntity.getTaxMoney()));
            }else  if (BillCategoryEnum.其他.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), executionEntity.getMoney()));
                totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), executionEntity.getTaxMoney()));
            }else  if (BillCategoryEnum.结算.getCode().equals(executionEntity.getBillCategory())) {
                totalCacheEntity.setSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleMoney(), executionEntity.getMoney()));
                totalCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleTaxMoney(), executionEntity.getTaxMoney()));
            }
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<TotalCacheEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, TotalCacheEntity.class));
        }
    }

    private void setValue(TotalCacheEntity totalCacheEntity, List<DetailCacheEntity> itemEntityList, Map<String, List<TotalExecutionEntity>> totalExecMap, Map<Long, List<FeeDetailScopeEntity>> scopeMap){
        totalCacheEntity.setPlanMoney(null);
        totalCacheEntity.setPlanNum(null);
        totalCacheEntity.setPlanTaxMoney(null);
        totalCacheEntity.setOutPlanMoney(null);
        totalCacheEntity.setOutPlanTaxMoney(null);

        totalCacheEntity.setContMoney(null);
        totalCacheEntity.setContNum(null);
        totalCacheEntity.setContTaxMoney(null);
        totalCacheEntity.setOutContMoney(null);
        totalCacheEntity.setOutContTaxMoney(null);

        totalCacheEntity.setStoreMoney(null);
        totalCacheEntity.setStoreNum(null);
        totalCacheEntity.setStoreTaxMoney(null);
        totalCacheEntity.setOutStoreMoney(null);
        totalCacheEntity.setOutStoreTaxMoney(null);

        totalCacheEntity.setOtherMoney(null);
        totalCacheEntity.setOtherNum(null);
        totalCacheEntity.setOtherTaxMoney(null);
        totalCacheEntity.setOutOtherMoney(null);
        totalCacheEntity.setOutOtherTaxMoney(null);

        totalCacheEntity.setSettleMoney(null);
        totalCacheEntity.setSettleNum(null);
        totalCacheEntity.setSettleTaxMoney(null);
        totalCacheEntity.setOutSettleMoney(null);
        totalCacheEntity.setOutSettleTaxMoney(null);
        if (CollectionUtils.isNotEmpty(itemEntityList) && (BooleanUtils.isFalse(totalCacheEntity.getSelfScopeFlag()) || DocTypeEnum.成本科目.getCode().equals(totalCacheEntity.getDocType()))) {
            for (DetailCacheEntity itemEntity : itemEntityList) {
                totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), itemEntity.getPlanMoney()));
                totalCacheEntity.setPlanNum(ComputeUtil.safeAdd(totalCacheEntity.getPlanNum(), itemEntity.getPlanNum()));
                totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), itemEntity.getPlanTaxMoney()));
                totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), itemEntity.getContMoney()));
                totalCacheEntity.setContNum(ComputeUtil.safeAdd(totalCacheEntity.getContNum(), itemEntity.getContNum()));
                totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), itemEntity.getContTaxMoney()));
                totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), itemEntity.getStoreMoney()));
                totalCacheEntity.setStoreNum(ComputeUtil.safeAdd(totalCacheEntity.getStoreNum(), itemEntity.getStoreNum()));
                totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), itemEntity.getStoreTaxMoney()));
                totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), itemEntity.getOtherMoney()));
                totalCacheEntity.setOtherNum(ComputeUtil.safeAdd(totalCacheEntity.getOtherNum(), itemEntity.getOtherNum()));
                totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), itemEntity.getOtherTaxMoney()));
                totalCacheEntity.setSettleNum(ComputeUtil.safeAdd(totalCacheEntity.getSettleNum(), itemEntity.getSettleNum()));
                totalCacheEntity.setSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleMoney(), itemEntity.getSettleMoney()));
                totalCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleTaxMoney(), itemEntity.getSettleTaxMoney()));
                if(null == itemEntity.getDutyItemId()){
                    totalCacheEntity.setOutPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutPlanMoney(), itemEntity.getPlanMoney()));
                    totalCacheEntity.setOutPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutPlanTaxMoney(), itemEntity.getPlanTaxMoney()));
                    totalCacheEntity.setOutContMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutContMoney(), itemEntity.getContMoney()));
                    totalCacheEntity.setOutContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutContTaxMoney(), itemEntity.getContTaxMoney()));
                    totalCacheEntity.setOutStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutStoreMoney(), itemEntity.getStoreMoney()));
                    totalCacheEntity.setOutStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutStoreTaxMoney(), itemEntity.getStoreTaxMoney()));
                    totalCacheEntity.setOutOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutOtherMoney(), itemEntity.getOtherMoney()));
                    totalCacheEntity.setOutOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutOtherTaxMoney(), itemEntity.getOtherTaxMoney()));
                    totalCacheEntity.setOutSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutSettleMoney(), itemEntity.getSettleMoney()));
                    totalCacheEntity.setOutSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutSettleTaxMoney(), itemEntity.getSettleTaxMoney()));
                }
            }
        } else if (BooleanUtils.isTrue(totalCacheEntity.getLeafFlag()) && BooleanUtils.isTrue(totalCacheEntity.getSelfScopeFlag())) {
            List<FeeDetailScopeEntity> scopeEntityList = scopeMap.get(totalCacheEntity.getFeeDetailId());
            for (FeeDetailScopeEntity scopeEntity : scopeEntityList) {
                String key = scopeEntity.getBillCode() + "&" + scopeEntity.getPropertyValue();
                if (totalExecMap.containsKey(key)) {
                    List<TotalExecutionEntity> totalExecutionEntities = totalExecMap.get(key);
                    setValueByList(totalCacheEntity, totalExecutionEntities);
                }
            }
        }

    }

    *//**
     * 查询明细缓存，按责任成本明细ID分组
     * @return
     *//*
    private  Map<String, List<TotalExecutionEntity>> queryTotalExecMap(){
        Map<String, List<TotalExecutionEntity>> cacheMap = new HashMap<>();
        LambdaQueryWrapper<TotalExecutionEntity> totalExecQry = new LambdaQueryWrapper<>();
        totalExecQry.eq(TotalExecutionEntity::getProjectId, dutyEntity.getProjectId());
        totalExecQry.notIn(TotalExecutionEntity::getBussinessType, unSubList);
        List<TotalExecutionEntity> totalExecEntities = totalExecutionService.list(totalExecQry);
        if (CollectionUtils.isNotEmpty(totalExecEntities)) {
            List<TotalExecutionEntity> cacheEntityList;
            for (TotalExecutionEntity executionEntity : totalExecEntities) {
                String key = executionEntity.getBussinessType() + "&" + executionEntity.getProperty();
                if (cacheMap.containsKey(key)) {
                    cacheEntityList = cacheMap.get(key);
                }else{
                    cacheEntityList = new ArrayList<>();
                }
                cacheEntityList.add(executionEntity);
                cacheMap.put(key, cacheEntityList);
            }
        }
        return cacheMap;
    }

    *//**
     * 查询明细缓存，按责任成本明细ID分组
     * @return
     *//*
    private  Map<Long, List<DetailCacheEntity>> queryDetailCacheMap(){
        Map<Long, List<DetailCacheEntity>> cacheMap = new HashMap<>();
        LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailCacheEntity::getProjectId, dutyEntity.getProjectId());
        List<DetailCacheEntity> cacheEntities = detailCacheService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(cacheEntities)) {
            List<DetailCacheEntity> cacheEntityList;
            for (DetailCacheEntity cacheEntity : cacheEntities) {
                Long key = cacheEntity.getDutyDetailId();
                if (cacheMap.containsKey(key)) {
                    cacheEntityList = cacheMap.get(key);
                }else{
                    cacheEntityList = new ArrayList<>();
                }
                cacheEntityList.add(cacheEntity);
                cacheMap.put(key, cacheEntityList);
            }
        }
        return cacheMap;
    }

    *//**
     * 查询业务范围，按费用模板明细ID分组
     * @return
     *//*
    private  Map<Long, List<FeeDetailScopeEntity>> queryScopeMap(){
        Map<Long, List<FeeDetailScopeEntity>> scopeMap = new HashMap<>();
        LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeId, dutyEntity.getFeeId());
        List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
        if (CollectionUtils.isNotEmpty(scopeEntities)) {
            List<FeeDetailScopeEntity> scopeEntityList;
            for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                Long key = scopeEntity.getFeeDetailId();
                if (scopeMap.containsKey(key)) {
                    scopeEntityList = scopeMap.get(key);
                }else{
                    scopeEntityList = new ArrayList<>();
                }
                scopeEntityList.add(scopeEntity);
                scopeMap.put(key, scopeEntityList);
            }
        }
        return scopeMap;
    }

    *//**
     * 查询目标成本费用明细，按明细ID分组
     * @return
     *//*
    private  Map<Long, List<DutyDetailItemEntity>> queryAllItemMap(){
        Map<Long, List<DutyDetailItemEntity>> itemAllMap = new HashMap<>();
        LambdaQueryWrapper<DutyDetailItemEntity> itemQuery = new LambdaQueryWrapper<>();
        itemQuery.eq(DutyDetailItemEntity::getDutyId, dutyEntity.getId());
        List<DutyDetailItemEntity> itemEntityList = dutyDetailItemService.list(itemQuery);
        if (CollectionUtils.isNotEmpty(itemEntityList)) {
            if (CollectionUtils.isNotEmpty(itemEntityList)) {
                List<DutyDetailItemEntity> itemList;
                for (DutyDetailItemEntity detailItemEntity : itemEntityList) {
                    Long key = detailItemEntity.getDutyDetailId();
                    if (itemAllMap.containsKey(key)) {
                        itemList = itemAllMap.get(key);
                    }else{
                        itemList = new ArrayList<>();
                    }
                    itemList.add(detailItemEntity);
                    itemAllMap.put(key, itemList);
                }
            }
        }
        return  itemAllMap;
    }

    private void setDetailValue(DetailCacheEntity detailCacheEntity, DetailExecutionEntity detailExecutionEntity) {
        if (BillCategoryEnum.计划.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setPlanMoney(ComputeUtil.safeAdd(detailCacheEntity.getPlanMoney(), detailExecutionEntity.getMoney()));
            detailCacheEntity.setPlanNum(ComputeUtil.safeAdd(detailCacheEntity.getPlanNum(), detailExecutionEntity.getNum()));
            detailCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getPlanTaxMoney(), detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.合同.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setContMoney(ComputeUtil.safeAdd(detailCacheEntity.getContMoney(), detailExecutionEntity.getMoney()));
            detailCacheEntity.setContNum(ComputeUtil.safeAdd(detailCacheEntity.getContNum(), detailExecutionEntity.getNum()));
            detailCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getContTaxMoney(), detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.入库.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setStoreMoney(ComputeUtil.safeAdd(detailCacheEntity.getStoreMoney(), detailExecutionEntity.getMoney()));
            detailCacheEntity.setStoreNum(ComputeUtil.safeAdd(detailCacheEntity.getStoreNum(), detailExecutionEntity.getNum()));
            detailCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getStoreTaxMoney(), detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.其他.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setOtherMoney(ComputeUtil.safeAdd(detailCacheEntity.getOtherMoney(), detailExecutionEntity.getMoney()));
            detailCacheEntity.setOtherNum(ComputeUtil.safeAdd(detailCacheEntity.getOtherNum(), detailExecutionEntity.getNum()));
            detailCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getOtherTaxMoney(), detailExecutionEntity.getTaxMoney()));
        } else if (BillCategoryEnum.结算.getCode().equals(detailExecutionEntity.getBillCategory())) {
            detailCacheEntity.setSettleMoney(ComputeUtil.safeAdd(detailCacheEntity.getSettleMoney(), detailExecutionEntity.getMoney()));
            detailCacheEntity.setSettleNum(ComputeUtil.safeAdd(detailCacheEntity.getSettleNum(), detailExecutionEntity.getNum()));
            detailCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getSettleTaxMoney(), detailExecutionEntity.getTaxMoney()));
        }
    }*/
}
