/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.handler.ConversionBaseHandler;
import com.ejianc.business.targetcost.handler.IConversioneHandler;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.business.zhht.vo.BuildDutyEquipDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyMaterialDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyMeasureDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyOtherDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="zhhtBuildHandler")
public class ZHHTHandler
extends ConversionBaseHandler
implements IConversioneHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        ArrayList<DutyEntity> resp = new ArrayList<DutyEntity>();
        BuildDutyVO buildDutyVO = (BuildDutyVO)baseVO;
        HashMap<String, Object> handleApi = new HashMap<String, Object>();
        handleApi.put("\u4eba\u5de5\u8d39", this.shareLabsubApi);
        handleApi.put("\u4e13\u4e1a\u8d39", this.shareProsubApi);
        handleApi.put("\u6750\u6599\u8d39", this.shareMaterialApi);
        handleApi.put("\u673a\u68b0\u8d39", this.shareEquipmentApi);
        handleApi.put("\u63aa\u65bd\u8d39", null);
        handleApi.put("\u5176\u4ed6\u8d39", null);
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        ArrayList<Future<DutyEntity>> futures = new ArrayList<Future<DutyEntity>>();
        CommonCallable call = null;
        Future<DutyEntity> future = null;
        for (String string : handleApi.keySet()) {
            call = new CommonCallable(buildDutyVO, dutyEntity, feeVO, string, handleApi.get(string), "\u673a\u68b0\u8d39".equals(string) ? this.shareLabsubApi : null);
            future = threadPool.submit(call);
            futures.add(future);
        }
        try {
            for (Future future2 : futures) {
                resp.add((DutyEntity)((Object)future2.get()));
            }
        }
        catch (Exception e) {
            this.logger.error("\u9879\u76ee\u7b56\u5212\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u9879\u76ee\u7b56\u5212\u8f6c\u6362\u5f02\u5e38, ", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return resp;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
    }

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        BuildDutyVO buildDutyVO = (BuildDutyVO)baseVO;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)buildDutyVO, DutyEntity.class));
        dutyEntity.setFirstImportId(buildDutyVO.getBaseDutyId());
        dutyEntity.setImportId(buildDutyVO.getId());
        dutyEntity.setImportType(ConversionEnum.\u4e2d\u6838\u534e\u6cf0\u623f\u5efa.getCode());
        this.handlerHead(dutyEntity, isEff, baseVO);
        return CommonResponse.success((String)"\u8f6c\u6362\u9879\u76ee\u7b56\u5212\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        this.deleteDuty(importId);
        return CommonResponse.success((String)"\u5220\u9664\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    private DutyEntity dealOtherFeeData(List<BuildDutyOtherDetailVO> vos, DutyEntity sourceDutyEntity, FeeVO feeVO, String feeName) {
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        Long aqwmsgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!feeName.equals(detailVO.getName())) continue;
            aqwmsgfId = detailVO.getId();
        }
        ArrayList<String> leafFeeDetailName = new ArrayList<String>();
        ArrayList<Long> leafFeeDetailIds = new ArrayList<Long>();
        HashMap nameTreeIndexMap = new HashMap();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (null == detailVO.getLeafFlag() || !detailVO.getLeafFlag().booleanValue() || !detailVO.getInnerCode().startsWith(aqwmsgfId.toString())) continue;
            leafFeeDetailName.add(detailVO.getName());
            leafFeeDetailIds.add(detailVO.getId());
        }
        HashMap dutyDetailMap = new HashMap();
        vos.stream().filter(item -> leafFeeDetailName.contains(item.getOtherName())).forEach(item -> {
            nameTreeIndexMap.put(item.getOtherName(), item.getOtherTreeIndex());
            dutyDetailMap.put(item.getOtherTreeIndex(), new ArrayList());
        });
        vos.stream().filter(cData -> null != cData.getLeafFlag() && cData.getLeafFlag() != false).forEach(cData -> {
            for (String treeIndex : dutyDetailMap.keySet()) {
                if (!cData.getOtherTreeIndex().startsWith(treeIndex)) continue;
                ((List)dutyDetailMap.get(treeIndex)).add(cData);
            }
        });
        this.logger.info("other: {}", (Object)JSONObject.toJSONString(nameTreeIndexMap));
        this.logger.info("leafFeeDetailIds: {}", (Object)JSONObject.toJSONString(leafFeeDetailIds));
        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (!detailEntity.getLeafFlag().booleanValue() || !leafFeeDetailIds.contains(detailEntity.getFeeDetailId())) continue;
            this.logger.info("other dutyEntity name \uff1a {}", (Object)detailEntity.getFeeDetailName());
            int num = 1;
            if (!dutyDetailMap.containsKey(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) continue;
            for (BuildDutyOtherDetailVO cData2 : (List)dutyDetailMap.get(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) {
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)cData2.getOtherCode())) {
                    itemEntity.setCode(String.valueOf(num));
                } else {
                    itemEntity.setCode(cData2.getOtherCode());
                }
                itemEntity.setName(cData2.getOtherName());
                itemEntity.setUnitName(cData2.getOtherUnitName());
                itemEntity.setTaxRate(cData2.getOtherCostRate());
                itemEntity.setPrice(cData2.getOtherCostPrice());
                itemEntity.setTaxPrice(cData2.getOtherCostTaxPrice());
                itemEntity.setAmount(cData2.getOtherNum());
                itemEntity.setMny(cData2.getOtherCostMny());
                itemEntity.setTaxMny(cData2.getOtherCostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
                ++num;
            }
        }
        return dutyEntity;
    }

    private DutyEntity dealMeasureData(List<BuildDutyMeasureDetailVO> vos, DutyEntity sourceDutyEntity, FeeVO feeVO, String feeName) {
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        Long aqwmsgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!feeName.equals(detailVO.getName())) continue;
            aqwmsgfId = detailVO.getId();
        }
        ArrayList<String> leafFeeDetailName = new ArrayList<String>();
        HashMap nameTreeIndexMap = new HashMap();
        ArrayList<Long> leafFeeDetailIds = new ArrayList<Long>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (null == detailVO.getLeafFlag() || !detailVO.getLeafFlag().booleanValue() || !detailVO.getInnerCode().startsWith(aqwmsgfId.toString())) continue;
            leafFeeDetailName.add(detailVO.getName());
            leafFeeDetailIds.add(detailVO.getId());
        }
        HashMap dutyDetailMap = new HashMap();
        vos.stream().filter(item -> leafFeeDetailName.contains(item.getMeasureName())).forEach(item -> {
            nameTreeIndexMap.put(item.getMeasureName(), item.getMeasureTreeIndex());
            dutyDetailMap.put(item.getMeasureTreeIndex(), new ArrayList());
        });
        vos.stream().filter(cData -> null != cData.getLeafFlag() && cData.getLeafFlag() != false).forEach(cData -> {
            for (String treeIndex : dutyDetailMap.keySet()) {
                if (!cData.getMeasureTreeIndex().startsWith(treeIndex)) continue;
                ((List)dutyDetailMap.get(treeIndex)).add(cData);
            }
        });
        this.logger.info("measure: {}", (Object)JSONObject.toJSONString(nameTreeIndexMap));
        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (!detailEntity.getLeafFlag().booleanValue() || !leafFeeDetailIds.contains(detailEntity.getFeeDetailId())) continue;
            this.logger.info("measure dutyEntity name \uff1a {}", (Object)detailEntity.getFeeDetailName());
            int num = 1;
            if (!dutyDetailMap.containsKey(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) continue;
            for (BuildDutyMeasureDetailVO cData2 : (List)dutyDetailMap.get(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) {
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)cData2.getMeasureCode())) {
                    itemEntity.setCode(String.valueOf(num));
                } else {
                    itemEntity.setCode(cData2.getMeasureCode());
                }
                itemEntity.setName(cData2.getMeasureName());
                itemEntity.setUnitName(cData2.getMeasureUnitName());
                itemEntity.setTaxRate(cData2.getMeasureCostRate());
                itemEntity.setPrice(cData2.getMeasureCostPrice());
                itemEntity.setTaxPrice(cData2.getMeasureCostTaxPrice());
                itemEntity.setAmount(cData2.getMeasureNum());
                itemEntity.setMny(cData2.getMeasureCostMny());
                itemEntity.setTaxMny(cData2.getMeasureCostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
                ++num;
            }
        }
        return dutyEntity;
    }

    private DutyEntity dealEquipData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi, Object restApi2) {
        CommonResponse labItemResponse;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        IShareEquipmentApi _restApi = (IShareEquipmentApi)restApi;
        IShareLabsubApi _labsubrestApi = (IShareLabsubApi)restApi2;
        if (CollectionUtils.isEmpty(feeVO.getFeeDetailList())) {
            return dutyEntity;
        }
        Long jxfId = null;
        Long tzsbfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238542").equals(detailVO.getFeePropId())) {
                jxfId = detailVO.getId();
            }
            if (!Long.valueOf("1932409448614203393").equals(detailVO.getFeePropId())) continue;
            tzsbfId = detailVO.getId();
        }
        if (null == jxfId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u673a\u68b0\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> jxfSet = new HashSet<Long>();
        HashSet<String> jxfDetailNameSet = new HashSet<String>();
        HashSet<Long> tzsbfSet = new HashSet<Long>();
        HashSet<String> tzsbfDetailNameSet = new HashSet<String>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (feeDetailVO.getInnerCode().contains(String.valueOf(jxfId))) {
                jxfSet.add(feeDetailVO.getId());
                jxfDetailNameSet.add(feeDetailVO.getName());
            }
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(tzsbfId))) continue;
            tzsbfSet.add(feeDetailVO.getId());
            tzsbfDetailNameSet.add(feeDetailVO.getName());
        }
        Long qtjxfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) || !jxfSet.contains(detailVO.getId())) continue;
            qtjxfId = detailVO.getId();
        }
        if (null == qtjxfId) {
            this.logger.error("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u673a\u68b0\u8d39\u3011\u7684\u8d39\u7528\u9879");
            qtjxfId = -1L;
        }
        this.logger.info(" ******* jxfSet : {}", (Object)JSONObject.toJSONString(jxfSet));
        this.logger.info(" jxfDetailNameSet : {}", (Object)JSONObject.toJSONString(jxfDetailNameSet));
        this.logger.info(" ******* tzsbfSet : {}", (Object)JSONObject.toJSONString(tzsbfSet));
        this.logger.info(" ******* tzsbfDetailNameSet : {}", (Object)JSONObject.toJSONString(tzsbfDetailNameSet));
        ArrayList arrayList = new ArrayList();
        ArrayList labsubCodeList = new ArrayList();
        ArrayList tzsbTreeIndex = new ArrayList();
        ArrayList tzsbLeafTreeIndex = new ArrayList();
        ArrayList jxfTreeIndex = new ArrayList();
        ArrayList jxfLeafTreeIndex = new ArrayList();
        buildDutyVO.getEquipDetailList().stream().forEach(item -> {
            if (jxfDetailNameSet.contains(item.getEquipDocName())) {
                jxfTreeIndex.add(item.getEquipTreeIndex());
            }
            if (tzsbfDetailNameSet.contains(item.getEquipDocName())) {
                tzsbTreeIndex.add(item.getEquipTreeIndex());
            }
        });
        this.logger.info(" ******* jxfTreeIndex : {}", (Object)JSONObject.toJSONString(jxfTreeIndex));
        this.logger.info(" ******* tzsbTreeIndex : {}", (Object)JSONObject.toJSONString(tzsbTreeIndex));
        buildDutyVO.getEquipDetailList().stream().filter(cData -> null != cData.getLeafFlag() && cData.getLeafFlag() != false).forEach(cData -> {
            for (String treeIndex : tzsbTreeIndex) {
                if (!cData.getEquipTreeIndex().startsWith(treeIndex)) continue;
                tzsbLeafTreeIndex.add(cData.getEquipTreeIndex());
                labsubCodeList.add(cData.getEquipDocCode());
            }
            for (String treeIndex : jxfTreeIndex) {
                if (!cData.getEquipTreeIndex().startsWith(treeIndex)) continue;
                equipCodeList.add(cData.getEquipDocCode());
                jxfLeafTreeIndex.add(cData.getEquipTreeIndex());
            }
        });
        this.logger.info(" ******* tzsbLeafTreeIndex : {}", (Object)JSONObject.toJSONString(tzsbLeafTreeIndex));
        this.logger.info(" labsubCodeList : {}", (Object)JSONObject.toJSONString(labsubCodeList));
        this.logger.info(" ******* equipCodeList : {}", (Object)JSONObject.toJSONString(arrayList));
        this.logger.info(" ******* jxfLeafTreeIndex : {}", (Object)JSONObject.toJSONString(jxfLeafTreeIndex));
        Map<Object, Object> matMap = new HashMap();
        if (CollectionUtils.isNotEmpty(arrayList)) {
            CommonResponse matResponse = _restApi.queryEquipmentListByCodes(arrayList);
            if (CollectionUtils.isEmpty((Collection)((Collection)matResponse.getData()))) {
                this.logger.error("!!!!\u9879\u76ee\u7b56\u5212 \u673a\u68b0\u8d39\u8f6c\u6362\u5931\u8d25\uff0c\u67e5\u8be2\u5230\u7269\u6599\u6863\u6848\u4e3a\u7a7a\uff01");
                return dutyEntity;
            }
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)matResponse.getData()))) {
                matMap = ((List)matResponse.getData()).stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
        }
        CommonResponse equipCtyResponse = this.shareEquipmentApi.queryCategoryListByIds(new ArrayList());
        HashMap<Long, String> equipCtyLongInnerMap = new HashMap<Long, String>();
        HashMap<String, String> equipCtyStringInnerMap = new HashMap<String, String>();
        for (EquipmentCategoryVO categoryVO : (List)equipCtyResponse.getData()) {
            equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
            equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
        }
        Map<Object, Object> labCtyInnerCodeMap = new HashMap();
        Map<Object, Object> labSubMap = new HashMap();
        CommonResponse labCtyResponse = _labsubrestApi.queryCategoryListByIds(new ArrayList());
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labCtyResponse.getData()))) {
            labCtyInnerCodeMap = ((List)labCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }
        if (CollectionUtils.isNotEmpty(labsubCodeList) && (labItemResponse = _labsubrestApi.queryItemListByCodes(labsubCodeList)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labItemResponse.getData()))) {
            labSubMap = ((List)labItemResponse.getData()).stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }
        int num = 1;
        for (BuildDutyEquipDetailVO buildEquipmentVO : buildDutyVO.getEquipDetailList()) {
            if (null == buildEquipmentVO.getLeafFlag() || !buildEquipmentVO.getLeafFlag().booleanValue() || null == buildEquipmentVO.getEquipNum()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                DutyDetailItemEntity itemEntity;
                ArrayList<DutyDetailItemEntity> itemList;
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipDocCode()) && matMap.containsKey(buildEquipmentVO.getEquipDocCode())) {
                    EquipmentVO equipmentVO = (EquipmentVO)matMap.get(buildEquipmentVO.getEquipDocCode());
                    String innerCode = (String)equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(equipmentVO.getCode());
                    itemEntity.setName(equipmentVO.getName());
                    itemEntity.setModel(equipmentVO.getSpec());
                    itemEntity.setUnitId(equipmentVO.getUnitId());
                    itemEntity.setUnitName(equipmentVO.getUnitName());
                    itemEntity.setTaxRate(buildEquipmentVO.getEquipCostRate());
                    itemEntity.setPrice(buildEquipmentVO.getEquipCostPrice());
                    itemEntity.setTaxPrice(buildEquipmentVO.getEquipCostTaxPrice());
                    itemEntity.setAmount(buildEquipmentVO.getEquipNum());
                    itemEntity.setMny(buildEquipmentVO.getEquipCostMny());
                    itemEntity.setTaxMny(buildEquipmentVO.getEquipCostTaxMny());
                    itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipRentDays());
                    itemEntity.setCategoryId(equipmentVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(equipmentVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                    itemEntity.setDocId(equipmentVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipDocCode()) && labSubMap.containsKey(buildEquipmentVO.getEquipDocCode())) {
                    LabsubItemVO labsubItemVO = (LabsubItemVO)labSubMap.get(buildEquipmentVO.getEquipDocCode());
                    String labsubInnerCode = (String)labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !labsubInnerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(labsubInnerCode, detailEntity.getCategoryInnerCode()) || !tzsbfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList();
                    itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(labsubItemVO.getTrawlingCode());
                    itemEntity.setName(labsubItemVO.getTrawlingName());
                    itemEntity.setPriceType(labsubItemVO.getPriceType());
                    itemEntity.setJobContent(labsubItemVO.getJobContent());
                    itemEntity.setUnitName(labsubItemVO.getUnitName());
                    itemEntity.setTaxRate(buildEquipmentVO.getEquipCostRate());
                    itemEntity.setPrice(buildEquipmentVO.getEquipCostPrice());
                    itemEntity.setTaxPrice(buildEquipmentVO.getEquipCostTaxPrice());
                    itemEntity.setAmount(buildEquipmentVO.getEquipNum());
                    itemEntity.setMny(buildEquipmentVO.getEquipCostMny());
                    itemEntity.setTaxMny(buildEquipmentVO.getEquipCostTaxMny());
                    itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(labsubInnerCode);
                    itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    itemEntity.setDocId(labsubItemVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipDocCode()) && equipCtyStringInnerMap.containsKey(buildEquipmentVO.getEquipDocCode())) {
                    String innerCode = (String)equipCtyStringInnerMap.get(buildEquipmentVO.getEquipDocCode());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)buildEquipmentVO.getEquipNum()));
                    detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)buildEquipmentVO.getEquipCostMny()));
                    detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)buildEquipmentVO.getEquipCostTaxMny()));
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(qtjxfId)) continue;
                ArrayList<DutyDetailItemEntity> itemList2 = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity2 = new DutyDetailItemEntity();
                itemEntity2.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)buildEquipmentVO.getEquipDocCode())) {
                    itemEntity2.setCode(String.valueOf(num));
                } else {
                    itemEntity2.setCode(buildEquipmentVO.getEquipDocCode());
                }
                itemEntity2.setName(buildEquipmentVO.getEquipDocName());
                itemEntity2.setUnitName(buildEquipmentVO.getEquipUnitName());
                itemEntity2.setTaxRate(buildEquipmentVO.getEquipCostRate());
                itemEntity2.setPrice(buildEquipmentVO.getEquipCostPrice());
                itemEntity2.setTaxPrice(buildEquipmentVO.getEquipCostTaxPrice());
                itemEntity2.setAmount(buildEquipmentVO.getEquipNum());
                itemEntity2.setMny(buildEquipmentVO.getEquipCostMny());
                itemEntity2.setTaxMny(buildEquipmentVO.getEquipCostTaxMny());
                itemEntity2.setRmatRentMonth(buildEquipmentVO.getEquipRentDays());
                itemEntity2.setDocType(6);
                itemList2.add(itemEntity2);
                detailEntity.setDutyDetailItemList(itemList2);
            }
            if (!StringUtils.isBlank((CharSequence)buildEquipmentVO.getEquipDocCode())) continue;
            ++num;
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealMaterialData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var11_14;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        IShareMaterialApi _restApi = (IShareMaterialApi)restApi;
        if (CollectionUtils.isEmpty((Collection)buildDutyVO.getMaterialDetailList())) {
            return dutyEntity;
        }
        HashMap<Long, String> matCtyLongInnerMap = new HashMap<Long, String>();
        HashMap<String, String> matCtyStringInnerMap = new HashMap<String, String>();
        Long clfId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238535").equals(feeDetailVO.getFeePropId())) continue;
            clfId = feeDetailVO.getId();
        }
        if (null == clfId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> clfSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(clfId))) continue;
            clfSet.add(feeDetailVO.getId());
        }
        Object var11_13 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) || !clfSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var11_14) {
            this.logger.error("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff01");
            Long l = -1L;
        }
        List list = buildDutyVO.getMaterialDetailList().stream().filter(item -> null != item.getLeafFlag() && item.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)item.getMaterialDocCode())).map(BuildDutyMaterialDetailVO::getMaterialDocCode).collect(Collectors.toList());
        CommonResponse matResponse = _restApi.queryMaterialListByCodes(list);
        Map<Object, Object> matMap = new HashMap();
        if (matResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)matResponse.getData()))) {
            matMap = ((List)matResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
        }
        int num = 1;
        for (BuildDutyMaterialDetailVO buildMaterialVO : buildDutyVO.getMaterialDetailList()) {
            if (null == buildMaterialVO.getLeafFlag() || !buildMaterialVO.getLeafFlag().booleanValue() || null == buildMaterialVO.getMaterialNum()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                void var11_17;
                MaterialVO materialVO;
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialDocCode())) {
                    CommonResponse response;
                    if (matMap.containsKey(buildMaterialVO.getMaterialDocCode())) {
                        materialVO = (MaterialVO)matMap.get(buildMaterialVO.getMaterialDocCode());
                        if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                            CommonResponse response2 = _restApi.queryCategoryById(materialVO.getCategoryId());
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)response2.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    } else if (!matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialDocCode()) && (response = _restApi.queryCategoryByCode(buildMaterialVO.getMaterialDocCode())).isSuccess() && null != response.getData()) {
                        MaterialCategoryVO categoryVO = (MaterialCategoryVO)response.getData();
                        matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                        matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialDocCode()) && matMap.containsKey(buildMaterialVO.getMaterialDocCode())) {
                    materialVO = (MaterialVO)matMap.get(buildMaterialVO.getMaterialDocCode());
                    String innerCode = (String)matCtyLongInnerMap.get(materialVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(materialVO.getCode());
                    itemEntity.setName(materialVO.getName());
                    itemEntity.setModel(materialVO.getSpec());
                    itemEntity.setUnitId(materialVO.getUnitId());
                    itemEntity.setUnitName(materialVO.getUnitName());
                    itemEntity.setTaxRate(buildMaterialVO.getMaterialCostRate());
                    itemEntity.setPrice(buildMaterialVO.getMaterialCostPrice());
                    itemEntity.setTaxPrice(buildMaterialVO.getMaterialCostTaxPrice());
                    itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                    itemEntity.setMny(buildMaterialVO.getMaterialCostMny());
                    itemEntity.setTaxMny(buildMaterialVO.getMaterialCostTaxMny());
                    itemEntity.setCategoryId(materialVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(materialVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                    itemEntity.setDocId(materialVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialDocCode()) && matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialDocCode())) {
                    String innerCode = (String)matCtyStringInnerMap.get(buildMaterialVO.getMaterialDocCode());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)buildMaterialVO.getMaterialNum()));
                    detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)buildMaterialVO.getMaterialCostMny()));
                    detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)buildMaterialVO.getMaterialCostTaxMny()));
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var11_17)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)buildMaterialVO.getMaterialDocCode())) {
                    itemEntity.setCode(String.valueOf(num));
                    ++num;
                } else {
                    itemEntity.setCode(buildMaterialVO.getMaterialDocCode());
                }
                itemEntity.setName(buildMaterialVO.getMaterialDocName());
                itemEntity.setUnitName(buildMaterialVO.getMaterialUnitName());
                itemEntity.setTaxRate(buildMaterialVO.getMaterialCostRate());
                itemEntity.setPrice(buildMaterialVO.getMaterialCostPrice());
                itemEntity.setTaxPrice(buildMaterialVO.getMaterialCostTaxPrice());
                itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                itemEntity.setMny(buildMaterialVO.getMaterialCostMny());
                itemEntity.setTaxMny(buildMaterialVO.getMaterialCostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealProsubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var9_12;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        if (CollectionUtils.isEmpty((Collection)buildDutyVO.getProSubDetailList())) {
            return dutyEntity;
        }
        IShareProsubApi _restApi = (IShareProsubApi)restApi;
        Long zyfbId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238540").equals(feeDetailVO.getFeePropId())) continue;
            zyfbId = feeDetailVO.getId();
        }
        if (null == zyfbId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4e13\u4e1a\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> zyfbSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(zyfbId))) continue;
            zyfbSet.add(feeDetailVO.getId());
        }
        Object var9_11 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) || !zyfbSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var9_12) {
            this.logger.error("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4e13\u4e1a\u8d39\u3011\u7684\u8d39\u7528\u9879");
            Long l = -1L;
        }
        List list = buildDutyVO.getProSubDetailList().stream().filter(subVO -> null != subVO.getLeafFlag() && subVO.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)subVO.getProSubDocCode())).map(BuildDutyProSubDetailVO::getProSubDocCode).collect(Collectors.toList());
        CommonResponse proCtyResponse = _restApi.queryCategoryListByIds(new ArrayList());
        Map<Object, Object> proCtyInnerCodeMap = new HashMap();
        if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proCtyResponse.getData()))) {
            proCtyInnerCodeMap = ((List)proCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }
        Map<Object, Object> proSubMap = new HashMap();
        CommonResponse proItemResponse = _restApi.queryItemListByCodes(list);
        if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proItemResponse.getData()))) {
            proSubMap = ((List)proItemResponse.getData()).stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }
        for (BuildDutyProSubDetailVO subVO2 : buildDutyVO.getProSubDetailList()) {
            if (null == subVO2.getLeafFlag() || !subVO2.getLeafFlag().booleanValue() || null == subVO2.getProSubNum()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                void var9_15;
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)subVO2.getProSubDocCode()) && proSubMap.containsKey(subVO2.getProSubDocCode())) {
                    ProsubItemVO prosubItemVO = (ProsubItemVO)proSubMap.get(subVO2.getProSubDocCode());
                    String innerCode = (String)proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zyfbSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(prosubItemVO.getTrawlingCode());
                    itemEntity.setName(prosubItemVO.getTrawlingName());
                    itemEntity.setPriceType(prosubItemVO.getPriceType());
                    itemEntity.setJobContent(prosubItemVO.getJobContent());
                    itemEntity.setUnitName(prosubItemVO.getUnitName());
                    itemEntity.setTaxRate(subVO2.getProSubCostRate());
                    itemEntity.setPrice(subVO2.getProSubCostPrice());
                    itemEntity.setTaxPrice(subVO2.getProSubCostTaxPrice());
                    itemEntity.setAmount(subVO2.getProSubNum());
                    itemEntity.setMny(subVO2.getProSubCostMny());
                    itemEntity.setTaxMny(subVO2.getProSubCostTaxMny());
                    itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    itemEntity.setDocId(prosubItemVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var9_15)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                itemEntity.setCode(subVO2.getProSubDocCode());
                itemEntity.setName(subVO2.getProSubDocName());
                itemEntity.setUnitName(subVO2.getProSubUnitName());
                itemEntity.setTaxRate(subVO2.getProSubCostRate());
                itemEntity.setPrice(subVO2.getProSubCostPrice());
                itemEntity.setTaxPrice(subVO2.getProSubCostTaxPrice());
                itemEntity.setAmount(subVO2.getProSubNum());
                itemEntity.setMny(subVO2.getProSubCostMny());
                itemEntity.setTaxMny(subVO2.getProSubCostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealLasubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var9_12;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        if (CollectionUtils.isEmpty((Collection)buildDutyVO.getLaborDetailList())) {
            return dutyEntity;
        }
        IShareLabsubApi _restApi = (IShareLabsubApi)restApi;
        Long rgfId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238533").equals(feeDetailVO.getFeePropId())) continue;
            rgfId = feeDetailVO.getId();
        }
        if (null == rgfId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> rgfSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(rgfId))) continue;
            rgfSet.add(feeDetailVO.getId());
        }
        Object var9_11 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) || !rgfSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var9_12) {
            this.logger.error("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879");
            Long l = -1L;
        }
        List list = buildDutyVO.getLaborDetailList().stream().filter(rgcostVO -> null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)rgcostVO.getLaborDocCode())).map(BuildDutyLaborCostDetailVO::getLaborDocCode).collect(Collectors.toList());
        CommonResponse labCtyResponse = _restApi.queryCategoryListByIds(new ArrayList());
        Map<Object, Object> labCtyInnerCodeMap = new HashMap();
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labCtyResponse.getData()))) {
            labCtyInnerCodeMap = ((List)labCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }
        Map<Object, Object> labSubMap = new HashMap();
        CommonResponse labItemResponse = _restApi.queryItemListByCodes(list);
        if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labItemResponse.getData()))) {
            labSubMap = ((List)labItemResponse.getData()).stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }
        for (BuildDutyLaborCostDetailVO rgcostVO2 : buildDutyVO.getLaborDetailList()) {
            if (null == rgcostVO2.getLeafFlag() || !rgcostVO2.getLeafFlag().booleanValue() || null == rgcostVO2.getLaborNum()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                void var9_15;
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)rgcostVO2.getLaborDocCode()) && labSubMap.containsKey(rgcostVO2.getLaborDocCode())) {
                    LabsubItemVO labsubItemVO = (LabsubItemVO)labSubMap.get(rgcostVO2.getLaborDocCode());
                    String innerCode = (String)labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !rgfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(labsubItemVO.getTrawlingCode());
                    itemEntity.setName(labsubItemVO.getTrawlingName());
                    itemEntity.setPriceType(labsubItemVO.getPriceType());
                    itemEntity.setJobContent(labsubItemVO.getJobContent());
                    itemEntity.setUnitName(labsubItemVO.getUnitName());
                    itemEntity.setTaxRate(rgcostVO2.getLaborCostRate());
                    itemEntity.setPrice(rgcostVO2.getLaborCostPrice());
                    itemEntity.setTaxPrice(rgcostVO2.getLaborCostTaxPrice());
                    itemEntity.setAmount(rgcostVO2.getLaborNum());
                    itemEntity.setMny(rgcostVO2.getLaborCostMny());
                    itemEntity.setTaxMny(rgcostVO2.getLaborCostTaxMny());
                    itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    itemEntity.setDocId(labsubItemVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var9_15)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                itemEntity.setCode(rgcostVO2.getLaborDocCode());
                itemEntity.setName(rgcostVO2.getLaborDocName());
                itemEntity.setUnitName(rgcostVO2.getLaborUnitName());
                itemEntity.setTaxRate(rgcostVO2.getLaborCostRate());
                itemEntity.setPrice(rgcostVO2.getLaborCostPrice());
                itemEntity.setTaxPrice(rgcostVO2.getLaborCostTaxPrice());
                itemEntity.setAmount(rgcostVO2.getLaborNum());
                itemEntity.setMny(rgcostVO2.getLaborCostMny());
                itemEntity.setTaxMny(rgcostVO2.getLaborCostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealSubEquipData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var9_12;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        if (CollectionUtils.isEmpty((Collection)buildDutyVO.getLaborDetailList())) {
            return dutyEntity;
        }
        IShareLabsubApi _restApi = (IShareLabsubApi)restApi;
        Long rgfId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("1932409448614203393").equals(feeDetailVO.getFeePropId())) continue;
            rgfId = feeDetailVO.getId();
        }
        if (null == rgfId) {
            this.logger.error("********\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u7279\u79cd\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u4e0d\u8fdb\u884c\u8f6c\u6362\uff01**********");
            return dutyEntity;
        }
        HashSet<Long> rgfSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(rgfId))) continue;
            rgfSet.add(feeDetailVO.getId());
        }
        Object var9_11 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) || !rgfSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var9_12) {
            this.logger.error("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u7279\u79cd\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879");
            Long l = -1L;
        }
        List list = buildDutyVO.getLaborDetailList().stream().filter(rgcostVO -> null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)rgcostVO.getLaborDocCode())).map(BuildDutyLaborCostDetailVO::getLaborDocCode).collect(Collectors.toList());
        CommonResponse labCtyResponse = _restApi.queryCategoryListByIds(new ArrayList());
        Map<Object, Object> labCtyInnerCodeMap = new HashMap();
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labCtyResponse.getData()))) {
            labCtyInnerCodeMap = ((List)labCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }
        Map<Object, Object> labSubMap = new HashMap();
        CommonResponse labItemResponse = _restApi.queryItemListByCodes(list);
        if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labItemResponse.getData()))) {
            labSubMap = ((List)labItemResponse.getData()).stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }
        for (BuildDutyLaborCostDetailVO rgcostVO2 : buildDutyVO.getLaborDetailList()) {
            if (null == rgcostVO2.getLeafFlag() || !rgcostVO2.getLeafFlag().booleanValue() || null == rgcostVO2.getLaborNum()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                void var9_15;
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)rgcostVO2.getLaborDocCode()) && labSubMap.containsKey(rgcostVO2.getLaborDocCode())) {
                    LabsubItemVO labsubItemVO = (LabsubItemVO)labSubMap.get(rgcostVO2.getLaborDocCode());
                    String innerCode = (String)labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !rgfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(labsubItemVO.getTrawlingCode());
                    itemEntity.setName(labsubItemVO.getTrawlingName());
                    itemEntity.setPriceType(labsubItemVO.getPriceType());
                    itemEntity.setJobContent(labsubItemVO.getJobContent());
                    itemEntity.setUnitName(labsubItemVO.getUnitName());
                    itemEntity.setTaxRate(rgcostVO2.getLaborCostRate());
                    itemEntity.setPrice(rgcostVO2.getLaborCostPrice());
                    itemEntity.setTaxPrice(rgcostVO2.getLaborCostTaxPrice());
                    itemEntity.setAmount(rgcostVO2.getLaborNum());
                    itemEntity.setMny(rgcostVO2.getLaborCostMny());
                    itemEntity.setTaxMny(rgcostVO2.getLaborCostTaxMny());
                    itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u7279\u79cd\u8bbe\u5907\u6863\u6848.getCode());
                    itemEntity.setDocId(labsubItemVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var9_15)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                itemEntity.setCode(rgcostVO2.getLaborDocCode());
                itemEntity.setName(rgcostVO2.getLaborDocName());
                itemEntity.setUnitName(rgcostVO2.getLaborUnitName());
                itemEntity.setTaxRate(rgcostVO2.getLaborCostRate());
                itemEntity.setPrice(rgcostVO2.getLaborCostPrice());
                itemEntity.setTaxPrice(rgcostVO2.getLaborCostTaxPrice());
                itemEntity.setAmount(rgcostVO2.getLaborNum());
                itemEntity.setMny(rgcostVO2.getLaborCostMny());
                itemEntity.setTaxMny(rgcostVO2.getLaborCostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    class CommonCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;
        private String handleType;
        private Object restApi;
        private Object restApi2;

        public CommonCallable(BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO, String handleType, Object restApi, Object restApi2) {
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
            this.handleType = handleType;
            this.restApi = restApi;
            this.restApi2 = restApi2;
        }

        @Override
        public DutyEntity call() throws Exception {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            switch (this.handleType) {
                case "\u4eba\u5de5\u8d39": {
                    return ZHHTHandler.this.dealLasubData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u7279\u79cd\u8bbe\u5907\u8d39": {
                    return ZHHTHandler.this.dealSubEquipData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u4e13\u4e1a\u8d39": {
                    return ZHHTHandler.this.dealProsubData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u6750\u6599\u8d39": {
                    return ZHHTHandler.this.dealMaterialData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u673a\u68b0\u8d39": {
                    return ZHHTHandler.this.dealEquipData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi, this.restApi2);
                }
                case "\u63aa\u65bd\u8d39": {
                    return ZHHTHandler.this.dealMeasureData(this.buildDutyVO.getMeasureDetailList(), this.baseDutyEntity, this.feeVO, this.handleType);
                }
                case "\u5176\u4ed6\u8d39": {
                    return ZHHTHandler.this.dealOtherFeeData(this.buildDutyVO.getOtherDetailList(), this.baseDutyEntity, this.feeVO, this.handleType);
                }
            }
            throw new BusinessException("\u9519\u8bef\u7684\u8d39\u7528\u540d\u79f0" + this.handleType);
        }
    }
}

