/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="duty")
public class DutyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u63d0\u4ea4\u524d\u56de\u8c03====================================== state:" + state);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        this.logger.info("state---------------\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03-------------------" + state);
        if (state == 0 && dutyEntity.getLastDutyId() == null && (BooleanUtils.isFalse((Boolean)dutyEntity.getLatestFlag()) || 1 != dutyEntity.getDutyVersion() && BooleanUtils.isFalse((Boolean)dutyEntity.getEnableState()))) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03====================================== state:" + state);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, true);
        this.updateItemSubjectInner(billId);
        this.dutyService.gatherDuty(billId);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("state---------------\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03-------------------" + state);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        if (!dutyEntity.getEnableState().booleanValue() || !dutyEntity.getLatestFlag().booleanValue()) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (null != dutyEntity.getImportId()) {
            throw new BusinessException("\u5bfc\u5165\u63a8\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        this.dutyService.gatherDuty(billId);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    private void updateEnableAndWriteBack(Long billId, Boolean isPass) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.getById(billId));
        dutyEntity.setEnableState(isPass);
        this.dutyService.saveOrUpdate((Object)dutyEntity);
        if (dutyEntity.getLastDutyId() != null) {
            DutyEntity revise = (DutyEntity)((Object)this.dutyService.getById(dutyEntity.getLastDutyId()));
            revise.setChangeState(isPass != false ? ChangeStateEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setEnableState(isPass == false);
            this.dutyService.saveOrUpdate((Object)revise);
        }
    }

    private void updateItemSubjectInner(Long billId) {
        CommonResponse subjectResponse = this.shareSubjectOrgApi.shareSubjectOrgApi();
        Map<Object, Object> subjectMap = new HashMap();
        if (subjectResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)subjectResponse.getData()))) {
            subjectMap = ((List)subjectResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyDetailItemEntity::getDutyId, (Object)billId);
        queryWrapper.isNull(DutyDetailItemEntity::getSubjectInnerCode);
        queryWrapper.isNotNull(DutyDetailItemEntity::getSubjectId);
        List list = this.dutyDetailItemService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DutyDetailItemEntity itemEntity : list) {
                SubjectOrgVO subjectOrgVO = (SubjectOrgVO)subjectMap.get(itemEntity.getSubjectId());
                itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
                itemEntity.setSubjectInnerCode(subjectOrgVO.getInnerCode());
            }
            this.dutyDetailItemService.saveOrUpdateBatch(list);
        }
    }
}

