package com.ejianc.business.targetcost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/api/execution/")
public class ExecutionApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
   private ITotalExecutionService totalExecutionService;

    /**
     * 主子表一起推送（同时支持总额和明细控时使用）
     * @param executionVO
     * @return
     */
    @PostMapping(value = "aggPush")
    public CommonResponse<String> aggPush(@Valid @RequestBody ExecutionVO executionVO) {
        logger.error("aggPush vo is " + JSONObject.toJSONString(executionVO));
        return  totalExecutionService.aggPush(executionVO);
    }

    /**
     * 主子表一起删除（同时支持总额和明细控时使用）
     * @param totalExecutionVOList
     * @return
     */
    @PostMapping(value = "aggDel")
    public CommonResponse<String> aggDel(@RequestBody List<TotalExecutionVO> totalExecutionVOList) {
        logger.error("aggDel voList is  " + JSONObject.toJSONString(totalExecutionVOList));
        return  totalExecutionService.aggDel(totalExecutionVOList);
    }

    /**
     * 目标成本控制,返回Json
     * @param executionVO
     * @return
     */
    @PostMapping(value = "ctrlJson")
    public CommonResponse<JSONObject> ctrlJson(@Valid @RequestBody ExecutionVO executionVO) {
        return  totalExecutionService.ctrlJson(executionVO);
    }

    /**
     * 目标成本控制,返回checkVO
     * @param executionVO
     * @return
     */
    @PostMapping(value = "ctrlCheckVO")
    public CommonResponse<ParamsCheckVO> ctrlCheckVO(@Valid @RequestBody ExecutionVO executionVO) {
        logger.error("before ctrl " + JSONObject.toJSONString(executionVO));
        CommonResponse<JSONObject>  response =  totalExecutionService.ctrlJson(executionVO);
        logger.error("ctrl result " + JSONObject.toJSONString(response));
        return dealCtrlResult(response, "项目策划控制");
    }

    /**
     * 实际成本控制,返回checkVO
     * @param costCtrlVO
     * @return
     */
    @PostMapping(value = "ctrlCost")
    public CommonResponse<ParamsCheckVO> ctrlCost(@Valid @RequestBody CostCtrlVO costCtrlVO) {
        logger.error("before ctrl " + JSONObject.toJSONString(costCtrlVO));
        CommonResponse<JSONObject>  response =  totalExecutionService.ctrlCost(costCtrlVO);
        logger.error("ctrl result " + JSONObject.toJSONString(response));
        return dealCtrlResult(response, "项目策划成本科目控制");
    }

    private CommonResponse<ParamsCheckVO> dealCtrlResult(CommonResponse<JSONObject> response, String warnItem){
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        if (!response.isSuccess()){
            if(null == response.getData()){
                return CommonResponse.error(response.getMsg());
            }
            JSONObject jsonObject = response.getData();
            Object obj = jsonObject.get(ControlTypeEnum.刚性控制.getCode());
            if (null != obj) {
                String[] strings = obj.toString().split("/n");
                for (String warn : strings) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[2]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(warnItem);
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success("参数校验成功！", paramsCheckVO);
            }

            obj = jsonObject.get(ControlTypeEnum.柔性控制.getCode());
            if (null != obj) {
                String[] strings = obj.toString().split("/n");
                for (String warn : strings) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[1]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(warnItem);
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success("参数校验成功！", paramsCheckVO);
            }
        }else if(null == response.getData()){
            return CommonResponse.success("参数校验成功！", paramsCheckVO);
        }
        paramsCheckVO.setWarnType(paramsArray[0]);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * @Description queryTotalContMny 获取项目的合同总额
     */
    @RequestMapping(value = "queryTotalContMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalContMny(@RequestParam(value = "projectId") Long projectId) {
        QueryWrapper<TotalExecutionEntity> queryWrapper = new QueryWrapper<TotalExecutionEntity>();
        queryWrapper.select("sum(tax_money) as taxMoney");
        queryWrapper.eq("bill_category", BillCategoryEnum.合同.getCode());
        queryWrapper.eq("project_id", projectId);
        TotalExecutionEntity entity = totalExecutionService.getOne(queryWrapper);
        return CommonResponse.success("获取项目的合同总额！", entity.getTaxMoney());
    }
}
