package com.ejianc.business.zhht.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zhht.mapper.ProjectMaterialMapper;
import com.ejianc.business.zhht.bean.ProjectMaterialEntity;
import com.ejianc.business.zhht.service.IProjectMaterialService;

import java.util.List;
import java.util.Map;

/**
 * 项目材料预算
 * 
 * @author generator
 * 
 */
@Service("projectMaterialService")
public class ProjectMaterialServiceImpl extends BaseServiceImpl<ProjectMaterialMapper, ProjectMaterialEntity> implements IProjectMaterialService{

    @Override
    public Boolean checkPartOnly(Long projectId, Long partId, Long id) {
        LambdaQueryWrapper<ProjectMaterialEntity> qw = Wrappers.lambdaQuery();
        qw.eq(ProjectMaterialEntity::getProjectId,projectId)
          .eq(ProjectMaterialEntity::getPartId,partId)
          .eq(ProjectMaterialEntity::getDr, BaseVO.DR_UNDELETE)
          .ne(id!=null,ProjectMaterialEntity::getId, id);
        int count = super.count(qw);
        return count<1;
    }

    @Override
    public List<Map<String,Object>> queryCostAnalyse(Long projectId, Long partId) {
        return baseMapper.queryCostAnalyse(projectId,partId);
    }
}
