package com.ejianc.business.targetcost.enums;

import com.ejianc.framework.core.exception.BusinessException;

import java.util.HashMap;
import java.util.Map;

/**
 * 导入类型
 */
public enum ConversionEnum {

    云南路桥("YN-LQ", "roadbridgeHandler"),
    云南房建("YN-FJ", "buildHandler"),
    中核华泰房建("ZHHT-FJ", "zhhtBuildHandler"),
    陕建房建("SX2J-FJ", "sX2JBuildHandler");

    private String code;
    private String handlerName;

    final static Map<String, ConversionEnum> enumMap = new HashMap<>();

    ConversionEnum(String code, String handlerName){
        this.code = code;
        this.handlerName = handlerName;
    }
    public String getCode() {
        return code;
    }

    public String getHandlerName() {
        return handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    static {
        for(ConversionEnum e : values()) {
            enumMap.put(e.getCode(), e);
        }
    }

    public static String getHandlerNameByCode(String code) {
        if(!enumMap.containsKey(code)) {
            throw new BusinessException("错误的导入类型：" + code);
        }
        return enumMap.get(code).getHandlerName();
    }
}
