package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.api.IConcreteCheckApi;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckDetailVO;
import com.ejianc.business.zhht.bean.ProjectMaterialEntity;
import com.ejianc.business.zhht.service.IProjectMaterialService;
import com.ejianc.business.zhht.vo.ProjectMaterialDetailVO;
import com.ejianc.business.zhht.vo.ProjectMaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目材料预算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectMaterial")
public class ProjectMaterialController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_MATERIAL";//此处需要根据实际修改

    @Autowired
    private IProjectMaterialService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IConcreteCheckApi concreteCheckApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectMaterialVO> saveOrUpdate(@RequestBody ProjectMaterialVO saveOrUpdateVO) {
    	ProjectMaterialEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectMaterialEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (!service.checkPartOnly(entity.getProjectId(),entity.getPartId(),entity.getId())){
    	    throw new BusinessException("该施工部位已存在材料预算单，不能重复新增！");
        }
    	service.saveOrUpdate(entity, false);
    	ProjectMaterialVO vo = BeanMapper.map(entity, ProjectMaterialVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectMaterialVO> queryDetail(@RequestParam Long id,
                                                         @RequestParam(value = "queryActNum",defaultValue = "false") boolean queryActNum) {
    	ProjectMaterialEntity entity = service.selectById(id);
    	ProjectMaterialVO vo = BeanMapper.map(entity, ProjectMaterialVO.class);

        List<ProjectMaterialDetailVO> allDetails = new ArrayList<>();
        if(queryActNum) {
            CommonResponse<List<ConcreteCheckDetailVO>> detailResp = concreteCheckApi.getDetailListByPmId(id);
            if(!detailResp.isSuccess()) {
                return CommonResponse.error("查询清单实际量失败，请重试！");
            }
            if(CollectionUtils.isNotEmpty(detailResp.getData())) {
                List<ConcreteCheckDetailVO> materialVOS = detailResp.getData();
                Map<Long, ConcreteCheckDetailVO> materialMap = new HashMap<>();
                for(ConcreteCheckDetailVO checkDetail : materialVOS) {
                    if(!materialMap.containsKey(checkDetail.getMaterialId())) {
                        materialMap.put(checkDetail.getMaterialId(), checkDetail);
                    } else {
                        materialMap.get(checkDetail.getMaterialId())
                                .setCheckNum(ComputeUtil.safeAdd(checkDetail.getCheckNum(), materialMap.get(checkDetail.getMaterialId()).getCheckNum()));
                    }
                }
                for(ProjectMaterialDetailVO detail : vo.getProjectMaterialDetailList()) {
                    if(null != detail.getMaterialDocId() && materialMap.containsKey(detail.getMaterialDocId())) {
                        detail.setActualNum(materialMap.get(detail.getMaterialDocId()).getCheckNum());
                        materialMap.remove(detail.getMaterialDocId());
                    }
                    allDetails.add(detail);
                }
                if(!materialMap.isEmpty()) {
                    ProjectMaterialDetailVO tmp = null;
                    for(ConcreteCheckDetailVO checkDetailVO : materialMap.values()) {
                        tmp = new ProjectMaterialDetailVO();
                        tmp.setId(checkDetailVO.getId());
                        tmp.setMaterialCategoryId(checkDetailVO.getMaterialTypeId());
                        tmp.setMaterialCategoryName(checkDetailVO.getMaterialTypeName());
                        tmp.setMaterialDocId(checkDetailVO.getMaterialId());
                        tmp.setMaterialDocCode(checkDetailVO.getMaterialCode());
                        tmp.setMaterialDocName(checkDetailVO.getMaterialName());
                        tmp.setMaterialUnitId(checkDetailVO.getUnitId());
                        tmp.setMaterialUnitName(checkDetailVO.getUnit());
                        tmp.setMaterialDocSpec(checkDetailVO.getSpec());
                        tmp.setPlanNum(BigDecimal.ZERO);
                        tmp.setNum(BigDecimal.ZERO);
                        tmp.setActualNum(checkDetailVO.getCheckNum());
                        tmp.setDetailMemo("来源于直入直出单");
                        tmp.setPid(checkDetailVO.getCheckId());
                        allDetails.add(tmp);
                    }
                }

                vo.setProjectMaterialDetailList(allDetails);
            }

        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/checkPartOnly", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkPartOnly(Long projectId,Long partId,Long id) {
        return CommonResponse.success("查询详情数据成功！",service.checkPartOnly(projectId,partId,id));
    }

    @RequestMapping(value = "/queryCostAnalyse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> queryCostAnalyse( @RequestParam(value ="projectId")Long projectId
            ,@RequestParam(value ="partId",required = false)Long partId) {
        return CommonResponse.success("查询详情数据成功！",service.queryCostAnalyse(projectId,partId));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectMaterialVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectMaterialVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectMaterialVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectMaterialVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","constructName","parentOrgName"
                ,"billCode","partName","employeeName","sceneEngineerName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<ProjectMaterialEntity> page = service.queryPage(param,false);
        IPage<ProjectMaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectMaterialVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","constructName","parentOrgName"
                ,"billCode","partName","employeeName","sceneEngineerName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectMaterialEntity> list = service.queryList(param);
        List<ProjectMaterialVO> volist = BeanMapper.mapList(list, ProjectMaterialVO.class);
        volist.stream().forEach(item -> item.setBillStateStr(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription()));
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", volist);
        ExcelExport.getInstance().exportWithTrans("ProjectMaterial-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectMaterialData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectMaterialVO>> refProjectMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        })));
        Long orgId = InvocationInfoProxy.getOrgId();
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("orgId")) {
                orgId = _con.getLong("orgId");
            }
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProjectMaterialEntity> page = service.queryPage(param,false);
        IPage<ProjectMaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectMaterialVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
