/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.TotalExecutionMapper;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDetailExecutionService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.utils.DutyCalcUtil;
import com.ejianc.business.targetcost.utils.PushCalcExecCallable;
import com.ejianc.business.targetcost.utils.ReCalcExec;
import com.ejianc.business.targetcost.utils.ReCalcExecCallable;
import com.ejianc.business.targetcost.utils.SubjectCtrl;
import com.ejianc.business.targetcost.utils.SubjectWarnCallable;
import com.ejianc.business.targetcost.utils.TargetcostCtrl;
import com.ejianc.business.targetcost.utils.TargetcostWarnCallable;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="totalExecutionService")
public class TotalExecutionServiceImpl
extends BaseServiceImpl<TotalExecutionMapper, TotalExecutionEntity>
implements ITotalExecutionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ITotalCacheService totalCacheService;
    @Autowired
    private IDetailCacheService detailCacheService;
    @Lazy
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IDetailExecutionService detailExecutionService;
    @Autowired
    private TargetcostCtrl targetcostCtrl;
    @Autowired
    private SubjectCtrl subjectCtrl;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRuleDetailService ruleDetailService;
    @Autowired
    private IRuleReceiverService ruleReceiverService;
    @Autowired
    private ICostDetailApi costDetailApi;
    private final String CHECK_PARAM = "P-55h7p20112";

    @Override
    public CommonResponse<String> aggPush(ExecutionVO executionVO) {
        String msg = this.checkAgg(executionVO);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        Map<String, List<String>> subCostMap = new DutyCalcUtil(this.paramConfigApi).getSubCostMap();
        List<String> subList = subCostMap.get("subList");
        List<String> unSubList = subCostMap.get("unSubList");
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        TotalExecutionVO dbTotalVO = new TotalExecutionVO();
        ArrayList detailListDb = new ArrayList();
        if (BussinessTypeEnum.\u5206\u5305\u7ed3\u7b97_\u52b3\u52a1\u5206\u5305.getCode().equals(totalExecutionVO.getBussinessType()) || BussinessTypeEnum.\u5206\u5305\u7ed3\u7b97_\u4e13\u4e1a\u5206\u5305.getCode().equals(totalExecutionVO.getBussinessType()) || BussinessTypeEnum.\u5206\u5305\u7ed3\u7b97_\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode().equals(totalExecutionVO.getBussinessType()) || BussinessTypeEnum.\u5206\u5305\u7ed3\u7b97_\u5176\u4ed6\u5206\u5305\u5408\u540c.getCode().equals(totalExecutionVO.getBussinessType())) {
            this.totalFinishSave(totalExecutionVO, subList, true);
            this.detailExecutionService.detailFinishSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, subList, true);
        } else if (totalExecutionVO.getBussinessType().contains("WZCGHT")) {
            dbTotalVO = this.totalContSave(totalExecutionVO, true);
            this.detailExecutionService.detailContSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, true);
        } else {
            dbTotalVO = this.totalSave(totalExecutionVO, true);
            this.detailExecutionService.detailSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, true);
        }
        CommonResponse response = this.paramConfigApi.getByCode("P-55h7p20112");
        if (response.isSuccess() && null != response.getData() && ((ParamRegisterSetVO)response.getData()).getValueData().equals("1")) {
            String authority = (String)RequestContextHolder.getRequestAttributes().getAttribute("authority", 0);
            ExecutorService threadPool = null;
            if (null != dbTotalVO && null != dbTotalVO.getId()) {
                threadPool = Executors.newFixedThreadPool(2);
                DutyEntity dutyEntity = this.beforeReCalc(totalExecutionVO.getProjectId());
                ReCalcExecCallable callable = this.getReCalcExecCallable(dutyEntity, totalExecutionVO.getProjectId(), unSubList);
                threadPool.submit(callable);
                DutyEntity dutyEntityDb = this.beforeReCalc(dbTotalVO.getProjectId());
                ReCalcExecCallable callabledb = this.getReCalcExecCallable(dutyEntityDb, dbTotalVO.getProjectId(), unSubList);
                threadPool.submit(callabledb);
            } else {
                threadPool = Executors.newFixedThreadPool(1);
                DutyEntity dutyEntity = this.beforeReCalc(totalExecutionVO.getProjectId());
                ReCalcExecCallable callable = this.getReCalcExecCallable(dutyEntity, totalExecutionVO.getProjectId(), unSubList);
                threadPool.submit(callable);
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u6267\u884c\u8868\u6210\u529f");
    }

    private TotalExecutionVO totalContSave(TotalExecutionVO totalExecutionVO, boolean isDb) {
        TotalExecutionVO dbTotalVO = null;
        TotalExecutionEntity entity = (TotalExecutionEntity)((Object)BeanMapper.map((Object)totalExecutionVO, TotalExecutionEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, (Object)totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
        TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)this.getOne((Wrapper)queryWrapper));
        if (null != dbEntity) {
            if (dbEntity.getProjectId().compareTo(totalExecutionVO.getProjectId()) != 0) {
                dbTotalVO = (TotalExecutionVO)BeanMapper.map((Object)((Object)dbEntity), TotalExecutionVO.class);
                dbTotalVO.setMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)dbTotalVO.getMoney()));
                dbTotalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)dbTotalVO.getTaxMoney()));
            } else if (!dbEntity.getBussinessType().equals(totalExecutionVO.getBussinessType())) {
                dbTotalVO = (TotalExecutionVO)BeanMapper.map((Object)((Object)dbEntity), TotalExecutionVO.class);
            } else {
                totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            }
            if (isDb) {
                ((TotalExecutionMapper)this.baseMapper).deleteByIdPhy(dbEntity.getId());
            }
        }
        if (!isDb && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0) {
            LambdaQueryWrapper lastQueryWrapper = new LambdaQueryWrapper();
            lastQueryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
            List lastList = this.list((Wrapper)lastQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)lastList)) {
                dbEntity = (TotalExecutionEntity)((Object)lastList.get(0));
                totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            }
        }
        if (isDb) {
            entity.setCostFlag(true);
            this.saveOrUpdate((Object)entity);
        }
        return dbTotalVO;
    }

    private void totalFinishSave(TotalExecutionVO totalExecutionVO, List<String> subList, boolean isDb) {
        TotalExecutionEntity entity = (TotalExecutionEntity)((Object)BeanMapper.map((Object)totalExecutionVO, TotalExecutionEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, (Object)totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
        TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        if (null != dbEntity) {
            totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
            totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            if (isDb) {
                ((TotalExecutionMapper)this.baseMapper).deleteByIdPhy(dbEntity.getId());
            }
        }
        if (isDb) {
            entity.setCostFlag(true);
            this.saveOrUpdate((Object)entity);
        }
        if (null == dbEntity) {
            if (isDb) {
                ArrayList<String> updateCostTypes = new ArrayList<String>();
                switch (totalExecutionVO.getBussinessType()) {
                    case "FBJS-LW": {
                        updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u52b3\u52a1\u5206\u5305.getCode());
                        break;
                    }
                    case "FBJS-ZY": {
                        updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u4e13\u4e1a\u5206\u5305.getCode());
                        break;
                    }
                    case "FBJS-TZSBZL": {
                        updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
                        break;
                    }
                    case "FBJS-QT": {
                        updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u5176\u4ed6\u5206\u5305\u5408\u540c.getCode());
                        break;
                    }
                }
                if (CollectionUtils.isNotEmpty(updateCostTypes)) {
                    this.updateCostFlag(totalExecutionVO.getContractId(), updateCostTypes, false);
                }
            } else {
                LambdaQueryWrapper totalExecQry = new LambdaQueryWrapper();
                totalExecQry.eq(TotalExecutionEntity::getProjectId, (Object)totalExecutionVO.getProjectId());
                totalExecQry.eq(TotalExecutionEntity::getContractId, (Object)totalExecutionVO.getContractId());
                totalExecQry.in(TotalExecutionEntity::getBussinessType, subList);
                List list = this.list((Wrapper)totalExecQry);
                for (TotalExecutionEntity executionEntity : list) {
                    totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)executionEntity.getMoney()));
                    totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)executionEntity.getTaxMoney()));
                }
            }
        }
    }

    @Override
    public CommonResponse<String> aggDel(List<TotalExecutionVO> totalExecutionVOList) {
        HashSet<Long> projSet = new HashSet<Long>();
        for (TotalExecutionVO totalExecutionVO : totalExecutionVOList) {
            if (StringUtils.isBlank((CharSequence)totalExecutionVO.getProperty())) {
                totalExecutionVO.setProperty("1");
            }
            TotalExecutionVO totalExecutionVO1 = this.totalDelete(totalExecutionVO);
            this.detailExecutionService.detailDeleteBatch(totalExecutionVO1);
            projSet.add(totalExecutionVO.getProjectId());
        }
        CommonResponse response = this.paramConfigApi.getByCode("P-55h7p20112");
        if (response.isSuccess() && null != response.getData() && ((ParamRegisterSetVO)response.getData()).getValueData().equals("1")) {
            Map<String, List<String>> subCostMap = new DutyCalcUtil(this.paramConfigApi).getSubCostMap();
            List<String> unSubList = subCostMap.get("unSubList");
            ExecutorService threadPool = Executors.newFixedThreadPool(projSet.size());
            for (Long projectId : projSet) {
                DutyEntity dutyEntity = this.beforeReCalc(projectId);
                ReCalcExecCallable callable = this.getReCalcExecCallable(dutyEntity, projectId, unSubList);
                threadPool.submit(callable);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6267\u884c\u8868\u6210\u529f");
    }

    @Override
    public CommonResponse<String> reCalc(Long projectId) {
        Map<String, List<String>> subCostMap = new DutyCalcUtil(this.paramConfigApi).getSubCostMap();
        List<String> unSubList = subCostMap.get("unSubList");
        this.logger.info("unSubList is " + JSONObject.toJSONString(unSubList));
        DutyEntity dutyEntity = this.beforeReCalc(projectId);
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        ReCalcExecCallable callable = this.getReCalcExecCallable(dutyEntity, projectId, unSubList);
        threadPool.submit(callable);
        return CommonResponse.success((String)"\u91cd\u7b97\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u5237\u65b0\u67e5\u770b\u6570\u636e");
    }

    @Override
    public CommonResponse<JSONObject> ctrlJson(ExecutionVO executionVO) {
        TotalExecutionVO dbTotalVO;
        String msg = this.checkAgg(executionVO);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        List<Object> detailListDb = new ArrayList();
        Map<String, List<String>> subCostMap = new DutyCalcUtil(this.paramConfigApi).getSubCostMap();
        List<String> unSubList = subCostMap.get("unSubList");
        if (unSubList.contains(totalExecutionVO.getBussinessType())) {
            return CommonResponse.success((String)"\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e\uff0c\u8be5\u5206\u5305\u7ed3\u7b97\u5355\u4e0d\u505a\u63a7\u5236\uff01");
        }
        if (totalExecutionVO.getBussinessType().contains("WZCGHT")) {
            dbTotalVO = this.totalContSave(totalExecutionVO, false);
            detailListDb = this.detailExecutionService.detailContSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, false);
        } else {
            dbTotalVO = this.totalSave(totalExecutionVO, false);
            this.detailExecutionService.detailSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, false);
        }
        CommonResponse<JSONObject> result = null;
        this.logger.error("dbTotalVO is " + JSONObject.toJSONString((Object)dbTotalVO));
        if (totalExecutionVO.getBussinessType().contains("WZCGHT") && null != dbTotalVO && null != dbTotalVO.getId() && !totalExecutionVO.getBussinessType().equals(dbTotalVO.getBussinessType())) {
            TotalExecutionVO totalExecutionVO1 = this.totalDelete(dbTotalVO);
            this.detailExecutionService.detailDeleteBatch(totalExecutionVO1);
            DutyEntity dutyEntity = this.beforeReCalc(dbTotalVO.getProjectId());
            ReCalcExec reCalcExec = new ReCalcExec(RequestContextHolder.getRequestAttributes(), dbTotalVO.getProjectId(), dutyEntity, this.redissonClient, this.totalCacheService, this.detailCacheService, this.dutyDetailService, this.dutyDetailItemService, this.feeDetailService, this.feeDetailScopeService, this.totalExecutionService, this.detailExecutionService, unSubList);
            CommonResponse<String> commonResponse = reCalcExec.call();
            if (commonResponse.isSuccess()) {
                result = this.targetcostCtrl.ctrl(executionVO);
                this.saveOrUpdate(BeanMapper.map((Object)dbTotalVO, TotalExecutionEntity.class));
                this.detailExecutionService.saveOrUpdateBatch(detailListDb);
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                ReCalcExecCallable callable = this.getReCalcExecCallable(dutyEntity, dbTotalVO.getProjectId(), unSubList);
                threadPool.submit(callable);
            }
        } else {
            result = this.targetcostCtrl.ctrl(executionVO);
        }
        return result;
    }

    private DutyEntity beforeReCalc(Long projectId) {
        LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
        feeQuery.eq(DutyEntity::getProjectId, (Object)projectId);
        feeQuery.eq(DutyEntity::getEnableState, (Object)true);
        feeQuery.eq(DutyEntity::getGatherFlag, (Object)true);
        return (DutyEntity)((Object)this.dutyService.getOne((Wrapper)feeQuery, false));
    }

    private TotalExecutionVO totalSave(TotalExecutionVO totalExecutionVO, Boolean isDb) {
        TotalExecutionVO dbTotalVO = null;
        TotalExecutionEntity entity = (TotalExecutionEntity)((Object)BeanMapper.map((Object)totalExecutionVO, TotalExecutionEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, (Object)totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)list.get(0));
            if (dbEntity.getProjectId().compareTo(totalExecutionVO.getProjectId()) != 0) {
                dbTotalVO = (TotalExecutionVO)BeanMapper.map((Object)((Object)dbEntity), TotalExecutionVO.class);
                dbTotalVO.setMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)dbTotalVO.getMoney()));
                dbTotalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)dbTotalVO.getTaxMoney()));
            } else {
                totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            }
            if (isDb.booleanValue()) {
                ((TotalExecutionMapper)this.baseMapper).deleteByIdPhy(dbEntity.getId());
            }
        }
        if (!isDb.booleanValue() && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0) {
            LambdaQueryWrapper lastQueryWrapper = new LambdaQueryWrapper();
            lastQueryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
            List lastList = this.list((Wrapper)lastQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)lastList)) {
                TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)lastList.get(0));
                totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            }
        }
        if (isDb.booleanValue()) {
            entity.setCostFlag(true);
            this.saveOrUpdate((Object)entity);
        }
        return dbTotalVO;
    }

    private void updateCostFlag(Long contractId, List<String> bussinessTypeList, Boolean costFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(TotalExecutionEntity::getContractId, (Object)contractId);
        updateWrapper.in(TotalExecutionEntity::getBussinessType, bussinessTypeList);
        updateWrapper.set(TotalExecutionEntity::getCostFlag, (Object)costFlag);
        this.update((Wrapper)updateWrapper);
    }

    private TotalExecutionVO totalDelete(TotalExecutionVO totalExecutionVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, (Object)totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)list.get(0));
            totalExecutionVO = (TotalExecutionVO)BeanMapper.map((Object)((Object)dbEntity), TotalExecutionVO.class);
            totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)totalExecutionVO.getMoney()));
            totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)totalExecutionVO.getTaxMoney()));
            ((TotalExecutionMapper)this.baseMapper).deleteByIdPhy(dbEntity.getId());
            ArrayList<String> updateCostTypes = new ArrayList<String>();
            switch (totalExecutionVO.getBussinessType()) {
                case "FBJS-LW": {
                    updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u52b3\u52a1\u5206\u5305.getCode());
                    break;
                }
                case "FBJS-ZY": {
                    updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u4e13\u4e1a\u5206\u5305.getCode());
                    break;
                }
                case "FBJS-TZSBZL": {
                    updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
                    break;
                }
                case "FBJS-QT": {
                    updateCostTypes.add(BussinessTypeEnum.\u5206\u5305\u4e2d\u95f4\u8ba1\u91cf_\u5176\u4ed6\u5206\u5305\u5408\u540c.getCode());
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(updateCostTypes)) {
                this.updateCostFlag(totalExecutionVO.getContractId(), updateCostTypes, true);
            }
        }
        return totalExecutionVO;
    }

    private String checkAgg(ExecutionVO executionVO) {
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        if (null == totalExecutionVO) {
            return "\u8868\u5934\u5fc5\u4f20";
        }
        if (null == totalExecutionVO.getOrgId()) {
            return "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == totalExecutionVO.getProjectId()) {
            return "\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == totalExecutionVO.getBillCategory()) {
            return "\u5355\u636e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)totalExecutionVO.getBillType())) {
            return "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)totalExecutionVO.getBussinessType())) {
            return "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)totalExecutionVO.getProperty())) {
            totalExecutionVO.setProperty("1");
        }
        if (null == totalExecutionVO.getSourceId()) {
            return "\u6765\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isNotEmpty((Collection)executionVO.getDetailList())) {
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                if (null == detailExecutionVO.getDocType()) {
                    return "\u8868\u4f53\u6863\u6848\uff08\u5206\u7c7b\uff09\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getDocId()) {
                    return "\u6863\u6848ID\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getName()) {
                    return "\u6863\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getCategoryId()) {
                    return "\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getSourceId()) {
                    return "\u6765\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null != detailExecutionVO.getSourceBillId()) continue;
                return "\u6765\u6e90\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        this.fullDetailCategoryInfo(executionVO);
        return null;
    }

    private PushCalcExecCallable getPushCalcExecCallable(String authority, ExecutionVO executionVO) {
        return new PushCalcExecCallable(RequestContextHolder.getRequestAttributes(), authority, executionVO, this.redissonClient, this.totalCacheService, this.detailCacheService, this.dutyService, this.dutyDetailService, this.dutyDetailItemService, this.feeDetailService, this.feeDetailScopeService);
    }

    private ReCalcExecCallable getReCalcExecCallable(DutyEntity dutyEntity, Long projectId, List<String> unSubList) {
        return new ReCalcExecCallable(RequestContextHolder.getRequestAttributes(), projectId, dutyEntity, this.redissonClient, this.totalCacheService, this.detailCacheService, this.dutyDetailService, this.dutyDetailItemService, this.feeDetailService, this.feeDetailScopeService, this.totalExecutionService, this.detailExecutionService, unSubList);
    }

    private TargetcostWarnCallable getTargetcostWarnCallable(List<DutyEntity> dutyEntities, String authority) {
        return new TargetcostWarnCallable(authority, RequestContextHolder.getRequestAttributes(), this.warnCenterApi, this.redissonClient, this.totalCacheService, this.detailCacheService, dutyEntities, this.ruleService, this.ruleDetailService, this.ruleReceiverService, this.feeDetailService, this.feeDetailScopeService);
    }

    private void fullDetailCategoryInfo(ExecutionVO executionVO) {
        if (CollectionUtils.isNotEmpty((Collection)executionVO.getDetailList())) {
            ArrayList categoryList = new ArrayList();
            HashMap docCategoryIdMap = new HashMap();
            HashMap materialCategoryMap = new HashMap();
            HashMap equipCategoryMap = new HashMap();
            HashMap proSubCategoryMap = new HashMap();
            HashMap labSubCategoryMap = new HashMap();
            HashMap subjectOrgMap = new HashMap();
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                if (!docCategoryIdMap.containsKey(detailExecutionVO.getDocType())) {
                    docCategoryIdMap.put(detailExecutionVO.getDocType(), new ArrayList());
                }
                ((List)docCategoryIdMap.get(detailExecutionVO.getDocType())).add(detailExecutionVO.getCategoryId());
            }
            this.logger.error("docCategoryIdMap11111111++++++++++++-------" + JSONObject.toJSONString(docCategoryIdMap));
            for (Integer docType : docCategoryIdMap.keySet()) {
                switch (docType) {
                    case 1: 
                    case 7: {
                        this.logger.error("docCategoryIdMap++++++++++++-------" + JSONObject.toJSONString(docCategoryIdMap));
                        CommonResponse lresponse = this.shareLabsubApi.getCategoryListByIds((List)docCategoryIdMap.get(docType));
                        if (!lresponse.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)lresponse.getData()))) break;
                        labSubCategoryMap.putAll(((List)lresponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1)));
                        this.logger.info("labSubCategoryMap++++++++++++-------" + JSONObject.toJSONString(labSubCategoryMap));
                        break;
                    }
                    case 2: {
                        CommonResponse presponse = this.shareProsubApi.queryCategoryListByIds((List)docCategoryIdMap.get(docType));
                        if (!presponse.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)presponse.getData()))) break;
                        proSubCategoryMap.putAll(((List)presponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1)));
                        break;
                    }
                    case 3: {
                        CommonResponse mresponse = this.shareMaterialApi.queryCategoryListByIds((List)docCategoryIdMap.get(docType));
                        if (!mresponse.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)mresponse.getData()))) break;
                        materialCategoryMap.putAll(((List)mresponse.getData()).stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key1)));
                        break;
                    }
                    case 4: {
                        CommonResponse eresponse = this.shareEquipmentApi.queryCategoryListByIds((List)docCategoryIdMap.get(docType));
                        if (!eresponse.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)eresponse.getData()))) break;
                        equipCategoryMap.putAll(((List)eresponse.getData()).stream().collect(Collectors.toMap(EquipmentCategoryVO::getId, Function.identity(), (key1, key2) -> key1)));
                        break;
                    }
                    case 5: {
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("id", new Parameter("in", docCategoryIdMap.get(docType)));
                        CommonResponse sresponse = this.shareSubjectOrgApi.querySubjectOrg(queryParam);
                        if (!sresponse.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)sresponse.getData()))) break;
                        subjectOrgMap.putAll(((List)sresponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1)));
                        break;
                    }
                }
            }
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                MaterialCategoryVO categoryVO;
                if (DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(detailExecutionVO.getDocType())) {
                    if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                    categoryVO = (MaterialCategoryVO)materialCategoryMap.get(detailExecutionVO.getCategoryId());
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    detailExecutionVO.setCategoryName(categoryVO.getName());
                    detailExecutionVO.setUnitId(categoryVO.getUnitId());
                    detailExecutionVO.setUnitName(categoryVO.getUnitName());
                    continue;
                }
                if (DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode().equals(detailExecutionVO.getDocType())) {
                    if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                    categoryVO = (EquipmentCategoryVO)equipCategoryMap.get(detailExecutionVO.getCategoryId());
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    detailExecutionVO.setCategoryName(categoryVO.getName());
                    continue;
                }
                if (DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode().equals(detailExecutionVO.getDocType())) {
                    if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                    categoryVO = (ProsubCategoryVO)proSubCategoryMap.get(detailExecutionVO.getCategoryId());
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                    detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    continue;
                }
                if (DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(detailExecutionVO.getDocType())) {
                    if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                    categoryVO = (LabsubCategoryVO)labSubCategoryMap.get(detailExecutionVO.getCategoryId());
                    this.logger.error("categoryVO++++++++++++-------" + JSONObject.toJSONString((Object)categoryVO));
                    this.logger.error("detailExecutionVO.getCategoryId()" + detailExecutionVO.getCategoryId());
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                    detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    continue;
                }
                if (!DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(detailExecutionVO.getDocType()) || !StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                categoryVO = (SubjectOrgVO)subjectOrgMap.get(detailExecutionVO.getCategoryId());
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getSubjectCode());
                detailExecutionVO.setCategoryName(categoryVO.getSubjectName());
            }
        }
    }

    @Override
    public CommonResponse<String> ctrlWarn(HttpServletRequest request) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getEnableState, (Object)1);
        queryWrapper.eq(DutyEntity::getGatherFlag, (Object)true);
        List dutyEntities = this.dutyService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)dutyEntities)) {
            for (DutyEntity dutyEntity : dutyEntities) {
                CommonResponse parents = this.orgApi.findParentsByOrgId(dutyEntity.getOrgId());
                if (!parents.isSuccess() || parents.getData() == null || ((List)parents.getData()).size() <= 0) continue;
                dutyEntity.setOrgList((List)parents.getData());
            }
            ExecutorService threadPool = Executors.newFixedThreadPool(2);
            TargetcostWarnCallable targetcostWarnCallable = this.getTargetcostWarnCallable(dutyEntities, request.getHeader("authority"));
            threadPool.submit(targetcostWarnCallable);
            Callable<CommonResponse<String>> subjectWarnCallable = this.getSubjectWarnCallable(dutyEntities, request.getHeader("authority"));
            threadPool.submit(subjectWarnCallable);
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u9884\u8b66\u6210\u529f");
    }

    private Callable<CommonResponse<String>> getSubjectWarnCallable(List<DutyEntity> dutyEntities, String authority) {
        return new SubjectWarnCallable(authority, RequestContextHolder.getRequestAttributes(), this.warnCenterApi, this.redissonClient, this.dutyDetailItemService, dutyEntities, this.ruleService, this.ruleDetailService, this.ruleReceiverService, this.costDetailApi, this.shareSubjectOrgApi);
    }

    @Override
    public CommonResponse<JSONObject> ctrlCost(CostCtrlVO costCtrlVO) {
        if (CollectionUtils.isEmpty((Collection)costCtrlVO.getDetailList())) {
            return CommonResponse.success((String)"\u4fdd\u5b58\u524d\u6210\u672c\u79d1\u76ee\u63a7\u5236\u901a\u8fc7");
        }
        this.fullDetailSubjectInfo(costCtrlVO);
        return this.subjectCtrl.ctrlCost(costCtrlVO);
    }

    private void fullDetailSubjectInfo(CostCtrlVO costCtrlVO) {
        List subjectIdList = costCtrlVO.getDetailList().stream().map(CostCtrlDetailVO::getSubjectId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", subjectIdList));
        CommonResponse response = this.shareSubjectOrgApi.querySubjectOrg(queryParam);
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List subjectOrgVOS = (List)response.getData();
            Map map = subjectOrgVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
            for (CostCtrlDetailVO detailVO : costCtrlVO.getDetailList()) {
                SubjectOrgVO subjectOrgVO = (SubjectOrgVO)map.get(detailVO.getSubjectId());
                detailVO.setSubjectCode(subjectOrgVO.getSubjectCode());
                detailVO.setSubjectName(subjectOrgVO.getSubjectName());
            }
        }
    }

    public List<List<DutyEntity>> averageAssign(List<DutyEntity> source, int n) {
        ArrayList<List<DutyEntity>> result = new ArrayList<List<DutyEntity>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<DutyEntity> value;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }
}

