/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SubjectCtrl {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRuleDetailService ruleDetailService;
    @Autowired
    private RedissonClient redissonClient;
    @Lazy
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    private static final String TC_LOCK = "TC_LOCK::";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<JSONObject> ctrlCost(CostCtrlVO costCtrlVO) {
        JSONObject jsonObject = new JSONObject();
        String lockKey = TC_LOCK + costCtrlVO.getProjectId();
        RLock mylock = this.redissonClient.getLock(lockKey);
        try {
            CommonResponse commonResponse;
            DutyDetailItemVO dutyDetailItemVO;
            CostDetailVO costDetailVO;
            Long subjectId;
            String innerCode;
            Object orgList;
            boolean lock = mylock.tryLock(5L, TimeUnit.SECONDS);
            if (!lock) {
                CommonResponse commonResponse2 = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + costCtrlVO.getProjectId()));
                return commonResponse2;
            }
            LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
            feeQuery.eq(DutyEntity::getProjectId, (Object)costCtrlVO.getProjectId());
            feeQuery.eq(DutyEntity::getEnableState, (Object)true);
            feeQuery.eq(DutyEntity::getGatherFlag, (Object)true);
            DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.getOne((Wrapper)feeQuery));
            if (null == dutyEntity) {
                CommonResponse commonResponse3 = CommonResponse.success((String)"\u8be5\u9879\u76ee\u8fd8\u6ca1\u7f16\u5236\u76ee\u6807\u6210\u672c");
                return commonResponse3;
            }
            CommonResponse parents = this.orgApi.findParentsByOrgId(costCtrlVO.getOrgId());
            HashSet<Long> ruleIdSet = new HashSet<Long>();
            List ruleEntities = null;
            HashMap<Long, CommonResponse> ruleMap = new HashMap<Long, CommonResponse>();
            if (parents.isSuccess() && parents.getData() != null && ((List)parents.getData()).size() > 0) {
                orgList = ((List)parents.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(RuleEntity::getFeeId, (Object)dutyEntity.getFeeId());
                ArrayList<Integer> billStatusList = new ArrayList<Integer>();
                billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                queryWrapper.eq(RuleEntity::getEnabled, (Object)1);
                queryWrapper.in(RuleEntity::getBillState, billStatusList);
                queryWrapper.in(RuleEntity::getOrgId, (Collection)orgList);
                ruleEntities = this.ruleService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)ruleEntities)) {
                    for (Object ruleEntity : ruleEntities) {
                        ruleIdSet.add(ruleEntity.getId());
                        ruleMap.put(ruleEntity.getId(), (CommonResponse)ruleEntity);
                    }
                }
            }
            if (CollectionUtils.isEmpty(ruleIdSet)) {
                orgList = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u89c4\u5219");
                return orgList;
            }
            List<Long> longList = costCtrlVO.getDetailList().stream().map(CostCtrlDetailVO::getSubjectId).collect(Collectors.toList());
            Map<Long, String> subjectMap = this.getSubjectMap(longList);
            LambdaQueryWrapper ruleDetailQuery = new LambdaQueryWrapper();
            ruleDetailQuery.eq(RuleDetailEntity::getSubjectFlag, (Object)true);
            ruleDetailQuery.in(RuleDetailEntity::getRuleId, new ArrayList(ruleIdSet));
            List ruleDetailList = this.ruleDetailService.list((Wrapper)ruleDetailQuery);
            if (CollectionUtils.isEmpty((Collection)ruleDetailList)) {
                Object ruleEntity;
                ruleEntity = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u6210\u672c\u79d1\u76ee\u63a7\u5236\u89c4\u5219");
                return ruleEntity;
            }
            ArrayList<RuleDetailEntity> ruleDetailEntities = new ArrayList<RuleDetailEntity>();
            HashSet<Long> costQuerySet = new HashSet<Long>();
            for (Long subjectId2 : longList) {
                String innerCode2 = subjectMap.get(subjectId2);
                for (Object ruleDetailEntity : ruleDetailList) {
                    if (!StringUtils.isNotBlank((CharSequence)innerCode2) || !innerCode2.contains(String.valueOf(((RuleDetailEntity)((Object)ruleDetailEntity)).getSubjectId()))) continue;
                    ruleDetailEntities.add((RuleDetailEntity)((Object)ruleDetailEntity));
                    costQuerySet.add(((RuleDetailEntity)((Object)ruleDetailEntity)).getSubjectId());
                }
            }
            if (CollectionUtils.isEmpty(ruleDetailEntities)) {
                CommonResponse commonResponse4 = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u6240\u5305\u542b\u7684\u6210\u672c\u79d1\u76ee\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u89c4\u5219");
                return commonResponse4;
            }
            CommonResponse listCommonResponse = this.costDetailApi.queryDetailByProjectId(costCtrlVO.getSourceId(), costCtrlVO.getProjectId(), new ArrayList(costQuerySet));
            Map<Object, Object> costMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                costMap = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(CostDetailVO::getSubjectId, Function.identity(), (key1, key2) -> key1));
            }
            HashMap<Long, RuleDetailEntity> gxMap = new HashMap<Long, RuleDetailEntity>();
            HashMap<Long, RuleDetailEntity> rxMap = new HashMap<Long, RuleDetailEntity>();
            for (RuleDetailEntity entity : ruleDetailEntities) {
                RuleDetailEntity controlScale;
                Long key;
                if (ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode().equals(entity.getControlType())) {
                    key = entity.getSubjectId();
                    controlScale = null;
                    controlScale = gxMap.containsKey(key) ? (ComputeUtil.isLessThan((BigDecimal)((RuleDetailEntity)((Object)gxMap.get(key))).getControlScale(), (BigDecimal)entity.getControlScale()) ? (RuleDetailEntity)((Object)gxMap.get(key)) : entity) : entity;
                    controlScale.setOrgName(((RuleEntity)((Object)ruleMap.get(controlScale.getRuleId()))).getOrgName());
                    gxMap.put(key, controlScale);
                    continue;
                }
                if (!ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode().equals(entity.getControlType())) continue;
                key = entity.getSubjectId();
                controlScale = null;
                controlScale = rxMap.containsKey(key) ? (ComputeUtil.isLessThan((BigDecimal)((RuleDetailEntity)((Object)rxMap.get(key))).getControlScale(), (BigDecimal)entity.getControlScale()) ? (RuleDetailEntity)((Object)rxMap.get(key)) : entity) : entity;
                controlScale.setOrgName(((RuleEntity)((Object)ruleMap.get(controlScale.getRuleId()))).getOrgName());
                rxMap.put(key, controlScale);
            }
            HashMap<Long, DutyDetailItemVO> dutyCostMap = new HashMap<Long, DutyDetailItemVO>();
            StringBuffer msg = new StringBuffer();
            for (CostCtrlDetailVO detailVO : costCtrlVO.getDetailList()) {
                innerCode = subjectMap.get(detailVO.getSubjectId());
                for (Long key : gxMap.keySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)innerCode) || !innerCode.contains(String.valueOf(key))) continue;
                    subjectId = ((RuleDetailEntity)((Object)gxMap.get(key))).getSubjectId();
                    CostDetailVO costDetailVO2 = costDetailVO = costMap.containsKey(subjectId) ? (CostDetailVO)costMap.get(subjectId) : new CostDetailVO();
                    if (dutyCostMap.containsKey(subjectId)) {
                        dutyDetailItemVO = (DutyDetailItemVO)((Object)dutyCostMap.get(subjectId));
                    } else {
                        dutyDetailItemVO = this.dutyDetailItemService.queryCostMnyBySubjectId(costCtrlVO.getProjectId(), subjectId);
                        dutyCostMap.put(subjectId, dutyDetailItemVO);
                    }
                    msg.append(this.ctrlCost((RuleDetailEntity)((Object)gxMap.get(key)), costDetailVO, dutyDetailItemVO, detailVO, ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                jsonObject.put(String.valueOf(ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode()), (Object)msg);
                commonResponse = CommonResponse.error((String)"\u63a7\u5236\u4e0d\u901a\u8fc7", (Object)jsonObject);
                return commonResponse;
            }
            for (CostCtrlDetailVO detailVO : costCtrlVO.getDetailList()) {
                innerCode = subjectMap.get(detailVO.getSubjectId());
                for (Long key : rxMap.keySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)innerCode) || !innerCode.contains(String.valueOf(key))) continue;
                    subjectId = ((RuleDetailEntity)((Object)rxMap.get(key))).getSubjectId();
                    CostDetailVO costDetailVO3 = costDetailVO = costMap.containsKey(subjectId) ? (CostDetailVO)costMap.get(subjectId) : new CostDetailVO();
                    if (dutyCostMap.containsKey(subjectId)) {
                        dutyDetailItemVO = (DutyDetailItemVO)((Object)dutyCostMap.get(subjectId));
                    } else {
                        dutyDetailItemVO = this.dutyDetailItemService.queryCostMnyBySubjectId(costCtrlVO.getProjectId(), subjectId);
                        dutyCostMap.put(subjectId, dutyDetailItemVO);
                    }
                    msg.append(this.ctrlCost((RuleDetailEntity)((Object)rxMap.get(key)), costDetailVO, dutyDetailItemVO, detailVO, ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                jsonObject.put(String.valueOf(ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode()), (Object)msg);
                commonResponse = CommonResponse.error((String)"\u63a7\u5236\u4e0d\u901a\u8fc7", (Object)jsonObject);
                return commonResponse;
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u524d\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
        }
        finally {
            mylock.unlock();
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u524d\u6210\u672c\u79d1\u76ee\u63a7\u5236\u901a\u8fc7");
    }

    private String ctrlCost(RuleDetailEntity ruleDetailEntity, CostDetailVO costDetailVO, DutyDetailItemVO detailItemVO, CostCtrlDetailVO ctrlDetailVO, Integer controlType) {
        BigDecimal comTaxScale;
        StringBuffer msg = new StringBuffer();
        BigDecimal taxMny = null != detailItemVO.getTaxMny() ? detailItemVO.getTaxMny() : BigDecimal.ZERO;
        BigDecimal comTaxMny = ComputeUtil.safeAdd((BigDecimal)costDetailVO.getHappenTaxMny(), (BigDecimal)ctrlDetailVO.getTaxMny());
        BigDecimal controlScale = ruleDetailEntity.getControlScale();
        if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)(comTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)comTaxMny, (BigDecimal)taxMny), (BigDecimal)BigDecimal.valueOf(100L)))) || null == detailItemVO.getTaxMny()) {
            msg.append(costDetailVO.getSubjectName()).append("\u603b\u989d\u63a7").append("&");
            msg.append(ruleDetailEntity.getOrgName()).append("&");
            StringBuffer tmpMsg = new StringBuffer();
            tmpMsg.append(costDetailVO.getSubjectName()).append("\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)comTaxMny, (int)2)).append("\u5143)\u5df2\u5360\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6210\u672c\u79d1\u76ee\u91d1\u989d");
            tmpMsg.append("(").append(ComputeUtil.scale((BigDecimal)taxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comTaxScale, (int)2)).append("%");
            msg.append(this.getBaseMsg(tmpMsg.toString(), controlType));
        }
        return msg.toString();
    }

    private String getBaseMsg(String midMsg, Integer controlType) {
        StringBuffer msg = new StringBuffer();
        if (ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\u521a\u6027\uff1a");
        } else if (ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\u67d4\u6027\uff1a");
        }
        msg.append(midMsg);
        if (ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01/n");
        } else if (ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\uff01/n");
        }
        return msg.toString();
    }

    private Map<Long, String> getSubjectMap(List<Long> subjectIdList) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", subjectIdList));
        CommonResponse response = this.shareSubjectOrgApi.querySubjectOrg(queryParam);
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List subjectOrgVOS = (List)response.getData();
            return subjectOrgVOS.stream().collect(Collectors.toMap(BaseVO::getId, SubjectOrgVO::getInnerCode, (key1, key2) -> key1));
        }
        return new HashMap<Long, String>();
    }
}

