/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.FeeTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.utils.DutyCalcUtil;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TargetcostCtrl {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRuleDetailService ruleDetailService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ITotalCacheService totalCacheService;
    @Autowired
    private IDetailCacheService detailCacheService;
    @Lazy
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    private static final String TC_LOCK = "TC_LOCK::";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<JSONObject> ctrl(ExecutionVO executionVO) {
        JSONObject jsonObject = new JSONObject();
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        String lockKey = TC_LOCK + totalExecutionVO.getProjectId();
        RLock mylock = this.redissonClient.getLock(lockKey);
        try {
            CommonResponse commonResponse;
            String key;
            Object orgList;
            boolean lock = mylock.tryLock(5L, TimeUnit.SECONDS);
            if (!lock) {
                CommonResponse commonResponse2 = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + totalExecutionVO.getProjectId()));
                return commonResponse2;
            }
            LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
            feeQuery.eq(DutyEntity::getProjectId, (Object)totalExecutionVO.getProjectId());
            feeQuery.eq(DutyEntity::getEnableState, (Object)true);
            feeQuery.eq(DutyEntity::getGatherFlag, (Object)true);
            List dutyEntities = this.dutyService.list((Wrapper)feeQuery);
            if (CollectionUtils.isEmpty((Collection)dutyEntities)) {
                CommonResponse commonResponse3 = CommonResponse.success((String)"\u8be5\u9879\u76ee\u8fd8\u6ca1\u7f16\u5236\u76ee\u6807\u6210\u672c");
                return commonResponse3;
            }
            DutyEntity dutyEntity = (DutyEntity)((Object)dutyEntities.get(0));
            CommonResponse parents = this.orgApi.findParentsByOrgId(totalExecutionVO.getOrgId());
            HashSet<Long> ruleIdSet = new HashSet<Long>();
            List ruleEntities = null;
            HashMap<Long, RuleEntity> ruleMap = new HashMap<Long, RuleEntity>();
            if (parents.isSuccess() && parents.getData() != null && ((List)parents.getData()).size() > 0) {
                orgList = ((List)parents.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(RuleEntity::getFeeId, (Object)dutyEntity.getFeeId());
                ArrayList<Integer> billStatusList = new ArrayList<Integer>();
                billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                queryWrapper.eq(RuleEntity::getEnabled, (Object)1);
                queryWrapper.in(RuleEntity::getBillState, billStatusList);
                queryWrapper.in(RuleEntity::getOrgId, (Collection)orgList);
                ruleEntities = this.ruleService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)ruleEntities)) {
                    for (Object ruleEntity : ruleEntities) {
                        ruleIdSet.add(ruleEntity.getId());
                        ruleMap.put(ruleEntity.getId(), (RuleEntity)((Object)ruleEntity));
                    }
                }
            }
            if (CollectionUtils.isEmpty(ruleIdSet)) {
                orgList = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u89c4\u5219");
                return orgList;
            }
            LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
            scopeQuery.eq(FeeDetailScopeEntity::getFeeId, (Object)dutyEntity.getFeeId());
            scopeQuery.eq(FeeDetailScopeEntity::getBillCode, (Object)totalExecutionVO.getBussinessType());
            scopeQuery.eq(FeeDetailScopeEntity::getPropertyValue, (Object)totalExecutionVO.getProperty());
            List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
            ArrayList<Long> feeDetailPks = new ArrayList<Long>();
            HashMap<String, String> scopeMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
                for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                    feeDetailPks.add(scopeEntity.getFeeDetailId());
                    scopeMap.put(scopeEntity.getBillCode(), scopeEntity.getMemoValue());
                }
            }
            if (CollectionUtils.isEmpty(feeDetailPks)) {
                Object ruleEntity;
                ruleEntity = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u660e\u7ec6");
                return ruleEntity;
            }
            HashMap<String, List<RuleDetailEntity>> ruleDetailMap = new HashMap<String, List<RuleDetailEntity>>();
            LambdaQueryWrapper ruleDetailQuery = new LambdaQueryWrapper();
            ruleDetailQuery.eq(RuleDetailEntity::getSubjectFlag, (Object)false);
            ruleDetailQuery.in(RuleDetailEntity::getRuleId, ruleIdSet);
            ruleDetailQuery.and(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(RuleDetailEntity::getBillCategory)).or()).like(RuleDetailEntity::getBillCategory, (Object)totalExecutionVO.getBillCategory()));
            List ruleDetailEntities = this.ruleDetailService.list((Wrapper)ruleDetailQuery);
            for (RuleDetailEntity entity : ruleDetailEntities) {
                key = entity.getFeeInnerCode();
                List<RuleDetailEntity> list = ruleDetailMap.containsKey(key) ? (List)ruleDetailMap.get(key) : new ArrayList();
                list.add(entity);
                ruleDetailMap.put(key, list);
            }
            List<DetailCacheEntity> detailCacheEntities = this.cacheDetails(dutyEntity, executionVO, feeDetailPks);
            List<TotalCacheEntity> totalCacheEntities = this.cacheTotal(dutyEntity, executionVO, feeDetailPks, detailCacheEntities);
            if (CollectionUtils.isEmpty(detailCacheEntities) && CollectionUtils.isEmpty(totalCacheEntities)) {
                key = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u672a\u5173\u8054\u5230\u9879\u76ee\u7b56\u5212\u6570\u636e");
                return key;
            }
            String msg = this.ctrl(detailCacheEntities, totalCacheEntities, scopeMap, executionVO, totalExecutionVO, ruleMap, ruleDetailMap, ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode());
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                jsonObject.put(String.valueOf(ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode()), (Object)msg);
                commonResponse = CommonResponse.error((String)"\u63a7\u5236\u4e0d\u901a\u8fc7", (Object)jsonObject);
                return commonResponse;
            }
            msg = this.ctrl(detailCacheEntities, totalCacheEntities, scopeMap, executionVO, totalExecutionVO, ruleMap, ruleDetailMap, ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode());
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                jsonObject.put(String.valueOf(ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode()), (Object)msg);
                commonResponse = CommonResponse.error((String)"\u63a7\u5236\u4e0d\u901a\u8fc7", (Object)jsonObject);
                return commonResponse;
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u524d\u76ee\u6807\u6210\u672c\u63a7\u5236\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
        }
        finally {
            mylock.unlock();
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u524d\u9879\u76ee\u7b56\u5212\u63a7\u5236\u901a\u8fc7");
    }

    private String ctrl(List<DetailCacheEntity> detailCacheEntities, List<TotalCacheEntity> totalCacheEntities, Map<String, String> scopeMap, ExecutionVO executionVO, TotalExecutionVO totalExecutionVO, Map<Long, RuleEntity> ruleMainMap, Map<String, List<RuleDetailEntity>> ruleDetailMap, Integer controlType) {
        Long feeDetailId;
        String ctrlAll = scopeMap.get(totalExecutionVO.getBussinessType());
        HashSet<Long> feeDetailPkSet = new HashSet<Long>();
        for (TotalCacheEntity cacheEntity : totalCacheEntities) {
            feeDetailPkSet.add(cacheEntity.getFeeDetailId());
        }
        for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
            feeDetailPkSet.add(detailCacheEntity.getFeeDetailId());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, feeDetailPkSet);
        List feeDetalilist = this.feeDetailService.list((Wrapper)queryWrapper);
        Map<Long, String> innerCodeMap = feeDetalilist.stream().collect(Collectors.toMap(BaseEntity::getId, FeeDetailEntity::getInnerCode, (key1, key2) -> key1));
        StringBuffer msg = new StringBuffer();
        HashMap detailCacheMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)executionVO.getDetailList())) {
            for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
                feeDetailId = detailCacheEntity.getFeeDetailId();
                List<RuleDetailEntity> ruleDetailEntityList = this.getRuleDetailList(ruleDetailMap, innerCodeMap.get(feeDetailId), ctrlAll);
                if (!CollectionUtils.isNotEmpty(ruleDetailEntityList)) continue;
                List<Map<Integer, RuleDetailEntity>> ruleList = this.splitToMap(ruleDetailEntityList, controlType, ruleMainMap);
                Map<Integer, RuleDetailEntity> ruleNullMap = ruleList.get(0);
                msg.append(this.detailCtrl(ruleNullMap, detailCacheEntity, totalExecutionVO, controlType));
                Long key = detailCacheEntity.getFeeDetailId();
                List<DetailCacheEntity> list = detailCacheMap.containsKey(key) ? (List)detailCacheMap.get(key) : new ArrayList();
                list.add(detailCacheEntity);
                detailCacheMap.put(key, list);
            }
        }
        for (TotalCacheEntity cacheEntity : totalCacheEntities) {
            feeDetailId = cacheEntity.getFeeDetailId();
            List detailCacheEntityList = (List)detailCacheMap.get(feeDetailId);
            List<RuleDetailEntity> ruleDetailEntityList = this.getRuleDetailList(ruleDetailMap, innerCodeMap.get(feeDetailId), ctrlAll);
            if (!CollectionUtils.isNotEmpty(ruleDetailEntityList)) continue;
            List<Map<Integer, RuleDetailEntity>> ruleList = this.splitToMap(ruleDetailEntityList, controlType, ruleMainMap);
            Map<Integer, RuleDetailEntity> ruleMap = ruleList.get(0);
            msg.append(this.totalCtrl(scopeMap, ruleMap, false, cacheEntity, executionVO, detailCacheEntityList, controlType));
            Map<Integer, RuleDetailEntity> ruleNullMap = ruleList.get(1);
            msg.append(this.totalCtrl(scopeMap, ruleNullMap, true, cacheEntity, executionVO, detailCacheEntityList, controlType));
        }
        return msg.toString();
    }

    private List<RuleDetailEntity> getRuleDetailList(Map<String, List<RuleDetailEntity>> ruleDetailMap, String innerCode, String ctrlAll) {
        ArrayList<RuleDetailEntity> list = new ArrayList<RuleDetailEntity>();
        for (String key : ruleDetailMap.keySet()) {
            if (!innerCode.contains(key)) continue;
            List<RuleDetailEntity> ruleDetailEntities = ruleDetailMap.get(key);
            if (key.equals(innerCode)) {
                for (RuleDetailEntity detailEntity : ruleDetailEntities) {
                    if (!ctrlAll.contains(String.valueOf(detailEntity.getFeeType()))) continue;
                    list.add(detailEntity);
                }
                continue;
            }
            for (RuleDetailEntity detailEntity : ruleDetailEntities) {
                if (!FeeTypeEnum.\u660e\u7ec6\u91cf\u63a7.getCode().equals(detailEntity.getFeeType()) && !FeeTypeEnum.\u660e\u7ec6\u91d1\u989d\u63a7.getCode().equals(detailEntity.getFeeType()) && !FeeTypeEnum.\u660e\u7ec6\u79df\u8d41\u65f6\u95f4\u63a7.getCode().equals(detailEntity.getFeeType()) || !ctrlAll.contains(String.valueOf(detailEntity.getFeeType()))) continue;
                list.add(detailEntity);
            }
        }
        return list;
    }

    private String detailCtrl(Map<Integer, RuleDetailEntity> ruleMap, DetailCacheEntity detailCacheEntity, TotalExecutionVO totalExecutionVO, Integer controlType) {
        String docTypeName;
        StringBuffer msg = new StringBuffer();
        BigDecimal num = detailCacheEntity.getAmount();
        BigDecimal taxMny = detailCacheEntity.getTaxMny();
        String string = docTypeName = DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.equals((Object)detailCacheEntity.getDocType()) || DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.equals((Object)detailCacheEntity.getDocType()) ? "\u6e05\u5355" : "\u6863\u6848";
        if (!ruleMap.isEmpty()) {
            for (Integer key : ruleMap.keySet()) {
                BigDecimal comScale;
                StringBuffer tmpMsg;
                BigDecimal comNum = null;
                BigDecimal comTaxMny = null;
                BigDecimal controlScale = ruleMap.get(key).getControlScale();
                if (FeeTypeEnum.\u660e\u7ec6\u91d1\u989d\u63a7.getCode().equals(key)) {
                    BigDecimal comTaxScale;
                    if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = detailCacheEntity.getPlanTaxMoney();
                    } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = detailCacheEntity.getContTaxMoney();
                    } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = detailCacheEntity.getStoreTaxMoney();
                    } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = detailCacheEntity.getOtherTaxMoney();
                    } else if (BillCategoryEnum.\u7ed3\u7b97.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = detailCacheEntity.getSettleTaxMoney();
                    }
                    if (!ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)(comTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)comTaxMny, (BigDecimal)taxMny), (BigDecimal)BigDecimal.valueOf(100L))))) continue;
                    msg.append(detailCacheEntity.getName()).append("\u660e\u7ec6\u91d1\u989d\u63a7").append("&");
                    msg.append(ruleMap.get(key).getOrgName()).append("&");
                    tmpMsg = new StringBuffer();
                    tmpMsg.append(detailCacheEntity.getName());
                    if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                        tmpMsg.append(detailCacheEntity.getModel());
                    }
                    tmpMsg.append("\u603b\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)comTaxMny, (int)2)).append("\u5143)\u5df2\u5360\u7528\u9879\u76ee\u7b56\u5212\u4e2d\u8be5" + docTypeName + "\u91d1\u989d");
                    tmpMsg.append("(").append(ComputeUtil.scale((BigDecimal)taxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comTaxScale, (int)2)).append("%");
                    msg.append(this.getBaseMsg(tmpMsg.toString(), controlType));
                    continue;
                }
                if (!FeeTypeEnum.\u660e\u7ec6\u91cf\u63a7.getCode().equals(key)) continue;
                if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                    comNum = ComputeUtil.safeAdd(comNum, (BigDecimal)detailCacheEntity.getPlanNum());
                } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                    comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getContNum());
                } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                    comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getStoreNum());
                } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                    comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getOtherNum());
                } else if (BillCategoryEnum.\u7ed3\u7b97.getCode().equals(totalExecutionVO.getBillCategory())) {
                    comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getSettleNum());
                }
                if (!ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)(comScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)comNum, (BigDecimal)num), (BigDecimal)BigDecimal.valueOf(100L))))) continue;
                msg.append(detailCacheEntity.getName()).append("\u660e\u7ec6\u91cf\u63a7").append("&");
                msg.append(ruleMap.get(key).getOrgName()).append("&");
                tmpMsg = new StringBuffer();
                tmpMsg.append(detailCacheEntity.getName());
                if (StringUtils.isNotBlank((CharSequence)detailCacheEntity.getModel())) {
                    tmpMsg.append(detailCacheEntity.getModel());
                }
                tmpMsg.append("\u603b\u6570\u91cf(").append(ComputeUtil.scale((BigDecimal)comNum, (int)4)).append(")\u5df2\u5360\u7528\u9879\u76ee\u7b56\u5212\u4e2d\u8be5" + docTypeName + "\u6570\u91cf");
                tmpMsg.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)4)).append(")").append(ComputeUtil.scale((BigDecimal)comScale, (int)2)).append("%");
                msg.append(this.getBaseMsg(tmpMsg.toString(), controlType));
            }
        }
        return msg.toString();
    }

    private String totalCtrl(Map<String, String> scopeMap, Map<Integer, RuleDetailEntity> ruleMap, Boolean isNullCtrl, TotalCacheEntity cacheEntity, ExecutionVO executionVO, List<DetailCacheEntity> detailCacheEntities, Integer controlType) {
        StringBuffer msg = new StringBuffer();
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        BigDecimal num = cacheEntity.getPreTypeAmount();
        BigDecimal taxMny = cacheEntity.getTaxMny();
        if (!ruleMap.isEmpty()) {
            List itemEntityList = null;
            if (ruleMap.containsKey(FeeTypeEnum.\u5206\u7c7b\u91cf\u63a7.getCode())) {
                LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
                itemQuery.eq(DetailCacheEntity::getDutyDetailId, (Object)cacheEntity.getDutyDetailId());
                itemEntityList = this.detailCacheService.list((Wrapper)itemQuery);
            }
            for (Integer key : ruleMap.keySet()) {
                StringBuffer tmpMsg;
                Object tmpMsg2;
                BigDecimal comTaxScale;
                BigDecimal comNum = null;
                BigDecimal comTaxMny = null;
                BigDecimal controlScale = ruleMap.get(key).getControlScale();
                if (FeeTypeEnum.\u603b\u989d\u63a7.getCode().equals(key)) {
                    if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getPlanTaxMoney();
                    } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getContTaxMoney();
                    } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getStoreTaxMoney();
                    } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getOtherTaxMoney();
                    } else if (BillCategoryEnum.\u7ed3\u7b97.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getSettleTaxMoney();
                    }
                    comTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)comTaxMny, (BigDecimal)taxMny), (BigDecimal)BigDecimal.valueOf(100L));
                    if (isNullCtrl.booleanValue()) {
                        if (!ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comTaxScale)) continue;
                        msg.append(cacheEntity.getName()).append("\u603b\u989d\u63a7").append("&");
                        msg.append(ruleMap.get(key).getOrgName()).append("&");
                        tmpMsg2 = new StringBuffer();
                        ((StringBuffer)tmpMsg2).append(cacheEntity.getName()).append("\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)comTaxMny, (int)2)).append("\u5143)\u5df2\u5360\u9879\u76ee\u7b56\u5212\u4e2d\u8be5\u8d39\u7528\u91d1\u989d");
                        ((StringBuffer)tmpMsg2).append("(").append(ComputeUtil.scale((BigDecimal)taxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comTaxScale, (int)2)).append("%");
                        msg.append(this.getBaseMsg(((StringBuffer)tmpMsg2).toString(), controlType));
                        continue;
                    }
                    if (null == taxMny || !ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comTaxScale)) continue;
                    msg.append(cacheEntity.getName()).append("\u603b\u989d\u63a7").append("&");
                    msg.append(ruleMap.get(key).getOrgName()).append("&");
                    tmpMsg2 = new StringBuffer();
                    ((StringBuffer)tmpMsg2).append(cacheEntity.getName()).append("\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)comTaxMny, (int)2)).append("\u5143)\u5df2\u5360\u9879\u76ee\u7b56\u5212\u4e2d\u8be5\u8d39\u7528\u91d1\u989d");
                    ((StringBuffer)tmpMsg2).append("(").append(ComputeUtil.scale((BigDecimal)taxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comTaxScale, (int)2)).append("%");
                    msg.append(this.getBaseMsg(((StringBuffer)tmpMsg2).toString(), controlType));
                    continue;
                }
                if (FeeTypeEnum.\u76ee\u6807\u5916\u660e\u7ec6\u603b\u91d1\u989d\u63a7.getCode().equals(key)) {
                    if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getOutPlanTaxMoney();
                    } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getOutContTaxMoney();
                    } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getOutStoreTaxMoney();
                    } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getOutOtherTaxMoney();
                    } else if (BillCategoryEnum.\u7ed3\u7b97.getCode().equals(totalExecutionVO.getBillCategory())) {
                        comTaxMny = cacheEntity.getOutSettleTaxMoney();
                    }
                    comTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)comTaxMny, (BigDecimal)taxMny), (BigDecimal)BigDecimal.valueOf(100L));
                    if (isNullCtrl.booleanValue()) {
                        if (!ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comTaxScale)) continue;
                        msg.append(cacheEntity.getName()).append("\u9879\u76ee\u7b56\u5212\u5916\u660e\u7ec6\u603b\u91d1\u989d\u63a7").append("&");
                        msg.append(ruleMap.get(key).getOrgName()).append("&");
                        tmpMsg2 = new StringBuffer();
                        ((StringBuffer)tmpMsg2).append(cacheEntity.getName()).append("\u9879\u76ee\u7b56\u5212\u5916\u660e\u7ec6\u91d1\u989d(").append(comTaxMny).append("\u5143)\u5df2\u5360\u9879\u76ee\u7b56\u5212").append(cacheEntity.getName());
                        ((StringBuffer)tmpMsg2).append("(").append(taxMny).append("\u5143)").append(comTaxScale).append("%");
                        msg.append(this.getBaseMsg(((StringBuffer)tmpMsg2).toString(), controlType));
                        continue;
                    }
                    if (null == taxMny || !ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comTaxScale)) continue;
                    msg.append(cacheEntity.getName()).append("\u9879\u76ee\u7b56\u5212\u5916\u660e\u7ec6\u603b\u91d1\u989d\u63a7").append("&");
                    msg.append(ruleMap.get(key).getOrgName()).append("&");
                    tmpMsg2 = new StringBuffer();
                    ((StringBuffer)tmpMsg2).append(cacheEntity.getName()).append("\u9879\u76ee\u7b56\u5212\u5916\u660e\u7ec6\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)comTaxMny, (int)2)).append("\u5143)\u5df2\u5360\u9879\u76ee\u7b56\u5212").append(cacheEntity.getName());
                    ((StringBuffer)tmpMsg2).append("(").append(ComputeUtil.scale((BigDecimal)taxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comTaxScale, (int)2)).append("%");
                    msg.append(this.getBaseMsg(((StringBuffer)tmpMsg2).toString(), controlType));
                    continue;
                }
                if (!FeeTypeEnum.\u5206\u7c7b\u91cf\u63a7.getCode().equals(key) || !DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(cacheEntity.getDocType()) || !cacheEntity.getLeafFlag().booleanValue() || !this.checkTotal(cacheEntity, executionVO)) continue;
                HashSet<Long> longSet = new HashSet<Long>();
                if (CollectionUtils.isNotEmpty(detailCacheEntities)) {
                    for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
                        if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd(comNum, (BigDecimal)detailCacheEntity.getPlanNum());
                        } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getContNum());
                        } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getStoreNum());
                        } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getOtherNum());
                        } else if (BillCategoryEnum.\u7ed3\u7b97.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getSettleNum());
                        }
                        longSet.add(detailCacheEntity.getId());
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)itemEntityList)) {
                    for (DetailCacheEntity detailCacheEntity : itemEntityList) {
                        if (longSet.contains(detailCacheEntity.getId())) continue;
                        if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getPlanNum());
                            continue;
                        }
                        if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getContNum());
                            continue;
                        }
                        if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getStoreNum());
                            continue;
                        }
                        if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                            comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getOtherNum());
                            continue;
                        }
                        if (!BillCategoryEnum.\u7ed3\u7b97.getCode().equals(totalExecutionVO.getBillCategory())) continue;
                        comNum = ComputeUtil.safeAdd((BigDecimal)comNum, (BigDecimal)detailCacheEntity.getSettleNum());
                    }
                }
                BigDecimal comScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv(comNum, (BigDecimal)num), (BigDecimal)BigDecimal.valueOf(100L));
                if (isNullCtrl.booleanValue()) {
                    if (!ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comScale)) continue;
                    msg.append(cacheEntity.getName()).append("\u5206\u7c7b\u91cf\u63a7").append("&");
                    msg.append(ruleMap.get(key).getOrgName()).append("&");
                    tmpMsg = new StringBuffer();
                    tmpMsg.append(cacheEntity.getName()).append("\u603b\u91cf(").append(ComputeUtil.scale((BigDecimal)comNum, (int)4)).append(")\u5df2\u5360\u9879\u76ee\u7b56\u5212\u4e2d\u8be5\u5206\u7c7b\u9884\u4f30\u603b\u91cf");
                    tmpMsg.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)4)).append(")").append(ComputeUtil.scale((BigDecimal)comScale, (int)2)).append("%");
                    msg.append(this.getBaseMsg(tmpMsg.toString(), controlType));
                    continue;
                }
                if (null == num || !ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comScale)) continue;
                msg.append(cacheEntity.getName()).append("\u5206\u7c7b\u91cf\u63a7").append("&");
                msg.append(ruleMap.get(key).getOrgName()).append("&");
                tmpMsg = new StringBuffer();
                tmpMsg.append(cacheEntity.getName()).append("\u603b\u91cf(").append(ComputeUtil.scale((BigDecimal)comNum, (int)4)).append(")\u5df2\u5360\u9879\u76ee\u7b56\u5212\u4e2d\u8be5\u5206\u7c7b\u9884\u4f30\u603b\u91cf");
                tmpMsg.append("(").append(ComputeUtil.scale((BigDecimal)num, (int)2)).append(")").append(ComputeUtil.scale((BigDecimal)comScale, (int)2)).append("%");
                msg.append(this.getBaseMsg(tmpMsg.toString(), controlType));
            }
        }
        return msg.toString();
    }

    private String getBaseMsg(String midMsg, Integer controlType) {
        StringBuffer msg = new StringBuffer();
        if (ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\u521a\u6027\uff1a");
        } else if (ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\u67d4\u6027\uff1a");
        }
        msg.append(midMsg);
        if (ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01/n");
        } else if (ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode().equals(controlType)) {
            msg.append("\uff01/n");
        }
        return msg.toString();
    }

    private List<Map<Integer, RuleDetailEntity>> splitToMap(List<RuleDetailEntity> ruleDetailEntityList, int controlType, Map<Long, RuleEntity> ruleMap) {
        ArrayList<Map<Integer, RuleDetailEntity>> list = new ArrayList<Map<Integer, RuleDetailEntity>>();
        HashMap<Integer, RuleDetailEntity> map = new HashMap<Integer, RuleDetailEntity>();
        HashMap<Integer, RuleDetailEntity> mapNull = new HashMap<Integer, RuleDetailEntity>();
        for (RuleDetailEntity entity : ruleDetailEntityList) {
            if (controlType != entity.getControlType()) continue;
            Integer key = entity.getFeeType();
            RuleDetailEntity controlScale = null;
            if (entity.getNullControlFlag().booleanValue()) {
                controlScale = mapNull.containsKey(key) ? (ComputeUtil.isLessThan((BigDecimal)((RuleDetailEntity)((Object)mapNull.get(key))).getControlScale(), (BigDecimal)entity.getControlScale()) ? (RuleDetailEntity)((Object)mapNull.get(key)) : entity) : entity;
                controlScale.setOrgName(ruleMap.get(controlScale.getRuleId()).getOrgName());
                mapNull.put(key, controlScale);
                continue;
            }
            controlScale = map.containsKey(key) ? (ComputeUtil.isLessThan((BigDecimal)((RuleDetailEntity)((Object)map.get(key))).getControlScale(), (BigDecimal)entity.getControlScale()) ? (RuleDetailEntity)((Object)map.get(key)) : entity) : entity;
            controlScale.setOrgName(ruleMap.get(controlScale.getRuleId()).getOrgName());
            map.put(key, controlScale);
        }
        list.add(map);
        list.add(mapNull);
        return list;
    }

    private List<DetailCacheEntity> cacheDetails(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks) {
        HashSet<DetailCacheEntity> insertSet = new HashSet<DetailCacheEntity>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        queryWrapper.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List detailEntities = this.dutyDetailService.list((Wrapper)queryWrapper);
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        for (DutyDetailEntity detailEntity : detailEntities) {
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId()) {
                parentIdList.add(detailEntity.getFeeDetailId());
            }
            detailIdList.add(detailEntity.getId());
        }
        HashMap ctyMap = new HashMap();
        if (CollectionUtils.isNotEmpty(parentIdList)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(FeeDetailEntity::getParentId, parentIdList);
            List feeDetailEntities = this.feeDetailService.list((Wrapper)query);
            for (Object detailEntity : feeDetailEntities) {
                ArrayList<Object> list = ctyMap.containsKey(((FeeDetailEntity)((Object)detailEntity)).getParentId()) ? (List)ctyMap.get(((FeeDetailEntity)((Object)detailEntity)).getParentId()) : new ArrayList<Object>();
                list.add(detailEntity);
                ctyMap.put(((FeeDetailEntity)((Object)detailEntity)).getParentId(), list);
            }
        }
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.in(DutyDetailItemEntity::getDutyDetailId, detailIdList);
        List itemAllEntityList = this.dutyDetailItemService.list((Wrapper)itemQuery);
        HashMap itemAllMap = new HashMap();
        for (DutyDetailItemEntity itemEntity : itemAllEntityList) {
            ArrayList<DutyDetailItemEntity> list = itemAllMap.containsKey(itemEntity.getDutyDetailId()) ? (List)itemAllMap.get(itemEntity.getDutyDetailId()) : new ArrayList<DutyDetailItemEntity>();
            list.add(itemEntity);
            itemAllMap.put(itemEntity.getDutyDetailId(), list);
        }
        LambdaQueryWrapper detailQuery = new LambdaQueryWrapper();
        detailQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        List detailCacheAllEntities = this.detailCacheService.list((Wrapper)detailQuery);
        HashMap itemcacheAllMap = new HashMap();
        for (DetailCacheEntity cacheEntity : detailCacheAllEntities) {
            ArrayList<DetailCacheEntity> list = itemcacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)itemcacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<DetailCacheEntity>();
            list.add(cacheEntity);
            itemcacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity detailEntity : detailEntities) {
            ArrayList<Long> categoryList = new ArrayList();
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId() && ctyMap.containsKey(detailEntity.getFeeDetailId())) {
                List list = (List)ctyMap.get(detailEntity.getFeeDetailId());
                categoryList = list.stream().map(FeeDetailEntity::getCategoryId).collect(Collectors.toList());
            }
            List itemEntityList = (List)itemAllMap.get(detailEntity.getId());
            Map<Object, Object> itemMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemEntityList)) {
                itemMap = itemEntityList.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }
            List detailCacheEntities = (List)itemcacheAllMap.get(detailEntity.getId());
            Map<Object, Object> itemcacheMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)detailCacheEntities)) {
                itemcacheMap = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                Long docId = detailExecutionVO.getDocId();
                if (!this.checkDetail(detailEntity, detailExecutionVO, categoryList)) continue;
                DetailCacheEntity cacheEntity = null;
                if (itemcacheMap.containsKey(docId)) {
                    cacheEntity = (DetailCacheEntity)((Object)itemcacheMap.get(docId));
                } else {
                    if (itemMap.containsKey(docId)) {
                        DutyDetailItemEntity itemEntity = (DutyDetailItemEntity)((Object)itemMap.get(docId));
                        cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)((Object)itemEntity), DetailCacheEntity.class));
                        cacheEntity.setDutyItemId(itemEntity.getId());
                        cacheEntity.setSpec(itemEntity.getModel());
                    } else {
                        cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)detailExecutionVO, DetailCacheEntity.class));
                        if (detailExecutionVO.getCategoryFlag().booleanValue()) {
                            cacheEntity.setCode(detailExecutionVO.getCategoryCode());
                            cacheEntity.setName(detailExecutionVO.getCategoryName());
                        }
                        cacheEntity.setPrice(null);
                        cacheEntity.setTaxPrice(null);
                        cacheEntity.setModel(detailExecutionVO.getSpec());
                        cacheEntity.setDutyDetailId(detailEntity.getId());
                        cacheEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                        cacheEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                        cacheEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    }
                    cacheEntity.setProjectId(dutyEntity.getProjectId());
                }
                cacheEntity.setBillCategory(executionVO.getTotalVO().getBillCategory());
                DutyCalcUtil.setDetailValue(cacheEntity, detailExecutionVO, executionVO.getTotalVO());
                insertSet.add(cacheEntity);
            }
        }
        return insertSet.isEmpty() ? new ArrayList<DetailCacheEntity>() : new ArrayList(insertSet);
    }

    private boolean checkDetail(DutyDetailEntity detailEntity, DetailExecutionVO detailExecutionVO, List<Long> categoryList) {
        if (null == detailEntity.getCategoryId()) {
            boolean flag = false;
            if (CollectionUtils.isNotEmpty(categoryList)) {
                for (Long category : categoryList) {
                    if (null == detailExecutionVO.getCategoryInnerCode() || !detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(category))) continue;
                    flag = true;
                }
            }
            return flag;
        }
        if (!detailEntity.getLeafFlag().booleanValue()) {
            return false;
        }
        if (detailEntity.getDocType().compareTo(detailExecutionVO.getDocType()) != 0) {
            return false;
        }
        return null != detailExecutionVO.getCategoryInnerCode() && detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(detailEntity.getCategoryId()));
    }

    private List<TotalCacheEntity> cacheTotal(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks, List<DetailCacheEntity> detailCacheEntities) {
        ArrayList<TotalCacheEntity> insertList = new ArrayList<TotalCacheEntity>();
        LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
        feeQuery.eq(FeeDetailEntity::getFeeId, (Object)dutyEntity.getFeeId());
        List feeDetailEntities = this.feeDetailService.list((Wrapper)feeQuery);
        Map<Long, String> feeInnerMap = feeDetailEntities.stream().collect(Collectors.toMap(BaseEntity::getId, FeeDetailEntity::getInnerCode, (key1, key2) -> key1));
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        LambdaQueryWrapper totalQuery = new LambdaQueryWrapper();
        totalQuery.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        totalQuery.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List dutyDetailEntities = this.dutyDetailService.list((Wrapper)totalQuery);
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        for (DutyDetailEntity detailEntity : dutyDetailEntities) {
            detailIdList.add(detailEntity.getId());
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(TotalCacheEntity::getDutyDetailId, detailIdList);
        List totalCacheAllEntities = this.totalCacheService.list((Wrapper)query);
        HashMap totalMap = new HashMap();
        for (TotalCacheEntity cacheEntity : totalCacheAllEntities) {
            ArrayList<TotalCacheEntity> list = totalMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)totalMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<TotalCacheEntity>();
            list.add(cacheEntity);
            totalMap.put(cacheEntity.getDutyDetailId(), list);
        }
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        List itemEntityAllListdb = this.detailCacheService.list((Wrapper)itemQuery);
        HashMap cacheAllMap = new HashMap();
        for (DetailCacheEntity cacheEntity : itemEntityAllListdb) {
            ArrayList<DetailCacheEntity> list = cacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)cacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<DetailCacheEntity>();
            list.add(cacheEntity);
            cacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            List totalCacheEntities = (List)totalMap.get(dutyDetailEntity.getId());
            TotalCacheEntity totalCacheEntity = CollectionUtils.isNotEmpty((Collection)totalCacheEntities) ? (TotalCacheEntity)((Object)totalCacheEntities.get(0)) : (TotalCacheEntity)((Object)BeanMapper.map((Object)((Object)dutyDetailEntity), TotalCacheEntity.class));
            totalCacheEntity.setDutyDetailId(dutyDetailEntity.getId());
            List itemEntityListdb = (List)cacheAllMap.get(dutyDetailEntity.getId());
            ArrayList<DetailCacheEntity> itemEntityList = new ArrayList<DetailCacheEntity>();
            HashSet<Long> longSet = new HashSet<Long>();
            boolean isAddList = false;
            if (CollectionUtils.isNotEmpty(detailCacheEntities)) {
                for (DetailCacheEntity detailCacheEntity : detailCacheEntities) {
                    if (detailCacheEntity.getDutyDetailId().compareTo(totalCacheEntity.getDutyDetailId()) == 0) {
                        itemEntityList = CollectionUtils.isNotEmpty(itemEntityList) ? itemEntityList : new ArrayList<DetailCacheEntity>();
                        itemEntityList.add(detailCacheEntity);
                        longSet.add(detailCacheEntity.getDocId());
                        isAddList = true;
                        continue;
                    }
                    if (!feeInnerMap.get(detailCacheEntity.getFeeDetailId()).contains(feeInnerMap.get(dutyDetailEntity.getFeeDetailId()))) continue;
                    isAddList = true;
                }
            } else if (CollectionUtils.isEmpty((Collection)executionVO.getDetailList()) && CollectionUtils.isEmpty(detailCacheEntities)) {
                isAddList = true;
            }
            if (CollectionUtils.isNotEmpty((Collection)itemEntityListdb)) {
                for (DetailCacheEntity detailCacheEntity : itemEntityListdb) {
                    if (longSet.contains(detailCacheEntity.getDocId())) continue;
                    itemEntityList.add(detailCacheEntity);
                }
            }
            DutyCalcUtil.setValue(totalCacheEntity, itemEntityList, totalExecutionVO);
            if (!isAddList) continue;
            insertList.add(totalCacheEntity);
        }
        List resultMapList = BeanMapper.mapList(insertList, Map.class);
        List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);
        this.gatherMnyAndNum(null, treeData);
        ArrayList<TotalCacheEntity> entities = new ArrayList<TotalCacheEntity>();
        this.treeToList(treeData, entities);
        for (TotalCacheEntity entity : entities) {
            if (!BooleanUtils.isTrue((Boolean)entity.getSelfScopeFlag()) || !BooleanUtils.isFalse((Boolean)entity.getLeafFlag()) || null != entity.getAllCostFlag() && !BooleanUtils.isFalse((Boolean)entity.getAllCostFlag())) continue;
            DutyCalcUtil.setValue(entity, totalExecutionVO);
        }
        return entities;
    }

    private boolean checkTotal(TotalCacheEntity cacheEntity, ExecutionVO executionVO) {
        String innerStr = "";
        List detailList = executionVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List innerList = detailList.stream().map(DetailExecutionVO::getCategoryInnerCode).collect(Collectors.toList());
            innerStr = StringUtils.join(innerList, (String)",");
        }
        if (null != cacheEntity.getCategoryId()) {
            return innerStr.indexOf(String.valueOf(cacheEntity.getCategoryId())) > 0;
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(FeeDetailEntity::getParentId, (Object)cacheEntity.getFeeDetailId());
        List feeDetailEntities = this.feeDetailService.list((Wrapper)query);
        for (FeeDetailEntity detailEntity : feeDetailEntities) {
            if (innerStr.indexOf(String.valueOf(detailEntity.getCategoryId())) <= 0) continue;
            return true;
        }
        return false;
    }

    private void treeToList(List<Map<String, Object>> treeData, List<TotalCacheEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((TotalCacheEntity)((Object)BeanMapper.map(ypd, TotalCacheEntity.class)));
        }
    }

    private void gatherMnyAndNum(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal planMoney = null;
        BigDecimal planTaxMoney = null;
        BigDecimal outPlanMoney = null;
        BigDecimal outPlanTaxMoney = null;
        BigDecimal contMoney = null;
        BigDecimal contTaxMoney = null;
        BigDecimal outContMoney = null;
        BigDecimal outContTaxMoney = null;
        BigDecimal storeMoney = null;
        BigDecimal storeTaxMoney = null;
        BigDecimal outStoreMoney = null;
        BigDecimal outStoreTaxMoney = null;
        BigDecimal otherMoney = null;
        BigDecimal otherTaxMoney = null;
        BigDecimal outOtherMoney = null;
        BigDecimal outOtherTaxMoney = null;
        Boolean allCostFlag = false;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMnyAndNum(ypd, (List)ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, (BigDecimal)this.getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, (BigDecimal)this.getBigDecimalValue(ypd, "taxMny"));
            planMoney = ComputeUtil.safeAdd(planMoney, (BigDecimal)this.getBigDecimalValue(ypd, "planMoney"));
            planTaxMoney = ComputeUtil.safeAdd(planTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "planTaxMoney"));
            outPlanMoney = ComputeUtil.safeAdd(outPlanMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outPlanMoney"));
            outPlanTaxMoney = ComputeUtil.safeAdd(outPlanTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outPlanTaxMoney"));
            contMoney = ComputeUtil.safeAdd(contMoney, (BigDecimal)this.getBigDecimalValue(ypd, "contMoney"));
            contTaxMoney = ComputeUtil.safeAdd(contTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "contTaxMoney"));
            outContMoney = ComputeUtil.safeAdd(outContMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outContMoney"));
            outContTaxMoney = ComputeUtil.safeAdd(outContTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outContTaxMoney"));
            storeMoney = ComputeUtil.safeAdd(storeMoney, (BigDecimal)this.getBigDecimalValue(ypd, "storeMoney"));
            storeTaxMoney = ComputeUtil.safeAdd(storeTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "storeTaxMoney"));
            outStoreMoney = ComputeUtil.safeAdd(outStoreMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outStoreMoney"));
            outStoreTaxMoney = ComputeUtil.safeAdd(outStoreTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outStoreTaxMoney"));
            otherMoney = ComputeUtil.safeAdd(otherMoney, (BigDecimal)this.getBigDecimalValue(ypd, "otherMoney"));
            otherTaxMoney = ComputeUtil.safeAdd(otherTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "otherTaxMoney"));
            outOtherMoney = ComputeUtil.safeAdd(outOtherMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outOtherMoney"));
            outOtherTaxMoney = ComputeUtil.safeAdd(outOtherTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outOtherTaxMoney"));
            if (!DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(ypd.get("docType"))) continue;
            allCostFlag = true;
        }
        if (now != null) {
            now.put("allCostFlag", allCostFlag);
            now.put("outPlanMoney", outPlanMoney);
            now.put("outPlanTaxMoney", outPlanTaxMoney);
            now.put("outContMoney", outContMoney);
            now.put("outContTaxMoney", outContTaxMoney);
            now.put("outStoreMoney", outStoreMoney);
            now.put("outStoreTaxMoney", outStoreTaxMoney);
            now.put("outOtherMoney", outOtherMoney);
            now.put("outOtherTaxMoney", outOtherTaxMoney);
            if (!((Boolean)now.get("selfScopeFlag")).booleanValue() || !((Boolean)now.get("leafFlag")).booleanValue() && allCostFlag.booleanValue()) {
                now.put("planMoney", planMoney);
                now.put("planTaxMoney", planTaxMoney);
                now.put("contMoney", contMoney);
                now.put("contTaxMoney", contTaxMoney);
                now.put("storeMoney", storeMoney);
                now.put("storeTaxMoney", storeTaxMoney);
                now.put("otherMoney", otherMoney);
                now.put("otherTaxMoney", otherTaxMoney);
            }
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }
}

