package com.ejianc.business.targetcost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.targetcost.bean.DutyAssessAdjustEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.targetcost.vo.DutyAssessAdjustDetailVO;

/**
 * 成本分析节点调整申请
 * 
 * @author generator
 * 
 */
public class DutyAssessAdjustVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 所属组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private Long projectId; // 所属项目
    private String projectName; // 项目名称
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private Long dutyId; // 目标责任成本
    private String dutyName; // 目标责任成本名称
    private String memo; // 备注
    private Integer billState; // 审批状态
    
    private List<DutyAssessAdjustDetailVO> dutyAssessAdjustDetailList = new ArrayList<>(); // 成本分析节点调整申请明细

    private List<DutyAssessAdjustEntity> dutyAssessAdjustEntities = new ArrayList<>();

    public List<DutyAssessAdjustEntity> getDutyAssessAdjustEntities() {
        return dutyAssessAdjustEntities;
    }

    public void setDutyAssessAdjustEntities(List<DutyAssessAdjustEntity> dutyAssessAdjustEntities) {
        this.dutyAssessAdjustEntities = dutyAssessAdjustEntities;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getOperatorId() {
        return operatorId;
    }
    @ReferDeserialTransfer
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    @ReferSerialTransfer(referCode = "tc-duty")
    public Long getDutyId() {
        return dutyId;
    }
    @ReferDeserialTransfer
    public void setDutyId(Long dutyId) {
        this.dutyId = dutyId;
    }
    public String getDutyName() {
        return dutyName;
    }

    public void setDutyName(String dutyName) {
        this.dutyName = dutyName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<DutyAssessAdjustDetailVO> getDutyAssessAdjustDetailList() {
        return dutyAssessAdjustDetailList;
     }

     public void setDutyAssessAdjustDetailList(List<DutyAssessAdjustDetailVO> dutyAssessAdjustDetailList) {
        this.dutyAssessAdjustDetailList = dutyAssessAdjustDetailList;
     }
}
