package com.ejianc.business.costcheck.mapper;

import com.ejianc.business.costcheck.vo.ProjectCheckCollectDetailEntitVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.costcheck.bean.ProjectCheckEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 项目检查表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectCheckMapper extends BaseCrudMapper<ProjectCheckEntity> {

    @Select("SELECT project.project_id,project.project_name,pcheck.id project_check_id,pcheck.major_project_id,pcheck.person_check_id,pcheck.person_check_name,pcheck.check_date,pcheck.grade_staff,pcheck.remark FROM `ejc_costcheck_major_project_detail` project\n" +
            "            LEFT JOIN (select * from \n" +
            "ejc_costcheck_project_check \n" +
            "where dr = 0\n" +
            "            and cite = 0\n" +
            "            and bill_state in (1,3)\n" +
            ")\n" +
            "as pcheck\n" +
            "            on pcheck.major_project_id = project.id\n" +
            "            where project.dr = 0")
    List<ProjectCheckCollectDetailEntitVO> getListByProjectId();

    @Select("SELECT count(*) num from ejc_costcheck_record\n" +
            "where dr = 0 and bill_state in (1,3) and cite = 0")
    Integer getTips();
}
