package com.ejianc.business.costcheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.costcheck.bean.ProjectCheckDetailEntity;
import com.ejianc.business.costcheck.bean.ProjectCheckEntity;
import com.ejianc.business.costcheck.bean.RecordEntity;
import com.ejianc.business.costcheck.service.IProjectCheckService;
import com.ejianc.business.costcheck.service.IRecordService;
import com.ejianc.business.costcheck.vo.RecordVO;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Service("projectCheck") 
public class ProjectCheckBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IProjectCheckService service;
	@Autowired
	private IRecordService recordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProjectCheckEntity projectCheckEntity = service.selectById(billId);
		if (projectCheckEntity != null) {
			//修改引用状态
			List<ProjectCheckDetailEntity> projectCheckDetailList = projectCheckEntity.getProjectCheckDetailList();
			if (CollectionUtils.isNotEmpty(projectCheckDetailList)){
				ArrayList<String> strings = new ArrayList<>();
				for (ProjectCheckDetailEntity projectCheckDetailEntity : projectCheckDetailList) {
					List<String> stringList = Arrays.asList(projectCheckDetailEntity.getRemark().split(","));
					strings.addAll(stringList);
				}

				LambdaUpdateWrapper<RecordEntity> updateWrapper =new LambdaUpdateWrapper<>();
				updateWrapper.set(RecordEntity::getCite, 1);
				updateWrapper.in(RecordEntity::getId,strings);
				recordService.update(updateWrapper);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("引用状态已修改！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
