package com.ejianc.business.costinspection.controller;

import java.io.Serializable;
import com.ejianc.business.costinspection.vo.util.TreeNodeBUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.costinspection.utils.ExcelImportUtil;
import com.ejianc.business.pro.supplier.vo.CommentModleContentVO;
import com.ejianc.business.pro.supplier.vo.CommentModleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.costinspection.bean.InspectionModleEntity;
import com.ejianc.business.costinspection.service.IInspectionModleService;
import com.ejianc.business.costinspection.vo.InspectionModleVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 巡检记录模板
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("inspectionModle")
public class InspectionModleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInspectionModleService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InspectionModleVO> saveOrUpdate(@RequestBody InspectionModleVO saveOrUpdateVO) {
    	InspectionModleEntity entity = BeanMapper.map(saveOrUpdateVO, InspectionModleEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

        //如果开启状态需要修改已开启的模板
        if(saveOrUpdateVO.getState()){
            QueryParam params = new QueryParam();
            params.getParams().put("commentType",new Parameter(QueryParam.EQ,saveOrUpdateVO.getCommentType()));
            params.getParams().put("state",new Parameter(QueryParam.EQ,true));

            List<InspectionModleEntity> lists =service.queryList(params);
            if(ListUtil.isNotEmpty(lists) && lists.get(0).getId()!=null && !lists.get(0).getId().equals(entity.getId())){
                InspectionModleEntity  commentModleEntity = lists.get(0);
                commentModleEntity.setState(false);
                service.saveOrUpdate(commentModleEntity);
            }
        }

    	InspectionModleVO vo = BeanMapper.map(entity, InspectionModleVO.class);

        vo.setInspectionModleContentList(TreeNodeBUtil.buildTree(vo.getInspectionModleContentList()));

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InspectionModleVO> queryDetail(Long id) {
    	InspectionModleEntity entity = service.selectById(id);
    	InspectionModleVO vo = BeanMapper.map(entity, InspectionModleVO.class);
        if(CollectionUtils.isNotEmpty(entity.getInspectionModleContentList())){
            vo.setInspectionModleContentList(TreeNodeBUtil.buildTree(vo.getInspectionModleContentList()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InspectionModleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InspectionModleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InspectionModleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InspectionModleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        IPage<InspectionModleEntity> page = service.queryPage(param,false);
        IPage<InspectionModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InspectionModleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InspectionModleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InspectionModle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refInspectionModleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InspectionModleVO>> refInspectionModleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InspectionModleEntity> page = service.queryPage(param,false);
        IPage<InspectionModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InspectionModleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<CommentModleContentVO> errorsList = new ArrayList<>();

            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<CommentModleContentVO> detailVoList = new ArrayList<>();
                Map<String, Long> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    CommentModleContentVO vo = new CommentModleContentVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    //维护父子关系
                    Long id = Long.valueOf(IdWorker.getId());
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            parentWarn=true;
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }else{
                            vo.setParentId(999L);
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                        vo.setParentId(999L);
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(0))) {
                        vo.setCode(null);
                        flag = true;
                    } else {
                        vo.setCode(datas.get(0));
                    }

                    if (StringUtils.isNotEmpty(datas.get(1))) {
                        if(parentWarn){
                            vo.setName(null);

                        }else{
                            vo.setName(datas.get(1));
                        }
                    }else {
                        if (!parentWarn && StringUtils.isBlank(vo.getTpid())){
                            vo.setName(null);
                            vo.setErrorMessage("第"+i+"行数据：导入失败，原因：评价内容必填！");
                        }
                    }

                    if (StringUtils.isNotEmpty(datas.get(2))) {
                        if(parentWarn){
                            vo.setItem(datas.get(2));
                        }else{
                            vo.setItem(null);
                        }

                    }else {
                        if (parentWarn){
                            vo.setItem(null);
                            vo.setErrorMessage("第"+i+"行数据：导入失败，原因：评价事项必填！");
                        }
                    }
                    if(parentWarn){
                        if (StringUtils.isNotEmpty(datas.get(3))) {
                            try{
                                vo.setDeduct(Integer.valueOf(datas.get(3)));
                            }catch (NumberFormatException e){
                                vo.setErrorMessage("第"+i+"行数据：导入失败，原因：分值不是正确的数字格式！");
                                vo.setDeduct(null);
                            }
                        }
                    }else{
                        vo.setDeduct(null);
                    }

                    parentWarn =false;
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setShadowId(vo.getTid());
                    vo.setRowState("add");
                    vo.setEditFlag(false);
                    if (StringUtils.isNotBlank(vo.getErrorMessage())){
                        errorsList.add(vo);
                    }else{
                        detailVoList.add(vo);
                    }
                }

                for (CommentModleContentVO tVo : detailVoList) {
                    tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                if(errorList.size() >0){
                    resp.put("errorList", errorList );
                    resp.put("errorNum", errorList.size());

                }else {
                    resp.put("errorList", errorsList );
                    resp.put("errorNum", 0);
                }
                resp.put("successList", allList.get(0));

                resp.put("successNum", result.size() - 1 - errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 修改状态
     * @param param
     * @return
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String,String> param){
        Long id = Long.parseLong(param.get("id"));
        Boolean state =  Boolean.parseBoolean(param.get("state"));
        service.updateState(id,state);
        return CommonResponse.success("修改状态成功!");
    }




    /**
     * @Description queryDetail 查询启用状态单据的详情
     * @param
     */
    @RequestMapping(value = "/queryOpenDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InspectionModleVO> queryOpenDetail() {

        QueryParam params = new QueryParam();
        params.getParams().put("state",new Parameter(QueryParam.EQ,true));
        params.getParams().put("dr",new Parameter(QueryParam.EQ,0));

        List<InspectionModleEntity> lists =service.queryList(params);
        if(ListUtil.isNotEmpty(lists) && lists.get(0).getId()!=null){
            InspectionModleEntity entity = service.selectById(lists.get(0).getId());
            InspectionModleVO vo = BeanMapper.map(entity, InspectionModleVO.class);
            if(CollectionUtils.isNotEmpty(entity.getInspectionModleContentList())){
                vo.setInspectionModleContentList(TreeNodeBUtil.buildTree(vo.getInspectionModleContentList()));
            }
            return CommonResponse.success("查询详情数据成功！",vo);
        }

        return CommonResponse.success("查询详情数据成功！",null);
    }


}
