package com.ejianc.business.costplan.mapper;

import com.ejianc.business.costplan.vo.DutyAssessPlanDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.costplan.bean.DutyAssessPlanEntity;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 成本分析月计划
 * 
 * @author generator
 * 
 */
@Mapper
public interface DutyAssessPlanMapper extends BaseCrudMapper<DutyAssessPlanEntity> {

    @Select("SELECT id as assess_id,project_id,project_name,assess_name,assess_time,memo FROM `ejc_targetcost_duty_assess_detail`\n" +
            "where dr = 0\n" +
            "and DATE_FORMAT( assess_time, '%Y%m' ) =DATE_FORMAT(#{checkDate}, '%Y%m' ) order by assess_time asc")
    List<DutyAssessPlanDetailVO> getCollectData(Date checkDate);
}
