package com.ejianc.business.costcheck.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.costcheck.bean.ProjectCheckDetailEntity;
/**
 * 项目检查表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costcheck_project_check")
public class ProjectCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="person_check_id")
    private Long personCheckId; // 检查人ID
    @TableField(value="person_check_name")
    private String personCheckName; // 检查人
    @TableField(value="check_date")
    private Date checkDate; // 检查时间
    @TableField(value="project_state")
    private String projectState; // 项目状态
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value="building_cost")
    private BigDecimal buildingCost; // 工程造价金额
    @TableField(value="control_mny")
    private BigDecimal controlMny; // 管控金额
    @TableField(value="grade_staff")
    private String gradeStaff; // 评定等级主管
    @TableField(value="grade_leader")
    private String gradeLeader; // 评定等级经理
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="major_project_id")
    private Long majorProjectId; // 项目ID
    @TableField(value="cite")
    private Integer cite; // 是否被引用 1true 0false
    @TableField(value="problem_description_staff")
    private String problemDescriptionStaff; // 项目问题描述主管
    @TableField(value="last_problem_description")
    private String lastProblemDescription; // 上次项目问题描述
    @TableField(value="last_grade")
    private String lastGrade; // 上次评定等级
    @TableField(value="last_project_check_id")
    private Long lastProjectCheckId; // 上次检查单id
    @TableField(value="problem_description_leader")
    private String problemDescriptionLeader; // 项目问题描述经理

    @TableField(exist=false)
    @SubEntity(serviceName="projectCheckDetailService")
    private List<ProjectCheckDetailEntity> projectCheckDetailList = new ArrayList<>(); // 项目检查明细


    public String getProblemDescriptionStaff() {
        return problemDescriptionStaff;
    }

    public void setProblemDescriptionStaff(String problemDescriptionStaff) {
        this.problemDescriptionStaff = problemDescriptionStaff;
    }

    public String getLastProblemDescription() {
        return lastProblemDescription;
    }

    public void setLastProblemDescription(String lastProblemDescription) {
        this.lastProblemDescription = lastProblemDescription;
    }

    public String getLastGrade() {
        return lastGrade;
    }

    public void setLastGrade(String lastGrade) {
        this.lastGrade = lastGrade;
    }

    public Long getLastProjectCheckId() {
        return lastProjectCheckId;
    }

    public void setLastProjectCheckId(Long lastProjectCheckId) {
        this.lastProjectCheckId = lastProjectCheckId;
    }

    public String getProblemDescriptionLeader() {
        return problemDescriptionLeader;
    }

    public void setProblemDescriptionLeader(String problemDescriptionLeader) {
        this.problemDescriptionLeader = problemDescriptionLeader;
    }

    public Integer getCite() {
        return cite;
    }

    public void setCite(Integer cite) {
        this.cite = cite;
    }

    public Long getMajorProjectId() {
        return majorProjectId;
    }

    public void setMajorProjectId(Long majorProjectId) {
        this.majorProjectId = majorProjectId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getPersonCheckId() {
        return personCheckId;
    }

    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getProjectState() {
        return projectState;
    }

    public void setProjectState(String projectState) {
        this.projectState = projectState;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getBuildingCost() {
        return buildingCost;
    }

    public void setBuildingCost(BigDecimal buildingCost) {
        this.buildingCost = buildingCost;
    }
    public BigDecimal getControlMny() {
        return controlMny;
    }

    public void setControlMny(BigDecimal controlMny) {
        this.controlMny = controlMny;
    }
    public String getGradeStaff() {
        return gradeStaff;
    }

    public void setGradeStaff(String gradeStaff) {
        this.gradeStaff = gradeStaff;
    }
    public String getGradeLeader() {
        return gradeLeader;
    }

    public void setGradeLeader(String gradeLeader) {
        this.gradeLeader = gradeLeader;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    

    public List<ProjectCheckDetailEntity> getProjectCheckDetailList() {
        return projectCheckDetailList;
    }

    public void setProjectCheckDetailList(List<ProjectCheckDetailEntity> projectCheckDetailList) {
        this.projectCheckDetailList = projectCheckDetailList;
    }
}
