package com.ejianc.business.costcheck.service.impl;

import com.ejianc.business.costcheck.vo.ProjectCheckCollectDetailEntitVO;
import com.ejianc.business.costcheck.vo.ProjectCheckVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.costcheck.mapper.ProjectCheckMapper;
import com.ejianc.business.costcheck.bean.ProjectCheckEntity;
import com.ejianc.business.costcheck.service.IProjectCheckService;

import java.util.List;

/**
 * 项目检查表
 * 
 * @author generator
 * 
 */
@Service("projectCheckService")
public class ProjectCheckServiceImpl extends BaseServiceImpl<ProjectCheckMapper, ProjectCheckEntity> implements IProjectCheckService{

    @Override
    public List<ProjectCheckCollectDetailEntitVO> getListByProjectId() {
        return baseMapper.getListByProjectId();
    }

    @Override
    public Integer getTips() {
        return baseMapper.getTips();
    }

    @Override
    public ProjectCheckVO getLastCheckByProjectId(Long projectId) {
        return baseMapper.getLastCheckByProjectId(projectId);
    }
}
