package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.*;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.FeeMapper;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 费用模板
 *
 * @author generator
 */
@Service("feeService")
public class FeeServiceImpl extends BaseServiceImpl<FeeMapper, FeeEntity> implements IFeeService {

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IFeeService service;

    @Autowired
    private IFeeDetailService feeDetailService;

    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;

    @Autowired
    private IBusinessScopeService businessScopeService;

    @Autowired
    private IBusinessScopeDetailService businessScopeDetailService;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "TC_FEE";

    @Override
    public CommonResponse<FeeVO> saveOrUpdate(FeeVO feeVO) {
        FeeEntity entity = BeanMapper.map(feeVO, FeeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setEnabled(true);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), feeVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        entity.setOrgId(getContextOrgId());
        service.saveOrUpdate(entity, false);

        //费用明细列表
        List<FeeDetailEntity> feeDetailEntities = entity.getFeeDetailList();
        Map<Long, String> innerCodeMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(feeDetailEntities)) {
            //费用明细编码对应主键
            Map<String, Long> map = new HashMap<>();
            //遍历获取真实主键
            for (FeeDetailEntity feeDetailEntity : feeDetailEntities) {
                map.put(feeDetailEntity.getShadowId(), feeDetailEntity.getId());
            }
            //设置子节点parentId
            for (FeeDetailEntity feeDetailEntity : feeDetailEntities) {
                feeDetailEntity.setParentId(map.get(feeDetailEntity.getTpid()));
                feeDetailEntity.setSelfScopeFlag(CollectionUtils.isNotEmpty(feeDetailEntity.getFeeDetailScopeList()));
                feeDetailEntity.setSelfRelatedFlag(CollectionUtils.isNotEmpty(feeDetailEntity.getRelatedDetailList()));
            }
            // 生成内码
            List<Map> resultMapList = BeanMapper.mapList(feeDetailEntities, Map.class);
            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
            List<Map<String, Object>> ListCodeDate = creatCode(treeData, null);
            List<FeeDetailEntity> entities = new ArrayList<>();
            treeToList(ListCodeDate, entities);
            innerCodeMap = entities.stream().collect(Collectors.toMap(FeeDetailEntity::getId, FeeDetailEntity::getInnerCode, (key1, key2) -> key1));
            feeDetailService.saveOrUpdateBatch(entities);
        }

        //保存业务范围
        Map<Long,List<FeeDetailScopeEntity>> scopeMap = new HashMap<>();

        for (FeeDetailEntity feeDetailEntity : entity.getFeeDetailList()) {
            //设置最近节点业务范围:当前节点不存在业务范围时,设置业务范围为最近节点业务范围
            if(feeDetailEntity.getParentId()!=null&&CollectionUtils.isEmpty(feeDetailEntity.getFeeDetailScopeList())){
                //存在父节点设置业务范围
                feeDetailEntity.setFeeDetailScopeList(scopeMap.get(feeDetailEntity.getParentId()));
            }
            scopeMap.put(feeDetailEntity.getId(),feeDetailEntity.getFeeDetailScopeList());

            //删除业务范围
            LambdaQueryWrapper<FeeDetailScopeEntity> query = new LambdaQueryWrapper<>();
            query.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailEntity.getId());
            feeDetailScopeService.remove(query);
            //保存新业务范围
            if("del" != feeDetailEntity.getRowState()){
                setScopList(feeDetailEntity, feeDetailEntity.getParentId());
            }
            //非正常显示清单
            if(feeDetailEntity.getSelfRelatedFlag()){
                LambdaQueryWrapper<FeeDetailEntity> deleteQuery = new LambdaQueryWrapper<>();
                deleteQuery.ne(FeeDetailEntity::getId, feeDetailEntity.getId());
                deleteQuery.like(FeeDetailEntity::getInnerCode, feeDetailEntity.getId());
                List<FeeDetailEntity> detailEntities = feeDetailService.list(deleteQuery);
                if (CollectionUtils.isNotEmpty(detailEntities)) {
                    List<Long> pkList = detailEntities.stream().map(FeeDetailEntity::getId).collect(Collectors.toList());
                    feeDetailService.removeByIds(pkList);
                    LambdaQueryWrapper<FeeDetailScopeEntity> deleteWrapper = new LambdaQueryWrapper<>();
                    deleteWrapper.in(FeeDetailScopeEntity::getFeeDetailId, pkList);
                    feeDetailScopeService.remove(deleteWrapper);
                }

                List<FeeDetailEntity> relatedDetailList = feeDetailEntity.getRelatedDetailList();
                if(CollectionUtils.isNotEmpty(relatedDetailList)){
                    for(FeeDetailEntity detailEntity:  relatedDetailList){
                        Long id = IdWorker.getId();
                        detailEntity.setFeeId(feeDetailEntity.getFeeId());
                        detailEntity.setId(id);
                        detailEntity.setParentId(feeDetailEntity.getId());
                        detailEntity.setInnerCode(innerCodeMap.get(feeDetailEntity.getId()) + "|" + id);
                        detailEntity.setNormalChildFlag(false);
                        detailEntity.setSelfScopeFlag(false);
                        detailEntity.setFeeDetailScopeList(feeDetailEntity.getFeeDetailScopeList());
                        setScopList(detailEntity, feeDetailEntity.getId());
                    }
                    feeDetailService.saveOrUpdateBatch(relatedDetailList);
                }
            }
        }
        return CommonResponse.success("保存或修改单据成功！", queryDetail(entity.getId(), true));
    }

    private void setScopList(FeeDetailEntity feeDetailEntity, Long parentDetailId){
        //保存新业务范围
        List<FeeDetailScopeEntity> feeDetailScopeList = feeDetailEntity.getFeeDetailScopeList();
        if(CollectionUtils.isNotEmpty(feeDetailScopeList)){
            //业务范围数据查询;由于参照只能返回明细业务范围的主键，此处根据主键查询业务范围明细及业务范围
            for(FeeDetailScopeEntity feeDetailScopeEntity : feeDetailScopeList){
                feeDetailScopeEntity.setId(null);//明细范围主键
                feeDetailScopeEntity.setFeeId(feeDetailEntity.getFeeId());//费用模板主键
                feeDetailScopeEntity.setFeeDetailId(feeDetailEntity.getId());//费用模板明细主键
                feeDetailScopeEntity.setParentFeeDetailId(parentDetailId);
                //业务范围明细表
                BusinessScopeDetailEntity businessScopeDetailEntity = businessScopeDetailService.getById(feeDetailScopeEntity.getBusinessScopeDetailId());
                feeDetailScopeEntity.setBillType(businessScopeDetailEntity.getBillType());//单据类型
                feeDetailScopeEntity.setBillCode(businessScopeDetailEntity.getBillCode());//单据编码
                feeDetailScopeEntity.setProperty(businessScopeDetailEntity.getProperty());//属性
                feeDetailScopeEntity.setPropertyValue(businessScopeDetailEntity.getPropertyValue());//属性值
                feeDetailScopeEntity.setMemo(businessScopeDetailEntity.getMemo());//备注
                feeDetailScopeEntity.setMemoValue(businessScopeDetailEntity.getMemoValue());//备注值
                feeDetailScopeEntity.setBusinessScopeId(businessScopeDetailEntity.getBusinessScopeId());//业务范围主表id
                //业务范围主表
                BusinessScopeEntity businessScopeEntity = businessScopeService.getById(businessScopeDetailEntity.getBusinessScopeId());
                feeDetailScopeEntity.setBusinessScopeName(businessScopeEntity.getName());//业务范围名称
                feeDetailScopeEntity.setBusinessScopeCode(businessScopeEntity.getCode());//业务范围编码
            }
            feeDetailScopeService.saveOrUpdateBatch(feeDetailEntity.getFeeDetailScopeList());
        }
    }

    private Long getContextOrgId(){
        UserContext userContextCache = sessionManager.getUserContext();
        return StringUtils.isNotBlank(userContextCache.getAuthOrgIds()) ? Long.valueOf(userContextCache.getAuthOrgIds().split(",")[0]) : userContextCache.getOrgId();
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode) {
        for (Map<String, Object> ypd : list) {
            // 生成内码
            if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatCode((List) ypd.get("children"),
                         ypd.get("innerCode").toString());
                ypd.put("children", child);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<FeeDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, FeeDetailEntity.class));
        }
    }

    @Override
    public CommonResponse<FeeVO> copySave(FeeVO feeVO) {
        //查询主表s
        FeeVO feecopyVO = this.queryDetail(feeVO.getCopyId(),false);
        feecopyVO.setId(null);
        feecopyVO.setName(feecopyVO.getName()+"（副本）");
        feecopyVO.setCreateTime(new Date());
        feecopyVO.setCreateUserCode(feeVO.getCreateUserCode());
        feecopyVO.setEmployeeId(feeVO.getEmployeeId());
        feecopyVO.setEmployeeName(feeVO.getEmployeeName());
        feecopyVO.setBillState(0);
        //清除明细主键
        for(FeeDetailVO feeDetailVO:feecopyVO.getFeeDetailList()){
            feeDetailVO.setFeeId(null);
            //tpid 上级id   shadowld 自身id
            feeDetailVO.setTpid(feeDetailVO.getParentId()+"_");
            feeDetailVO.setShadowId(feeDetailVO.getId()+"_");
            feeDetailVO.setTid(null);
            feeDetailVO.setId(null);
        }
        return this.saveOrUpdate(feecopyVO);
    }


    @Override
    public FeeVO queryDetail(Long id,boolean hasChildren) {
        FeeEntity entity = selectById(id);
        //遍历费用明细,查询费用明细业务范围
        List<FeeDetailEntity> feeDetailEntityList = entity.getFeeDetailList();
        List<FeeDetailEntity> normalFeeDetailList = new ArrayList<>();
        List<FeeDetailEntity> unNormalFeeDetailList = new ArrayList<>();
        List<Long> categoryList = new ArrayList<>();
        for (FeeDetailEntity feeDetailEntity : feeDetailEntityList) {
            feeDetailEntity.setTid(feeDetailEntity.getId().toString());
            feeDetailEntity.setTpid(feeDetailEntity.getParentId()!= null&&feeDetailEntity.getParentId()>0?feeDetailEntity.getParentId().toString():"");
            if(!feeDetailEntity.getSelfScopeFlag()){
                feeDetailEntity.setFeeDetailScopeList(new ArrayList<>());
            }else{
                List<FeeDetailScopeEntity> feeDetailScopeEntityList = feeDetailScopeService.findByFeeDetailId(feeDetailEntity.getId());
                if (CollectionUtils.isNotEmpty(feeDetailScopeEntityList)) {
                    for(FeeDetailScopeEntity scopeEntity : feeDetailScopeEntityList){
                        scopeEntity.setId(scopeEntity.getBusinessScopeDetailId());
                    }
                }
                feeDetailEntity.setFeeDetailScopeList(feeDetailScopeEntityList);
            }
            if(DocTypeEnum.物料档案.getCode().equals(feeDetailEntity.getDocType()) && feeDetailEntity.getLeafFlag()){
                categoryList.add(feeDetailEntity.getCategoryId());
            }
            if(null != feeDetailEntity.getNormalChildFlag() && false == feeDetailEntity.getNormalChildFlag()){
                unNormalFeeDetailList.add(feeDetailEntity);
            }else{
                normalFeeDetailList.add(feeDetailEntity);
            }
        }

        if(CollectionUtils.isNotEmpty(unNormalFeeDetailList)){
            Map<Long, List<FeeDetailEntity>> map = new HashMap<>();
            for(FeeDetailEntity feeDetailEntity: unNormalFeeDetailList){
                List<FeeDetailEntity> list = null;
                if(!map.containsKey(feeDetailEntity.getParentId())){
                    list = new ArrayList<>();
                }else{
                    list = map.get(feeDetailEntity.getParentId());
                }
                list.add(feeDetailEntity);
                map.put(feeDetailEntity.getParentId(), list);
            }
            for(FeeDetailEntity feeDetailEntity : normalFeeDetailList){
                if(feeDetailEntity.getSelfRelatedFlag() && map.containsKey(feeDetailEntity.getId())){
                    List<FeeDetailEntity> feeDetailEntities = map.get(feeDetailEntity.getId());
                    feeDetailEntity.setRelatedDetailList(feeDetailEntities);
                    for(FeeDetailEntity feeDetail : feeDetailEntities){
                        feeDetail.setId(feeDetail.getCategoryId());
                    }
                    feeDetailEntity.setRelatedList(feeDetailEntities);
                }
            }
        }
        //实现排序
        Collections.sort(normalFeeDetailList, new FeeDetailCompareVO());
        entity.setFeeDetailList(normalFeeDetailList);

        CommonResponse<List<MaterialCategoryVO>> listCommonResponse = shareMaterialApi.queryCategoryListByIds(categoryList);
        Map<Long, MaterialCategoryVO> map = new HashMap<>();
        if(listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())){
            map = listCommonResponse.getData().stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
        }

        FeeVO vo = BeanMapper.map(entity, FeeVO.class);
        for (FeeDetailVO detailVO : vo.getFeeDetailList()) {
            if(DocTypeEnum.物料档案.getCode().equals(detailVO.getDocType()) && detailVO.getLeafFlag() && null != detailVO.getCategoryId()){
                MaterialCategoryVO categoryVO = map.get(detailVO.getCategoryId());
                if(null != categoryVO){
                    detailVO.setUnitId(categoryVO.getUnitId());
                    detailVO.setUnitName(categoryVO.getUnitName());
                }
            }
        }
        if(hasChildren){
            vo.setFeeDetailList(TreeNodeBUtil.buildTree(vo.getFeeDetailList()));
        }
        return vo;
    }

    // 实现 Comparator 接口，并实现该接口的 compare 方法的类
    class FeeDetailCompareVO implements Comparator<FeeDetailEntity> {
        @Override
        public int compare(FeeDetailEntity o1, FeeDetailEntity o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }
}
