package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.mapper.DutyDetailItemMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 目标责任成本明细项
 *
 * @author generator
 *
 */
@Service("dutyDetailItemService")
public class DutyDetailItemServiceImpl extends BaseServiceImpl<DutyDetailItemMapper, DutyDetailItemEntity> implements IDutyDetailItemService{

    @Override
    public List<DutyDetailItemEntity> findByDutyDetailId(Long dutyDetailId) {
        LambdaQueryWrapper<DutyDetailItemEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyDetailItemEntity::getDutyDetailId, dutyDetailId);
        return list(queryWrapper);
    }

    @Override
    public void deleteByDutyDetailId(Long dutyDetailId) {
        if (null == dutyDetailId) {
            return;
        }
        LambdaUpdateWrapper<DutyDetailItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(DutyDetailItemEntity::getDutyDetailId, dutyDetailId);
        remove(updateWrapper);
    }

    @Override
    public List<DutyDetailItemEntity> dutyItemMerge(List<DutyDetailItemEntity> dutyDetailItemEntityList) {
        if(CollectionUtils.isNotEmpty(dutyDetailItemEntityList)){
            Map<Long,List<DutyDetailItemEntity>> dutyItemMapList =dutyDetailItemEntityList.stream().collect(
                    Collectors.groupingBy(
                            s->s.getDocId()
                    ));
            List<DutyDetailItemEntity> detailItemEntitieList = new ArrayList<>();
            dutyItemMapList.forEach((docId,dutyItemList)->{
                DutyDetailItemEntity dutyDetailItemEntity = new DutyDetailItemEntity();
                dutyDetailItemEntity.setDutyId(dutyItemList.stream().findFirst().get().getDutyId());
                dutyDetailItemEntity.setDutyDetailId(dutyItemList.stream().findFirst().get().getDutyDetailId());
                dutyDetailItemEntity.setOrgId(dutyItemList.stream().findFirst().get().getOrgId());
                dutyDetailItemEntity.setOrgName(dutyItemList.stream().findFirst().get().getOrgName());
                dutyDetailItemEntity.setProjectId(dutyItemList.stream().findFirst().get().getProjectId());
                dutyDetailItemEntity.setProjectName(dutyItemList.stream().findFirst().get().getProjectName());
                dutyDetailItemEntity.setCode(dutyItemList.stream().findFirst().get().getCode());
                dutyDetailItemEntity.setName(dutyItemList.stream().findFirst().get().getName());
                dutyDetailItemEntity.setPriceType(dutyItemList.stream().findFirst().get().getPriceType());
                dutyDetailItemEntity.setJobContent(dutyItemList.stream().findFirst().get().getJobContent());
                dutyDetailItemEntity.setUnitId(dutyItemList.stream().findFirst().get().getUnitId());
                dutyDetailItemEntity.setUnitName(dutyItemList.stream().findFirst().get().getUnitName());
                dutyDetailItemEntity.setMemo(dutyItemList.stream().findFirst().get().getMemo());
                dutyDetailItemEntity.setModel(dutyItemList.stream().findFirst().get().getModel());
                dutyDetailItemEntity.setCategoryId(dutyItemList.stream().findFirst().get().getCategoryId());
                dutyDetailItemEntity.setCategoryInnerCode(dutyItemList.stream().findFirst().get().getCategoryInnerCode());
                dutyDetailItemEntity.setCategoryName(dutyItemList.stream().findFirst().get().getCategoryName());
                dutyDetailItemEntity.setDocType(dutyItemList.stream().findFirst().get().getDocType());
                dutyDetailItemEntity.setDutyId(dutyItemList.stream().findFirst().get().getDutyId());
                dutyDetailItemEntity.setFeeDetailId(dutyItemList.stream().findFirst().get().getFeeDetailId());
                dutyDetailItemEntity.setFeeDetailCode(dutyItemList.stream().findFirst().get().getFeeDetailCode());
                dutyDetailItemEntity.setFeeDetailName(dutyItemList.stream().findFirst().get().getFeeDetailName());
                dutyDetailItemEntity.setChangeFlag(dutyItemList.stream().findFirst().get().getChangeFlag());
                dutyDetailItemEntity.setHistoricalPrice(dutyItemList.stream().findFirst().get().getHistoricalPrice());
                dutyDetailItemEntity.setId(IdWorker.getId());
                getSum(dutyItemList, dutyDetailItemEntity);
                detailItemEntitieList.add(dutyDetailItemEntity);
            });
            return detailItemEntitieList;
        }
        return dutyDetailItemEntityList;
    }
    private void getSum(List<DutyDetailItemEntity> dutyDetailItemEntityList, DutyDetailItemEntity dutyDetailItemEntity) {

        BigDecimal mny = dutyDetailItemEntityList.stream().filter(s->s.getMny()!=null).map(DutyDetailItemEntity::getMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxMny = dutyDetailItemEntityList.stream().filter(s->s.getTaxMny()!=null).map(DutyDetailItemEntity::getTaxMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amount = dutyDetailItemEntityList.stream().filter(s->s.getAmount()!=null).map(DutyDetailItemEntity::getAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        dutyDetailItemEntity.setAmount(amount);
        dutyDetailItemEntity.setPrice(ComputeUtil.safeDiv(mny,amount));
        dutyDetailItemEntity.setTaxPrice(ComputeUtil.safeDiv(taxMny,amount));
        dutyDetailItemEntity.setMny(mny);
        dutyDetailItemEntity.setTaxMny(taxMny);
        dutyDetailItemEntity.setTaxRate(ComputeUtil.safeMultiply( ComputeUtil.safeDiv(ComputeUtil.safeSub(taxMny,mny),mny),new BigDecimal("100")));

        //变更前
        BigDecimal beforeMny = dutyDetailItemEntityList.stream().filter(s->s.getBeforeMny()!=null).map(DutyDetailItemEntity::getBeforeMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal beforeTaxMny = dutyDetailItemEntityList.stream().filter(s->s.getBeforeTaxMny()!=null).map(DutyDetailItemEntity::getBeforeTaxMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal beforeAmount = dutyDetailItemEntityList.stream().filter(s->s.getBeforeAmount()!=null).map(DutyDetailItemEntity::getBeforeAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        dutyDetailItemEntity.setBeforeAmount(beforeAmount);
        dutyDetailItemEntity.setBeforePrice(ComputeUtil.safeDiv(beforeMny,beforeAmount));
        dutyDetailItemEntity.setBeforeTaxPrice(ComputeUtil.safeDiv(beforeTaxMny,beforeAmount));
        dutyDetailItemEntity.setBeforeMny(beforeMny);
        dutyDetailItemEntity.setBeforeTaxMny(beforeTaxMny);
        dutyDetailItemEntity.setBeforeTaxRate(ComputeUtil.safeMultiply( ComputeUtil.safeDiv(ComputeUtil.safeSub(beforeTaxMny,beforeMny),beforeMny),new BigDecimal("100")));
    }

}
