/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.mapper.DutyDetailItemMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="dutyDetailItemService")
public class DutyDetailItemServiceImpl
extends BaseServiceImpl<DutyDetailItemMapper, DutyDetailItemEntity>
implements IDutyDetailItemService {
    @Override
    public List<DutyDetailItemEntity> findByDutyDetailId(Long dutyDetailId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyDetailItemEntity::getDutyDetailId, (Object)dutyDetailId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByDutyDetailId(Long dutyDetailId) {
        if (null == dutyDetailId) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(DutyDetailItemEntity::getDutyDetailId, (Object)dutyDetailId);
        this.remove((Wrapper)updateWrapper);
    }

    @Override
    public List<DutyDetailItemEntity> dutyItemMerge(List<DutyDetailItemEntity> dutyDetailItemEntityList) {
        if (CollectionUtils.isNotEmpty(dutyDetailItemEntityList)) {
            Map<Long, List<DutyDetailItemEntity>> dutyItemMapList = dutyDetailItemEntityList.stream().collect(Collectors.groupingBy(s -> s.getDocId()));
            ArrayList<DutyDetailItemEntity> detailItemEntitieList = new ArrayList<DutyDetailItemEntity>();
            dutyItemMapList.forEach((docId, dutyItemList) -> {
                DutyDetailItemEntity dutyDetailItemEntity = new DutyDetailItemEntity();
                dutyDetailItemEntity.setDutyId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getDutyId());
                dutyDetailItemEntity.setDutyDetailId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getDutyDetailId());
                dutyDetailItemEntity.setOrgId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getOrgId());
                dutyDetailItemEntity.setOrgName(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getOrgName());
                dutyDetailItemEntity.setProjectId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getProjectId());
                dutyDetailItemEntity.setProjectName(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getProjectName());
                dutyDetailItemEntity.setCode(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getCode());
                dutyDetailItemEntity.setName(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getName());
                dutyDetailItemEntity.setPriceType(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getPriceType());
                dutyDetailItemEntity.setJobContent(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getJobContent());
                dutyDetailItemEntity.setUnitId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getUnitId());
                dutyDetailItemEntity.setUnitName(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getUnitName());
                dutyDetailItemEntity.setMemo(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getMemo());
                dutyDetailItemEntity.setModel(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getModel());
                dutyDetailItemEntity.setCategoryId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getCategoryId());
                dutyDetailItemEntity.setCategoryInnerCode(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getCategoryInnerCode());
                dutyDetailItemEntity.setCategoryName(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getCategoryName());
                dutyDetailItemEntity.setDocType(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getDocType());
                dutyDetailItemEntity.setDutyId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getDutyId());
                dutyDetailItemEntity.setFeeDetailId(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getFeeDetailId());
                dutyDetailItemEntity.setFeeDetailCode(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getFeeDetailCode());
                dutyDetailItemEntity.setFeeDetailName(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getFeeDetailName());
                dutyDetailItemEntity.setChangeFlag(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getChangeFlag());
                dutyDetailItemEntity.setHistoricalPrice(((DutyDetailItemEntity)((Object)((Object)dutyItemList.stream().findFirst().get()))).getHistoricalPrice());
                dutyDetailItemEntity.setId(IdWorker.getId());
                this.getSum((List<DutyDetailItemEntity>)dutyItemList, dutyDetailItemEntity);
                detailItemEntitieList.add(dutyDetailItemEntity);
            });
            return detailItemEntitieList;
        }
        return dutyDetailItemEntityList;
    }

    private void getSum(List<DutyDetailItemEntity> dutyDetailItemEntityList, DutyDetailItemEntity dutyDetailItemEntity) {
        BigDecimal mny = dutyDetailItemEntityList.stream().filter(s -> s.getMny() != null).map(DutyDetailItemEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxMny = dutyDetailItemEntityList.stream().filter(s -> s.getTaxMny() != null).map(DutyDetailItemEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amount = dutyDetailItemEntityList.stream().filter(s -> s.getAmount() != null).map(DutyDetailItemEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        dutyDetailItemEntity.setAmount(amount);
        dutyDetailItemEntity.setPrice(ComputeUtil.safeDiv((BigDecimal)mny, (BigDecimal)amount));
        dutyDetailItemEntity.setTaxPrice(ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)amount));
        dutyDetailItemEntity.setMny(mny);
        dutyDetailItemEntity.setTaxMny(taxMny);
        dutyDetailItemEntity.setTaxRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)taxMny, (BigDecimal)mny), (BigDecimal)mny), (BigDecimal)new BigDecimal("100")));
        BigDecimal beforeMny = dutyDetailItemEntityList.stream().filter(s -> s.getBeforeMny() != null).map(DutyDetailItemEntity::getBeforeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal beforeTaxMny = dutyDetailItemEntityList.stream().filter(s -> s.getBeforeTaxMny() != null).map(DutyDetailItemEntity::getBeforeTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal beforeAmount = dutyDetailItemEntityList.stream().filter(s -> s.getBeforeAmount() != null).map(DutyDetailItemEntity::getBeforeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        dutyDetailItemEntity.setBeforeAmount(beforeAmount);
        dutyDetailItemEntity.setBeforePrice(ComputeUtil.safeDiv((BigDecimal)beforeMny, (BigDecimal)beforeAmount));
        dutyDetailItemEntity.setBeforeTaxPrice(ComputeUtil.safeDiv((BigDecimal)beforeTaxMny, (BigDecimal)beforeAmount));
        dutyDetailItemEntity.setBeforeMny(beforeMny);
        dutyDetailItemEntity.setBeforeTaxMny(beforeTaxMny);
        dutyDetailItemEntity.setBeforeTaxRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)beforeTaxMny, (BigDecimal)beforeMny), (BigDecimal)beforeMny), (BigDecimal)new BigDecimal("100")));
    }
}

