/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.FeeEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.bean.RuleReceiverEntity;
import com.ejianc.business.targetcost.mapper.RuleMapper;
import com.ejianc.business.targetcost.service.IFeeService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.business.targetcost.vo.RuleDetailVO;
import com.ejianc.business.targetcost.vo.RuleFeeDetailVO;
import com.ejianc.business.targetcost.vo.RuleVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ruleService")
public class RuleServiceImpl
extends BaseServiceImpl<RuleMapper, RuleEntity>
implements IRuleService {
    private static final String BILL_CODE = "TC_RULE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IFeeService feeService;
    @Autowired
    private IRuleDetailService ruleDetailService;
    @Autowired
    private IRuleReceiverService ruleReceiverService;

    @Override
    public RuleVO insertOrUpdate(RuleVO ruleVO) {
        CommonResponse commonResponse;
        RuleEntity entity = (RuleEntity)((Object)BeanMapper.map((Object)((Object)ruleVO), RuleEntity.class));
        entity.setEnabled(true);
        FeeEntity feeEntity = (FeeEntity)((Object)this.feeService.selectById(ruleVO.getFeeId()));
        entity.setFeeCode(feeEntity.getBillCode());
        entity.setFeeName(feeEntity.getName());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)ruleVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != entity.getOrgId()) {
            commonResponse = this.orgApi.getOneById(entity.getOrgId());
            entity.setOrgName(commonResponse.isSuccess() ? ((OrgVO)commonResponse.getData()).getName() : null);
            entity.setParentOrgId(commonResponse.isSuccess() ? (((OrgVO)commonResponse.getData()).getParentId() == null ? entity.getOrgId() : ((OrgVO)commonResponse.getData()).getParentId()) : null);
        }
        if (null != entity.getEmployeeId()) {
            commonResponse = this.employeeApi.getById(entity.getEmployeeId());
            entity.setEmployeeName(commonResponse.isSuccess() ? ((EmployeeVO)commonResponse.getData()).getName() : null);
        }
        this.saveOrUpdate((Object)entity, false);
        for (RuleDetailEntity detailEntity : entity.getRuleDetailList()) {
            List<RuleReceiverEntity> receiverList = detailEntity.getMessageReceiver();
            if (!CollectionUtils.isNotEmpty(receiverList)) continue;
            for (RuleReceiverEntity receiverEntity : receiverList) {
                receiverEntity.setId(null);
                receiverEntity.setRuleId(entity.getId());
                receiverEntity.setRuleDetailId(detailEntity.getId());
            }
            LambdaQueryWrapper deleteQuery = new LambdaQueryWrapper();
            deleteQuery.eq(RuleReceiverEntity::getRuleDetailId, (Object)detailEntity.getId());
            this.ruleReceiverService.remove((Wrapper)deleteQuery);
            this.ruleReceiverService.saveOrUpdateBatch(receiverList);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public RuleVO queryDetail(Long id) {
        RuleEntity entity = (RuleEntity)((Object)this.selectById(id));
        List<RuleDetailEntity> ruleDetailList = entity.getRuleDetailList();
        Set feeDetailSet = null;
        if (CollectionUtils.isNotEmpty(ruleDetailList)) {
            feeDetailSet = ruleDetailList.stream().map(RuleDetailEntity::getFeeDetailId).collect(Collectors.toSet());
        }
        RuleVO ruleVO = (RuleVO)((Object)BeanMapper.map((Object)((Object)entity), RuleVO.class));
        FeeVO feeVO = this.feeService.queryDetail(entity.getFeeId(), false);
        if (null == feeVO) {
            throw new BusinessException("\u67e5\u8be2\u8d39\u7528\u6a21\u677f\u5931\u8d25");
        }
        List ruleFeeDetailVOS = BeanMapper.mapList(feeVO.getFeeDetailList(), RuleFeeDetailVO.class);
        if (CollectionUtils.isNotEmpty(feeDetailSet)) {
            Iterator iterator = ruleFeeDetailVOS.iterator();
            while (iterator.hasNext()) {
                RuleFeeDetailVO ruleFeeDetailVO;
                ruleFeeDetailVO.setSetFlag(feeDetailSet.contains((ruleFeeDetailVO = (RuleFeeDetailVO)iterator.next()).getId()));
            }
        }
        ruleVO.setFeeDetailList(TreeNodeBUtil.buildTree(ruleFeeDetailVOS));
        return ruleVO;
    }

    @Override
    public RuleVO tempSaveOrUpdate(RuleVO ruleVO) {
        if (null != ruleVO.getId()) {
            ArrayList<RuleDetailVO> insertList = new ArrayList<RuleDetailVO>();
            ArrayList<Long> deleteList = new ArrayList<Long>();
            for (RuleDetailVO ruleDetailVO : ruleVO.getRuleDetailList()) {
                ruleDetailVO.setRuleId(ruleVO.getId());
                if ("del".equals(ruleDetailVO.getRowState())) {
                    deleteList.add(ruleDetailVO.getId());
                    continue;
                }
                insertList.add(ruleDetailVO);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                List detailEntities = BeanMapper.mapList(insertList, RuleDetailEntity.class);
                this.ruleDetailService.saveOrUpdateBatch(detailEntities);
                for (RuleDetailEntity detailEntity : detailEntities) {
                    List<RuleReceiverEntity> receiverList = detailEntity.getMessageReceiver();
                    if (!CollectionUtils.isNotEmpty(receiverList)) continue;
                    for (RuleReceiverEntity receiverEntity : receiverList) {
                        receiverEntity.setId(null);
                        receiverEntity.setRuleId(ruleVO.getId());
                        receiverEntity.setRuleDetailId(detailEntity.getId());
                    }
                    LambdaQueryWrapper deleteQuery = new LambdaQueryWrapper();
                    deleteQuery.eq(RuleReceiverEntity::getRuleDetailId, (Object)detailEntity.getId());
                    this.ruleReceiverService.remove((Wrapper)deleteQuery);
                    this.ruleReceiverService.saveOrUpdateBatch(receiverList);
                }
            }
            if (CollectionUtils.isNotEmpty(deleteList)) {
                this.ruleDetailService.removeByIds(deleteList);
            }
        } else {
            return this.insertOrUpdate(ruleVO);
        }
        return this.queryDetail(ruleVO.getId());
    }

    @Override
    public String updateEnable(Long id, Boolean enabled) {
        RuleEntity ruleEntity = (RuleEntity)((Object)this.selectById(id));
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(ruleEntity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(ruleEntity.getBillState())) {
            throw new BusinessException("\u975e\u5ba1\u6279\u901a\u8fc7\u6216\u5df2\u63d0\u4ea4\u7684\u6570\u636e\u4e0d\u80fd\u542f\u7528\u505c\u7528");
        }
        ruleEntity.setEnabled(enabled);
        this.saveOrUpdate((Object)ruleEntity);
        return "\u66f4\u6539\u542f\u7528\u72b6\u6001\u6210\u529f";
    }

    @Override
    public RuleVO copySave(RuleVO ruleVO) {
        CommonResponse commonResponse;
        RuleEntity entity = (RuleEntity)((Object)this.selectById(ruleVO.getCopyId()));
        entity.setId(null);
        entity.setEnabled(true);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        entity.setVersion(null);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setName(ruleVO.getName());
        entity.setDepartmentId(ruleVO.getDepartmentId());
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)ruleVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setBillCode((String)billCode.getData());
        if (null != ruleVO.getOrgId()) {
            commonResponse = this.orgApi.getOneById(ruleVO.getOrgId());
            entity.setOrgName(commonResponse.isSuccess() ? ((OrgVO)commonResponse.getData()).getName() : null);
            entity.setParentOrgId(commonResponse.isSuccess() ? (((OrgVO)commonResponse.getData()).getParentId() == null ? entity.getOrgId() : ((OrgVO)commonResponse.getData()).getParentId()) : null);
        }
        if (null != ruleVO.getEmployeeId()) {
            commonResponse = this.employeeApi.getById(ruleVO.getEmployeeId());
            entity.setEmployeeName(commonResponse.isSuccess() ? ((EmployeeVO)commonResponse.getData()).getName() : null);
        }
        for (RuleDetailEntity detailEntity : entity.getRuleDetailList()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(RuleReceiverEntity::getRuleDetailId, (Object)detailEntity.getId());
            detailEntity.setMessageReceiver(this.ruleReceiverService.list((Wrapper)queryWrapper));
            detailEntity.setId(null);
            detailEntity.setRuleId(null);
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setVersion(null);
        }
        this.saveOrUpdate((Object)entity, false);
        for (RuleDetailEntity detailEntity : entity.getRuleDetailList()) {
            List<RuleReceiverEntity> receiverList = detailEntity.getMessageReceiver();
            if (!CollectionUtils.isNotEmpty(receiverList)) continue;
            for (RuleReceiverEntity receiverEntity : receiverList) {
                receiverEntity.setId(null);
                receiverEntity.setCreateTime(null);
                receiverEntity.setCreateUserCode(null);
                receiverEntity.setUpdateUserCode(null);
                receiverEntity.setUpdateTime(null);
                receiverEntity.setVersion(null);
                receiverEntity.setRuleId(entity.getId());
                receiverEntity.setRuleDetailId(detailEntity.getId());
            }
            this.ruleReceiverService.saveOrUpdateBatch(receiverList);
        }
        return this.queryDetail(entity.getId());
    }
}

