/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.targetcost.service.IAssessDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.vo.AssessDetailVO;
import com.ejianc.business.targetcost.vo.DutyWarnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dutyWarn/"})
public class DutyWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyService service;
    @Autowired
    private IAssessDetailService assessDetailService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    static String PC_URL = "/ejc-targetcost-frontend/#/duty";

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Integer day = 15;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<AssessDetailVO> assessDetailVOS = this.service.queryWarnList();
            if (!ListUtil.isNotEmpty(assessDetailVOS)) continue;
            for (AssessDetailVO assessDetailVO : assessDetailVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getBigDecimal("parameterValue").intValue();
                    if ("\u9ad8".equals(set.getString("warningLevel")) && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L <= (long)day.intValue() && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L >= 0L) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L <= (long)day.intValue() && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L >= 0L) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L > (long)day.intValue() || (assessDetailVO.getAssessTime().getTime() - now.getTime()) / 86400000L < 0L) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getProjectName());
                vo.setPcTitle("\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                vo.setPcUrl(PC_URL + assessDetailVO.getParentId());
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getOrgName());
                vo.setSourceId(assessDetailVO.getParentId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName()).replaceAll("#assessName#", assessDetailVO.getAssessName()).replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName()).replaceAll("#assessName#", assessDetailVO.getAssessName()).replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName()).replaceAll("#assessName#", assessDetailVO.getAssessName()).replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime())));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @PostMapping(value={"noDutyExecute"})
    public CommonResponse<String> noDutyExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<DutyWarnVO> dutyWarnVOS = this.service.queryProjectList();
            if (!ListUtil.isNotEmpty(dutyWarnVOS)) continue;
            for (DutyWarnVO assessDetailVO : dutyWarnVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    low = true;
                    useSetLow = set;
                    meddle = true;
                    useSetMeddle = set;
                    high = true;
                    useSetHigh = set;
                    if (!(assessDetailVO.getProjectType() != null && assessDetailVO.getProjectType().equals(1506581476628926466L) || assessDetailVO.getContractValuationType() != null && assessDetailVO.getContractValuationType().equals(1269824218831179778L))) {
                        if (assessDetailVO.getPlanDateNum() != null && assessDetailVO.getPlanDateNum() >= 365 || assessDetailVO.getBaseTaxMoney() == null && assessDetailVO.getBaseTaxMoney().compareTo(new BigDecimal("10000*1000*5")) >= 0) {
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 90L) {
                                low = true;
                                useSetLow = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 120L) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 150L) continue;
                            high = true;
                            useSetHigh = set;
                            continue;
                        }
                        if (assessDetailVO.getPlanDateNum() != null && assessDetailVO.getPlanDateNum() >= 180 || assessDetailVO.getBaseTaxMoney() == null && assessDetailVO.getBaseTaxMoney().compareTo(new BigDecimal("10000*1000*2")) >= 0) {
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 60L) {
                                low = true;
                                useSetLow = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 90L) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                            if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 120L) continue;
                            high = true;
                            useSetHigh = set;
                            continue;
                        }
                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 30L) {
                            low = true;
                            useSetLow = set;
                        }
                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 60L) {
                            meddle = true;
                            useSetMeddle = set;
                        }
                        if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 90L) continue;
                        high = true;
                        useSetHigh = set;
                        continue;
                    }
                    if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 90L) {
                        low = true;
                        useSetLow = set;
                    }
                    if (assessDetailVO.getChangeStatusDate() != null && (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L > 120L) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (assessDetailVO.getChangeStatusDate() == null || (now.getTime() - assessDetailVO.getChangeStatusDate().getTime()) / 86400000L <= 150L) continue;
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getName());
                vo.setPcTitle("\u76ee\u6807\u8d23\u4efb\u6210\u672c\u672a\u7f16\u5236");
                vo.setPcUrl(PC_URL);
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getName());
                vo.setSourceId(assessDetailVO.getId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }
}

